/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.samples.signature;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.security.Key;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.samples.SampleUtils;
import org.apache.xml.security.samples.utils.resolver.OfflineResolver;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.utils.IgnoreAllErrorHandler;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class VerifySignature {
    public static void main(String[] stringArray) {
        boolean bl = false;
        String string = "signature.xml";
        if (bl) {
            System.out.println("We do schema-validation");
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        if (bl) {
            documentBuilderFactory.setAttribute("http://apache.org/xml/features/validation/schema", Boolean.TRUE);
            documentBuilderFactory.setAttribute("http://apache.org/xml/features/dom/defer-node-expansion", Boolean.TRUE);
            documentBuilderFactory.setValidating(true);
            documentBuilderFactory.setAttribute("http://xml.org/sax/features/validation", Boolean.TRUE);
        }
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setAttribute("http://xml.org/sax/features/namespaces", Boolean.TRUE);
        if (bl) {
            documentBuilderFactory.setAttribute("http://apache.org/xml/properties/schema/external-schemaLocation", "http://www.w3.org/2000/09/xmldsig# data/xmldsig-core-schema.xsd");
        }
        try {
            File file = new File(string);
            System.out.println("Try to verify " + file.toURL().toString());
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setErrorHandler((ErrorHandler)new IgnoreAllErrorHandler());
            if (bl) {
                documentBuilder.setEntityResolver(new EntityResolver(){

                    public InputSource resolveEntity(String string, String string2) throws SAXException {
                        if (string2.endsWith("xmldsig-core-schema.xsd")) {
                            try {
                                return new InputSource(new FileInputStream("data/xmldsig-core-schema.xsd"));
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                throw new SAXException(fileNotFoundException);
                            }
                        }
                        return null;
                    }
                });
            }
            Document document = documentBuilder.parse(new FileInputStream(file));
            Element element = SampleUtils.createDSctx(document, "ds", "http://www.w3.org/2000/09/xmldsig#");
            Element element2 = (Element)XPathAPI.selectSingleNode((Node)document, (String)"//ds:Signature[1]", (Node)element);
            XMLSignature xMLSignature = new XMLSignature(element2, file.toURL().toString());
            xMLSignature.addResourceResolver((ResourceResolverSpi)new OfflineResolver());
            KeyInfo keyInfo = xMLSignature.getKeyInfo();
            if (keyInfo != null) {
                X509Certificate x509Certificate;
                if (keyInfo.containsX509Data()) {
                    System.out.println("Could find a X509Data element in the KeyInfo");
                }
                if ((x509Certificate = xMLSignature.getKeyInfo().getX509Certificate()) != null) {
                    System.out.println("The XML signature in file " + file.toURL().toString() + " is " + (xMLSignature.checkSignatureValue(x509Certificate) ? "valid (good)" : "invalid !!!!! (bad)"));
                } else {
                    System.out.println("Did not find a Certificate");
                    PublicKey publicKey = xMLSignature.getKeyInfo().getPublicKey();
                    if (publicKey != null) {
                        System.out.println("The XML signature in file " + file.toURL().toString() + " is " + (xMLSignature.checkSignatureValue((Key)publicKey) ? "valid (good)" : "invalid !!!!! (bad)"));
                    } else {
                        System.out.println("Did not find a public key, so I can't check the signature");
                    }
                }
            } else {
                System.out.println("Did not find a KeyInfo");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        Init.init();
    }
}

