# -*-python-*-
# GemRB - Infinity Engine Emulator
# Copyright (C) 2003 The GemRB Project
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
#


# GUIMG.py - scripts to control mage spells windows from GUIMG winpack

###################################################

import GemRB
import GUICommon
import CommonTables
import GUICommonWindows
from GUIDefines import *
from ie_stats import *

MageWindow = None
MageSpellInfoWindow = None
MageSpellLevel = 0
MageSpellUnmemorizeWindow = None

def InitMageWindow (Window):
	global MageWindow
	MageWindow = Window

	Button = Window.GetControl (0)
	Button.SetEvent (IE_GUI_BUTTON_ON_PRESS, MagePrevLevelPress)

	Button = Window.GetControl (1)
	Button.SetEvent (IE_GUI_BUTTON_ON_PRESS, MageNextLevelPress)

	# Setup memorized spells buttons
	for i in range (12):
		Icon = Window.GetControl (2 + i)
		color = {'r' : 0, 'g' : 0, 'b' :0, 'a' : 160}
		Icon.SetBorder (0, color,  0, 1)
		Icon.SetVarAssoc ("SpellButton", i)

	for i in range (20):
		Icon = Window.GetControl (14 + i)
		Icon.SetVarAssoc ("SpellButton", 100 + i)
	return

def UpdateMageWindow (Window=None):
	global MageMemorizedSpellList, MageKnownSpellList

	if Window == None:
		Window = MageWindow

	MageMemorizedSpellList = []
	MageKnownSpellList = []

	pc = GemRB.GameGetSelectedPCSingle ()
	spelltype = IE_SPELL_TYPE_WIZARD
	level = MageSpellLevel
	max_mem_cnt = GemRB.GetMemorizableSpellsCount (pc, spelltype, level)
	
#	CantCast = CommonTables.ClassSkills.GetValue (GUICommon.GetClassRowName (pc), "MAGESPELL") == "*"
#	GUICommon.AdjustWindowVisibility (Window, pc, CantCast)

	Name = GemRB.GetPlayerName (pc, 1)
	Label = Window.GetControl (0x10000027)
	Label.SetText (Name)

	Label = Window.GetControl (0x10000026)
	GemRB.SetToken ('LEVEL', str (level + 1))
	Label.SetText (19672)
	mem_cnt = GemRB.GetMemorizedSpellsCount (pc, spelltype, level, False)
	for i in range (12):
		Icon = Window.GetControl (2 + i)
		if i < mem_cnt:
			ms = GemRB.GetMemorizedSpell (pc, spelltype, level, i)
			Icon.SetSpellIcon (ms['SpellResRef'])
			Icon.SetFlags (IE_GUI_BUTTON_NO_IMAGE, OP_NAND)
			if ms['Flags']:
				Icon.SetEvent (IE_GUI_BUTTON_ON_PRESS, OpenMageSpellUnmemorizeWindow)
			else:
				Icon.SetEvent (IE_GUI_BUTTON_ON_PRESS, OnMageUnmemorizeSpell)
			Icon.SetEvent (IE_GUI_BUTTON_ON_RIGHT_PRESS, OpenMageSpellInfoWindow)
			spell = GemRB.GetSpell (ms['SpellResRef'])
			Icon.SetTooltip (spell['SpellName'])
			MageMemorizedSpellList.append (ms['SpellResRef'])
			Icon.EnableBorder (0, ms['Flags'] == 0)
		else:
			if i < max_mem_cnt:
				Icon.SetFlags (IE_GUI_BUTTON_NO_IMAGE, OP_NAND)
				Icon.SetSprites ("IVSLOT", 0,  0, 0, 0, 0)
			else:
				Icon.SetFlags (IE_GUI_BUTTON_NO_IMAGE, OP_OR)
			Icon.SetEvent (IE_GUI_BUTTON_ON_PRESS, None)
			Icon.SetEvent (IE_GUI_BUTTON_ON_RIGHT_PRESS, None)
			Icon.SetTooltip ('')
			Icon.EnableBorder (0, 0)

	#--------------------------test-----------------------------#
	print("max_mem_cnt is: ", max_mem_cnt)
	print("mem_cnt is:     ", mem_cnt)
	known_cnt = GemRB.GetKnownSpellsCount (pc, spelltype, level)
	btncount = 20
	i = 0
	for i in range (known_cnt):
		Icon = Window.GetControl (14 + i)
		ks = GemRB.GetKnownSpell (pc, spelltype, level, i)
		Icon.SetSpellIcon (ks['SpellResRef'])
		Icon.SetFlags (IE_GUI_BUTTON_NO_IMAGE, OP_NAND)
		Icon.SetEvent (IE_GUI_BUTTON_ON_PRESS, OnMageMemorizeSpell)
		Icon.SetEvent (IE_GUI_BUTTON_ON_RIGHT_PRESS, OpenMageSpellInfoWindow)
		spell = GemRB.GetSpell (ks['SpellResRef'])
		Icon.SetTooltip (spell['SpellName'])
		MageKnownSpellList.append (ks['SpellResRef'])

	if known_cnt == 0: i = -1
	for i in range (i + 1, btncount):
		Icon = Window.GetControl (14 + i)
		Icon.SetFlags (IE_GUI_BUTTON_NO_IMAGE, OP_OR)
		Icon.SetEvent (IE_GUI_BUTTON_ON_PRESS, None)
		Icon.SetEvent (IE_GUI_BUTTON_ON_RIGHT_PRESS, None)
		Icon.SetTooltip ('')
		

ToggleSpellWindow = GUICommonWindows.CreateTopWinLoader(3, "GUIMG", GUICommonWindows.ToggleWindow, InitMageWindow, UpdateMageWindow, WINDOW_TOP|WINDOW_HCENTER)
OpenSpellWindow = GUICommonWindows.CreateTopWinLoader(3, "GUIMG", GUICommonWindows.OpenWindowOnce, InitMageWindow, UpdateMageWindow, WINDOW_TOP|WINDOW_HCENTER)

def MagePrevLevelPress ():
	global MageSpellLevel

	if MageSpellLevel > 0:
		MageSpellLevel = MageSpellLevel - 1
		UpdateMageWindow ()


def MageNextLevelPress ():
	global MageSpellLevel

	if MageSpellLevel < 8:
		MageSpellLevel = MageSpellLevel + 1
		UpdateMageWindow ()

def OpenMageSpellInfoWindow ():
	global MageSpellInfoWindow

	if MageSpellInfoWindow != None:
		if MageSpellInfoWindow:
			MageSpellInfoWindow.Unload ()
		MageSpellInfoWindow = None

		return

	MageSpellInfoWindow = Window = GemRB.LoadWindow (4)

	Button = Window.GetControl (4)
	Button.SetText (1403)
	Button.SetEvent (IE_GUI_BUTTON_ON_PRESS, OpenMageSpellInfoWindow)

	index = GemRB.GetVar ("SpellButton")
	if index < 100:
		ResRef = MageMemorizedSpellList[index]
	else:
		ResRef = MageKnownSpellList[index - 100]

	spell = GemRB.GetSpell (ResRef)

	Label = Window.GetControl (0x0fffffff)
	Label.SetText (spell['SpellName'])
	Label.SetFlags(IE_GUI_LABEL_USE_COLOR, OP_OR)

	Icon = Window.GetControl (1)
	Icon.SetSpellIcon (ResRef)

	Text = Window.GetControl (2)
	Text.SetText (spell['SpellDesc'])

	IconResRef = 'SPL' + spell['SpellbookIcon'][2:]

	Icon = Window.GetControl (5)
	Icon.SetSprites (IconResRef, 0, 0, 0, 0, 0)

	Window.ShowModal (MODAL_SHADOW_GRAY)


def OnMageMemorizeSpell ():
	pc = GemRB.GameGetSelectedPCSingle ()
	level = MageSpellLevel
	spelltype = IE_SPELL_TYPE_WIZARD

	index = GemRB.GetVar ("SpellButton") - 100

	if GemRB.MemorizeSpell (pc, spelltype, level, index):
		UpdateMageWindow ()

	# FIXME: use FLASH.bam


def OpenMageSpellUnmemorizeWindow (btn, val):
	global MageSpellUnmemorizeWindow

	if MageSpellUnmemorizeWindow != None:
		MageSpellUnmemorizeWindow.Unload ()
		MageSpellUnmemorizeWindow = None
		return

	MageSpellUnmemorizeWindow = Window = GemRB.LoadWindow (6)

	# "Are you sure you want to ....?"
	TextArea = Window.GetControl (2)
	TextArea.SetText (50450)

	# Remove
	Button = Window.GetControl (0)
	Button.SetText (42514)
	Button.SetEvent (IE_GUI_BUTTON_ON_PRESS, OnMageUnmemorizeSpell)
	Button.MakeDefault()

	Button = Window.GetControl (1)
	Button.SetText (4196)
	Button.SetEvent (IE_GUI_BUTTON_ON_PRESS, lambda: OpenMageSpellUnmemorizeWindow(btn, val))
	Button.MakeEscape()

	Window.ShowModal (MODAL_SHADOW_GRAY)


def OnMageUnmemorizeSpell (btn, index):
	if MageSpellUnmemorizeWindow:
		OpenMageSpellUnmemorizeWindow (btn, index)

	index = GemRB.GetVar ("SpellButton")
	pc = GemRB.GameGetSelectedPCSingle ()
	level = MageSpellLevel
	spelltype = IE_SPELL_TYPE_WIZARD

	if GemRB.UnmemorizeSpell (pc, spelltype, level, index):
		UpdateMageWindow ()

###################################################
# End of file GUIMG.py
