/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.collections;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NestedHashMap {
    public final Map data = new HashMap();

    public Object get(Object ... keys) {
        Map map = this.data;
        int nestedMaps = keys.length - 1;
        for (int iii = 0; iii < nestedMaps; ++iii) {
            if ((map = (Map)map.get(keys[iii])) != null) continue;
            return null;
        }
        return map.get(keys[nestedMaps]);
    }

    public synchronized void put(Object value, Object ... keys) {
        this.put(value, false, keys);
    }

    public synchronized Object put(Object value, boolean keepOldBindingIfPresent, Object ... keys) {
        Map map = this.data;
        int keysLength = keys.length;
        for (int iii = 0; iii < keysLength; ++iii) {
            if (iii == keysLength - 1) {
                if (keepOldBindingIfPresent && map.containsKey(keys[iii])) {
                    return map.get(keys[iii]);
                }
                map.put(keys[iii], value);
                return value;
            }
            HashMap tmp = (HashMap)map.get(keys[iii]);
            if (tmp == null) {
                tmp = new HashMap();
                map.put(keys[iii], tmp);
            }
            map = tmp;
        }
        return value;
    }

    public List<Object> getAllValues() {
        ArrayList<Object> result = new ArrayList<Object>();
        this.fillAllValues(this.data, result);
        return result;
    }

    private void fillAllValues(Map map, List<Object> result) {
        for (Object value : map.values()) {
            if (value == null) continue;
            if (value instanceof Map) {
                this.fillAllValues((Map)value, result);
                continue;
            }
            result.add(value);
        }
    }

    public List<Leaf> getAllLeaves() {
        ArrayList<Leaf> result = new ArrayList<Leaf>();
        ArrayList<Object> path = new ArrayList<Object>();
        this.fillAllLeaves(this.data, path, result);
        return result;
    }

    private void fillAllLeaves(Map map, List<Object> path, List<Leaf> result) {
        for (Object key : map.keySet()) {
            Object value = map.get(key);
            if (value == null) continue;
            ArrayList<Object> newPath = new ArrayList<Object>(path);
            newPath.add(key);
            if (value instanceof Map) {
                this.fillAllLeaves((Map)value, newPath, result);
                continue;
            }
            result.add(new Leaf(newPath, value));
        }
    }

    public static class Leaf {
        public final List<Object> keys;
        public final Object value;

        public Leaf(List<Object> keys, Object value) {
            this.keys = keys;
            this.value = value;
        }
    }
}

