/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.Jpeg2000Module;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BinaryFilterBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHeader;
import edu.harvard.hul.ois.jhove.module.jpeg2000.CrossRefBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Iterator;

public class BoxHolder
implements Iterator {
    protected Jpeg2000Module _module;
    protected JP2Box _parentBox;
    protected RandomAccessFile _raf;
    protected DataInputStream _dstrm;
    protected BoxHeader _boxHeader;
    protected RepInfo _repInfo;
    protected long bytesLeft;
    protected long filePos;
    protected boolean hasBoxes = false;
    private BinaryFilterBox binaryFilterBox;

    public BoxHolder(RandomAccessFile randomAccessFile) {
        this._raf = randomAccessFile;
        this.binaryFilterBox = null;
        try {
            this.filePos = randomAccessFile.getFilePointer();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected long getFilePos() {
        return this.filePos;
    }

    @Override
    public boolean hasNext() {
        return this.hasBoxes && this.bytesLeft >= 8L;
    }

    public Object next() {
        if (!this.hasBoxes) {
            return null;
        }
        try {
            JP2Box jP2Box;
            if (this.binaryFilterBox != null) {
                if (this.binaryFilterBox.hasNext()) {
                    jP2Box = (JP2Box)this.binaryFilterBox.next();
                } else {
                    this.binaryFilterBox = null;
                }
            }
            if (this.bytesLeft < 8L) {
                return null;
            }
            BoxHeader boxHeader = new BoxHeader(this._module, this._dstrm);
            boxHeader.readHeader();
            this.bytesLeft -= boxHeader.getLength();
            String string = boxHeader.getType();
            if ("bfil".equals(string)) {
                this.binaryFilterBox = new BinaryFilterBox(this._raf, this instanceof JP2Box ? (JP2Box)this : null);
                if (this.binaryFilterBox.hasNext()) {
                    return this.binaryFilterBox.next();
                }
                boxHeader.readHeader();
                string = boxHeader.getType();
            }
            if ("cref".equals(string)) {
                CrossRefBox crossRefBox = new CrossRefBox(this._raf, this instanceof JP2Box ? (JP2Box)this : null);
                if (!crossRefBox.readBox()) {
                    return null;
                }
                BoxHeader boxHeader2 = new BoxHeader(this._module, crossRefBox.getCrossRefStream());
                boxHeader2.readHeader();
                jP2Box = JP2Box.boxMaker(boxHeader2.getType(), this instanceof JP2Box ? (JP2Box)this : null);
                return jP2Box;
            }
            jP2Box = JP2Box.boxMaker(string, this);
            jP2Box.setModule(this._module);
            jP2Box.setRepInfo(this._repInfo);
            jP2Box.setRandomAccessFile(this._raf);
            jP2Box.setDataInputStream(this._dstrm);
            jP2Box.setBoxHeader(boxHeader);
            return jP2Box;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    protected void superboxOverrun() {
        this._repInfo.setMessage((Message)new ErrorMessage("Size of contained Box overruns " + this.getSelfPropName(), this._module.getFilePos()));
        this._repInfo.setWellFormed(false);
    }

    protected void superboxUnderrun() {
        this._repInfo.setMessage((Message)new ErrorMessage("Size of contained Boxes underruns " + this.getSelfPropName(), this._module.getFilePos()));
        this._repInfo.setWellFormed(false);
    }

    protected String getSelfPropName() {
        return "";
    }
}

