/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.wave;

import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.WaveModule;
import edu.harvard.hul.ois.jhove.module.iff.Chunk;
import edu.harvard.hul.ois.jhove.module.iff.ChunkHeader;
import edu.harvard.hul.ois.jhove.module.wave.WaveStrings;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;

public class MpegChunk
extends Chunk {
    public MpegChunk(ModuleBase moduleBase, ChunkHeader chunkHeader, DataInputStream dataInputStream) {
        super(moduleBase, chunkHeader, dataInputStream);
    }

    @Override
    public boolean readChunk(RepInfo repInfo) throws IOException {
        WaveModule waveModule = (WaveModule)this._module;
        int n = waveModule.readUnsignedShort(this._dstream);
        int n2 = waveModule.readUnsignedShort(this._dstream);
        int n3 = waveModule.readUnsignedShort(this._dstream);
        int n4 = waveModule.readUnsignedShort(this._dstream);
        waveModule.skipBytes(this._dstream, 4, waveModule);
        ArrayList<Property> arrayList = new ArrayList<Property>();
        arrayList.add(waveModule.buildBitmaskProperty(n, "SoundInformation", WaveStrings.SOUND_INFORMATION_1, WaveStrings.SOUND_INFORMATION_0));
        arrayList.add(new Property("FrameSize", PropertyType.INTEGER, (Object)new Integer(n2)));
        arrayList.add(new Property("AncillaryDataLength", PropertyType.INTEGER, (Object)new Integer(n3)));
        arrayList.add(waveModule.buildBitmaskProperty(n4, "AncillaryDataDef", WaveStrings.ANCILLARY_DEF_1, WaveStrings.ANCILLARY_DEF_0));
        waveModule.addWaveProperty(new Property("MPEG", PropertyType.PROPERTY, PropertyArity.LIST, arrayList));
        return true;
    }
}

