/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote.internal.ui.properties;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.common.util.IOSGIServiceAccess;
import com.nvidia.common.util.SWTUtil;
import com.nvidia.cuda.ide.debug.core.Activator;
import com.nvidia.cuda.ide.remote.connection.IRemoteConnection;
import com.nvidia.cuda.ide.remote.connection.IRemoteConnectionsService;
import com.nvidia.cuda.ide.remote.internal.ui.properties.RemoteTarget;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.statushandlers.StatusManager;

public class RemoteTargetEntry
extends Composite {
    private static final String REASONABLE_REMOTE_PROJECT_PATH = "/home/someusername/projects/cuda/aproject";
    protected Composite body;
    private final Button browseProjectLocation;
    protected DataBindingContext context;
    private final Composite header;
    private final Text location;
    private IObservableValue locationObservable;
    protected RemoteTarget remoteTarget;
    private final WritableValue status = new WritableValue(null, IStatus.class);
    protected final WritableValue target = new WritableValue(null, RemoteTarget.class);
    private final CLabel title;
    private Font titleFont;

    protected static void handle(CoreException e) {
        StatusManager.getManager().handle(e.getStatus(), 3);
    }

    public RemoteTargetEntry(Composite parent, int style) {
        super(parent, style | 0x800 | 0x10);
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.setLayout((Layout)gridLayout);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                RemoteTargetEntry.this.performDispose();
            }
        });
        this.header = new Composite((Composite)this, 0);
        this.header.setBackground(Display.getCurrent().getSystemColor(15));
        GridLayout gl_composite_1 = new GridLayout(2, false);
        gl_composite_1.marginWidth = 0;
        gl_composite_1.marginHeight = 0;
        this.header.setLayout((Layout)gl_composite_1);
        this.header.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.title = new CLabel(this.header, 0);
        this.title.setForeground(Display.getCurrent().getSystemColor(2));
        this.title.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.title.setFont(this.getTitleFont());
        this.title.setBackground(Display.getCurrent().getSystemColor(15));
        ToolBar toolBar = new ToolBar(this.header, 0x820000);
        toolBar.setBackground(Display.getCurrent().getSystemColor(15));
        ToolItem delete = new ToolItem(toolBar, 0);
        delete.setImage(SWTUtil.getImage((String)"IMG_ETOOL_DELETE"));
        delete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (RemoteTargetEntry.this.target.getValue() != null) {
                    RemoteTargetEntry.this.remoteTarget.remove();
                }
            }
        });
        this.body = new Composite((Composite)this, 0);
        this.body.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.body.setLayout((Layout)new GridLayout(3, false));
        Label lblLocation = new Label(this.body, 0);
        lblLocation.setText("Project Path:");
        this.location = new Text(this.body, 2048);
        this.browseProjectLocation = new Button(this.body, 0);
        this.browseProjectLocation.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.browseProjectLocation.setText("Browse...");
        this.browseProjectLocation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemoteTargetEntry.this.browse();
            }
        });
        this.setupBindings();
    }

    protected void browse() {
        if (this.target.getValue() != null) {
            try {
                try {
                    this.browseProjectLocation.setEnabled(false);
                    String path = (String)CoreUtil.accessService(IRemoteConnectionsService.class, (IOSGIServiceAccess)new IOSGIServiceAccess<IRemoteConnectionsService, String>(){

                        public String runWithService(IRemoteConnectionsService service) throws CoreException {
                            return RemoteTargetEntry.this.browseConnection(service);
                        }
                    });
                    if (path != null) {
                        this.remoteTarget.setProjectLocation(path);
                    }
                    this.refresh();
                }
                catch (CoreException e) {
                    RemoteTargetEntry.handle(e);
                    this.browseProjectLocation.setEnabled(true);
                }
            }
            finally {
                this.browseProjectLocation.setEnabled(true);
            }
        }
    }

    private String browseConnection(final IRemoteConnectionsService service) throws CoreException {
        MessageDialog.openInformation((Shell)this.body.getShell(), (String)"Project Path", (String)"It's recommended to choose empty folder on target for project path");
        String p = this.remoteTarget.getProjectLocation();
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
        final IRemoteConnection[] connections = new IRemoteConnection[1];
        try {
            dialog.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    connections[0] = RemoteTargetEntry.this.getConnection(service, connections, monitor);
                }
            });
        }
        catch (InvocationTargetException e) {
            throw (CoreException)((Object)CoreUtil.exceptionCast((Throwable)e.getTargetException()));
        }
        catch (InterruptedException e) {
            Activator.log((Throwable)e);
        }
        if (connections[0] != null) {
            return connections[0].browse(this.getShell(), "Select project path", p);
        }
        return null;
    }

    private IRemoteConnection getConnection(IRemoteConnectionsService service, IRemoteConnection[] connections, IProgressMonitor monitor) throws InvocationTargetException {
        IProgressMonitor m = monitor == null ? new NullProgressMonitor() : monitor;
        m.beginTask("Connecting to the remote system", -1);
        IRemoteConnection connection = service.getConnection(this.remoteTarget.getName(), (IProgressMonitor)new NullProgressMonitor());
        try {
            if (connection != null) {
                connection.connect(IRemoteConnection.Service.Files, (IProgressMonitor)new NullProgressMonitor());
                IRemoteConnection iRemoteConnection = connection;
                return iRemoteConnection;
            }
            return null;
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
        finally {
            m.done();
        }
    }

    public final IObservableValue getStatus() {
        return this.status;
    }

    private Font getTitleFont() {
        Object[] fontData;
        Font f;
        if (this.titleFont == null && (f = this.title.getFont()) != null && !CoreUtil.isNullOrEmpty((Object[])(fontData = f.getFontData()))) {
            Object data = fontData[0];
            FontData newData = new FontData(data.getName(), data.getHeight(), data.getStyle() | 1);
            this.titleFont = new Font((Device)Display.getCurrent(), newData);
        }
        return this.titleFont;
    }

    public final void highlight() {
        final Display current = Display.getCurrent();
        SWTUtil.setBackground((Control)this.header, (int)26);
        this.title.setForeground(current.getSystemColor(27));
        current.timerExec(200, new Runnable(){

            @Override
            public void run() {
                SWTUtil.setBackground((Control)RemoteTargetEntry.this.header, (int)15);
                RemoteTargetEntry.this.title.setForeground(current.getSystemColor(2));
            }
        });
    }

    protected final void performDispose() {
        if (this.titleFont != null) {
            this.titleFont.dispose();
            this.titleFont = null;
        }
    }

    protected void refresh() {
    }

    public boolean setFocus() {
        return this.location.setFocus();
    }

    public void setTarget(RemoteTarget target) {
        this.remoteTarget = target;
        if (target != null) {
            this.title.setText(target.getName());
        } else {
            this.title.setText("");
        }
        SWTUtil.setEnabled((Control)this, (target != null ? 1 : 0) != 0);
        boolean isLocal = target != null && target.isLocal();
        int width = SWTUtil.getTextExtent((Drawable)this, (String)REASONABLE_REMOTE_PROJECT_PATH).x;
        if (isLocal) {
            width = 13 * width / 10;
        }
        this.target.setValue((Object)target);
        GridData locationLD = new GridData(4, 0x1000000, true, false, isLocal ? 2 : 1, 1);
        locationLD.widthHint = width;
        this.location.setLayoutData((Object)locationLD);
        this.location.setEnabled(!isLocal);
        SWTUtil.setVisible((Control)this.browseProjectLocation, (!isLocal ? 1 : 0) != 0);
    }

    private void setTitleValidationStatus(IStatus s) {
        if (!this.title.isDisposed()) {
            this.title.setImage(SWTUtil.getImage((IStatus)s));
            String message = s == null || s.getSeverity() == 0 ? "" : s.getMessage();
            this.title.setToolTipText(message);
        }
    }

    private void setupBindings() {
        this.context = new DataBindingContext();
        this.locationObservable = BeansObservables.observeDetailValue((IObservableValue)this.target, (String)"projectLocation", String.class);
        this.context.bindValue((IObservableValue)SWTObservables.observeText((Control)this.location, (int)24), this.locationObservable);
        this.context.bindValue(this.getStatus(), (IObservableValue)new ComputedValue(IStatus.class){

            protected Object calculate() {
                RemoteTarget rt = (RemoteTarget)RemoteTargetEntry.this.target.getValue();
                IStatus s = rt != null ? RemoteTargetEntry.this.validateTargetSettings(rt) : CoreUtil.OK_STATUS;
                RemoteTargetEntry.this.setTitleValidationStatus(s);
                return s;
            }
        });
    }

    protected IStatus validateTargetSettings(RemoteTarget value) {
        if (CoreUtil.isNullOrEmpty((String)((String)this.locationObservable.getValue()))) {
            return CoreUtil.errorStatus((String)"Project path for connection %s is not specified", (Object[])new Object[]{this.remoteTarget.getName()});
        }
        return CoreUtil.OK_STATUS;
    }
}

