/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.internal.ui.dialogs.SystemCopyProfileDialog;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.actions.SystemBaseDialogAction;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class SystemProfileNameCopyAction
extends SystemBaseDialogAction
implements IRunnableWithProgress {
    private ISystemProfile profile;
    private ISystemProfile newProfile;
    private ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
    private String oldName;
    private String newName;
    private boolean makeActive;
    private Exception runException = null;

    public SystemProfileNameCopyAction(Shell shell) {
        super(SystemResources.ACTION_PROFILE_COPY_LABEL, SystemResources.ACTION_PROFILE_COPY_TOOLTIP, PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY"), shell);
        this.setSelectionSensitive(true);
        this.allowOnMultipleSelection(false);
        this.setHelp("org.eclipse.rse.ui.actndupr");
    }

    public void setProfile(ISystemProfile profile) {
        this.profile = profile;
    }

    protected Dialog createDialog(Shell parent) {
        return new SystemCopyProfileDialog(parent, this.profile);
    }

    protected Object getDialogValue(Dialog dlg) {
        this.newName = null;
        SystemCopyProfileDialog rnmDlg = (SystemCopyProfileDialog)dlg;
        if (!rnmDlg.wasCancelled()) {
            this.oldName = this.profile.getName();
            this.newName = rnmDlg.getNewName();
            this.makeActive = rnmDlg.getMakeActive();
            IRunnableContext runnableContext = this.getRunnableContext();
            try {
                runnableContext.run(false, false, (IRunnableWithProgress)this);
                if (this.makeActive && this.newProfile != null) {
                    this.sr.setSystemProfileActive(this.newProfile, true);
                }
            }
            catch (InvocationTargetException exc) {
                this.showOperationMessage(exc, this.getShell());
            }
            catch (Exception exc) {
                this.showOperationMessage(exc, this.getShell());
            }
        }
        return this.newName;
    }

    protected IRunnableContext getRunnableContext() {
        IRunnableContext irc = RSEUIPlugin.getTheSystemRegistryUI().getRunnableContext();
        if (irc == null) {
            irc = new ProgressMonitorDialog(this.getShell());
        }
        return irc;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        String msg = SystemProfileNameCopyAction.getCopyingMessage(this.oldName, this.newName);
        this.runException = null;
        try {
            int steps = 0;
            IHost[] conns = this.sr.getHostsByProfile(this.profile);
            if (conns != null && conns.length > 0) {
                steps = conns.length;
            }
            monitor.beginTask(msg, steps += 2);
            this.newProfile = this.sr.copySystemProfile(this.profile, this.newName, this.makeActive, monitor);
            monitor.done();
        }
        catch (InterruptedException exc) {
            monitor.done();
            this.runException = exc;
            throw (InterruptedException)this.runException;
        }
        catch (Exception exc) {
            monitor.done();
            this.runException = new InvocationTargetException(exc);
            throw (InvocationTargetException)this.runException;
        }
    }

    public static String getCopyingMessage(String oldName, String newName) {
        SystemMessage msg = RSEUIPlugin.getPluginMessage("RSEG1072");
        msg.makeSubstitution((Object)oldName, (Object)newName);
        return msg.getLevelOneText();
    }

    protected void showOperationMessage(Exception exc, Shell shell) {
        if (exc instanceof InterruptedException) {
            this.showOperationCancelledMessage(shell);
        } else if (exc instanceof InvocationTargetException) {
            this.showOperationErrorMessage(shell, ((InvocationTargetException)exc).getTargetException());
        } else {
            this.showOperationErrorMessage(shell, exc);
        }
    }

    protected void showOperationErrorMessage(Shell shell, Throwable exc) {
        SystemMessageDialog msgDlg = new SystemMessageDialog(shell, RSEUIPlugin.getPluginMessage("RSEG1066").makeSubstitution((Object)exc.getMessage()));
        msgDlg.open();
        SystemBasePlugin.logError("Copy profile operation failed", exc);
    }

    protected void showOperationCancelledMessage(Shell shell) {
        SystemMessageDialog msgDlg = new SystemMessageDialog(shell, RSEUIPlugin.getPluginMessage("RSEG1067"));
        msgDlg.open();
    }
}

