/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.viper.ByteSizeFormatter;
import com.nvidia.viper.ViperColors;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.activity.CuptiActivityFlag;
import com.nvidia.viper.activity.CuptiActivityMemcpy;
import com.nvidia.viper.activity.CuptiActivityMemcpyKind;
import com.nvidia.viper.activity.CuptiActivityMemcpyP2p;
import com.nvidia.viper.activity.CuptiActivityMemoryKind;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.ProfileDataModel;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.TimelineColorMode;
import com.nvidia.viper.model.TimelineIntervalHierarchy;
import com.nvidia.viper.model.TimelineIntervalKind;
import com.nvidia.viper.value.ValueBandwidth;
import java.util.HashSet;
import java.util.Set;

public class TimelineIntervalMemcpy
extends TimelineIntervalHierarchy
implements IModel,
ITimelineInterval {
    protected CuptiActivityMemcpy activity;
    protected Set<Integer> correlationIds = new HashSet<Integer>();

    public TimelineIntervalMemcpy(TimelineIntervalKind kind, CuptiActivityMemcpy activity) {
        super(kind, activity.start, activity.end, activity.getID());
        if (activity != null) {
            this.correlationIds.add(activity.correlationId);
        }
        this.activity = activity;
        this.primaryTimeline = null;
    }

    @Override
    public String getName() {
        return "Memcpy " + this.activity.getCopyKind().getShortName() + " [" + (this.isAsync() ? "async" : "sync") + "]";
    }

    @Override
    public String getDisplayName() {
        return this.getName();
    }

    @Override
    public Set<Integer> getCorrelationIds() {
        return this.correlationIds;
    }

    @Override
    public int getPrimaryCorrelationId() {
        return this.activity.correlationId;
    }

    public String getStreamName() {
        return this.getStreamName(this.activity.streamId);
    }

    public int getRuntimeCorrelationId() {
        return this.activity.runtimeCorrelationId;
    }

    @Override
    public ViperColors.GradientColors getColor(ViperColors.GradientColors colors) {
        Session session = this.primaryTimeline.getSession();
        TimelineColorMode colorMode = session.getColorMode();
        if (colorMode.equals((Object)TimelineColorMode.STREAM)) {
            return session.streamIdToColorMap.get(this.activity.streamId);
        }
        if (colorMode.equals((Object)TimelineColorMode.PROCESS)) {
            if (session.processIdToColorMap.size() == 1) {
                return (ViperColors.GradientColors)session.processIdToColorMap.values().toArray()[0];
            }
            return session.processIdToColorMap.get(session.getProcessId(this));
        }
        return colors;
    }

    public long getBytes() {
        return this.activity.bytes;
    }

    public long getThroughput() {
        long bw = new ValueBandwidth(ByteSizeFormatter.Base.KILOBYTE, this.activity.bytes, this.getDuration()).getBandwidth();
        if (this.activity.getCopyKind().equals((Object)CuptiActivityMemcpyKind.CUPTI_ACTIVITY_MEMCPY_KIND_DTOD)) {
            return bw * 2L;
        }
        return bw;
    }

    public CuptiActivityMemcpyKind getCopyKind() {
        return this.activity.getCopyKind();
    }

    public CuptiActivityMemoryKind getSrcMemoryKind() {
        return this.activity.getSrcKind();
    }

    public CuptiActivityMemoryKind getDstMemoryKind() {
        return this.activity.getDstKind();
    }

    public boolean isAsync() {
        return CuptiActivityFlag.CUPTI_ACTIVITY_FLAG_MEMCPY_ASYNC.isSet(this.activity.flags);
    }

    public int getSourceDeviceId() {
        if (this.activity instanceof CuptiActivityMemcpyP2p) {
            CuptiActivityMemcpyP2p p2p = (CuptiActivityMemcpyP2p)this.activity;
            return p2p.srcDeviceId;
        }
        return -1;
    }

    public int getDestinationDeviceId() {
        if (this.activity instanceof CuptiActivityMemcpyP2p) {
            CuptiActivityMemcpyP2p p2p = (CuptiActivityMemcpyP2p)this.activity;
            return p2p.dstDeviceId;
        }
        return -1;
    }

    boolean isP2PMemcopy() {
        return this.activity instanceof CuptiActivityMemcpyP2p;
    }

    @Override
    public void appendToPDM(ProfileDataModel pdm) throws ViperException {
        try {
            this.activity.appendToPDM(pdm.getNativeHandle());
        }
        catch (Exception e) {
            if (e instanceof ViperException) {
                throw (ViperException)e;
            }
            throw new ViperException(e);
        }
    }
}

