/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import org.eclipse.core.runtime.content.IContentType;

public class CFileTypeAssociation {
    private String fSpec;
    private int fType;
    private IContentType fContentType;

    public CFileTypeAssociation(String spec, int type, IContentType contentType) {
        this.fSpec = spec;
        this.fType = type;
        this.fContentType = contentType;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fContentType == null ? 0 : this.fContentType.getId().hashCode());
        result = 31 * result + (this.fSpec == null ? 0 : this.fSpec.hashCode());
        result = 31 * result + this.fType;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CFileTypeAssociation other = (CFileTypeAssociation)obj;
        if (!this.fContentType.getId().equals(other.fContentType.getId())) {
            return false;
        }
        if (!this.fSpec.equals(other.fSpec)) {
            return false;
        }
        return this.fType == other.fType;
    }

    public boolean equalsIgnoreCaseOfSpec(CFileTypeAssociation other) {
        if (!this.fContentType.getId().equals(other.fContentType.getId())) {
            return false;
        }
        if (!this.fSpec.equalsIgnoreCase(other.fSpec)) {
            return false;
        }
        return this.fType == other.fType;
    }

    public IContentType getContentType() {
        return this.fContentType;
    }

    public String getSpec() {
        return this.fSpec;
    }

    public String getPattern() {
        String pattern = this.getSpec();
        if (this.isExtSpec()) {
            return "*." + pattern;
        }
        return pattern;
    }

    public boolean isFileSpec() {
        return (this.fType & 4) != 0;
    }

    public boolean isExtSpec() {
        return (this.fType & 8) != 0;
    }

    public boolean isPredefined() {
        return (this.fType & 2) != 0;
    }

    public boolean isUserDefined() {
        return (this.fType & 1) != 0;
    }

    public String getDescription() {
        return this.fContentType.getName();
    }

    public int getFileSpecType() {
        return this.fType & 0xC;
    }
}

