/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.language;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.cdt.core.language.ProjectLanguageConfiguration;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.internal.core.CContentTypes;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.language.LanguageMapping;
import org.eclipse.cdt.internal.core.language.LanguageMappingResolver;
import org.eclipse.cdt.internal.ui.language.LanguageMappingLinkListener;
import org.eclipse.cdt.internal.ui.language.LanguageVerifier;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.cdt.internal.ui.util.Messages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.PropertyPage;

public class FileLanguageMappingPropertyPage
extends PropertyPage {
    private static final int MINIMUM_COLUMN_WIDTH = 150;
    private static final int LANGUAGE_COLUMN = 1;
    private static final int CONFIGURATION_COLUMN = 0;
    private static final int LANGUAGE_ID = 0;
    private static final int LANGUAGE_NAME = 1;
    private static final String ALL_CONFIGURATIONS = "";
    private IContentType fContentType;
    private Composite fContents;
    private Table fTable;
    private ILanguage[] fLanguages = LanguageManager.getInstance().getRegisteredLanguages();
    private Map<String, ILanguage> fLanguageIds = LanguageVerifier.computeAvailableLanguages();
    private boolean fHasChanges;

    protected Control createContents(Composite parent) {
        IFile file = this.getFile();
        IProject project = file.getProject();
        this.fContentType = CContentTypes.getContentType((IProject)project, (String)file.getName());
        this.fContents = new Composite(parent, 0);
        this.fContents.setLayout((Layout)new GridLayout(2, false));
        Label contentTypeLabel = new Label(this.fContents, 0);
        contentTypeLabel.setText(PreferencesMessages.FileLanguagesPropertyPage_contentTypeLabel);
        contentTypeLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        Label contentTypeDescriptionLabel = new Label(this.fContents, 0);
        contentTypeDescriptionLabel.setText(this.fContentType.getName());
        contentTypeDescriptionLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        try {
            this.createMappingTable(this.fContents, file);
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
        }
        Link link = new Link(this.fContents, 0);
        link.setText(PreferencesMessages.FileLanguagesPropertyPage_description);
        link.addListener(13, (Listener)new LanguageMappingLinkListener(parent.getShell(), (IAdaptable)project){

            @Override
            protected void refresh() {
                try {
                    FileLanguageMappingPropertyPage.this.refreshMappings();
                }
                catch (CoreException e) {
                    CUIPlugin.log(e);
                }
            }
        });
        link.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.fContents.pack();
        return this.fContents;
    }

    private void createMappingTable(Composite contents, final IFile file) throws CoreException {
        Composite tableParent = new Composite(contents, 0);
        tableParent.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.fTable = new Table(tableParent, 68098);
        this.fTable.setHeaderVisible(true);
        this.fTable.setLinesVisible(true);
        this.fTable.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = PreferencesMessages.FileLanguagesPropertyPage_mappingTableTitle;
            }
        });
        this.fTable.setToolTipText(PreferencesMessages.FileLanguagesPropertyPage_mappingTableTitle);
        TableColumn contentTypeColumn = new TableColumn(this.fTable, 16384);
        contentTypeColumn.setText(PreferencesMessages.FileLanguagesPropertyPage_configurationColumn);
        TableColumn languageColumn = new TableColumn(this.fTable, 16384);
        languageColumn.setText(PreferencesMessages.ProjectLanguagesPropertyPage_languageColumn);
        TableColumnLayout layout = new TableColumnLayout();
        layout.setColumnData((Widget)contentTypeColumn, (ColumnLayoutData)new ColumnWeightData(1, 150, true));
        layout.setColumnData((Widget)languageColumn, (ColumnLayoutData)new ColumnWeightData(1, 150, true));
        tableParent.setLayout((Layout)layout);
        final TableEditor editor = new TableEditor(this.fTable);
        editor.grabHorizontal = true;
        editor.grabVertical = true;
        editor.setColumn(1);
        final IProject project = file.getProject();
        this.fTable.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TableItem item;
                Control oldEditor = editor.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }
                if ((item = (TableItem)event.item) == null) {
                    return;
                }
                LanguageTableData data = (LanguageTableData)item.getData();
                CCombo newEditor = new CCombo((Composite)FileLanguageMappingPropertyPage.this.fTable, 8);
                FileLanguageMappingPropertyPage.this.populateLanguages(project, file, data.configuration, data.languageId, newEditor);
                newEditor.addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        CCombo combo = (CCombo)editor.getEditor();
                        int index = combo.getSelectionIndex();
                        if (index != -1) {
                            TableItem item = editor.getItem();
                            item.setText(1, combo.getText());
                            String selectedLanguage = ((String[])combo.getData())[index];
                            LanguageTableData data = (LanguageTableData)item.getData();
                            data.languageId = selectedLanguage;
                            FileLanguageMappingPropertyPage.this.fHasChanges = true;
                            try {
                                FileLanguageMappingPropertyPage.this.refreshMappings();
                            }
                            catch (CoreException e) {
                                CUIPlugin.log(e);
                            }
                        }
                    }
                });
                newEditor.setFocus();
                editor.setEditor((Control)newEditor, item, 1);
            }
        });
        this.populateLanguageTable(this.fTable);
        this.refreshMappings();
    }

    private void populateLanguageTable(Table table) throws CoreException {
        IFile file = this.getFile();
        IProject project = file.getProject();
        ICProjectDescription description = CoreModel.getDefault().getProjectDescription(project);
        ICConfigurationDescription[] configurations = description.getConfigurations();
        TableItem defaultItem = new TableItem(table, 0);
        defaultItem.setText(0, PreferencesMessages.FileLanguagesPropertyPage_defaultMapping);
        ProjectLanguageConfiguration config = LanguageManager.getInstance().getLanguageConfiguration(project);
        Set<String> missingLanguages = LanguageVerifier.removeMissingLanguages(config, description, this.fLanguageIds);
        if (missingLanguages.size() > 0) {
            MessageBox messageBox = new MessageBox(this.getShell(), 40);
            messageBox.setText(PreferencesMessages.LanguageMappings_missingLanguageTitle);
            String affectedLanguages = LanguageVerifier.computeAffectedLanguages(missingLanguages);
            messageBox.setMessage(Messages.format(PreferencesMessages.FileLanguagesPropertyPage_missingLanguage, affectedLanguages));
            messageBox.open();
        }
        String defaultLanguageId = config.getLanguageForFile(null, file);
        LanguageTableData defaultData = new LanguageTableData(null, defaultLanguageId);
        defaultItem.setData((Object)defaultData);
        int i = 0;
        while (i < configurations.length) {
            TableItem item = new TableItem(table, 0);
            item.setText(0, configurations[i].getName());
            String languageId = config.getLanguageForFile(configurations[i], file);
            if (languageId != null) {
                ILanguage language = this.fLanguageIds.get(languageId);
                String languageName = language.getName();
                item.setText(1, languageName);
            }
            LanguageTableData data = new LanguageTableData(configurations[i], languageId);
            item.setData((Object)data);
            ++i;
        }
    }

    private void populateLanguages(IProject project, IFile file, ICConfigurationDescription configuration, String selectedLanguage, CCombo combo) {
        try {
            String[][] languageInfo = this.getLanguages(project, file, configuration);
            combo.setItems(languageInfo[1]);
            combo.setData((Object)languageInfo[0]);
            this.findSelection(configuration, selectedLanguage, combo);
            this.fContents.layout();
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
        }
    }

    private void refreshMappings() throws CoreException {
        IFile file = this.getFile();
        IProject project = file.getProject();
        LanguageManager manager = LanguageManager.getInstance();
        TableItem[] items = this.fTable.getItems();
        int i = 0;
        while (i < items.length) {
            TableItem item = items[i];
            LanguageTableData data = (LanguageTableData)item.getData();
            if (data.languageId == null) {
                LanguageMapping mapping = this.computeInheritedMapping(project, file, data.configuration);
                item.setText(1, this.computeInheritedFrom(data.configuration, mapping));
            } else {
                ILanguage language = manager.getLanguage(data.languageId);
                item.setText(1, language.getName());
            }
            ++i;
        }
    }

    private void findSelection(ICConfigurationDescription configuration, String languageId, CCombo combo) throws CoreException {
        if (languageId == null) {
            combo.select(0);
            return;
        }
        LanguageManager manager = LanguageManager.getInstance();
        ILanguage language = manager.getLanguage(languageId);
        String name = language.getName();
        int i = 1;
        while (i < combo.getItemCount()) {
            if (name.equals(combo.getItem(i))) {
                combo.select(i);
                return;
            }
            ++i;
        }
        combo.select(0);
    }

    public boolean performOk() {
        block5: {
            if (this.fHasChanges) break block5;
            return true;
        }
        try {
            IFile file = this.getFile();
            IProject project = file.getProject();
            LanguageManager manager = LanguageManager.getInstance();
            ProjectLanguageConfiguration config = manager.getLanguageConfiguration(project);
            TreeMap<String, String> mappings = new TreeMap<String, String>();
            TableItem[] items = this.fTable.getItems();
            int i = 0;
            while (i < items.length) {
                TableItem item = items[i];
                LanguageTableData data = (LanguageTableData)item.getData();
                if (data.languageId != null) {
                    String configurationId = data.configuration == null ? ALL_CONFIGURATIONS : data.configuration.getId();
                    mappings.put(configurationId, data.languageId);
                }
                ++i;
            }
            config.setFileMappings(file, mappings);
            manager.storeLanguageMappingConfiguration(file);
            this.fHasChanges = false;
            return true;
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
            return false;
        }
    }

    private IFile getFile() {
        return (IFile)this.getElement().getAdapter(IFile.class);
    }

    protected void performDefaults() {
        super.performDefaults();
    }

    private String computeInheritedFrom(ICConfigurationDescription configuration, LanguageMapping mapping) throws CoreException {
        ILanguage language;
        String inheritedFrom;
        LanguageTableData data = (LanguageTableData)this.fTable.getItem(0).getData();
        if (configuration != null && data.languageId != null) {
            inheritedFrom = PreferencesMessages.FileLanguagesPropertyPage_inheritedFromFile;
            language = LanguageManager.getInstance().getLanguage(data.languageId);
        } else {
            language = mapping.language;
            switch (mapping.inheritedFrom) {
                case 0: {
                    inheritedFrom = PreferencesMessages.FileLanguagesPropertyPage_inheritedFromSystem;
                    break;
                }
                case 2: {
                    inheritedFrom = PreferencesMessages.FileLanguagesPropertyPage_inheritedFromProject;
                    break;
                }
                case 1: {
                    inheritedFrom = PreferencesMessages.FileLanguagesPropertyPage_inheritedFromWorkspace;
                    break;
                }
                default: {
                    throw new CoreException(Util.createStatus((Throwable)new IllegalArgumentException()));
                }
            }
        }
        return Messages.format(inheritedFrom, language.getName());
    }

    private LanguageMapping computeInheritedMapping(IProject project, IFile file, ICConfigurationDescription configuration) throws CoreException {
        LanguageMapping[] mappings = LanguageMappingResolver.computeLanguage((IProject)project, (String)file.getProjectRelativePath().toPortableString(), (ICConfigurationDescription)configuration, (String)this.fContentType.getId(), (boolean)true);
        LanguageMapping inheritedMapping = mappings[0];
        if (inheritedMapping.inheritedFrom == 3) {
            inheritedMapping = mappings[1];
        }
        return inheritedMapping;
    }

    private String[][] getLanguages(IProject project, IFile file, ICConfigurationDescription configuration) throws CoreException {
        String[][] descriptions = new String[2][this.fLanguages.length + 1];
        LanguageMapping inheritedMapping = this.computeInheritedMapping(project, file, configuration);
        int index = 0;
        descriptions[0][index] = null;
        descriptions[1][index] = this.computeInheritedFrom(configuration, inheritedMapping);
        ++index;
        int i = 0;
        while (i < this.fLanguages.length) {
            descriptions[0][index] = this.fLanguages[i].getId();
            descriptions[1][index] = this.fLanguages[i].getName();
            ++index;
            ++i;
        }
        return descriptions;
    }

    private static class LanguageTableData {
        ICConfigurationDescription configuration;
        String languageId;

        LanguageTableData(ICConfigurationDescription configuration, String languageId) {
            this.configuration = configuration;
            this.languageId = languageId;
        }
    }
}

