/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core;

import java.util.StringTokenizer;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.GPPLanguage;
import org.eclipse.cdt.core.dom.parser.AbstractCLikeLanguage;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.Messages;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.cdt.internal.core.parser.scanner.ILexerLog;
import org.eclipse.cdt.internal.core.parser.scanner.Lexer;
import org.eclipse.cdt.internal.core.parser.scanner.Token;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class CConventions {
    private static final String scopeResolutionOperator = "::";
    private static final char fgDot = '.';
    private static final String ILLEGAL_FILE_CHARS = "/\\:<>?*|\"";

    public static boolean isLegalIdentifier(String name) {
        if (name == null) {
            return false;
        }
        if (name.indexOf(32) != -1) {
            return false;
        }
        int length = name.length();
        if (length == 0) {
            return false;
        }
        char c = name.charAt(0);
        if (!Character.isLetter(c) && c != '_') {
            return false;
        }
        int i = 1;
        while (i < length) {
            c = name.charAt(i);
            if (!Character.isLetterOrDigit(c) && c != '_') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static IStatus validateClassName(String name) {
        char[] scannedID;
        if (name == null) {
            return new Status(4, "org.eclipse.cdt.core", -1, Messages.convention_class_nullName, null);
        }
        String trimmed = name.trim();
        if (!name.equals(trimmed) || name.indexOf(" ") != -1) {
            return new Status(4, "org.eclipse.cdt.core", -1, Messages.convention_class_nameWithBlanks, null);
        }
        int index = name.lastIndexOf(scopeResolutionOperator);
        if (index == -1) {
            IStatus status = CConventions.validateIdentifier(name, GPPLanguage.getDefault());
            if (!status.isOK()) {
                return status;
            }
            scannedID = name.toCharArray();
        } else {
            String pkg = name.substring(0, index).trim();
            IStatus status = CConventions.validateScopeName(pkg);
            if (!status.isOK()) {
                return status;
            }
            String type = name.substring(index + scopeResolutionOperator.length()).trim();
            status = CConventions.validateIdentifier(type, GPPLanguage.getDefault());
            if (!status.isOK()) {
                return status;
            }
            scannedID = type.toCharArray();
        }
        if (scannedID != null) {
            if (CharOperation.contains('$', scannedID)) {
                return new Status(2, "org.eclipse.cdt.core", -1, Messages.convention_class_dollarName, null);
            }
            if (scannedID.length > 0 && scannedID[0] == '_') {
                return new Status(2, "org.eclipse.cdt.core", -1, Messages.convention_class_leadingUnderscore, null);
            }
            if (scannedID.length > 0 && Character.isLowerCase(scannedID[0])) {
                return new Status(2, "org.eclipse.cdt.core", -1, Messages.convention_class_lowercaseName, null);
            }
            return CModelStatus.VERIFIED_OK;
        }
        return new Status(4, "org.eclipse.cdt.core", -1, NLS.bind((String)Messages.convention_class_invalidName, (Object)name), null);
    }

    public static IStatus validateNamespaceName(String name) {
        char[] scannedID;
        if (name == null) {
            return new Status(4, "org.eclipse.cdt.core", -1, Messages.convention_namespace_nullName, null);
        }
        String trimmed = name.trim();
        if (!name.equals(trimmed) || name.indexOf(" ") != -1) {
            return new Status(4, "org.eclipse.cdt.core", -1, Messages.convention_namespace_nameWithBlanks, null);
        }
        int index = name.lastIndexOf(scopeResolutionOperator);
        if (index == -1) {
            IStatus status = CConventions.validateIdentifier(name, GPPLanguage.getDefault());
            if (!status.isOK()) {
                return status;
            }
            scannedID = name.toCharArray();
        } else {
            String pkg = name.substring(0, index).trim();
            IStatus status = CConventions.validateScopeName(pkg);
            if (!status.isOK()) {
                return status;
            }
            String type = name.substring(index + scopeResolutionOperator.length()).trim();
            status = CConventions.validateIdentifier(type, GPPLanguage.getDefault());
            if (!status.isOK()) {
                return status;
            }
            scannedID = type.toCharArray();
        }
        if (scannedID != null) {
            if (CharOperation.contains('$', scannedID)) {
                return new Status(2, "org.eclipse.cdt.core", -1, Messages.convention_namespace_dollarName, null);
            }
            if (scannedID.length > 0 && scannedID[0] == '_') {
                return new Status(2, "org.eclipse.cdt.core", -1, Messages.convention_namespace_leadingUnderscore, null);
            }
            return CModelStatus.VERIFIED_OK;
        }
        return new Status(4, "org.eclipse.cdt.core", -1, NLS.bind((String)Messages.convention_class_invalidName, (Object)name), null);
    }

    public static IStatus validateScopeName(String name) {
        if (name == null) {
            return new Status(4, "org.eclipse.cdt.core", -1, Messages.convention_scope_nullName, null);
        }
        int length = name.length();
        if (length == 0) {
            return new Status(4, "org.eclipse.cdt.core", -1, Messages.convention_scope_emptyName, null);
        }
        if (name.charAt(0) == '.' || name.charAt(length - 1) == '.') {
            return new Status(4, "org.eclipse.cdt.core", -1, Messages.convention_scope_dotName, null);
        }
        if (CharOperation.isWhitespace(name.charAt(0)) || CharOperation.isWhitespace(name.charAt(name.length() - 1))) {
            return new Status(4, "org.eclipse.cdt.core", -1, Messages.convention_scope_nameWithBlanks, null);
        }
        StringTokenizer st = new StringTokenizer(name, scopeResolutionOperator);
        boolean firstToken = true;
        while (st.hasMoreTokens()) {
            String typeName = st.nextToken();
            char[] scannedID = (typeName = typeName.trim()).toCharArray();
            if (scannedID == null) {
                return new Status(4, "org.eclipse.cdt.core", -1, NLS.bind((String)Messages.convention_illegalIdentifier, (Object)typeName), null);
            }
            if (firstToken && scannedID.length > 0 && scannedID[0] == '_') {
                return new Status(2, "org.eclipse.cdt.core", -1, Messages.convention_scope_leadingUnderscore, null);
            }
            if (firstToken && scannedID.length > 0 && Character.isLowerCase(scannedID[0])) {
                return new Status(2, "org.eclipse.cdt.core", -1, Messages.convention_scope_lowercaseName, null);
            }
            firstToken = false;
        }
        return CModelStatus.VERIFIED_OK;
    }

    public static IStatus validateFieldName(String name) {
        return CConventions.validateIdentifier(name, GPPLanguage.getDefault());
    }

    @Deprecated
    public static IStatus validateIdentifier(String id) {
        if (!CConventions.isLegalIdentifier(id)) {
            return new Status(4, "org.eclipse.cdt.core", -1, NLS.bind((String)Messages.convention_illegalIdentifier, (Object)id), null);
        }
        if (!CConventions.isValidIdentifier(id)) {
            return new Status(4, "org.eclipse.cdt.core", -1, NLS.bind((String)Messages.convention_invalid, (Object)id), null);
        }
        return CModelStatus.VERIFIED_OK;
    }

    public static IStatus validateIdentifier(String id, AbstractCLikeLanguage language) {
        if (!CConventions.isLegalIdentifier(id)) {
            return new Status(4, "org.eclipse.cdt.core", -1, NLS.bind((String)Messages.convention_illegalIdentifier, (Object)id), null);
        }
        if (!CConventions.isValidIdentifier(id)) {
            return new Status(4, "org.eclipse.cdt.core", -1, NLS.bind((String)Messages.convention_invalid, (Object)id), null);
        }
        if (CConventions.isReservedKeyword(id, language) || CConventions.isBuiltinType(id, language)) {
            return new Status(4, "org.eclipse.cdt.core", -1, NLS.bind((String)Messages.convention_reservedKeyword, (Object)id), null);
        }
        return CModelStatus.VERIFIED_OK;
    }

    public static IStatus validateMethodName(String name) {
        if (name.startsWith("~")) {
            return CConventions.validateIdentifier(name.substring(1), GPPLanguage.getDefault());
        }
        return CConventions.validateIdentifier(name, GPPLanguage.getDefault());
    }

    public static IStatus validateIncludeName(IProject project, String name) {
        String[] segments = new Path(name).segments();
        int i = 0;
        while (i < segments.length) {
            IStatus status = i == segments.length - 1 ? CConventions.validateHeaderFileName(project, segments[i]) : CConventions.validateFileName(segments[i]);
            if (!status.isOK()) {
                return status;
            }
            ++i;
        }
        return CModelStatus.VERIFIED_OK;
    }

    public static boolean isValidIdentifier(String name) {
        Token token = null;
        Lexer lexer = new Lexer(name.toCharArray(), new Lexer.LexerOptions(), ILexerLog.NULL, null);
        try {
            token = lexer.nextToken();
            if (token.getType() == 1 && lexer.nextToken().getType() == 144) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    private static boolean isReservedKeyword(String name, AbstractCLikeLanguage language) {
        String[] keywords;
        String[] stringArray = keywords = language.getKeywords();
        int n = keywords.length;
        int n2 = 0;
        while (n2 < n) {
            String kw = stringArray[n2];
            if (kw.equals(name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean isBuiltinType(String name, AbstractCLikeLanguage language) {
        String[] types;
        String[] stringArray = types = language.getBuiltinTypes();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            if (type.equals(name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean isLegalFilename(String name) {
        if (name == null || name.isEmpty()) {
            return false;
        }
        int len = name.length();
        int i = 0;
        while (i < len) {
            char c = name.charAt(i);
            if (ILLEGAL_FILE_CHARS.indexOf(c) != -1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static IStatus validateFileName(String name) {
        if (name == null || name.length() == 0) {
            return new Status(4, "org.eclipse.cdt.core", -1, Messages.convention_filename_nullName, null);
        }
        if (!CConventions.isLegalFilename(name)) {
            return new Status(2, "org.eclipse.cdt.core", -1, Messages.convention_filename_possiblyInvalid, null);
        }
        String trimmed = name.trim();
        if (!name.equals(trimmed) || name.indexOf(" ") != -1) {
            return new Status(2, "org.eclipse.cdt.core", -1, Messages.convention_filename_nameWithBlanks, null);
        }
        return CModelStatus.VERIFIED_OK;
    }

    public static IStatus validateHeaderFileName(IProject project, String name) {
        IStatus val = CConventions.validateFileName(name);
        if (val.getSeverity() == 4) {
            return val;
        }
        if (!CoreModel.isValidHeaderUnitName(project, name)) {
            return new Status(2, "org.eclipse.cdt.core", -1, Messages.convention_headerFilename_filetype, null);
        }
        return val;
    }

    public static IStatus validateSourceFileName(IProject project, String name) {
        IStatus val = CConventions.validateFileName(name);
        if (val.getSeverity() == 4) {
            return val;
        }
        if (!CoreModel.isValidSourceUnitName(project, name)) {
            return new Status(2, "org.eclipse.cdt.core", -1, Messages.convention_sourceFilename_filetype, null);
        }
        return val;
    }

    public static IStatus validateEnumName(String name) {
        char[] scannedID;
        if (name == null) {
            return new Status(4, "org.eclipse.cdt.core", -1, Messages.convention_enum_nullName, null);
        }
        String trimmed = name.trim();
        if (!name.equals(trimmed) || name.indexOf(" ") != -1) {
            return new Status(4, "org.eclipse.cdt.core", -1, Messages.convention_enum_nameWithBlanks, null);
        }
        int index = name.lastIndexOf(scopeResolutionOperator);
        if (index == -1) {
            IStatus status = CConventions.validateIdentifier(name, GPPLanguage.getDefault());
            if (!status.isOK()) {
                return status;
            }
            scannedID = name.toCharArray();
        } else {
            String pkg = name.substring(0, index).trim();
            IStatus status = CConventions.validateScopeName(pkg);
            if (!status.isOK()) {
                return status;
            }
            String type = name.substring(index + scopeResolutionOperator.length()).trim();
            status = CConventions.validateIdentifier(type, GPPLanguage.getDefault());
            if (!status.isOK()) {
                return status;
            }
            scannedID = type.toCharArray();
        }
        if (scannedID != null) {
            if (CharOperation.contains('$', scannedID)) {
                return new Status(2, "org.eclipse.cdt.core", -1, Messages.convention_enum_dollarName, null);
            }
            if (scannedID.length > 0 && scannedID[0] == '_') {
                return new Status(2, "org.eclipse.cdt.core", -1, Messages.convention_enum_leadingUnderscore, null);
            }
            if (scannedID.length > 0 && Character.isLowerCase(scannedID[0])) {
                return new Status(2, "org.eclipse.cdt.core", -1, Messages.convention_enum_lowercaseName, null);
            }
            return CModelStatus.VERIFIED_OK;
        }
        return new Status(4, "org.eclipse.cdt.core", -1, Messages.convention_enum_invalidName, null);
    }
}

