/*###############################################################################
# Linux Management Providers (LMP), BIOS provider package
# Copyright (C) 2010 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#ifndef OPENDRIM_BIOSCONCRETECOMPONENTACCESS_H_
#define OPENDRIM_BIOSCONCRETECOMPONENTACCESS_H_

#include "BIOS_Common.h"

#include "OpenDRIM_BIOSConcreteComponent.h"
#include "assocOpenDRIM_BIOSConcreteComponent.h"

int BIOS_OpenDRIM_BIOSConcreteComponent_load(const CMPIBroker* broker, string& errorMessage);

int BIOS_OpenDRIM_BIOSConcreteComponent_unload(string& errorMessage);

int BIOS_OpenDRIM_BIOSConcreteComponent_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_BIOSConcreteComponent>& instances, const char** properties, string& errorMessage, const string& discriminant);

int BIOS_OpenDRIM_BIOSConcreteComponent_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_BIOSConcreteComponent& instance, const char** properties, string& errorMessage);

int BIOS_OpenDRIM_BIOSConcreteComponent_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BIOSConcreteComponent& newInstance, const OpenDRIM_BIOSConcreteComponent& oldInstance, const char** properties, string& errorMessage);

int BIOS_OpenDRIM_BIOSConcreteComponent_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BIOSConcreteComponent& instance, string& errorMessage);

int BIOS_OpenDRIM_BIOSConcreteComponent_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BIOSConcreteComponent& instance, string& errorMessage);

int BIOS_OpenDRIM_BIOSConcreteComponent_associatorPartComponentToGroupComponent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& PartComponent_instance, const char** properties, vector<Instance>& GroupComponent_associatedInstances, string& errorMessage, const string& discriminant);

int BIOS_OpenDRIM_BIOSConcreteComponent_associatorGroupComponentToPartComponent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& GroupComponent_instance, const char** properties, vector<Instance>& PartComponent_associatedInstances, string& errorMessage, const string& discriminant);

int BIOS_OpenDRIM_BIOSConcreteComponent_referencePartComponentToGroupComponent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& PartComponent_instance, const vector<Instance>& GroupComponent_instances, vector<OpenDRIM_BIOSConcreteComponent>& OpenDRIM_BIOSConcreteComponent_instances, const char** properties, string& errorMessage, const string& discriminant);

int BIOS_OpenDRIM_BIOSConcreteComponent_referenceGroupComponentToPartComponent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& GroupComponent_instance, const vector<Instance>& PartComponent_instances, vector<OpenDRIM_BIOSConcreteComponent>& OpenDRIM_BIOSConcreteComponent_instances, const char** properties, string& errorMessage, const string& discriminant);

int BIOS_OpenDRIM_BIOSConcreteComponent_populate(OpenDRIM_BIOSConcreteComponent& instance, string& errorMessage);

#endif /*OPENDRIM_BIOSCONCRETECOMPONENTACCESS_H_*/
