/*###############################################################################
# Linux Management Providers (LMP), CPU provider package
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr ,desmons_frederic@yahoo.fr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Rakhimov Rustam, TUIT <rusyasoft@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_COMPUTERSYSTEMPROCESSOR_H_
#define OPENDRIM_COMPUTERSYSTEMPROCESSOR_H_

#include <Association.h>

// Direct Invocation includes, may have to be adjusted
/*
#include "cmpiCIM_LogicalDevice.h"
#include "CIM_LogicalDeviceAccess.h"
#include "cmpiCIM_System.h"
#include "CIM_SystemAccess.h"
*/

const static char* OpenDRIM_ComputerSystemProcessor_classnames[] = {"OpenDRIM_ComputerSystemProcessor"};
static string OpenDRIM_ComputerSystemProcessor_NAMESPACE = _NAMESPACE;
const static string PartComponent_role = "PartComponent";
const static char* PartComponent_classnames[] = {"OpenDRIM_Processor"};
const static string PartComponent_NAMESPACE = _NAMESPACE;

const static string GroupComponent_role = "GroupComponent";
const static char* GroupComponent_classnames[] = {"OpenDRIM_ComputerSystem"};
const static string GroupComponent_NAMESPACE = _NAMESPACE;

class OpenDRIM_ComputerSystemProcessor {

public:
	
	Objectpath GroupComponent;
	bool GroupComponent_isNULL;
	
	Objectpath PartComponent;
	bool PartComponent_isNULL;
	
	OpenDRIM_ComputerSystemProcessor() {
		GroupComponent_isNULL = true;
		PartComponent_isNULL = true;
	}
	
	~OpenDRIM_ComputerSystemProcessor() {}
	
	string getKeys() const {
		return CF_toLowCase(".GroupComponent=\"" + CF_quoteString(GroupComponent.toString()) + "\""".PartComponent=\"" + CF_quoteString(PartComponent.toString()) + "\"");
	}

	int getGroupComponent(Objectpath& value) const {
		if (GroupComponent_isNULL==true)
			return NOT_FOUND;
		value = GroupComponent;
		return OK;
	}
	
	int setGroupComponent(const Objectpath& newValue) {
		GroupComponent = newValue;
		GroupComponent.setNamespace(GroupComponent_NAMESPACE);
		GroupComponent_isNULL = false;
		return OK;
	}

	int getPartComponent(Objectpath& value) const {
		if (PartComponent_isNULL==true)
			return NOT_FOUND;
		value = PartComponent;
		return OK;
	}
	
	int setPartComponent(const Objectpath& newValue) {
		PartComponent = newValue;
		PartComponent.setNamespace(PartComponent_NAMESPACE);
		PartComponent_isNULL = false;
		return OK;
	}

};

#endif /*OPENDRIM_COMPUTERSYSTEMPROCESSOR_H_*/
