#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# VirtuaVerse
# send your bug reports to contact@dotslashplay.it
###

script_version=20241111.1

PLAYIT_COMPATIBILITY_LEVEL='2.31'

GAME_ID='virtuaverse'
GAME_NAME='VirtuaVerse'

ARCHIVE_BASE_1_NAME='virtuaverse_1_35_53585.sh'
ARCHIVE_BASE_1_MD5='5285b1fb4793e2c87d39f567eceabe71'
ARCHIVE_BASE_1_SIZE='1788767'
ARCHIVE_BASE_1_VERSION='1.35-gog53585'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/virtuaverse'

ARCHIVE_BASE_0_NAME='virtuaverse_1_34_51687.sh'
ARCHIVE_BASE_0_MD5='0592cc967de9f333344f2d69c7665173'
ARCHIVE_BASE_0_SIZE='1800000'
ARCHIVE_BASE_0_VERSION='1.34-gog51687'

UNITY3D_NAME='VirtuaVerse'
## TODO: Check if the Steam library is required
UNITY3D_PLUGINS='
libsteam_api.so'

CONTENT_PATH_DEFAULT='data/noarch/game'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libm.so.6
libpthread.so.0
librt.so.1
libz.so.1'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
