#

  * Replies to Some Errors and Distortions in Bryan Caplan's "Anarchist Theory FAQ" version 4.1.1.

There have been a few "anarchist" FAQ's produced before. Bryan Caplan's
anarchism FAQ is one of the more recent. While appearing to be a "neutral"
statement of anarchist ideas, it is actually in large part an
"anarcho"-capitalist FAQ. This can be seen by the fact that anarchist ideas
(which he calls "left-anarchist") are given less than half the available space
while "anarcho"-capitalist dogma makes up the majority of it. Considering that
anarchism has been around far longer than "anarcho"-capitalism and is the
bigger and better established movement, this is surprising. Even his use of
the term "left anarchist" is strange as it is never used by anarchists and
ignores the fact that Individualist Anarchists like Tucker called themselves
"socialists" and considered themselves part of the wider socialist movement.
For anarchists, the expression "left anarchist" is meaningless as all
anarchists are anti-capitalist. Thus the terms used to describe each "school"
in his FAQ are biased (those whom Caplan calls "Left anarchists" do not use
that term, usually preferring "social anarchist" to distinguish themselves
from individualist anarchists like Tucker).

Caplan also frames the debate only around issues which he is comfortable with.
For example, when discussing "left anarchist" ideas he states that _"A key
value in this line of anarchist thought is egalitarianism, the view that
inequalities, especially of wealth and power, are undesirable, immoral, and
socially contingent."_ This, however, is **not** why anarchists are
egalitarians. Anarchists oppose inequalities because they undermine and
restrict individual and social freedom.

Taking another example, under the question, _"How would left-anarchy work?"_,
Caplan fails to spell out some of the really obvious forms of anarchist
thought. For example, the works of Bookchin, Kropotkin, Bakunin and Proudhon
are not discussed in any detail. His vague and confusing prose would seem to
reflect the amount of thought that he has put into it. Being an
"anarcho"-capitalist, Caplan concentrates on the economic aspect of anarchism
and ignores its communal side. The economic aspect of anarchism he discusses
is anarcho-syndicalism and tries to contrast the confederated economic system
explained by one anarcho-syndicalist with Bakunin's opposition to Marxism.
Unfortunately for Caplan, Bakunin is the source of anarcho-syndicalism's ideas
on a confederation of self-managed workplaces running the economy. Therefore,
to state that _"many"_ anarchists _"have been very sceptical of setting up any
overall political structure, even a democratic one, and focused instead on
direct worker control at the factory level"_ is simply **false**. The idea of
direct local control within a confederated whole is a common thread through
anarchist theory and activity, as any anarchist could tell you.

Lastly, we must note that after Caplan posted his FAQ to the "anarchy-list,"
many of the anarchists on that list presented numerous critiques of the
"anarcho"-capitalist theories and of the ideas (falsely) attributed to social
anarchists in the FAQ, which he chose to ignore (that he was aware of these
postings is asserted by the fact he e-mailed one of the authors of this FAQ on
the issue that anarchists never used or use the term "left-anarchist" to
describe social anarchism. He replied by arguing that the term "left-
anarchist" had been used by Michel Foucault, who never claimed to be an
anarchist, in one of his private letters! Strangely, he never posted his FAQ
to the list again).

Therefore, as can be seen from these few examples, Caplan's "FAQ" is blatantly
biased towards "anarcho-capitalism" and based on the mis-characterisations and
the dis-emphasis on some of the most important issues between "anarcho-
capitalists" and anarchists. It is clear that his viewpoint is anything but
impartial.

This section will highlight some of the many errors and distortions in that
FAQ. Numbers in square brackets refer to the corresponding sections Caplan's
FAQ.

## 1 Is anarchism purely negative?

[1]. Caplan, consulting his **American Heritage Dictionary**, claims:
_"Anarchism is a negative; it holds that one thing, namely government, is bad
and should be abolished. Aside from this defining tenet, it would be difficult
to list any belief that all anarchists hold."_

The last sentence is ridiculous. If we look at the works of Tucker, Kropotkin,
Proudhon and Bakunin (for example) we discover that we can, indeed list one
more _"belief that all anarchists hold."_ This is opposition to exploitation,
to usury (i.e. profits, interest and rent). For example, Tucker argued that
_"Liberty insists. . . [on] the abolition of the State and the abolition of
usury; on no more government of man by man, and no more exploitation of man by
man."_ [cited in **Native American Anarchism - A Study of Left-Wing American
Individualism** by Eunice Schuster, p. 140] Such a position is one that
Proudhon, Bakunin and Kropotkin would agree with.

In other words, anarchists hold two beliefs -- opposition to government
**and** opposition to exploitation. Any person which rejects either of these
positions cannot be part of the anarchist movement. In other words, an
anarchist must be against capitalism in order to be a true anarchist.

Moreover it is not at all difficult to find a more fundamental _"defining
tenet"_ of anarchism. We can do so merely by analysing the term _"an-archy,"_
which is composed of the Greek words **an**, meaning _"no"_ or _"without,"_
and **arche**, meaning literally _"a ruler,"_ but more generally referring to
the **principle** of rulership, i.e. hierarchical authority. Hence an
anarchist is someone who advocates abolishing the principle of hierarchical
authority -- not just in government but in all institutions and social
relations.

Anarchists oppose the principle of hierarchical authority because it is the
basis of domination, which is not only degrading in itself but generally leads
to exploitation and all the social evils which follow from exploitation, from
poverty, hunger and homelessness to class struggle and armed conflict.

Because anarchists oppose hierarchical authority, domination, and
exploitation, they naturally seek to eliminate all hierarchies, as the very
purpose of hierarchy is to facilitate the domination and (usually)
exploitation of subordinates.

The reason anarchists oppose government, then, is because government is **one
manifestation** of the evils of hierarchical authority, domination, and
exploitation. But the capitalist workplace is another. In fact, the capitalist
workplace is where most people have their most frequent and unpleasant
encounters with these evils. Hence workers' control -- the elimination of the
hierarchical workplace through democratic self-management -- has been central
to the agenda of classical and contemporary anarchism from the 19th century to
the present. Indeed, anarchism was born out of the struggle of workers against
capitalist exploitation.

To accept Caplan's definition of anarchism, however, would mean that
anarchists' historical struggle for workers' self-management has never been a
"genuine" anarchist activity. This is clearly a **reductio ad absurdum** of
that definition.

Caplan has confused a necessary condition with a sufficient condition.
Opposition to government is a necessary condition of anarchism, but not a
sufficient one. To put it differently, all anarchists oppose government, but
opposition to government does not automatically make one an anarchist. To be
an anarchist one must oppose government for anarchist reasons and be opposed
to all other forms of hierarchical structure.

To understand why let use look to capitalist property. Murray Rothbard argues
that _"[o]bviously, in a free society, Smith has the ultimate decision-making
power over his own just property, Jones over his, etc."_ [**The Ethics of
Liberty**, p. 173] Defence firms would be employed to enforce those decisions
(i.e. laws and rules). No real disagreement there. What **is** illuminating is
Rothbard's comments that the state _"arrogates to itself a monopoly of force,
of ultimate decision-making power, over a given area territorial area"_ [**Op.
Cit.** , p. 170] Which, to state the obvious, means that both the state and
property is marked by an _"ultimate decision-making power"_ over their
territory. The only "difference" is that Rothbard claims the former is "just"
(i.e. "justly" acquired) and the latter is "unjust" (i.e. acquired by force).
In reality of course, the modern distribution of property is just as much a
product of past force as is the modern state. In other words, the current
property owners have acquired their property in the same unjust fashion as the
state has its. If one is valid, so is the other. Rothbard (and
"anarcho"-capitalists in general) are trying to have it both ways.

Rothbard goes on to show why statism and private property are essentially the
same thing:

> _"**If** the State may be said too properly **own** its territory, then it
is proper for it to make rules for everyone who presumes to live in that area.
It can legitimately seize or control private property because there **is** no
private property in its area, because it really owns the entire land surface.
**So long** as the State permits its subjects to leave its territory, then, it
can be said to act as does any other owner who sets down rules for people
living on his property."_ [**Op. Cit.**, p. 170]

Of course Rothbard does not draw the obvious conclusion. He wants to maintain
that the state is bad and property is good while drawing attention to their
obvious similarities! Ultimately Rothbard is exposing the bankruptcy of his
own politics and analysis. According to Rothbard, something can look like a
state (i.e. have the _"ultimate decision-making power"_ over an area) and act
like a state (i.e. _"make rules for everyone"_ who lives in an area, i.e.
govern them) but not be a state. This not a viable position for obvious
reasons.

In capitalism, property and possession are opposites -- as Proudhon argued in
**What is Property?**. Under possession, the "property" owner exercises
_"ultimate decision-making power"_ over themselves as no-one else uses the
resource in question. This is non-hierarchical. Under capitalism, however, use
and ownership are divided. Landlords and capitalists give others access to
their property while retaining power over it and so the people who use it.
This is by nature hierarchical. Little wonder Noam Chomsky argued that a
_"consistent anarchist must oppose private ownership of the means of
production and the wage slavery which is a component of this system as
incompatible with the principle that labour must be freely undertaken and
under the control of the producer."_ [_"Notes on Anarchism"_, **For Reasons of
State**, p. 158]

Thus a true anarchist must oppose both state and capitalism as they generate
the same hierarchical social relationships (as recognised by Rothbard but
apparently subjected to "doublethink"). As "anarcho"-capitalists do not oppose
capitalist property they cannot be anarchists -- they support a very specific
form of **archy,** that of the capitalist/landlord over working class people.

Self-styled "anarcho"-capitalists do not oppose government for anarchist
reasons. That is, they oppose it not because it is a manifestation of
hierarchical authority, but because government authority often **conflicts**
with capitalists' authority over the enterprises they control. By getting rid
of government with its minimum wage laws, health and safety requirements,
union rights laws, environmental standards, child labour laws, and other
inconveniences, capitalists would have even more power to exploit workers than
they already do. These consequences of "anarcho"-capitalism are diametrically
opposed to the historically central objective of the anarchist movement, which
is to eliminate capitalist exploitation.

We must conclude, then, that "anarcho"-capitalists are not anarchists at all.
In reality they are capitalists **posing** as anarchists in order to attract
support for their laissez-faire economic project from those who are angry at
government. This scam is only possible on the basis of the misunderstanding
perpetrated by Caplan: that anarchism means nothing more than opposition to
government.

Better definitions of anarchism can be found in other reference works. For
example, in **Grollier's Online Encyclopedia** we read: _"Anarchism rejects
all forms of hierarchical authority, social and economic as well as
political."_ According to this more historically and etymologically accurate
definition, "anarcho"-capitalism is not a form of anarchism, since it does not
reject hierarchical authority in the economic sphere (which has been the area
of prime concern to anarchists since day one). Hence it is **bogus**
anarchism.

## 2 Anarchism and Equality

[5.] On the question "What major subdivisions may be made among anarchists?"
Caplan writes:

> _"Unlike the left-anarchists, anarcho-capitalists generally place little or
no value on equality, believing that inequalities along all dimensions --
including income and wealth -- are not only perfectly legitimate so long as
they 'come about in the right way,' but are the natural consequence of human
freedom."_

This statement is not inaccurate as a characterisation of "anarcho"-capitalist
ideas, but its implications need to be made clear. "Anarcho"-capitalists
generally place little or no value on equality -- particularly economic
equality -- because they know that under their system, where capitalists would
be completely free to exploit workers to the hilt, wealth and income
inequalities would become even greater than they are now. Thus their
references to "human freedom" as the way in which such inequalities would
allegedly come about means "freedom of capitalists to exploit workers;" it
does not mean "freedom of workers **from** capitalist exploitation."

But "freedom to exploit workers" has historically been the objective only of
capitalists, not anarchists. Therefore, "anarcho"-capitalism again shows
itself to be nothing more than capitalism attempting to pass itself off as
part of the anarchist movement -- a movement that has been dedicated since its
inception to the destruction of capitalism! One would have to look hard to
find a more audacious fraud.

As we argue in [section 2.1](append132.md#secf21) of the appendix ["Is
'anarcho'-capitalism a type of anarchism?"](append13.md) the claim that
inequalities are irrelevant if they _"come about the right way"_ ignores the
reality of freedom and what is required to be free. To see way we have to
repeat part of our argument from that section and look at Murray Rothbard's (a
leading "anarcho"-capitalist icon) analysis of the situation after the
abolition of serfdom in Russia and slavery in America. He writes:

> _"The **bodies** of the oppressed were freed, but the property which they
had worked and eminently deserved to own, remained in the hands of their
former oppressors. With economic power thus remaining in their hands, the
former lords soon found themselves virtual masters once more of what were now
free tenants or farm labourers. The serfs and slaves had tasted freedom, but
had been cruelly derived of its fruits."_ [**The Ethics of Liberty**, p. 74]

However, contrast this with Rothbard's (and Caplan's) claims that if market
forces ("voluntary exchanges") result in the creation of free tenants or wage-
labourers then these labourers and tenants are free (see, for example, **The
Ethics of Liberty**, pp. 221-2 on why "economic power" within capitalism does
not, in fact, exist). But the labourers dispossessed by market forces are in
**exactly** the same situation as the former serfs and slaves. Rothbard sees
the obvious "economic power" in the later case, but denies it in the former.
But the **conditions** of the people in question are identical and it is these
conditions that horrify us and create social relationships because on
subordination, authority and oppression rather than freedom. It is only
ideology that stops Rothbard and Caplan drawing the obvious conclusion --
identical conditions produce identical social relationships and so if the
formally "free" ex-serfs are subject to "economic power" and "masters" then so
are the formally "free" labourers within capitalism! Both sets of workers may
be formally free, but their circumstances are such that they are "free" to
"consent" to sell their freedom to others (i.e. economic power produces
relationships of domination and unfreedom between formally free individuals).

Thus inequalities that _"come about in the right way"_ restrict freedom just
as much as inequalities that do not. If the latter restricts liberty and
generate oppressive and exploitative social relationships then so do the
former. Thus, if we are serious about individuality liberty (rather than
property) we must look at inequalities and what generate them.

One last thing. Caplan states that inequalities in capitalism are _"the
natural consequence of human freedom."_ They are not, unless you subscribe to
the idea that capitalist property rights are the basis of human freedom.
However, the assumption that capitalist property rights are the best means to
defend individual liberty can be easily seen to be flawed just from the
example of the ex-slaves and ex-serfs we have just described. Inequalities
resulting from "voluntary exchanges" in the capitalist market can and do
result in the denial of freedom, thus suggesting that "property" and liberty
are not natural consequences of each other.

To state the obvious, private property (rather than possession) means that the
non-property owner can gain access to the resource in question only when they
agree to submit to the property owner's authority (and pay tribute for the
privilege of being bossed about). This aspect of property (rightly called
_"despotism"_ by Proudhon) is one which right-libertarians continually fail to
highlight when they defend it as the paradigm of liberty.

## 3 Is anarchism the same thing as socialism?

[7.] In this section ("Is anarchism the same thing as socialism?") Caplan
writes:

> _"Outside of the Anglo-American political culture, there has been a long and
close historical relationship between the more orthodox socialists who
advocate a socialist government, and the anarchist socialists who desire some
sort of decentralised, voluntary socialism. The two groups both want to
severely limit or abolish private property..."_

For Caplan to claim that anarchism is not the same thing as socialism, he has
to ignore anarchist history. For example, the Individualist anarchists called
themselves _"socialists,"_ as did social anarchists. Indeed, Individualist
Anarchists like Joseph Labadie stated that _"Anarchism is voluntary
socialism"_ [**Anarchism: What it is and What it is Not**) and wanted to limit
private property in many ways (for example, _"the resources of nature -- land,
mines, and so forth -- should not be held as private property and subject to
being held by the individual for speculative purposes, that use of these
things shall be the only valid title, and that each person has an equal right
to the use of all these things."_ [**What is Socialism?**]). Therefore,
**within** the _"Anglo-American political culture,"_ **all** types of
anarchists considered themselves part of the socialist movement. This can be
seen not only from Kropotkin's or Bakunin's work, but also in Tucker's (see
**Instead of a Book**). So to claim that the _"Anglo-American"_ anarchists did
not have _"a long and close historical relationship"_ with the wider socialist
movement is simply **false.**

The statement that anarchists want to severely limit or abolish "private
property" is misleading if it is not further explained. For the way it stands,
it sounds like anarchism is just another form of coercive "state" (i.e. a
political entity that forcibly prevents people from owning private property),
whereas this is far from the case.

Firstly, anarchists are **not** against "private property" in the sense
personal belongings. _"Anarchists,"_ points out Nicholas Walter, _"are in
favour of the private property which cannot be used by one person to exploit
another -- those personal possessions which we accumulate from childhood and
which become part of ours."_ [_"About Anarchism"_, in **Reinventing Anarchy**,
p. 49] Kropotkin makes the anarchist position clear when he wrote that we _"do
not want to rob any one of his coat"_ but expropriation _"must apply to
everything that enables any man [or woman] -- by he financier, mill owner, or
landlord -- to appropriate the product of others' toil."_ [**The Conquest of
Bread**, p. 61]

In effect, Caplan is confusing two very different kinds of "private property",
of which one rests on usefulness to an individual, the other on the employment
(and so exploitation) of the labour of others. The latter produces social
relations of domination between individuals, while the former is a
relationship between people and things. As Proudhon argued, possession becomes
property only when it also serves as means of exploitation and subjection of
other people. But failing to distinguish these radically different forms of
"private property" Caplan distorts the anarchist position.

Secondly, it is not that anarchists want to pass laws making private property
(in the second, exploitative, sense) illegal. Rather they want to restructure
society in such a way that the means of production are freely available for
workers to use. This does not mean "anarchist police" standing around with
guns to prohibit people from owning private property. Rather, it means
dismantling the coercive state agencies that make private property possible,
i.e., the departments of real police who now stand around with guns protecting
private property.

Once that occurs, anarchists maintain that capitalism would be impossible,
since capitalism is essentially a monopoly of the means of production, which
can only be maintained by organised coercion. For suppose that in an anarchist
society someone (call him Bob) somehow acquires certain machinery needed to
produce widgets (a doubtful supposition if widget-making machines are very
expensive, as there will be little wealth disparity in an anarchist society).
And suppose Bob offers to let workers with widget-making skills use his
machines if they will pay him "rent," i.e. allow him to appropriate a certain
amount of the value embodied in the widgets they produce. The workers will
simply refuse, choosing instead to join a widget-making collective where they
have free access to widget-making machinery, thus preventing Bob from living
parasitically on their labour. Thus Kropotkin:

> _"Everywhere you will find that the wealth of the wealthy springs from the
poverty of the poor. That is why an anarchist society need not fear the advent
of a Rothschild [or any other millionaire] who would settle in its midst. If
every member of the community knows that after a few hours of productive toil
he [or she] will have a right to all the pleasures that civilisation procures,
and to those deeper sources of enjoyment which art and science offer to all
who seek them, he [or she] will not sell his strength. . . No one will
volunteer to work for the enrichment of your Rothschild."_ [**Op. Cit.**, p.
61]

In this scenario, private property was "abolished," but not through coercion.
Indeed, it was precisely the abolition of organised coercion that allowed
private property to be abolished.

## 4 Anarchism and dissidents

[9.] On the question "How would left-anarchy work?" Caplan writes:

> _"Some other crucial features of the left-anarchist society are quite
unclear. Whether dissidents who despised all forms of communal living would be
permitted to set up their own inegalitarian separatist societies is rarely
touched upon. Occasionally left-anarchists have insisted that small farmers
and the like would not be forcibly collectivised, but the limits of the right
to refuse to adopt an egalitarian way of life are rarely specified."_

This is a straw man. "Left" (i.e. real) anarchist theory clearly implies and
**explicitly states** the answer to these questions.

Firstly, on the issue of "separatist" societies. Anarchist thinkers have
always acknowledged that there would be multitude of different communities
after a revolution (and not just Caplan's "inegalitarian" ones). Marx, for
example, mocked Bakunin for arguing that only revolutionary communes would
federate together and that this would not claim any right to govern others
(see Bakunin's _"Letter to Albert Richards"_, **Michael Bakunin: Selected
Writings**, p. 179] Kropotkin stated that _"the point attained in the
socialisation of wealth will not be everywhere the same"_ and _"[s]ide by side
with the revolutionised communes . . . places would remain in an expectant
attitude, and would go on living on the Individualist system."_ [**The
Conquest of Bread**, p. 81] While he was hopeful that _"everywhere [would be]
more or less Socialism"_ he recognised that the revolution would not conform
to _"any particular rule"_ and would differ in different areas -- _"in one
country State Socialist, in another Federation"_ and so on. [**Op. Cit.**, p.
82] Malatesta made the same point, arguing that _"after the revolution"_ there
would be _"relations between anarchist groupings and those living under some
kind of authority, between communist collectives and those living in an
individualistic way."_ This is because anarchism _"cannot be imposed"_.
[**Life and Ideas**, p. 173, p. 21]

Needless to say, these "separatist societies" (which may or may not be
"inegalitarian") would not be anarchist societies. If a group of people wanted
to set up a capitalist, Marxist, Georgist or whatever kind of community then
their right would be respected (although, of course, anarchists would seek to
convince those who live in such a regime of the benefits of anarchism!). As
Malatesta pointed out, _"free and voluntary communism is ironical if one has
not the right and the possibility to live in a different regime, collectivist,
mutualist, individualist -- as one wishes, always on condition that there is
no oppression or exploitation of other"_ as _"it is clear that all, and only,
those ways of life which respect freedom, and recognise that each individual
has an equal right to the means of production and to the full enjoyment of the
product of his own labour, have anything in common with anarchism."_ [**Op.
Cit.**, p. 103 and p. 33]

Ultimately, _"it is not a question of right and wrong; it is a question of
freedom for everybody. . . None can judge with certainty who is right and who
is wrong, who is nearest to the truth, or which is the best way to achieve the
greatest good for each and everyone. Freedom coupled with experience, is the
only way of discovering the truth and what is best; and there can be no
freedom if there is the denial of the freedom to err."_ [**Op. Cit.**, p. 49]

Secondly, regarding _"dissidents"_ who wanted to set up their own
_"inegalitarian separatist societies,"_ if the term "inegalitarian" implies
economic inequalities due to private property, the answer is that private
property requires some kind of state, if not a public state then private
security forces ("private-state capitalism"), as advocated by
"anarcho"-capitalists, in order to protect private property. Therefore,
"anarcho"-capitalists are asking if an anarchist society will allow the
existence of states. Of course, in the territory that used to be claimed by a
nation state a whole host of communities and societies will spring up -- but
that does not make the non-anarchist ones anarchist!

Thus suppose that in a hypothetical libertarian socialist society, Bob tries
to set up private security forces to protect certain means of production, e.g.
farmland. By the hypothesis, if Bob merely wanted to work the land himself,
there would be no reason for him go to the trouble of creating a private state
to guard it, because use-rights guarantee that he has free access to the
productive assets he needs to make a living. Thus, the only plausible reason
Bob could have for claiming and guarding more farmland than he could use
himself would be a desire to create a monopoly of land in order to exact
tribute from others for the privilege of using it. But this would be an
attempt to set up a system of feudal exploitation in the midst of a free
community. Thus the community is justified in disarming this would-be parasite
and ignoring his claims to "own" more land than he can use himself.

In other words, there is no "right" to adopt an "inegalitarian way of life"
within a libertarian community, since such a right would have to be enforced
by the creation of a coercive system of enslavement, which would mean the end
of the "libertarian" community. To the contrary, the members of such a
community have a right, guaranteed by "the people in arms," to resist such
attempts to enslave them.

The statement that "left" anarchists have _"occasionally"_ insisted that small
farmers and the like would not be forcibly collectivised is a distortion of
the facts. No responsible left libertarian advocates forced collectivisation,
i.e. compelling others to join collectives. Self-employment is always an
option. This can be seen from Bakunin's works [**Bakunin on Anarchism**, p.
200], Kropotkin's [**The Conquest of Bread**, p. 61 and **Act for
Yourselves**, pp. 104-5] and Malatesta's [**Life and Ideas**, p. 99, p. 103].
So the anarchist opposition to forced collectivisation has always existed and,
for anyone familiar with the ideas of social anarchism, very well know. Thus
during the Spanish Revolution, small farmers who did not wish to join
collective farms were allowed to keep as much land as they could work
themselves. After perceiving the advantages of collectives, however, many
joined them voluntarily (see Sam Dolgoff, ed., **The Anarchist Collectives**).

To claim that social anarchists _"occasionally"_ oppose forced
collectivisation is a smear, pure and simple, with little basis in anarchist
activity and even less in anarchist theory. Anyone remotely familiar with the
literature could not make such a mistake.

Finally, we should point out that under "anarcho"-capitalism there would be,
according to Murray Rothbard, a _"basic libertarian law code."_ Which means
that under "anarcho"-capitalism, "egalitarian" communities could only come
about within a "inegalitarian" legal framework! Thus, given that everything
would be privatised, dissenters could only experiment if they could afford it
**and** accepted the legal system based on capitalist property rights (and, of
course, survive the competition of capitalist companies within the capitalist
framework). As we have argued in sections [B.4](secB4.md) and
[F.3](secF3.md) **why** should we have to **pay** the stealers of the earth
for the privilege to life our own lives? Caplan, in effect, ignores the
barriers to experimentation in his system while distorting the anarchist
position.

## 5 How would anarcho-capitalism work?

[10.] This section (How would anarcho-capitalism work?) contains Caplan's
summary of arguments for "anarcho"-capitalism, which he describes as an
offshoot of Libertarianism. Thus:

> _"So-called 'minarchist' libertarians such as Nozick have argued that the
largest justified government was one which was limited to the protection of
individuals and their private property against physical invasion; accordingly,
they favour a government limited to supplying police, courts, a legal code,
and national defence."_

The first thing to note about this argument is that it is stated in such a way
as to prejudice the reader against the left-libertarian critique of private
property. The minarchist right-"libertarian," it is said, only wants to
protect individuals and their private property against "physical invasion."
But, because of the loose way in which the term "property" is generally used,
the "private property" of most "individuals" is commonly thought of as
**personal possessions,** i.e. cars, houses, clothing, etc. (For the left-
libertarian distinction between private property and possessions, see [section
B.3.1.](secB3.md#secb31)) Therefore the argument makes it appear that right
libertarians are in favour of protecting personal possessions whereas left-
libertarians are not, thus conjuring up a world where, for example, there
would be no protection against one's house being "physically invaded" by an
intruder or a stranger stealing the shirt off one's back!

By lumping the protection of "individuals" together with the protection of
their "private property," the argument implies that right libertarians are
concerned with the welfare of the vast majority of the population, whereas in
reality, the vast majority of "individuals" **do not own** any private
property (i.e. means of production) -- only a handful of capitalists do.
Moreover, these capitalists use their private property to exploit the working
class, leading to impoverishment, alienation, etc., and thus **damaging** most
individuals rather than "protecting" them.

Caplan goes on:

> _"This normative theory is closely linked to laissez-faire economic theory,
according to which private property and unregulated competition generally lead
to both an efficient allocation of resources and (more importantly) a high
rate of economic progress."_

Caplan does not mention the obvious problems with this "theory," e.g. that
during the heyday of laissez-faire capitalism in the US there was vast wealth
disparity, with an enormous mass of impoverished people living in slums in the
major cities -- hardly an "efficient" allocation of resources or an example of
"progress." Of course, if one defines "efficiency" as "the most effective
means of exploiting the working class" and "progress" as "a high rate of
profit for investors," then the conclusion of the "theory" does indeed follow.

And let us not forget that it is general equilibrium theory which predicts
that unregulated competition will produce an efficient allocation of
resources. However, as we noted in [section C.1](secC1.md), such a model has
little to do with any real economy. This means that there is no real reason to
assume an efficient outcome of capitalist economies. Concentrations of
economic power and wealth can easily skew outcomes to favour the haves over
the have-nots (as history again and again shows).

Moreover, the capitalism can easily lead to resources being allocated to the
most profitable uses rather than those which are most needed by individuals. A
classic example is in the case of famines. Amartya Sen (who won the 1998 Nobel
Prize for economics) developed an _**"entitlement"**_ approach to the study of
famine. This approach starts with the insight that having food available in a
country or region does not mean everyone living there is "entitled" to it. In
market economies, people are entitled to food according to their ability to
produce it for themselves or to pay or swap for it. In capitalist economies,
most people are entitled to food only if they can sell their labour/liberty to
those who own the means of life (which increases the economic insecurity of
wage workers).

If some group loses its entitlement to food, whether there is a decline in the
available supply or not, a famine can occur. This may seem obvious, yet before
- and after - Sen, famine studies have remained fixated on the drop in food
available instead of whether specific social groups are entitled to it. Thus
even a relatively success economy can price workers out of the food market (a
depressed economy brings the contradiction between need and profit -- use
value and exchange value -- even more to the forefront). This _"pricing out"_
can occur especially if food can get higher prices (and so profits) elsewhere
-- for example the Irish famine of 1848 and sub-Saharan famines of the 1980s
saw food being exported from famine areas to areas where it could fetch a
higher price. In other words, market forces can skew resource allocation away
from where it is most needed to where it can generate a profit. As anarchist
George Barret noted decades before Sen:

> _"Today the scramble is to compete for the greatest profits. If there is
more profit to be made in satisfying my lady's passing whim than there is in
feeding hungry children, then competition brings us in feverish haste to
supply the former, whilst cold charity or the poor law can supply the latter,
or leave it unsupplied, just as it feels disposed. That is how it works out."_
[**Objectives to Anarchism**]

In other words, inequality skews resource allocation towards the wealthy.
While such a situation may be _"efficient allocation of resources"_ from the
perspective of the capitalist, it is hardly so from a social perspective (i.e.
one that considers **all** individual needs rather than "effective demand").

Furthermore, if we look at the stock market (a key aspect of any capitalist
system) we discover a strong tendencies **against** the efficient allocation
of resources. The stock market often experiences "bubbles" and becomes
significantly over-valued. An inflated stock market badly distorts investment
decisions. For example, if Internet companies are wildly over-valued then the
sale of shares of new Internet companies or the providing of start-up capital
will drain away savings that could be more productively used elsewhere. The
real economy will pay a heavy price from such misdirected investment and, more
importantly, resources are **not** efficiency allocated as the stock market
skews resources into the apparently more profitable areas and away from where
they could be used to satisfy other needs.

The stock market is also a source of other inefficiencies. Supporters of
"free-market" capitalism always argued that the Stalinist system of central
planning created a perverse set of incentives to managers. In effect, the
system penalised honest managers and encouraged the flow of
**dis**-information. This lead to information being distorted and resources
inefficiently allocated and wasted. Unfortunately the stock market also
creates its own set of perverse responses and mis-information. Doug Henwood
argues that _"something like a prisoners' dilemma prevails in relations
between managers and the stock market. Even if participants are aware of an
upward bias to earnings estimates, and even if they correct for it, managers
still have an incentive to try and fool the market. If you tell the truth,
your accurate estimates will be marked down by a sceptical market. So its
entirely rational for managers to boost profits in the short term, either
through accounting gimmickry or by making only investments with quick
paybacks."_ He goes on to note that _"[i]f the markets see high costs as bad,
and low costs as good, then firms may shun expensive investments because they
will be taken as signs of managerial incompetence. Throughout the late 1980s
and early 1990s, the stock market rewarded firms announcing write-offs and
mass firings -- a bulimic strategy of management -- since the cost cutting was
seen as contributing rather quickly to profits. Firms and economies can't get
richer by starving themselves, but stock market investors can get richer when
the companies they own go hungry. As for the long term, well, that's someone
else's problem."_ [**Wall Street**, p. 171]

This means that resources are allocated to short term projects, those that
enrich the investors now rather than produce long term growth and benefits
later. This results in slower and more unstable investment than less market
centred economies, as well as greater instability over the business cycle
[**Op. Cit.**, pp. 174-5] Thus the claim that capitalism results in the
"efficient" allocation of resources is only true if we assume "efficient"
equals highest profits for capitalists. As Henwood summarises, _"the US
financial system performs dismally at its advertised task, that of efficiently
directing society's savings towards their optimal investment pursuits. The
system is stupefyingly expensive, gives terrible signals, and has surprisingly
little to do with real investment."_ [**Op. Cit.**, p. 3]

Moreover, the claim that laissez-faire economies produce a high rate of
economic progress can be questioned on the empirical evidence available. For
example, from the 1970s onwards there has been a strong tendency towards
economic deregulation. However, this tendency has been associated with a
**slow down** of economic growth. For example, _"[g]rowth rates, investment
rates and productivity rates are all lower now than in the [Keynesian post-
war] Golden Age, and there is evidence that the trend rate of growth -- the
underlying growth rate -- has also decreased."_ Before the Thatcher pro-market
reforms, the British economy grew by 2.4% in the 1970s. After Thatcher's
election in 1979, growth decreased to 2% in the 1980s and to 1.2% in the
1990s. In the USA, we find a similar pattern. Growth was 4.4% in the 1960s,
3.2% in the 1970s, 2.8% in the 1980s and 1.9% in the first half of the 1990s
[Larry Elliot and Dan Atkinson, **The Age of Insecurity**, p. 236]. Moreover,
in terms of inflation-adjusted GDP per capita and productivity, the US had the
worse performance out of the US, UK, Japan, Italy, France, Canada and
Australia between 1970 and 1995 [Marc-Anfre Pigeon and L. Randall Wray,
**Demand Constraints and Economic Growth**]. Given that the US is usually
considered the most laissez-faire out of these 7 countries, Caplan's claim of
high progress for deregulated systems seems at odds with this evidence.

As far as technological innovation goes, it is also not clear that
deregulation has aided that process. Much of our modern technology owns its
origins to the US Pentagon system, in which public money is provided to
companies for military R&amp;D purposes. Once the technology has been proven
viable, the companies involved can sell their public subsidised products for
private profit. The computer industry (as we point out in [section
J.4.7](secJ4.md#secj47)) is a classic example of this -- indeed it is
unlikely whether we would have computers or the internet if we had waited for
capitalists to development them. So whether a totally deregulated capitalism
would have as high a rate of technological progress is a moot point.

So, it seems likely that it is only the **assumption** that the free
capitalist market will generate _"an efficient allocation of resources and
(more importantly) a high rate of economic progress."_ Empirical evidence
points the other way -- namely, that state aided capitalism provides an
approximation of these claims. Indeed, if we look at the example of the
British Empire (which pursued a strong free trade and laissez-faire policy
over the areas it had invaded) we can suggest that the opposite may be true.
After 25 prosperous years of fast growth (3.5 per cent), after 1873 Britain
had 40 years of slow growth (1.5 per cent), the last 14 years of which were
the worse -- with productivity declining, GDP stagnant and home investment
halved. [Nicholas Kaldor, **Further Essays on Applied Economics**, p. 239] In
comparison, those countries which embraced protectionism (such as Germany and
the USA) industrialised successfully and become competitors with the UK.
Indeed, these new competitors grew in time to be efficient competitors of
Britain not only in foreign markets but also in Britain's home market. The
result was that _"for fifty years Britain's GDP grew very slowly relative to
the more successful of the newer industrialised countries, who overtook her,
one after another, in the volume of manufacturing production and in exports
and finally in real income per head."_ [**Op. Cit.**, p. xxvi] Indeed,
_"America's growth and productivity rates were higher when tariffs were steep
than when they came down."_ [Larry Elliot and Dan Atkinson, **Op. Cit.**, p.
277]

It is possible to explain almost everything that has ever happened in the
world economy as evidence not of the failure of markets but rather of what
happens when markets are not able to operate freely. Indeed, this is the
right-libertarian position in a nut shell. However, it does seem strange that
movements towards increased freedom for markets produce worse results than the
old, more regulated, way. Similarly it seems strange that the country that
embraced laissez-faire and free trade (Britain) did **worse** than those which
embraced protectionism (USA, Germany, etc.).

It could always be argued that the protectionist countries had embraced free
trade their economies would have done even better. This is, of course, a
possibility -- if somewhat unlikely. After all, the argument for laissez-faire
and free trade is that it benefits all parties, even if it is embraced
unilaterally. That Britain obviously did not benefit suggests a flaw in the
theory (and that no country **has** industrialised without protectionism
suggests likewise). Unfortunately, free-market capitalist economics lends
itself to a mind frame that ensures that nothing could happen in the real
world that would could ever change its supporters minds about anything.

Free trade, it could be argued, benefits only those who have established
themselves in the market -- that is, have market power. Thus Britain could
initially benefit from free trade as it was the only industrialised nation
(and even **its** early industrialisation cannot be divorced from its initial
mercantilist policies). This position of strength allowed them to dominate and
destroy possible competitors (as Kaldor points out, _"[w]here the British
succeeded in gaining free entry for its goods. . . it had disastrous effects
on local manufactures and employment."_ [**Op. Cit.**, p. xxvi]). This would
revert the other country back towards agriculture, an industry with
diminishing returns to scale (manufacturing, in contrast, has increasing
returns) and ensure Britain's position of power.

The use of protection, however, sheltered the home industries of other
countries and gave them the foothold required to compete with Britain. In
addition, Britains continual adherence to free trade meant that a lot of
**new** industries (such as chemical and electrical ones) could not be
properly established. This combination contributed to free trade leading to
stunted growth, in stark contrast to the arguments of neo-classical economics.

Of course, we will be accused of supporting protectionism by recounting these
facts. That is not the case, as protectionism is used as a means of
"proletarianising" a nation (as we discuss in [section F.8](secF8.md)).
Rather we are presenting evidence to refute a claim that deregulated
capitalism will lead to higher growth. Thus, we suggest, the history of
"actually existing" capitalism indicates that Caplan's claim that deregulated
capitalism will result _"a high rate of economic progress"_ may be little more
than an assumption. True, it is an assumption of neo-classical economics, but
empirical evidence suggests that assumption is as unfounded as the rest of
that theory.

Next we get to the meat of the defence of "anarcho"-capitalism:

> _"Now the anarcho-capitalist essentially turns the minarchist's own logic
against him, and asks why the remaining functions of the state could not be
turned over to the free market. And so, the anarcho-capitalist imagines that
police services could be sold by freely competitive firms; that a court system
would emerge to peacefully arbitrate disputes between firms; and that a
sensible legal code could be developed through custom, precedent, and
contract."_

Indeed, the functions in question could certainly be turned over to the "free"
market, as was done in certain areas of the US during the 19th century, e.g.
the coal towns that were virtually owned by private coal companies. We have
already discussed the negative impact of that experiment on the working class
in [section F.6.2](secF6.md#secf62). Our objection is not that such
privatisation cannot be done, but that it is an error to call it a form of
anarchism. In reality it is an extreme form of laissez-faire capitalism, which
is the exact opposite of anarchism. The defence of private power by private
police is hardly a move towards the end of authority, nor are collections of
private states an example of anarchism.

Indeed, that "anarcho"-capitalism does not desire the end of the state, just a
change in its form, can be seen from Caplan's own arguments. He states that
_"the remaining functions of the state"_ should be _"turned over to the free
market."_ Thus the state (and its functions, primarily the defence of
capitalist property rights) is **privatised** and not, in fact, abolished. In
effect, the "anarcho"-capitalist seeks to abolish the state by calling it
something else.

Caplan:

> _"The anarcho-capitalist typically hails modern society's increasing
reliance on private security guards, gated communities, arbitration and
mediation, and other demonstrations of the free market's ability to supply the
defensive and legal services normally assumed to be of necessity a government
monopoly."_

It is questionable that _"modern society"_ **as such** has increased its
reliance on _"private security guards, gated communities"_ and so on. Rather,
it is the **wealthy** who have increased their reliance on these forms of
private defence. Indeed it is strange to hear a right-libertarian even use the
term "society" as, according to that ideology, society does not exist! Perhaps
the term "society" is used to hide the class nature of these developments? As
for "gated communities" it is clear that their inhabitants would object if the
rest of society gated themselves from them! But such is the logic of such
developments -- but the gated communities want it both ways. They seek to
exclude the rest of society from their communities while expected to be given
access to that society. Needless to say, Caplan fails to see that liberty for
the rich can mean oppression for the working class -- _"we who belong to the
proletaire class, property excommunicates us!"_ [Proudhon, **What is
Property?**, p. 105]

That the law code of the state is being defended by private companies is
hardly a step towards anarchy. This indicates exactly why an "anarcho"-
capitalist system will be a collection of private states united around a
common, capitalistic, and hierarchical law code. In addition, this system does
not abolish the monopoly of government over society represented by the
_"general libertarian law code,"_ nor the monopoly of power that owners have
over their property and those who use it. The difference between public and
private statism is that the boss can select which law enforcement agents will
enforce his or her power.

The threat to freedom and justice for the working class is clear. The thug-
like nature of many private security guards enforcing private power is well
documented. For example, the beating of protesters by "private cops" is a
common sight in anti-motorway campaigns or when animal right activists attempt
to disrupt fox hunts. The shooting of strikers during strikes occurred during
the peak period of American laissez-faire capitalism. However, as most forms
of protest involve the violation of "absolute" property rights, the "justice"
system under "anarcho"-capitalism would undoubtedly fine the victims of such
attacks by private cops.

It is also interesting that the "anarcho"-capitalist "hails" what are actually
symptoms of social breakdown under capitalism. With increasing wealth
disparity, poverty, and chronic high unemployment, society is becoming
polarised into those who can afford to live in secure, gated communities and
those who cannot. The latter are increasingly marginalised in ghettos and poor
neighbourhoods where drug-dealing, prostitution, and theft become main forms
of livelihood, with gangs offering a feudalistic type of "protection" to those
who join or pay tribute to them. Under "anarcho"-capitalism, the only change
would be that drug-dealing and prostitution would be legalised and gangs could
start calling themselves "defence companies."

Caplan:

> _"In his ideal society, these market alternatives to government services
would take over **all** legitimate security services. One plausible market
structure would involve individuals subscribing to one of a large number of
competing police services; these police services would then set up contracts
or networks for peacefully handling disputes between members of each others'
agencies. Alternately, police services might be 'bundled' with housing
services, just as landlords often bundle water and power with rental housing,
and gardening and security are today provided to residents in gated
communities and apartment complexes."_

This is a scenario designed with the upper classes in mind and a few working
class people, i.e. those with **some** property (for example, a house) --
sometimes labelled the "middle class". But under capitalism, the tendency
toward capital concentration leads to increasing wealth polarisation, which
means a shrinking "middle class" (i.e. working class with decent jobs and
their own homes) and a growing "underclass" (i.e. working class people without
a decent job). Ironically enough, America (with one of the most laissez-faire
capitalist systems) is also the Western nation with the **smallest** "middle
class" and wealth concentration has steadily increased since the 1970s. Thus
the number of people who could afford to buy protection and "justice" from the
best companies would continually decrease. For this reason there would be a
growing number of people at the mercy of the rich and powerful, particularly
when it comes to matters concerning employment, which is the main way in which
the poor would be victimised by the rich and powerful (as is indeed the case
now).

Of course, if landlords **do** "bundle" police services in their contracts
this means that they are determining the monopoly of force over the property
in question. Tenants would "consent" to the police force and the laws of the
landlord in exactly the same way emigrants "consent" to the laws and
government of, say, the USA when they move there. Rather than show the
difference between statism and capitalism, Caplan has indicated their
essential commonality. For the proletarian, property is but another form of
state. For this reason anarchists would agree with Rousseau when he wrote
that:

> _"That a rich and powerful man, having acquired immense possessions in
lands, should impose laws on those who want to establish themselves there, and
that he should only allow them to do so on condition that they accept his
supreme authority and obey all his wishes; that, I can still conceive. But how
can I conceive such a treaty, which presupposes anterior rights, could be the
first foundation of law? Would not this tyrannical act contain a double
usurpation: that on the ownership of the land and that on the liberty of the
inhabitants?"_ [**The Social Contract and Discourses**, p. 316]

Caplan:

> _"The underlying idea is that contrary to popular belief, private police
would have strong incentives to be peaceful and respect individual rights. For
first of all, failure to peacefully arbitrate will yield to jointly
destructive warfare, which will be bad for profits. Second, firms will want to
develop long-term business relationships, and hence be willing to negotiate in
good faith to insure their long-term profitability. And third, aggressive
firms would be likely to attract only high-risk clients and thus suffer from
extraordinarily high costs (a problem parallel to the well-known 'adverse
selection problem' in e.g. medical insurance -- the problem being that high-
risk people are especially likely to seek insurance, which drives up the price
when riskiness is hard for the insurer to discern or if regulation requires a
uniform price regardless of risk)."_

The theory that _"failure to peacefully arbitrate will yield to jointly
destructive warfare, which will be bad for profits"_ can be faulted in two
ways. Firstly, if warfare would be bad for profits, what is to stop a large
"defence association" from ignoring a smaller one's claim? If warfare were
"bad for business," it would be even worse for a small company without the
capital to survive a conflict, which could give big "defence associations" the
leverage to force compliance with their business interests. Price wars are
often bad for business, but companies sometimes start them if they think they
can win. Needless to say, demand would exist for such a service (unless you
assume a transformation in the "human nature" generated by capitalism -- an
unlikely situation and one "anarcho"-capitalists usually deny is required for
their system to work). Secondly -- and this is equally, if not more, likely --
a "balance of power" method to stop warfare has little to recommend it from
history. This can be seen from the First World War and feudal society.

What the "anarcho"-capitalist is describing is essentially a system of
"industrial feudalism" wherein people contract for "protection" with armed
gangs of their choice. Feudal societies have never been known to be peaceful,
even though war is always "unprofitable" for one side or the other or both.
The argument fails to consider that "defence companies," whether they be
called police forces, paramilitaries or full-blown armies, tend to attract the
"martial" type of authoritarian personality, and that this type of "macho"
personality thrives on and finds its reason for existence in armed conflict
and other forms of interpersonal violence and intimidation. Hence feudal
society is continually wracked by battles between the forces of opposing
warlords, because such conflicts allow the combatants a chance to "prove their
manhood," vent their aggression, obtain honours and titles, advance in the
ranks, obtain spoils, etc. The "anarcho" capitalist has given no reason why
warfare among legalised gangs would not continue under industrial feudalism,
except the extremely lame reason that it would not be profitable -- a reason
that has never prevented war in any known feudal society.

It should be noted that the above is not an argument from "original sin."
Feudal societies are characterised by conflict between opposing "protection
agencies" not because of the innate depravity of human beings but because of a
social structure based on private property and hierarchy, which brings out the
latent capacities for violence, domination, greed, etc. that humans have by
creating a financial incentive to be so. But this is not to say that a
different social structure would not bring out latent capacities for much
different qualities like sharing, peaceableness, and co-operation, which human
beings also have. In fact, as Kropotkin argued in **Mutual Aid** and as recent
anthropologists have confirmed in greater detail, ancient societies based on
communal ownership of productive assets and little social hierarchy were
basically peaceful, with no signs of warfare for thousands of years.

However, let us assume that such a competitive system does actually work as
described. Caplan, in effect, argues that competition will generate co-
operation. This is due to the nature of the market in question -- defence (and
so peace) is dependent on firms working together as the commodity "peace"
cannot be supplied by one firm. However, this co-operation does not, for some
reason, become **collusion** between the firms in question. According to
"anarcho"-capitalists this competitive system not only produces co-operation,
it excludes "defence" firms making agreements to fix monopoly profits (i.e.
co-operation that benefits the firms in question). Why does the market produce
beneficial co-operation to everyone but not collusion for the firms in
question? Collusion is when firms have "business relationships" and "negotiate
in good faith" to insure their profitability by agreeing not to compete
aggressively against each other in order to exploit the market. Obviously in
"anarcho"-capitalism the firms in question only use their powers for good!

Needless to say, the "anarcho"-capitalist will object and argue that
competition will ensure that collusion will not occur. However, given that co-
operation is required between all firms in order to provide the commodity
"peace" this places the "anarcho"-capitalist in a bind. As Caplan notes,
"aggressive" firms are _"likely to attract only high-risk clients and thus
suffer from extraordinarily high costs."_ From the perspective of the
colluding firms, a new entry into their market is, by definition, aggressive.
If the colluding firms do not co-operate with the new competitor, then it will
suffer from _"extraordinarily high costs"_ and either go out of business or
join the co-operators. If the new entry could survive in the face of the
colluding firms hostility then so could "bad" defence firms, ones that ignored
the market standards.

So the "anarcho"-capitalist faces two options. Either an "aggressive" firm
cannot survive or it can. If it cannot then the very reason why it cannot
ensures that collusion is built into the market and while the system is
peaceful it is based on an effective monopoly of colluding firms who charge
monopoly profits. This, in effect, is a state under the "anarcho"-capitalist's
definition as a property owner cannot freely select their own "protection" --
they are limited to the firms (and laws) provided by the co-operating firms.
Or an "aggressive" firm can survive, violence is commonplace and chaos
ensures.

Caplan's passing reference to the _"adverse selection problem"_ in medical
insurance suggests another problem with "anarcho"-capitalism. The problem is
that high-risk people are especially likely to seek protection, which drives
up the price for, as "anarcho"-capitalists themselves note, areas with high
crime levels "will be bad for profits," as hardware and personnel costs will
be correspondingly higher. This means that the price for "protection" in areas
which need it most will be far higher than for areas which do not need it. As
poor areas are generally more crime afflicted than rich areas,
"anarcho"-capitalism may see vast sections of the population not able to
afford "protection" (just as they may not be about to afford health care and
other essential services). Indeed, "protection services" which try to provide
cheap services to "high-risk" areas will be at an competitive disadvantage in
relation to those who do not, as the "high-risk" areas will hurt profits and
companies without "high-risk" "customers" could undercut those that have.

Caplan:

> _"Anarcho-capitalists generally give little credence to the view that their
'private police agencies' would be equivalent to today's Mafia -- the cost
advantages of open, legitimate business would make 'criminal police'
uncompetitive. (Moreover, they argue, the Mafia can only thrive in the
artificial market niche created by the prohibition of alcohol, drugs,
prostitution, gambling, and other victimless crimes. Mafia gangs might kill
each other over turf, but liquor-store owners generally do not.)"_

As we have pointed out in [section F.6](secF6.md), the "Mafia" objection to
"anarcho"-capitalist defence companies is a red herring. The biggest problem
would not be "criminal police" but the fact that working people and tenants
would subject to the rules, power and laws of the property owners, the rich
would be able to buy better police protection and "justice" than the poor and
that the "general" law code these companies would defend would be slanted
towards the interests and power of the capitalist class (defending capitalist
property rights and the proprietors power). And as we also noted, such a
system has already been tried in 19th-century and early 20th America, with the
result that the rich reduced the working class to a serf-like existence,
capitalist production undermined independent producers (to the annoyance of
individualist anarchists at the time), and the result was the emergence of the
corporate America that "anarcho"-capitalists say they oppose.

Caplan argues that "liquor-store owners" do not generally kill each other over
turf. This is true (but then again they do not have access to their own
private cops currently so perhaps this could change). But the company owners
who created their own private police forces and armies in America's past
**did** allow their goons to attack and murder union organisers and strikers.
Let us look at Henry Ford's Service Department (private police force) in
action:

> _"In 1932 a hunger march of the unemployed was planned to march up to the
gates of the Ford plant at Dearborn. . . The machine guns of the Dearborn
police and the Ford Motor Company's Service Department killed [four] and
wounded over a score of others. . . Ford was fundamentally and entirely
opposed to trade unions. The idea of working men questioning his prerogatives
as an owner was outrageous. . . [T]he River Rouge plant. . . was dominated by
the autocratic regime of Bennett's service men. Bennett . . organise[d] and
train[ed] the three and a half thousand private policemen employed by Ford.
His task was to maintain discipline amongst the work force, protect Ford's
property [and power], and prevent unionisation. . . Frank Murphy, the mayor of
Detroit, claimed that 'Henry Ford employs some of the worst gangsters in our
city.' The claim was well based. Ford's Service Department policed the gates
of his plants, infiltrated emergent groups of union activists, posed as
workers to spy on men on the line. . . Under this tyranny the Ford worker had
no security, no rights. So much so that any information about the state of
things within the plant could only be freely obtained from ex-Ford workers."_
[Huw Beynon, **Working for Ford**, pp. 29-30]

The private police attacked women workers handing out pro-union handbills and
gave them _"a serve beating."_ At Kansas and Dallas _"similar beatings were
handed out to the union men."_ [**Op. Cit.**, p. 34] This use of private
police to control the work force was not unique. General Motors _"spent one
million dollars on espionage, employing fourteen detective agencies and two
hundred spies at one time [between 1933 and 1936]. The Pinkerton Detective
Agency found anti-unionism its most lucrative activity."_ [**Op. Cit.**, p.
32] We must also note that the Pinkerton's had been selling their private
police services for decades before the 1930s. In the 1870s, they had
infiltrated and destroyed the Molly Maguires (a secret organisation Irish
miners had developed to fight the coal bosses). For over 60 years the
Pinkerton Detective Agency had _"specialised in providing spies, agent
provocateurs, and private armed forces for employers combating labour
organisations."_ By 1892 it _"had provided its services for management in
seventy major labour disputes, and its 2 000 active agents and 30 000 reserves
totalled more than the standing army of the nation."_ [Jeremy Brecher,
**Strike!**, p. 9 and p. 55] With this force available, little wonder unions
found it so hard to survive in the USA. Given that unions could be considered
as "defence" agencies for workers, this suggests a picture of how
"anarcho"-capitalism may work in practice.

It could be argued that, in the end, the union was recognised by the Ford
company. However, this occurred after the New Deal was in place (which helped
the process), after years of illegal activity (by definition union activism on
Ford property was an illegal act) and extremely militant strikes. Given that
the union agreement occurred nearly 40 years after Ford was formed **and** in
a legal situation violently at odds with "anarcho"-capitalism (or even minimal
statist capitalism), we would be justified in wondering if unionisation would
ever have occurred at Ford and if Ford's private police state would ever have
been reformed.

Of course, from an "anarcho"-capitalist perspective the only limitation in the
Ford workers' liberty was the fact they had to pay taxes to the US government.
The regime at Ford could **not** restrict their liberty as no one forced them
to work for the company. Needless to say, an "anarcho"-capitalist would reject
out of hand the argument that no-one forced the citizen to entry or remain in
the USA and so they consented to taxation, the government's laws and so on.

This is more than a history lesson. Such private police forces are on the rise
again (see _"Armed and Dangerous: Private Police on the March"_ by Mike
Zielinski, **Covert Action Quarterly**, no. 54, Fall, 1995 for example). This
system of private police (as demonstrated by Ford) is just one of the hidden
aspects of Caplan's comment that the "anarcho"-capitalist _"typically hails
modern society's increasing reliance on private security guards. . . and other
demonstrations of the free market's ability to supply the defensive and legal
services normally assumed to be of necessity a government monopoly."_

Needless to say, private police states are not a step forward in anarchist
eyes.

Caplan:

> _"Unlike some left-anarchists, the anarcho-capitalist has no objection to
punishing criminals; and he finds the former's claim that punishment does not
deter crime to be the height of naivete. Traditional punishment might be meted
out after a conviction by a neutral arbitrator; or a system of monetary
restitution (probably in conjunction with a prison factory system) might exist
instead."_

Let us note first that in disputes between the capitalist class and the
working class, there would be no _"neutral arbitrator,"_ because the rich
would either own the arbitration company or influence/control it through the
power of the purse (see [section F.6](secF6.md)). In addition, "successful"
arbitrators would also be wealthy, therefore making neutrality even more
unlikely. Moreover, given that the laws the "neutral arbitrator" would be
using are based on capitalist property rights, the powers and privileges of
the owner are built into the system from the start.

Second, the left-libertarian critique of punishment does not rest, as
"anarcho"-capitalists claim, on the naive view that intimidation and coercion
aren't effective in controlling behaviour. Rather, it rests on the premise
that capitalist societies produce large numbers of criminals, whereas
societies based on equality and community ownership of productive assets do
not.

The argument for this is that societies based on private property and
hierarchy inevitably lead to a huge gap between the haves and the have-nots,
with the latter sunk in poverty, alienation, resentment, anger, and
hopelessness, while at the same time such societies promote greed, ambition,
ruthlessness, deceit, and other aspects of competitive individualism that
destroy communal values like sharing, co-operation, and mutual aid. Thus in
capitalist societies, the vast majority of "crime" turns out to be so-called
"crimes against property," which can be traced to poverty and the grossly
unfair distribution of wealth. Where the top one percent of the population
controls more wealth than the bottom 90 percent combined, it is no wonder that
a considerable number of those on the bottom should try to recoup illegally
some of the mal-distributed wealth they cannot obtain legally. (In this they
are encouraged by the bad example of the ruling class, whose parasitic ways of
making a living would be classified as criminal if the mechanisms for defining
"criminal behaviour" were not controlled by the ruling class itself.) And most
of the remaining "crimes against persons" can be traced to the alienation,
dehumanisation, frustration, rage, and other negative emotions produced by the
inhumane and unjust economic system.

Thus it is only in our societies like ours, with their wholesale manufacture
of many different kinds of criminals, that punishment appears to be the only
possible way to discourage "crime." From the left-libertarian perspective,
however, the punitive approach is a band-aid measure that does not get to the
real root of the problem -- a problem that lies in the structure of the system
itself. The real solution is the creation of a non-hierarchical society based
on communal ownership of productive assets, which, by eliminating poverty and
the other negative effects of capitalism, would greatly reduce the incidence
of criminal behaviour and so the need for punitive countermeasures.

Finally, two more points on private prisons. Firstly, as to the desirability
of a "prison factory system," we will merely note that, given the capitalist
principle of "grow-or-die," if punishing crime becomes a business, one can be
sure that those who profit from it will find ways to ensure that the
"criminal" population keeps expanding at a rate sufficient to maintain a high
rate of profit and growth. After all, the logic of a "prison factory system"
is self-defeating. If the aim of prison is to deter crime (as some claim) and
if a private prison system will meet that aim, then a successful private
prison system will stop crime, which, in turn, will put them out of business!
Thus a "prison factory system" cannot aim to be efficient (i.e. stop crime).

Secondly, Caplan does not mention the effect of prison labour on the wages,
job conditions and market position of workers. Having a sizeable proportion of
the working population labouring in prison would have a serious impact on the
bargaining power of workers. How could workers outside of prison compete with
such a regime of labour discipline without submitting to prison-like
conditions themselves? Unsurprisingly, US history again presents some insight
into this. As Noam Chomsky notes, the _"rapid industrial development in the
southeastern region [of America] a century ago was based on (Black) convict
labour, leased to the highest bidder."_ Chomsky quotes expert Alex
Lichtenstein comments that Southern Industrialists pointed out that convict
labour was _"more reliable and productive than free labour"_ and that it
overcomes the problem of labour turnover and instability. It also _"remove[d]
all danger and cost of strikes"_ and that it lowers wages for _"free labour"_
(i.e. wage labour). The US Bureau of Labor reported that _"mine owners [in
Alabama] say they could not work at a profit without the lowering effect in
wages of convict-labour competition."_ [**The Umbrella of US Power**, p. 32]

Needless to say, Caplan fails to mention this aspect of "anarcho"-capitalism
(just as he fails to mention the example of Ford's private police state).
Perhaps an "anarcho"-capitalist will say that prison labour will be less
productive than wage labour and so workers have little to fear, but this makes
little sense. If wage labour is more productive then prison labour will not
find a market (and then what for the prisoners? Will profit-maximising
companies **really** invest in an industry with such high over-heads as
maintaining prisoners for free?). Thus it seems more than likely that any
"prison-factory system" will be as productive as the surrounding wage-labour
ones, thus forcing down their wages and the conditions of labour. For
capitalists this would be ideal, however for the vast majority a different
conclusion must be drawn.

Caplan:

> _"Probably the main division between the anarcho-capitalists stems from the
apparent differences between Rothbard's natural-law anarchism, and David
Friedman's more economistic approach. Rothbard puts more emphasis on the need
for a generally recognised libertarian legal code (which he thinks could be
developed fairly easily by purification of the Anglo-American common law),
whereas Friedman focuses more intently on the possibility of plural legal
systems co-existing and responding to the consumer demands of different
elements of the population. The difference, however, is probably overstated.
Rothbard believes that it is legitimate for consumer demand to determine the
philosophically neutral content of the law, such as legal procedure, as well
as technical issues of property right definition such as water law, mining
law, etc. And Friedman admits that 'focal points' including prevalent norms
are likely to circumscribe and somewhat standardise the menu of available
legal codes."_

>

>

The argument that "consumer demand" would determine a "philosophically
neutral" content of the law cannot be sustained. Any law code will reflect the
philosophy of those who create it. Under "anarcho"-capitalism, as we have
noted (see [section F.6](secF6.md)), the values of the capitalist rich will
be dominant and will shape the law code and justice system, as they do now,
only more so. The law code will therefore continue to give priority to the
protection of private property over human values; those who have the most
money will continue being able to hire the best lawyers; and the best (i.e.
most highly paid) judges will be inclined to side with the wealthy and to rule
in their interests, out of class loyalty (and personal interests).

Moreover, given that the law code exists to protect capitalist property
rights, how can it be "philosophically neutral" with that basis? How would
"competing" property frameworks co-exist? If a defence agency allowed
squatting and another (hired by the property owner) did not, there is no way
(bar force) a conflict could be resolved. Then the firm with the most
resources would win. "Anarcho"-capitalism, in effect, smuggles into the
foundation of their system a distinctly **non**-neutral philosophy, namely
capitalism. Those who reject such a basis may end up sharing the fate of
tribal peoples who rejected that system of property rights, for example, the
Native Americans.

In other words, in terms of outcome the whole system would favour
**capitalist** values and so not be "philosophically neutral." The law would
be favourable to employers rather than workers, manufacturers rather than
consumers, and landlords rather than tenants. Indeed, from the
"anarcho"-capitalist perspective the rules that benefit employers, landlords
and manufacturers (as passed by progressive legislatures or enforced by direct
action) simply define liberty and property rights whereas the rules that
benefit workers, tenants and consumers are simply an interference with
liberty. The rules one likes, in other words, are the foundations of sacred
property rights (and so "liberty," as least for the capitalist and landlord),
those one does not like are meddlesome regulation. This is a very handy trick
and would not be worth mentioning if it was not so commonplace in right-
libertarian theory.

We should leave aside the fantasy that the law under "anarcho"-capitalism is a
politically neutral set of universal rules deduced from particular cases and
free from a particular instrumental or class agenda.

Caplan:

> _"Critics of anarcho-capitalism sometimes assume that communal or worker-
owned firms would be penalised or prohibited in an anarcho-capitalist society.
It would be more accurate to state that while individuals would be free to
voluntarily form communitarian organisations, the anarcho-capitalist simply
doubts that they would be widespread or prevalent."_

There is good reason for this doubt. Worker co-operatives would not be
widespread or prevalent in an "anarcho"-capitalist society for the same reason
that they are not widespread or prevalent now: namely, that the socio-
economic, legal, and political systems would be structured in such as way as
to automatically discourage their growth (in addition, capitalist firms and
the rich would also have an advantage in that they would still own and control
the wealth they currently have which are a result of previous "initiations of
force". This would give them an obvious advantage on the "free-market" -- an
advantage which would be insurmountable).

As we explain in more detail in [ section J.5.11](secJ5.md#secj511), the
reason why there are not more producer co-operatives is partly structural,
based on the fact that co-operatives have a tendency to grow at a slower rate
than capitalist firms. This is a good thing if one's primary concern is, say,
protecting the environment, but fatal if one is trying to survive in a
competitive capitalist environment.

Under capitalism, successful competition for profits is the fundamental fact
of economic survival. This means that banks and private investors seeking the
highest returns on their investments will favour those companies that grow the
fastest. Moreover, in co-operatives returns to capital are less than in
capitalist firms. Under such conditions, capitalist firms will attract more
investment capital, allowing them to buy more productivity-enhancing
technology and thus to sell their products more cheaply than co-operatives.
Even though co-operatives are at least as efficient (usually more so) than
their equivalent capitalist firms, the effect of market forces (particularly
those associated with capital markets) will select against them. This bias
against co-operatives under capitalism is enough to ensure that, despite their
often higher efficiency, they cannot prosper under capitalism (i.e. capitalism
selects the **least efficient** way of producing). Hence Caplan's comments
hide how the effect of inequalities in wealth and power under capitalism
determine which alternatives are "widespread" in the "free market"

Moreover, co-operatives within capitalism have a tendency to adapt to the
dominant market conditions rather than undermining them. There will be
pressure on the co-operatives to compete more effectively by adopting the same
cost-cutting and profit-enhancing measures as capitalist firms. Such measures
will include the deskilling of workers; squeezing as much "productivity" as is
humanly possible from them; and a system of pay differentials in which the
majority of workers receive low wages while the bulk of profits are reinvested
in technology upgrades and other capital expansion that keeps pace with
capitalist firms. But this means that in a capitalist environment, there tend
to be few practical advantages for workers in collective ownership of the
firms in which they work.

This problem can only be solved by eliminating private property and the
coercive statist mechanisms required to protect it (including private states
masquerading as "protection companies"), because this is the only way to
eliminate competition for profits as the driving force of economic activity.
In a libertarian socialist environment, federated associations of workers in
co-operative enterprises would co-ordinate production for **use** rather than
profit, thus eliminating the competitive basis of the economy and so also the
"grow-or-die" principle which now puts co-operatives at a fatal economic
disadvantage. (For more on how such an economy would be organised and
operated, as well as answers to objections, see [section I](secIcon.md).)

And let us not forget what is implied by Caplan's statement that the
"anarcho"-capitalist does not think that co-operative holding of "property"
"would be widespread or prevalent." It means that the vast majority would be
subject to the power, authority and laws of the property owner and so would
not govern themselves. In other words, it would a system of private statism
rather than anarchy.

Caplan:

> _"However, in theory an 'anarcho-capitalist' society might be filled with
nothing but communes or worker-owned firms, so long as these associations were
formed voluntarily (i.e., individuals joined voluntarily and capital was
obtained with the consent of the owners) and individuals retained the right to
exit and set up corporations or other profit-making, individualistic firms."_

It's interesting that the "anarcho"-capitalists are willing to allow workers
to set up "voluntary" co-operatives so long as the conditions are retained
which ensure that such co-operatives will have difficulty surviving (i.e.
private property and private states), but they are unwilling to allow workers
to set up co-operatives under conditions that would ensure their success (i.e.
the absence of private property and private states). This reflects the usual
vacuousness of the right-libertarian concepts of "freedom" and "voluntarism."

In other words, these worker-owned firms would exist in and be subject to the
same capitalist _"general libertarian law code"_ and work in the same
capitalist market as the rest of society. So, not only are these co-operatives
subject to capitalist market forces, they exist and operate in a society
defined by capitalist laws. As discussed in [section F.2](secF2.md), such
disregard for the social context of human action shows up the "anarcho"
capitalist's disregard for meaningful liberty.

All Caplan is arguing here is that as long as people remain within the
(capitalist) "law code," they can do whatever they like. However, what
determines the amount of coercion required in a society is the extent to which
people are willing to accept the rules imposed on them. This is as true of an
"anarcho"-capitalist society as it is of any other. In other words, if more
and more people reject the basic assumptions of capitalism, the more coercion
against anarchistic tendencies will be required. Saying that people would be
free to experiment under "anarcho"-capitalist law (if they can afford it, of
course) does not address the issue of changes in social awareness (caused, by
example, by class struggle) which can make such "laws" redundant. So, when all
is said and done, "anarcho"-capitalism just states that as long as you accept
their rules, you are free to do what you like.

How generous of them!

Thus, while we would be allowed to be collective capitalists or property
owners under "anarcho"-capitalists we would have no choice about living under
laws based on the most rigid and extreme interpretation of property rights
available. In other words, "anarcho"-capitalists recognise (at least
implicitly) that there exists one collective need that needs collective
support -- a law system to define and protects people's rights. Ultimately, as
C.B. Macpherson argues, "Individualism" implies "collectivism" for the
_"notion that individualism and 'collectivism' are the opposite ends of a
scale along which states and theories of the state can be arranged . . . is
superficial and misleading. . . . [I]ndividualism . . . does not exclude but
on the contrary demands the supremacy of the state [or law] over the
individual. It is not a question of the more individualism, the less
collectivism; rather, the more through-going the individualism, the more
complete the collectivism. Of this the supreme illustration is Hobbes's
theory."_ [**The Political Theory of Possessive Individualism**, p.256] Under
"anarcho"-capitalism the individual is subject to the laws regarding private
property, laws decided in advance by a small group of ideological leaders.
Then real individuals are expected to live with the consequences as best they
can, with the law being placed ahead of these consequences for flesh and blood
people. The abstraction of the law dominates and devours real individuals, who
are considered below it and incapable of changing it (except for the worse).
This, from one angle, shares a lot with theocracy and very little with
liberty.

Needless to say, Caplan like most (if not all) "anarcho"-capitalists assume
that the current property owners are entitled to their property. However, as
John Stuart Mill pointed out over 100 years ago, the _"social arrangements"_
existing today _"commenced from a distribution of property which was the
result, not of a just partition, or acquisition by industry, but of conquest
and violence . . . [and] the system still retains many and large traces of its
origin."_ [**Principles of Political Economy**, p. 15] Given that (as we point
out in [section F.1](secF1.md)) Murray Rothbard argues that the state cannot
be claimed to own its territory simply because it did not acquire its property
in a "just" manner, this suggests that "anarcho"-capitalism cannot actually
argue against the state. After all, property owners today cannot be said to
have received their property "justly" and **if** they are entitled to it so is
the state to **its** "property"!

But as is so often the case, property owners are exempt from the analysis the
state is subjected to by "anarcho"-capitalists. The state and property owners
may do the same thing (such as ban freedom of speech and association or
regulate individual behaviour) but only the state is condemned by
"anarcho"-capitalism.

Caplan:

> _"On other issues, the anarcho-capitalist differs little if at all from the
more moderate libertarian. Services should be privatised and opened to free
competition; regulation of personal AND economic behaviour should be done away
with."_

>

>

The "anarcho"-capitalist's professed desire to "do away" with the "regulation"
of economic behaviour is entirely disingenuous. For, by giving capitalists the
ability to protect their exploitative monopolies of social capital by the use
of coercive private states, one is thereby "regulating" the economy in the
strongest possible way, i.e. ensuring that it will be channelled in certain
directions rather than others. For example, one is guaranteeing that
production will be for profit rather than use; that there will consequently be
runaway growth and an endless devouring of nature based on the principle of
"grow or die;" and that the alienation and deskilling of the workforce will
continue. What the "anarcho"-capitalist really means by "doing away with the
regulation of economic behaviour" is that ordinary people will have even less
opportunity than now to democratically control the rapacious behaviour of
capitalists. Needless to say, the "regulation of personal" behaviour would
**not** be done away with in the workplace, where the authority of the bosses
would still exist and you would have follow their petty rules and regulations.

Moreover, regardless of "anarcho"-capitalist claims, they do not, in fact,
support civil liberties or oppose "regulation" of personal behaviour as such.
Rather, they **support** property owners suppressing civil liberties on their
property and the regulation of personal behaviour by employers and landlords.
This they argue is a valid expression of property rights. Indeed, any attempts
to allow workers civil liberties or restrict employers demands on workers by
state or union action is denounced as a violation of "liberty" (i.e. the power
of the property owner). Those subject to the denial of civil liberties or the
regulation of their personal behaviour by landlords or employees can "love it
or leave it." Of course, the same can be said to any objector to state
oppression -- and frequently is. This is an artificial double standard, which
labels a restraint by one group or person in a completely different way than
the same restraint by others simply because one is called "the government" and
the other is not.

This denial of civil liberties can be seen from these words by Murray
Rothbard:

> _"[I]n the profoundest sense there are no rights but property rights . . .
Freedom of speech is supposed to mean the right of everyone to say whatever he
likes. But the neglected question is: Where? Where does a man have this right?
He certainly does not have it on property on which he is trespassing. In
short, he has this right only either on his own property or on the property of
someone who has agreed, as a gift or in a rental contract, to allow him in the
premises. In fact, then, there is no such thing as a separate 'right to free
speech'; there is only a man's property right: the right to do as he wills
with his own or to make voluntary agreements with other property owners."_
[Murray Rothbard, **Power and Market**, p. 176]

Of course, Rothbard fails to see that for the property-less such a regime
implies **no** rights whatsoever. It also means the effective end of free
speech and free association as the property owner can censor those on their
property (such as workers or tenants) and ban their organisations (such as
unions). Of course, in his example Rothbard looks at the "trespasser," **not**
the wage worker or the tenant (two far more common examples in any modern
society). Rothbard is proposing the dictatorship of the property owner and the
end of civil liberties and equal rights (as property is unequally
distributed). He gives this utter denial of liberty an Orwellian twist by
proclaiming the end of civil liberties by property rights as "a new liberty."
Perhaps for the property-owner, but not the wage worker -- _"We who belong to
the proletaire class, property excommunicates us!"_ [Proudhon, **What is
Property?**, p. 137]

In effect, right-Libertarians do not care how many restrictions are placed on
you as long as it is not the government doing it. Of course it will be claimed
that workers and tenants "consent" to these controls (although they reject the
notion that citizens "consent" to government controls by not leaving their
state). Here the libertarian case is so disingenuous as to be offensive. There
is no symmetry in the situations facing workers and firms. To the worker, the
loss of a job is often far more of a threat than the loss of one worker is to
the firm. The reality of economic power leads people to contract into
situations that, although they are indeed the "best" arrangements of those
available, are nonetheless miserable. In any real economy -- and, remember,
the right-libertarian economy lacks any social safety net, making workers'
positions more insecure than now -- the right-libertarian denial of economic
power is a delusion.

Unlike anarchist theory, right-libertarian theory provides **no** rationale to
protest private power (or even state power if we accept the notion that the
state owns its territory). Relations of domination and subjection are valid
expressions of liberty in their system and, perversely, attempts to resist
authority (by strikes, unions, resistance) are deemed "initiations of force"
upon the oppressor! In contrast, anarchist theory provides a strong rationale
for resisting private and public domination. Such domination violates freedom
and any free association which dominates any within it violates the basis of
that association in self-assumed obligation (see [section
A.2.11](secA2.md#seca211)). Thus Proudhon:

> _"The social contract should increase the well-being and liberty of every
citizen. -- If any one-sided conditions should slip in; if one part of the
citizens should find themselves, by the contract, subordinated and exploited
by others, it would no longer be a contract; it would be a fraud, against
which annulment might at any time by invoked justly."_ [**The General Idea of
the Revolution**, p. 114]

Caplan's claim that right libertarians oppose regulation of individual
behaviour is simply not true. They just oppose state regulation while
supporting private regulation wholeheartedly. Anarchists, in contrast, reject
both public and private domination.

Caplan:

> _"Poverty would be handled by work and responsibility for those able to care
for themselves, and voluntary charity for those who cannot. (Libertarians
hasten to add that a deregulated economy would greatly increase the economic
opportunities of the poor, and elimination of taxation would lead to a large
increase in charitable giving.)"_

>

>

Notice the implication that poverty is now caused by laziness and
irresponsibility rather than by the inevitable workings of an economic system
that **requires** a large _"reserve army of the unemployed"_ as a condition of
profitability. The continuous "boom" economy of "anarcho"-capitalist fantasies
is simply incompatible with the fundamental principles of capitalism. To re-
quote Michael Kalecki (from [section B.4.4](secB4.md#secb44)), _"[l]asting
full employment is not at all to [the] liking [of business leaders]. The
workers would 'get out of hand' and the 'captains of industry' would be
anxious 'to teach them a lesson'"_ as _"'discipline in the factories' and
`political stability' are more appreciated by business leaders than profits.
Their class interest tells them that lasting full employment is unsound from
their point of view and that unemployment is an integral part of the 'normal'
capitalist system."_. See section C.7 (["What causes the capitalist business
cycle?"](secC7.md)) for a fuller discussion of this point.

In addition, the claims that a "deregulated economy" would benefit the poor do
not have much empirical evidence to back them up. If we look at the last
quarter of the twentieth century we discover that a more deregulated economy
has lead to massive increases in inequality and poverty. If a movement towards
a deregulated economy has had the opposite effect than that predicted by
Caplan, why should a totally deregulated economy have the opposite effect. It
is a bit like claiming that while adding black paint to grey makes it more
black, adding the whole tin will make it white!

The reason for increased inequality and poverty as a result of increased
deregulation is simple. A "free exchange" between two people will benefit the
stronger party. This is obvious as the economy is marked by power, regardless
of "anarcho"-capitalist claims, and any "free exchange" will reflect
difference in power. Moreover, a series of such exchanges will have an
accumulative effect, with the results of previous exchanges bolstering the
position of the stronger party in the current exchange.

Moreover, the claim that removing taxation will **increase** donations to
charity is someone strange. We doubt that the rich who object to money being
taken from them to pay for welfare will **increase** the amount of money they
give to others if taxation **was** abolished. As Peter Sabatini points out,
"anarcho"-capitalists _"constantly rant and shriek about how the government,
or the rabble, hinders their Lockean right to amass capital."_ [**Social
Anarchism**, no. 23, p.101] Caplan seems to expect them to turn over a new
leaf and give **more** to that same rabble!

[‹ Replies to Some Errors and Distortions in Bryan Caplan's "Anarchist Theory
FAQ" version 5.2](append11.md "Go to previous page" ) [up](append1.md "Go
to parent page" ) [Appendix - Is "anarcho"-capitalism a type of anarchism?
›](append13.md "Go to next page" )

