/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.classfile.attribute;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.cojen.classfile.Attribute;
import org.cojen.classfile.ConstantPool;
import org.cojen.classfile.constant.ConstantClassInfo;

public class ExceptionsAttr
extends Attribute {
    private List<ConstantClassInfo> mExceptions = new ArrayList<ConstantClassInfo>(2);

    public ExceptionsAttr(ConstantPool cp) {
        super(cp, "Exceptions");
    }

    public ExceptionsAttr(ConstantPool cp, String name) {
        super(cp, name);
    }

    public ExceptionsAttr(ConstantPool cp, String name, int length, DataInput din) throws IOException {
        super(cp, name);
        int size = din.readUnsignedShort();
        length -= 2;
        for (int i = 0; i < size; ++i) {
            int index = din.readUnsignedShort();
            length -= 2;
            ConstantClassInfo info = (ConstantClassInfo)cp.getConstant(index);
            this.addException(info);
        }
        ExceptionsAttr.skipBytes(din, length);
    }

    public ConstantClassInfo[] getExceptions() {
        return this.mExceptions.toArray(new ConstantClassInfo[this.mExceptions.size()]);
    }

    public void addException(ConstantClassInfo type) {
        this.mExceptions.add(type);
    }

    public int getLength() {
        return 2 + 2 * this.mExceptions.size();
    }

    public void writeDataTo(DataOutput dout) throws IOException {
        int size = this.mExceptions.size();
        dout.writeShort(size);
        for (int i = 0; i < size; ++i) {
            ConstantClassInfo info = this.mExceptions.get(i);
            dout.writeShort(info.getIndex());
        }
    }
}

