# -*- coding: utf-8 -*-
# Balazar in the Rancid Skull Dungeon
# Copyright (C) 2008 Jean-Baptiste LAMY
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import os, os.path, random
import cerealizer

from balazar3.rooms            import *
from balazar3.rooms.rooms_defs import *
from balazar3.game             import *
import balazar3.globdef as globdef
import balazar3.tofu    as tofu

DUNGEON = None

def load_dungeon():
  global DUNGEON
  filename = os.path.join(globdef.SAVED_GAME_DIR, tofu.GAME, "dungeon.data")
  if os.path.exists(filename): DUNGEON = cerealizer.load(open(filename))
  else:                        DUNGEON = Dungeon()
  DUNGEON.path = os.path.join(globdef.SAVED_GAME_DIR, tofu.GAME)
  
class Dungeon(object):
  def __init__(self):
    self.path  = ""
    self.rooms = {"0_0" : "17"}
    
  def save(self):
    if self.path: cerealizer.dump(self, open(os.path.join(self.path, "dungeon.data"), "wb"))

  def delete(self):
    if self.path:
      for level_file in os.listdir(os.path.join(self.path, "levels")):
        level_file = os.path.join(self.path, "levels", level_file)
        print "* Balazar 3 * Remove level file %s..." % level_file
        os.remove(level_file)

      dungeon_filename = os.path.join(self.path, "dungeon.data")
      if os.path.exists(dungeon_filename):
        print "* Balazar 3 * Remove dungeon file %s..." % dungeon_filename
        os.remove(dungeon_filename)
        
      self.path = ""
      
  def random_level(self, level):
    I = level.I
    J = level.J
    
    rooms = set(all_rooms)
    left  = self.rooms.get("%s_%s" % (I - 1, J))
    right = self.rooms.get("%s_%s" % (I + 1, J))
    up    = self.rooms.get("%s_%s" % (I, J + 1))
    down  = self.rooms.get("%s_%s" % (I, J - 1))
    if left:
      if (Room.get(left ).blocs[6][3] == 2): rooms.intersection_update(left_open_rooms)
      else:                                  rooms.difference_update  (left_open_rooms)
    if right:
      if (Room.get(right).blocs[0][3] == 2): rooms.intersection_update(right_open_rooms)
      else:                                  rooms.difference_update  (right_open_rooms)
    if up:
      if (Room.get(up   ).blocs[3][0] == 2): rooms.intersection_update(up_open_rooms)
      else:                                  rooms.difference_update  (up_open_rooms)
    if down:
      if (Room.get(down ).blocs[3][6] == 2): rooms.intersection_update(down_open_rooms)
      else:                                  rooms.difference_update  (down_open_rooms)
      
    room_name = self.rooms[level.filename] = random.choice(list(rooms))
    level.room = Room.get(room_name)
    
    nb_monster = random.choice(level.room.nb_monster)
    
    for k in range(nb_monster):
      monster = random.choice(level.room.monster_classes)()
      i = random.randint(0, len(level.room.monster_places) - 1)
      monster.i, monster.j = level.room.monster_places.pop(i)
      monster.angle        = random.random() * 360.0
      level.add_mobile(monster)
      
    for proba, Trap, i, j in level.room.traps:
      if random.random() <= proba:
        trap = Trap()
        trap.i = i ; trap.j = j
        level.add_mobile(trap)

cerealizer.register(Dungeon)

