# -*- coding: utf-8 -*-
# Balazar in the Rancid Skull Dungeon
# Copyright (C) 2008 Jean-Baptiste LAMY
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import os, os.path, gettext, socket

VERSION = "0.1"
APPDIR  = os.path.dirname(__file__)


translator = None
LOCALEDIR = os.path.join(APPDIR, "locale")
try: translator = gettext.translation("balazar3", LOCALEDIR)
except IOError:
  
  LOCALEDIR = os.path.join(APPDIR, "..", "locale")
  try: translator = gettext.translation("balazar3", LOCALEDIR)
  except IOError:
    
    LOCALEDIR = os.path.join("/", "usr", "share", "locale")
    try: translator = gettext.translation("balazar3", LOCALEDIR)
    except IOError:
      
      # Non-supported language, defaults to english
      LOCALEDIR = os.path.join(APPDIR, "locale")
      try: translator = gettext.translation("balazar3", LOCALEDIR, ("en",))
      except IOError:
        
        LOCALEDIR = os.path.join(APPDIR, "..", "locale")
        try: translator = gettext.translation("balazar3", LOCALEDIR, ("en",))
        except IOError:
          
          LOCALEDIR = os.path.join("/", "usr", "share", "locale")
          translator = gettext.translation("balazar3", LOCALEDIR, ("en",))
      
translator.install(1)

DRIVER = "3d"

FULLSCREEN    = 0
SCREEN_WIDTH  = 800
SCREEN_HEIGHT = 600
MIN_FRAME_DURATION = 0.025

QUALITY = 1

CLIENT_HOST = "localhost"
CLIENT_PORT = 6902

SERVER_HOST = socket.gethostname()
SERVER_PORT = 6902

SOUND_VOLUME = 1.0
MUSIC = True

ZAURUS = 0

# Check for ".balazar3" config file
CONFIG_FILE = os.path.expanduser(os.path.join("~", ".balazar3"))
if CONFIG_FILE[0] == "~": # Fucking winedaube OS !!!
  CONFIG_FILE = "C:\\.balazar3" # Random name...
  


try:
  import getpass
  SINGLE_LOGIN = CLIENT_LOGIN = getpass.getuser()
except:
  SINGLE_LOGIN = CLIENT_LOGIN = "Player"

# tofu.HOST           = ""
# tofu.PORT           = 6919
SAVED_GAME_DIR = os.path.expanduser(os.path.join("~", ".balazar3_v%s_saves" % VERSION))
if SAVED_GAME_DIR[0] == "~": # Fucking winedaube OS !!!
  SAVED_GAME_DIR = "C:\\balazar3_v%s_saves" % VERSION

SAVED_GAME_DIR ="/tmp/balazar3_v%s_saves" % VERSION

if os.path.exists(CONFIG_FILE):
  try:
    execfile(CONFIG_FILE)
  except:
    import sys
    sys.excepthook(*sys.exc_info())
    print """* Balazar 3 * Error in config file %s !
Please reconfigure the game !
Config file ignored.
""" % CONFIG_FILE




def save_config():
  f = open(CONFIG_FILE, "w")
  f.write("""
FULLSCREEN        = %(FULLSCREEN)s
SCREEN_WIDTH      = %(SCREEN_WIDTH)s
SCREEN_HEIGHT     = %(SCREEN_HEIGHT)s
QUALITY           = %(QUALITY)s

SOUND_VOLUME      = %(SOUND_VOLUME)s
MUSIC             = %(MUSIC)s

SAVED_GAME_DIR    = '%(SAVED_GAME_DIR)s'
SINGLE_LOGIN      = '%(SINGLE_LOGIN)s'
CLIENT_LOGIN      = '%(CLIENT_LOGIN)s'

CLIENT_HOST       = '%(CLIENT_HOST)s'
CLIENT_PORT       = %(CLIENT_PORT)s

SERVER_HOST       = '%(SERVER_HOST)s'
SERVER_PORT       = %(SERVER_PORT)s

ZAURUS            = %(ZAURUS)s

DRIVER            = '%(DRIVER)s'

""" % globals())
#  f.write("""
#tofu.HOST           = '%s'
#tofu.PORT           = %s
#tofu.SAVED_GAME_DIR = '%s'
#""" % (tofu.HOST, tofu.PORT, tofu.SAVED_GAME_DIR))
  
LIMIT_FPS = 1

SINGLE_PASSWORD = "x"
CLIENT_PASSWORD = "x"


# Find an available driver
AVAILABLE_DRIVERS = ["3d", "2d", "2d800x480"]

if not DRIVER in AVAILABLE_DRIVERS:
  DRIVER = AVAILABLE_DRIVERS[0]
  
