SET(CPACK_PACKAGE_NAME "BALL")
SET(CPACK_PACKAGE_VENDOR "ball-project.org")
SET(CPACK_PACKAGE_DESCRIPTION_SUMMARY "BALL - The Biochemical Algorithms Library")
SET(CPACK_PACKAGE_VERSION "${CF_BALL_PACKAGE_VERSION}")
SET(CPACK_PACKAGE_VERSION_MAJOR "${BALL_PACKAGE_VERSION_MAJOR}")
SET(CPACK_PACKAGE_VERSION_MINOR "${BALL_PACKAGE_VERSION_MINOR}")
SET(CPACK_PACKAGE_VERSION_PATCH "${BALL_PACKAGE_VERSION_PATCH}")
SET(CPACK_PACKAGE_INSTALL_DIRECTORY "BALL-${CPACK_PACKAGE_VERSION}")
SET(CPACK_PACKAGE_DESCRIPTION_FILE "${PROJECT_SOURCE_DIR}/cmake/installer/Welcome.rtf")
SET(CPACK_RESOURCE_FILE_LICENSE "${PROJECT_SOURCE_DIR}/cmake/installer/COPYRIGHT.txt")
SET(CPACK_RESOURCE_FILE_WELCOME "${PROJECT_SOURCE_DIR}/cmake/installer/Welcome.rtf")

IF (WIN32 AND NOT UNIX)
	IF (CMAKE_SIZEOF_VOID_P EQUAL 8)
		SET(CPACK_NSIS_INSTALL_ROOT "$PROGRAMFILES64")
	ENDIF()
	SET(CPACK_NSIS_MUI_ICON "${PROJECT_SOURCE_DIR}\\\\data\\\\graphics\\\\ballview.ico")
	SET(CPACK_NSIS_MUI_UNIICON "${PROJECT_SOURCE_DIR}\\\\data\\\\graphics\\\\ballview.ico")
	SET(CPACK_PACKAGE_ICON "${PROJECT_SOURCE_DIR}\\\\data\\\\graphics\\\\installer_header.bmp")
	SET(CPACK_NSIS_INSTALLED_ICON_NAME "bin\\\\BALLView.exe")
	IF (BALL_HAS_RTFACT)
		SET(CPACK_PACKAGE_NAME "BALL-RT")
		SET(CPACK_NSIS_DISPLAY_NAME "BALLView-RT-${CPACK_PACKAGE_VERSION}")
	ELSE()
		SET(CPACK_NSIS_DISPLAY_NAME "BALLView-${CPACK_PACKAGE_VERSION}")
	ENDIF()
	SET(CPACK_NSIS_HELP_LINK "http:\\\\\\\\www.ball-project.org")
	SET(CPACK_NSIS_URL_INFO_ABOUT "http:\\\\\\\\www.ball-project.org")
	SET(CPACK_NSIS_CONTACT "ball@bioinf.uni-sb.de")
	SET(CPACK_NSIS_EXTRA_INSTALL_COMMANDS "NOT-FOUND")
	SET(CPACK_NSIS_EXTRA_UNINSTALL_COMMANDS "NOT-FOUND")
	FILE(READ "${PROJECT_SOURCE_DIR}/cmake/NSISExtraInstallCommands.cmake" CPACK_NSIS_EXTRA_INSTALL_COMMANDS)
	FILE(READ "${PROJECT_SOURCE_DIR}/cmake/NSISExtraUninstallCommands.cmake" CPACK_NSIS_EXTRA_UNINSTALL_COMMANDS)
	IF (PYTHON_INSTALLER)
		CONFIGURE_FILE(${PROJECT_SOURCE_DIR}/cmake/NSISEmbeddedInstallers.cmake.in ${PROJECT_BINARY_DIR}/NSISEmbeddedInstallers.nsh)
		SET(CPACK_NSIS_EMBEDDED_INSTALLERS "!Include ..\\\\..\\\\..\\\\NSISEmbeddedInstallers.nsh")
	ENDIF()
	# NOTE: CPack overwrites this option, so it is currently ignored *sigh*. Thus, we use
	#       our own NSIS template
	SET(CPACK_NSIS_DEFINES "  RequestExecutionLevel highest")
	SET(CPACK_NSIS_EXTRA_DEFINES "  RequestExecutionLevel highest")
ELSEIF(APPLE)
	SET(CPACK_GENERATOR PackageMaker)
	SET(CPACK_BUNDLE_NAME BALLView)
	SET(CPACK_BUNDLE_ICON "${PROJECT_SOURCE_DIR}/cmake/installer/BALLView.icns")
	SET(CPACK_BUNDLE_STARTUP_COMMAND ${PROJECT_SOURCE_DIR}/cmake/installer/BALLView.sh)
	SET(CPACK_PACKAGING_INSTALL_PREFIX /)

	CONFIGURE_FILE(${PROJECT_SOURCE_DIR}/cmake/installer/postflight.in ${PROJECT_BINARY_DIR}/postflight.sh)
	SET(CPACK_POSTFLIGHT_SCRIPT ${PROJECT_BINARY_DIR}/postflight.sh)
ELSE()
	SET(CPACK_STRIP_FILES "bin/BALLView bin/libBALL.so bin/libVIEW.so")
ENDIF()

SET(CPACK_PROJECT_CONFIG_FILE "${PROJECT_SOURCE_DIR}/cmake/BALLPackageConfigOptions.cmake")

SET(CPACK_PACKAGE_EXECUTABLES ${BALL_EXECUTABLES})
INCLUDE(CPack)
