/*
 * Decompiled with CFR 0.152.
 */
package yuku.alkitab.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;

public class OptionalGzipInputStream
extends InputStream {
    InputStream wrapper;

    public OptionalGzipInputStream(InputStream source) throws IOException {
        PeekInputStream peek = new PeekInputStream(source);
        int first = peek.getFirstByte();
        int second = peek.getSecondByte();
        if (first == 31 && second == 139) {
            try {
                this.wrapper = new GZIPInputStream(peek);
            }
            catch (EOFException e) {
                this.wrapper = peek;
            }
        } else {
            this.wrapper = peek;
        }
    }

    @Override
    public int read() throws IOException {
        return this.wrapper.read();
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.wrapper.read(buffer);
    }

    @Override
    public int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
        return this.wrapper.read(buffer, byteOffset, byteCount);
    }

    @Override
    public void close() throws IOException {
        this.wrapper.close();
    }

    static class PeekInputStream
    extends InputStream {
        private final InputStream source;
        int pos = 0;
        int len = -1;
        int firstByte;
        int secondByte;

        PeekInputStream(InputStream source) throws IOException {
            this.source = source;
            this.firstByte = source.read();
            this.secondByte = source.read();
            if (this.firstByte == -1) {
                this.len = 0;
            } else if (this.secondByte == -1) {
                this.len = 1;
            }
        }

        public int getFirstByte() {
            return this.firstByte;
        }

        public int getSecondByte() {
            return this.secondByte;
        }

        @Override
        public int read() throws IOException {
            if (this.len == 0) {
                return -1;
            }
            if (this.len == 1) {
                if (this.pos == 0) {
                    ++this.pos;
                    return this.firstByte;
                }
                return -1;
            }
            if (this.pos == 0) {
                ++this.pos;
                return this.firstByte;
            }
            if (this.pos == 1) {
                ++this.pos;
                return this.secondByte;
            }
            ++this.pos;
            return this.source.read();
        }

        @Override
        public int read(byte[] buffer) throws IOException {
            return this.read(buffer, 0, buffer.length);
        }

        @Override
        public int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
            int remainingToRead;
            int newOffset;
            if (byteCount == 0) {
                return 0;
            }
            if (byteCount == 1) {
                int b = this.read();
                if (b == -1) {
                    return -1;
                }
                buffer[byteOffset] = (byte)b;
                return 1;
            }
            if (this.len == 0) {
                return -1;
            }
            if (this.len == 1 && this.pos == 0) {
                int b = this.read();
                buffer[byteOffset] = (byte)b;
                return 1;
            }
            if (this.len == 1) {
                return -1;
            }
            if (this.pos == 0) {
                buffer[byteOffset] = (byte)this.firstByte;
                buffer[byteOffset + 1] = (byte)this.secondByte;
                this.pos = 2;
                newOffset = byteOffset + 2;
                remainingToRead = byteCount - 2;
            } else if (this.pos == 1) {
                buffer[byteOffset] = (byte)this.secondByte;
                this.pos = 2;
                newOffset = byteOffset + 1;
                remainingToRead = byteCount - 1;
            } else {
                newOffset = byteOffset;
                remainingToRead = byteCount;
            }
            int read = this.source.read(buffer, newOffset, remainingToRead);
            if (read == -1) {
                int res = newOffset - byteOffset;
                if (res == 0) {
                    return -1;
                }
                return res;
            }
            return read + newOffset - byteOffset;
        }

        @Override
        public void close() throws IOException {
            this.source.close();
        }
    }
}

