//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Model/Beam/BeamAngleItems.h
//! @brief     Defines class BeamAngleItems
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_MODEL_BEAM_BEAMANGLEITEMS_H
#define BORNAGAIN_GUI_MODEL_BEAM_BEAMANGLEITEMS_H

#include "GUI/Model/Beam/BeamDistributionItem.h"

class BeamAzimuthalAngleItem : public BeamDistributionItem {
public:
    BeamAzimuthalAngleItem();

    void readFrom(QXmlStreamReader* r) override;

    double azimuthalAngle() const;
    double scaleFactor() const override;

private:
    static void initDistribution(DistributionItem* newDistribution,
                                 const DistributionItem* currentDistribution);
};

class BeamInclinationAngleItem : public BeamDistributionItem {
public:
    BeamInclinationAngleItem();

    void readFrom(QXmlStreamReader* r) override;

    double inclinationAngle() const;
    double scaleFactor() const override;

private:
    static void initDistribution(DistributionItem* newDistribution,
                                 const DistributionItem* currentDistribution);
};

#endif // BORNAGAIN_GUI_MODEL_BEAM_BEAMANGLEITEMS_H
