#!/bin/sh
#
#  A simple webcam application using webgrab to produce a timestamped
# image.
#
#  This tool requires that the imagemagick package is installed to perform
# the time stamping of the image..
#
# Steve
# --
# www.steve.org.uk
#


#  The ultimate destination for the shot.
output=/var/www/shot.jpg

#  A temporary location.
tempfile=/tmp/cam.jpg



while true ; do
  # Remove any existing file
  /bin/rm "$tempfile"

  # Get a temporary file
  ./camgrab -device "/dev/video" -output "$tempfile"
  
  # Image stamp it if `convert` is installed.
  if [ -e /usr/bin/convert ]; then
     convert -font helvetica -fill black -draw "text 10, 280 '`date`'" "$tempfile"  "$tempfile"
  fi

  # Move it into position.
  /bin/mv "$tempfile" "$output"

  # Pause
  sleep 5;

done
