/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/


//
// $Id: GlobalUtilities.H,v 1.20 2002/12/10 20:12:23 vince Exp $
//

// ---------------------------------------------------------------
// GlobalUtilities.H
// ---------------------------------------------------------------
#ifndef _GLOBALUTILITIES_H_
#define _GLOBALUTILITIES_H_

#include "AmrvisConstants.H"
#include "Box.H"
#include "Array.H"

#include <list>
#include <string>
using std::list;
using std::string;


namespace AVGlobals {

  Box GetBoxFromCommandLine();
  void SetMaxPictureSize(int size);
  int  MaxPictureSize();
  int  MaxPaletteIndex();
  void SetVerbose();
  bool Verbose();
  void ParseCommandLine(int, char **);
  void GetDefaults(const string &defaultsfilename);
  bool ReadLightingFile(const string &lightdefaultsfilename,
		        Real &ambientDef, Real &diffuseDef, Real &specularDef,
		        Real &shinyDef,
		        Real &minRayOpacityDef, Real &maxRayOpacityDef);
  bool WriteLightingFile(const string &lightdefaultsfilename,
		         const Real &ambientDef, const Real &diffuseDef,
		         const Real &specularDef, const Real &shinyDef,
		         const Real &minRayOpacityDef,
			 const Real &maxRayOpacityDef);
  void SetAnimation();
  bool IsAnimation();
  void SetSGIrgbFile();
  void ClearSGIrgbFile();
  bool IsSGIrgbFile();
  int GetFileCount();
  int SleepTime();
  const string &GetComlineFilename(int index);
  string StripSlashes(const string &inString);
  FileType GetDefaultFileType();
  bool GivenBox();
  bool GivenBoxSlice();
  bool GivenFilename();
  int GetFileCount();
  bool MakeSWFData();
  bool MakeSWFLight();
  bool LowBlack();
  bool UseSpecifiedMinMax();
  void SetSpecifiedMinMax(Real  specifiedmin, Real  specifiedmax);
  void GetSpecifiedMinMax(Real &specifiedmin, Real &specifiedmax);
  int CRRBetweenLevels(int fromlevel, int tolevel, const Array<int> &refratios);
  int DetermineMaxAllowableLevel(const Box &finebox, int finestlevel,
			         int maxpoints, const Array<int> &refratios);

  void SetBoundaryWidth(int width);
  int  GetBoundaryWidth();
  void SetSkipPltLines(int nlines);
  int  GetSkipPltLines();
  bool UseMaxLevel();
  int  GetMaxLevel();
  void SetBoxColor(int boxcolor);
  int  GetBoxColor();

  void SetInitialDerived(const string &formatString);
  const string &GetInitialDerived();
  const string &GetPaletteName();
  const string &GetLightingFileName();

  bool DumpSlices();
  bool SliceAllVars();
  Array< list<int> > &GetDumpSlices();
  int  GetFabOutFormat();

  // -------------------- cartGrid functions
  void SetShowBody(const bool btf);
  bool GetShowBody();

  #define SHOWVAL(val) { cout << #val << " = " << val << endl; }  // Jensens device
  #define VSHOWVAL(verbose, val) { if(verbose) { \
		   cout << #val << " = " << val << endl; } }

}  // end namespace AVGlobals
#endif
