from __future__ import absolute_import, division, print_function

from libtbx import easy_run
import time
import os
from libtbx.test_utils import show_diff

def exercise_1(prefix="tst_sort_atoms_1"):
  """
  In an ideal world, this program should preserve everything that was in
  input pdb file: HEADER, TITLE, REMARKs, CONNECT, etc.
  Right now it preserves only atoms, CRYST1 and HELIX/SHEET records.
  """

  input_pdb_str = """\
HEADER    UNKNOWN FUNCTION                        17-FEB-05   1YWF
TITLE     CRYSTAL STRUCTURE OF MYCOBACTERIUM TUBERCULOSIS PROTEIN
TITLE    2 TYROSINE PHOSPHATASE PTPB
COMPND    MOL_ID: 1;
COMPND   2 MOLECULE: PHOSPHOTYROSINE PROTEIN PHOSPHATASE PTPB;
COMPND   3 CHAIN: A;
COMPND   4 ENGINEERED: YES
SOURCE    MOL_ID: 1;
SOURCE   2 ORGANISM_SCIENTIFIC: MYCOBACTERIUM TUBERCULOSIS;
SOURCE   3 ORGANISM_TAXID: 1773;
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI BL21;
SOURCE   5 EXPRESSION_SYSTEM_TAXID: 511693;
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21;
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET28B+
KEYWDS    FOUR STRANDED PARALLEL BETA SHEET WITH FLANKING HELICES,
KEYWDS   2 STRUCTURAL GENOMICS, PSI, PROTEIN STRUCTURE INITIATIVE, TB
KEYWDS   3 STRUCTURAL GENOMICS CONSORTIUM, TBSGC, UNKNOWN FUNCTION
EXPDTA    X-RAY DIFFRACTION
AUTHOR    C.GRUNDNER,H.L.NG,T.ALBER,TB STRUCTURAL GENOMICS CONSORTIUM
AUTHOR   2 (TBSGC)
REVDAT   3   24-FEB-09 1YWF    1       VERSN
REVDAT   2   24-OCT-06 1YWF    1       KEYWDS AUTHOR REMARK MASTER
REVDAT   1   22-NOV-05 1YWF    0
JRNL        AUTH   C.GRUNDNER,H.L.NG,T.ALBER
JRNL        TITL   MYCOBACTERIUM TUBERCULOSIS PROTEIN TYROSINE
JRNL        TITL 2 PHOSPHATASE PTPB STRUCTURE REVEALS A DIVERGED FOLD
JRNL        TITL 3 AND A BURIED ACTIVE SITE.
JRNL        REF    STRUCTURE                     V.  13  1625 2005
JRNL        REFN                   ISSN 0969-2126
JRNL        PMID   16271885
JRNL        DOI    10.1016/J.STR.2005.07.017
REMARK   1
REMARK   2
REMARK   2 RESOLUTION.    1.71 ANGSTROMS.
REMARK   3
REMARK   3 REFINEMENT.
REMARK   3   PROGRAM     : REFMAC 5.1.24
REMARK   3   AUTHORS     : MURSHUDOV,VAGIN,DODSON
REMARK   3
REMARK   3    REFINEMENT TARGET : MAXIMUM LIKELIHOOD
REMARK   3
REMARK   3  DATA USED IN REFINEMENT.
REMARK   3   RESOLUTION RANGE HIGH (ANGSTROMS) : 1.71
REMARK   3   RESOLUTION RANGE LOW  (ANGSTROMS) : 79.00
REMARK   3   DATA CUTOFF            (SIGMA(F)) : 0.000
REMARK   3   COMPLETENESS FOR RANGE        (%) : 93.5
REMARK   3   NUMBER OF REFLECTIONS             : 32240
REMARK   3
REMARK   3  FIT TO DATA USED IN REFINEMENT.
REMARK   3   CROSS-VALIDATION METHOD          : THROUGHOUT
REMARK   3   FREE R VALUE TEST SET SELECTION  : RANDOM
REMARK   3   R VALUE     (WORKING + TEST SET) : 0.178
REMARK   3   R VALUE            (WORKING SET) : 0.176
REMARK   3   FREE R VALUE                     : 0.214
REMARK   3   FREE R VALUE TEST SET SIZE   (%) : 5.000
REMARK   3   FREE R VALUE TEST SET COUNT      : 1692
REMARK   3
REMARK   3  FIT IN THE HIGHEST RESOLUTION BIN.
REMARK   3   TOTAL NUMBER OF BINS USED           : 20
REMARK   3   BIN RESOLUTION RANGE HIGH       (A) : 1.71
REMARK   3   BIN RESOLUTION RANGE LOW        (A) : 1.76
REMARK   3   REFLECTION IN BIN     (WORKING SET) : 1609
REMARK   3   BIN COMPLETENESS (WORKING+TEST) (%) : NULL
REMARK   3   BIN R VALUE           (WORKING SET) : 0.2670
REMARK   3   BIN FREE R VALUE SET COUNT          : 89
REMARK   3   BIN FREE R VALUE                    : 0.2680
REMARK   3
REMARK   3  NUMBER OF NON-HYDROGEN ATOMS USED IN REFINEMENT.
REMARK   3   PROTEIN ATOMS            : 1858
REMARK   3   NUCLEIC ACID ATOMS       : 0
REMARK   3   HETEROGEN ATOMS          : 5
REMARK   3   SOLVENT ATOMS            : 264
REMARK   3
REMARK   3  B VALUES.
REMARK   3   FROM WILSON PLOT           (A**2) : NULL
REMARK   3   MEAN B VALUE      (OVERALL, A**2) : 28.71
REMARK   3   OVERALL ANISOTROPIC B VALUE.
REMARK   3    B11 (A**2) : -1.99000
REMARK   3    B22 (A**2) : -1.99000
REMARK   3    B33 (A**2) : 3.98000
REMARK   3    B12 (A**2) : 0.00000
REMARK   3    B13 (A**2) : 0.00000
REMARK   3    B23 (A**2) : 0.00000
REMARK   3
REMARK   3  ESTIMATED OVERALL COORDINATE ERROR.
REMARK   3   ESU BASED ON R VALUE                            (A): 0.094
REMARK   3   ESU BASED ON FREE R VALUE                       (A): 0.098
REMARK   3   ESU BASED ON MAXIMUM LIKELIHOOD                 (A): 0.071
REMARK   3   ESU FOR B VALUES BASED ON MAXIMUM LIKELIHOOD (A**2): 2.244
REMARK   3
REMARK   3 CORRELATION COEFFICIENTS.
REMARK   3   CORRELATION COEFFICIENT FO-FC      : 0.969
REMARK   3   CORRELATION COEFFICIENT FO-FC FREE : 0.955
REMARK   3
REMARK   3  RMS DEVIATIONS FROM IDEAL VALUES        COUNT    RMS    WEIGHT
REMARK   3   BOND LENGTHS REFINED ATOMS        (A):  1889 ; 0.016 ; 0.021
REMARK   3   BOND LENGTHS OTHERS               (A):  1797 ; 0.002 ; 0.020
REMARK   3   BOND ANGLES REFINED ATOMS   (DEGREES):  2561 ; 1.676 ; 1.966
REMARK   3   BOND ANGLES OTHERS          (DEGREES):  4107 ; 0.915 ; 3.000
REMARK   3   TORSION ANGLES, PERIOD 1    (DEGREES):   239 ; 5.557 ; 5.000
REMARK   3   TORSION ANGLES, PERIOD 2    (DEGREES):  NULL ;  NULL ;  NULL
REMARK   3   TORSION ANGLES, PERIOD 3    (DEGREES):  NULL ;  NULL ;  NULL
REMARK   3   TORSION ANGLES, PERIOD 4    (DEGREES):  NULL ;  NULL ;  NULL
REMARK   3   CHIRAL-CENTER RESTRAINTS       (A**3):   295 ; 0.084 ; 0.200
REMARK   3   GENERAL PLANES REFINED ATOMS      (A):  2137 ; 0.007 ; 0.020
REMARK   3   GENERAL PLANES OTHERS             (A):   424 ; 0.005 ; 0.020
REMARK   3   NON-BONDED CONTACTS REFINED ATOMS (A):   444 ; 0.220 ; 0.200
REMARK   3   NON-BONDED CONTACTS OTHERS        (A):  2236 ; 0.251 ; 0.200
REMARK   3   NON-BONDED TORSION REFINED ATOMS  (A):  NULL ;  NULL ;  NULL
REMARK   3   NON-BONDED TORSION OTHERS         (A):  1177 ; 0.087 ; 0.200
REMARK   3   H-BOND (X...Y) REFINED ATOMS      (A):   169 ; 0.173 ; 0.200
REMARK   3   H-BOND (X...Y) OTHERS             (A):  NULL ;  NULL ;  NULL
REMARK   3   POTENTIAL METAL-ION REFINED ATOMS (A):  NULL ;  NULL ;  NULL
REMARK   3   POTENTIAL METAL-ION OTHERS        (A):  NULL ;  NULL ;  NULL
REMARK   3   SYMMETRY VDW REFINED ATOMS        (A):     2 ; 0.260 ; 0.200
REMARK   3   SYMMETRY VDW OTHERS               (A):    18 ; 0.295 ; 0.200
REMARK   3   SYMMETRY H-BOND REFINED ATOMS     (A):    11 ; 0.205 ; 0.200
REMARK   3   SYMMETRY H-BOND OTHERS            (A):  NULL ;  NULL ;  NULL
REMARK   3   SYMMETRY METAL-ION REFINED ATOMS  (A):  NULL ;  NULL ;  NULL
REMARK   3   SYMMETRY METAL-ION OTHERS         (A):  NULL ;  NULL ;  NULL
REMARK   3
REMARK   3  ISOTROPIC THERMAL FACTOR RESTRAINTS.     COUNT   RMS    WEIGHT
REMARK   3   MAIN-CHAIN BOND REFINED ATOMS  (A**2):  1194 ; 0.978 ; 1.500
REMARK   3   MAIN-CHAIN BOND OTHER ATOMS    (A**2):  NULL ;  NULL ;  NULL
REMARK   3   MAIN-CHAIN ANGLE REFINED ATOMS (A**2):  1910 ; 1.788 ; 2.000
REMARK   3   SIDE-CHAIN BOND REFINED ATOMS  (A**2):   695 ; 2.805 ; 3.000
REMARK   3   SIDE-CHAIN ANGLE REFINED ATOMS (A**2):   651 ; 4.729 ; 4.500
REMARK   3
REMARK   3 ANISOTROPIC THERMAL FACTOR RESTRAINTS.    COUNT   RMS   WEIGHT
REMARK   3   RIGID-BOND RESTRAINTS          (A**2):  NULL ;  NULL ;  NULL
REMARK   3   SPHERICITY; FREE ATOMS         (A**2):  NULL ;  NULL ;  NULL
REMARK   3   SPHERICITY; BONDED ATOMS       (A**2):  NULL ;  NULL ;  NULL
REMARK   3
REMARK   3  NCS RESTRAINTS STATISTICS
REMARK   3   NUMBER OF DIFFERENT NCS GROUPS : NULL
REMARK   3
REMARK   3  TLS DETAILS
REMARK   3   NUMBER OF TLS GROUPS  : NULL
REMARK   3
REMARK   3  BULK SOLVENT MODELLING.
REMARK   3   METHOD USED : BABINET MODEL WITH MASK
REMARK   3   PARAMETERS FOR MASK CALCULATION
REMARK   3   VDW PROBE RADIUS   : 1.40
REMARK   3   ION PROBE RADIUS   : 0.80
REMARK   3   SHRINKAGE RADIUS   : 0.80
REMARK   3
REMARK   3  OTHER REFINEMENT REMARKS: HYDROGENS HAVE BEEN ADDED IN THE
REMARK   3  RIDING POSITIONS
REMARK   4
REMARK   4 1YWF COMPLIES WITH FORMAT V. 3.15, 01-DEC-08
REMARK 100
REMARK 100 THIS ENTRY HAS BEEN PROCESSED BY RCSB ON 09-MAR-05.
REMARK 100 THE RCSB ID CODE IS RCSB031997.
REMARK 200
REMARK 200 EXPERIMENTAL DETAILS
REMARK 200  EXPERIMENT TYPE                : X-RAY DIFFRACTION
REMARK 200  DATE OF DATA COLLECTION        : 06-NOV-04
REMARK 200  TEMPERATURE           (KELVIN) : 93
REMARK 200  PH                             : 5.5
REMARK 200  NUMBER OF CRYSTALS USED        : 1
REMARK 200
REMARK 200  SYNCHROTRON              (Y/N) : Y
REMARK 200  RADIATION SOURCE               : ALS
REMARK 200  BEAMLINE                       : 8.3.1
REMARK 200  X-RAY GENERATOR MODEL          : NULL
REMARK 200  MONOCHROMATIC OR LAUE    (M/L) : M
REMARK 200  WAVELENGTH OR RANGE        (A) : 1.1157, 0.97949, 0.97973,
REMARK 200                                   0.93927
REMARK 200  MONOCHROMATOR                  : SI 111 CHANNEL
REMARK 200  OPTICS                         : NULL
REMARK 200
REMARK 200  DETECTOR TYPE                  : CCD
REMARK 200  DETECTOR MANUFACTURER          : ADSC QUANTUM 4
REMARK 200  INTENSITY-INTEGRATION SOFTWARE : HKL-2000
REMARK 200  DATA SCALING SOFTWARE          : SCALEPACK
REMARK 200
REMARK 200  NUMBER OF UNIQUE REFLECTIONS   : 33939
REMARK 200  RESOLUTION RANGE HIGH      (A) : 1.700
REMARK 200  RESOLUTION RANGE LOW       (A) : 79.000
REMARK 200  REJECTION CRITERIA  (SIGMA(I)) : -3.000
REMARK 200
REMARK 200 OVERALL.
REMARK 200  COMPLETENESS FOR RANGE     (%) : 91.2
REMARK 200  DATA REDUNDANCY                : NULL
REMARK 200  R MERGE                    (I) : 0.04100
REMARK 200  R SYM                      (I) : NULL
REMARK 200  <I/SIGMA(I)> FOR THE DATA SET  : 66.7000
REMARK 200
REMARK 200 IN THE HIGHEST RESOLUTION SHELL.
REMARK 200  HIGHEST RESOLUTION SHELL, RANGE HIGH (A) : 1.70
REMARK 200  HIGHEST RESOLUTION SHELL, RANGE LOW  (A) : 1.76
REMARK 200  COMPLETENESS FOR SHELL     (%) : 48.6
REMARK 200  DATA REDUNDANCY IN SHELL       : NULL
REMARK 200  R MERGE FOR SHELL          (I) : NULL
REMARK 200  R SYM FOR SHELL            (I) : NULL
REMARK 200  <I/SIGMA(I)> FOR SHELL         : NULL
REMARK 200
REMARK 200 DIFFRACTION PROTOCOL: MAD
REMARK 200 METHOD USED TO DETERMINE THE STRUCTURE: MAD
REMARK 200 SOFTWARE USED: SOLVE
REMARK 200 STARTING MODEL: NULL
REMARK 200
REMARK 200 REMARK: NULL
REMARK 280
REMARK 280 CRYSTAL
REMARK 280 SOLVENT CONTENT, VS   (%): 56.40
REMARK 280 MATTHEWS COEFFICIENT, VM (ANGSTROMS**3/DA): 2.63
REMARK 280
REMARK 280 CRYSTALLIZATION CONDITIONS: 0.05M KH2PO4, 20% PEG8000, 10MM
REMARK 280  NAACETATE, PH 5.5, VAPOR DIFFUSION, HANGING DROP, TEMPERATURE
REMARK 280  277K
REMARK 290
REMARK 290 CRYSTALLOGRAPHIC SYMMETRY
REMARK 290 SYMMETRY OPERATORS FOR SPACE GROUP: I 41
REMARK 290
REMARK 290      SYMOP   SYMMETRY
REMARK 290     NNNMMM   OPERATOR
REMARK 290       1555   X,Y,Z
REMARK 290       2555   -Y,X+1/2,Z+1/4
REMARK 290       3555   -X+1/2,-Y+1/2,Z+1/2
REMARK 290       4555   Y+1/2,-X,Z+3/4
REMARK 290       5555   X+1/2,Y+1/2,Z+1/2
REMARK 290       6555   -Y+1/2,X,Z+3/4
REMARK 290       7555   -X,-Y,Z
REMARK 290       8555   Y,-X+1/2,Z+1/4
REMARK 290
REMARK 290     WHERE NNN -> OPERATOR NUMBER
REMARK 290           MMM -> TRANSLATION VECTOR
REMARK 290
REMARK 290 CRYSTALLOGRAPHIC SYMMETRY TRANSFORMATIONS
REMARK 290 THE FOLLOWING TRANSFORMATIONS OPERATE ON THE ATOM/HETATM
REMARK 290 RECORDS IN THIS ENTRY TO PRODUCE CRYSTALLOGRAPHICALLY
REMARK 290 RELATED MOLECULES.
REMARK 290   SMTRY1   1  1.000000  0.000000  0.000000        0.00000
REMARK 290   SMTRY2   1  0.000000  1.000000  0.000000        0.00000
REMARK 290   SMTRY3   1  0.000000  0.000000  1.000000        0.00000
REMARK 290   SMTRY1   2  0.000000 -1.000000  0.000000        0.00000
REMARK 290   SMTRY2   2  1.000000  0.000000  0.000000       56.53400
REMARK 290   SMTRY3   2  0.000000  0.000000  1.000000       13.32300
REMARK 290   SMTRY1   3 -1.000000  0.000000  0.000000       56.53400
REMARK 290   SMTRY2   3  0.000000 -1.000000  0.000000       56.53400
REMARK 290   SMTRY3   3  0.000000  0.000000  1.000000       26.64600
REMARK 290   SMTRY1   4  0.000000  1.000000  0.000000       56.53400
REMARK 290   SMTRY2   4 -1.000000  0.000000  0.000000        0.00000
REMARK 290   SMTRY3   4  0.000000  0.000000  1.000000       39.96900
REMARK 290   SMTRY1   5  1.000000  0.000000  0.000000       56.53400
REMARK 290   SMTRY2   5  0.000000  1.000000  0.000000       56.53400
REMARK 290   SMTRY3   5  0.000000  0.000000  1.000000       26.64600
REMARK 290   SMTRY1   6  0.000000 -1.000000  0.000000       56.53400
REMARK 290   SMTRY2   6  1.000000  0.000000  0.000000        0.00000
REMARK 290   SMTRY3   6  0.000000  0.000000  1.000000       39.96900
REMARK 290   SMTRY1   7 -1.000000  0.000000  0.000000        0.00000
REMARK 290   SMTRY2   7  0.000000 -1.000000  0.000000        0.00000
REMARK 290   SMTRY3   7  0.000000  0.000000  1.000000        0.00000
REMARK 290   SMTRY1   8  0.000000  1.000000  0.000000        0.00000
REMARK 290   SMTRY2   8 -1.000000  0.000000  0.000000       56.53400
REMARK 290   SMTRY3   8  0.000000  0.000000  1.000000       13.32300
REMARK 290
REMARK 290 REMARK: NULL
REMARK 300
REMARK 300 BIOMOLECULE: 1
REMARK 300 SEE REMARK 350 FOR THE AUTHOR PROVIDED AND/OR PROGRAM
REMARK 300 GENERATED ASSEMBLY INFORMATION FOR THE STRUCTURE IN
REMARK 300 THIS ENTRY. THE REMARK MAY ALSO PROVIDE INFORMATION ON
REMARK 300 BURIED SURFACE AREA.
REMARK 350
REMARK 350 COORDINATES FOR A COMPLETE MULTIMER REPRESENTING THE KNOWN
REMARK 350 BIOLOGICALLY SIGNIFICANT OLIGOMERIZATION STATE OF THE
REMARK 350 MOLECULE CAN BE GENERATED BY APPLYING BIOMT TRANSFORMATIONS
REMARK 350 GIVEN BELOW.  BOTH NON-CRYSTALLOGRAPHIC AND
REMARK 350 CRYSTALLOGRAPHIC OPERATIONS ARE GIVEN.
REMARK 350
REMARK 350 BIOMOLECULE: 1
REMARK 350 AUTHOR DETERMINED BIOLOGICAL UNIT: MONOMERIC
REMARK 350 APPLY THE FOLLOWING TO CHAINS: A
REMARK 350   BIOMT1   1  1.000000  0.000000  0.000000        0.00000
REMARK 350   BIOMT2   1  0.000000  1.000000  0.000000        0.00000
REMARK 350   BIOMT3   1  0.000000  0.000000  1.000000        0.00000
REMARK 375
REMARK 375 SPECIAL POSITION
REMARK 375 THE FOLLOWING ATOMS ARE FOUND TO BE WITHIN 0.15 ANGSTROMS
REMARK 375 OF A SYMMETRY RELATED ATOM AND ARE ASSUMED TO BE ON SPECIAL
REMARK 375 POSITIONS.
REMARK 375
REMARK 375 ATOM RES CSSEQI
REMARK 375      HOH A 354  LIES ON A SPECIAL POSITION.
REMARK 465
REMARK 465 MISSING RESIDUES
REMARK 465 THE FOLLOWING RESIDUES WERE NOT LOCATED IN THE
REMARK 465 EXPERIMENT. (M=MODEL NUMBER; RES=RESIDUE NAME; C=CHAIN
REMARK 465 IDENTIFIER; SSSEQ=SEQUENCE NUMBER; I=INSERTION CODE.)
REMARK 465
REMARK 465   M RES C SSSEQI
REMARK 465     MET A   -19
REMARK 465     GLY A   -18
REMARK 465     SER A   -17
REMARK 465     SER A   -16
REMARK 465     HIS A   -15
REMARK 465     HIS A   -14
REMARK 465     HIS A   -13
REMARK 465     HIS A   -12
REMARK 465     HIS A   -11
REMARK 465     HIS A   -10
REMARK 465     SER A    -9
REMARK 465     SER A    -8
REMARK 465     GLY A    -7
REMARK 465     LEU A    -6
REMARK 465     VAL A    -5
REMARK 465     PRO A    -4
REMARK 465     ARG A    -3
REMARK 465     GLY A    -2
REMARK 465     SER A    -1
REMARK 465     HIS A     0
REMARK 465     MET A     1
REMARK 465     ALA A     2
REMARK 465     VAL A     3
REMARK 465     ASP A    86
REMARK 465     ASP A    87
REMARK 465     ALA A    88
REMARK 465     ASP A    89
REMARK 465     ASP A    90
REMARK 465     SER A    91
REMARK 465     ALA A    92
REMARK 465     PRO A    93
REMARK 465     HIS A    94
REMARK 465     GLU A    95
REMARK 465     THR A    96
REMARK 465     ALA A    97
REMARK 465     PHE A    98
REMARK 465     LYS A    99
REMARK 465     ARG A   100
REMARK 465     LEU A   101
REMARK 465     LEU A   102
REMARK 465     THR A   103
REMARK 465     ASN A   104
REMARK 465     ASP A   105
REMARK 465     GLY A   106
REMARK 465     SER A   107
REMARK 465     ASN A   108
REMARK 465     GLY A   109
REMARK 465     GLU A   110
REMARK 465     SER A   111
REMARK 465     GLY A   112
REMARK 465     GLU A   113
REMARK 465     SER A   114
REMARK 465     SER A   115
REMARK 465     GLN A   116
REMARK 465     GLY A   276
REMARK 470
REMARK 470 MISSING ATOM
REMARK 470 THE FOLLOWING RESIDUES HAVE MISSING ATOMS(M=MODEL NUMBER;
REMARK 470 RES=RESIDUE NAME; C=CHAIN IDENTIFIER; SSEQ=SEQUENCE NUMBER;
REMARK 470 I=INSERTION CODE):
REMARK 470   M RES CSSEQI  ATOMS
REMARK 470     ARG A  45    CG   CD   NE   CZ   NH1  NH2
REMARK 470     ARG A 226    CG   CD   NE   CZ   NH1  NH2
REMARK 500
REMARK 500 GEOMETRY AND STEREOCHEMISTRY
REMARK 500 SUBTOPIC: CLOSE CONTACTS IN SAME ASYMMETRIC UNIT
REMARK 500
REMARK 500 THE FOLLOWING ATOMS ARE IN CLOSE CONTACT.
REMARK 500
REMARK 500  ATM1  RES C  SSEQI   ATM2  RES C  SSEQI           DISTANCE
REMARK 500   O    HOH A   466     O    HOH A   507              2.15
REMARK 500
REMARK 500 REMARK: NULL
REMARK 500
REMARK 500 GEOMETRY AND STEREOCHEMISTRY
REMARK 500 SUBTOPIC: COVALENT BOND LENGTHS
REMARK 500
REMARK 500 THE STEREOCHEMICAL PARAMETERS OF THE FOLLOWING RESIDUES
REMARK 500 HAVE VALUES WHICH DEVIATE FROM EXPECTED VALUES BY MORE
REMARK 500 THAN 6*RMSD (M=MODEL NUMBER; RES=RESIDUE NAME; C=CHAIN
REMARK 500 IDENTIFIER; SSEQ=SEQUENCE NUMBER; I=INSERTION CODE).
REMARK 500
REMARK 500 STANDARD TABLE:
REMARK 500 FORMAT: (10X,I3,1X,2(A3,1X,A1,I4,A1,1X,A4,3X),1X,F6.3)
REMARK 500
REMARK 500 EXPECTED VALUES PROTEIN: ENGH AND HUBER, 1999
REMARK 500 EXPECTED VALUES NUCLEIC ACID: CLOWNEY ET AL 1996
REMARK 500
REMARK 500  M RES CSSEQI ATM1   RES CSSEQI ATM2   DEVIATION
REMARK 500    LYS A 164   CD    LYS A 164   CE      0.195
REMARK 500
REMARK 500 REMARK: NULL
REMARK 500
REMARK 500 GEOMETRY AND STEREOCHEMISTRY
REMARK 500 SUBTOPIC: COVALENT BOND ANGLES
REMARK 500
REMARK 500 THE STEREOCHEMICAL PARAMETERS OF THE FOLLOWING RESIDUES
REMARK 500 HAVE VALUES WHICH DEVIATE FROM EXPECTED VALUES BY MORE
REMARK 500 THAN 6*RMSD (M=MODEL NUMBER; RES=RESIDUE NAME; C=CHAIN
REMARK 500 IDENTIFIER; SSEQ=SEQUENCE NUMBER; I=INSERTION CODE).
REMARK 500
REMARK 500 STANDARD TABLE:
REMARK 500 FORMAT: (10X,I3,1X,A3,1X,A1,I4,A1,3(1X,A4,2X),12X,F5.1)
REMARK 500
REMARK 500 EXPECTED VALUES PROTEIN: ENGH AND HUBER, 1999
REMARK 500 EXPECTED VALUES NUCLEIC ACID: CLOWNEY ET AL 1996
REMARK 500
REMARK 500  M RES CSSEQI ATM1   ATM2   ATM3
REMARK 500    ASP A 120   CB  -  CG  -  OD2 ANGL. DEV. =   6.1 DEGREES
REMARK 500    LYS A 164   CD  -  CE  -  NZ  ANGL. DEV. = -37.4 DEGREES
REMARK 500    ARG A 271   NE  -  CZ  -  NH2 ANGL. DEV. =  -3.6 DEGREES
REMARK 500
REMARK 500 REMARK: NULL
REMARK 500
REMARK 500 GEOMETRY AND STEREOCHEMISTRY
REMARK 500 SUBTOPIC: TORSION ANGLES
REMARK 500
REMARK 500 TORSION ANGLES OUTSIDE THE EXPECTED RAMACHANDRAN REGIONS:
REMARK 500 (M=MODEL NUMBER; RES=RESIDUE NAME; C=CHAIN IDENTIFIER;
REMARK 500 SSEQ=SEQUENCE NUMBER; I=INSERTION CODE).
REMARK 500
REMARK 500 STANDARD TABLE:
REMARK 500 FORMAT:(10X,I3,1X,A3,1X,A1,I4,A1,4X,F7.2,3X,F7.2)
REMARK 500
REMARK 500 EXPECTED VALUES: GJ KLEYWEGT AND TA JONES (1996). PHI/PSI-
REMARK 500 CHOLOGY: RAMACHANDRAN REVISITED. STRUCTURE 4, 1395 - 1400
REMARK 500
REMARK 500  M RES CSSEQI        PSI       PHI
REMARK 500    ASN A 119       40.85   -101.39
REMARK 500    CYS A 160     -126.55   -127.33
REMARK 500    PHE A 161      -69.45    -90.71
REMARK 500    ASP A 165      -72.55    -98.47
REMARK 500    LEU A 227       45.01     27.68
REMARK 500    SER A 228      150.03    -45.91
REMARK 500
REMARK 500 REMARK: NULL
REMARK 800
REMARK 800 SITE
REMARK 800 SITE_IDENTIFIER: AC1
REMARK 800 EVIDENCE_CODE: SOFTWARE
REMARK 800 SITE_DESCRIPTION: BINDING SITE FOR RESIDUE PO4 A 277
REMARK 900
REMARK 900 RELATED ENTRIES
REMARK 900 RELATED ID: RV0153C   RELATED DB: TARGETDB
DBREF  1YWF A    1   276  UNP    P96830   P96830_MYCTU     1    276
SEQADV 1YWF MET A  -19  UNP  P96830              CLONING ARTIFACT
SEQADV 1YWF GLY A  -18  UNP  P96830              CLONING ARTIFACT
SEQADV 1YWF SER A  -17  UNP  P96830              CLONING ARTIFACT
SEQADV 1YWF SER A  -16  UNP  P96830              CLONING ARTIFACT
SEQADV 1YWF HIS A  -15  UNP  P96830              CLONING ARTIFACT
SEQADV 1YWF HIS A  -14  UNP  P96830              CLONING ARTIFACT
SEQADV 1YWF HIS A  -13  UNP  P96830              CLONING ARTIFACT
SEQADV 1YWF HIS A  -12  UNP  P96830              CLONING ARTIFACT
SEQADV 1YWF HIS A  -11  UNP  P96830              CLONING ARTIFACT
SEQADV 1YWF HIS A  -10  UNP  P96830              CLONING ARTIFACT
SEQADV 1YWF SER A   -9  UNP  P96830              CLONING ARTIFACT
SEQADV 1YWF SER A   -8  UNP  P96830              CLONING ARTIFACT
SEQADV 1YWF GLY A   -7  UNP  P96830              CLONING ARTIFACT
SEQADV 1YWF LEU A   -6  UNP  P96830              CLONING ARTIFACT
SEQADV 1YWF VAL A   -5  UNP  P96830              CLONING ARTIFACT
SEQADV 1YWF PRO A   -4  UNP  P96830              CLONING ARTIFACT
SEQADV 1YWF ARG A   -3  UNP  P96830              CLONING ARTIFACT
SEQADV 1YWF GLY A   -2  UNP  P96830              CLONING ARTIFACT
SEQADV 1YWF SER A   -1  UNP  P96830              CLONING ARTIFACT
SEQADV 1YWF HIS A    0  UNP  P96830              CLONING ARTIFACT
SEQRES   1 A  296  MET GLY SER SER HIS HIS HIS HIS HIS HIS SER SER GLY
SEQRES   2 A  296  LEU VAL PRO ARG GLY SER HIS MET ALA VAL ARG GLU LEU
SEQRES   3 A  296  PRO GLY ALA TRP ASN PHE ARG ASP VAL ALA ASP THR ALA
SEQRES   4 A  296  THR ALA LEU ARG PRO GLY ARG LEU PHE ARG SER SER GLU
SEQRES   5 A  296  LEU SER ARG LEU ASP ASP ALA GLY ARG ALA THR LEU ARG
SEQRES   6 A  296  ARG LEU GLY ILE THR ASP VAL ALA ASP LEU ARG SER SER
SEQRES   7 A  296  ARG GLU VAL ALA ARG ARG GLY PRO GLY ARG VAL PRO ASP
SEQRES   8 A  296  GLY ILE ASP VAL HIS LEU LEU PRO PHE PRO ASP LEU ALA
SEQRES   9 A  296  ASP ASP ASP ALA ASP ASP SER ALA PRO HIS GLU THR ALA
SEQRES  10 A  296  PHE LYS ARG LEU LEU THR ASN ASP GLY SER ASN GLY GLU
SEQRES  11 A  296  SER GLY GLU SER SER GLN SER ILE ASN ASP ALA ALA THR
SEQRES  12 A  296  ARG TYR MET THR ASP GLU TYR ARG GLN PHE PRO THR ARG
SEQRES  13 A  296  ASN GLY ALA GLN ARG ALA LEU HIS ARG VAL VAL THR LEU
SEQRES  14 A  296  LEU ALA ALA GLY ARG PRO VAL LEU THR HIS CYS PHE ALA
SEQRES  15 A  296  GLY LYS ASP ARG THR GLY PHE VAL VAL ALA LEU VAL LEU
SEQRES  16 A  296  GLU ALA VAL GLY LEU ASP ARG ASP VAL ILE VAL ALA ASP
SEQRES  17 A  296  TYR LEU ARG SER ASN ASP SER VAL PRO GLN LEU ARG ALA
SEQRES  18 A  296  ARG ILE SER GLU MET ILE GLN GLN ARG PHE ASP THR GLU
SEQRES  19 A  296  LEU ALA PRO GLU VAL VAL THR PHE THR LYS ALA ARG LEU
SEQRES  20 A  296  SER ASP GLY VAL LEU GLY VAL ARG ALA GLU TYR LEU ALA
SEQRES  21 A  296  ALA ALA ARG GLN THR ILE ASP GLU THR TYR GLY SER LEU
SEQRES  22 A  296  GLY GLY TYR LEU ARG ASP ALA GLY ILE SER GLN ALA THR
SEQRES  23 A  296  VAL ASN ARG MET ARG GLY VAL LEU LEU GLY
HET    PO4  A 277       5
HETNAM     PO4 PHOSPHATE ION
FORMUL   2  PO4    O4 P 3-
FORMUL   3  HOH   *264(H2 O)
HELIX    1   1 ALA A   16  THR A   18  5                                   3
HELIX    2   2 ASP A   37  GLY A   48  1                                  12
HELIX    3   3 SER A   57  GLY A   65  1                                   9
HELIX    4   4 ASN A  119  PHE A  133  1                                  15
HELIX    5   5 PRO A  134  ARG A  136  5                                   3
HELIX    6   6 GLY A  138  ALA A  152  1                                  15
HELIX    7   7 ASP A  165  VAL A  178  1                                  14
HELIX    8   8 ASP A  181  ARG A  191  1                                  11
HELIX    9   9 SER A  192  ASP A  194  5                                   3
HELIX   10  10 SER A  195  GLN A  209  1                                  15
HELIX   11  11 ALA A  216  ALA A  225  1                                  10
HELIX   12  12 SER A  228  GLY A  233  1                                   6
HELIX   13  13 ARG A  235  GLY A  251  1                                  17
HELIX   14  14 SER A  252  ALA A  260  1                                   9
HELIX   15  15 SER A  263  LEU A  275  1                                  13
SHEET    1   A 5 ARG A  13  ASP A  14  0
SHEET    2   A 5 LEU A  27  SER A  30 -1  O  ARG A  29   N  ARG A  13
SHEET    3   A 5 VAL A 156  HIS A 159  1  O  VAL A 156   N  PHE A  28
SHEET    4   A 5 ASP A  51  ASP A  54  1  N  ALA A  51   O  LEU A 157
SHEET    5   A 5 ASP A  74  LEU A  77  1  O  HIS A  74   N  VAL A  52
SITE   *** AC1  9 LEU A  83  CYS A 160  PHE A 161  ALA A 162
SITE   *** AC1  9 GLY A 163  LYS A 164  ASP A 165  ARG A 166
SITE   *** AC1  9 GLU A 218
CRYST1  113.068  113.068   53.292  90.00  90.00  90.00 I 41          8
ORIGX1      1.000000  0.000000  0.000000        0.00000
ORIGX2      0.000000  1.000000  0.000000        0.00000
ORIGX3      0.000000  0.000000  1.000000        0.00000
SCALE1      0.008844  0.000000  0.000000        0.00000
SCALE2      0.000000  0.008844  0.000000        0.00000
SCALE3      0.000000  0.000000  0.018765        0.00000
ATOM      1  N   ARG A   4       7.511  46.981  14.258  1.00 46.91           N
ATOM      2  CA  ARG A   4       7.057  47.032  12.837  1.00 47.14           C
ATOM      3  C   ARG A   4       7.149  48.454  12.261  1.00 44.77           C
ATOM      4  O   ARG A   4       7.798  48.643  11.247  1.00 45.20           O
ATOM      5  CB  ARG A   4       5.613  46.509  12.682  1.00 47.77           C
ATOM      6  CG  ARG A   4       5.282  45.235  13.472  1.00 52.79           C
ATOM      7  CD  ARG A   4       4.921  43.958  12.663  1.00 58.16           C
ATOM      8  NE  ARG A   4       4.877  44.193  11.216  1.00 63.64           N
ATOM      9  CZ  ARG A   4       5.947  44.408  10.439  1.00 67.41           C
ATOM     10  NH1 ARG A   4       7.176  44.420  10.954  1.00 68.79           N
ATOM     11  NH2 ARG A   4       5.785  44.627   9.133  1.00 68.95           N
ATOM      0  HA  ARG A   4       7.735  46.377  12.271  1.00 47.14           H
ATOM      0  HB2 ARG A   4       4.919  47.303  12.994  1.00 47.77           H
ATOM      0  HB3 ARG A   4       5.424  46.317  11.615  1.00 47.77           H
ATOM      0  HG2 ARG A   4       6.146  44.998  14.111  1.00 52.79           H
ATOM      0  HG3 ARG A   4       4.439  45.461  14.142  1.00 52.79           H
ATOM      0  HD2 ARG A   4       5.659  43.172  12.879  1.00 58.16           H
ATOM      0  HD3 ARG A   4       3.943  43.582  12.998  1.00 58.16           H
ATOM      0  HE  ARG A   4       3.979  44.193  10.775  1.00 63.64           H
ATOM      0 HH11 ARG A   4       7.309  44.267  11.933  1.00 68.79           H
ATOM      0 HH12 ARG A   4       7.965  44.582  10.361  1.00 68.79           H
ATOM      0 HH21 ARG A   4       4.867  44.630   8.737  1.00 68.95           H
ATOM      0 HH22 ARG A   4       6.582  44.788   8.550  1.00 68.95           H
ATOM     12  N   GLU A   5       6.489  49.425  12.914  1.00 42.64           N
ATOM     13  CA  GLU A   5       6.285  50.786  12.396  1.00 40.70           C
ATOM     14  C   GLU A   5       7.010  51.885  13.188  1.00 37.71           C
ATOM     15  O   GLU A   5       7.249  51.776  14.392  1.00 37.47           O
ATOM     16  CB  GLU A   5       4.775  51.134  12.383  1.00 41.69           C
ATOM     17  CG  GLU A   5       3.932  50.296  11.422  1.00 44.73           C
ATOM     18  CD  GLU A   5       4.140  50.666   9.954  1.00 49.40           C
ATOM     19  OE1 GLU A   5       4.507  51.827   9.648  1.00 50.99           O
ATOM     20  OE2 GLU A   5       3.938  49.789   9.079  1.00 54.37           O
ATOM      0  H   GLU A   5       6.083  49.285  13.817  1.00 42.64           H
ATOM      0  HA  GLU A   5       6.714  50.769  11.383  1.00 40.70           H
ATOM      0  HB2 GLU A   5       4.376  51.011  13.401  1.00 41.69           H
ATOM      0  HB3 GLU A   5       4.660  52.196  12.119  1.00 41.69           H
ATOM      0  HG2 GLU A   5       4.176  49.233  11.563  1.00 44.73           H
ATOM      0  HG3 GLU A   5       2.869  50.418  11.676  1.00 44.73           H
ATOM     21  N   LEU A   6       7.297  52.974  12.490  1.00 34.71           N
ATOM     22  CA  LEU A   6       7.928  54.158  13.057  1.00 32.83           C
ATOM     23  C   LEU A   6       7.124  55.354  12.548  1.00 32.42           C
ATOM     24  O   LEU A   6       7.421  55.925  11.503  1.00 31.01           O
ATOM     25  CB  LEU A   6       9.391  54.265  12.608  1.00 32.60           C
ATOM     26  CG  LEU A   6      10.179  55.463  13.111  1.00 30.47           C
ATOM     27  CD1 LEU A   6      10.149  55.453  14.651  1.00 33.03           C
ATOM     28  CD2 LEU A   6      11.634  55.474  12.576  1.00 30.34           C
ATOM      0  H   LEU A   6       7.098  53.060  11.514  1.00 34.71           H
ATOM      0  HA  LEU A   6       7.934  54.115  14.156  1.00 32.83           H
ATOM      0  HB2 LEU A   6       9.915  53.352  12.928  1.00 32.60           H
ATOM      0  HB3 LEU A   6       9.411  54.279  11.508  1.00 32.60           H
ATOM      0  HG  LEU A   6       9.711  56.384  12.733  1.00 30.47           H
ATOM      0 HD11 LEU A   6      10.715  56.314  15.035  1.00 33.03           H
ATOM      0 HD12 LEU A   6       9.107  55.515  14.998  1.00 33.03           H
ATOM      0 HD13 LEU A   6      10.603  54.522  15.021  1.00 33.03           H
ATOM      0 HD21 LEU A   6      12.162  56.357  12.966  1.00 30.34           H
ATOM      0 HD22 LEU A   6      12.153  54.562  12.905  1.00 30.34           H
ATOM      0 HD23 LEU A   6      11.621  55.512  11.477  1.00 30.34           H
ATOM     29  N   PRO A   7       6.021  55.686  13.228  1.00 31.97           N
ATOM     30  CA  PRO A   7       5.071  56.656  12.662  1.00 31.54           C
ATOM     31  C   PRO A   7       5.654  58.019  12.286  1.00 29.40           C
ATOM     32  O   PRO A   7       6.359  58.672  13.062  1.00 31.00           O
ATOM     33  CB  PRO A   7       3.963  56.730  13.741  1.00 31.52           C
ATOM     34  CG  PRO A   7       4.012  55.430  14.379  1.00 32.79           C
ATOM     35  CD  PRO A   7       5.514  55.095  14.483  1.00 32.60           C
ATOM      0  HA  PRO A   7       4.705  56.327  11.678  1.00 31.54           H
ATOM      0  HB2 PRO A   7       4.154  57.540  14.460  1.00 31.52           H
ATOM      0  HB3 PRO A   7       2.977  56.923  13.294  1.00 31.52           H
ATOM      0  HG2 PRO A   7       3.540  55.455  15.372  1.00 32.79           H
ATOM      0  HG3 PRO A   7       3.475  54.675  13.786  1.00 32.79           H
ATOM      0  HD2 PRO A   7       5.980  55.544  15.373  1.00 32.60           H
ATOM      0  HD3 PRO A   7       5.696  54.012  14.536  1.00 32.60           H
ATOM     36  N   GLY A   8       5.386  58.417  11.036  1.00 28.81           N
ATOM     37  CA  GLY A   8       5.916  59.617  10.412  1.00 28.14           C
ATOM     38  C   GLY A   8       7.143  59.366   9.540  1.00 26.94           C
ATOM     39  O   GLY A   8       7.557  60.229   8.751  1.00 26.16           O
ATOM      0  H   GLY A   8       4.784  57.898  10.429  1.00 28.81           H
ATOM      0  HA2 GLY A   8       5.129  60.078   9.797  1.00 28.14           H
ATOM      0  HA3 GLY A   8       6.177  60.342  11.197  1.00 28.14           H
ATOM     40  N   ALA A   9       7.683  58.159   9.650  1.00 26.13           N
ATOM     41  CA  ALA A   9       8.750  57.696   8.757  1.00 25.16           C
ATOM     42  C   ALA A   9       8.313  56.419   8.034  1.00 25.14           C
ATOM     43  O   ALA A   9       7.221  55.876   8.276  1.00 25.57           O
ATOM     44  CB  ALA A   9      10.038  57.470   9.546  1.00 25.41           C
ATOM      0  H   ALA A   9       7.406  57.489  10.338  1.00 26.13           H
ATOM      0  HA  ALA A   9       8.947  58.469   7.999  1.00 25.16           H
ATOM      0  HB1 ALA A   9      10.830  57.123   8.865  1.00 25.41           H
ATOM      0  HB2 ALA A   9      10.349  58.413  10.019  1.00 25.41           H
ATOM      0  HB3 ALA A   9       9.864  56.711  10.323  1.00 25.41           H
ATOM     45  N   TRP A  10       9.132  55.968   7.091  1.00 24.79           N
ATOM     46  CA  TRP A  10       8.801  54.772   6.341  1.00 23.84           C
ATOM     47  C   TRP A  10      10.106  53.977   6.084  1.00 23.68           C
ATOM     48  O   TRP A  10      11.196  54.413   6.461  1.00 21.87           O
ATOM     49  CB  TRP A  10       8.093  55.130   5.023  1.00 23.84           C
ATOM     50  CG  TRP A  10       8.914  55.811   3.994  1.00 21.18           C
ATOM     51  CD1 TRP A  10       9.502  55.245   2.912  1.00 23.12           C
ATOM     52  CD2 TRP A  10       9.276  57.199   3.966  1.00 23.18           C
ATOM     53  NE1 TRP A  10      10.195  56.191   2.193  1.00 23.94           N
ATOM     54  CE2 TRP A  10      10.049  57.406   2.829  1.00 24.73           C
ATOM     55  CE3 TRP A  10       8.976  58.314   4.790  1.00 25.02           C
ATOM     56  CZ2 TRP A  10      10.585  58.649   2.506  1.00 24.98           C
ATOM     57  CZ3 TRP A  10       9.511  59.554   4.437  1.00 24.23           C
ATOM     58  CH2 TRP A  10      10.275  59.704   3.315  1.00 23.25           C
ATOM      0  H   TRP A  10       9.998  56.399   6.838  1.00 24.79           H
ATOM      0  HA  TRP A  10       8.103  54.149   6.919  1.00 23.84           H
ATOM      0  HB2 TRP A  10       7.692  54.204   4.585  1.00 23.84           H
ATOM      0  HB3 TRP A  10       7.233  55.774   5.258  1.00 23.84           H
ATOM      0  HD1 TRP A  10       9.435  54.180   2.646  1.00 23.12           H
ATOM      0  HE1 TRP A  10      10.715  56.026   1.355  1.00 23.94           H
ATOM      0  HE3 TRP A  10       8.340  58.205   5.681  1.00 25.02           H
ATOM      0  HZ2 TRP A  10      11.236  58.777   1.629  1.00 24.98           H
ATOM      0  HZ3 TRP A  10       9.313  60.428   5.075  1.00 24.23           H
ATOM      0  HH2 TRP A  10      10.652  60.704   3.056  1.00 23.25           H
TER    1859
HETATM 2117  O   HOH A 530      14.129  75.372   1.869  1.00 42.52           O
HETATM 2118  O   HOH A 531      16.760  75.823   5.378  1.00 55.47           O
HETATM 2119  O   HOH A 532      17.376  76.181  -1.370  1.00 58.56           O
HETATM 2120  O   HOH A 533      29.999  39.710  23.377  1.00 65.34           O
HETATM 2121  O   HOH A 534       5.061  66.928  20.580  1.00 53.64           O
HETATM 2122  O   HOH A 535      31.453  64.317  11.742  1.00 57.21           O
HETATM 2123  O   HOH A 536      33.870  40.890  21.690  1.00 49.33           O
HETATM 2124  O   HOH A 537      12.870  61.651  25.404  1.00 60.53           O
HETATM 2125  O   HOH A 538       1.073  55.236   2.188  1.00 56.32           O
HETATM 2126  O   HOH A 539       5.912  53.669  23.394  1.00 76.65           O
HETATM 2127  O   HOH A 540      15.986  47.456 -16.281  1.00 62.61           O
HETATM 2128  O   HOH A 541      16.397  56.900  23.573  1.00 58.46           O
CONECT 1860 1861 1862 1863 1864
CONECT 1861 1860
CONECT 1862 1860
CONECT 1863 1860
CONECT 1864 1860
END
"""

  result_pdb_str = """\
CRYST1  113.068  113.068   53.292  90.00  90.00  90.00 I 41
SCALE1      0.008844  0.000000  0.000000        0.00000
SCALE2      0.000000  0.008844  0.000000        0.00000
SCALE3      0.000000  0.000000  0.018765        0.00000
ATOM      1  N   ARG A   4       7.511  46.981  14.258  1.00 46.91           N
ATOM      2  CA  ARG A   4       7.057  47.032  12.837  1.00 47.14           C
ATOM      3  C   ARG A   4       7.149  48.454  12.261  1.00 44.77           C
ATOM      4  O   ARG A   4       7.798  48.643  11.247  1.00 45.20           O
ATOM      5  CB  ARG A   4       5.613  46.509  12.682  1.00 47.77           C
ATOM      6  CG  ARG A   4       5.282  45.235  13.472  1.00 52.79           C
ATOM      7  CD  ARG A   4       4.921  43.958  12.663  1.00 58.16           C
ATOM      8  NE  ARG A   4       4.877  44.193  11.216  1.00 63.64           N
ATOM      9  CZ  ARG A   4       5.947  44.408  10.439  1.00 67.41           C
ATOM     10  NH1 ARG A   4       7.176  44.420  10.954  1.00 68.79           N
ATOM     11  NH2 ARG A   4       5.785  44.627   9.133  1.00 68.95           N
ATOM     12  HA  ARG A   4       7.735  46.377  12.271  1.00 47.14           H
ATOM     13  HB2 ARG A   4       4.919  47.303  12.994  1.00 47.77           H
ATOM     14  HB3 ARG A   4       5.424  46.317  11.615  1.00 47.77           H
ATOM     15  HG2 ARG A   4       6.146  44.998  14.111  1.00 52.79           H
ATOM     16  HG3 ARG A   4       4.439  45.461  14.142  1.00 52.79           H
ATOM     17  HD2 ARG A   4       5.659  43.172  12.879  1.00 58.16           H
ATOM     18  HD3 ARG A   4       3.943  43.582  12.998  1.00 58.16           H
ATOM     19  HE  ARG A   4       3.979  44.193  10.775  1.00 63.64           H
ATOM     20 HH11 ARG A   4       7.309  44.267  11.933  1.00 68.79           H
ATOM     21 HH12 ARG A   4       7.965  44.582  10.361  1.00 68.79           H
ATOM     22 HH21 ARG A   4       4.867  44.630   8.737  1.00 68.95           H
ATOM     23 HH22 ARG A   4       6.582  44.788   8.550  1.00 68.95           H
ATOM     24  N   GLU A   5       6.489  49.425  12.914  1.00 42.64           N
ATOM     25  CA  GLU A   5       6.285  50.786  12.396  1.00 40.70           C
ATOM     26  C   GLU A   5       7.010  51.885  13.188  1.00 37.71           C
ATOM     27  O   GLU A   5       7.249  51.776  14.392  1.00 37.47           O
ATOM     28  CB  GLU A   5       4.775  51.134  12.383  1.00 41.69           C
ATOM     29  CG  GLU A   5       3.932  50.296  11.422  1.00 44.73           C
ATOM     30  CD  GLU A   5       4.140  50.666   9.954  1.00 49.40           C
ATOM     31  OE1 GLU A   5       4.507  51.827   9.648  1.00 50.99           O
ATOM     32  OE2 GLU A   5       3.938  49.789   9.079  1.00 54.37           O
ATOM     33  H   GLU A   5       6.083  49.285  13.817  1.00 42.64           H
ATOM     34  HA  GLU A   5       6.714  50.769  11.383  1.00 40.70           H
ATOM     35  HB2 GLU A   5       4.376  51.011  13.401  1.00 41.69           H
ATOM     36  HB3 GLU A   5       4.660  52.196  12.119  1.00 41.69           H
ATOM     37  HG2 GLU A   5       4.176  49.233  11.563  1.00 44.73           H
ATOM     38  HG3 GLU A   5       2.869  50.418  11.676  1.00 44.73           H
ATOM     39  N   LEU A   6       7.297  52.974  12.490  1.00 34.71           N
ATOM     40  CA  LEU A   6       7.928  54.158  13.057  1.00 32.83           C
ATOM     41  C   LEU A   6       7.124  55.354  12.548  1.00 32.42           C
ATOM     42  O   LEU A   6       7.421  55.925  11.503  1.00 31.01           O
ATOM     43  CB  LEU A   6       9.391  54.265  12.608  1.00 32.60           C
ATOM     44  CG  LEU A   6      10.179  55.463  13.111  1.00 30.47           C
ATOM     45  CD1 LEU A   6      10.149  55.453  14.651  1.00 33.03           C
ATOM     46  CD2 LEU A   6      11.634  55.474  12.576  1.00 30.34           C
ATOM     47  H   LEU A   6       7.098  53.060  11.514  1.00 34.71           H
ATOM     48  HA  LEU A   6       7.934  54.115  14.156  1.00 32.83           H
ATOM     49  HB2 LEU A   6       9.915  53.352  12.928  1.00 32.60           H
ATOM     50  HB3 LEU A   6       9.411  54.279  11.508  1.00 32.60           H
ATOM     51  HG  LEU A   6       9.711  56.384  12.733  1.00 30.47           H
ATOM     52 HD11 LEU A   6      10.715  56.314  15.035  1.00 33.03           H
ATOM     53 HD12 LEU A   6       9.107  55.515  14.998  1.00 33.03           H
ATOM     54 HD13 LEU A   6      10.603  54.522  15.021  1.00 33.03           H
ATOM     55 HD21 LEU A   6      12.162  56.357  12.966  1.00 30.34           H
ATOM     56 HD22 LEU A   6      12.153  54.562  12.905  1.00 30.34           H
ATOM     57 HD23 LEU A   6      11.621  55.512  11.477  1.00 30.34           H
ATOM     58  N   PRO A   7       6.021  55.686  13.228  1.00 31.97           N
ATOM     59  CA  PRO A   7       5.071  56.656  12.662  1.00 31.54           C
ATOM     60  C   PRO A   7       5.654  58.019  12.286  1.00 29.40           C
ATOM     61  O   PRO A   7       6.359  58.672  13.062  1.00 31.00           O
ATOM     62  CB  PRO A   7       3.963  56.730  13.741  1.00 31.52           C
ATOM     63  CG  PRO A   7       4.012  55.430  14.379  1.00 32.79           C
ATOM     64  CD  PRO A   7       5.514  55.095  14.483  1.00 32.60           C
ATOM     65  HA  PRO A   7       4.705  56.327  11.678  1.00 31.54           H
ATOM     66  HB2 PRO A   7       4.154  57.540  14.460  1.00 31.52           H
ATOM     67  HB3 PRO A   7       2.977  56.923  13.294  1.00 31.52           H
ATOM     68  HG2 PRO A   7       3.540  55.455  15.372  1.00 32.79           H
ATOM     69  HG3 PRO A   7       3.475  54.675  13.786  1.00 32.79           H
ATOM     70  HD2 PRO A   7       5.980  55.544  15.373  1.00 32.60           H
ATOM     71  HD3 PRO A   7       5.696  54.012  14.536  1.00 32.60           H
ATOM     72  N   GLY A   8       5.386  58.417  11.036  1.00 28.81           N
ATOM     73  CA  GLY A   8       5.916  59.617  10.412  1.00 28.14           C
ATOM     74  C   GLY A   8       7.143  59.366   9.540  1.00 26.94           C
ATOM     75  O   GLY A   8       7.557  60.229   8.751  1.00 26.16           O
ATOM     76  H   GLY A   8       4.784  57.898  10.429  1.00 28.81           H
ATOM     77  HA2 GLY A   8       5.129  60.078   9.797  1.00 28.14           H
ATOM     78  HA3 GLY A   8       6.177  60.342  11.197  1.00 28.14           H
ATOM     79  N   ALA A   9       7.683  58.159   9.650  1.00 26.13           N
ATOM     80  CA  ALA A   9       8.750  57.696   8.757  1.00 25.16           C
ATOM     81  C   ALA A   9       8.313  56.419   8.034  1.00 25.14           C
ATOM     82  O   ALA A   9       7.221  55.876   8.276  1.00 25.57           O
ATOM     83  CB  ALA A   9      10.038  57.470   9.546  1.00 25.41           C
ATOM     84  H   ALA A   9       7.406  57.489  10.338  1.00 26.13           H
ATOM     85  HA  ALA A   9       8.947  58.469   7.999  1.00 25.16           H
ATOM     86  HB1 ALA A   9      10.830  57.123   8.865  1.00 25.41           H
ATOM     87  HB2 ALA A   9      10.349  58.413  10.019  1.00 25.41           H
ATOM     88  HB3 ALA A   9       9.864  56.711  10.323  1.00 25.41           H
ATOM     89  N   TRP A  10       9.132  55.968   7.091  1.00 24.79           N
ATOM     90  CA  TRP A  10       8.801  54.772   6.341  1.00 23.84           C
ATOM     91  C   TRP A  10      10.106  53.977   6.084  1.00 23.68           C
ATOM     92  O   TRP A  10      11.196  54.413   6.461  1.00 21.87           O
ATOM     93  CB  TRP A  10       8.093  55.130   5.023  1.00 23.84           C
ATOM     94  CG  TRP A  10       8.914  55.811   3.994  1.00 21.18           C
ATOM     95  CD1 TRP A  10       9.502  55.245   2.912  1.00 23.12           C
ATOM     96  CD2 TRP A  10       9.276  57.199   3.966  1.00 23.18           C
ATOM     97  NE1 TRP A  10      10.195  56.191   2.193  1.00 23.94           N
ATOM     98  CE2 TRP A  10      10.049  57.406   2.829  1.00 24.73           C
ATOM     99  CE3 TRP A  10       8.976  58.314   4.790  1.00 25.02           C
ATOM    100  CZ2 TRP A  10      10.585  58.649   2.506  1.00 24.98           C
ATOM    101  CZ3 TRP A  10       9.511  59.554   4.437  1.00 24.23           C
ATOM    102  CH2 TRP A  10      10.275  59.704   3.315  1.00 23.25           C
ATOM    103  H   TRP A  10       9.998  56.399   6.838  1.00 24.79           H
ATOM    104  HA  TRP A  10       8.103  54.149   6.919  1.00 23.84           H
ATOM    105  HB2 TRP A  10       7.692  54.204   4.585  1.00 23.84           H
ATOM    106  HB3 TRP A  10       7.233  55.774   5.258  1.00 23.84           H
ATOM    107  HD1 TRP A  10       9.435  54.180   2.646  1.00 23.12           H
ATOM    108  HE1 TRP A  10      10.715  56.026   1.355  1.00 23.94           H
ATOM    109  HE3 TRP A  10       8.340  58.205   5.681  1.00 25.02           H
ATOM    110  HZ2 TRP A  10      11.236  58.777   1.629  1.00 24.98           H
ATOM    111  HZ3 TRP A  10       9.313  60.428   5.075  1.00 24.23           H
ATOM    112  HH2 TRP A  10      10.652  60.704   3.056  1.00 23.25           H
TER
HETATM  113  O   HOH A 530      14.129  75.372   1.869  1.00 42.52           O
HETATM  114  O   HOH A 531      16.760  75.823   5.378  1.00 55.47           O
HETATM  115  O   HOH A 532      17.376  76.181  -1.370  1.00 58.56           O
HETATM  116  O   HOH A 533      29.999  39.710  23.377  1.00 65.34           O
HETATM  117  O   HOH A 534       5.061  66.928  20.580  1.00 53.64           O
HETATM  118  O   HOH A 535      31.453  64.317  11.742  1.00 57.21           O
HETATM  119  O   HOH A 536      33.870  40.890  21.690  1.00 49.33           O
HETATM  120  O   HOH A 537      12.870  61.651  25.404  1.00 60.53           O
HETATM  121  O   HOH A 538       1.073  55.236   2.188  1.00 56.32           O
HETATM  122  O   HOH A 539       5.912  53.669  23.394  1.00 76.65           O
HETATM  123  O   HOH A 540      15.986  47.456 -16.281  1.00 62.61           O
HETATM  124  O   HOH A 541      16.397  56.900  23.573  1.00 58.46           O
END
"""

  in_f = open("%s.pdb" % prefix, 'w')
  in_f.write(input_pdb_str)
  in_f.close()
  cmd = " ".join([
      "iotbx.pdb.sort_atoms",
      "%s.pdb" % prefix,
      ])
  print(cmd)
  easy_run.call(cmd)
  assert os.path.isfile("%s_sorted.pdb" % prefix)
  out_f = open("%s_sorted.pdb" % prefix, 'r')
  out_str = out_f.read()
  assert not show_diff(result_pdb_str, out_str)
  out_f.close()

if (__name__ == "__main__"):
  t0 = time.time()
  exercise_1()
  print("Time: %6.4f"%(time.time()-t0))
  print("OK")
