/* Generated from posixunix.scm by the CHICKEN compiler
   http://www.call-cc.org
   2014-06-07 15:21
   Version 4.9.0.1 (stability/4.9.0) (rev 8b3189b)
   linux-unix-gnu-x86-64 [ 64bit manyargs ptables ]
   compiled 2014-06-07 on yves (Linux)
   command line: posixunix.scm -optimize-level 2 -include-path . -include-path ./ -inline -ignore-repository -feature chicken-bootstrap -no-warnings -specialize -types ./types.db -explicit-use -no-trace -output-file posixunix.c
   unit: posix
*/

#include "chicken.h"


#include <signal.h>
#include <errno.h>

#include <sys/stat.h>

static int C_not_implemented(void);
int C_not_implemented() { return -1; }

#define C_curdir(buf)       (getcwd(C_c_string(buf), 1024) ? C_fix(strlen(C_c_string(buf))) : C_SCHEME_FALSE)

static C_TLS struct stat C_statbuf;

#define C_stat_type         (C_statbuf.st_mode & S_IFMT)
#define C_stat(fn)          C_fix(stat((char *)C_data_pointer(fn), &C_statbuf))
#define C_fstat(f)          C_fix(fstat(C_unfix(f), &C_statbuf))

#ifndef S_IFSOCK
# define S_IFSOCK           0140000
#endif

#define cpy_tmvec_to_tmstc08(ptm, v) \
    ((ptm)->tm_sec = C_unfix(C_block_item((v), 0)), \
    (ptm)->tm_min = C_unfix(C_block_item((v), 1)), \
    (ptm)->tm_hour = C_unfix(C_block_item((v), 2)), \
    (ptm)->tm_mday = C_unfix(C_block_item((v), 3)), \
    (ptm)->tm_mon = C_unfix(C_block_item((v), 4)), \
    (ptm)->tm_year = C_unfix(C_block_item((v), 5)), \
    (ptm)->tm_wday = C_unfix(C_block_item((v), 6)), \
    (ptm)->tm_yday = C_unfix(C_block_item((v), 7)), \
    (ptm)->tm_isdst = (C_block_item((v), 8) != C_SCHEME_FALSE))

#define cpy_tmvec_to_tmstc9(ptm, v) \
    (((struct tm *)ptm)->tm_gmtoff = -C_unfix(C_block_item((v), 9)))

#define C_tm_set_08(v, tm)  cpy_tmvec_to_tmstc08( (tm), (v) )
#define C_tm_set_9(v, tm)   cpy_tmvec_to_tmstc9( (tm), (v) )

static struct tm *
C_tm_set( C_word v, void *tm )
{
  C_tm_set_08( v, (struct tm *)tm );
#if defined(C_GNU_ENV) && !defined(__CYGWIN__) && !defined(__uClinux__)
  C_tm_set_9( v, (struct tm *)tm );
#endif
  return tm;
}

#define TIME_STRING_MAXLENGTH 255
static char C_time_string [TIME_STRING_MAXLENGTH + 1];
#undef TIME_STRING_MAXLENGTH

#define C_strftime(v, f, tm) \
        (strftime(C_time_string, sizeof(C_time_string), C_c_string(f), C_tm_set((v), (tm))) ? C_time_string : NULL)
#define C_a_mktime(ptr, c, v, tm)  C_flonum(ptr, mktime(C_tm_set((v), C_data_pointer(tm))))
#define C_asctime(v, tm)    (asctime(C_tm_set((v), (tm))))

#define C_fdopen(a, n, fd, m) C_mpointer(a, fdopen(C_unfix(fd), C_c_string(m)))
#define C_C_fileno(p)       C_fix(fileno(C_port_file(p)))
#define C_dup(x)            C_fix(dup(C_unfix(x)))
#define C_dup2(x, y)        C_fix(dup2(C_unfix(x), C_unfix(y)))

#define C_set_file_ptr(port, ptr)  (C_set_block_item(port, 0, (C_block_item(ptr, 0))), C_SCHEME_UNDEFINED)

#define C_opendir(x,h)      C_set_block_item(h, 0, (C_word) opendir(C_c_string(x)))
#define C_closedir(h)       (closedir((DIR *)C_block_item(h, 0)), C_SCHEME_UNDEFINED)
#define C_readdir(h,e)      C_set_block_item(e, 0, (C_word) readdir((DIR *)C_block_item(h, 0)))
#define C_foundfile(e,b,l)    (C_strlcpy(C_c_string(b), ((struct dirent *) C_block_item(e, 0))->d_name, l), C_fix(strlen(((struct dirent *) C_block_item(e, 0))->d_name)))

#ifdef HAVE_SETENV
# define C_unsetenv(s)      (unsetenv((char *)C_data_pointer(s)), C_SCHEME_TRUE)
# define C_setenv(x, y)     C_fix(setenv((char *)C_data_pointer(x), (char *)C_data_pointer(y), 1))
#else
# if defined(_WIN32) && !defined(__CYGWIN__)
#  define C_unsetenv(s)      C_setenv(s, C_SCHEME_FALSE)
# else
#  define C_unsetenv(s)      C_fix(putenv((char *)C_data_pointer(s)))
# endif
static C_word C_fcall C_setenv(C_word x, C_word y) {
  char *sx = C_c_string(x),
       *sy = (y == C_SCHEME_FALSE ? "" : C_c_string(y));
  int n1 = C_strlen(sx), n2 = C_strlen(sy);
  int buf_len = n1 + n2 + 2;
  char *buf = (char *)C_malloc(buf_len);
  if(buf == NULL) return(C_fix(0));
  else {
    C_strlcpy(buf, sx, buf_len);
    C_strlcat(buf, "=", buf_len);
    C_strlcat(buf, sy, buf_len);
    return(C_fix(putenv(buf)));
  }
}
#endif

#ifndef S_IFLNK
#define S_IFLNK S_IFREG
#endif

#ifndef S_IFREG
#define S_IFREG S_IFREG
#endif

#ifndef S_IFDIR
#define S_IFDIR S_IFREG
#endif

#ifndef S_IFCHR
#define S_IFCHR S_IFREG
#endif

#ifndef S_IFBLK
#define S_IFBLK S_IFREG
#endif

#ifndef S_IFSOCK
#define S_IFSOCK S_IFREG
#endif

#ifndef S_IFIFO
#define S_IFIFO S_IFREG
#endif

static C_TLS int C_wait_status;

#include <sys/time.h>
#include <sys/wait.h>
#include <sys/utsname.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <dirent.h>
#include <pwd.h>
#include <utime.h>

#if defined(__sun) && defined(__SVR4)
# include <sys/tty.h>
# include <termios.h>
#endif

#ifdef HAVE_GRP_H
#include <grp.h>
#endif

#include <sys/mman.h>
#include <sys/poll.h>

#ifndef O_FSYNC
# define O_FSYNC O_SYNC
#endif

#ifndef PIPE_BUF
# ifdef __CYGWIN__
#  define PIPE_BUF       _POSIX_PIPE_BUF
# else
#  define PIPE_BUF 1024
# endif
#endif

#ifndef O_BINARY
# define O_BINARY        0
#endif
#ifndef O_TEXT
# define O_TEXT          0
#endif

#ifndef ARG_MAX
# define ARG_MAX 256
#endif

#ifndef MAP_FILE
# define MAP_FILE    0
#endif

#ifndef MAP_ANON
# define MAP_ANON    0
#endif

#if defined(HAVE_CRT_EXTERNS_H)
# include <crt_externs.h>
# define C_getenventry(i)       ((*_NSGetEnviron())[ i ])
#elif defined(C_MACOSX)
# define C_getenventry(i)       NULL
#else
extern char **environ;
# define C_getenventry(i)       (environ[ i ])
#endif

#ifndef ENV_MAX
# define ENV_MAX        1024
#endif

#ifndef FILENAME_MAX
# define FILENAME_MAX          1024
#endif

static C_TLS char *C_exec_args[ ARG_MAX ];
static C_TLS char *C_exec_env[ ENV_MAX ];
static C_TLS struct utsname C_utsname;
static C_TLS struct flock C_flock;
static C_TLS DIR *temphandle;
static C_TLS struct passwd *C_user;
#ifdef HAVE_GRP_H
static C_TLS struct group *C_group;
#else
static C_TLS struct {
  char *gr_name, gr_passwd;
  int gr_gid;
  char *gr_mem[ 1 ];
} C_group = { "", "", 0, { "" } };
#endif

/* Android doesn't provide pw_gecos in the passwd struct */
#ifdef __ANDROID__
# define C_PW_GECOS ("")
#else
# define C_PW_GECOS (C_user->pw_gecos)
#endif

static C_TLS int C_pipefds[ 2 ];
static C_TLS time_t C_secs;
static C_TLS struct timeval C_timeval;
static C_TLS char C_hostbuf[ 256 ];
static C_TLS struct stat C_statbuf;

#define C_mkdir(str)        C_fix(mkdir(C_c_string(str), S_IRWXU | S_IRWXG | S_IRWXO))
#define C_fchdir(fd)        C_fix(fchdir(C_unfix(fd)))
#define C_chdir(str)        C_fix(chdir(C_c_string(str)))
#define C_rmdir(str)        C_fix(rmdir(C_c_string(str)))

#define open_binary_input_pipe(a, n, name)   C_mpointer(a, popen(C_c_string(name), "r"))
#define open_text_input_pipe(a, n, name)     open_binary_input_pipe(a, n, name)
#define open_binary_output_pipe(a, n, name)  C_mpointer(a, popen(C_c_string(name), "w"))
#define open_text_output_pipe(a, n, name)    open_binary_output_pipe(a, n, name)
#define close_pipe(p)                        C_fix(pclose(C_port_file(p)))

#define C_fork              fork
#define C_waitpid(id, o)    C_fix(waitpid(C_unfix(id), &C_wait_status, C_unfix(o)))
#define C_getppid           getppid
#define C_kill(id, s)       C_fix(kill(C_unfix(id), C_unfix(s)))
#define C_getuid            getuid
#define C_getgid            getgid
#define C_geteuid           geteuid
#define C_getegid           getegid
#define C_chown(fn, u, g)   C_fix(chown(C_data_pointer(fn), C_unfix(u), C_unfix(g)))
#define C_chmod(fn, m)      C_fix(chmod(C_data_pointer(fn), C_unfix(m)))
#define C_setuid(id)        C_fix(setuid(C_unfix(id)))
#define C_setgid(id)        C_fix(setgid(C_unfix(id)))
#define C_seteuid(id)       C_fix(seteuid(C_unfix(id)))
#define C_setegid(id)       C_fix(setegid(C_unfix(id)))
#define C_setsid(dummy)     C_fix(setsid())
#define C_setpgid(x, y)     C_fix(setpgid(C_unfix(x), C_unfix(y)))
#define C_getpgid(x)        C_fix(getpgid(C_unfix(x)))
#define C_symlink(o, n)     C_fix(symlink(C_data_pointer(o), C_data_pointer(n)))
#define C_do_readlink(f, b)    C_fix(readlink(C_data_pointer(f), C_data_pointer(b), FILENAME_MAX))
#define C_getpwnam(n)       C_mk_bool((C_user = getpwnam((char *)C_data_pointer(n))) != NULL)
#define C_getpwuid(u)       C_mk_bool((C_user = getpwuid(C_unfix(u))) != NULL)
#if !defined(__ANDROID__) && defined(HAVE_GRP_H)
#define C_getgrnam(n)       C_mk_bool((C_group = getgrnam((char *)C_data_pointer(n))) != NULL)
#define C_getgrgid(u)       C_mk_bool((C_group = getgrgid(C_unfix(u))) != NULL)
#else
#define C_getgrnam(n)       C_SCHEME_FALSE
#define C_getgrgid(n)       C_SCHEME_FALSE
#endif
#define C_pipe(d)           C_fix(pipe(C_pipefds))
#define C_truncate(f, n)    C_fix(truncate((char *)C_data_pointer(f), C_num_to_int(n)))
#define C_ftruncate(f, n)   C_fix(ftruncate(C_unfix(f), C_num_to_int(n)))
#define C_uname             C_fix(uname(&C_utsname))
#define C_alarm             alarm
#define C_setvbuf(p, m, s)  C_fix(setvbuf(C_port_file(p), NULL, C_unfix(m), C_unfix(s)))
#define C_test_access(fn, m)     C_fix(access((char *)C_data_pointer(fn), C_unfix(m)))
#define C_close(fd)         C_fix(close(C_unfix(fd)))
#define C_sleep             sleep
#define C_umask(m)          C_fix(umask(C_unfix(m)))

#define C_lstat(fn)         C_fix(lstat((char *)C_data_pointer(fn), &C_statbuf))

static void C_fcall C_set_arg_string(char **where, int i, char *a, int len) {
  char *ptr;
  if(a != NULL) {
    ptr = (char *)C_malloc(len + 1);
    C_memcpy(ptr, a, len);
    ptr[ len ] = '\0';
    /* Can't barf() here, so the NUL byte check happens in Scheme */
  }
  else ptr = NULL;
  where[ i ] = ptr;
}

static void C_fcall C_free_arg_string(char **where) {
  while((*where) != NULL) C_free(*(where++));
}

#define C_set_exec_arg(i, a, len)	C_set_arg_string(C_exec_args, i, a, len)
#define C_free_exec_args()		C_free_arg_string(C_exec_args)
#define C_set_exec_env(i, a, len)	C_set_arg_string(C_exec_env, i, a, len)
#define C_free_exec_env()		C_free_arg_string(C_exec_env)

#define C_execvp(f)         C_fix(execvp(C_data_pointer(f), C_exec_args))
#define C_execve(f)         C_fix(execve(C_data_pointer(f), C_exec_args, C_exec_env))

#if defined(__FreeBSD__) || defined(C_MACOSX) || defined(__NetBSD__) || defined(__OpenBSD__) || defined(__sgi__) || defined(sgi) || defined(__DragonFly__) || defined(__SUNPRO_C)
static C_TLS int C_uw;
# define C_WIFEXITED(n)      (C_uw = C_unfix(n), C_mk_bool(WIFEXITED(C_uw)))
# define C_WIFSIGNALED(n)    (C_uw = C_unfix(n), C_mk_bool(WIFSIGNALED(C_uw)))
# define C_WIFSTOPPED(n)     (C_uw = C_unfix(n), C_mk_bool(WIFSTOPPED(C_uw)))
# define C_WEXITSTATUS(n)    (C_uw = C_unfix(n), C_fix(WEXITSTATUS(C_uw)))
# define C_WTERMSIG(n)       (C_uw = C_unfix(n), C_fix(WTERMSIG(C_uw)))
# define C_WSTOPSIG(n)       (C_uw = C_unfix(n), C_fix(WSTOPSIG(C_uw)))
#else
# define C_WIFEXITED(n)      C_mk_bool(WIFEXITED(C_unfix(n)))
# define C_WIFSIGNALED(n)    C_mk_bool(WIFSIGNALED(C_unfix(n)))
# define C_WIFSTOPPED(n)     C_mk_bool(WIFSTOPPED(C_unfix(n)))
# define C_WEXITSTATUS(n)    C_fix(WEXITSTATUS(C_unfix(n)))
# define C_WTERMSIG(n)       C_fix(WTERMSIG(C_unfix(n)))
# define C_WSTOPSIG(n)       C_fix(WSTOPSIG(C_unfix(n)))
#endif

#ifdef __CYGWIN__
# define C_mkfifo(fn, m)    C_fix(-1);
#else
# define C_mkfifo(fn, m)    C_fix(mkfifo((char *)C_data_pointer(fn), C_unfix(m)))
#endif

#define C_flock_setup(t, s, n) (C_flock.l_type = C_unfix(t), C_flock.l_start = C_num_to_int(s), C_flock.l_whence = SEEK_SET, C_flock.l_len = C_num_to_int(n), C_SCHEME_UNDEFINED)
#define C_flock_test(p)     (fcntl(fileno(C_port_file(p)), F_GETLK, &C_flock) >= 0 ? (C_flock.l_type == F_UNLCK ? C_fix(0) : C_fix(C_flock.l_pid)) : C_SCHEME_FALSE)
#define C_flock_lock(p)     C_fix(fcntl(fileno(C_port_file(p)), F_SETLK, &C_flock))
#define C_flock_lockw(p)    C_fix(fcntl(fileno(C_port_file(p)), F_SETLKW, &C_flock))

static C_TLS sigset_t C_sigset;
#define C_sigemptyset(d)    (sigemptyset(&C_sigset), C_SCHEME_UNDEFINED)
#define C_sigaddset(s)      (sigaddset(&C_sigset, C_unfix(s)), C_SCHEME_UNDEFINED)
#define C_sigdelset(s)      (sigdelset(&C_sigset, C_unfix(s)), C_SCHEME_UNDEFINED)
#define C_sigismember(s)    C_mk_bool(sigismember(&C_sigset, C_unfix(s)))
#define C_sigprocmask_set(d)        C_fix(sigprocmask(SIG_SETMASK, &C_sigset, NULL))
#define C_sigprocmask_block(d)      C_fix(sigprocmask(SIG_BLOCK, &C_sigset, NULL))
#define C_sigprocmask_unblock(d)    C_fix(sigprocmask(SIG_UNBLOCK, &C_sigset, NULL))
#define C_sigprocmask_get(d)        C_fix(sigprocmask(SIG_SETMASK, NULL, &C_sigset))

#define C_open(fn, fl, m)   C_fix(open(C_c_string(fn), C_unfix(fl), C_unfix(m)))
#define C_read(fd, b, n)    C_fix(read(C_unfix(fd), C_data_pointer(b), C_unfix(n)))
#define C_write(fd, b, n)   C_fix(write(C_unfix(fd), C_data_pointer(b), C_unfix(n)))
#define C_mkstemp(t)        C_fix(mkstemp(C_c_string(t)))

/* It is assumed that 'int' is-a 'long' */
#define C_ftell(p)          C_fix(ftell(C_port_file(p)))
#define C_fseek(p, n, w)    C_mk_nbool(fseek(C_port_file(p), C_num_to_int(n), C_unfix(w)))
#define C_lseek(fd, o, w)     C_fix(lseek(C_unfix(fd), C_unfix(o), C_unfix(w)))

#define C_ctime(n)          (C_secs = (n), ctime(&C_secs))

#if defined(__SVR4) || defined(C_MACOSX) || defined(__ANDROID__) || defined(_AIX)
/* Seen here: http://lists.samba.org/archive/samba-technical/2002-November/025571.html */

static time_t C_timegm(struct tm *t)
{
  time_t tl, tb;
  struct tm *tg;

  tl = mktime (t);
  if (tl == -1)
    {
      t->tm_hour--;
      tl = mktime (t);
      if (tl == -1)
        return -1; /* can't deal with output from strptime */
      tl += 3600;
    }
  tg = gmtime (&tl);
  tg->tm_isdst = 0;
  tb = mktime (tg);
  if (tb == -1)
    {
      tg->tm_hour--;
      tb = mktime (tg);
      if (tb == -1)
        return -1; /* can't deal with output from gmtime */
      tb += 3600;
    }
  return (tl - (tb - tl));
}
#else
#define C_timegm timegm
#endif

#define C_a_timegm(ptr, c, v, tm)  C_flonum(ptr, C_timegm(C_tm_set((v), C_data_pointer(tm))))

#ifdef __linux__
extern char *strptime(const char *s, const char *format, struct tm *tm);
extern pid_t getpgid(pid_t pid);
#endif

/* tm_get could be in posix-common, but it's only used in here */
#define cpy_tmstc08_to_tmvec(v, ptm) \
    (C_set_block_item((v), 0, C_fix(((struct tm *)ptm)->tm_sec)), \
    C_set_block_item((v), 1, C_fix((ptm)->tm_min)), \
    C_set_block_item((v), 2, C_fix((ptm)->tm_hour)), \
    C_set_block_item((v), 3, C_fix((ptm)->tm_mday)), \
    C_set_block_item((v), 4, C_fix((ptm)->tm_mon)), \
    C_set_block_item((v), 5, C_fix((ptm)->tm_year)), \
    C_set_block_item((v), 6, C_fix((ptm)->tm_wday)), \
    C_set_block_item((v), 7, C_fix((ptm)->tm_yday)), \
    C_set_block_item((v), 8, ((ptm)->tm_isdst ? C_SCHEME_TRUE : C_SCHEME_FALSE)))

#define cpy_tmstc9_to_tmvec(v, ptm) \
    (C_set_block_item((v), 9, C_fix(-(ptm)->tm_gmtoff)))

#define C_tm_get_08(v, tm)  cpy_tmstc08_to_tmvec( (v), (tm) )
#define C_tm_get_9(v, tm)   cpy_tmstc9_to_tmvec( (v), (tm) )

static C_word
C_tm_get( C_word v, void *tm )
{
  C_tm_get_08( v, (struct tm *)tm );
#if defined(C_GNU_ENV) && !defined(__CYGWIN__) && !defined(__uClinux__)
  C_tm_get_9( v, (struct tm *)tm );
#endif
  return v;
}

#define C_strptime(s, f, v, stm) \
        (strptime(C_c_string(s), C_c_string(f), ((struct tm *)(stm))) ? C_tm_get((v), (stm)) : C_SCHEME_FALSE)

static gid_t *C_groups = NULL;

#define C_get_gid(n)      C_fix(C_groups[ C_unfix(n) ])
#define C_set_gid(n, id)  (C_groups[ C_unfix(n) ] = C_unfix(id), C_SCHEME_UNDEFINED)
#define C_set_groups(n)   C_fix(setgroups(C_unfix(n), C_groups))

#if !defined(__ANDROID__) && defined(TIOCGWINSZ)
static int get_tty_size(int p, int *rows, int *cols)
{
 struct winsize tty_size;
 int r;

 memset(&tty_size, 0, sizeof tty_size);

 r = ioctl(p, TIOCGWINSZ, &tty_size);
 if (r == 0) {
    *rows = tty_size.ws_row;
    *cols = tty_size.ws_col;
 }
 return r;
}
#else
static int get_tty_size(int p, int *rows, int *cols)
{
 *rows = *cols = 0;
 return -1;
}
#endif

static int set_file_mtime(char *filename, C_word tm)
{
  struct utimbuf tb;

  tb.actime = tb.modtime = C_num_to_int(tm);
  return utime(filename, &tb);
}

static C_word C_i_fifo_p(C_word name) 
{
  struct stat buf;
  int res;

  res = stat(C_c_string(name), &buf);

  if(res != 0) {
#ifdef __CYGWIN__
    return C_SCHEME_FALSE;
#else
    if(errno == ENOENT) return C_fix(0);
    else return C_fix(res);
#endif
  }

  if((buf.st_mode & S_IFMT) == S_IFIFO) return C_SCHEME_TRUE;
  else return C_SCHEME_FALSE;
}


static C_PTABLE_ENTRY *create_ptable(void);
C_noret_decl(C_scheduler_toplevel)
C_externimport void C_ccall C_scheduler_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_irregex_toplevel)
C_externimport void C_ccall C_irregex_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_extras_toplevel)
C_externimport void C_ccall C_extras_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_files_toplevel)
C_externimport void C_ccall C_files_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_ports_toplevel)
C_externimport void C_ccall C_ports_toplevel(C_word c,C_word d,C_word k) C_noret;

static C_TLS C_word lf[466];
static double C_possibly_force_alignment;
static C_char C_TLS li0[] C_aligned={C_lihdr(0,0,41),40,112,111,115,105,120,45,101,114,114,111,114,32,116,121,112,101,55,49,32,108,111,99,55,50,32,109,115,103,55,51,32,46,32,97,114,103,115,55,52,41,0,0,0,0,0,0,0};
static C_char C_TLS li1[] C_aligned={C_lihdr(0,0,38),40,35,35,115,121,115,35,115,116,97,116,32,102,105,108,101,56,54,32,108,105,110,107,56,55,32,101,114,114,56,56,32,108,111,99,56,57,41,0,0};
static C_char C_TLS li2[] C_aligned={C_lihdr(0,0,28),40,102,105,108,101,45,115,116,97,116,32,102,49,48,50,32,46,32,116,109,112,49,48,49,49,48,51,41,0,0,0,0};
static C_char C_TLS li3[] C_aligned={C_lihdr(0,0,23),40,102,105,108,101,45,97,99,99,101,115,115,45,116,105,109,101,32,102,49,50,56,41,0};
static C_char C_TLS li4[] C_aligned={C_lihdr(0,0,23),40,102,105,108,101,45,99,104,97,110,103,101,45,116,105,109,101,32,102,49,51,49,41,0};
static C_char C_TLS li5[] C_aligned={C_lihdr(0,0,17),40,102,105,108,101,45,111,119,110,101,114,32,102,49,51,52,41,0,0,0,0,0,0,0};
static C_char C_TLS li6[] C_aligned={C_lihdr(0,0,23),40,102,105,108,101,45,112,101,114,109,105,115,115,105,111,110,115,32,102,49,51,55,41,0};
static C_char C_TLS li7[] C_aligned={C_lihdr(0,0,16),40,102,105,108,101,45,115,105,122,101,32,102,49,52,48,41};
static C_char C_TLS li8[] C_aligned={C_lihdr(0,0,31),40,102,105,108,101,45,116,121,112,101,32,102,105,108,101,49,52,56,32,46,32,116,109,112,49,52,55,49,52,57,41,0};
static C_char C_TLS li9[] C_aligned={C_lihdr(0,0,23),40,114,101,103,117,108,97,114,45,102,105,108,101,63,32,102,105,108,101,49,54,55,41,0};
static C_char C_TLS li10[] C_aligned={C_lihdr(0,0,24),40,115,121,109,98,111,108,105,99,45,108,105,110,107,63,32,102,105,108,101,49,54,57,41};
static C_char C_TLS li11[] C_aligned={C_lihdr(0,0,23),40,98,108,111,99,107,45,100,101,118,105,99,101,63,32,102,105,108,101,49,55,49,41,0};
static C_char C_TLS li12[] C_aligned={C_lihdr(0,0,27),40,99,104,97,114,97,99,116,101,114,45,100,101,118,105,99,101,63,32,102,105,108,101,49,55,51,41,0,0,0,0,0};
static C_char C_TLS li13[] C_aligned={C_lihdr(0,0,16),40,102,95,50,57,48,57,32,102,105,108,101,49,55,53,41};
static C_char C_TLS li14[] C_aligned={C_lihdr(0,0,17),40,115,111,99,107,101,116,63,32,102,105,108,101,49,55,55,41,0,0,0,0,0,0,0};
static C_char C_TLS li15[] C_aligned={C_lihdr(0,0,20),40,100,105,114,101,99,116,111,114,121,63,32,102,105,108,101,49,55,57,41,0,0,0,0};
static C_char C_TLS li16[] C_aligned={C_lihdr(0,0,25),40,109,111,100,101,32,105,110,112,49,56,53,32,109,49,56,54,32,108,111,99,49,56,55,41,0,0,0,0,0,0,0};
static C_char C_TLS li17[] C_aligned={C_lihdr(0,0,32),40,99,104,101,99,107,32,108,111,99,49,57,57,32,102,100,50,48,48,32,105,110,112,50,48,49,32,114,50,48,50,41};
static C_char C_TLS li18[] C_aligned={C_lihdr(0,0,31),40,111,112,101,110,45,105,110,112,117,116,45,102,105,108,101,42,32,102,100,50,48,53,32,46,32,109,50,48,54,41,0};
static C_char C_TLS li19[] C_aligned={C_lihdr(0,0,32),40,111,112,101,110,45,111,117,116,112,117,116,45,102,105,108,101,42,32,102,100,50,48,56,32,46,32,109,50,48,57,41};
static C_char C_TLS li20[] C_aligned={C_lihdr(0,0,22),40,112,111,114,116,45,62,102,105,108,101,110,111,32,112,111,114,116,50,49,53,41,0,0};
static C_char C_TLS li21[] C_aligned={C_lihdr(0,0,34),40,100,117,112,108,105,99,97,116,101,45,102,105,108,101,110,111,32,111,108,100,50,50,52,32,46,32,110,101,119,50,50,53,41,0,0,0,0,0,0};
static C_char C_TLS li22[] C_aligned={C_lihdr(0,0,31),40,99,117,114,114,101,110,116,45,100,105,114,101,99,116,111,114,121,32,46,32,116,109,112,50,51,54,50,51,55,41,0};
static C_char C_TLS li23[] C_aligned={C_lihdr(0,0,14),40,114,109,100,105,114,32,100,105,114,50,54,52,41,0,0};
static C_char C_TLS li24[] C_aligned={C_lihdr(0,0,11),40,103,50,55,49,32,102,50,56,48,41,0,0,0,0,0};
static C_char C_TLS li25[] C_aligned={C_lihdr(0,0,26),40,102,111,114,45,101,97,99,104,45,108,111,111,112,50,55,48,32,103,50,55,55,50,56,56,41,0,0,0,0,0,0};
static C_char C_TLS li26[] C_aligned={C_lihdr(0,0,38),40,100,101,108,101,116,101,45,100,105,114,101,99,116,111,114,121,32,110,97,109,101,50,53,54,32,46,32,116,109,112,50,53,53,50,53,55,41,0,0};
static C_char C_TLS li27[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char C_TLS li28[] C_aligned={C_lihdr(0,0,23),40,100,105,114,101,99,116,111,114,121,32,46,32,116,109,112,51,48,48,51,48,49,41,0};
static C_char C_TLS li29[] C_aligned={C_lihdr(0,0,7),40,97,51,51,56,54,41,0};
static C_char C_TLS li30[] C_aligned={C_lihdr(0,0,11),40,103,51,54,51,32,109,51,54,53,41,0,0,0,0,0};
static C_char C_TLS li31[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,102,110,115,51,53,54,41,0,0,0};
static C_char C_TLS li32[] C_aligned={C_lihdr(0,0,46),40,97,51,51,57,50,32,100,105,114,51,51,57,51,52,48,51,52,53,32,102,105,108,51,52,49,51,52,50,51,52,54,32,101,120,116,51,52,51,51,52,52,51,52,55,41,0,0};
static C_char C_TLS li33[] C_aligned={C_lihdr(0,0,20),40,99,111,110,99,45,108,111,111,112,32,112,97,116,104,115,51,51,55,41,0,0,0,0};
static C_char C_TLS li34[] C_aligned={C_lihdr(0,0,17),40,103,108,111,98,32,46,32,112,97,116,104,115,51,51,53,41,0,0,0,0,0,0,0};
static C_char C_TLS li35[] C_aligned={C_lihdr(0,0,7),40,97,51,53,53,54,41,0};
static C_char C_TLS li36[] C_aligned={C_lihdr(0,0,7),40,97,51,53,54,49,41,0};
static C_char C_TLS li37[] C_aligned={C_lihdr(0,0,7),40,97,51,53,56,57,41,0};
static C_char C_TLS li38[] C_aligned={C_lihdr(0,0,17),40,108,111,111,112,32,102,115,51,57,50,32,114,51,57,51,41,0,0,0,0,0,0,0};
static C_char C_TLS li39[] C_aligned={C_lihdr(0,0,13),40,102,95,51,54,52,55,32,120,51,57,48,41,0,0,0};
static C_char C_TLS li40[] C_aligned={C_lihdr(0,0,15),40,102,95,51,54,54,51,32,46,32,95,51,56,55,41,0};
static C_char C_TLS li41[] C_aligned={C_lihdr(0,0,15),40,102,95,51,54,53,53,32,46,32,95,51,56,54,41,0};
static C_char C_TLS li42[] C_aligned={C_lihdr(0,0,7),40,97,51,54,57,50,41,0};
static C_char C_TLS li43[] C_aligned={C_lihdr(0,0,7),40,97,51,54,57,53,41,0};
static C_char C_TLS li44[] C_aligned={C_lihdr(0,0,7),40,97,51,54,57,56,41,0};
static C_char C_TLS li45[] C_aligned={C_lihdr(0,0,7),40,97,51,55,48,49,41,0};
static C_char C_TLS li46[] C_aligned={C_lihdr(0,0,18),40,102,95,51,55,48,55,32,120,52,50,56,32,121,52,50,57,41,0,0,0,0,0,0};
static C_char C_TLS li47[] C_aligned={C_lihdr(0,0,7),40,97,51,55,48,52,41,0};
static C_char C_TLS li48[] C_aligned={C_lihdr(0,0,15),40,102,95,51,55,49,53,32,46,32,95,52,50,54,41,0};
static C_char C_TLS li49[] C_aligned={C_lihdr(0,0,7),40,97,51,55,49,50,41,0};
static C_char C_TLS li50[] C_aligned={C_lihdr(0,0,31),40,102,105,110,100,45,102,105,108,101,115,32,100,105,114,52,50,51,32,46,32,116,109,112,52,50,50,52,50,52,41,0};
static C_char C_TLS li51[] C_aligned={C_lihdr(0,0,32),40,99,104,101,99,107,45,116,105,109,101,45,118,101,99,116,111,114,32,108,111,99,52,53,53,32,116,109,52,53,54,41};
static C_char C_TLS li52[] C_aligned={C_lihdr(0,0,33),40,115,101,99,111,110,100,115,45,62,108,111,99,97,108,45,116,105,109,101,32,46,32,116,109,112,52,54,51,52,54,52,41,0,0,0,0,0,0,0};
static C_char C_TLS li53[] C_aligned={C_lihdr(0,0,31),40,115,101,99,111,110,100,115,45,62,117,116,99,45,116,105,109,101,32,46,32,116,109,112,52,55,54,52,55,55,41,0};
static C_char C_TLS li54[] C_aligned={C_lihdr(0,0,29),40,115,101,99,111,110,100,115,45,62,115,116,114,105,110,103,32,46,32,116,109,112,52,57,53,52,57,54,41,0,0,0};
static C_char C_TLS li55[] C_aligned={C_lihdr(0,0,27),40,108,111,99,97,108,45,116,105,109,101,45,62,115,101,99,111,110,100,115,32,116,109,53,48,55,41,0,0,0,0,0};
static C_char C_TLS li56[] C_aligned={C_lihdr(0,0,32),40,116,105,109,101,45,62,115,116,114,105,110,103,32,116,109,53,52,48,32,46,32,116,109,112,53,51,57,53,52,49,41};
static C_char C_TLS li57[] C_aligned={C_lihdr(0,0,22),40,115,101,116,101,110,118,32,118,97,114,53,53,52,32,118,97,108,53,53,53,41,0,0};
static C_char C_TLS li58[] C_aligned={C_lihdr(0,0,17),40,117,110,115,101,116,101,110,118,32,118,97,114,53,54,48,41,0,0,0,0,0,0,0};
static C_char C_TLS li59[] C_aligned={C_lihdr(0,0,11),40,115,99,97,110,32,106,53,55,52,41,0,0,0,0,0};
static C_char C_TLS li60[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,105,53,55,49,41,0,0,0,0,0};
static C_char C_TLS li61[] C_aligned={C_lihdr(0,0,27),40,103,101,116,45,101,110,118,105,114,111,110,109,101,110,116,45,118,97,114,105,97,98,108,101,115,41,0,0,0,0,0};
static C_char C_TLS li62[] C_aligned={C_lihdr(0,0,36),40,115,101,116,45,115,105,103,110,97,108,45,104,97,110,100,108,101,114,33,32,115,105,103,53,55,56,32,112,114,111,99,53,55,57,41,0,0,0,0};
static C_char C_TLS li63[] C_aligned={C_lihdr(0,0,20),40,99,117,114,114,101,110,116,45,112,114,111,99,101,115,115,45,105,100,41,0,0,0,0};
static C_char C_TLS li64[] C_aligned={C_lihdr(0,0,7),40,97,52,48,56,55,41,0};
static C_char C_TLS li65[] C_aligned={C_lihdr(0,0,33),40,97,52,48,57,51,32,101,112,105,100,54,48,51,32,101,110,111,114,109,54,48,52,32,101,99,111,100,101,54,48,53,41,0,0,0,0,0,0,0};
static C_char C_TLS li66[] C_aligned={C_lihdr(0,0,24),40,112,114,111,99,101,115,115,45,119,97,105,116,32,46,32,97,114,103,115,53,56,56,41};
static C_char C_TLS li67[] C_aligned={C_lihdr(0,0,34),40,35,35,115,121,115,35,102,105,108,101,45,110,111,110,98,108,111,99,107,105,110,103,33,32,102,100,54,53,49,54,53,52,41,0,0,0,0,0,0};
static C_char C_TLS li68[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,102,105,108,101,45,115,101,108,101,99,116,45,111,110,101,32,105,110,116,54,53,54,54,53,57,41,0,0,0,0,0,0,0};
static C_char C_TLS li69[] C_aligned={C_lihdr(0,0,39),40,102,105,108,101,45,99,111,110,116,114,111,108,32,102,100,55,49,49,32,99,109,100,55,49,50,32,46,32,116,109,112,55,49,48,55,49,51,41,0};
static C_char C_TLS li70[] C_aligned={C_lihdr(0,0,42),40,102,105,108,101,45,111,112,101,110,32,102,105,108,101,110,97,109,101,55,50,52,32,102,108,97,103,115,55,50,53,32,46,32,109,111,100,101,55,50,54,41,0,0,0,0,0,0};
static C_char C_TLS li71[] C_aligned={C_lihdr(0,0,18),40,102,105,108,101,45,99,108,111,115,101,32,102,100,55,51,52,41,0,0,0,0,0,0};
static C_char C_TLS li72[] C_aligned={C_lihdr(0,0,37),40,102,105,108,101,45,114,101,97,100,32,102,100,55,51,55,32,115,105,122,101,55,51,56,32,46,32,98,117,102,102,101,114,55,51,57,41,0,0,0};
static C_char C_TLS li73[] C_aligned={C_lihdr(0,0,38),40,102,105,108,101,45,119,114,105,116,101,32,102,100,55,52,56,32,98,117,102,102,101,114,55,52,57,32,46,32,115,105,122,101,55,53,48,41,0,0};
static C_char C_TLS li74[] C_aligned={C_lihdr(0,0,26),40,102,105,108,101,45,109,107,115,116,101,109,112,32,116,101,109,112,108,97,116,101,55,53,57,41,0,0,0,0,0,0};
static C_char C_TLS li75[] C_aligned={C_lihdr(0,0,20),40,100,111,108,111,111,112,55,56,55,32,102,100,115,114,108,55,57,48,41,0,0,0,0};
static C_char C_TLS li76[] C_aligned={C_lihdr(0,0,20),40,100,111,108,111,111,112,56,48,53,32,102,100,115,119,108,56,48,56,41,0,0,0,0};
static C_char C_TLS li77[] C_aligned={C_lihdr(0,0,23),40,108,112,32,105,56,54,50,32,114,101,115,56,54,51,32,102,100,115,56,54,52,41,0};
static C_char C_TLS li78[] C_aligned={C_lihdr(0,0,23),40,108,112,32,105,56,52,51,32,114,101,115,56,52,52,32,102,100,115,56,52,53,41,0};
static C_char C_TLS li79[] C_aligned={C_lihdr(0,0,42),40,102,105,108,101,45,115,101,108,101,99,116,32,102,100,115,114,55,54,54,32,102,100,115,119,55,54,55,32,46,32,116,105,109,101,111,117,116,55,54,56,41,0,0,0,0,0,0};
static C_char C_TLS li80[] C_aligned={C_lihdr(0,0,47),40,115,101,116,45,102,105,108,101,45,112,111,115,105,116,105,111,110,33,32,112,111,114,116,56,57,49,32,112,111,115,56,57,50,32,46,32,119,104,101,110,99,101,56,57,51,41,0};
static C_char C_TLS li81[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,100,105,114,57,50,57,41,0,0,0};
static C_char C_TLS li82[] C_aligned={C_lihdr(0,0,7),40,97,52,57,48,54,41,0};
static C_char C_TLS li83[] C_aligned={C_lihdr(0,0,47),40,97,52,57,49,50,32,100,105,114,57,51,55,57,51,56,57,52,51,32,102,105,108,101,57,51,57,57,52,48,57,52,52,32,101,120,116,57,52,49,57,52,50,57,52,53,41,0};
static C_char C_TLS li84[] C_aligned={C_lihdr(0,0,38),40,99,114,101,97,116,101,45,100,105,114,101,99,116,111,114,121,32,110,97,109,101,57,49,55,32,46,32,116,109,112,57,49,54,57,49,56,41,0,0};
static C_char C_TLS li85[] C_aligned={C_lihdr(0,0,26),40,99,104,97,110,103,101,45,100,105,114,101,99,116,111,114,121,32,110,97,109,101,57,53,54,41,0,0,0,0,0,0};
static C_char C_TLS li86[] C_aligned={C_lihdr(0,0,25),40,99,104,97,110,103,101,45,100,105,114,101,99,116,111,114,121,42,32,102,100,57,54,49,41,0,0,0,0,0,0,0};
static C_char C_TLS li87[] C_aligned={C_lihdr(0,0,33),40,99,104,101,99,107,32,108,111,99,57,54,57,32,99,109,100,57,55,48,32,105,110,112,57,55,49,32,114,57,55,50,41,0,0,0,0,0,0,0};
static C_char C_TLS li88[] C_aligned={C_lihdr(0,0,31),40,111,112,101,110,45,105,110,112,117,116,45,112,105,112,101,32,99,109,100,57,55,53,32,46,32,109,57,55,54,41,0};
static C_char C_TLS li89[] C_aligned={C_lihdr(0,0,32),40,111,112,101,110,45,111,117,116,112,117,116,45,112,105,112,101,32,99,109,100,57,56,53,32,46,32,109,57,56,54,41};
static C_char C_TLS li90[] C_aligned={C_lihdr(0,0,26),40,99,108,111,115,101,45,105,110,112,117,116,45,112,105,112,101,32,112,111,114,116,57,57,53,41,0,0,0,0,0,0};
static C_char C_TLS li91[] C_aligned={C_lihdr(0,0,27),40,99,108,111,115,101,45,111,117,116,112,117,116,45,112,105,112,101,32,112,111,114,116,57,57,57,41,0,0,0,0,0};
static C_char C_TLS li92[] C_aligned={C_lihdr(0,0,7),40,97,53,49,52,52,41,0};
static C_char C_TLS li93[] C_aligned={C_lihdr(0,0,21),40,97,53,49,53,48,32,46,32,114,101,115,117,108,116,115,49,48,49,52,41,0,0,0};
static C_char C_TLS li94[] C_aligned={C_lihdr(0,0,50),40,99,97,108,108,45,119,105,116,104,45,105,110,112,117,116,45,112,105,112,101,32,99,109,100,49,48,49,48,32,112,114,111,99,49,48,49,49,32,46,32,109,111,100,101,49,48,49,50,41,0,0,0,0,0,0};
static C_char C_TLS li95[] C_aligned={C_lihdr(0,0,7),40,97,53,49,54,56,41,0};
static C_char C_TLS li96[] C_aligned={C_lihdr(0,0,21),40,97,53,49,55,52,32,46,32,114,101,115,117,108,116,115,49,48,50,49,41,0,0,0};
static C_char C_TLS li97[] C_aligned={C_lihdr(0,0,51),40,99,97,108,108,45,119,105,116,104,45,111,117,116,112,117,116,45,112,105,112,101,32,99,109,100,49,48,49,55,32,112,114,111,99,49,48,49,56,32,46,32,109,111,100,101,49,48,49,57,41,0,0,0,0,0};
static C_char C_TLS li98[] C_aligned={C_lihdr(0,0,7),40,97,53,49,57,50,41,0};
static C_char C_TLS li99[] C_aligned={C_lihdr(0,0,21),40,97,53,50,48,51,32,46,32,114,101,115,117,108,116,115,49,48,51,54,41,0,0,0};
static C_char C_TLS li100[] C_aligned={C_lihdr(0,0,7),40,97,53,49,57,55,41,0};
static C_char C_TLS li101[] C_aligned={C_lihdr(0,0,7),40,97,53,50,49,50,41,0};
static C_char C_TLS li102[] C_aligned={C_lihdr(0,0,51),40,119,105,116,104,45,105,110,112,117,116,45,102,114,111,109,45,112,105,112,101,32,99,109,100,49,48,50,52,32,116,104,117,110,107,49,48,50,53,32,46,32,109,111,100,101,49,48,50,54,41,0,0,0,0,0};
static C_char C_TLS li103[] C_aligned={C_lihdr(0,0,7),40,97,53,50,50,54,41,0};
static C_char C_TLS li104[] C_aligned={C_lihdr(0,0,21),40,97,53,50,51,55,32,46,32,114,101,115,117,108,116,115,49,48,53,51,41,0,0,0};
static C_char C_TLS li105[] C_aligned={C_lihdr(0,0,7),40,97,53,50,51,49,41,0};
static C_char C_TLS li106[] C_aligned={C_lihdr(0,0,7),40,97,53,50,52,54,41,0};
static C_char C_TLS li107[] C_aligned={C_lihdr(0,0,50),40,119,105,116,104,45,111,117,116,112,117,116,45,116,111,45,112,105,112,101,32,99,109,100,49,48,52,49,32,116,104,117,110,107,49,48,52,50,32,46,32,109,111,100,101,49,48,52,51,41,0,0,0,0,0,0};
static C_char C_TLS li108[] C_aligned={C_lihdr(0,0,13),40,99,114,101,97,116,101,45,112,105,112,101,41,0,0,0};
static C_char C_TLS li109[] C_aligned={C_lihdr(0,0,19),40,102,111,114,45,101,97,99,104,45,108,111,111,112,49,48,57,49,41,0,0,0,0,0};
static C_char C_TLS li110[] C_aligned={C_lihdr(0,0,27),40,115,101,116,45,115,105,103,110,97,108,45,109,97,115,107,33,32,115,105,103,115,49,48,56,56,41,0,0,0,0,0};
static C_char C_TLS li111[] C_aligned={C_lihdr(0,0,24),40,115,105,103,110,97,108,45,109,97,115,107,101,100,63,32,115,105,103,49,49,49,57,41};
static C_char C_TLS li112[] C_aligned={C_lihdr(0,0,22),40,115,105,103,110,97,108,45,109,97,115,107,33,32,115,105,103,49,49,50,51,41,0,0};
static C_char C_TLS li113[] C_aligned={C_lihdr(0,0,24),40,115,105,103,110,97,108,45,117,110,109,97,115,107,33,32,115,105,103,49,49,50,56,41};
static C_char C_TLS li114[] C_aligned={C_lihdr(0,0,20),40,115,121,115,116,101,109,45,105,110,102,111,114,109,97,116,105,111,110,41,0,0,0,0};
static C_char C_TLS li115[] C_aligned={C_lihdr(0,0,41),40,117,115,101,114,45,105,110,102,111,114,109,97,116,105,111,110,32,117,115,101,114,49,49,54,49,32,46,32,116,109,112,49,49,54,48,49,49,54,50,41,0,0,0,0,0,0,0};
static C_char C_TLS li116[] C_aligned={C_lihdr(0,0,19),40,99,117,114,114,101,110,116,45,117,115,101,114,45,110,97,109,101,41,0,0,0,0,0};
static C_char C_TLS li117[] C_aligned={C_lihdr(0,0,29),40,99,117,114,114,101,110,116,45,101,102,102,101,99,116,105,118,101,45,117,115,101,114,45,110,97,109,101,41,0,0,0};
static C_char C_TLS li118[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,105,49,50,48,48,41,0,0,0,0};
static C_char C_TLS li119[] C_aligned={C_lihdr(0,0,43),40,103,114,111,117,112,45,105,110,102,111,114,109,97,116,105,111,110,32,103,114,111,117,112,49,49,56,55,32,46,32,116,109,112,49,49,56,54,49,49,56,56,41,0,0,0,0,0};
static C_char C_TLS li120[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,105,49,50,49,57,41,0,0,0,0};
static C_char C_TLS li121[] C_aligned={C_lihdr(0,0,12),40,103,101,116,45,103,114,111,117,112,115,41,0,0,0,0};
static C_char C_TLS li122[] C_aligned={C_lihdr(0,0,26),40,100,111,108,111,111,112,49,50,50,54,32,108,115,116,49,50,50,56,32,105,49,50,50,57,41,0,0,0,0,0,0};
static C_char C_TLS li123[] C_aligned={C_lihdr(0,0,22),40,115,101,116,45,103,114,111,117,112,115,33,32,108,115,116,48,49,50,50,53,41,0,0};
static C_char C_TLS li124[] C_aligned={C_lihdr(0,0,35),40,105,110,105,116,105,97,108,105,122,101,45,103,114,111,117,112,115,32,117,115,101,114,49,50,52,54,32,105,100,49,50,52,55,41,0,0,0,0,0};
static C_char C_TLS li125[] C_aligned={C_lihdr(0,0,34),40,99,104,97,110,103,101,45,102,105,108,101,45,109,111,100,101,32,102,110,97,109,101,49,50,57,49,32,109,49,50,57,50,41,0,0,0,0,0,0};
static C_char C_TLS li126[] C_aligned={C_lihdr(0,0,42),40,99,104,97,110,103,101,45,102,105,108,101,45,111,119,110,101,114,32,102,110,49,50,57,54,32,117,105,100,49,50,57,55,32,103,105,100,49,50,57,56,41,0,0,0,0,0,0};
static C_char C_TLS li127[] C_aligned={C_lihdr(0,0,36),40,99,104,101,99,107,32,102,105,108,101,110,97,109,101,49,51,48,51,32,97,99,99,49,51,48,52,32,108,111,99,49,51,48,53,41,0,0,0,0};
static C_char C_TLS li128[] C_aligned={C_lihdr(0,0,32),40,102,105,108,101,45,114,101,97,100,45,97,99,99,101,115,115,63,32,102,105,108,101,110,97,109,101,49,51,48,57,41};
static C_char C_TLS li129[] C_aligned={C_lihdr(0,0,33),40,102,105,108,101,45,119,114,105,116,101,45,97,99,99,101,115,115,63,32,102,105,108,101,110,97,109,101,49,51,49,48,41,0,0,0,0,0,0,0};
static C_char C_TLS li130[] C_aligned={C_lihdr(0,0,35),40,102,105,108,101,45,101,120,101,99,117,116,101,45,97,99,99,101,115,115,63,32,102,105,108,101,110,97,109,101,49,51,49,49,41,0,0,0,0,0};
static C_char C_TLS li131[] C_aligned={C_lihdr(0,0,16),40,99,114,101,97,116,101,45,115,101,115,115,105,111,110,41};
static C_char C_TLS li132[] C_aligned={C_lihdr(0,0,38),40,99,114,101,97,116,101,45,115,121,109,98,111,108,105,99,45,108,105,110,107,32,111,108,100,49,51,51,49,32,110,101,119,49,51,51,50,41,0,0};
static C_char C_TLS li133[] C_aligned={C_lihdr(0,0,49),40,35,35,115,121,115,35,114,101,97,100,45,115,121,109,98,111,108,105,99,45,108,105,110,107,32,102,110,97,109,101,49,51,51,55,32,108,111,99,97,116,105,111,110,49,51,51,56,41,0,0,0,0,0,0,0};
static C_char C_TLS li134[] C_aligned={C_lihdr(0,0,7),40,97,54,48,49,48,41,0};
static C_char C_TLS li135[] C_aligned={C_lihdr(0,0,32),40,108,111,111,112,32,99,111,109,112,111,110,101,110,116,115,49,51,53,56,32,114,101,115,117,108,116,49,51,53,57,41};
static C_char C_TLS li136[] C_aligned={C_lihdr(0,0,67),40,97,54,48,49,54,32,98,97,115,101,45,111,114,105,103,105,110,49,51,53,52,32,98,97,115,101,45,100,105,114,101,99,116,111,114,121,49,51,53,53,32,100,105,114,101,99,116,111,114,121,45,99,111,109,112,111,110,101,110,116,115,49,51,53,54,41,0,0,0,0,0};
static C_char C_TLS li137[] C_aligned={C_lihdr(0,0,44),40,114,101,97,100,45,115,121,109,98,111,108,105,99,45,108,105,110,107,32,102,110,97,109,101,49,51,52,54,32,46,32,116,109,112,49,51,52,53,49,51,52,55,41,0,0,0,0};
static C_char C_TLS li138[] C_aligned={C_lihdr(0,0,27),40,102,105,108,101,45,108,105,110,107,32,111,108,100,49,51,56,50,32,110,101,119,49,51,56,51,41,0,0,0,0,0};
static C_char C_TLS li139[] C_aligned={C_lihdr(0,0,8),40,114,101,97,100,121,63,41};
static C_char C_TLS li140[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char C_TLS li141[] C_aligned={C_lihdr(0,0,7),40,102,101,116,99,104,41,0};
static C_char C_TLS li142[] C_aligned={C_lihdr(0,0,7),40,97,54,51,49,50,41,0};
static C_char C_TLS li143[] C_aligned={C_lihdr(0,0,7),40,97,54,51,51,55,41,0};
static C_char C_TLS li144[] C_aligned={C_lihdr(0,0,7),40,97,54,51,52,57,41,0};
static C_char C_TLS li145[] C_aligned={C_lihdr(0,0,7),40,97,54,51,55,49,41,0};
static C_char C_TLS li146[] C_aligned={C_lihdr(0,0,28),40,108,111,111,112,32,110,49,52,54,50,32,109,49,52,54,51,32,115,116,97,114,116,49,52,54,52,41,0,0,0,0};
static C_char C_TLS li147[] C_aligned={C_lihdr(0,0,41),40,97,54,51,56,54,32,112,111,114,116,49,52,53,55,32,110,49,52,53,56,32,100,101,115,116,49,52,53,57,32,115,116,97,114,116,49,52,54,48,41,0,0,0,0,0,0,0};
static C_char C_TLS li148[] C_aligned={C_lihdr(0,0,15),40,97,54,52,57,48,32,112,111,115,49,52,56,52,41,0};
static C_char C_TLS li149[] C_aligned={C_lihdr(0,0,7),40,97,54,52,56,48,41,0};
static C_char C_TLS li150[] C_aligned={C_lihdr(0,0,40),40,97,54,53,51,54,32,110,101,120,116,49,52,57,50,32,108,105,110,101,49,52,57,51,32,102,117,108,108,45,108,105,110,101,63,49,52,57,52,41};
static C_char C_TLS li151[] C_aligned={C_lihdr(0,0,23),40,97,54,52,54,50,32,112,49,52,55,56,32,108,105,109,105,116,49,52,55,57,41,0};
static C_char C_TLS li152[] C_aligned={C_lihdr(0,0,16),40,97,54,53,56,53,32,112,111,114,116,49,52,57,57,41};
static C_char C_TLS li153[] C_aligned={C_lihdr(0,0,62),40,35,35,115,121,115,35,99,117,115,116,111,109,45,105,110,112,117,116,45,112,111,114,116,32,108,111,99,49,51,57,50,32,110,97,109,49,51,57,51,32,102,100,49,51,57,52,32,46,32,116,109,112,49,51,57,49,49,51,57,53,41,0,0};
static C_char C_TLS li154[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char C_TLS li155[] C_aligned={C_lihdr(0,0,26),40,112,111,107,101,49,53,50,55,32,115,116,114,49,53,51,51,32,108,101,110,49,53,51,52,41,0,0,0,0,0,0};
static C_char C_TLS li156[] C_aligned={C_lihdr(0,0,15),40,97,54,55,54,49,32,115,116,114,49,53,55,49,41,0};
static C_char C_TLS li157[] C_aligned={C_lihdr(0,0,7),40,97,54,55,54,55,41,0};
static C_char C_TLS li158[] C_aligned={C_lihdr(0,0,7),40,97,54,55,56,57,41,0};
static C_char C_TLS li159[] C_aligned={C_lihdr(0,0,16),40,102,95,54,55,57,56,32,115,116,114,49,53,53,49,41};
static C_char C_TLS li160[] C_aligned={C_lihdr(0,0,32),40,108,111,111,112,32,114,101,109,49,53,53,54,32,115,116,97,114,116,49,53,53,55,32,108,101,110,49,53,53,56,41};
static C_char C_TLS li161[] C_aligned={C_lihdr(0,0,16),40,102,95,54,56,49,51,32,115,116,114,49,53,53,52,41};
static C_char C_TLS li162[] C_aligned={C_lihdr(0,0,63),40,35,35,115,121,115,35,99,117,115,116,111,109,45,111,117,116,112,117,116,45,112,111,114,116,32,108,111,99,49,53,49,49,32,110,97,109,49,53,49,50,32,102,100,49,53,49,51,32,46,32,116,109,112,49,53,49,48,49,53,49,52,41,0};
static C_char C_TLS li163[] C_aligned={C_lihdr(0,0,33),40,102,105,108,101,45,116,114,117,110,99,97,116,101,32,102,110,97,109,101,49,53,55,57,32,111,102,102,49,53,56,48,41,0,0,0,0,0,0,0};
static C_char C_TLS li164[] C_aligned={C_lihdr(0,0,33),40,115,101,116,117,112,32,112,111,114,116,49,53,56,56,32,97,114,103,115,49,53,56,57,32,108,111,99,49,53,57,48,41,0,0,0,0,0,0,0};
static C_char C_TLS li165[] C_aligned={C_lihdr(0,0,30),40,101,114,114,32,109,115,103,49,54,48,53,32,108,111,99,107,49,54,48,54,32,108,111,99,49,54,48,55,41,0,0};
static C_char C_TLS li166[] C_aligned={C_lihdr(0,0,31),40,102,105,108,101,45,108,111,99,107,32,112,111,114,116,49,54,48,56,32,46,32,97,114,103,115,49,54,48,57,41,0};
static C_char C_TLS li167[] C_aligned={C_lihdr(0,0,40),40,102,105,108,101,45,108,111,99,107,47,98,108,111,99,107,105,110,103,32,112,111,114,116,49,54,49,49,32,46,32,97,114,103,115,49,54,49,50,41};
static C_char C_TLS li168[] C_aligned={C_lihdr(0,0,36),40,102,105,108,101,45,116,101,115,116,45,108,111,99,107,32,112,111,114,116,49,54,49,52,32,46,32,97,114,103,115,49,54,49,53,41,0,0,0,0};
static C_char C_TLS li169[] C_aligned={C_lihdr(0,0,22),40,102,105,108,101,45,117,110,108,111,99,107,32,108,111,99,107,49,54,51,50,41,0,0};
static C_char C_TLS li170[] C_aligned={C_lihdr(0,0,34),40,99,114,101,97,116,101,45,102,105,102,111,32,102,110,97,109,101,49,54,51,54,32,46,32,109,111,100,101,49,54,51,55,41,0,0,0,0,0,0};
static C_char C_TLS li171[] C_aligned={C_lihdr(0,0,20),40,102,105,102,111,63,32,102,105,108,101,110,97,109,101,49,54,52,50,41,0,0,0,0};
static C_char C_TLS li172[] C_aligned={C_lihdr(0,0,72),40,109,97,112,45,102,105,108,101,45,116,111,45,109,101,109,111,114,121,32,97,100,100,114,49,54,55,56,32,108,101,110,49,54,55,57,32,112,114,111,116,49,54,56,48,32,102,108,97,103,49,54,56,49,32,102,100,49,54,56,50,32,46,32,111,102,102,49,54,56,51,41};
static C_char C_TLS li173[] C_aligned={C_lihdr(0,0,43),40,117,110,109,97,112,45,102,105,108,101,45,102,114,111,109,45,109,101,109,111,114,121,32,109,109,97,112,49,55,48,48,32,46,32,108,101,110,49,55,48,49,41,0,0,0,0,0};
static C_char C_TLS li174[] C_aligned={C_lihdr(0,0,37),40,109,101,109,111,114,121,45,109,97,112,112,101,100,45,102,105,108,101,45,112,111,105,110,116,101,114,32,109,109,97,112,49,55,48,53,41,0,0,0};
static C_char C_TLS li175[] C_aligned={C_lihdr(0,0,27),40,109,101,109,111,114,121,45,109,97,112,112,101,100,45,102,105,108,101,63,32,120,49,55,48,56,41,0,0,0,0,0};
static C_char C_TLS li176[] C_aligned={C_lihdr(0,0,36),40,115,116,114,105,110,103,45,62,116,105,109,101,32,116,105,109,49,55,51,48,32,46,32,116,109,112,49,55,50,57,49,55,51,49,41,0,0,0,0};
static C_char C_TLS li177[] C_aligned={C_lihdr(0,0,26),40,117,116,99,45,116,105,109,101,45,62,115,101,99,111,110,100,115,32,116,109,49,55,52,50,41,0,0,0,0,0,0};
static C_char C_TLS li178[] C_aligned={C_lihdr(0,0,29),40,108,111,99,97,108,45,116,105,109,101,122,111,110,101,45,97,98,98,114,101,118,105,97,116,105,111,110,41,0,0,0};
static C_char C_TLS li179[] C_aligned={C_lihdr(0,0,18),40,95,101,120,105,116,32,46,32,99,111,100,101,49,55,53,53,41,0,0,0,0,0,0};
static C_char C_TLS li180[] C_aligned={C_lihdr(0,0,24),40,115,101,116,45,97,108,97,114,109,33,32,105,110,116,49,55,53,55,49,55,54,48,41};
static C_char C_TLS li181[] C_aligned={C_lihdr(0,0,50),40,115,101,116,45,98,117,102,102,101,114,105,110,103,45,109,111,100,101,33,32,112,111,114,116,49,55,54,50,32,109,111,100,101,49,55,54,51,32,46,32,115,105,122,101,49,55,54,52,41,0,0,0,0,0,0};
static C_char C_TLS li182[] C_aligned={C_lihdr(0,0,25),40,116,101,114,109,105,110,97,108,45,112,111,114,116,63,32,112,111,114,116,49,55,55,54,41,0,0,0,0,0,0,0};
static C_char C_TLS li183[] C_aligned={C_lihdr(0,0,42),40,35,35,115,121,115,35,116,101,114,109,105,110,97,108,45,99,104,101,99,107,32,99,97,108,108,101,114,49,55,56,49,32,112,111,114,116,49,55,56,50,41,0,0,0,0,0,0};
static C_char C_TLS li184[] C_aligned={C_lihdr(0,0,24),40,116,101,114,109,105,110,97,108,45,110,97,109,101,32,112,111,114,116,49,55,57,50,41};
static C_char C_TLS li185[] C_aligned={C_lihdr(0,0,24),40,116,101,114,109,105,110,97,108,45,115,105,122,101,32,112,111,114,116,49,56,48,52,41};
static C_char C_TLS li186[] C_aligned={C_lihdr(0,0,15),40,103,101,116,45,104,111,115,116,45,110,97,109,101,41,0};
static C_char C_TLS li187[] C_aligned={C_lihdr(0,0,18),40,102,95,55,54,57,54,32,116,104,117,110,107,49,56,52,55,41,0,0,0,0,0,0};
static C_char C_TLS li188[] C_aligned={C_lihdr(0,0,7),40,97,55,54,56,49,41,0};
static C_char C_TLS li189[] C_aligned={C_lihdr(0,0,28),40,112,114,111,99,101,115,115,45,102,111,114,107,32,46,32,116,109,112,49,56,51,49,49,56,51,50,41,0,0,0,0};
static C_char C_TLS li190[] C_aligned={C_lihdr(0,0,49),40,115,101,116,97,114,103,32,105,110,116,49,56,54,50,49,56,54,56,32,99,45,115,116,114,105,110,103,49,56,54,51,49,56,54,57,32,105,110,116,49,56,54,52,49,56,55,48,41,0,0,0,0,0,0,0};
static C_char C_TLS li191[] C_aligned={C_lihdr(0,0,49),40,115,101,116,101,110,118,32,105,110,116,49,56,55,52,49,56,56,48,32,99,45,115,116,114,105,110,103,49,56,55,53,49,56,56,49,32,105,110,116,49,56,55,54,49,56,56,50,41,0,0,0,0,0,0,0};
static C_char C_TLS li192[] C_aligned={C_lihdr(0,0,25),40,100,111,108,111,111,112,49,57,48,56,32,101,108,49,57,49,48,32,105,49,57,49,49,41,0,0,0,0,0,0,0};
static C_char C_TLS li193[] C_aligned={C_lihdr(0,0,25),40,100,111,108,111,111,112,49,57,48,52,32,97,108,49,57,48,54,32,105,49,57,48,55,41,0,0,0,0,0,0,0};
static C_char C_TLS li194[] C_aligned={C_lihdr(0,0,44),40,112,114,111,99,101,115,115,45,101,120,101,99,117,116,101,32,102,105,108,101,110,97,109,101,49,56,57,49,32,46,32,116,109,112,49,56,57,48,49,56,57,50,41,0,0,0,0};
static C_char C_TLS li195[] C_aligned={C_lihdr(0,0,7),40,97,55,57,53,55,41,0};
static C_char C_TLS li196[] C_aligned={C_lihdr(0,0,39),40,35,35,115,121,115,35,112,114,111,99,101,115,115,45,119,97,105,116,32,112,105,100,49,57,51,49,32,110,111,104,97,110,103,49,57,51,50,41,0};
static C_char C_TLS li197[] C_aligned={C_lihdr(0,0,19),40,112,97,114,101,110,116,45,112,114,111,99,101,115,115,45,105,100,41,0,0,0,0,0};
static C_char C_TLS li198[] C_aligned={C_lihdr(0,0,19),40,115,108,101,101,112,32,105,110,116,49,57,52,52,49,57,52,55,41,0,0,0,0,0};
static C_char C_TLS li199[] C_aligned={C_lihdr(0,0,33),40,112,114,111,99,101,115,115,45,115,105,103,110,97,108,32,105,100,49,57,52,57,32,46,32,115,105,103,49,57,53,48,41,0,0,0,0,0,0,0};
static C_char C_TLS li200[] C_aligned={C_lihdr(0,0,21),40,35,35,115,121,115,35,115,104,101,108,108,45,99,111,109,109,97,110,100,41,0,0,0};
static C_char C_TLS li201[] C_aligned={C_lihdr(0,0,42),40,35,35,115,121,115,35,115,104,101,108,108,45,99,111,109,109,97,110,100,45,97,114,103,117,109,101,110,116,115,32,99,109,100,108,105,110,49,57,54,48,41,0,0,0,0,0,0};
static C_char C_TLS li202[] C_aligned={C_lihdr(0,0,30),40,112,114,111,99,101,115,115,45,114,117,110,32,102,49,57,54,50,32,46,32,97,114,103,115,49,57,54,51,41,0,0};
static C_char C_TLS li203[] C_aligned={C_lihdr(0,0,7),40,97,56,49,48,48,41,0};
static C_char C_TLS li204[] C_aligned={C_lihdr(0,0,29),40,97,56,49,48,54,32,95,49,57,56,55,32,102,108,103,49,57,56,56,32,99,111,100,49,57,56,57,41,0,0,0};
static C_char C_TLS li205[] C_aligned={C_lihdr(0,0,8),40,102,95,56,48,56,54,41};
static C_char C_TLS li206[] C_aligned={C_lihdr(0,0,68),40,109,97,107,101,45,111,110,45,99,108,111,115,101,32,108,111,99,49,57,56,48,32,112,105,100,49,57,56,49,32,99,108,115,118,101,99,49,57,56,50,32,105,100,120,49,57,56,51,32,105,100,120,97,49,57,56,52,32,105,100,120,98,49,57,56,53,41,0,0,0,0};
static C_char C_TLS li207[] C_aligned={C_lihdr(0,0,7),40,97,56,49,50,57,41,0};
static C_char C_TLS li208[] C_aligned={C_lihdr(0,0,19),40,97,56,49,51,53,32,105,49,57,57,52,32,111,49,57,57,53,41,0,0,0,0,0};
static C_char C_TLS li209[] C_aligned={C_lihdr(0,0,22),40,110,101,101,100,101,100,45,112,105,112,101,32,112,111,114,116,49,57,57,50,41,0,0};
static C_char C_TLS li210[] C_aligned={C_lihdr(0,0,34),40,99,111,110,110,101,99,116,45,112,97,114,101,110,116,32,112,105,112,101,49,57,57,55,32,112,111,114,116,49,57,57,56,41,0,0,0,0,0,0};
static C_char C_TLS li211[] C_aligned={C_lihdr(0,0,43),40,99,111,110,110,101,99,116,45,99,104,105,108,100,32,112,105,112,101,50,48,48,53,32,112,111,114,116,50,48,48,54,32,115,116,100,102,100,50,48,48,55,41,0,0,0,0,0};
static C_char C_TLS li212[] C_aligned={C_lihdr(0,0,14),40,115,119,97,112,112,101,100,45,101,110,100,115,41,0,0};
static C_char C_TLS li213[] C_aligned={C_lihdr(0,0,7),40,97,56,50,48,52,41,0};
static C_char C_TLS li214[] C_aligned={C_lihdr(0,0,67),40,115,112,97,119,110,32,99,109,100,50,48,49,56,32,97,114,103,115,50,48,49,57,32,101,110,118,50,48,50,48,32,115,116,100,111,117,116,102,50,48,50,49,32,115,116,100,105,110,102,50,48,50,50,32,115,116,100,101,114,114,102,50,48,50,51,41,0,0,0,0,0};
static C_char C_TLS li215[] C_aligned={C_lihdr(0,0,59),40,105,110,112,117,116,45,112,111,114,116,32,108,111,99,50,48,51,48,32,99,109,100,50,48,51,50,32,112,105,112,101,50,48,51,51,32,115,116,100,102,50,48,51,52,32,111,110,45,99,108,111,115,101,50,48,51,54,41,0,0,0,0,0};
static C_char C_TLS li216[] C_aligned={C_lihdr(0,0,60),40,111,117,116,112,117,116,45,112,111,114,116,32,108,111,99,50,48,51,56,32,99,109,100,50,48,52,48,32,112,105,112,101,50,48,52,49,32,115,116,100,102,50,48,52,50,32,111,110,45,99,108,111,115,101,50,48,52,52,41,0,0,0,0};
static C_char C_TLS li217[] C_aligned={C_lihdr(0,0,7),40,97,56,50,53,52,41,0};
static C_char C_TLS li218[] C_aligned={C_lihdr(0,0,50),40,97,56,50,54,48,32,105,110,112,105,112,101,50,48,53,51,32,111,117,116,112,105,112,101,50,48,53,52,32,101,114,114,112,105,112,101,50,48,53,53,32,112,105,100,50,48,53,54,41,0,0,0,0,0,0};
static C_char C_TLS li219[] C_aligned={C_lihdr(0,0,83),40,35,35,115,121,115,35,112,114,111,99,101,115,115,32,108,111,99,50,48,52,54,32,99,109,100,50,48,52,55,32,97,114,103,115,50,48,52,56,32,101,110,118,50,48,52,57,32,115,116,100,111,117,116,102,50,48,53,48,32,115,116,100,105,110,102,50,48,53,49,32,115,116,100,101,114,114,102,50,48,53,50,41,0,0,0,0,0};
static C_char C_TLS li220[] C_aligned={C_lihdr(0,0,7),40,103,50,48,55,50,41,0};
static C_char C_TLS li221[] C_aligned={C_lihdr(0,0,19),40,102,111,114,45,101,97,99,104,45,108,111,111,112,50,48,55,49,41,0,0,0,0,0};
static C_char C_TLS li222[] C_aligned={C_lihdr(0,0,19),40,99,104,107,115,116,114,108,115,116,32,108,115,116,50,48,54,56,41,0,0,0,0,0};
static C_char C_TLS li223[] C_aligned={C_lihdr(0,0,7),40,97,56,51,53,53,41,0};
static C_char C_TLS li224[] C_aligned={C_lihdr(0,0,58),40,37,112,114,111,99,101,115,115,32,108,111,99,50,48,54,49,32,101,114,114,63,50,48,54,50,32,99,109,100,50,48,54,51,32,97,114,103,115,50,48,54,52,32,101,110,118,50,48,54,53,32,107,50,48,54,54,41,0,0,0,0,0,0};
static C_char C_TLS li225[] C_aligned={C_lihdr(0,0,31),40,97,56,51,57,51,32,105,50,49,49,54,32,111,50,49,49,55,32,112,50,49,49,56,32,101,50,49,49,57,41,0};
static C_char C_TLS li226[] C_aligned={C_lihdr(0,0,31),40,112,114,111,99,101,115,115,32,99,109,100,50,49,48,52,32,46,32,116,109,112,50,49,48,51,50,49,48,53,41,0};
static C_char C_TLS li227[] C_aligned={C_lihdr(0,0,32),40,112,114,111,99,101,115,115,42,32,99,109,100,50,49,50,53,32,46,32,116,109,112,50,49,50,52,50,49,50,54,41};
static C_char C_TLS li228[] C_aligned={C_lihdr(0,0,29),40,115,101,116,45,114,111,111,116,45,100,105,114,101,99,116,111,114,121,33,32,100,105,114,50,49,52,54,41,0,0,0};
static C_char C_TLS li229[] C_aligned={C_lihdr(0,0,15),40,97,56,53,48,49,32,112,105,100,49,51,50,48,41,0};
static C_char C_TLS li230[] C_aligned={C_lihdr(0,0,24),40,97,56,53,49,57,32,112,105,100,49,51,50,53,32,112,103,105,100,49,51,50,54,41};
static C_char C_TLS li231[] C_aligned={C_lihdr(0,0,7),40,97,56,53,52,49,41,0};
static C_char C_TLS li232[] C_aligned={C_lihdr(0,0,14),40,97,56,53,52,52,32,105,100,49,49,53,51,41,0,0};
static C_char C_TLS li233[] C_aligned={C_lihdr(0,0,7),40,97,56,53,54,48,41,0};
static C_char C_TLS li234[] C_aligned={C_lihdr(0,0,14),40,97,56,53,54,51,32,105,100,49,49,52,56,41,0,0};
static C_char C_TLS li235[] C_aligned={C_lihdr(0,0,7),40,97,56,53,55,57,41,0};
static C_char C_TLS li236[] C_aligned={C_lihdr(0,0,14),40,97,56,53,56,50,32,105,100,49,49,52,51,41,0,0};
static C_char C_TLS li237[] C_aligned={C_lihdr(0,0,7),40,97,56,53,57,56,41,0};
static C_char C_TLS li238[] C_aligned={C_lihdr(0,0,14),40,97,56,54,48,49,32,105,100,49,49,51,56,41,0,0};
static C_char C_TLS li239[] C_aligned={C_lihdr(0,0,24),40,108,111,111,112,32,115,105,103,115,49,49,49,51,32,109,97,115,107,49,49,49,52,41};
static C_char C_TLS li240[] C_aligned={C_lihdr(0,0,7),40,97,56,54,49,55,41,0};
static C_char C_TLS li241[] C_aligned={C_lihdr(0,0,15),40,97,56,54,52,55,32,112,111,114,116,57,48,52,41,0};
static C_char C_TLS li242[] C_aligned={C_lihdr(0,0,14),40,97,56,54,56,56,32,115,105,103,53,56,52,41,0,0};
static C_char C_TLS li243[] C_aligned={C_lihdr(0,0,19),40,97,56,54,57,55,32,46,32,116,109,112,52,51,57,52,52,48,41,0,0,0,0,0};
static C_char C_TLS li244[] C_aligned={C_lihdr(0,0,13),40,97,56,55,50,50,32,117,109,52,53,50,41,0,0,0};
static C_char C_TLS li245[] C_aligned={C_lihdr(0,0,12),40,97,56,55,50,56,32,102,49,49,49,41,0,0,0,0};
static C_char C_TLS li246[] C_aligned={C_lihdr(0,0,17),40,97,56,55,51,52,32,102,49,49,51,32,116,49,49,52,41,0,0,0,0,0,0,0};
static C_char C_TLS li247[] C_aligned={C_lihdr(0,0,10),40,116,111,112,108,101,118,101,108,41,0,0,0,0,0,0};


/* from k8469 in set-root-directory! in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static C_word C_fcall stub2141(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub2141(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
C_r=C_fix((C_word)chroot(t0));
return C_r;}

/* from k7986 */
static C_word C_fcall stub1945(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1945(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_fix((C_word)C_sleep(t0));
return C_r;}

/* from parent-process-id in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static C_word C_fcall stub1941(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1941(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getppid());
return C_r;}

/* from freeenv */
static C_word C_fcall stub1884(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1884(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_free_exec_env();
return C_r;}

/* from k7770 */
static C_word C_fcall stub1877(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub1877(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
char * t1=(char * )C_string_or_null(C_a1);
int t2=(int )C_unfix(C_a2);
C_set_exec_env(t0,t1,t2);
return C_r;}

/* from freeargs */
static C_word C_fcall stub1872(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1872(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_free_exec_args();
return C_r;}

/* from k7747 */
static C_word C_fcall stub1865(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub1865(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
char * t1=(char * )C_string_or_null(C_a1);
int t2=(int )C_unfix(C_a2);
C_set_exec_arg(t0,t1,t2);
return C_r;}

/* from k7690 */
static C_word C_fcall stub1851(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1851(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
_exit(t0);
return C_r;}

/* from fork */
static C_word C_fcall stub1825(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1825(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_fork());
return C_r;}

#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_ret; C_cblockend
static C_word C_fcall stub1818(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1818(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
if(gethostname(C_hostbuf, 256) == -1) C_return(NULL);else C_return(C_hostbuf);
C_ret:
#undef return

return C_r;}

/* from k7595 */
static C_word C_fcall stub1799(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub1799(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
int *t1=(int *)C_c_pointer_nn(C_a1);
int *t2=(int *)C_c_pointer_nn(C_a2);
C_r=C_fix((C_word)get_tty_size(t0,t1,t2));
return C_r;}

/* from k7571 */
static C_word C_fcall stub1788(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1788(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)ttyname(t0));
return C_r;}

/* from k7458 */
static C_word C_fcall stub1758(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1758(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_fix((C_word)C_alarm(t0));
return C_r;}

/* from k7438 */
static C_word C_fcall stub1752(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1752(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
_exit(t0);
return C_r;}

#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_ret; C_cblockend
static C_word C_fcall stub1746(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1746(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;

#if !defined(__CYGWIN__) && !defined(__SVR4) && !defined(__uClinux__) && !defined(__hpux__) && !defined(_AIX)
time_t clock = time(NULL);struct tm *ltm = C_localtime(&clock);char *z = ltm ? (char *)ltm->tm_zone : 0;
#else
char *z = (daylight ? tzname[1] : tzname[0]);
#endif
C_return(z);
C_ret:
#undef return

return C_r;}

/* from k7366 */
static C_word C_fcall stub1716(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3) C_regparm;
C_regparm static C_word C_fcall stub1716(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_word t1=(C_word )(C_a1);
C_word t2=(C_word )(C_a2);
void * t3=(void * )C_data_pointer_or_null(C_a3);
C_r=((C_word)C_strptime(t0,t1,t2,t3));
return C_r;}

/* from k7309 */
static C_word C_fcall stub1694(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub1694(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_c_pointer_or_null(C_a0);
int t1=(int )C_num_to_int(C_a1);
C_r=C_fix((C_word)munmap(t0,t1));
return C_r;}

/* from k7249 */
static C_word C_fcall stub1667(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4,C_word C_a5) C_regparm;
C_regparm static C_word C_fcall stub1667(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4,C_word C_a5){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_c_pointer_or_null(C_a0);
int t1=(int )C_num_to_int(C_a1);
int t2=(int )C_unfix(C_a2);
int t3=(int )C_unfix(C_a3);
int t4=(int )C_unfix(C_a4);
int t5=(int )C_num_to_int(C_a5);
C_r=C_mpointer_or_false(&C_a,(void*)mmap(t0,t1,t2,t3,t4,t5));
return C_r;}

/* from k6100 in k6096 in file-link in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static C_word C_fcall stub1374(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub1374(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
char * t1=(char * )C_string_or_null(C_a1);
C_r=C_fix((C_word)link(t0,t1));
return C_r;}

/* from k5744 */
static C_word C_fcall stub1240(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub1240(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
int t1=(int )C_unfix(C_a1);
C_r=C_fix((C_word)initgroups(t0,t1));
return C_r;}

#define return(x) C_cblock C_r = (C_mk_bool((x))); goto C_ret; C_cblockend
static C_word C_fcall stub1210(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1210(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int n=(int )C_unfix(C_a0);
if(C_groups != NULL) C_free(C_groups);C_groups = (gid_t *)C_malloc(sizeof(gid_t) * n);if(C_groups == NULL) C_return(0);else C_return(1);
C_ret:
#undef return

return C_r;}

#define return(x) C_cblock C_r = (C_fix((C_word)(x))); goto C_ret; C_cblockend
static C_word C_fcall stub1205(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1205(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int n=(int )C_unfix(C_a0);
C_return(getgroups(n, C_groups));
C_ret:
#undef return

return C_r;}

#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_ret; C_cblockend
static C_word C_fcall stub1177(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1177(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int i=(int )C_unfix(C_a0);
C_return(C_group->gr_mem[ i ]);
C_ret:
#undef return

return C_r;}

/* from a8541 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static C_word C_fcall stub1151(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1151(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getegid());
return C_r;}

/* from a8560 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static C_word C_fcall stub1146(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1146(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getgid());
return C_r;}

/* from a8579 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static C_word C_fcall stub1141(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1141(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_geteuid());
return C_r;}

/* from a8598 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static C_word C_fcall stub1136(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1136(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getuid());
return C_r;}

#define return(x) C_cblock C_r = (C_mk_bool((x))); goto C_ret; C_cblockend
static C_word C_fcall stub873(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub873(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int i=(int )C_unfix(C_a0);
void * p=(void * )C_data_pointer_or_null(C_a1);
struct pollfd *fds = p;C_return(fds[i].revents & (POLLOUT|POLLERR|POLLHUP|POLLNVAL));
C_ret:
#undef return

return C_r;}

#define return(x) C_cblock C_r = (C_mk_bool((x))); goto C_ret; C_cblockend
static C_word C_fcall stub854(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub854(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int i=(int )C_unfix(C_a0);
void * p=(void * )C_data_pointer_or_null(C_a1);
struct pollfd *fds = p;C_return(fds[i].revents & (POLLIN|POLLERR|POLLHUP|POLLNVAL));
C_ret:
#undef return

return C_r;}

/* from k4431 */
static C_word C_fcall stub829(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub829(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_data_pointer_or_null(C_a0);
int t1=(int )C_unfix(C_a1);
int t2=(int )C_unfix(C_a2);
C_r=C_fix((C_word)poll(t0,t1,t2));
return C_r;}

#define return(x) C_cblock C_r = (((C_word)(x))); goto C_ret; C_cblockend
static C_word C_fcall stub814(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub814(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int i=(int )C_unfix(C_a0);
int fd=(int )C_unfix(C_a1);
void * p=(void * )C_data_pointer_or_null(C_a2);
struct pollfd *fds = p;fds[i].fd = fd; fds[i].events = POLLOUT;
C_ret:
#undef return

return C_r;}

#define return(x) C_cblock C_r = (((C_word)(x))); goto C_ret; C_cblockend
static C_word C_fcall stub796(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub796(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int i=(int )C_unfix(C_a0);
int fd=(int )C_unfix(C_a1);
void * p=(void * )C_data_pointer_or_null(C_a2);
struct pollfd *fds = p;fds[i].fd = fd; fds[i].events = POLLIN;
C_ret:
#undef return

return C_r;}

/* from k4194 */
static C_word C_fcall stub701(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub701(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
int t1=(int )C_unfix(C_a1);
long t2=(long )C_num_to_long(C_a2);
C_r=C_fix((C_word)fcntl(t0,t1,t2));
return C_r;}

/* from k4143 */
static C_word C_fcall stub657(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub657(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_fix((C_word)C_check_fd_ready(t0));
return C_r;}

#define return(x) C_cblock C_r = (C_mk_bool((x))); goto C_ret; C_cblockend
static C_word C_fcall stub652(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub652(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int fd=(int )C_unfix(C_a0);
int val = fcntl(fd, F_GETFL, 0);if(val == -1) C_return(0);C_return(fcntl(fd, F_SETFL, val | O_NONBLOCK) != -1);
C_ret:
#undef return

return C_r;}

/* from k3972 */
static C_word C_fcall stub566(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub566(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)C_getenventry(t0));
return C_r;}

/* from k3870 */
static C_word C_fcall stub526(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub526(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_word t1=(C_word )(C_a1);
void * t2=(void * )C_data_pointer_or_null(C_a2);
C_r=C_mpointer(&C_a,(void*)C_strftime(t0,t1,t2));
return C_r;}

/* from k3857 */
static C_word C_fcall stub516(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub516(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
void * t1=(void * )C_data_pointer_or_null(C_a1);
C_r=C_mpointer(&C_a,(void*)C_asctime(t0,t1));
return C_r;}

/* from k3790 */
static C_word C_fcall stub487(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub487(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_num_to_int(C_a0);
C_r=C_mpointer(&C_a,(void*)C_ctime(t0));
return C_r;}

/* from k8743 in k8766 in a8734 in k2654 in k2651 in k2648 in k2645 in k2642 */
static C_word C_fcall stub120(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub120(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
C_word t1=(C_word )(C_a1);
C_r=C_fix((C_word)set_file_mtime(t0,t1));
return C_r;}

/* from k2665 */
static C_word C_fcall stub67(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub67(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)strerror(t0));
return C_r;}

C_noret_decl(f_7635)
static void C_ccall f_7635(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7639)
static void C_ccall f_7639(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7627)
static void C_ccall f_7627(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7623)
static void C_ccall f_7623(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7649)
static void C_ccall f_7649(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_7649)
static void C_ccall f_7649r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_7642)
static void C_ccall f_7642(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7423)
static void C_ccall f_7423(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5256)
static void C_ccall f_5256(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5252)
static void C_ccall f_5252(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5619)
static void C_ccall f_5619(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5615)
static void C_ccall f_5615(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7139)
static void C_fcall f_7139(C_word t0,C_word t1) C_noret;
C_noret_decl(f_7132)
static void C_ccall f_7132(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_7132)
static void C_ccall f_7132r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_7602)
static void C_ccall f_7602(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6511)
static void C_ccall f_6511(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7160)
static void C_ccall f_7160(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7156)
static void C_ccall f_7156(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8768)
static void C_ccall f_8768(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7181)
static void C_ccall f_7181(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5299)
static void C_ccall f_5299(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7173)
static void C_ccall f_7173(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4602)
static void C_fcall f_4602(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2774)
static void C_ccall f_2774(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2776)
static void C_ccall f_2776(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2770)
static void C_ccall f_2770(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6586)
static void C_ccall f_6586(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5238)
static void C_ccall f_5238(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5238)
static void C_ccall f_5238r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_5232)
static void C_ccall f_5232(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7668)
static void C_ccall f_7668(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5247)
static void C_ccall f_5247(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5242)
static void C_ccall f_5242(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3892)
static void C_ccall f_3892(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6596)
static void C_ccall f_6596(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8745)
static void C_ccall f_8745(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4647)
static C_word C_fcall f_4647(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_4645)
static void C_ccall f_4645(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2737)
static void C_ccall f_2737(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3876)
static void C_ccall f_3876(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3876)
static void C_ccall f_3876r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_2730)
static void C_ccall f_2730(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_2730)
static void C_ccall f_2730r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3590)
static void C_ccall f_3590(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3647)
static void C_ccall f_3647(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2764)
static void C_ccall f_2764(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3646)
static void C_ccall f_3646(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2762)
static void C_ccall f_2762(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2768)
static void C_ccall f_2768(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3883)
static void C_ccall f_3883(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3562)
static void C_ccall f_3562(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7104)
static void C_ccall f_7104(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2752)
static void C_ccall f_2752(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2758)
static void C_ccall f_2758(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2756)
static void C_ccall f_2756(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2750)
static void C_ccall f_2750(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3629)
static void C_ccall f_3629(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2782)
static void C_ccall f_2782(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_2782)
static void C_ccall f_2782r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3622)
static void C_ccall f_3622(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2780)
static void C_ccall f_2780(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3584)
static void C_ccall f_3584(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4689)
static C_word C_fcall f_4689(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_3636)
static void C_ccall f_3636(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3839)
static void C_ccall f_3839(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3835)
static void C_ccall f_3835(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3831)
static void C_ccall f_3831(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3557)
static void C_ccall f_3557(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8733)
static void C_ccall f_8733(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8735)
static void C_ccall f_8735(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3555)
static void C_ccall f_3555(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3603)
static void C_ccall f_3603(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3600)
static void C_ccall f_3600(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3609)
static void C_ccall f_3609(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3845)
static void C_ccall f_3845(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8723)
static void C_ccall f_8723(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6537)
static void C_ccall f_6537(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_8729)
static void C_ccall f_8729(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3577)
static void C_ccall f_3577(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8755)
static void C_ccall f_8755(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3570)
static void C_ccall f_3570(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3574)
static void C_ccall f_3574(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7271)
static void C_ccall f_7271(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7265)
static void C_ccall f_7265(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7262)
static void C_fcall f_7262(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5204)
static void C_ccall f_5204(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5204)
static void C_ccall f_5204r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_5208)
static void C_ccall f_5208(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7284)
static void C_ccall f_7284(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4898)
static void C_ccall f_4898(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4891)
static void C_ccall f_4891(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4197)
static void C_ccall f_4197(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_4197)
static void C_ccall f_4197r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_8602)
static void C_ccall f_8602(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7259)
static void C_ccall f_7259(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7255)
static void C_ccall f_7255(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,...) C_noret;
C_noret_decl(f_7255)
static void C_ccall f_7255r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t8) C_noret;
C_noret_decl(f_4961)
static void C_ccall f_4961(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4964)
static void C_ccall f_4964(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4634)
static void C_fcall f_4634(C_word t0,C_word t1) C_noret;
C_noret_decl(f_6445)
static void C_ccall f_6445(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5704)
static void C_ccall f_5704(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4133)
static void C_ccall f_4133(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4975)
static void C_ccall f_4975(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4977)
static void C_ccall f_4977(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4140)
static void C_ccall f_4140(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4984)
static void C_ccall f_4984(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6463)
static void C_ccall f_6463(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5818)
static void C_ccall f_5818(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6467)
static void C_ccall f_6467(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8648)
static void C_ccall f_8648(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7215)
static void C_ccall f_7215(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5213)
static void C_ccall f_5213(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5218)
static void C_ccall f_5218(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_5218)
static void C_ccall f_5218r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_5839)
static void C_ccall f_5839(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6481)
static void C_ccall f_6481(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3180)
static void C_ccall f_3180(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3186)
static void C_ccall f_3186(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5222)
static void C_ccall f_5222(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5227)
static void C_ccall f_5227(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4936)
static void C_ccall f_4936(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8624)
static void C_fcall f_8624(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6476)
static void C_fcall f_6476(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5843)
static void C_ccall f_5843(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5845)
static void C_ccall f_5845(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_2668)
static void C_ccall f_2668(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...) C_noret;
C_noret_decl(f_2668)
static void C_ccall f_2668r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t6) C_noret;
C_noret_decl(f_3191)
static void C_fcall f_3191(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2725)
static void C_ccall f_2725(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8612)
static void C_ccall f_8612(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2721)
static void C_ccall f_2721(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8618)
static void C_ccall f_8618(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2690)
static void C_ccall f_2690(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4954)
static void C_ccall f_4954(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6491)
static void C_ccall f_6491(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2714)
static void C_ccall f_2714(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5869)
static void C_ccall f_5869(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8689)
static void C_ccall f_8689(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3141)
static void C_ccall f_3141(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5873)
static void C_ccall f_5873(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5875)
static void C_fcall f_5875(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2672)
static void C_ccall f_2672(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2679)
static void C_ccall f_2679(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3702)
static void C_ccall f_3702(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3705)
static void C_ccall f_3705(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3707)
static void C_ccall f_3707(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3715)
static void C_ccall f_3715(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3713)
static void C_ccall f_3713(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3157)
static void C_ccall f_3157(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5885)
static void C_ccall f_5885(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8664)
static void C_ccall f_8664(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5899)
static void C_ccall f_5899(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5897)
static void C_ccall f_5897(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5893)
static void C_ccall f_5893(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4907)
static void C_ccall f_4907(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3722)
static void C_fcall f_3722(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3164)
static void C_fcall f_3164(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3163)
static void C_ccall f_3163(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3720)
static void C_ccall f_3720(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4905)
static void C_ccall f_4905(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2653)
static void C_ccall f_2653(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8652)
static void C_ccall f_8652(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8655)
static void C_ccall f_8655(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2656)
static void C_ccall f_2656(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2650)
static void C_ccall f_2650(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4913)
static void C_ccall f_4913(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_3174)
static void C_ccall f_3174(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2683)
static void C_ccall f_2683(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2686)
static void C_fcall f_2686(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_3745)
static void C_ccall f_3745(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3741)
static void C_ccall f_3741(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3741)
static void C_ccall f_3741r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_3110)
static void C_ccall f_3110(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3113)
static void C_ccall f_3113(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3949)
static void C_ccall f_3949(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3955)
static void C_ccall f_3955(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3953)
static void C_ccall f_3953(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3137)
static void C_fcall f_3137(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3131)
static void C_ccall f_3131(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3131)
static void C_ccall f_3131r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3963)
static void C_ccall f_3963(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6790)
static void C_ccall f_6790(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3975)
static void C_ccall f_3975(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5569)
static void C_ccall f_5569(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5565)
static void C_fcall f_5565(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5563)
static void C_ccall f_5563(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6798)
static void C_ccall f_6798(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_8536)
static void C_ccall f_8536(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5579)
static void C_ccall f_5579(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4484)
static void C_fcall f_4484(C_word t0,C_word t1) C_noret;
C_noret_decl(f_8520)
static void C_ccall f_8520(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_8288)
static void C_ccall f_8288(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8284)
static void C_ccall f_8284(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8280)
static void C_ccall f_8280(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6751)
static void C_fcall f_6751(C_word t0,C_word t1) C_noret;
C_noret_decl(f_6756)
static void C_ccall f_6756(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3336)
static void C_ccall f_3336(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3938)
static void C_ccall f_3938(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3930)
static void C_ccall f_3930(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8545)
static void C_ccall f_8545(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_8542)
static void C_ccall f_8542(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8261)
static void C_ccall f_8261(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_6741)
static void C_ccall f_6741(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8292)
static void C_ccall f_8292(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5508)
static void C_ccall f_5508(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5504)
static void C_ccall f_5504(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5518)
static void C_ccall f_5518(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5510)
static void C_ccall f_5510(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6710)
static void C_ccall f_6710(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8509)
static void C_ccall f_8509(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8502)
static void C_ccall f_8502(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4402)
static void C_fcall f_4402(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5542)
static void C_fcall f_5542(C_word t0,C_word t1) C_noret;
C_noret_decl(f_7994)
static void C_fcall f_7994(C_word t0,C_word t1) C_noret;
C_noret_decl(f_7990)
static void C_ccall f_7990(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_7990)
static void C_ccall f_7990r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_6762)
static void C_ccall f_6762(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6760)
static void C_ccall f_6760(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5770)
static void C_ccall f_5770(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6778)
static void C_ccall f_6778(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5777)
static void C_ccall f_5777(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4410)
static void C_ccall f_4410(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5555)
static void C_ccall f_5555(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5559)
static void C_ccall f_5559(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8555)
static void C_ccall f_8555(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6768)
static void C_ccall f_6768(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5742)
static void C_ccall f_5742(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2801)
static void C_ccall f_2801(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5522)
static void C_ccall f_5522(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5754)
static void C_ccall f_5754(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5535)
static void C_ccall f_5535(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5535)
static void C_ccall f_5535r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_8574)
static void C_ccall f_8574(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8561)
static void C_ccall f_8561(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8564)
static void C_ccall f_8564(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2647)
static void C_ccall f_2647(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2644)
static void C_ccall f_2644(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8515)
static void C_ccall f_8515(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5593)
static void C_ccall f_5593(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7983)
static void C_ccall f_7983(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7980)
static void C_ccall f_7980(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8583)
static void C_ccall f_8583(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_8580)
static void C_ccall f_8580(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4474)
static void C_ccall f_4474(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4477)
static void C_ccall f_4477(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7958)
static void C_ccall f_7958(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2909)
static void C_ccall f_2909(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2907)
static void C_ccall f_2907(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7049)
static void C_ccall f_7049(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7045)
static void C_ccall f_7045(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_7045)
static void C_ccall f_7045r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5145)
static void C_ccall f_5145(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5140)
static void C_ccall f_5140(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6684)
static void C_ccall f_6684(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6685)
static void C_ccall f_6685(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_7065)
static void C_ccall f_7065(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7061)
static void C_ccall f_7061(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_7061)
static void C_ccall f_7061r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3064)
static void C_ccall f_3064(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8203)
static void C_ccall f_8203(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8205)
static void C_ccall f_8205(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8209)
static void C_ccall f_8209(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3038)
static void C_ccall f_3038(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8231)
static void C_ccall f_8231(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8238)
static void C_fcall f_8238(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6) C_noret;
C_noret_decl(f_7942)
static void C_ccall f_7942(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5184)
static void C_ccall f_5184(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_5184)
static void C_ccall f_5184r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_5188)
static void C_ccall f_5188(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3047)
static void C_ccall f_3047(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7077)
static void C_ccall f_7077(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_7077)
static void C_ccall f_7077r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5155)
static void C_ccall f_5155(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5151)
static void C_ccall f_5151(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5151)
static void C_ccall f_5151r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_8215)
static void C_ccall f_8215(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8212)
static void C_ccall f_8212(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8424)
static void C_ccall f_8424(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_8424)
static void C_ccall f_8424r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_2887)
static void C_ccall f_2887(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2889)
static void C_ccall f_2889(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5164)
static void C_ccall f_5164(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4776)
static void C_ccall f_4776(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_4776)
static void C_ccall f_4776r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_5160)
static void C_ccall f_5160(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_5160)
static void C_ccall f_5160r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_8249)
static void C_ccall f_8249(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8) C_noret;
C_noret_decl(f_8242)
static void C_ccall f_8242(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5169)
static void C_ccall f_5169(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2877)
static void C_ccall f_2877(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6662)
static void C_ccall f_6662(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...) C_noret;
C_noret_decl(f_6662)
static void C_ccall f_6662r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t6) C_noret;
C_noret_decl(f_2879)
static void C_ccall f_2879(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5136)
static void C_ccall f_5136(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_5136)
static void C_ccall f_5136r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_8276)
static void C_ccall f_8276(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2919)
static void C_ccall f_2919(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_8272)
static void C_ccall f_8272(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2917)
static void C_ccall f_2917(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2869)
static void C_ccall f_2869(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6691)
static void C_ccall f_6691(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4795)
static void C_ccall f_4795(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8227)
static void C_fcall f_8227(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6) C_noret;
C_noret_decl(f_8471)
static void C_ccall f_8471(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8479)
static void C_ccall f_8479(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7081)
static void C_ccall f_7081(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8255)
static void C_ccall f_8255(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3545)
static void C_ccall f_3545(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3511)
static void C_ccall f_3511(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4780)
static void C_fcall f_4780(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4789)
static void C_ccall f_4789(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6167)
static void C_ccall f_6167(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2899)
static void C_ccall f_2899(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2897)
static void C_ccall f_2897(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3536)
static void C_ccall f_3536(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3533)
static void C_ccall f_3533(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8192)
static void C_ccall f_8192(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7027)
static void C_fcall f_7027(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_8189)
static void C_ccall f_8189(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8186)
static void C_ccall f_8186(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8182)
static void C_fcall f_8182(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7) C_noret;
C_noret_decl(f_6139)
static void C_ccall f_6139(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...) C_noret;
C_noret_decl(f_6139)
static void C_ccall f_6139r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t6) C_noret;
C_noret_decl(f_6137)
static void C_ccall f_6137(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(C_posix_toplevel)
C_externexport void C_ccall C_posix_toplevel(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6923)
static void C_ccall f_6923(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5113)
static void C_ccall f_5113(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6193)
static void C_ccall f_6193(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8153)
static void C_fcall f_8153(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_8152)
static void C_ccall f_8152(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5121)
static void C_ccall f_5121(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5128)
static void C_ccall f_5128(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8141)
static void C_fcall f_8141(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6178)
static void C_ccall f_6178(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6984)
static void C_fcall f_6984(C_word t0,C_word t1) C_noret;
C_noret_decl(f_6978)
static void C_ccall f_6978(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6173)
static void C_ccall f_6173(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6174)
static void C_fcall f_6174(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4247)
static void C_ccall f_4247(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8168)
static C_word C_fcall f_8168(C_word *a,C_word t0);
C_noret_decl(f_8164)
static void C_ccall f_8164(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4250)
static void C_ccall f_4250(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6962)
static void C_fcall f_6962(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4266)
static void C_ccall f_4266(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4260)
static void C_ccall f_4260(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6951)
static void C_ccall f_6951(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8101)
static void C_ccall f_8101(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8107)
static void C_ccall f_8107(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_8136)
static void C_ccall f_8136(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_8130)
static void C_ccall f_8130(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8086)
static void C_ccall f_8086(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8084)
static void C_fcall f_8084(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6) C_noret;
C_noret_decl(f_8080)
static void C_ccall f_8080(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4282)
static void C_ccall f_4282(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_4282)
static void C_ccall f_4282r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_8121)
static void C_fcall f_8121(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4298)
static void C_ccall f_4298(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4295)
static void C_ccall f_4295(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4292)
static void C_ccall f_4292(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5193)
static void C_ccall f_5193(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5198)
static void C_ccall f_5198(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6117)
static void C_ccall f_6117(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_8307)
static void C_fcall f_8307(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_8305)
static void C_fcall f_8305(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6) C_noret;
C_noret_decl(f_7543)
static void C_fcall f_7543(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6102)
static void C_ccall f_6102(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3985)
static void C_ccall f_3985(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3981)
static void C_fcall f_3981(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4234)
static void C_fcall f_4234(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4230)
static void C_ccall f_4230(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_4230)
static void C_ccall f_4230r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_5175)
static void C_ccall f_5175(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5175)
static void C_ccall f_5175r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_5179)
static void C_ccall f_5179(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7531)
static void C_ccall f_7531(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8321)
static C_word C_fcall f_8321(C_word t0,C_word t1);
C_noret_decl(f_3993)
static void C_fcall f_3993(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5106)
static void C_ccall f_5106(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_8312)
static C_word C_fcall f_8312(C_word t0,C_word t1);
C_noret_decl(f_3483)
static void C_fcall f_3483(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3480)
static void C_fcall f_3480(C_word t0,C_word t1) C_noret;
C_noret_decl(f_8348)
static void C_ccall f_8348(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6947)
static void C_ccall f_6947(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3492)
static void C_fcall f_3492(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3490)
static void C_ccall f_3490(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7578)
static void C_ccall f_7578(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7574)
static void C_ccall f_7574(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6940)
static void C_ccall f_6940(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6933)
static void C_fcall f_6933(C_word t0,C_word t1) C_noret;
C_noret_decl(f_8599)
static void C_ccall f_8599(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8593)
static void C_ccall f_8593(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8351)
static void C_ccall f_8351(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8356)
static void C_ccall f_8356(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7598)
static void C_ccall f_7598(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_8394)
static void C_ccall f_8394(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_2950)
static void C_ccall f_2950(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3447)
static void C_ccall f_3447(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2942)
static void C_fcall f_2942(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_8370)
static void C_ccall f_8370(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8374)
static void C_ccall f_8374(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8376)
static void C_ccall f_8376(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_8376)
static void C_ccall f_8376r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_6043)
static void C_ccall f_6043(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3902)
static void C_ccall f_3902(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3909)
static void C_ccall f_3909(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3906)
static void C_ccall f_3906(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2979)
static void C_fcall f_2979(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_6037)
static void C_ccall f_6037(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6064)
static void C_ccall f_6064(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3439)
static void C_ccall f_3439(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3435)
static void C_ccall f_3435(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6052)
static void C_ccall f_6052(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3406)
static void C_fcall f_3406(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3404)
static void C_ccall f_3404(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7782)
static void C_ccall f_7782(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_7782)
static void C_ccall f_7782r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_6058)
static void C_ccall f_6058(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6055)
static void C_ccall f_6055(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8698)
static void C_ccall f_8698(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_8698)
static void C_ccall f_8698r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_7736)
static void C_fcall f_7736(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2937)
static void C_ccall f_2937(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7525)
static void C_ccall f_7525(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3467)
static void C_ccall f_3467(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2927)
static void C_ccall f_2927(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2929)
static void C_ccall f_2929(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7759)
static void C_fcall f_7759(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5348)
static void C_ccall f_5348(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5462)
static void C_ccall f_5462(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7745)
static void C_ccall f_7745(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5466)
static void C_ccall f_5466(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5356)
static void C_ccall f_5356(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5350)
static void C_ccall f_5350(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6098)
static void C_ccall f_6098(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6813)
static void C_ccall f_6813(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6812)
static void C_ccall f_6812(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5470)
static void C_ccall f_5470(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5478)
static void C_ccall f_5478(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5474)
static void C_ccall f_5474(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5488)
static void C_ccall f_5488(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3427)
static void C_fcall f_3427(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3423)
static void C_ccall f_3423(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8034)
static void C_fcall f_8034(C_word t0,C_word t1) C_noret;
C_noret_decl(f_8030)
static void C_ccall f_8030(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_8030)
static void C_ccall f_8030r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5415)
static void C_ccall f_5415(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8037)
static void C_ccall f_8037(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5411)
static void C_ccall f_5411(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2994)
static void C_ccall f_2994(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_2994)
static void C_ccall f_2994r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_2992)
static void C_ccall f_2992(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8024)
static void C_ccall f_8024(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_8015)
static void C_ccall f_8015(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4543)
static void C_fcall f_4543(C_word t0,C_word t1) C_noret;
C_noret_decl(f_8019)
static void C_ccall f_8019(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6003)
static void C_ccall f_6003(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6027)
static void C_fcall f_6027(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6025)
static void C_ccall f_6025(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8060)
static void C_ccall f_8060(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6011)
static void C_ccall f_6011(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6017)
static void C_ccall f_6017(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_8056)
static void C_ccall f_8056(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7899)
static void C_ccall f_7899(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3655)
static void C_ccall f_3655(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6840)
static void C_ccall f_6840(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7768)
static void C_ccall f_7768(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4514)
static void C_fcall f_4514(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_6830)
static void C_fcall f_6830(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_5496)
static void C_ccall f_5496(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5421)
static void C_ccall f_5421(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5428)
static void C_ccall f_5428(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3688)
static void C_ccall f_3688(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3685)
static void C_ccall f_3685(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3682)
static void C_ccall f_3682(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5432)
static void C_ccall f_5432(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5436)
static void C_ccall f_5436(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3616)
static void C_ccall f_3616(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5440)
static void C_ccall f_5440(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5442)
static void C_ccall f_5442(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5442)
static void C_ccall f_5442r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5449)
static void C_fcall f_5449(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3669)
static void C_ccall f_3669(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3669)
static void C_ccall f_3669r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_7822)
static void C_ccall f_7822(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3663)
static void C_ccall f_3663(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3366)
static void C_ccall f_3366(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3366)
static void C_ccall f_3366r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_7877)
static void C_ccall f_7877(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3679)
static void C_ccall f_3679(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3676)
static void C_ccall f_3676(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7812)
static void C_fcall f_7812(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3673)
static void C_ccall f_3673(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6397)
static void C_fcall f_6397(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4573)
static void C_fcall f_4573(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_3372)
static void C_fcall f_3372(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7828)
static void C_ccall f_7828(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7825)
static void C_ccall f_7825(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6372)
static void C_ccall f_6372(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6387)
static void C_ccall f_6387(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_3302)
static void C_ccall f_3302(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6360)
static void C_ccall f_6360(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6376)
static void C_ccall f_6376(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3393)
static void C_ccall f_3393(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_3397)
static void C_ccall f_3397(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6350)
static void C_ccall f_6350(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4088)
static void C_ccall f_4088(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7850)
static void C_ccall f_7850(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4056)
static void C_ccall f_4056(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4058)
static void C_ccall f_4058(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7357)
static void C_ccall f_7357(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7858)
static void C_fcall f_7858(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5905)
static void C_ccall f_5905(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3693)
static void C_ccall f_3693(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3696)
static void C_ccall f_3696(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3699)
static void C_ccall f_3699(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6338)
static void C_ccall f_6338(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7389)
static void C_ccall f_7389(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7804)
static void C_ccall f_7804(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7807)
static void C_ccall f_7807(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4041)
static void C_ccall f_4041(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_7372)
static void C_ccall f_7372(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_7372)
static void C_ccall f_7372r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_6307)
static void C_ccall f_6307(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4853)
static void C_ccall f_4853(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4064)
static void C_ccall f_4064(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4064)
static void C_ccall f_4064r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_3387)
static void C_ccall f_3387(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5323)
static C_word C_fcall f_5323(C_word t0);
C_noret_decl(f_5047)
static void C_ccall f_5047(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5040)
static void C_ccall f_5040(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5407)
static void C_ccall f_5407(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5403)
static void C_ccall f_5403(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7348)
static void C_ccall f_7348(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4872)
static void C_fcall f_4872(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4875)
static void C_ccall f_4875(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5911)
static void C_ccall f_5911(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5917)
static void C_ccall f_5917(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5057)
static void C_ccall f_5057(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5388)
static void C_ccall f_5388(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4844)
static void C_ccall f_4844(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5921)
static void C_ccall f_5921(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4847)
static void C_ccall f_4847(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5927)
static void C_ccall f_5927(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5066)
static void C_ccall f_5066(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5066)
static void C_ccall f_5066r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5392)
static void C_ccall f_5392(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5399)
static void C_ccall f_5399(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3766)
static void C_ccall f_3766(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3762)
static void C_ccall f_3762(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3762)
static void C_ccall f_3762r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_4023)
static void C_ccall f_4023(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4863)
static void C_ccall f_4863(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4865)
static void C_fcall f_4865(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3280)
static void C_ccall f_3280(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5087)
static void C_ccall f_5087(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5080)
static void C_ccall f_5080(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5372)
static void C_ccall f_5372(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4834)
static void C_ccall f_4834(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4834)
static void C_ccall f_4834r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4832)
static void C_ccall f_4832(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6395)
static void C_fcall f_6395(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5957)
static void C_ccall f_5957(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3292)
static void C_fcall f_3292(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3793)
static void C_ccall f_3793(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3793)
static void C_ccall f_3793r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_4801)
static void C_ccall f_4801(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3797)
static void C_ccall f_3797(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5961)
static void C_ccall f_5961(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5965)
static void C_ccall f_5965(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5969)
static void C_ccall f_5969(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4094)
static void C_ccall f_4094(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_3266)
static void C_fcall f_3266(C_word t0,C_word t1) C_noret;
C_noret_decl(f_7322)
static void C_fcall f_7322(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5934)
static void C_ccall f_5934(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5936)
static void C_ccall f_5936(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_7393)
static void C_ccall f_7393(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3245)
static void C_ccall f_3245(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3248)
static void C_ccall f_3248(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3242)
static void C_ccall f_3242(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5993)
static void C_ccall f_5993(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5993)
static void C_ccall f_5993r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3252)
static void C_ccall f_3252(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6239)
static void C_ccall f_6239(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6236)
static void C_ccall f_6236(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3803)
static void C_ccall f_3803(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3227)
static void C_ccall f_3227(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3223)
static void C_ccall f_3223(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3223)
static void C_ccall f_3223r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_6269)
static void C_ccall f_6269(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5973)
static void C_ccall f_5973(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5974)
static void C_ccall f_5974(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5979)
static void C_ccall f_5979(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4339)
static void C_ccall f_4339(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4333)
static void C_fcall f_4333(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4330)
static void C_ccall f_4330(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3022)
static void C_ccall f_3022(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3201)
static void C_ccall f_3201(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3020)
static void C_ccall f_3020(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_8496)
static void C_ccall f_8496(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6311)
static void C_ccall f_6311(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6313)
static void C_ccall f_6313(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6317)
static void C_ccall f_6317(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5011)
static void C_fcall f_5011(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_6272)
static void C_ccall f_6272(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6278)
static void C_ccall f_6278(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4011)
static void C_ccall f_4011(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5024)
static void C_ccall f_5024(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5026)
static void C_ccall f_5026(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5026)
static void C_ccall f_5026r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4019)
static void C_ccall f_4019(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3008)
static void C_ccall f_3008(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3008)
static void C_ccall f_3008r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3006)
static void C_ccall f_3006(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4367)
static void C_ccall f_4367(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4360)
static void C_ccall f_4360(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7315)
static void C_ccall f_7315(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_7315)
static void C_ccall f_7315r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4373)
static void C_ccall f_4373(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4380)
static void C_ccall f_4380(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5688)
static void C_fcall f_5688(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5683)
static void C_ccall f_5683(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4399)
static void C_fcall f_4399(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4396)
static void C_fcall f_4396(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4392)
static void C_ccall f_4392(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_4392)
static void C_ccall f_4392r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3097)
static void C_ccall f_3097(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3097)
static void C_ccall f_3097r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_7417)
static void C_ccall f_7417(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7413)
static void C_ccall f_7413(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6203)
static C_word C_fcall f_6203(C_word t0);
C_noret_decl(f_7409)
static void C_ccall f_7409(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7401)
static void C_ccall f_7401(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3070)
static void C_ccall f_3070(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3070)
static void C_ccall f_3070r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5097)
static void C_ccall f_5097(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3077)
static void C_fcall f_3077(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3080)
static void C_ccall f_3080(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7428)
static void C_ccall f_7428(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7441)
static void C_ccall f_7441(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_7441)
static void C_ccall f_7441r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_6211)
static void C_fcall f_6211(C_word t0,C_word t1) C_noret;
C_noret_decl(f_6217)
static void C_ccall f_6217(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7455)
static void C_ccall f_7455(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7472)
static void C_ccall f_7472(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5630)
static void C_fcall f_5630(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7462)
static void C_ccall f_7462(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_7462)
static void C_ccall f_7462r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_5655)
static void C_ccall f_5655(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4323)
static void C_ccall f_4323(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_4323)
static void C_ccall f_4323r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_7469)
static void C_fcall f_7469(C_word t0,C_word t1) C_noret;
C_noret_decl(f_7466)
static void C_ccall f_7466(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7481)
static void C_fcall f_7481(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5622)
static void C_ccall f_5622(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5625)
static void C_ccall f_5625(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5679)
static void C_ccall f_5679(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5674)
static void C_ccall f_5674(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5645)
static void C_ccall f_5645(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7696)
static void C_ccall f_7696(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7686)
static void C_ccall f_7686(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7682)
static void C_ccall f_7682(C_word c,C_word t0,C_word t1) C_noret;

C_noret_decl(trf_7139)
static void C_fcall trf_7139(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7139(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_7139(t0,t1);}

C_noret_decl(trf_4602)
static void C_fcall trf_4602(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4602(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4602(t0,t1);}

C_noret_decl(trf_7262)
static void C_fcall trf_7262(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7262(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_7262(t0,t1);}

C_noret_decl(trf_4634)
static void C_fcall trf_4634(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4634(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4634(t0,t1);}

C_noret_decl(trf_8624)
static void C_fcall trf_8624(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8624(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_8624(t0,t1,t2,t3);}

C_noret_decl(trf_6476)
static void C_fcall trf_6476(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6476(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_6476(t0,t1);}

C_noret_decl(trf_3191)
static void C_fcall trf_3191(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3191(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3191(t0,t1,t2);}

C_noret_decl(trf_5875)
static void C_fcall trf_5875(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5875(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_5875(t0,t1,t2,t3);}

C_noret_decl(trf_3722)
static void C_fcall trf_3722(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3722(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3722(t0,t1,t2);}

C_noret_decl(trf_3164)
static void C_fcall trf_3164(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3164(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3164(t0,t1,t2);}

C_noret_decl(trf_2686)
static void C_fcall trf_2686(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2686(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_2686(t0,t1,t2,t3,t4);}

C_noret_decl(trf_3137)
static void C_fcall trf_3137(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3137(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3137(t0,t1);}

C_noret_decl(trf_5565)
static void C_fcall trf_5565(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5565(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_5565(t0,t1,t2);}

C_noret_decl(trf_4484)
static void C_fcall trf_4484(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4484(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4484(t0,t1);}

C_noret_decl(trf_6751)
static void C_fcall trf_6751(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6751(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_6751(t0,t1);}

C_noret_decl(trf_4402)
static void C_fcall trf_4402(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4402(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4402(t0,t1);}

C_noret_decl(trf_5542)
static void C_fcall trf_5542(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5542(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_5542(t0,t1);}

C_noret_decl(trf_7994)
static void C_fcall trf_7994(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7994(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_7994(t0,t1);}

C_noret_decl(trf_8238)
static void C_fcall trf_8238(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8238(void *dummy){
C_word t6=C_pick(0);
C_word t5=C_pick(1);
C_word t4=C_pick(2);
C_word t3=C_pick(3);
C_word t2=C_pick(4);
C_word t1=C_pick(5);
C_word t0=C_pick(6);
C_adjust_stack(-7);
f_8238(t0,t1,t2,t3,t4,t5,t6);}

C_noret_decl(trf_8227)
static void C_fcall trf_8227(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8227(void *dummy){
C_word t6=C_pick(0);
C_word t5=C_pick(1);
C_word t4=C_pick(2);
C_word t3=C_pick(3);
C_word t2=C_pick(4);
C_word t1=C_pick(5);
C_word t0=C_pick(6);
C_adjust_stack(-7);
f_8227(t0,t1,t2,t3,t4,t5,t6);}

C_noret_decl(trf_4780)
static void C_fcall trf_4780(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4780(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4780(t0,t1);}

C_noret_decl(trf_7027)
static void C_fcall trf_7027(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7027(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_7027(t0,t1,t2,t3);}

C_noret_decl(trf_8182)
static void C_fcall trf_8182(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8182(void *dummy){
C_word t7=C_pick(0);
C_word t6=C_pick(1);
C_word t5=C_pick(2);
C_word t4=C_pick(3);
C_word t3=C_pick(4);
C_word t2=C_pick(5);
C_word t1=C_pick(6);
C_word t0=C_pick(7);
C_adjust_stack(-8);
f_8182(t0,t1,t2,t3,t4,t5,t6,t7);}

C_noret_decl(trf_8153)
static void C_fcall trf_8153(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8153(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_8153(t0,t1,t2,t3);}

C_noret_decl(trf_8141)
static void C_fcall trf_8141(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8141(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_8141(t0,t1,t2);}

C_noret_decl(trf_6984)
static void C_fcall trf_6984(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6984(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_6984(t0,t1);}

C_noret_decl(trf_6174)
static void C_fcall trf_6174(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6174(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_6174(t0,t1);}

C_noret_decl(trf_6962)
static void C_fcall trf_6962(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6962(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_6962(t0,t1,t2,t3);}

C_noret_decl(trf_8084)
static void C_fcall trf_8084(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8084(void *dummy){
C_word t6=C_pick(0);
C_word t5=C_pick(1);
C_word t4=C_pick(2);
C_word t3=C_pick(3);
C_word t2=C_pick(4);
C_word t1=C_pick(5);
C_word t0=C_pick(6);
C_adjust_stack(-7);
f_8084(t0,t1,t2,t3,t4,t5,t6);}

C_noret_decl(trf_8121)
static void C_fcall trf_8121(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8121(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_8121(t0,t1);}

C_noret_decl(trf_8307)
static void C_fcall trf_8307(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8307(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_8307(t0,t1,t2);}

C_noret_decl(trf_8305)
static void C_fcall trf_8305(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8305(void *dummy){
C_word t6=C_pick(0);
C_word t5=C_pick(1);
C_word t4=C_pick(2);
C_word t3=C_pick(3);
C_word t2=C_pick(4);
C_word t1=C_pick(5);
C_word t0=C_pick(6);
C_adjust_stack(-7);
f_8305(t0,t1,t2,t3,t4,t5,t6);}

C_noret_decl(trf_7543)
static void C_fcall trf_7543(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7543(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_7543(t0,t1,t2);}

C_noret_decl(trf_3981)
static void C_fcall trf_3981(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3981(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3981(t0,t1,t2);}

C_noret_decl(trf_4234)
static void C_fcall trf_4234(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4234(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4234(t0,t1);}

C_noret_decl(trf_3993)
static void C_fcall trf_3993(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3993(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3993(t0,t1,t2);}

C_noret_decl(trf_3483)
static void C_fcall trf_3483(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3483(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3483(t0,t1);}

C_noret_decl(trf_3480)
static void C_fcall trf_3480(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3480(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3480(t0,t1);}

C_noret_decl(trf_3492)
static void C_fcall trf_3492(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3492(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_3492(t0,t1,t2,t3);}

C_noret_decl(trf_6933)
static void C_fcall trf_6933(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6933(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_6933(t0,t1);}

C_noret_decl(trf_2942)
static void C_fcall trf_2942(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2942(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_2942(t0,t1,t2,t3);}

C_noret_decl(trf_2979)
static void C_fcall trf_2979(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2979(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_2979(t0,t1,t2,t3,t4);}

C_noret_decl(trf_3406)
static void C_fcall trf_3406(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3406(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3406(t0,t1,t2);}

C_noret_decl(trf_7736)
static void C_fcall trf_7736(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7736(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_7736(t0,t1,t2,t3);}

C_noret_decl(trf_7759)
static void C_fcall trf_7759(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7759(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_7759(t0,t1,t2,t3);}

C_noret_decl(trf_3427)
static void C_fcall trf_3427(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3427(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3427(t0,t1,t2);}

C_noret_decl(trf_8034)
static void C_fcall trf_8034(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_8034(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_8034(t0,t1);}

C_noret_decl(trf_4543)
static void C_fcall trf_4543(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4543(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4543(t0,t1);}

C_noret_decl(trf_6027)
static void C_fcall trf_6027(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6027(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_6027(t0,t1,t2,t3);}

C_noret_decl(trf_4514)
static void C_fcall trf_4514(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4514(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_4514(t0,t1,t2,t3,t4);}

C_noret_decl(trf_6830)
static void C_fcall trf_6830(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6830(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_6830(t0,t1,t2,t3,t4);}

C_noret_decl(trf_5449)
static void C_fcall trf_5449(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5449(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_5449(t0,t1);}

C_noret_decl(trf_7812)
static void C_fcall trf_7812(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7812(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_7812(t0,t1,t2,t3);}

C_noret_decl(trf_6397)
static void C_fcall trf_6397(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6397(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_6397(t0,t1,t2,t3,t4);}

C_noret_decl(trf_4573)
static void C_fcall trf_4573(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4573(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_4573(t0,t1,t2,t3,t4);}

C_noret_decl(trf_3372)
static void C_fcall trf_3372(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3372(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3372(t0,t1,t2);}

C_noret_decl(trf_7858)
static void C_fcall trf_7858(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7858(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_7858(t0,t1,t2,t3);}

C_noret_decl(trf_4872)
static void C_fcall trf_4872(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4872(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4872(t0,t1);}

C_noret_decl(trf_4865)
static void C_fcall trf_4865(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4865(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4865(t0,t1,t2);}

C_noret_decl(trf_6395)
static void C_fcall trf_6395(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6395(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_6395(t0,t1);}

C_noret_decl(trf_3292)
static void C_fcall trf_3292(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3292(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3292(t0,t1);}

C_noret_decl(trf_3266)
static void C_fcall trf_3266(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3266(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3266(t0,t1);}

C_noret_decl(trf_7322)
static void C_fcall trf_7322(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7322(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_7322(t0,t1);}

C_noret_decl(trf_4333)
static void C_fcall trf_4333(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4333(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4333(t0,t1);}

C_noret_decl(trf_5011)
static void C_fcall trf_5011(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5011(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_5011(t0,t1,t2,t3,t4);}

C_noret_decl(trf_5688)
static void C_fcall trf_5688(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5688(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_5688(t0,t1,t2,t3);}

C_noret_decl(trf_4399)
static void C_fcall trf_4399(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4399(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4399(t0,t1);}

C_noret_decl(trf_4396)
static void C_fcall trf_4396(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4396(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4396(t0,t1);}

C_noret_decl(trf_3077)
static void C_fcall trf_3077(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3077(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3077(t0,t1);}

C_noret_decl(trf_6211)
static void C_fcall trf_6211(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6211(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_6211(t0,t1);}

C_noret_decl(trf_5630)
static void C_fcall trf_5630(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5630(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_5630(t0,t1,t2);}

C_noret_decl(trf_7469)
static void C_fcall trf_7469(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7469(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_7469(t0,t1);}

C_noret_decl(trf_7481)
static void C_fcall trf_7481(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7481(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_7481(t0,t1);}

C_noret_decl(tr9)
static void C_fcall tr9(C_proc9 k) C_regparm C_noret;
C_regparm static void C_fcall tr9(C_proc9 k){
C_word t8=C_pick(0);
C_word t7=C_pick(1);
C_word t6=C_pick(2);
C_word t5=C_pick(3);
C_word t4=C_pick(4);
C_word t3=C_pick(5);
C_word t2=C_pick(6);
C_word t1=C_pick(7);
C_word t0=C_pick(8);
C_adjust_stack(-9);
(k)(9,t0,t1,t2,t3,t4,t5,t6,t7,t8);}

C_noret_decl(tr6)
static void C_fcall tr6(C_proc6 k) C_regparm C_noret;
C_regparm static void C_fcall tr6(C_proc6 k){
C_word t5=C_pick(0);
C_word t4=C_pick(1);
C_word t3=C_pick(2);
C_word t2=C_pick(3);
C_word t1=C_pick(4);
C_word t0=C_pick(5);
C_adjust_stack(-6);
(k)(6,t0,t1,t2,t3,t4,t5);}

C_noret_decl(tr5)
static void C_fcall tr5(C_proc5 k) C_regparm C_noret;
C_regparm static void C_fcall tr5(C_proc5 k){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
(k)(5,t0,t1,t2,t3,t4);}

C_noret_decl(tr4)
static void C_fcall tr4(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4(C_proc4 k){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
(k)(4,t0,t1,t2,t3);}

C_noret_decl(tr3)
static void C_fcall tr3(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3(C_proc3 k){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
(k)(3,t0,t1,t2);}

C_noret_decl(tr2)
static void C_fcall tr2(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2(C_proc2 k){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
(k)(2,t0,t1);}

C_noret_decl(tr5r)
static void C_fcall tr5r(C_proc5 k) C_regparm C_noret;
C_regparm static void C_fcall tr5r(C_proc5 k){
int n;
C_word *a,t5;
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
n=C_rest_count(0);
a=C_alloc(n*3);
t5=C_restore_rest(a,n);
(k)(t0,t1,t2,t3,t4,t5);}

C_noret_decl(tr7r)
static void C_fcall tr7r(C_proc7 k) C_regparm C_noret;
C_regparm static void C_fcall tr7r(C_proc7 k){
int n;
C_word *a,t7;
C_word t6=C_pick(0);
C_word t5=C_pick(1);
C_word t4=C_pick(2);
C_word t3=C_pick(3);
C_word t2=C_pick(4);
C_word t1=C_pick(5);
C_word t0=C_pick(6);
C_adjust_stack(-7);
n=C_rest_count(0);
a=C_alloc(n*3);
t7=C_restore_rest(a,n);
(k)(t0,t1,t2,t3,t4,t5,t6,t7);}

C_noret_decl(tr4r)
static void C_fcall tr4r(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4r(C_proc4 k){
int n;
C_word *a,t4;
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
n=C_rest_count(0);
a=C_alloc(n*3);
t4=C_restore_rest(a,n);
(k)(t0,t1,t2,t3,t4);}

C_noret_decl(tr3r)
static void C_fcall tr3r(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3r(C_proc3 k){
int n;
C_word *a,t3;
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
n=C_rest_count(0);
a=C_alloc(n*3);
t3=C_restore_rest(a,n);
(k)(t0,t1,t2,t3);}

C_noret_decl(tr2r)
static void C_fcall tr2r(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2r(C_proc2 k){
int n;
C_word *a,t2;
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
n=C_rest_count(0);
a=C_alloc(n*3);
t2=C_restore_rest(a,n);
(k)(t0,t1,t2);}

/* get-host-name in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7635(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7635,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7639,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t3=C_a_i_bytevector(&a,1,C_fix(3));
t4=stub1818(t3);
/* posixunix.scm:1630: ##sys#peek-c-string */
t5=*((C_word*)lf[4]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t2,t4,C_fix(0));}

/* k7637 in get-host-name in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7639(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7639,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7642,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(t2)){
t4=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t2);}
else{
/* posixunix.scm:1636: posix-error */
t4=lf[0];
f_2668(5,t4,t3,lf[413],lf[417],lf[418]);}}

/* k7625 in k7621 in k7600 in terminal-size in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7627(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
t2=C_i_foreign_fixnum_argumentp(((C_word*)t0)[2]);
t3=C_i_foreign_pointer_argumentp(((C_word*)t0)[3]);
t4=C_i_foreign_pointer_argumentp(t1);
t5=stub1799(C_SCHEME_UNDEFINED,t2,t3,t4);
t6=C_eqp(C_fix(0),t5);
if(C_truep(t6)){
/* posixunix.scm:1624: values */
C_values(4,0,((C_word*)t0)[4],C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[5]))),C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[6]))));}
else{
/* posixunix.scm:1625: posix-error */
t7=lf[0];
f_2668(6,t7,((C_word*)t0)[4],lf[413],lf[412],lf[414],((C_word*)t0)[7]);}}

/* k7621 in k7600 in terminal-size in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7623(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7623,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_7627,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm:1623: ##sys#make-locative */
((C_proc6)C_fast_retrieve_proc(*((C_word*)lf[415]+1)))(6,*((C_word*)lf[415]+1),t3,((C_word*)t0)[5],C_fix(0),C_SCHEME_FALSE,lf[416]);}

/* process-fork in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7649(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr2r,(void*)f_7649r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_7649r(t0,t1,t2);}}

static void C_ccall f_7649r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word *a=C_alloc(6);
t3=C_i_nullp(t2);
t4=(C_truep(t3)?C_SCHEME_FALSE:C_i_car(t2));
t5=t4;
t6=C_i_nullp(t2);
t7=(C_truep(t6)?C_SCHEME_END_OF_LIST:C_i_cdr(t2));
t8=C_i_nullp(t7);
t9=(C_truep(t8)?C_SCHEME_FALSE:C_i_car(t7));
t10=t9;
t11=C_i_nullp(t7);
t12=(C_truep(t11)?C_SCHEME_END_OF_LIST:C_i_cdr(t7));
t13=stub1825(C_SCHEME_UNDEFINED);
t14=t13;
t15=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7668,a[2]=t5,a[3]=t14,a[4]=t10,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t16=C_eqp(C_fix(-1),t14);
if(C_truep(t16)){
/* posixunix.scm:1647: posix-error */
t17=lf[0];
f_2668(5,t17,t15,lf[122],lf[419],lf[421]);}
else{
t17=t15;
f_7668(2,t17,C_SCHEME_UNDEFINED);}}

/* k7640 in k7637 in get-host-name in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7642(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[3]);}

/* k7421 in k7415 in k7411 in utc-time->seconds in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7423(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
/* posixunix.scm:1550: ##sys#error */
t2=*((C_word*)lf[41]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[397],lf[398],((C_word*)t0)[3]);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[4]);}}

/* k5254 in create-pipe in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5256(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:787: values */
C_values(4,0,((C_word*)t0)[2],C_fix((C_word)C_pipefds[ 0 ]),C_fix((C_word)C_pipefds[ 1 ]));}

/* create-pipe in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5252(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5252,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5256,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t3=C_pipe(C_SCHEME_FALSE);
if(C_truep(C_fixnum_lessp(t3,C_fix(0)))){
/* posixunix.scm:786: posix-error */
t4=lf[0];
f_2668(5,t4,t2,lf[8],lf[215],lf[216]);}
else{
/* posixunix.scm:787: values */
C_values(4,0,t1,C_fix((C_word)C_pipefds[ 0 ]),C_fix((C_word)C_pipefds[ 1 ]));}}

/* k5617 in get-groups in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5619(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5619,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5622,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=C_i_foreign_fixnum_argumentp(((C_word*)t0)[2]);
if(C_truep(stub1210(C_SCHEME_UNDEFINED,t3))){
t4=t2;
f_5622(2,t4,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm:1030: ##sys#error */
t4=*((C_word*)lf[41]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,lf[266],lf[268]);}}

/* get-groups in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5615(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5615,2,t0,t1);}
t2=C_fix((C_word)getgroups(0, C_groups));
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5619,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5674,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1027: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[5]+1)))(2,*((C_word*)lf[5]+1),t4);}
else{
t4=t3;
f_5619(2,t4,C_SCHEME_UNDEFINED);}}

/* k7137 in create-fifo in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_7139(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7139,NULL,2,t0,t1);}
t2=t1;
t3=C_i_check_exact_2(t2,lf[372]);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7156,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7160,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1465: ##sys#expand-home-path */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(3,*((C_word*)lf[12]+1),t5,((C_word*)t0)[3]);}

/* create-fifo in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7132(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f_7132r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_7132r(t0,t1,t2,t3);}}

static void C_ccall f_7132r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(4);
t4=C_i_check_string_2(t2,lf[372]);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7139,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_pairp(t3))){
t6=t3;
t7=t5;
f_7139(t7,C_u_i_car(t6));}
else{
t6=C_fixnum_or(C_fix((C_word)S_IRWXG),C_fix((C_word)S_IRWXO));
t7=t5;
f_7139(t7,C_fixnum_or(C_fix((C_word)S_IRWXU),t6));}}

/* k7600 in terminal-size in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7602(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7602,2,t0,t1);}
t2=C_a_i_bytevector(&a,1,C_fix(1));
t3=C_a_i_bytevector(&a,1,C_fix(1));
t4=C_C_fileno(((C_word*)t0)[2]);
t5=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_7623,a[2]=t4,a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=t3,a[6]=((C_word*)t0)[2],tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm:1622: ##sys#make-locative */
((C_proc6)C_fast_retrieve_proc(*((C_word*)lf[415]+1)))(6,*((C_word*)lf[415]+1),t5,t2,C_fix(0),C_SCHEME_FALSE,lf[416]);}

/* k6509 in a6490 in a6480 in k6474 in k6465 in a6462 in k6171 in k6165 in custom-input-port in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in ... */
static void C_ccall f_6511(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(C_fixnum_lessp(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]))){
t2=C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[4])[1]);
t3=C_i_fixnum_min(((C_word*)((C_word*)t0)[3])[1],t2);
/* posixunix.scm:1322: values */
C_values(5,0,((C_word*)t0)[5],((C_word*)t0)[6],((C_word*)((C_word*)t0)[2])[1],t3);}
else{
/* posixunix.scm:1325: values */
C_values(5,0,((C_word*)t0)[5],C_SCHEME_FALSE,((C_word*)((C_word*)t0)[2])[1],C_SCHEME_FALSE);}}

/* k7158 in k7137 in create-fifo in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7160(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1465: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),((C_word*)t0)[2],t1,lf[372]);}

/* k7154 in k7137 in create-fifo in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7156(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_mkfifo(t1,((C_word*)t0)[2]);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm:1466: posix-error */
t3=lf[0];
f_2668(7,t3,((C_word*)t0)[3],lf[8],lf[372],lf[373],((C_word*)t0)[4],((C_word*)t0)[2]);}
else{
t3=C_SCHEME_UNDEFINED;
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k8766 in a8734 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8768(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8768,2,t0,t1);}
t2=((C_word*)t0)[2];
t3=((C_word*)t0)[3];
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8745,a[2]=t2,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
if(C_truep(t1)){
t5=C_i_foreign_string_argumentp(t1);
/* posix-common.scm:250: ##sys#make-c-string */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(3,*((C_word*)lf[10]+1),t4,t5);}
else{
t5=t2;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,stub120(C_SCHEME_UNDEFINED,C_SCHEME_FALSE,t3));}}

/* k7179 in fifo? in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7181(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_i_fifo_p(t1);
switch(t2){
case C_SCHEME_TRUE:
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_TRUE);
case C_SCHEME_FALSE:
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_FALSE);
case C_fix(0):
/* posixunix.scm:1476: ##sys#signal-hook */
t3=*((C_word*)lf[1]+1);
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,((C_word*)t0)[2],lf[8],lf[34],lf[374],((C_word*)t0)[3]);
default:
/* posixunix.scm:1478: posix-error */
t3=lf[0];
f_2668(6,t3,((C_word*)t0)[2],lf[8],lf[34],lf[375],((C_word*)t0)[3]);}}

/* set-signal-mask! in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5299(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5299,3,t0,t1,t2);}
t3=C_i_check_list_2(t2,lf[245]);
t4=C_sigemptyset(C_fix(0));
t5=t2;
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5323,a[2]=((C_word)li109),tmp=(C_word)a,a+=3,tmp);
t7=f_5323(t5);
t8=C_sigprocmask_set(C_fix(0));
if(C_truep(C_fixnum_lessp(t8,C_fix(0)))){
/* posixunix.scm:866: posix-error */
t9=lf[0];
f_2668(5,t9,t1,lf[122],lf[245],lf[246]);}
else{
t9=C_SCHEME_UNDEFINED;
t10=t1;
((C_proc2)(void*)(*((C_word*)t10+1)))(2,t10,t9);}}

/* fifo? in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7173(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7173,3,t0,t1,t2);}
t3=C_i_check_string_2(t2,lf[34]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7181,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7215,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1473: ##sys#expand-home-path */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(3,*((C_word*)lf[12]+1),t5,t2);}

/* k4600 in lp in k4632 in k4408 in k4400 in k4397 in k4394 in file-select in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_4602(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4602,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=C_fixnum_plus(((C_word*)t0)[2],C_fix(1));
t3=C_i_car(((C_word*)t0)[3]);
t4=C_a_i_cons(&a,2,t3,((C_word*)t0)[4]);
t5=((C_word*)t0)[3];
t6=C_u_i_cdr(t5);
/* posixunix.scm:602: lp */
t7=((C_word*)((C_word*)t0)[5])[1];
f_4573(t7,((C_word*)t0)[6],t2,t4,t6);}
else{
t2=C_fixnum_plus(((C_word*)t0)[2],C_fix(1));
t3=C_i_cdr(((C_word*)t0)[3]);
/* posixunix.scm:603: lp */
t4=((C_word*)((C_word*)t0)[5])[1];
f_4573(t4,((C_word*)t0)[6],t2,((C_word*)t0)[4],t3);}}

/* k2772 in file-permissions in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_2774(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_mode));}

/* file-size in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_2776(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2776,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2780,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:262: ##sys#stat */
f_2686(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[21]);}

/* file-permissions in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_2770(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2770,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2774,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:261: ##sys#stat */
f_2686(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[20]);}

/* a6585 in k6171 in k6165 in custom-input-port in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_6586(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6586,3,t0,t1,t2);}
if(C_truep(C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]))){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,lf[353]);}
else{
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6596,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1338: ##sys#substring */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[63]+1)))(5,*((C_word*)lf[63]+1),t3,((C_word*)t0)[4],((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]);}}

/* a5237 in a5231 in k5220 in with-output-to-pipe in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5238(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_5238r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_5238r(t0,t1,t2);}}

static void C_ccall f_5238r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5242,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:777: close-output-pipe */
t4=*((C_word*)lf[207]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* a5231 in k5220 in with-output-to-pipe in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5232(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5232,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5238,a[2]=((C_word*)t0)[2],a[3]=((C_word)li104),tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:775: ##sys#call-with-values */
C_call_with_values(4,0,t1,((C_word*)t0)[3],t2);}

/* k7666 in process-fork in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7668(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7668,2,t0,t1);}
t2=(C_truep(((C_word*)t0)[2])?C_eqp(((C_word*)t0)[3],C_fix(0)):C_SCHEME_FALSE);
if(C_truep(t2)){
t3=(C_truep(((C_word*)t0)[4])?*((C_word*)lf[420]+1):(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7696,a[2]=((C_word)li187),tmp=(C_word)a,a+=3,tmp));
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7682,a[2]=((C_word*)t0)[2],a[3]=((C_word)li188),tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1648: g1845 */
t5=t3;
((C_proc3)C_fast_retrieve_proc(t5))(3,t5,((C_word*)t0)[5],t4);}
else{
t3=((C_word*)t0)[5];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,((C_word*)t0)[3]);}}

/* a5246 in k5220 in with-output-to-pipe in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5247(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5247,2,t0,t1);}
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,*((C_word*)lf[214]+1));
t3=C_mutate2((C_word*)lf[214]+1 /* (set! ##sys#standard-output ...) */,((C_word*)((C_word*)t0)[3])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}

/* k5240 in a5237 in a5231 in k5220 in with-output-to-pipe in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5242(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply_values(3,0,((C_word*)t0)[2],((C_word*)t0)[3]);}

/* k3890 in k3881 in time->string in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3892(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}
else{
/* posix-common.scm:551: ##sys#error */
t2=*((C_word*)lf[41]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[110],lf[111],((C_word*)t0)[3]);}}

/* k6594 in a6585 in k6171 in k6165 in custom-input-port in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_6596(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}

/* k8743 in k8766 in a8734 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8745(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,stub120(C_SCHEME_UNDEFINED,t1,((C_word*)t0)[3]));}

/* doloop805 in k4408 in k4400 in k4397 in k4394 in file-select in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static C_word C_fcall f_4647(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_stack_overflow_check;
loop:
if(C_truep(C_i_nullp(t2))){
t3=C_SCHEME_UNDEFINED;
return(t3);}
else{
t3=C_i_car(t2);
t4=t1;
t5=C_i_foreign_fixnum_argumentp(t4);
t6=C_i_foreign_fixnum_argumentp(t3);
if(C_truep(((C_word*)t0)[2])){
t7=C_i_foreign_block_argumentp(((C_word*)t0)[2]);
t8=stub814(C_SCHEME_UNDEFINED,t5,t6,t7);
t9=C_fixnum_plus(t1,C_fix(1));
t10=t2;
t11=C_u_i_cdr(t10);
t18=t9;
t19=t11;
t1=t18;
t2=t19;
goto loop;}
else{
t7=stub814(C_SCHEME_UNDEFINED,t5,t6,C_SCHEME_FALSE);
t8=C_fixnum_plus(t1,C_fix(1));
t9=t2;
t10=C_u_i_cdr(t9);
t18=t8;
t19=t10;
t1=t18;
t2=t19;
goto loop;}}}

/* k4643 in k4408 in k4400 in k4397 in k4394 in file-select in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_4645(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4645,2,t0,t1);}
t2=C_a_i_times(&a,2,t1,C_fix(1000));
t3=((C_word*)t0)[2];
f_4634(t3,C_i_inexact_to_exact(t2));}

/* k2735 in file-stat in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_2737(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[30],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2737,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_i_vector(&a,13,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_ino),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_mode),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_nlink),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_uid),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_gid),C_a_double_to_num(&a,C_statbuf.st_size),C_flonum(&a,C_statbuf.st_atime),C_flonum(&a,C_statbuf.st_ctime),C_flonum(&a,C_statbuf.st_mtime),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_dev),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_rdev),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_blksize),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_blocks)));}

/* time->string in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3876(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr3r,(void*)f_3876r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3876r(t0,t1,t2,t3);}}

static void C_ccall f_3876r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(6);
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=t5;
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3883,a[2]=t6,a[3]=t1,a[4]=t2,a[5]=((C_word*)t0)[2],tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:546: check-time-vector */
f_3722(t7,lf[110],t2);}

/* file-stat in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_2730(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr3r,(void*)f_2730r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2730r(t0,t1,t2,t3);}}

static void C_ccall f_2730r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(3);
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2737,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:237: ##sys#stat */
f_2686(t6,t2,t5,C_SCHEME_TRUE,lf[15]);}

/* a3589 in k3543 in k3607 in k3614 in k3509 in loop in k3488 in k3481 in k3478 in k3686 in k3683 in k3680 in k3677 in k3674 in k3671 in find-files in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 in ... */
static void C_ccall f_3590(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3590,2,t0,t1);}
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate2(((C_word *)((C_word*)t0)[3])+1,((C_word*)((C_word*)t0)[4])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}

/* f_3647 in k3644 in k3478 in k3686 in k3683 in k3680 in k3677 in k3674 in k3671 in find-files in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3647(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3647,3,t0,t1,t2);}
/* posix-common.scm:464: irregex-match */
t3=*((C_word*)lf[79]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,((C_word*)t0)[2],t2);}

/* file-owner in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_2764(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2764,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2768,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:260: ##sys#stat */
f_2686(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[19]);}

/* k3644 in k3478 in k3686 in k3683 in k3680 in k3677 in k3674 in k3671 in find-files in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3646(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3646,2,t0,t1);}
t2=t1;
t3=((C_word*)t0)[2];
f_3483(t3,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3647,a[2]=t2,a[3]=((C_word)li39),tmp=(C_word)a,a+=4,tmp));}

/* k2760 in file-change-time in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_2762(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2762,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_ctime));}

/* k2766 in file-owner in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_2768(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_uid));}

/* k3881 in time->string in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3883(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3883,2,t0,t1);}
if(C_truep(((C_word*)t0)[2])){
t2=C_i_check_string_2(((C_word*)t0)[2],lf[110]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3892,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3902,a[2]=((C_word*)t0)[4],a[3]=t3,a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:550: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),t4,((C_word*)t0)[2],lf[110]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3909,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3930,a[2]=((C_word*)t0)[4],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:552: ##sys#make-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[65]+1)))(4,*((C_word*)lf[65]+1),t3,((C_word*)t0)[5],C_make_character(0));}}

/* a3561 in k3543 in k3607 in k3614 in k3509 in loop in k3488 in k3481 in k3478 in k3686 in k3683 in k3680 in k3677 in k3674 in k3671 in find-files in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 in ... */
static void C_ccall f_3562(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3562,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3570,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3584,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
if(C_truep(((C_word*)t0)[7])){
/* posix-common.scm:478: make-pathname */
t4=*((C_word*)lf[77]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,((C_word*)t0)[4],lf[85]);}
else{
/* posix-common.scm:478: make-pathname */
t4=*((C_word*)lf[77]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,((C_word*)t0)[4],lf[86]);}}

/* file-unlock in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7104(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7104,3,t0,t1,t2);}
t3=C_i_check_structure_2(t2,lf[362],lf[370]);
t4=C_slot(t2,C_fix(2));
t5=C_slot(t2,C_fix(3));
t6=C_flock_setup(C_fix((C_word)F_UNLCK),t4,t5);
t7=C_slot(t2,C_fix(1));
t8=C_flock_lock(t7);
if(C_truep(C_fixnum_lessp(t8,C_fix(0)))){
/* posixunix.scm:1455: posix-error */
t9=lf[0];
f_2668(6,t9,t1,lf[8],lf[370],lf[371],t2);}
else{
t9=C_SCHEME_UNDEFINED;
t10=t1;
((C_proc2)(void*)(*((C_word*)t10+1)))(2,t10,t9);}}

/* file-access-time in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_2752(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2752,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2756,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:258: ##sys#stat */
f_2686(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[17]);}

/* file-change-time in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_2758(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2758,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2762,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:259: ##sys#stat */
f_2686(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[18]);}

/* k2754 in file-access-time in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_2756(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2756,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_atime));}

/* k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_2750(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word ab[89],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2750,2,t0,t1);}
t2=C_mutate2((C_word*)lf[16]+1 /* (set! file-modification-time ...) */,t1);
t3=C_mutate2((C_word*)lf[17]+1 /* (set! file-access-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2752,a[2]=((C_word)li3),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate2((C_word*)lf[18]+1 /* (set! file-change-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2758,a[2]=((C_word)li4),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate2((C_word*)lf[19]+1 /* (set! file-owner ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2764,a[2]=((C_word)li5),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate2((C_word*)lf[20]+1 /* (set! file-permissions ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2770,a[2]=((C_word)li6),tmp=(C_word)a,a+=3,tmp));
t7=C_mutate2((C_word*)lf[21]+1 /* (set! file-size ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2776,a[2]=((C_word)li7),tmp=(C_word)a,a+=3,tmp));
t8=C_mutate2((C_word*)lf[22]+1 /* (set! file-type ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2782,a[2]=((C_word)li8),tmp=(C_word)a,a+=3,tmp));
t9=C_mutate2((C_word*)lf[30]+1 /* (set! regular-file? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2869,a[2]=((C_word)li9),tmp=(C_word)a,a+=3,tmp));
t10=C_mutate2((C_word*)lf[31]+1 /* (set! symbolic-link? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2879,a[2]=((C_word)li10),tmp=(C_word)a,a+=3,tmp));
t11=C_mutate2((C_word*)lf[32]+1 /* (set! block-device? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2889,a[2]=((C_word)li11),tmp=(C_word)a,a+=3,tmp));
t12=C_mutate2((C_word*)lf[33]+1 /* (set! character-device? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2899,a[2]=((C_word)li12),tmp=(C_word)a,a+=3,tmp));
t13=C_mutate2((C_word*)lf[34]+1 /* (set! fifo? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2909,a[2]=((C_word)li13),tmp=(C_word)a,a+=3,tmp));
t14=C_mutate2((C_word*)lf[35]+1 /* (set! socket? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2919,a[2]=((C_word)li14),tmp=(C_word)a,a+=3,tmp));
t15=C_mutate2((C_word*)lf[36]+1 /* (set! directory? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2929,a[2]=((C_word)li15),tmp=(C_word)a,a+=3,tmp));
t16=C_mutate2((C_word*)lf[37]+1 /* (set! fileno/stdin ...) */,C_fix((C_word)STDIN_FILENO));
t17=C_mutate2((C_word*)lf[38]+1 /* (set! fileno/stdout ...) */,C_fix((C_word)STDOUT_FILENO));
t18=C_mutate2((C_word*)lf[39]+1 /* (set! fileno/stderr ...) */,C_fix((C_word)STDERR_FILENO));
t19=C_SCHEME_UNDEFINED;
t20=(*a=C_VECTOR_TYPE|1,a[1]=t19,tmp=(C_word)a,a+=2,tmp);
t21=C_SCHEME_UNDEFINED;
t22=(*a=C_VECTOR_TYPE|1,a[1]=t21,tmp=(C_word)a,a+=2,tmp);
t23=C_set_block_item(t20,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2942,a[2]=((C_word)li16),tmp=(C_word)a,a+=3,tmp));
t24=C_set_block_item(t22,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2979,a[2]=((C_word)li17),tmp=(C_word)a,a+=3,tmp));
t25=C_mutate2((C_word*)lf[52]+1 /* (set! open-input-file* ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2994,a[2]=t22,a[3]=t20,a[4]=((C_word)li18),tmp=(C_word)a,a+=5,tmp));
t26=C_mutate2((C_word*)lf[53]+1 /* (set! open-output-file* ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3008,a[2]=t22,a[3]=t20,a[4]=((C_word)li19),tmp=(C_word)a,a+=5,tmp));
t27=C_mutate2((C_word*)lf[54]+1 /* (set! port->fileno ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3022,a[2]=((C_word)li20),tmp=(C_word)a,a+=3,tmp));
t28=C_mutate2((C_word*)lf[59]+1 /* (set! duplicate-fileno ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3070,a[2]=((C_word)li21),tmp=(C_word)a,a+=3,tmp));
t29=C_mutate2((C_word*)lf[61]+1 /* (set! current-directory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3097,a[2]=((C_word)li22),tmp=(C_word)a,a+=3,tmp));
t30=C_mutate2((C_word*)lf[66]+1 /* (set! delete-directory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3131,a[2]=((C_word)li26),tmp=(C_word)a,a+=3,tmp));
t31=C_mutate2((C_word*)lf[25]+1 /* (set! directory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3223,a[2]=((C_word)li28),tmp=(C_word)a,a+=3,tmp));
t32=C_mutate2((C_word*)lf[75]+1 /* (set! glob ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3366,a[2]=((C_word)li34),tmp=(C_word)a,a+=3,tmp));
t33=C_mutate2((C_word*)lf[70]+1 /* (set! find-files ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3669,a[2]=((C_word)li50),tmp=(C_word)a,a+=3,tmp));
t34=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3720,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t35=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8698,a[2]=((C_word)li243),tmp=(C_word)a,a+=3,tmp);
t36=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8723,a[2]=((C_word)li244),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:496: getter-with-setter */
t37=*((C_word*)lf[446]+1);
((C_proc5)(void*)(*((C_word*)t37+1)))(5,t37,t34,t35,t36,lf[462]);}

/* k3627 in k3620 in k3509 in loop in k3488 in k3481 in k3478 in k3686 in k3683 in k3680 in k3677 in k3674 in k3671 in find-files in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3629(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:481: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_3492(t2,((C_word*)t0)[3],((C_word*)t0)[4],t1);}

/* file-type in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_2782(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr3r,(void*)f_2782r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2782r(t0,t1,t2,t3);}}

static void C_ccall f_2782r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word *a=C_alloc(3);
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=C_i_nullp(t3);
t7=(C_truep(t6)?C_SCHEME_END_OF_LIST:C_i_cdr(t3));
t8=C_i_nullp(t7);
t9=(C_truep(t8)?C_SCHEME_TRUE:C_i_car(t7));
t10=C_i_nullp(t7);
t11=(C_truep(t10)?C_SCHEME_END_OF_LIST:C_i_cdr(t7));
t12=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2801,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:265: ##sys#stat */
f_2686(t12,t2,t5,t9,lf[22]);}

/* k3620 in k3509 in loop in k3488 in k3481 in k3478 in k3686 in k3683 in k3680 in k3677 in k3674 in k3671 in find-files in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3622(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3622,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3629,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:481: action */
t3=((C_word*)t0)[5];
((C_proc4)C_fast_retrieve_proc(t3))(4,t3,t2,((C_word*)t0)[6],((C_word*)t0)[7]);}
else{
/* posix-common.scm:482: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_3492(t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[7]);}}

/* k2778 in file-size in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_2780(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2780,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_double_to_num(&a,C_statbuf.st_size));}

/* k3582 in a3561 in k3543 in k3607 in k3614 in k3509 in loop in k3488 in k3481 in k3478 in k3686 in k3683 in k3680 in k3677 in k3674 in k3671 in find-files in k2748 in k2654 in k2651 in k2648 in k2645 in ... */
static void C_ccall f_3584(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:478: glob */
t2=*((C_word*)lf[75]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* doloop787 in k4408 in k4400 in k4397 in k4394 in file-select in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static C_word C_fcall f_4689(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_stack_overflow_check;
loop:
if(C_truep(C_i_nullp(t2))){
t3=C_SCHEME_UNDEFINED;
return(t3);}
else{
t3=C_i_car(t2);
t4=t1;
t5=C_i_foreign_fixnum_argumentp(t4);
t6=C_i_foreign_fixnum_argumentp(t3);
if(C_truep(((C_word*)t0)[2])){
t7=C_i_foreign_block_argumentp(((C_word*)t0)[2]);
t8=stub796(C_SCHEME_UNDEFINED,t5,t6,t7);
t9=C_fixnum_plus(t1,C_fix(1));
t10=t2;
t11=C_u_i_cdr(t10);
t18=t9;
t19=t11;
t1=t18;
t2=t19;
goto loop;}
else{
t7=stub796(C_SCHEME_UNDEFINED,t5,t6,C_SCHEME_FALSE);
t8=C_fixnum_plus(t1,C_fix(1));
t9=t2;
t10=C_u_i_cdr(t9);
t18=t8;
t19=t10;
t1=t18;
t2=t19;
goto loop;}}}

/* k3634 in k3481 in k3478 in k3686 in k3683 in k3680 in k3677 in k3674 in k3671 in find-files in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3636(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:465: glob */
t2=*((C_word*)lf[75]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3837 in k3833 in local-time->seconds in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3839(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3839,2,t0,t1);}
t2=C_a_mktime(&a,2,((C_word*)t0)[2],t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3845,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:537: fp= */
t4=*((C_word*)lf[108]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,lf[109],t2);}

/* k3833 in local-time->seconds in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3835(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3835,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3839,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:536: ##sys#make-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[65]+1)))(4,*((C_word*)lf[65]+1),t2,((C_word*)t0)[4],C_make_character(0));}

/* local-time->seconds in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3831(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3831,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3835,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:535: check-time-vector */
f_3722(t3,lf[106],t2);}

/* a3556 in k3543 in k3607 in k3614 in k3509 in loop in k3488 in k3481 in k3478 in k3686 in k3683 in k3680 in k3677 in k3674 in k3671 in find-files in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 in ... */
static void C_ccall f_3557(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3557,2,t0,t1);}
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate2(((C_word *)((C_word*)t0)[3])+1,((C_word*)((C_word*)t0)[4])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}

/* k8731 in a8728 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8733(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8733,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_mtime));}

/* a8734 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8735(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[9],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_8735,4,t0,t1,t2,t3);}
t4=C_i_check_number_2(t3,lf[463]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_8755,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8768,a[2]=t5,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:251: ##sys#expand-home-path */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(3,*((C_word*)lf[12]+1),t6,t2);}

/* k3553 in k3543 in k3607 in k3614 in k3509 in loop in k3488 in k3481 in k3478 in k3686 in k3683 in k3680 in k3677 in k3674 in k3671 in find-files in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 in ... */
static void C_ccall f_3555(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:476: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_3492(t2,((C_word*)t0)[3],((C_word*)t0)[4],t1);}

/* k3601 in k3543 in k3607 in k3614 in k3509 in loop in k3488 in k3481 in k3478 in k3686 in k3683 in k3680 in k3677 in k3674 in k3671 in find-files in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 in ... */
static void C_ccall f_3603(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
/* posix-common.scm:480: action */
t2=((C_word*)t0)[2];
((C_proc4)C_fast_retrieve_proc(t2))(4,t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5]);}
else{
t2=((C_word*)t0)[5];
/* posix-common.scm:480: loop */
t3=((C_word*)((C_word*)t0)[6])[1];
f_3492(t3,((C_word*)t0)[7],((C_word*)t0)[8],t2);}}

/* k3598 in k3543 in k3607 in k3614 in k3509 in loop in k3488 in k3481 in k3478 in k3686 in k3683 in k3680 in k3677 in k3674 in k3671 in find-files in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 in ... */
static void C_ccall f_3600(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:480: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_3492(t2,((C_word*)t0)[3],((C_word*)t0)[4],t1);}

/* k3607 in k3614 in k3509 in loop in k3488 in k3481 in k3478 in k3686 in k3683 in k3680 in k3677 in k3674 in k3671 in find-files in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3609(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3609,2,t0,t1);}
t2=(C_truep(t1)?C_i_not(((C_word*)t0)[2]):C_SCHEME_FALSE);
if(C_truep(t2)){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3533,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3536,a[2]=((C_word*)t0)[6],a[3]=t3,a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[3],a[7]=((C_word*)t0)[4],a[8]=((C_word*)t0)[5],tmp=(C_word)a,a+=9,tmp);
/* posix-common.scm:474: pproc */
t5=((C_word*)t0)[9];
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,((C_word*)t0)[7]);}
else{
t3=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_3545,a[2]=((C_word*)t0)[10],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[11],tmp=(C_word)a,a+=11,tmp);
/* posix-common.scm:475: lproc */
t4=((C_word*)t0)[12];
((C_proc3)C_fast_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[7]);}}

/* k3843 in k3837 in k3833 in local-time->seconds in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3845(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
/* posix-common.scm:538: ##sys#error */
t2=*((C_word*)lf[41]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[106],lf[107],((C_word*)t0)[3]);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[4]);}}

/* a8722 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8723(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_8723,3,t0,t1,t2);}
t3=C_i_check_exact_2(t2,lf[97]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_umask(t2));}

/* a6536 in k6474 in k6465 in a6462 in k6171 in k6165 in custom-input-port in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in ... */
static void C_ccall f_6537(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_6537,5,t0,t1,t2,t3,t4);}
if(C_truep(t4)){
t5=C_slot(((C_word*)t0)[2],C_fix(4));
t6=C_fixnum_plus(t5,C_fix(1));
t7=C_i_set_i_slot(((C_word*)t0)[2],C_fix(4),t6);
t8=C_i_set_i_slot(((C_word*)t0)[2],C_fix(5),C_fix(0));
t9=C_mutate2(((C_word *)((C_word*)t0)[3])+1,t2);
t10=t1;
((C_proc2)(void*)(*((C_word*)t10+1)))(2,t10,t3);}
else{
t5=C_slot(((C_word*)t0)[2],C_fix(5));
t6=C_block_size(t3);
t7=C_fixnum_plus(t5,t6);
t8=C_i_set_i_slot(((C_word*)t0)[2],C_fix(5),t7);
t9=C_mutate2(((C_word *)((C_word*)t0)[3])+1,t2);
t10=t1;
((C_proc2)(void*)(*((C_word*)t10+1)))(2,t10,t3);}}

/* a8728 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8729(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_8729,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8733,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:247: ##sys#stat */
f_2686(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[16]);}

/* k3575 in k3568 in a3561 in k3543 in k3607 in k3614 in k3509 in loop in k3488 in k3481 in k3478 in k3686 in k3683 in k3680 in k3677 in k3674 in k3671 in find-files in k2748 in k2654 in k2651 in k2648 in ... */
static void C_ccall f_3577(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
/* posix-common.scm:479: action */
t2=((C_word*)t0)[2];
((C_proc4)C_fast_retrieve_proc(t2))(4,t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5]);}
else{
t2=((C_word*)t0)[5];
/* posix-common.scm:478: loop */
t3=((C_word*)((C_word*)t0)[6])[1];
f_3492(t3,((C_word*)t0)[7],((C_word*)t0)[8],t2);}}

/* k8753 in a8734 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8755(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(C_fixnum_lessp(t1,C_fix(0)))){
/* posix-common.scm:253: posix-error */
t2=lf[0];
f_2668(7,t2,((C_word*)t0)[2],lf[8],lf[463],lf[464],((C_word*)t0)[3],((C_word*)t0)[4]);}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* k3568 in a3561 in k3543 in k3607 in k3614 in k3509 in loop in k3488 in k3481 in k3478 in k3686 in k3683 in k3680 in k3677 in k3674 in k3671 in find-files in k2748 in k2654 in k2651 in k2648 in k2645 in ... */
static void C_ccall f_3570(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3570,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3574,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3577,a[2]=((C_word*)t0)[4],a[3]=t3,a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[2],a[7]=((C_word*)t0)[3],a[8]=t2,tmp=(C_word)a,a+=9,tmp);
/* posix-common.scm:479: pproc */
t5=((C_word*)t0)[7];
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,((C_word*)t0)[5]);}

/* k3572 in k3568 in a3561 in k3543 in k3607 in k3614 in k3509 in loop in k3488 in k3481 in k3478 in k3686 in k3683 in k3680 in k3677 in k3674 in k3671 in find-files in k2748 in k2654 in k2651 in k2648 in ... */
static void C_ccall f_3574(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:478: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_3492(t2,((C_word*)t0)[3],((C_word*)t0)[4],t1);}

/* k7269 in k7263 in k7260 in k7257 in map-file-to-memory in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7271(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7271,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_i_record3(&a,3,lf[386],((C_word*)t0)[3],((C_word*)t0)[4]));}

/* k7263 in k7260 in k7257 in map-file-to-memory in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7265(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word ab[21],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7265,2,t0,t1);}
t2=((C_word*)t0)[2];
t3=((C_word*)t0)[3];
t4=((C_word*)t0)[4];
t5=((C_word*)t0)[5];
t6=C_a_i_bytevector(&a,1,C_fix(3));
t7=(C_truep(((C_word*)t0)[6])?C_i_foreign_pointer_argumentp(((C_word*)t0)[6]):C_SCHEME_FALSE);
t8=C_i_foreign_integer_argumentp(t2);
t9=C_i_foreign_fixnum_argumentp(t3);
t10=C_i_foreign_fixnum_argumentp(t4);
t11=C_i_foreign_fixnum_argumentp(t5);
t12=C_i_foreign_integer_argumentp(((C_word*)t0)[7]);
t13=stub1667(t6,t7,t8,t9,t10,t11,t12);
t14=t13;
t15=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7271,a[2]=((C_word*)t0)[8],a[3]=t14,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t16=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_7284,a[2]=t15,a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[5],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=t14,tmp=(C_word)a,a+=11,tmp);
/* posixunix.scm:1515: ##sys#pointer->address */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[388]+1)))(3,*((C_word*)lf[388]+1),t16,t14);}

/* k7260 in k7257 in map-file-to-memory in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_7262(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7262,NULL,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_7265,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=t2,a[8]=((C_word*)t0)[7],tmp=(C_word)a,a+=9,tmp);
if(C_truep(C_blockp(((C_word*)t0)[6]))){
if(C_truep(C_specialp(((C_word*)t0)[6]))){
t4=t3;
f_7265(2,t4,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm:1513: ##sys#signal-hook */
t4=*((C_word*)lf[1]+1);
((C_proc6)(void*)(*((C_word*)t4+1)))(6,t4,t3,lf[13],lf[385],lf[389],((C_word*)t0)[6]);}}
else{
/* posixunix.scm:1513: ##sys#signal-hook */
t4=*((C_word*)lf[1]+1);
((C_proc6)(void*)(*((C_word*)t4+1)))(6,t4,t3,lf[13],lf[385],lf[389],((C_word*)t0)[6]);}}

/* a5203 in a5197 in k5186 in with-input-from-pipe in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5204(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_5204r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_5204r(t0,t1,t2);}}

static void C_ccall f_5204r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5208,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:769: close-input-pipe */
t4=*((C_word*)lf[205]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k5206 in a5203 in a5197 in k5186 in with-input-from-pipe in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5208(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply_values(3,0,((C_word*)t0)[2],((C_word*)t0)[3]);}

/* k7282 in k7263 in k7260 in k7257 in map-file-to-memory in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7284(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7284,2,t0,t1);}
t2=C_eqp(C_fix(-1),t1);
if(C_truep(t2)){
/* posixunix.scm:1516: posix-error */
t3=lf[0];
f_2668(11,t3,((C_word*)t0)[2],lf[8],lf[385],lf[387],((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)t0)[6],((C_word*)t0)[7],((C_word*)t0)[8]);}
else{
t3=((C_word*)t0)[9];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_a_i_record3(&a,3,lf[386],((C_word*)t0)[10],((C_word*)t0)[4]));}}

/* k4896 in k4870 in loop in k4861 in k4851 in k4842 in create-directory in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_4898(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:677: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_4865(t2,((C_word*)t0)[3],t1);}

/* k4889 in k4873 in k4870 in loop in k4861 in k4851 in k4842 in create-directory in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_4891(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
t2=C_mkdir(t1);
t3=C_eqp(C_fix(0),t2);
if(C_truep(t3)){
t4=C_SCHEME_UNDEFINED;
t5=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
/* posixunix.scm:665: posix-error */
t4=lf[0];
f_2668(6,t4,((C_word*)t0)[2],lf[8],lf[191],lf[192],((C_word*)t0)[3]);}}

/* file-control in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_4197(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+0)){
C_save_and_reclaim((void*)tr4r,(void*)f_4197r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_4197r(t0,t1,t2,t3,t4);}}

static void C_ccall f_4197r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
t5=C_i_nullp(t4);
t6=(C_truep(t5)?C_fix(0):C_i_car(t4));
t7=C_i_check_exact_2(t2,lf[162]);
t8=C_i_check_exact_2(t3,lf[162]);
t9=t2;
t10=t3;
t11=C_i_foreign_fixnum_argumentp(t9);
t12=C_i_foreign_fixnum_argumentp(t10);
t13=C_i_foreign_integer_argumentp(t6);
t14=stub701(C_SCHEME_UNDEFINED,t11,t12,t13);
t15=C_eqp(t14,C_fix(-1));
if(C_truep(t15)){
/* posixunix.scm:504: posix-error */
t16=lf[0];
f_2668(7,t16,t1,lf[8],lf[162],lf[163],t2,t3);}
else{
t16=t1;
((C_proc2)(void*)(*((C_word*)t16+1)))(2,t16,t14);}}

/* a8601 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8602(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_8602,3,t0,t1,t2);}
t3=C_setuid(t2);
if(C_truep(C_fixnum_lessp(t3,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8612,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:925: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[5]+1)))(2,*((C_word*)lf[5]+1),t4);}
else{
t4=C_SCHEME_UNDEFINED;
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}}

/* k7257 in map-file-to-memory in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7259(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7259,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_7262,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t2,a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
if(C_truep(C_i_pairp(((C_word*)t0)[7]))){
t4=((C_word*)t0)[7];
t5=t3;
f_7262(t5,C_u_i_car(t4));}
else{
t4=t3;
f_7262(t4,C_fix(0));}}

/* map-file-to-memory in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7255(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,...){
C_word tmp;
C_word t7;
va_list v;
C_word *a,c2=c;
C_save_rest(t6,c2,7);
if(c<7) C_bad_min_argc_2(c,7,t0);
if(!C_demand(c*C_SIZEOF_PAIR+8)){
C_save_and_reclaim((void*)tr7r,(void*)f_7255r,7,t0,t1,t2,t3,t4,t5,t6);}
else{
a=C_alloc((c-7)*3);
t7=C_restore_rest(a,C_rest_count(0));
f_7255r(t0,t1,t2,t3,t4,t5,t6,t7);}}

static void C_ccall f_7255r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(8);
t8=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_7259,a[2]=t3,a[3]=t4,a[4]=t5,a[5]=t6,a[6]=t1,a[7]=t7,tmp=(C_word)a,a+=8,tmp);
t9=t2;
if(C_truep(t9)){
t10=t8;
f_7259(2,t10,t2);}
else{
/* posixunix.scm:1510: ##sys#null-pointer */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[390]+1)))(2,*((C_word*)lf[390]+1),t8);}}

/* k4959 in change-directory in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_4961(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4961,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4964,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=C_chdir(t1);
t4=C_eqp(C_fix(0),t3);
if(C_truep(t4)){
t5=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,((C_word*)t0)[3]);}
else{
/* posixunix.scm:687: posix-error */
t5=lf[0];
f_2668(6,t5,t2,lf[8],lf[62],lf[195],((C_word*)t0)[3]);}}

/* k4962 in k4959 in change-directory in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_4964(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[3]);}

/* k4632 in k4408 in k4400 in k4397 in k4394 in file-select in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_4634(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4634,NULL,2,t0,t1);}
t2=(C_truep(((C_word*)t0)[2])?C_i_foreign_block_argumentp(((C_word*)t0)[2]):C_SCHEME_FALSE);
t3=C_i_foreign_fixnum_argumentp(((C_word*)t0)[3]);
t4=C_i_foreign_fixnum_argumentp(t1);
t5=stub829(C_SCHEME_UNDEFINED,t2,t3,t4);
if(C_truep(C_fixnum_lessp(t5,C_fix(0)))){
/* posixunix.scm:593: posix-error */
t6=lf[0];
f_2668(7,t6,((C_word*)t0)[4],lf[8],lf[176],lf[177],((C_word*)t0)[5],((C_word*)t0)[6]);}
else{
t6=C_eqp(t5,C_fix(0));
if(C_truep(t6)){
t7=C_i_pairp(((C_word*)t0)[5]);
t8=(C_truep(t7)?C_SCHEME_END_OF_LIST:C_SCHEME_FALSE);
if(C_truep(C_i_pairp(((C_word*)t0)[6]))){
/* posixunix.scm:594: values */
C_values(4,0,((C_word*)t0)[4],t8,C_SCHEME_END_OF_LIST);}
else{
/* posixunix.scm:594: values */
C_values(4,0,((C_word*)t0)[4],t8,C_SCHEME_FALSE);}}
else{
t7=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4474,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[2],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],tmp=(C_word)a,a+=8,tmp);
t8=C_SCHEME_UNDEFINED;
t9=(*a=C_VECTOR_TYPE|1,a[1]=t8,tmp=(C_word)a,a+=2,tmp);
t10=C_set_block_item(t9,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4573,a[2]=t9,a[3]=((C_word*)t0)[2],a[4]=((C_word)li78),tmp=(C_word)a,a+=5,tmp));
t11=((C_word*)t9)[1];
f_4573(t11,t7,C_fix(0),C_SCHEME_END_OF_LIST,((C_word*)t0)[9]);}}}

/* k6443 in loop in k6393 in a6386 in k6171 in k6165 in custom-input-port in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in ... */
static void C_ccall f_6445(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_eqp(C_fix(0),((C_word*)((C_word*)t0)[2])[1]);
if(C_truep(t2)){
t3=((C_word*)t0)[3];
t4=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
/* posixunix.scm:1302: loop */
t3=((C_word*)((C_word*)t0)[5])[1];
f_6397(t3,((C_word*)t0)[4],((C_word*)t0)[6],((C_word*)t0)[3],((C_word*)t0)[7]);}}

/* k5702 in doloop1226 in k5681 in set-groups! in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5704(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1047: ##sys#error */
t2=*((C_word*)lf[41]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[270],lf[271],((C_word*)t0)[3]);}

/* ##sys#file-nonblocking! in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_4133(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4133,3,t0,t1,t2);}
t3=C_i_foreign_fixnum_argumentp(t2);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,stub652(C_SCHEME_UNDEFINED,t3));}

/* k4973 in change-directory in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_4975(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:685: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),((C_word*)t0)[2],t1,lf[62]);}

/* change-directory* in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_4977(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4977,3,t0,t1,t2);}
t3=C_i_check_exact_2(t2,lf[196]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4984,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t5=C_fchdir(t2);
t6=C_eqp(C_fix(0),t5);
if(C_truep(t6)){
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t2);}
else{
/* posixunix.scm:693: posix-error */
t7=lf[0];
f_2668(6,t7,t4,lf[8],lf[196],lf[197],t2);}}

/* ##sys#file-select-one in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_4140(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4140,3,t0,t1,t2);}
t3=C_i_foreign_fixnum_argumentp(t2);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,stub657(C_SCHEME_UNDEFINED,t3));}

/* k4982 in change-directory* in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_4984(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[3]);}

/* a6462 in k6171 in k6165 in custom-input-port in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_6463(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word ab[9],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_6463,4,t0,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_6467,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=t3,a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[5],a[8]=t2,tmp=(C_word)a,a+=9,tmp);
if(C_truep(C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]))){
/* posixunix.scm:1305: fetch */
t5=((C_word*)t0)[5];
f_6211(t5,t4);}
else{
t5=t4;
f_6467(2,t5,C_SCHEME_UNDEFINED);}}

/* change-file-mode in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5818(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[8],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_5818,4,t0,t1,t2,t3);}
t4=C_i_check_string_2(t2,lf[314]);
t5=C_i_check_exact_2(t3,lf[314]);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5839,a[2]=t3,a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5843,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1111: ##sys#expand-home-path */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(3,*((C_word*)lf[12]+1),t7,t2);}

/* k6465 in a6462 in k6171 in k6165 in custom-input-port in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_6467(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6467,2,t0,t1);}
if(C_truep(C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]))){
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_FILE);}
else{
t2=((C_word*)t0)[5];
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6476,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[4],tmp=(C_word)a,a+=8,tmp);
if(C_truep(t2)){
t4=t3;
f_6476(t4,t2);}
else{
t4=C_fudge(C_fix(21));
t5=t3;
f_6476(t5,C_fixnum_difference(t4,((C_word*)((C_word*)t0)[2])[1]));}}}

/* a8647 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8648(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_8648,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8652,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8664,a[2]=t2,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:646: port? */
t5=*((C_word*)lf[187]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k7213 in fifo? in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7215(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1473: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),((C_word*)t0)[2],t1,lf[34]);}

/* a5212 in k5186 in with-input-from-pipe in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5213(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5213,2,t0,t1);}
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,*((C_word*)lf[212]+1));
t3=C_mutate2((C_word*)lf[212]+1 /* (set! ##sys#standard-input ...) */,((C_word*)((C_word*)t0)[3])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}

/* with-output-to-pipe in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5218(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr4r,(void*)f_5218r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_5218r(t0,t1,t2,t3,t4);}}

static void C_ccall f_5218r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5222,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
C_apply(5,0,t5,*((C_word*)lf[204]+1),t2,t4);}

/* k5837 in change-file-mode in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5839(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_chmod(t1,((C_word*)t0)[2]);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm:1112: posix-error */
t3=lf[0];
f_2668(7,t3,((C_word*)t0)[3],lf[8],lf[314],lf[315],((C_word*)t0)[4],((C_word*)t0)[2]);}
else{
t3=C_SCHEME_UNDEFINED;
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* a6480 in k6474 in k6465 in a6462 in k6171 in k6165 in custom-input-port in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in ... */
static void C_ccall f_6481(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6481,2,t0,t1);}
t2=C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]);
t3=C_i_fixnum_min(((C_word*)((C_word*)t0)[4])[1],t2);
t4=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6491,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word)li148),tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm:1310: ##sys#scan-buffer-line */
((C_proc6)C_fast_retrieve_proc(*((C_word*)lf[352]+1)))(6,*((C_word*)lf[352]+1),t1,((C_word*)t0)[5],t3,((C_word*)((C_word*)t0)[2])[1],t4);}

/* k3178 in k3172 in g271 in k3161 in k3155 in delete-directory in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3180(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
/* posix-common.scm:392: g281 */
f_3137(((C_word*)t0)[3],((C_word*)t0)[4]);}
else{
t2=*((C_word*)lf[68]+1);
t3=*((C_word*)lf[68]+1);
/* posix-common.scm:392: g281 */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[68]+1)))(3,*((C_word*)lf[68]+1),((C_word*)t0)[3],((C_word*)t0)[4]);}}

/* k3184 in k3161 in k3155 in delete-directory in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3186(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:398: rmdir */
f_3137(((C_word*)t0)[3],((C_word*)t0)[4]);}

/* k5220 in with-output-to-pipe in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5222(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5222,2,t0,t1);}
t2=t1;
t3=t2;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_SCHEME_FALSE;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5227,a[2]=t6,a[3]=t4,a[4]=((C_word)li103),tmp=(C_word)a,a+=5,tmp);
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5232,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word)li105),tmp=(C_word)a,a+=5,tmp);
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5247,a[2]=t4,a[3]=t6,a[4]=((C_word)li106),tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:772: ##sys#dynamic-wind */
t10=*((C_word*)lf[87]+1);
((C_proc5)(void*)(*((C_word*)t10+1)))(5,t10,((C_word*)t0)[3],t7,t8,t9);}

/* a5226 in k5220 in with-output-to-pipe in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5227(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5227,2,t0,t1);}
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,*((C_word*)lf[214]+1));
t3=C_mutate2((C_word*)lf[214]+1 /* (set! ##sys#standard-output ...) */,((C_word*)((C_word*)t0)[3])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}

/* k4934 in k4851 in k4842 in create-directory in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_4936(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
t2=C_mkdir(t1);
t3=C_eqp(C_fix(0),t2);
if(C_truep(t3)){
t4=C_SCHEME_UNDEFINED;
t5=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
/* posixunix.scm:665: posix-error */
t4=lf[0];
f_2668(6,t4,((C_word*)t0)[2],lf[8],lf[191],lf[192],((C_word*)t0)[3]);}}

/* loop in a8617 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_8624(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word *a;
loop:
a=C_alloc(3);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_8624,NULL,4,t0,t1,t2,t3);}
if(C_truep(C_i_nullp(t2))){
t4=t3;
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=C_i_car(t2);
t5=t2;
t6=C_u_i_cdr(t5);
if(C_truep(C_sigismember(t4))){
t7=C_a_i_cons(&a,2,t4,t3);
/* posixunix.scm:876: loop */
t11=t1;
t12=t6;
t13=t7;
t1=t11;
t2=t12;
t3=t13;
goto loop;}
else{
t7=t3;
/* posixunix.scm:876: loop */
t11=t1;
t12=t6;
t13=t7;
t1=t11;
t2=t12;
t3=t13;
goto loop;}}}

/* k6474 in k6465 in a6462 in k6171 in k6165 in custom-input-port in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 in ... */
static void C_fcall f_6476(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6476,NULL,2,t0,t1);}
t2=t1;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6481,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word)li149),tmp=(C_word)a,a+=8,tmp);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6537,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[2],a[4]=((C_word)li150),tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1308: ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[7],t4,t5);}

/* k5841 in change-file-mode in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5843(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1111: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),((C_word*)t0)[2],t1,lf[314]);}

/* change-file-owner in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5845(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[9],*a=ab;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_5845,5,t0,t1,t2,t3,t4);}
t5=C_i_check_string_2(t2,lf[316]);
t6=C_i_check_exact_2(t3,lf[316]);
t7=C_i_check_exact_2(t4,lf[316]);
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5869,a[2]=t3,a[3]=t4,a[4]=t1,a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5873,a[2]=t8,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1119: ##sys#expand-home-path */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(3,*((C_word*)lf[12]+1),t9,t2);}

/* posix-error in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_2668(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...){
C_word tmp;
C_word t5;
va_list v;
C_word *a,c2=c;
C_save_rest(t4,c2,5);
if(c<5) C_bad_min_argc_2(c,5,t0);
if(!C_demand(c*C_SIZEOF_PAIR+7)){
C_save_and_reclaim((void*)tr5r,(void*)f_2668r,5,t0,t1,t2,t3,t4);}
else{
a=C_alloc((c-5)*3);
t5=C_restore_rest(a,C_rest_count(0));
f_2668r(t0,t1,t2,t3,t4,t5);}}

static void C_ccall f_2668r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word *a=C_alloc(7);
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2672,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t5,a[6]=t4,tmp=(C_word)a,a+=7,tmp);
/* posix-common.scm:178: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[5]+1)))(2,*((C_word*)lf[5]+1),t6);}

/* for-each-loop270 in k3161 in k3155 in delete-directory in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_3191(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3191,NULL,3,t0,t1,t2);}
if(C_truep(C_i_pairp(t2))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3201,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=C_slot(t2,C_fix(0));
/* posix-common.scm:387: g271 */
t5=((C_word*)t0)[3];
f_3164(t5,t3,t4);}
else{
t3=C_SCHEME_UNDEFINED;
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k2723 in stat in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_2725(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:221: ##sys#platform-fixup-pathname */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[11]+1)))(3,*((C_word*)lf[11]+1),((C_word*)t0)[2],t1);}

/* k8610 in a8601 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8612(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:926: ##sys#error */
t2=*((C_word*)lf[41]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[451],lf[457],((C_word*)t0)[3]);}

/* k2719 in stat in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_2721(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:220: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),((C_word*)t0)[2],t1,((C_word*)t0)[3]);}

/* a8617 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8618(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8618,2,t0,t1);}
t2=C_sigprocmask_get(C_fix(0));
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8624,a[2]=t4,a[3]=((C_word)li239),tmp=(C_word)a,a+=4,tmp));
t6=((C_word*)t4)[1];
f_8624(t6,t1,*((C_word*)lf[244]+1),C_SCHEME_END_OF_LIST);}

/* k2688 in stat in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_2690(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(C_fixnum_lessp(t1,C_fix(0)))){
if(C_truep(((C_word*)t0)[2])){
/* posix-common.scm:232: posix-error */
t2=lf[0];
f_2668(6,t2,((C_word*)t0)[3],lf[8],((C_word*)t0)[4],lf[9],((C_word*)t0)[5]);}
else{
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}
else{
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_TRUE);}}

/* change-directory in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_4954(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4954,3,t0,t1,t2);}
t3=C_i_check_string_2(t2,lf[62]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4961,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4975,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:685: ##sys#expand-home-path */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(3,*((C_word*)lf[12]+1),t5,t2);}

/* a6490 in a6480 in k6474 in k6465 in a6462 in k6171 in k6165 in custom-input-port in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in ... */
static void C_ccall f_6491(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[7],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6491,3,t0,t1,t2);}
t3=C_fixnum_difference(t2,((C_word*)((C_word*)t0)[2])[1]);
if(C_truep(C_fixnum_greater_or_equal_p(t3,((C_word*)((C_word*)t0)[3])[1]))){
/* posixunix.scm:1317: values */
C_values(5,0,t1,C_SCHEME_FALSE,t2,C_SCHEME_FALSE);}
else{
t4=C_fixnum_difference(((C_word*)((C_word*)t0)[3])[1],t3);
t5=C_mutate2(((C_word *)((C_word*)t0)[3])+1,t4);
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6511,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[3],a[5]=t1,a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm:1320: fetch */
t7=((C_word*)t0)[6];
f_6211(t7,t6);}}

/* k2712 in stat in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_2714(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
f_2690(2,t2,(C_truep(((C_word*)t0)[3])?C_lstat(t1):C_stat(t1)));}

/* k5867 in change-file-owner in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5869(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_chown(t1,((C_word*)t0)[2],((C_word*)t0)[3]);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm:1120: posix-error */
t3=lf[0];
f_2668(8,t3,((C_word*)t0)[4],lf[8],lf[316],lf[317],((C_word*)t0)[5],((C_word*)t0)[2],((C_word*)t0)[3]);}
else{
t3=C_SCHEME_UNDEFINED;
t4=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* a8688 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8689(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_8689,3,t0,t1,t2);}
t3=C_i_check_exact_2(t2,lf[118]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_slot(*((C_word*)lf[117]+1),t2));}

/* k3139 in rmdir in delete-directory in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3141(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
t2=C_rmdir(t1);
t3=C_eqp(C_fix(0),t2);
if(C_truep(t3)){
t4=C_SCHEME_UNDEFINED;
t5=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
/* posix-common.scm:383: posix-error */
t4=lf[0];
f_2668(6,t4,((C_word*)t0)[2],lf[8],lf[66],lf[67],((C_word*)t0)[3]);}}

/* k5871 in change-file-owner in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5873(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1119: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),((C_word*)t0)[2],t1,lf[316]);}

/* check in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_5875(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5875,NULL,4,t1,t2,t3,t4);}
t5=C_i_check_string_2(t2,t4);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5893,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5897,a[2]=t6,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1129: ##sys#expand-home-path */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(3,*((C_word*)lf[12]+1),t7,t2);}

/* k2670 in posix-error in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_2672(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2672,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2679,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2683,a[2]=t2,a[3]=((C_word*)t0)[6],tmp=(C_word)a,a+=4,tmp);
t4=C_a_i_bytevector(&a,1,C_fix(3));
t5=C_i_foreign_fixnum_argumentp(t1);
t6=stub67(t4,t5);
/* posix-common.scm:175: ##sys#peek-c-string */
t7=*((C_word*)lf[4]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t3,t6,C_fix(0));}

/* k2677 in k2670 in posix-error in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_2679(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply(7,0,((C_word*)t0)[2],*((C_word*)lf[1]+1),((C_word*)t0)[3],((C_word*)t0)[4],t1,((C_word*)t0)[5]);}

/* a3701 in k3674 in k3671 in find-files in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3702(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3702,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_LIST);}

/* a3704 in k3671 in find-files in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3705(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3705,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3707,a[2]=((C_word)li46),tmp=(C_word)a,a+=3,tmp));}

/* f_3707 in a3704 in k3671 in find-files in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3707(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word ab[3],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_3707,4,t0,t1,t2,t3);}
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_a_i_cons(&a,2,t2,t3));}

/* f_3715 in a3712 in find-files in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3715(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3715,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_TRUE);}

/* a3712 in find-files in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3713(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3713,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3715,a[2]=((C_word)li48),tmp=(C_word)a,a+=3,tmp));}

/* k3155 in delete-directory in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3157(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3157,2,t0,t1);}
t2=t1;
if(C_truep(((C_word*)t0)[2])){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3163,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:387: find-files */
t4=*((C_word*)lf[70]+1);
((C_proc7)(void*)(*((C_word*)t4+1)))(7,t4,t3,t2,lf[71],C_SCHEME_TRUE,lf[72],C_SCHEME_FALSE);}
else{
/* posix-common.scm:399: rmdir */
f_3137(((C_word*)t0)[4],t2);}}

/* k5883 in k5891 in check in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5885(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[3]);}

/* k8662 in a8647 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8664(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_truep(t1)){
t2=C_slot(((C_word*)t0)[2],C_fix(7));
t3=C_eqp(t2,lf[51]);
if(C_truep(t3)){
t4=C_ftell(((C_word*)t0)[2]);
t5=((C_word*)t0)[3];
f_8652(2,t5,t4);}
else{
t4=((C_word*)t0)[3];
f_8652(2,t4,C_fix(-1));}}
else{
if(C_truep(C_fixnump(((C_word*)t0)[2]))){
t2=C_lseek(((C_word*)t0)[2],C_fix(0),C_fix((C_word)SEEK_CUR));
t3=((C_word*)t0)[3];
f_8652(2,t3,t2);}
else{
/* posixunix.scm:653: ##sys#signal-hook */
t2=*((C_word*)lf[1]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[13],lf[190],lf[460],((C_word*)t0)[2]);}}}

/* file-read-access? in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5899(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5899,3,t0,t1,t2);}
/* posixunix.scm:1132: check */
f_5875(t1,t2,C_fix((C_word)R_OK),lf[318]);}

/* k5895 in check in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5897(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1129: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),((C_word*)t0)[2],t1,((C_word*)t0)[3]);}

/* k5891 in check in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5893(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5893,2,t0,t1);}
t2=C_test_access(t1,((C_word*)t0)[2]);
t3=C_eqp(C_fix(0),t2);
t4=t3;
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5885,a[2]=((C_word*)t0)[3],a[3]=t4,tmp=(C_word)a,a+=4,tmp);
if(C_truep(t4)){
t6=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t4);}
else{
/* posixunix.scm:1130: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[5]+1)))(2,*((C_word*)lf[5]+1),t5);}}

/* a4906 in k4851 in k4842 in create-directory in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_4907(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4907,2,t0,t1);}
/* posixunix.scm:674: decompose-pathname */
t2=*((C_word*)lf[76]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,((C_word*)t0)[2]);}

/* check-time-vector in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_3722(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3722,NULL,3,t1,t2,t3);}
t4=C_i_check_vector_2(t3,t2);
t5=C_block_size(t3);
if(C_truep(C_fixnum_lessp(t5,C_fix(10)))){
/* posix-common.scm:513: ##sys#error */
t6=*((C_word*)lf[41]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t1,t2,lf[99],t3);}
else{
t6=C_SCHEME_UNDEFINED;
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}}

/* g271 in k3161 in k3155 in delete-directory in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_3164(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3164,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3174,a[2]=t1,a[3]=t2,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:393: symbolic-link? */
t4=*((C_word*)lf[31]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,t2);}

/* k3161 in k3155 in delete-directory in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3163(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[16],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3163,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3164,a[2]=((C_word*)t0)[2],a[3]=((C_word)li24),tmp=(C_word)a,a+=4,tmp);
t3=C_i_check_list_2(t1,lf[69]);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3186,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t5=C_SCHEME_UNDEFINED;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_set_block_item(t6,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3191,a[2]=t6,a[3]=t2,a[4]=((C_word)li25),tmp=(C_word)a,a+=5,tmp));
t8=((C_word*)t6)[1];
f_3191(t8,t4,t1);}

/* k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3720(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word ab[38],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3720,2,t0,t1);}
t2=C_mutate2((C_word*)lf[97]+1 /* (set! file-creation-mode ...) */,t1);
t3=C_mutate2(&lf[98] /* (set! check-time-vector ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3722,a[2]=((C_word)li51),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate2((C_word*)lf[100]+1 /* (set! seconds->local-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3741,a[2]=((C_word)li52),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate2((C_word*)lf[103]+1 /* (set! seconds->utc-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3762,a[2]=((C_word)li53),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate2((C_word*)lf[104]+1 /* (set! seconds->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3793,a[2]=((C_word)li54),tmp=(C_word)a,a+=3,tmp));
t7=C_fix((C_word)sizeof(struct tm));
t8=C_mutate2((C_word*)lf[106]+1 /* (set! local-time->seconds ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3831,a[2]=t7,a[3]=((C_word)li55),tmp=(C_word)a,a+=4,tmp));
t9=C_fix((C_word)sizeof(struct tm));
t10=C_mutate2((C_word*)lf[110]+1 /* (set! time->string ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3876,a[2]=t9,a[3]=((C_word)li56),tmp=(C_word)a,a+=4,tmp));
t11=C_mutate2((C_word*)lf[113]+1 /* (set! setenv ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3938,a[2]=((C_word)li57),tmp=(C_word)a,a+=3,tmp));
t12=C_mutate2((C_word*)lf[114]+1 /* (set! unsetenv ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3955,a[2]=((C_word)li58),tmp=(C_word)a,a+=3,tmp));
t13=C_mutate2((C_word*)lf[115]+1 /* (set! get-environment-variables ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3975,a[2]=((C_word)li61),tmp=(C_word)a,a+=3,tmp));
t14=C_mutate2((C_word*)lf[116]+1 /* (set! set-signal-handler! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4041,a[2]=((C_word)li62),tmp=(C_word)a,a+=3,tmp));
t15=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4056,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t16=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8689,a[2]=((C_word)li242),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:595: getter-with-setter */
t17=*((C_word*)lf[446]+1);
((C_proc4)(void*)(*((C_word*)t17+1)))(4,t17,t15,t16,*((C_word*)lf[116]+1));}

/* k4903 in loop in k4861 in k4851 in k4842 in create-directory in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_4905(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
f_4872(t2,C_i_not(t1));}

/* k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_2653(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2653,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2656,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_ports_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k8650 in a8647 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8652(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8652,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8655,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_lessp(t2,C_fix(0)))){
/* posixunix.scm:655: posix-error */
t4=lf[0];
f_2668(6,t4,t3,lf[8],lf[190],lf[459],((C_word*)t0)[3]);}
else{
t4=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t2);}}

/* k8653 in k8650 in a8647 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8655(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[3]);}

/* k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_2656(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[18],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2656,2,t0,t1);}
t2=C_mutate2(&lf[0] /* (set! posix-error ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2668,a[2]=((C_word)li0),tmp=(C_word)a,a+=3,tmp));
t3=C_mutate2((C_word*)lf[6]+1 /* (set! ##sys#posix-error ...) */,lf[0]);
t4=C_mutate2(&lf[7] /* (set! ##sys#stat ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2686,a[2]=((C_word)li1),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate2((C_word*)lf[15]+1 /* (set! file-stat ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2730,a[2]=((C_word)li2),tmp=(C_word)a,a+=3,tmp));
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2750,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8729,a[2]=((C_word)li245),tmp=(C_word)a,a+=3,tmp);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8735,a[2]=((C_word)li246),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:245: getter-with-setter */
t9=*((C_word*)lf[446]+1);
((C_proc5)(void*)(*((C_word*)t9+1)))(5,t9,t6,t7,t8,lf[465]);}

/* k2648 in k2645 in k2642 */
static void C_ccall f_2650(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2650,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2653,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_files_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* a4912 in k4851 in k4842 in create-directory in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_4913(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_4913,5,t0,t1,t2,t3,t4);}
if(C_truep(t3)){
/* posixunix.scm:675: make-pathname */
t5=*((C_word*)lf[77]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t1,t2,t3,t4);}
else{
t5=t2;
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}}

/* k3172 in g271 in k3161 in k3155 in delete-directory in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3174(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3174,2,t0,t1);}
if(C_truep(t1)){
t2=*((C_word*)lf[68]+1);
t3=*((C_word*)lf[68]+1);
/* posix-common.scm:392: g281 */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[68]+1)))(3,*((C_word*)lf[68]+1),((C_word*)t0)[2],((C_word*)t0)[3]);}
else{
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3180,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:394: directory? */
t3=*((C_word*)lf[36]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[3]);}}

/* k2681 in k2670 in posix-error in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_2683(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:179: string-append */
t2=*((C_word*)lf[2]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],((C_word*)t0)[3],lf[3],t1);}

/* ##sys#stat in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_2686(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[17],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2686,NULL,5,t1,t2,t3,t4,t5);}
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2690,a[2]=t4,a[3]=t1,a[4]=t5,a[5]=t2,tmp=(C_word)a,a+=6,tmp);
if(C_truep(C_fixnump(t2))){
t7=t6;
f_2690(2,t7,C_fstat(t2));}
else{
if(C_truep(C_i_stringp(t2))){
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2714,a[2]=t6,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2721,a[2]=t7,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2725,a[2]=t8,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:222: ##sys#expand-home-path */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(3,*((C_word*)lf[12]+1),t9,t2);}
else{
/* posix-common.scm:228: ##sys#signal-hook */
t7=*((C_word*)lf[1]+1);
((C_proc6)(void*)(*((C_word*)t7+1)))(6,t7,t6,lf[13],t5,lf[14],t2);}}}

/* k3743 in seconds->local-time in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3745(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_i_check_number_2(t1,lf[100]);
/* posix-common.scm:517: ##sys#decode-seconds */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[101]+1)))(4,*((C_word*)lf[101]+1),((C_word*)t0)[2],t1,C_SCHEME_FALSE);}

/* seconds->local-time in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3741(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr2r,(void*)f_3741r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3741r(t0,t1,t2);}}

static void C_ccall f_3741r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3745,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_i_nullp(t2))){
/* posix-common.scm:515: current-seconds */
t4=*((C_word*)lf[102]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t4=C_i_car(t2);
t5=C_i_check_number_2(t4,lf[100]);
/* posix-common.scm:517: ##sys#decode-seconds */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[101]+1)))(4,*((C_word*)lf[101]+1),t1,t4,C_SCHEME_FALSE);}}

/* k3108 in current-directory in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3110(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3110,2,t0,t1);}
t2=t1;
t3=C_curdir(t2);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3113,a[2]=t3,a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:371: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[5]+1)))(2,*((C_word*)lf[5]+1),t4);}

/* k3111 in k3108 in current-directory in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3113(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(((C_word*)t0)[2])){
/* posix-common.scm:373: ##sys#substring */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[63]+1)))(5,*((C_word*)lf[63]+1),((C_word*)t0)[3],((C_word*)t0)[4],C_fix(0),((C_word*)t0)[2]);}
else{
/* posix-common.scm:374: ##sys#signal-hook */
t2=*((C_word*)lf[1]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[8],lf[61],lf[64]);}}

/* k3947 in setenv in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3949(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3949,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3953,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:564: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),t3,((C_word*)t0)[3],lf[113]);}

/* unsetenv in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3955(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3955,3,t0,t1,t2);}
t3=C_i_check_string_2(t2,lf[114]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3963,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:569: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),t4,t2,lf[114]);}

/* k3951 in k3947 in setenv in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3953(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_setenv(((C_word*)t0)[2],t1);
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}

/* rmdir in delete-directory in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_3137(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3137,NULL,2,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3141,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:381: ##sys#make-c-string */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(3,*((C_word*)lf[10]+1),t3,t2);}

/* delete-directory in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3131(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+8)){
C_save_and_reclaim((void*)tr3r,(void*)f_3131r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3131r(t0,t1,t2,t3);}}

static void C_ccall f_3131r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(8);
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=t5;
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3137,a[2]=((C_word)li23),tmp=(C_word)a,a+=3,tmp);
t8=C_i_check_string_2(t2,lf[66]);
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3157,a[2]=t6,a[3]=t7,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:385: ##sys#expand-home-path */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(3,*((C_word*)lf[12]+1),t9,t2);}

/* k3961 in unsetenv in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3963(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_unsetenv(t1);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}

/* a6789 in k6749 in k6682 in custom-output-port in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_6790(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6790,2,t0,t1);}
/* posixunix.scm:1396: store */
t2=((C_word*)((C_word*)t0)[2])[1];
((C_proc3)C_fast_retrieve_proc(t2))(3,t2,t1,C_SCHEME_FALSE);}

/* get-environment-variables in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3975(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3975,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3981,a[2]=t3,a[3]=((C_word)li60),tmp=(C_word)a,a+=4,tmp));
t5=((C_word*)t3)[1];
f_3981(t5,t1,C_fix(0));}

/* k5567 in loop in k5557 in k5553 in k5540 in group-information in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5569(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5569,2,t0,t1);}
t2=t1;
if(C_truep(t2)){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5579,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=C_fixnum_plus(((C_word*)t0)[3],C_fix(1));
/* posixunix.scm:1010: loop */
t5=((C_word*)((C_word*)t0)[4])[1];
f_5565(t5,t3,t4);}
else{
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_END_OF_LIST);}}

/* loop in k5557 in k5553 in k5540 in group-information in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_5565(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5565,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5569,a[2]=t1,a[3]=t2,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t4=t2;
t5=C_a_i_bytevector(&a,1,C_fix(3));
t6=C_i_foreign_fixnum_argumentp(t4);
t7=stub1177(t5,t6);
/* posixunix.scm:993: ##sys#peek-c-string */
t8=*((C_word*)lf[4]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t3,t7,C_fix(0));}

/* k5561 in k5557 in k5553 in k5540 in group-information in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5563(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:996: g1197 */
t2=((C_word*)t0)[2];
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],C_fix((C_word)C_group->gr_gid),t1);}

/* f_6798 in k6682 in custom-output-port in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_6798(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6798,3,t0,t1,t2);}
if(C_truep(t2)){
t3=C_block_size(t2);
/* posixunix.scm:1368: poke */
t4=((C_word*)((C_word*)t0)[2])[1];
((C_proc4)C_fast_retrieve_proc(t4))(4,t4,t1,t2,t3);}
else{
t3=C_SCHEME_UNDEFINED;
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k8534 in a8519 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8536(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1157: ##sys#error */
t2=*((C_word*)lf[41]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[2],lf[444],lf[445],((C_word*)t0)[3],((C_word*)t0)[4]);}

/* k5577 in k5567 in loop in k5557 in k5553 in k5540 in group-information in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5579(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5579,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_i_cons(&a,2,((C_word*)t0)[3],t1));}

/* k4482 in k4475 in k4472 in k4632 in k4408 in k4400 in k4397 in k4394 in file-select in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_4484(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(((C_word*)t0)[2])){
if(C_truep(C_fixnump(((C_word*)t0)[2]))){
if(C_truep(C_i_memq(((C_word*)t0)[2],((C_word*)t0)[3]))){
t2=((C_word*)t0)[2];
/* posixunix.scm:612: values */
C_values(4,0,((C_word*)t0)[4],t1,t2);}
else{
/* posixunix.scm:612: values */
C_values(4,0,((C_word*)t0)[4],t1,C_SCHEME_FALSE);}}
else{
/* posixunix.scm:612: values */
C_values(4,0,((C_word*)t0)[4],t1,((C_word*)t0)[3]);}}
else{
/* posixunix.scm:612: values */
C_values(4,0,((C_word*)t0)[4],t1,C_SCHEME_FALSE);}}

/* a8519 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8520(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[5],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_8520,4,t0,t1,t2,t3);}
t4=C_i_check_exact_2(t2,lf[444]);
t5=C_i_check_exact_2(t3,lf[444]);
t6=C_setpgid(t2,t3);
if(C_truep(C_fixnum_lessp(t6,C_fix(0)))){
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_8536,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1156: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[5]+1)))(2,*((C_word*)lf[5]+1),t7);}
else{
t7=C_SCHEME_UNDEFINED;
t8=t1;
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,t7);}}

/* k8286 in k8270 in a8260 in process in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8288(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1827: output-port */
t2=((C_word*)t0)[2];
f_8238(t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)t0)[6],((C_word*)t0)[7],t1);}

/* k8282 in k8274 in k8270 in a8260 in process in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8284(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1830: input-port */
t2=((C_word*)t0)[2];
f_8227(t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)t0)[6],((C_word*)t0)[7],t1);}

/* k8278 in k8274 in k8270 in a8260 in process in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8280(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1824: values */
C_values(6,0,((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],t1);}

/* k6749 in k6682 in custom-output-port in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_6751(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[23],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6751,NULL,2,t0,t1);}
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,((C_word*)t0)[3]);
t3=C_mutate2(((C_word *)((C_word*)t0)[4])+1,t1);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6756,a[2]=t5,a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],tmp=(C_word)a,a+=5,tmp);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6762,a[2]=((C_word*)t0)[4],a[3]=((C_word)li156),tmp=(C_word)a,a+=4,tmp);
t8=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6768,a[2]=t5,a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[9],a[6]=((C_word*)t0)[6],a[7]=((C_word)li157),tmp=(C_word)a,a+=8,tmp);
t9=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6790,a[2]=((C_word*)t0)[4],a[3]=((C_word)li158),tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1387: make-output-port */
t10=*((C_word*)lf[358]+1);
((C_proc5)(void*)(*((C_word*)t10+1)))(5,t10,t6,t7,t8,t9);}

/* k6754 in k6749 in k6682 in custom-output-port in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_6756(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6756,2,t0,t1);}
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6760,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1397: set-port-name! */
t4=*((C_word*)lf[350]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,((C_word*)((C_word*)t0)[2])[1],((C_word*)t0)[4]);}

/* k3334 in k3246 in k3243 in k3240 in k3225 in directory in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3336(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:409: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),((C_word*)t0)[2],t1,lf[25]);}

/* setenv in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3938(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_3938,4,t0,t1,t2,t3);}
t4=C_i_check_string_2(t2,lf[113]);
t5=C_i_check_string_2(t3,lf[113]);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3949,a[2]=t1,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:564: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),t6,t2,lf[113]);}

/* k3928 in k3881 in time->string in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3930(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3930,2,t0,t1);}
t2=((C_word*)t0)[2];
t3=C_a_i_bytevector(&a,1,C_fix(3));
if(C_truep(t1)){
t4=C_i_foreign_block_argumentp(t1);
t5=stub516(t3,t2,t4);
/* posix-common.scm:542: ##sys#peek-c-string */
t6=*((C_word*)lf[4]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,((C_word*)t0)[3],t5,C_fix(0));}
else{
t4=stub516(t3,t2,C_SCHEME_FALSE);
/* posix-common.scm:542: ##sys#peek-c-string */
t5=*((C_word*)lf[4]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,((C_word*)t0)[3],t4,C_fix(0));}}

/* a8544 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8545(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_8545,3,t0,t1,t2);}
t3=C_setegid(t2);
if(C_truep(C_fixnum_lessp(t3,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8555,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:953: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[5]+1)))(2,*((C_word*)lf[5]+1),t4);}
else{
t4=C_SCHEME_UNDEFINED;
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}}

/* a8541 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8542(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8542,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,stub1151(C_SCHEME_UNDEFINED));}

/* a8260 in process in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8261(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word ab[26],*a=ab;
if(c!=6) C_bad_argc_2(c,6,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr6,(void*)f_8261,6,t0,t1,t2,t3,t4,t5);}
t6=C_i_not(((C_word*)t0)[2]);
t7=C_i_not(((C_word*)t0)[3]);
t8=C_i_not(((C_word*)t0)[4]);
t9=C_a_i_vector3(&a,3,t6,t7,t8);
t10=t9;
t11=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f_8272,a[2]=t1,a[3]=t5,a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=t4,a[8]=((C_word*)t0)[4],a[9]=((C_word*)t0)[8],a[10]=t10,a[11]=((C_word*)t0)[9],a[12]=t3,a[13]=((C_word*)t0)[3],tmp=(C_word)a,a+=14,tmp);
t12=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_8292,a[2]=((C_word*)t0)[5],a[3]=t11,a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=t2,a[7]=((C_word*)t0)[2],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm:1826: make-on-close */
f_8084(t12,((C_word*)t0)[6],t5,t10,C_fix(0),C_fix(1),C_fix(2));}

/* k6739 in loop in poke1527 in k6682 in custom-output-port in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_6741(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_fixnum_difference(((C_word*)t0)[2],((C_word*)t0)[3]);
/* posixunix.scm:1362: poke */
t3=((C_word*)((C_word*)t0)[4])[1];
((C_proc4)C_fast_retrieve_proc(t3))(4,t3,((C_word*)t0)[5],t1,t2);}

/* k8290 in a8260 in process in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8292(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1825: input-port */
t2=((C_word*)t0)[2];
f_8227(t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)t0)[6],((C_word*)t0)[7],t1);}

/* k5506 in current-user-name in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5508(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:983: user-information */
t2=*((C_word*)lf[260]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k5502 in current-user-name in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5504(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_i_car(t1));}

/* k5516 in current-effective-user-name in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5518(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_i_car(t1));}

/* current-effective-user-name in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5510(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5510,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5518,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5522,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:986: current-effective-user-id */
t4=*((C_word*)lf[257]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k6708 in loop in poke1527 in k6682 in custom-output-port in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_6710(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1356: poke */
t2=((C_word*)((C_word*)t0)[2])[1];
((C_proc4)C_fast_retrieve_proc(t2))(4,t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5]);}

/* k8507 in a8501 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8509(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[3]);}

/* a8501 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8502(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[8],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_8502,3,t0,t1,t2);}
t3=C_i_check_exact_2(t2,lf[323]);
t4=C_getpgid(t2);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8509,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnum_lessp(t4,C_fix(0)))){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8515,a[2]=t5,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1149: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[5]+1)))(2,*((C_word*)lf[5]+1),t6);}
else{
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t4);}}

/* k4400 in k4397 in k4394 in file-select in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_4402(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4402,NULL,2,t0,t1);}
t2=t1;
t3=C_u_i_length(((C_word*)t0)[2]);
t4=C_u_i_length(t2);
t5=C_fixnum_plus(t3,t4);
t6=t5;
t7=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_4410,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],a[4]=t3,a[5]=t2,a[6]=t6,a[7]=((C_word*)t0)[4],a[8]=((C_word*)t0)[5],a[9]=((C_word*)t0)[6],tmp=(C_word)a,a+=10,tmp);
t8=C_fix((C_word)sizeof(struct pollfd));
t9=C_fixnum_times(t6,t8);
/* posixunix.scm:575: ##sys#make-blob */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[180]+1)))(3,*((C_word*)lf[180]+1),t7,t9);}

/* k5540 in group-information in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_5542(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5542,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=(C_truep(((C_word*)t0)[2])?*((C_word*)lf[261]+1):*((C_word*)lf[262]+1));
t3=t2;
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5555,a[2]=t3,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* ##sys#peek-nonnull-c-string */
t5=*((C_word*)lf[254]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t4,C_mpointer(&a,(void*)C_group->gr_name),C_fix(0));}
else{
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* k7992 in process-signal in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_7994(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
t2=C_i_check_exact_2(((C_word*)t0)[2],lf[427]);
t3=C_i_check_exact_2(t1,lf[427]);
t4=C_kill(((C_word*)t0)[2],t1);
t5=C_eqp(t4,C_fix(-1));
if(C_truep(t5)){
/* posixunix.scm:1722: posix-error */
t6=lf[0];
f_2668(7,t6,((C_word*)t0)[3],lf[122],lf[427],lf[428],((C_word*)t0)[2],t1);}
else{
t6=C_SCHEME_UNDEFINED;
t7=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}}

/* process-signal in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7990(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f_7990r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_7990r(t0,t1,t2,t3);}}

static void C_ccall f_7990r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7994,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_pairp(t3))){
t5=t3;
t6=t4;
f_7994(t6,C_u_i_car(t5));}
else{
t5=t4;
f_7994(t5,C_fix((C_word)SIGTERM));}}

/* a6761 in k6749 in k6682 in custom-output-port in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_6762(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6762,3,t0,t1,t2);}
/* posixunix.scm:1389: store */
t3=((C_word*)((C_word*)t0)[2])[1];
((C_proc3)C_fast_retrieve_proc(t3))(3,t3,t1,t2);}

/* k6758 in k6754 in k6749 in k6682 in custom-output-port in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_6760(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)((C_word*)t0)[3])[1]);}

/* k5768 in k5775 in initialize-groups in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5770(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1059: ##sys#error */
t2=*((C_word*)lf[41]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[2],lf[273],lf[274],((C_word*)t0)[3],((C_word*)t0)[4]);}

/* k6776 in a6767 in k6749 in k6682 in custom-output-port in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_6778(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1394: on-close */
t2=((C_word*)t0)[2];
((C_proc2)C_fast_retrieve_proc(t2))(2,t2,((C_word*)t0)[3]);}

/* k5775 in initialize-groups in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5777(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5777,2,t0,t1);}
if(C_truep(C_fixnum_lessp(t1,C_fix(0)))){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5770,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1058: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[5]+1)))(2,*((C_word*)lf[5]+1),t2);}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* k4408 in k4400 in k4397 in k4394 in file-select in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_4410(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[21],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4410,2,t0,t1);}
t2=t1;
t3=(C_truep(((C_word*)t0)[2])?C_i_check_number(((C_word*)t0)[2]):C_SCHEME_UNDEFINED);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4689,a[2]=t2,a[3]=((C_word)li75),tmp=(C_word)a,a+=4,tmp);
t5=f_4689(t4,C_fix(0),((C_word*)t0)[3]);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4647,a[2]=t2,a[3]=((C_word)li76),tmp=(C_word)a,a+=4,tmp);
t7=f_4647(t6,((C_word*)t0)[4],((C_word*)t0)[5]);
t8=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_4634,a[2]=t2,a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[9],a[7]=((C_word*)t0)[4],a[8]=((C_word*)t0)[5],a[9]=((C_word*)t0)[3],tmp=(C_word)a,a+=10,tmp);
if(C_truep(((C_word*)t0)[2])){
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4645,a[2]=t8,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:591: max */
t10=*((C_word*)lf[179]+1);
((C_proc4)(void*)(*((C_word*)t10+1)))(4,t10,t9,C_fix(0),((C_word*)t0)[2]);}
else{
t9=t8;
f_4634(t9,C_fix(-1));}}

/* k5553 in k5540 in group-information in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5555(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5555,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5559,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* ##sys#peek-nonnull-c-string */
t4=*((C_word*)lf[254]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,C_mpointer(&a,(void*)C_group->gr_passwd),C_fix(0));}

/* k5557 in k5553 in k5540 in group-information in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5559(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5559,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5563,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5565,a[2]=t5,a[3]=((C_word)li118),tmp=(C_word)a,a+=4,tmp));
t7=((C_word*)t5)[1];
f_5565(t7,t3,C_fix(0));}

/* k8553 in a8544 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8555(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:954: ##sys#error */
t2=*((C_word*)lf[41]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[448],lf[449],((C_word*)t0)[3]);}

/* a6767 in k6749 in k6682 in custom-output-port in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_6768(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6768,2,t0,t1);}
if(C_truep(C_slot(((C_word*)((C_word*)t0)[2])[1],C_fix(8)))){
t2=C_SCHEME_UNDEFINED;
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6778,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t3=C_close(((C_word*)t0)[4]);
if(C_truep(C_fixnum_lessp(t3,C_fix(0)))){
/* posixunix.scm:1393: posix-error */
t4=lf[0];
f_2668(7,t4,t2,lf[8],((C_word*)t0)[5],lf[357],((C_word*)t0)[4],((C_word*)t0)[6]);}
else{
/* posixunix.scm:1394: on-close */
t4=((C_word*)t0)[3];
((C_proc2)C_fast_retrieve_proc(t4))(2,t4,t1);}}}

/* k5740 in initialize-groups in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5742(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_i_foreign_fixnum_argumentp(((C_word*)t0)[2]);
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,stub1240(C_SCHEME_UNDEFINED,t1,t2));}

/* k2799 in file-type in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_2801(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_stat_type);
if(C_truep(C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFREG)))){
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,lf[23]);}
else{
if(C_truep(C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFLNK)))){
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,lf[24]);}
else{
if(C_truep(C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFDIR)))){
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,lf[25]);}
else{
if(C_truep(C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFCHR)))){
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,lf[26]);}
else{
if(C_truep(C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFBLK)))){
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,lf[27]);}
else{
if(C_truep(C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFIFO)))){
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,lf[28]);}
else{
t3=C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFSOCK));
t4=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_truep(t3)?lf[29]:lf[23]));}}}}}}}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* k5520 in current-effective-user-name in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5522(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:986: user-information */
t2=*((C_word*)lf[260]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* initialize-groups in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5754(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word ab[9],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_5754,4,t0,t1,t2,t3);}
t4=C_i_check_string_2(t2,lf[273]);
t5=C_i_check_exact_2(t3,lf[273]);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5777,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t7=t6;
t8=t2;
t9=t3;
t10=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5742,a[2]=t9,a[3]=t7,tmp=(C_word)a,a+=4,tmp);
if(C_truep(t8)){
t11=C_i_foreign_string_argumentp(t8);
/* posixunix.scm:1053: ##sys#make-c-string */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(3,*((C_word*)lf[10]+1),t10,t11);}
else{
t11=C_i_foreign_fixnum_argumentp(t9);
t12=t7;
((C_proc2)(void*)(*((C_word*)t12+1)))(2,t12,stub1240(C_SCHEME_UNDEFINED,C_SCHEME_FALSE,t11));}}

/* group-information in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5535(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+7)){
C_save_and_reclaim((void*)tr3r,(void*)f_5535r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_5535r(t0,t1,t2,t3);}}

static void C_ccall f_5535r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(7);
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=t5;
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5542,a[2]=t6,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnump(t2))){
t8=t7;
f_5542(t8,C_getgrgid(t2));}
else{
t8=C_i_check_string_2(t2,lf[265]);
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5593,a[2]=t7,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1001: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),t9,t2,lf[265]);}}

/* k8572 in a8563 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8574(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:945: ##sys#error */
t2=*((C_word*)lf[41]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[451],lf[452],((C_word*)t0)[3]);}

/* a8560 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8561(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8561,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,stub1146(C_SCHEME_UNDEFINED));}

/* a8563 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8564(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_8564,3,t0,t1,t2);}
t3=C_setgid(t2);
if(C_truep(C_fixnum_lessp(t3,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8574,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:944: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[5]+1)))(2,*((C_word*)lf[5]+1),t4);}
else{
t4=C_SCHEME_UNDEFINED;
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}}

/* k2645 in k2642 */
static void C_ccall f_2647(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2647,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2650,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_extras_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k2642 */
static void C_ccall f_2644(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2644,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2647,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_irregex_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k8513 in a8501 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8515(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1150: ##sys#error */
t2=*((C_word*)lf[41]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[323],lf[443],((C_word*)t0)[3]);}

/* k5591 in group-information in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5593(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
f_5542(t2,C_getgrnam(t1));}

/* sleep in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7983(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7983,3,t0,t1,t2);}
t3=C_i_foreign_fixnum_argumentp(t2);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,stub1945(C_SCHEME_UNDEFINED,t3));}

/* parent-process-id in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7980(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7980,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,stub1941(C_SCHEME_UNDEFINED));}

/* a8582 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8583(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_8583,3,t0,t1,t2);}
t3=C_seteuid(t2);
if(C_truep(C_fixnum_lessp(t3,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8593,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:934: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[5]+1)))(2,*((C_word*)lf[5]+1),t4);}
else{
t4=C_SCHEME_UNDEFINED;
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}}

/* a8579 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8580(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8580,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,stub1141(C_SCHEME_UNDEFINED));}

/* k4472 in k4632 in k4408 in k4400 in k4397 in k4394 in file-select in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_4474(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4474,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4477,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4514,a[2]=t5,a[3]=((C_word*)t0)[5],a[4]=((C_word)li77),tmp=(C_word)a,a+=5,tmp));
t7=((C_word*)t5)[1];
f_4514(t7,t3,((C_word*)t0)[6],C_SCHEME_END_OF_LIST,((C_word*)t0)[7]);}

/* k4475 in k4472 in k4632 in k4408 in k4400 in k4397 in k4394 in file-select in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_4477(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4477,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4484,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
if(C_truep(((C_word*)t0)[4])){
if(C_truep(C_fixnump(((C_word*)t0)[4]))){
t4=C_i_memq(((C_word*)t0)[4],((C_word*)t0)[5]);
t5=t3;
f_4484(t5,(C_truep(t4)?((C_word*)t0)[4]:C_SCHEME_FALSE));}
else{
t4=t3;
f_4484(t4,((C_word*)t0)[5]);}}
else{
t4=t3;
f_4484(t4,C_SCHEME_FALSE);}}

/* a7957 in process-wait in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7958(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7958,2,t0,t1);}
/* posixunix.scm:1703: ##sys#process-wait */
t2=*((C_word*)lf[121]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,((C_word*)t0)[2],((C_word*)t0)[3]);}

/* f_2909 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_2909(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2909,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2917,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:289: file-type */
t4=*((C_word*)lf[22]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,t2,C_SCHEME_FALSE,C_SCHEME_FALSE);}

/* k2905 in character-device? in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_2907(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_eqp(lf[26],t1));}

/* k7047 in file-lock in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7049(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_flock_lock(((C_word*)t0)[2]);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm:1436: err */
f_7027(((C_word*)t0)[4],lf[365],t1,lf[364]);}
else{
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}}

/* file-lock in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7045(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_7045r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_7045r(t0,t1,t2,t3);}}

static void C_ccall f_7045r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7049,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1434: setup */
f_6962(t4,t2,t3,lf[364]);}

/* a5144 in k5138 in call-with-input-pipe in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5145(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5145,2,t0,t1);}
/* posixunix.scm:749: proc */
t2=((C_word*)t0)[2];
((C_proc3)C_fast_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[3]);}

/* k5138 in call-with-input-pipe in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5140(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5140,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5145,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word)li92),tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5151,a[2]=t2,a[3]=((C_word)li93),tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:748: ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[3],t3,t4);}

/* k6682 in custom-output-port in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_6684(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word ab[26],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6684,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6685,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word)li155),tmp=(C_word)a,a+=7,tmp);
t7=C_fixnump(((C_word*)t0)[5]);
t8=(C_truep(t7)?((C_word*)t0)[5]:C_block_size(((C_word*)t0)[5]));
t9=t8;
t10=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_6751,a[2]=t3,a[3]=t6,a[4]=t5,a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[2],a[9]=((C_word*)t0)[3],tmp=(C_word)a,a+=10,tmp);
t11=C_eqp(C_fix(0),t9);
if(C_truep(t11)){
t12=t10;
f_6751(t12,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6798,a[2]=t3,a[3]=((C_word)li159),tmp=(C_word)a,a+=4,tmp));}
else{
t12=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6812,a[2]=t10,a[3]=t9,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_fixnump(((C_word*)t0)[5]))){
/* posixunix.scm:1369: ##sys#make-string */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[65]+1)))(3,*((C_word*)lf[65]+1),t12,((C_word*)t0)[5]);}
else{
t13=t12;
f_6812(2,t13,((C_word*)t0)[5]);}}}

/* poke1527 in k6682 in custom-output-port in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_6685(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[12],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_6685,4,t0,t1,t2,t3);}
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_6691,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=t3,a[5]=((C_word*)t0)[3],a[6]=t5,a[7]=((C_word*)t0)[4],a[8]=((C_word*)t0)[5],a[9]=((C_word)li154),tmp=(C_word)a,a+=10,tmp));
t7=((C_word*)t5)[1];
f_6691(2,t7,t1);}

/* k7063 in file-lock/blocking in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7065(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_flock_lockw(((C_word*)t0)[2]);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm:1442: err */
f_7027(((C_word*)t0)[4],lf[367],t1,lf[366]);}
else{
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}}

/* file-lock/blocking in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7061(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_7061r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_7061r(t0,t1,t2,t3);}}

static void C_ccall f_7061r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7065,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1440: setup */
f_6962(t4,t2,t3,lf[366]);}

/* k3062 in port->fileno in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3064(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3064,2,t0,t1);}
if(C_truep(C_i_zerop(t1))){
/* posix-common.scm:348: posix-error */
t2=lf[0];
f_2668(6,t2,((C_word*)t0)[2],lf[13],lf[54],lf[56],((C_word*)t0)[3]);}
else{
t2=C_C_fileno(((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3047,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
/* posix-common.scm:346: posix-error */
t4=lf[0];
f_2668(6,t4,t3,lf[8],lf[54],lf[57],((C_word*)t0)[3]);}
else{
t4=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t2);}}}

/* k8201 in k8190 in k8187 in k8184 in spawn in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8203(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1801: values */
C_values(6,0,((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],t1);}

/* a8204 in k8190 in k8187 in k8184 in spawn in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8205(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[12],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8205,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_8209,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],a[11]=((C_word*)t0)[10],tmp=(C_word)a,a+=12,tmp);
/* posixunix.scm:1805: connect-child */
f_8153(t2,((C_word*)t0)[11],((C_word*)t0)[12],*((C_word*)lf[37]+1));}

/* k8207 in a8204 in k8190 in k8187 in k8184 in spawn in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 in ... */
static void C_ccall f_8209(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8209,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_8212,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],tmp=(C_word)a,a+=10,tmp);
t3=f_8168(C_a_i(&a,3),((C_word*)t0)[10]);
/* posixunix.scm:1806: connect-child */
f_8153(t2,t3,((C_word*)t0)[11],*((C_word*)lf[38]+1));}

/* k3036 in port->fileno in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3038(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_slot(t1,C_fix(0)));}

/* k8229 in input-port in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8231(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
/* posixunix.scm:1812: ##sys#custom-input-port */
t2=*((C_word*)lf[339]+1);
((C_proc8)(void*)(*((C_word*)t2+1)))(8,t2,((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)t0)[4],t1,C_SCHEME_TRUE,C_fix(256),((C_word*)t0)[5]);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* output-port in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_8238(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6){
C_word tmp;
C_word t7;
C_word t8;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_8238,NULL,7,t0,t1,t2,t3,t4,t5,t6);}
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_8242,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t6,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:1815: connect-parent */
f_8141(t7,t4,t5);}

/* ##sys#process-wait in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7942(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word ab[5],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_7942,4,t0,t1,t2,t3);}
t4=(C_truep(t3)?C_fix((C_word)WNOHANG):C_fix(0));
t5=C_waitpid(t2,t4);
t6=C_WIFEXITED(C_fix((C_word)C_wait_status));
t7=C_eqp(t5,C_fix(-1));
t8=(C_truep(t7)?C_eqp(C_fix((C_word)errno),C_fix((C_word)EINTR)):C_SCHEME_FALSE);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7958,a[2]=t2,a[3]=t3,a[4]=((C_word)li195),tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1702: ##sys#dispatch-interrupt */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[347]+1)))(3,*((C_word*)lf[347]+1),t1,t9);}
else{
if(C_truep(t6)){
t9=C_WEXITSTATUS(C_fix((C_word)C_wait_status));
/* posixunix.scm:1704: values */
C_values(5,0,t1,t5,t6,t9);}
else{
if(C_truep(C_WIFSIGNALED(C_fix((C_word)C_wait_status)))){
t9=C_WTERMSIG(C_fix((C_word)C_wait_status));
/* posixunix.scm:1704: values */
C_values(5,0,t1,t5,t6,t9);}
else{
t9=C_WSTOPSIG(C_fix((C_word)C_wait_status));
/* posixunix.scm:1704: values */
C_values(5,0,t1,t5,t6,t9);}}}}

/* with-input-from-pipe in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5184(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr4r,(void*)f_5184r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_5184r(t0,t1,t2,t3,t4);}}

static void C_ccall f_5184r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5188,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
C_apply(5,0,t5,*((C_word*)lf[200]+1),t2,t4);}

/* k5186 in with-input-from-pipe in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5188(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5188,2,t0,t1);}
t2=t1;
t3=t2;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_SCHEME_FALSE;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5193,a[2]=t6,a[3]=t4,a[4]=((C_word)li98),tmp=(C_word)a,a+=5,tmp);
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5198,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word)li100),tmp=(C_word)a,a+=5,tmp);
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5213,a[2]=t4,a[3]=t6,a[4]=((C_word)li101),tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:764: ##sys#dynamic-wind */
t10=*((C_word*)lf[87]+1);
((C_proc5)(void*)(*((C_word*)t10+1)))(5,t10,((C_word*)t0)[3],t7,t8,t9);}

/* k3045 in k3062 in port->fileno in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3047(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[3]);}

/* file-test-lock in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7077(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_7077r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_7077r(t0,t1,t2,t3);}}

static void C_ccall f_7077r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7081,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1446: setup */
f_6962(t4,t2,t3,lf[368]);}

/* k5153 in a5150 in k5138 in call-with-input-pipe in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5155(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply_values(3,0,((C_word*)t0)[2],((C_word*)t0)[3]);}

/* a5150 in k5138 in call-with-input-pipe in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5151(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_5151r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_5151r(t0,t1,t2);}}

static void C_ccall f_5151r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5155,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:751: close-input-pipe */
t4=*((C_word*)lf[205]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k8213 in k8210 in k8207 in a8204 in k8190 in k8187 in k8184 in spawn in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in ... */
static void C_ccall f_8215(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1808: process-execute */
t2=*((C_word*)lf[423]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5]);}

/* k8210 in k8207 in a8204 in k8190 in k8187 in k8184 in spawn in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in ... */
static void C_ccall f_8212(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8212,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_8215,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
t3=f_8168(C_a_i(&a,3),((C_word*)t0)[7]);
/* posixunix.scm:1807: connect-child */
f_8153(t2,t3,((C_word*)t0)[9],*((C_word*)lf[39]+1));}

/* process* in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8424(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+0)){
C_save_and_reclaim((void*)tr3r,(void*)f_8424r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_8424r(t0,t1,t2,t3);}}

static void C_ccall f_8424r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=C_i_nullp(t3);
t7=(C_truep(t6)?C_SCHEME_END_OF_LIST:C_i_cdr(t3));
t8=C_i_nullp(t7);
t9=(C_truep(t8)?C_SCHEME_FALSE:C_i_car(t7));
if(C_truep(C_i_nullp(t7))){
/* posixunix.scm:1861: %process */
f_8305(t1,lf[439],C_SCHEME_TRUE,t2,t5,t9,*((C_word*)lf[440]+1));}
else{
t10=C_i_cdr(t7);
/* posixunix.scm:1861: %process */
f_8305(t1,lf[439],C_SCHEME_TRUE,t2,t5,t9,*((C_word*)lf[440]+1));}}

/* k2885 in symbolic-link? in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_2887(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_eqp(lf[24],t1));}

/* block-device? in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_2889(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2889,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2897,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:283: file-type */
t4=*((C_word*)lf[22]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,t2,C_SCHEME_FALSE,C_SCHEME_FALSE);}

/* k5162 in call-with-output-pipe in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5164(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5164,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5169,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word)li95),tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5175,a[2]=t2,a[3]=((C_word)li96),tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:757: ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[3],t3,t4);}

/* set-file-position! in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_4776(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_4776r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_4776r(t0,t1,t2,t3,t4);}}

static void C_ccall f_4776r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4780,a[2]=t3,a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_pairp(t4))){
t6=t4;
t7=t5;
f_4780(t7,C_u_i_car(t6));}
else{
t6=t5;
f_4780(t6,C_fix((C_word)SEEK_SET));}}

/* call-with-output-pipe in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5160(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr4r,(void*)f_5160r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_5160r(t0,t1,t2,t3,t4);}}

static void C_ccall f_5160r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5164,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
C_apply(5,0,t5,*((C_word*)lf[204]+1),t2,t4);}

/* ##sys#process in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8249(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8){
C_word tmp;
C_word t9;
C_word t10;
C_word t11;
C_word ab[21],*a=ab;
if(c!=9) C_bad_argc_2(c,9,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr9,(void*)f_8249,9,t0,t1,t2,t3,t4,t5,t6,t7,t8);}
t9=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_8255,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=t4,a[5]=t5,a[6]=t6,a[7]=t7,a[8]=t8,a[9]=((C_word)li217),tmp=(C_word)a,a+=10,tmp);
t10=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_8261,a[2]=t7,a[3]=t6,a[4]=t8,a[5]=((C_word*)t0)[3],a[6]=t2,a[7]=t3,a[8]=((C_word*)t0)[4],a[9]=((C_word*)t0)[5],a[10]=((C_word)li218),tmp=(C_word)a,a+=11,tmp);
/* posixunix.scm:1759: ##sys#call-with-values */
C_call_with_values(4,0,t1,t9,t10);}

/* k8240 in output-port in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8242(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
/* posixunix.scm:1816: ##sys#custom-output-port */
t2=*((C_word*)lf[355]+1);
((C_proc8)(void*)(*((C_word*)t2+1)))(8,t2,((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)t0)[4],t1,C_SCHEME_TRUE,C_fix(0),((C_word*)t0)[5]);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* a5168 in k5162 in call-with-output-pipe in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5169(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5169,2,t0,t1);}
/* posixunix.scm:758: proc */
t2=((C_word*)t0)[2];
((C_proc3)C_fast_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[3]);}

/* k2875 in regular-file? in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_2877(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_eqp(lf[23],t1));}

/* ##sys#custom-output-port in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_6662(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...){
C_word tmp;
C_word t5;
va_list v;
C_word *a,c2=c;
C_save_rest(t4,c2,5);
if(c<5) C_bad_min_argc_2(c,5,t0);
if(!C_demand(c*C_SIZEOF_PAIR+8)){
C_save_and_reclaim((void*)tr5r,(void*)f_6662r,5,t0,t1,t2,t3,t4);}
else{
a=C_alloc((c-5)*3);
t5=C_restore_rest(a,C_rest_count(0));
f_6662r(t0,t1,t2,t3,t4,t5);}}

static void C_ccall f_6662r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word *a=C_alloc(8);
t6=C_i_nullp(t5);
t7=(C_truep(t6)?C_SCHEME_FALSE:C_i_car(t5));
t8=C_i_nullp(t5);
t9=(C_truep(t8)?C_SCHEME_END_OF_LIST:C_i_cdr(t5));
t10=C_i_nullp(t9);
t11=(C_truep(t10)?C_fix(0):C_i_car(t9));
t12=t11;
t13=C_i_nullp(t9);
t14=(C_truep(t13)?C_SCHEME_END_OF_LIST:C_i_cdr(t9));
t15=C_i_nullp(t14);
t16=(C_truep(t15)?*((C_word*)lf[340]+1):C_i_car(t14));
t17=t16;
t18=C_i_nullp(t14);
t19=(C_truep(t18)?C_SCHEME_END_OF_LIST:C_i_cdr(t14));
t20=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6684,a[2]=t4,a[3]=t2,a[4]=t3,a[5]=t12,a[6]=t1,a[7]=t17,tmp=(C_word)a,a+=8,tmp);
if(C_truep(t7)){
/* posixunix.scm:1347: ##sys#file-nonblocking! */
t21=*((C_word*)lf[124]+1);
((C_proc3)(void*)(*((C_word*)t21+1)))(3,t21,t20,t4);}
else{
t21=t20;
f_6684(2,t21,C_SCHEME_UNDEFINED);}}

/* symbolic-link? in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_2879(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2879,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2887,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:280: file-type */
t4=*((C_word*)lf[22]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,t2,C_SCHEME_TRUE,C_SCHEME_FALSE);}

/* call-with-input-pipe in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5136(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr4r,(void*)f_5136r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_5136r(t0,t1,t2,t3,t4);}}

static void C_ccall f_5136r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5140,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
C_apply(5,0,t5,*((C_word*)lf[200]+1),t2,t4);}

/* k8274 in k8270 in a8260 in process in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8276(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8276,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_8280,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t4=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_8284,a[2]=((C_word*)t0)[5],a[3]=t3,a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm:1831: make-on-close */
f_8084(t4,((C_word*)t0)[6],((C_word*)t0)[4],((C_word*)t0)[11],C_fix(2),C_fix(0),C_fix(1));}

/* socket? in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_2919(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2919,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2927,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:292: file-type */
t4=*((C_word*)lf[22]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,t2,C_SCHEME_FALSE,C_SCHEME_FALSE);}

/* k8270 in a8260 in process in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8272(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[20],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8272,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_8276,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],a[11]=((C_word*)t0)[10],tmp=(C_word)a,a+=12,tmp);
t4=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_8288,a[2]=((C_word*)t0)[11],a[3]=t3,a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[12],a[7]=((C_word*)t0)[13],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm:1828: make-on-close */
f_8084(t4,((C_word*)t0)[5],((C_word*)t0)[3],((C_word*)t0)[10],C_fix(1),C_fix(0),C_fix(2));}

/* k2915 */
static void C_ccall f_2917(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_eqp(lf[28],t1));}

/* regular-file? in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_2869(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2869,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2877,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:277: file-type */
t4=*((C_word*)lf[22]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,t2,C_SCHEME_FALSE,C_SCHEME_FALSE);}

/* loop in poke1527 in k6682 in custom-output-port in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_6691(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[6],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6691,2,t0,t1);}
t2=C_write(((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)t0)[4]);
t3=C_eqp(C_fix(-1),t2);
if(C_truep(t3)){
t4=C_fix((C_word)errno);
t5=C_i_eqvp(t4,C_fix((C_word)EWOULDBLOCK));
t6=(C_truep(t5)?t5:C_i_eqvp(t4,C_fix((C_word)EAGAIN)));
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6710,a[2]=((C_word*)t0)[5],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:1355: ##sys#thread-yield! */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[343]+1)))(2,*((C_word*)lf[343]+1),t7);}
else{
if(C_truep(C_i_eqvp(t4,C_fix((C_word)EINTR)))){
/* posixunix.scm:1358: ##sys#dispatch-interrupt */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[347]+1)))(3,*((C_word*)lf[347]+1),t1,((C_word*)((C_word*)t0)[6])[1]);}
else{
/* posixunix.scm:1360: posix-error */
t7=lf[0];
f_2668(7,t7,t1,((C_word*)t0)[7],lf[8],lf[356],((C_word*)t0)[2],((C_word*)t0)[8]);}}}
else{
if(C_truep(C_fixnum_lessp(t2,((C_word*)t0)[4]))){
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6741,a[2]=((C_word*)t0)[4],a[3]=t2,a[4]=((C_word*)t0)[5],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:1362: ##sys#substring */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[63]+1)))(5,*((C_word*)lf[63]+1),t4,((C_word*)t0)[3],t2,((C_word*)t0)[4]);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}}

/* k4793 in k4787 in k4778 in set-file-position! in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_4795(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
/* posixunix.scm:641: posix-error */
t2=lf[0];
f_2668(7,t2,((C_word*)t0)[2],lf[8],lf[184],lf[185],((C_word*)t0)[3],((C_word*)t0)[4]);}}

/* input-port in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_8227(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6){
C_word tmp;
C_word t7;
C_word t8;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_8227,NULL,7,t0,t1,t2,t3,t4,t5,t6);}
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_8231,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t6,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:1811: connect-parent */
f_8141(t7,t4,t5);}

/* k8469 in set-root-directory! in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8471(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,stub2141(C_SCHEME_UNDEFINED,t1));}

/* set-root-directory! in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8479(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[7],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_8479,3,t0,t1,t2);}
t3=C_i_check_string_2(t2,lf[441]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8496,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t5=t4;
t6=t2;
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8471,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
if(C_truep(t6)){
t8=C_i_foreign_string_argumentp(t6);
/* posixunix.scm:1869: ##sys#make-c-string */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(3,*((C_word*)lf[10]+1),t7,t8);}
else{
t8=t5;
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,stub2141(C_SCHEME_UNDEFINED,C_SCHEME_FALSE));}}

/* k7079 in file-test-lock in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7081(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
t2=C_flock_test(((C_word*)t0)[2]);
if(C_truep(t2)){
t3=((C_word*)t0)[3];
t4=C_eqp(t2,C_fix(0));
t5=t3;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,(C_truep(t4)?C_SCHEME_FALSE:t2));}
else{
/* posixunix.scm:1448: err */
f_7027(((C_word*)t0)[3],lf[369],t1,lf[368]);}}

/* a8254 in process in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8255(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8255,2,t0,t1);}
/* posixunix.scm:1819: spawn */
t2=((C_word*)t0)[2];
f_8182(t2,t1,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)t0)[6],((C_word*)t0)[7],((C_word*)t0)[8]);}

/* k3543 in k3607 in k3614 in k3509 in loop in k3488 in k3481 in k3478 in k3686 in k3683 in k3680 in k3677 in k3674 in k3671 in find-files in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3545(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word ab[30],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3545,2,t0,t1);}
if(C_truep(t1)){
t2=C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],C_fix(1));
t3=t2;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_SCHEME_FALSE;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3555,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3557,a[2]=t6,a[3]=((C_word*)t0)[2],a[4]=t4,a[5]=((C_word)li35),tmp=(C_word)a,a+=6,tmp);
t9=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3562,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[9],a[7]=((C_word*)t0)[10],a[8]=((C_word)li36),tmp=(C_word)a,a+=9,tmp);
t10=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3590,a[2]=t4,a[3]=((C_word*)t0)[2],a[4]=t6,a[5]=((C_word)li37),tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:477: ##sys#dynamic-wind */
t11=*((C_word*)lf[87]+1);
((C_proc5)(void*)(*((C_word*)t11+1)))(5,t11,t7,t8,t9,t10);}
else{
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3600,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3603,a[2]=((C_word*)t0)[6],a[3]=t2,a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[3],a[7]=((C_word*)t0)[4],a[8]=((C_word*)t0)[5],tmp=(C_word)a,a+=9,tmp);
/* posix-common.scm:480: pproc */
t4=((C_word*)t0)[9];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[7]);}}

/* k3509 in loop in k3488 in k3481 in k3478 in k3686 in k3683 in k3680 in k3677 in k3674 in k3671 in find-files in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3511(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3511,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_3616,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],a[11]=((C_word*)t0)[11],a[12]=((C_word*)t0)[12],tmp=(C_word)a,a+=13,tmp);
/* posix-common.scm:472: pathname-file */
t3=*((C_word*)lf[88]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[8]);}
else{
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3622,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[5],tmp=(C_word)a,a+=8,tmp);
/* posix-common.scm:481: pproc */
t3=((C_word*)t0)[9];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[8]);}}

/* k4778 in set-file-position! in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_4780(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4780,NULL,2,t0,t1);}
t2=t1;
t3=C_i_check_exact_2(((C_word*)t0)[2],lf[184]);
t4=C_i_check_exact_2(t2,lf[184]);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4789,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[2],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t6=((C_word*)t0)[2];
if(C_truep(C_fixnum_lessp(t6,C_fix(0)))){
/* posixunix.scm:633: ##sys#signal-hook */
t7=*((C_word*)lf[1]+1);
((C_proc7)(void*)(*((C_word*)t7+1)))(7,t7,t5,lf[188],lf[184],lf[189],((C_word*)t0)[2],((C_word*)t0)[4]);}
else{
t7=t5;
f_4789(2,t7,C_SCHEME_UNDEFINED);}}

/* k4787 in k4778 in set-file-position! in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_4789(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4789,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4795,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4801,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:634: port? */
t4=*((C_word*)lf[187]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[3]);}

/* k6165 in custom-input-port in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_6167(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6167,2,t0,t1);}
t2=C_fixnump(((C_word*)t0)[2]);
t3=(C_truep(t2)?((C_word*)t0)[2]:C_block_size(((C_word*)t0)[2]));
t4=t3;
t5=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_6173,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t4,a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],tmp=(C_word)a,a+=9,tmp);
if(C_truep(C_fixnump(((C_word*)t0)[2]))){
/* posixunix.scm:1220: ##sys#make-string */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[65]+1)))(3,*((C_word*)lf[65]+1),t5,((C_word*)t0)[2]);}
else{
t6=t5;
f_6173(2,t6,((C_word*)t0)[2]);}}

/* character-device? in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_2899(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2899,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2907,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:286: file-type */
t4=*((C_word*)lf[22]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,t2,C_SCHEME_FALSE,C_SCHEME_FALSE);}

/* k2895 in block-device? in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_2897(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_eqp(lf[27],t1));}

/* k3534 in k3607 in k3614 in k3509 in loop in k3488 in k3481 in k3478 in k3686 in k3683 in k3680 in k3677 in k3674 in k3671 in find-files in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3536(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
/* posix-common.scm:474: action */
t2=((C_word*)t0)[2];
((C_proc4)C_fast_retrieve_proc(t2))(4,t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5]);}
else{
t2=((C_word*)t0)[5];
/* posix-common.scm:474: loop */
t3=((C_word*)((C_word*)t0)[6])[1];
f_3492(t3,((C_word*)t0)[7],((C_word*)t0)[8],t2);}}

/* k3531 in k3607 in k3614 in k3509 in loop in k3488 in k3481 in k3478 in k3686 in k3683 in k3680 in k3677 in k3674 in k3671 in find-files in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3533(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:474: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_3492(t2,((C_word*)t0)[3],((C_word*)t0)[4],t1);}

/* k8190 in k8187 in k8184 in spawn in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8192(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[23],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8192,2,t0,t1);}
t2=t1;
t3=f_8168(C_a_i(&a,3),((C_word*)t0)[3]);
t4=t3;
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_8203,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=t4,a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t6=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f_8205,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[2],a[6]=t2,a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[5],a[10]=((C_word*)t0)[11],a[11]=((C_word*)t0)[3],a[12]=((C_word*)t0)[12],a[13]=((C_word)li213),tmp=(C_word)a,a+=14,tmp);
/* posixunix.scm:1803: process-fork */
t7=*((C_word*)lf[419]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t5,t6);}

/* err in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_7027(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7027,NULL,4,t1,t2,t3,t4);}
t5=C_slot(t3,C_fix(1));
t6=C_slot(t3,C_fix(2));
t7=C_slot(t3,C_fix(3));
/* posixunix.scm:1431: posix-error */
t8=lf[0];
f_2668(8,t8,t1,lf[8],t4,t2,t5,t6,t7);}

/* k8187 in k8184 in spawn in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8189(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8189,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_8192,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],a[11]=((C_word*)t0)[10],a[12]=((C_word*)t0)[11],tmp=(C_word)a,a+=13,tmp);
/* posixunix.scm:1800: needed-pipe */
f_8121(t3,((C_word*)t0)[9]);}

/* k8184 in spawn in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8186(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8186,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_8189,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],a[11]=((C_word*)t0)[10],a[12]=((C_word*)t0)[11],tmp=(C_word)a,a+=13,tmp);
/* posixunix.scm:1799: needed-pipe */
f_8121(t3,((C_word*)t0)[9]);}

/* spawn in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_8182(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word t9;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_8182,NULL,8,t0,t1,t2,t3,t4,t5,t6,t7);}
t8=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_8186,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,a[5]=t3,a[6]=t4,a[7]=((C_word*)t0)[3],a[8]=t7,a[9]=t5,a[10]=t6,a[11]=((C_word*)t0)[4],tmp=(C_word)a,a+=12,tmp);
/* posixunix.scm:1798: needed-pipe */
f_8121(t8,t6);}

/* ##sys#custom-input-port in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_6139(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...){
C_word tmp;
C_word t5;
va_list v;
C_word *a,c2=c;
C_save_rest(t4,c2,5);
if(c<5) C_bad_min_argc_2(c,5,t0);
if(!C_demand(c*C_SIZEOF_PAIR+9)){
C_save_and_reclaim((void*)tr5r,(void*)f_6139r,5,t0,t1,t2,t3,t4);}
else{
a=C_alloc((c-5)*3);
t5=C_restore_rest(a,C_rest_count(0));
f_6139r(t0,t1,t2,t3,t4,t5);}}

static void C_ccall f_6139r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word *a=C_alloc(9);
t6=C_i_nullp(t5);
t7=(C_truep(t6)?C_SCHEME_FALSE:C_i_car(t5));
t8=C_i_nullp(t5);
t9=(C_truep(t8)?C_SCHEME_END_OF_LIST:C_i_cdr(t5));
t10=C_i_nullp(t9);
t11=(C_truep(t10)?C_fix(1):C_i_car(t9));
t12=t11;
t13=C_i_nullp(t9);
t14=(C_truep(t13)?C_SCHEME_END_OF_LIST:C_i_cdr(t9));
t15=C_i_nullp(t14);
t16=(C_truep(t15)?*((C_word*)lf[340]+1):C_i_car(t14));
t17=t16;
t18=C_i_nullp(t14);
t19=(C_truep(t18)?C_SCHEME_END_OF_LIST:C_i_cdr(t14));
t20=C_i_nullp(t19);
t21=(C_truep(t20)?C_SCHEME_FALSE:C_i_car(t19));
t22=t21;
t23=C_i_nullp(t19);
t24=(C_truep(t23)?C_SCHEME_END_OF_LIST:C_i_cdr(t19));
t25=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_6167,a[2]=t12,a[3]=t2,a[4]=t4,a[5]=t3,a[6]=t22,a[7]=t1,a[8]=t17,tmp=(C_word)a,a+=9,tmp);
if(C_truep(t7)){
/* posixunix.scm:1218: ##sys#file-nonblocking! */
t26=*((C_word*)lf[124]+1);
((C_proc3)(void*)(*((C_word*)t26+1)))(3,t26,t25,t4);}
else{
t26=t25;
f_6167(2,t26,C_SCHEME_UNDEFINED);}}

/* k6135 in file-link in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_6137(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(C_fixnum_lessp(t1,C_fix(0)))){
/* posixunix.scm:1213: posix-error */
t2=lf[0];
f_2668(7,t2,((C_word*)t0)[2],lf[8],lf[337],lf[338],((C_word*)t0)[3],((C_word*)t0)[4]);}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* toplevel */
static C_TLS int toplevel_initialized=0;
C_noret_decl(toplevel_trampoline)
static void C_fcall toplevel_trampoline(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall toplevel_trampoline(void *dummy){
C_posix_toplevel(2,C_SCHEME_UNDEFINED,C_restore);}

void C_ccall C_posix_toplevel(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(toplevel_initialized) C_kontinue(t1,C_SCHEME_UNDEFINED);
else C_toplevel_entry(C_text("posix_toplevel"));
C_check_nursery_minimum(3);
if(!C_demand(3)){
C_save(t1);
C_reclaim((void*)toplevel_trampoline,NULL);}
toplevel_initialized=1;
if(!C_demand_2(3404)){
C_save(t1);
C_rereclaim2(3404*sizeof(C_word), 1);
t1=C_restore;}
a=C_alloc(3);
C_initialize_lf(lf,466);
lf[1]=C_h_intern(&lf[1],15,"\003syssignal-hook");
lf[2]=C_h_intern(&lf[2],13,"string-append");
lf[3]=C_decode_literal(C_heaptop,"\376B\000\000\003 - ");
lf[4]=C_h_intern(&lf[4],17,"\003syspeek-c-string");
lf[5]=C_h_intern(&lf[5],16,"\003sysupdate-errno");
lf[6]=C_h_intern(&lf[6],15,"\003sysposix-error");
lf[8]=C_h_intern(&lf[8],11,"\000file-error");
lf[9]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot access file");
lf[10]=C_h_intern(&lf[10],17,"\003sysmake-c-string");
lf[11]=C_h_intern(&lf[11],27,"\003sysplatform-fixup-pathname");
lf[12]=C_h_intern(&lf[12],20,"\003sysexpand-home-path");
lf[13]=C_h_intern(&lf[13],11,"\000type-error");
lf[14]=C_decode_literal(C_heaptop,"\376B\000\000\052bad argument type - not a fixnum or string");
lf[15]=C_h_intern(&lf[15],9,"file-stat");
lf[16]=C_h_intern(&lf[16],22,"file-modification-time");
lf[17]=C_h_intern(&lf[17],16,"file-access-time");
lf[18]=C_h_intern(&lf[18],16,"file-change-time");
lf[19]=C_h_intern(&lf[19],10,"file-owner");
lf[20]=C_h_intern(&lf[20],16,"file-permissions");
lf[21]=C_h_intern(&lf[21],9,"file-size");
lf[22]=C_h_intern(&lf[22],9,"file-type");
lf[23]=C_h_intern(&lf[23],12,"regular-file");
lf[24]=C_h_intern(&lf[24],13,"symbolic-link");
lf[25]=C_h_intern(&lf[25],9,"directory");
lf[26]=C_h_intern(&lf[26],16,"character-device");
lf[27]=C_h_intern(&lf[27],12,"block-device");
lf[28]=C_h_intern(&lf[28],4,"fifo");
lf[29]=C_h_intern(&lf[29],6,"socket");
lf[30]=C_h_intern(&lf[30],13,"regular-file\077");
lf[31]=C_h_intern(&lf[31],14,"symbolic-link\077");
lf[32]=C_h_intern(&lf[32],13,"block-device\077");
lf[33]=C_h_intern(&lf[33],17,"character-device\077");
lf[34]=C_h_intern(&lf[34],5,"fifo\077");
lf[35]=C_h_intern(&lf[35],7,"socket\077");
lf[36]=C_h_intern(&lf[36],10,"directory\077");
lf[37]=C_h_intern(&lf[37],12,"fileno/stdin");
lf[38]=C_h_intern(&lf[38],13,"fileno/stdout");
lf[39]=C_h_intern(&lf[39],13,"fileno/stderr");
lf[40]=C_h_intern(&lf[40],7,"\000append");
lf[41]=C_h_intern(&lf[41],9,"\003syserror");
lf[42]=C_decode_literal(C_heaptop,"\376B\000\000\033invalid mode for input file");
lf[43]=C_decode_literal(C_heaptop,"\376B\000\000\001a");
lf[44]=C_decode_literal(C_heaptop,"\376B\000\000\025invalid mode argument");
lf[45]=C_decode_literal(C_heaptop,"\376B\000\000\001r");
lf[46]=C_decode_literal(C_heaptop,"\376B\000\000\001w");
lf[47]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open file");
lf[48]=C_h_intern(&lf[48],13,"\003sysmake-port");
lf[49]=C_h_intern(&lf[49],21,"\003sysstream-port-class");
lf[50]=C_decode_literal(C_heaptop,"\376B\000\000\010(fdport)");
lf[51]=C_h_intern(&lf[51],6,"stream");
lf[52]=C_h_intern(&lf[52],16,"open-input-file\052");
lf[53]=C_h_intern(&lf[53],17,"open-output-file\052");
lf[54]=C_h_intern(&lf[54],12,"port->fileno");
lf[55]=C_h_intern(&lf[55],13,"\003sysport-data");
lf[56]=C_decode_literal(C_heaptop,"\376B\000\000\031port has no attached file");
lf[57]=C_decode_literal(C_heaptop,"\376B\000\000%cannot access file-descriptor of port");
lf[58]=C_h_intern(&lf[58],25,"\003syspeek-unsigned-integer");
lf[59]=C_h_intern(&lf[59],16,"duplicate-fileno");
lf[60]=C_decode_literal(C_heaptop,"\376B\000\000 cannot duplicate file-descriptor");
lf[61]=C_h_intern(&lf[61],17,"current-directory");
lf[62]=C_h_intern(&lf[62],16,"change-directory");
lf[63]=C_h_intern(&lf[63],13,"\003syssubstring");
lf[64]=C_decode_literal(C_heaptop,"\376B\000\000!cannot retrieve current directory");
lf[65]=C_h_intern(&lf[65],15,"\003sysmake-string");
lf[66]=C_h_intern(&lf[66],16,"delete-directory");
lf[67]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot delete directory");
lf[68]=C_h_intern(&lf[68],11,"delete-file");
lf[69]=C_h_intern(&lf[69],8,"for-each");
lf[70]=C_h_intern(&lf[70],10,"find-files");
lf[71]=C_h_intern(&lf[71],9,"\000dotfiles");
lf[72]=C_h_intern(&lf[72],16,"\000follow-symlinks");
lf[73]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot open directory");
lf[74]=C_h_intern(&lf[74],16,"\003sysmake-pointer");
lf[75]=C_h_intern(&lf[75],4,"glob");
lf[76]=C_h_intern(&lf[76],18,"decompose-pathname");
lf[77]=C_h_intern(&lf[77],13,"make-pathname");
lf[78]=C_h_intern(&lf[78],23,"irregex-match-substring");
lf[79]=C_h_intern(&lf[79],13,"irregex-match");
lf[80]=C_decode_literal(C_heaptop,"\376B\000\000\001.");
lf[81]=C_h_intern(&lf[81],16,"\003sysglob->regexp");
lf[82]=C_decode_literal(C_heaptop,"\376B\000\000\001\052");
lf[83]=C_decode_literal(C_heaptop,"\376B\000\000\001.");
lf[84]=C_decode_literal(C_heaptop,"\376B\000\000\002..");
lf[85]=C_decode_literal(C_heaptop,"\376B\000\000\002\077\052");
lf[86]=C_decode_literal(C_heaptop,"\376B\000\000\001\052");
lf[87]=C_h_intern(&lf[87],16,"\003sysdynamic-wind");
lf[88]=C_h_intern(&lf[88],13,"pathname-file");
lf[89]=C_decode_literal(C_heaptop,"\376B\000\000\002\077\052");
lf[90]=C_decode_literal(C_heaptop,"\376B\000\000\001\052");
lf[91]=C_h_intern(&lf[91],7,"irregex");
lf[92]=C_h_intern(&lf[92],15,"\003sysget-keyword");
lf[93]=C_h_intern(&lf[93],6,"\000limit");
lf[94]=C_h_intern(&lf[94],5,"\000seed");
lf[95]=C_h_intern(&lf[95],7,"\000action");
lf[96]=C_h_intern(&lf[96],5,"\000test");
lf[97]=C_h_intern(&lf[97],18,"file-creation-mode");
lf[99]=C_decode_literal(C_heaptop,"\376B\000\000\025time vector too short");
lf[100]=C_h_intern(&lf[100],19,"seconds->local-time");
lf[101]=C_h_intern(&lf[101],18,"\003sysdecode-seconds");
lf[102]=C_h_intern(&lf[102],15,"current-seconds");
lf[103]=C_h_intern(&lf[103],17,"seconds->utc-time");
lf[104]=C_h_intern(&lf[104],15,"seconds->string");
lf[105]=C_decode_literal(C_heaptop,"\376B\000\000 cannot convert seconds to string");
lf[106]=C_h_intern(&lf[106],19,"local-time->seconds");
lf[107]=C_decode_literal(C_heaptop,"\376B\000\000%cannot convert time vector to seconds");
lf[108]=C_h_intern(&lf[108],3,"fp=");
lf[109]=C_decode_literal(C_heaptop,"\376U-1.0\000");
lf[110]=C_h_intern(&lf[110],12,"time->string");
lf[111]=C_decode_literal(C_heaptop,"\376B\000\000 time formatting overflows buffer");
lf[112]=C_decode_literal(C_heaptop,"\376B\000\000$cannot convert time vector to string");
lf[113]=C_h_intern(&lf[113],6,"setenv");
lf[114]=C_h_intern(&lf[114],8,"unsetenv");
lf[115]=C_h_intern(&lf[115],25,"get-environment-variables");
lf[116]=C_h_intern(&lf[116],19,"set-signal-handler!");
lf[117]=C_h_intern(&lf[117],17,"\003syssignal-vector");
lf[118]=C_h_intern(&lf[118],14,"signal-handler");
lf[119]=C_h_intern(&lf[119],18,"current-process-id");
lf[120]=C_h_intern(&lf[120],12,"process-wait");
lf[121]=C_h_intern(&lf[121],16,"\003sysprocess-wait");
lf[122]=C_h_intern(&lf[122],14,"\000process-error");
lf[123]=C_decode_literal(C_heaptop,"\376B\000\000 waiting for child process failed");
lf[124]=C_h_intern(&lf[124],21,"\003sysfile-nonblocking!");
lf[125]=C_h_intern(&lf[125],19,"\003sysfile-select-one");
lf[126]=C_h_intern(&lf[126],8,"pipe/buf");
lf[127]=C_h_intern(&lf[127],11,"fcntl/dupfd");
lf[128]=C_h_intern(&lf[128],11,"fcntl/getfd");
lf[129]=C_h_intern(&lf[129],11,"fcntl/setfd");
lf[130]=C_h_intern(&lf[130],11,"fcntl/getfl");
lf[131]=C_h_intern(&lf[131],11,"fcntl/setfl");
lf[132]=C_h_intern(&lf[132],11,"open/rdonly");
lf[133]=C_h_intern(&lf[133],11,"open/wronly");
lf[134]=C_h_intern(&lf[134],9,"open/rdwr");
lf[135]=C_h_intern(&lf[135],9,"open/read");
lf[136]=C_h_intern(&lf[136],10,"open/write");
lf[137]=C_h_intern(&lf[137],10,"open/creat");
lf[138]=C_h_intern(&lf[138],11,"open/append");
lf[139]=C_h_intern(&lf[139],9,"open/excl");
lf[140]=C_h_intern(&lf[140],11,"open/noctty");
lf[141]=C_h_intern(&lf[141],13,"open/nonblock");
lf[142]=C_h_intern(&lf[142],10,"open/trunc");
lf[143]=C_h_intern(&lf[143],9,"open/sync");
lf[144]=C_h_intern(&lf[144],10,"open/fsync");
lf[145]=C_h_intern(&lf[145],11,"open/binary");
lf[146]=C_h_intern(&lf[146],9,"open/text");
lf[147]=C_h_intern(&lf[147],10,"perm/irusr");
lf[148]=C_h_intern(&lf[148],10,"perm/iwusr");
lf[149]=C_h_intern(&lf[149],10,"perm/ixusr");
lf[150]=C_h_intern(&lf[150],10,"perm/irgrp");
lf[151]=C_h_intern(&lf[151],10,"perm/iwgrp");
lf[152]=C_h_intern(&lf[152],10,"perm/ixgrp");
lf[153]=C_h_intern(&lf[153],10,"perm/iroth");
lf[154]=C_h_intern(&lf[154],10,"perm/iwoth");
lf[155]=C_h_intern(&lf[155],10,"perm/ixoth");
lf[156]=C_h_intern(&lf[156],10,"perm/irwxu");
lf[157]=C_h_intern(&lf[157],10,"perm/irwxg");
lf[158]=C_h_intern(&lf[158],10,"perm/irwxo");
lf[159]=C_h_intern(&lf[159],10,"perm/isvtx");
lf[160]=C_h_intern(&lf[160],10,"perm/isuid");
lf[161]=C_h_intern(&lf[161],10,"perm/isgid");
lf[162]=C_h_intern(&lf[162],12,"file-control");
lf[163]=C_decode_literal(C_heaptop,"\376B\000\000\023cannot control file");
lf[164]=C_h_intern(&lf[164],9,"file-open");
lf[165]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open file");
lf[166]=C_h_intern(&lf[166],10,"file-close");
lf[167]=C_decode_literal(C_heaptop,"\376B\000\000\021cannot close file");
lf[168]=C_h_intern(&lf[168],9,"file-read");
lf[169]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot read from file");
lf[170]=C_decode_literal(C_heaptop,"\376B\000\000(bad argument type - not a string or blob");
lf[171]=C_h_intern(&lf[171],10,"file-write");
lf[172]=C_decode_literal(C_heaptop,"\376B\000\000\024cannot write to file");
lf[173]=C_decode_literal(C_heaptop,"\376B\000\000(bad argument type - not a string or blob");
lf[174]=C_h_intern(&lf[174],12,"file-mkstemp");
lf[175]=C_decode_literal(C_heaptop,"\376B\000\000\034cannot create temporary file");
lf[176]=C_h_intern(&lf[176],11,"file-select");
lf[177]=C_decode_literal(C_heaptop,"\376B\000\000\006failed");
lf[178]=C_h_intern(&lf[178],16,"\003sysfast-reverse");
lf[179]=C_h_intern(&lf[179],3,"max");
lf[180]=C_h_intern(&lf[180],13,"\003sysmake-blob");
lf[181]=C_h_intern(&lf[181],8,"seek/set");
lf[182]=C_h_intern(&lf[182],8,"seek/end");
lf[183]=C_h_intern(&lf[183],8,"seek/cur");
lf[184]=C_h_intern(&lf[184],18,"set-file-position!");
lf[185]=C_decode_literal(C_heaptop,"\376B\000\000\030cannot set file position");
lf[186]=C_decode_literal(C_heaptop,"\376B\000\000\014invalid file");
lf[187]=C_h_intern(&lf[187],5,"port\077");
lf[188]=C_h_intern(&lf[188],13,"\000bounds-error");
lf[189]=C_decode_literal(C_heaptop,"\376B\000\000\036invalid negative port position");
lf[190]=C_h_intern(&lf[190],13,"file-position");
lf[191]=C_h_intern(&lf[191],16,"create-directory");
lf[192]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot create directory");
lf[193]=C_h_intern(&lf[193],18,"pathname-directory");
lf[194]=C_h_intern(&lf[194],12,"file-exists\077");
lf[195]=C_decode_literal(C_heaptop,"\376B\000\000\037cannot change current directory");
lf[196]=C_h_intern(&lf[196],17,"change-directory\052");
lf[197]=C_decode_literal(C_heaptop,"\376B\000\000\037cannot change current directory");
lf[198]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open pipe");
lf[199]=C_decode_literal(C_heaptop,"\376B\000\000\006(pipe)");
lf[200]=C_h_intern(&lf[200],15,"open-input-pipe");
lf[201]=C_h_intern(&lf[201],5,"\000text");
lf[202]=C_h_intern(&lf[202],7,"\000binary");
lf[203]=C_decode_literal(C_heaptop,"\376B\000\000#illegal input/output mode specifier");
lf[204]=C_h_intern(&lf[204],16,"open-output-pipe");
lf[205]=C_h_intern(&lf[205],16,"close-input-pipe");
lf[206]=C_decode_literal(C_heaptop,"\376B\000\000\030error while closing pipe");
lf[207]=C_h_intern(&lf[207],17,"close-output-pipe");
lf[208]=C_decode_literal(C_heaptop,"\376B\000\000\030error while closing pipe");
lf[209]=C_h_intern(&lf[209],20,"call-with-input-pipe");
lf[210]=C_h_intern(&lf[210],21,"call-with-output-pipe");
lf[211]=C_h_intern(&lf[211],20,"with-input-from-pipe");
lf[212]=C_h_intern(&lf[212],18,"\003sysstandard-input");
lf[213]=C_h_intern(&lf[213],19,"with-output-to-pipe");
lf[214]=C_h_intern(&lf[214],19,"\003sysstandard-output");
lf[215]=C_h_intern(&lf[215],11,"create-pipe");
lf[216]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot create pipe");
lf[217]=C_h_intern(&lf[217],11,"signal/term");
lf[218]=C_h_intern(&lf[218],11,"signal/kill");
lf[219]=C_h_intern(&lf[219],10,"signal/int");
lf[220]=C_h_intern(&lf[220],10,"signal/hup");
lf[221]=C_h_intern(&lf[221],10,"signal/fpe");
lf[222]=C_h_intern(&lf[222],10,"signal/ill");
lf[223]=C_h_intern(&lf[223],11,"signal/segv");
lf[224]=C_h_intern(&lf[224],11,"signal/abrt");
lf[225]=C_h_intern(&lf[225],11,"signal/trap");
lf[226]=C_h_intern(&lf[226],11,"signal/quit");
lf[227]=C_h_intern(&lf[227],11,"signal/alrm");
lf[228]=C_h_intern(&lf[228],13,"signal/vtalrm");
lf[229]=C_h_intern(&lf[229],11,"signal/prof");
lf[230]=C_h_intern(&lf[230],9,"signal/io");
lf[231]=C_h_intern(&lf[231],10,"signal/urg");
lf[232]=C_h_intern(&lf[232],11,"signal/chld");
lf[233]=C_h_intern(&lf[233],11,"signal/cont");
lf[234]=C_h_intern(&lf[234],11,"signal/stop");
lf[235]=C_h_intern(&lf[235],11,"signal/tstp");
lf[236]=C_h_intern(&lf[236],11,"signal/pipe");
lf[237]=C_h_intern(&lf[237],11,"signal/xcpu");
lf[238]=C_h_intern(&lf[238],11,"signal/xfsz");
lf[239]=C_h_intern(&lf[239],11,"signal/usr1");
lf[240]=C_h_intern(&lf[240],11,"signal/usr2");
lf[241]=C_h_intern(&lf[241],12,"signal/winch");
lf[242]=C_h_intern(&lf[242],10,"signal/bus");
lf[243]=C_h_intern(&lf[243],12,"signal/break");
lf[244]=C_h_intern(&lf[244],12,"signals-list");
lf[245]=C_h_intern(&lf[245],16,"set-signal-mask!");
lf[246]=C_decode_literal(C_heaptop,"\376B\000\000\026cannot set signal mask");
lf[247]=C_h_intern(&lf[247],11,"signal-mask");
lf[248]=C_h_intern(&lf[248],14,"signal-masked\077");
lf[249]=C_h_intern(&lf[249],12,"signal-mask!");
lf[250]=C_decode_literal(C_heaptop,"\376B\000\000\023cannot block signal");
lf[251]=C_h_intern(&lf[251],14,"signal-unmask!");
lf[252]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot unblock signal");
lf[253]=C_h_intern(&lf[253],18,"system-information");
lf[254]=C_h_intern(&lf[254],25,"\003syspeek-nonnull-c-string");
lf[255]=C_decode_literal(C_heaptop,"\376B\000\000\042cannot retrieve system information");
lf[256]=C_h_intern(&lf[256],15,"current-user-id");
lf[257]=C_h_intern(&lf[257],25,"current-effective-user-id");
lf[258]=C_h_intern(&lf[258],16,"current-group-id");
lf[259]=C_h_intern(&lf[259],26,"current-effective-group-id");
lf[260]=C_h_intern(&lf[260],16,"user-information");
lf[261]=C_h_intern(&lf[261],6,"vector");
lf[262]=C_h_intern(&lf[262],4,"list");
lf[263]=C_h_intern(&lf[263],17,"current-user-name");
lf[264]=C_h_intern(&lf[264],27,"current-effective-user-name");
lf[265]=C_h_intern(&lf[265],17,"group-information");
lf[266]=C_h_intern(&lf[266],10,"get-groups");
lf[267]=C_decode_literal(C_heaptop,"\376B\000\000\047cannot retrieve supplementary group ids");
lf[268]=C_decode_literal(C_heaptop,"\376B\000\000\015out of memory");
lf[269]=C_decode_literal(C_heaptop,"\376B\000\000\047cannot retrieve supplementary group ids");
lf[270]=C_h_intern(&lf[270],11,"set-groups!");
lf[271]=C_decode_literal(C_heaptop,"\376B\000\000\042cannot set supplementary group ids");
lf[272]=C_decode_literal(C_heaptop,"\376B\000\000\015out of memory");
lf[273]=C_h_intern(&lf[273],17,"initialize-groups");
lf[274]=C_decode_literal(C_heaptop,"\376B\000\000)cannot initialize supplementary group ids");
lf[275]=C_h_intern(&lf[275],10,"errno/perm");
lf[276]=C_h_intern(&lf[276],11,"errno/noent");
lf[277]=C_h_intern(&lf[277],10,"errno/srch");
lf[278]=C_h_intern(&lf[278],10,"errno/intr");
lf[279]=C_h_intern(&lf[279],8,"errno/io");
lf[280]=C_h_intern(&lf[280],12,"errno/noexec");
lf[281]=C_h_intern(&lf[281],10,"errno/badf");
lf[282]=C_h_intern(&lf[282],11,"errno/child");
lf[283]=C_h_intern(&lf[283],11,"errno/nomem");
lf[284]=C_h_intern(&lf[284],11,"errno/acces");
lf[285]=C_h_intern(&lf[285],11,"errno/fault");
lf[286]=C_h_intern(&lf[286],10,"errno/busy");
lf[287]=C_h_intern(&lf[287],12,"errno/notdir");
lf[288]=C_h_intern(&lf[288],11,"errno/isdir");
lf[289]=C_h_intern(&lf[289],11,"errno/inval");
lf[290]=C_h_intern(&lf[290],11,"errno/mfile");
lf[291]=C_h_intern(&lf[291],11,"errno/nospc");
lf[292]=C_h_intern(&lf[292],11,"errno/spipe");
lf[293]=C_h_intern(&lf[293],10,"errno/pipe");
lf[294]=C_h_intern(&lf[294],11,"errno/again");
lf[295]=C_h_intern(&lf[295],10,"errno/rofs");
lf[296]=C_h_intern(&lf[296],11,"errno/exist");
lf[297]=C_h_intern(&lf[297],16,"errno/wouldblock");
lf[298]=C_h_intern(&lf[298],10,"errno/2big");
lf[299]=C_h_intern(&lf[299],12,"errno/deadlk");
lf[300]=C_h_intern(&lf[300],9,"errno/dom");
lf[301]=C_h_intern(&lf[301],10,"errno/fbig");
lf[302]=C_h_intern(&lf[302],11,"errno/ilseq");
lf[303]=C_h_intern(&lf[303],11,"errno/mlink");
lf[304]=C_h_intern(&lf[304],17,"errno/nametoolong");
lf[305]=C_h_intern(&lf[305],11,"errno/nfile");
lf[306]=C_h_intern(&lf[306],11,"errno/nodev");
lf[307]=C_h_intern(&lf[307],11,"errno/nolck");
lf[308]=C_h_intern(&lf[308],11,"errno/nosys");
lf[309]=C_h_intern(&lf[309],14,"errno/notempty");
lf[310]=C_h_intern(&lf[310],11,"errno/notty");
lf[311]=C_h_intern(&lf[311],10,"errno/nxio");
lf[312]=C_h_intern(&lf[312],11,"errno/range");
lf[313]=C_h_intern(&lf[313],10,"errno/xdev");
lf[314]=C_h_intern(&lf[314],16,"change-file-mode");
lf[315]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot change file mode");
lf[316]=C_h_intern(&lf[316],17,"change-file-owner");
lf[317]=C_decode_literal(C_heaptop,"\376B\000\000\030cannot change file owner");
lf[318]=C_h_intern(&lf[318],17,"file-read-access\077");
lf[319]=C_h_intern(&lf[319],18,"file-write-access\077");
lf[320]=C_h_intern(&lf[320],20,"file-execute-access\077");
lf[321]=C_h_intern(&lf[321],14,"create-session");
lf[322]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot create session");
lf[323]=C_h_intern(&lf[323],16,"process-group-id");
lf[324]=C_h_intern(&lf[324],20,"create-symbolic-link");
lf[325]=C_h_intern(&lf[325],18,"create-symbol-link");
lf[326]=C_decode_literal(C_heaptop,"\376B\000\000\033cannot create symbolic link");
lf[327]=C_h_intern(&lf[327],22,"\003sysread-symbolic-link");
lf[328]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot read symbolic link");
lf[329]=C_h_intern(&lf[329],9,"substring");
lf[330]=C_h_intern(&lf[330],18,"read-symbolic-link");
lf[331]=C_h_intern(&lf[331],19,"decompose-directory");
lf[332]=C_h_intern(&lf[332],18,"absolute-pathname\077");
lf[333]=C_decode_literal(C_heaptop,"\376B\000\000Icould not canonicalize path with symbolic links, component does not exist");
lf[334]=C_decode_literal(C_heaptop,"\376B\000\000\000");
lf[335]=C_decode_literal(C_heaptop,"\376B\000\000\000");
lf[336]=C_h_intern(&lf[336],9,"file-link");
lf[337]=C_h_intern(&lf[337],9,"hard-link");
lf[338]=C_decode_literal(C_heaptop,"\376B\000\000\032could not create hard link");
lf[339]=C_h_intern(&lf[339],21,"\003syscustom-input-port");
lf[340]=C_h_intern(&lf[340],4,"void");
lf[341]=C_decode_literal(C_heaptop,"\376B\000\000\015cannot select");
lf[342]=C_h_intern(&lf[342],3,"rx=");
lf[343]=C_h_intern(&lf[343],17,"\003systhread-yield!");
lf[344]=C_h_intern(&lf[344],25,"\003systhread-block-for-i/o!");
lf[345]=C_h_intern(&lf[345],18,"\003syscurrent-thread");
lf[346]=C_h_intern(&lf[346],6,"\000input");
lf[347]=C_h_intern(&lf[347],22,"\003sysdispatch-interrupt");
lf[348]=C_decode_literal(C_heaptop,"\376B\000\000\013cannot read");
lf[349]=C_decode_literal(C_heaptop,"\376B\000\000\013cannot read");
lf[350]=C_h_intern(&lf[350],14,"set-port-name!");
lf[351]=C_decode_literal(C_heaptop,"\376B\000\000\014cannot close");
lf[352]=C_h_intern(&lf[352],20,"\003sysscan-buffer-line");
lf[353]=C_decode_literal(C_heaptop,"\376B\000\000\000");
lf[354]=C_h_intern(&lf[354],15,"make-input-port");
lf[355]=C_h_intern(&lf[355],22,"\003syscustom-output-port");
lf[356]=C_decode_literal(C_heaptop,"\376B\000\000\014cannot write");
lf[357]=C_decode_literal(C_heaptop,"\376B\000\000\014cannot close");
lf[358]=C_h_intern(&lf[358],16,"make-output-port");
lf[359]=C_h_intern(&lf[359],13,"file-truncate");
lf[360]=C_decode_literal(C_heaptop,"\376B\000\000\024cannot truncate file");
lf[361]=C_decode_literal(C_heaptop,"\376B\000\000\014invalid file");
lf[362]=C_h_intern(&lf[362],4,"lock");
lf[363]=C_h_intern(&lf[363],14,"\003syscheck-port");
lf[364]=C_h_intern(&lf[364],9,"file-lock");
lf[365]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot lock file");
lf[366]=C_h_intern(&lf[366],18,"file-lock/blocking");
lf[367]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot lock file");
lf[368]=C_h_intern(&lf[368],14,"file-test-lock");
lf[369]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot unlock file");
lf[370]=C_h_intern(&lf[370],11,"file-unlock");
lf[371]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot unlock file");
lf[372]=C_h_intern(&lf[372],11,"create-fifo");
lf[373]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot create FIFO");
lf[374]=C_decode_literal(C_heaptop,"\376B\000\000\023file does not exist");
lf[375]=C_decode_literal(C_heaptop,"\376B\000\000(system error while trying to access file");
lf[376]=C_h_intern(&lf[376],9,"prot/read");
lf[377]=C_h_intern(&lf[377],10,"prot/write");
lf[378]=C_h_intern(&lf[378],9,"prot/exec");
lf[379]=C_h_intern(&lf[379],9,"prot/none");
lf[380]=C_h_intern(&lf[380],9,"map/fixed");
lf[381]=C_h_intern(&lf[381],10,"map/shared");
lf[382]=C_h_intern(&lf[382],11,"map/private");
lf[383]=C_h_intern(&lf[383],13,"map/anonymous");
lf[384]=C_h_intern(&lf[384],8,"map/file");
lf[385]=C_h_intern(&lf[385],18,"map-file-to-memory");
lf[386]=C_h_intern(&lf[386],4,"mmap");
lf[387]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot map file to memory");
lf[388]=C_h_intern(&lf[388],20,"\003syspointer->address");
lf[389]=C_decode_literal(C_heaptop,"\376B\000\000)bad argument type - not a foreign pointer");
lf[390]=C_h_intern(&lf[390],16,"\003sysnull-pointer");
lf[391]=C_h_intern(&lf[391],22,"unmap-file-from-memory");
lf[392]=C_decode_literal(C_heaptop,"\376B\000\000\035cannot unmap file from memory");
lf[393]=C_h_intern(&lf[393],26,"memory-mapped-file-pointer");
lf[394]=C_h_intern(&lf[394],19,"memory-mapped-file\077");
lf[395]=C_h_intern(&lf[395],12,"string->time");
lf[396]=C_decode_literal(C_heaptop,"\376B\000\000\027%a %b %e %H:%M:%S %Z %Y");
lf[397]=C_h_intern(&lf[397],17,"utc-time->seconds");
lf[398]=C_decode_literal(C_heaptop,"\376B\000\000%cannot convert time vector to seconds");
lf[399]=C_h_intern(&lf[399],27,"local-timezone-abbreviation");
lf[400]=C_h_intern(&lf[400],5,"_exit");
lf[401]=C_h_intern(&lf[401],10,"set-alarm!");
lf[402]=C_h_intern(&lf[402],19,"set-buffering-mode!");
lf[403]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot set buffering mode");
lf[404]=C_h_intern(&lf[404],5,"\000full");
lf[405]=C_h_intern(&lf[405],5,"\000line");
lf[406]=C_h_intern(&lf[406],5,"\000none");
lf[407]=C_decode_literal(C_heaptop,"\376B\000\000\026invalid buffering-mode");
lf[408]=C_h_intern(&lf[408],14,"terminal-port\077");
lf[410]=C_decode_literal(C_heaptop,"\376B\000\000#port is not connected to a terminal");
lf[411]=C_h_intern(&lf[411],13,"terminal-name");
lf[412]=C_h_intern(&lf[412],13,"terminal-size");
lf[413]=C_h_intern(&lf[413],6,"\000error");
lf[414]=C_decode_literal(C_heaptop,"\376B\000\000\036Unable to get size of terminal");
lf[415]=C_h_intern(&lf[415],17,"\003sysmake-locative");
lf[416]=C_h_intern(&lf[416],8,"location");
lf[417]=C_h_intern(&lf[417],13,"get-host-name");
lf[418]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot retrieve host-name");
lf[419]=C_h_intern(&lf[419],12,"process-fork");
lf[420]=C_h_intern(&lf[420],22,"\003syskill-other-threads");
lf[421]=C_decode_literal(C_heaptop,"\376B\000\000\033cannot create child process");
lf[422]=C_h_intern(&lf[422],24,"pathname-strip-directory");
lf[423]=C_h_intern(&lf[423],15,"process-execute");
lf[424]=C_decode_literal(C_heaptop,"\376B\000\000\026cannot execute process");
lf[425]=C_h_intern(&lf[425],17,"parent-process-id");
lf[426]=C_h_intern(&lf[426],5,"sleep");
lf[427]=C_h_intern(&lf[427],14,"process-signal");
lf[428]=C_decode_literal(C_heaptop,"\376B\000\000 could not send signal to process");
lf[429]=C_h_intern(&lf[429],17,"\003sysshell-command");
lf[430]=C_decode_literal(C_heaptop,"\376B\000\000\007/bin/sh");
lf[431]=C_h_intern(&lf[431],24,"get-environment-variable");
lf[432]=C_decode_literal(C_heaptop,"\376B\000\000\005SHELL");
lf[433]=C_h_intern(&lf[433],27,"\003sysshell-command-arguments");
lf[434]=C_decode_literal(C_heaptop,"\376B\000\000\002-c");
lf[435]=C_h_intern(&lf[435],11,"process-run");
lf[436]=C_decode_literal(C_heaptop,"\376B\000\000\025abnormal process exit");
lf[437]=C_h_intern(&lf[437],11,"\003sysprocess");
lf[438]=C_h_intern(&lf[438],7,"process");
lf[439]=C_h_intern(&lf[439],8,"process\052");
lf[440]=C_h_intern(&lf[440],6,"values");
lf[441]=C_h_intern(&lf[441],19,"set-root-directory!");
lf[442]=C_decode_literal(C_heaptop,"\376B\000\000\037unable to change root directory");
lf[443]=C_decode_literal(C_heaptop,"\376B\000\000 cannot retrieve process group ID");
lf[444]=C_h_intern(&lf[444],21,"set-process-group-id!");
lf[445]=C_decode_literal(C_heaptop,"\376B\000\000\033cannot set process group ID");
lf[446]=C_h_intern(&lf[446],18,"getter-with-setter");
lf[447]=C_decode_literal(C_heaptop,"\376B\000\000\026(process-group-id pid)");
lf[448]=C_h_intern(&lf[448],26,"effective-group-id!-setter");
lf[449]=C_decode_literal(C_heaptop,"\376B\000\000\035cannot set effective group ID");
lf[450]=C_decode_literal(C_heaptop,"\376B\000\000\034(current-effective-group-id)");
lf[451]=C_h_intern(&lf[451],12,"set-user-id!");
lf[452]=C_decode_literal(C_heaptop,"\376B\000\000\023cannot set group ID");
lf[453]=C_decode_literal(C_heaptop,"\376B\000\000\022(current-group-id)");
lf[454]=C_h_intern(&lf[454],25,"effective-user-id!-setter");
lf[455]=C_decode_literal(C_heaptop,"\376B\000\000\034cannot set effective user ID");
lf[456]=C_decode_literal(C_heaptop,"\376B\000\000\033(current-effective-used-id)");
lf[457]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot set user ID");
lf[458]=C_decode_literal(C_heaptop,"\376B\000\000\021(current-user-id)");
lf[459]=C_decode_literal(C_heaptop,"\376B\000\000%cannot retrieve file position of port");
lf[460]=C_decode_literal(C_heaptop,"\376B\000\000\014invalid file");
lf[461]=C_decode_literal(C_heaptop,"\376B\000\000\024(file-position port)");
lf[462]=C_decode_literal(C_heaptop,"\376B\000\000\031(file-creation-mode mode)");
lf[463]=C_h_intern(&lf[463],26,"set-file-modification-time");
lf[464]=C_decode_literal(C_heaptop,"\376B\000\000!cannot set file modification-time");
lf[465]=C_decode_literal(C_heaptop,"\376B\000\000\032(file-modification-time f)");
C_register_lf2(lf,466,create_ptable());
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2644,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
C_scheduler_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* file-truncate in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_6923(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[15],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_6923,4,t0,t1,t2,t3);}
t4=C_i_check_number_2(t3,lf[359]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6933,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6940,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_i_stringp(t2))){
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6947,a[2]=t3,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6951,a[2]=t7,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1406: ##sys#expand-home-path */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(3,*((C_word*)lf[12]+1),t8,t2);}
else{
if(C_truep(C_fixnump(t2))){
t7=C_ftruncate(t2,t3);
t8=t5;
f_6933(t8,C_fixnum_lessp(t7,C_fix(0)));}
else{
/* posixunix.scm:1408: ##sys#error */
t7=*((C_word*)lf[41]+1);
((C_proc5)(void*)(*((C_word*)t7+1)))(5,t7,t6,lf[359],lf[361],t2);}}}

/* k5111 in close-input-pipe in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5113(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[3]);}

/* k6191 in k6176 in ready? in k6171 in k6165 in custom-input-port in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 in ... */
static void C_ccall f_6193(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}
else{
/* posixunix.scm:1230: posix-error */
t2=lf[0];
f_2668(7,t2,((C_word*)t0)[2],lf[8],((C_word*)t0)[3],lf[341],((C_word*)t0)[4],((C_word*)t0)[5]);}}

/* connect-child in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_8153(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_8153,NULL,4,t1,t2,t3,t4);}
if(C_truep(t3)){
t5=C_i_car(t2);
t6=t5;
t7=t2;
t8=C_u_i_cdr(t7);
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_8164,a[2]=t1,a[3]=t6,a[4]=t4,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1789: file-close */
t10=*((C_word*)lf[166]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t9,t8);}
else{
t5=C_SCHEME_UNDEFINED;
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}}

/* k8150 in connect-parent in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8152(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[3]);}

/* close-output-pipe in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5121(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5121,3,t0,t1,t2);}
t3=t2;
t4=C_i_check_port_2(t3,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[207]);
t5=close_pipe(t2);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5128,a[2]=t1,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
t7=C_eqp(C_fix(-1),t5);
if(C_truep(t7)){
/* posixunix.scm:742: posix-error */
t8=lf[0];
f_2668(6,t8,t6,lf[8],lf[207],lf[208],t2);}
else{
t8=t1;
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,t5);}}

/* k5126 in close-output-pipe in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5128(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[3]);}

/* connect-parent in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_8141(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_8141,NULL,3,t1,t2,t3);}
if(C_truep(t3)){
t4=C_i_car(t2);
t5=t4;
t6=t2;
t7=C_u_i_cdr(t6);
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8152,a[2]=t1,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1783: file-close */
t9=*((C_word*)lf[166]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t7);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_FALSE);}}

/* k6176 in ready? in k6171 in k6165 in custom-input-port in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_6178(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6178,2,t0,t1);}
t2=C_eqp(C_fix(-1),t1);
if(C_truep(t2)){
t3=C_eqp(C_fix((C_word)errno),C_fix((C_word)EWOULDBLOCK));
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6193,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
if(C_truep(t3)){
t5=t4;
f_6193(2,t5,t3);}
else{
/* posixunix.scm:1228: rx= */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[342]+1)))(4,*((C_word*)lf[342]+1),t4,C_fix((C_word)errno),C_fix((C_word)EAGAIN));}}
else{
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_eqp(C_fix(1),t1));}}

/* k6982 in k6976 in setup in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_6984(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6984,NULL,2,t0,t1);}
t2=C_slot(((C_word*)t0)[2],C_fix(1));
t3=(C_truep(t2)?C_fix((C_word)F_RDLCK):C_fix((C_word)F_WRLCK));
t4=C_flock_setup(t3,((C_word*)t0)[3],((C_word*)((C_word*)t0)[4])[1]);
t5=((C_word*)t0)[5];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_a_i_record4(&a,4,lf[362],((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)((C_word*)t0)[4])[1]));}

/* k6976 in setup in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_6978(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6978,2,t0,t1);}
t2=C_i_check_number_2(((C_word*)t0)[2],((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6984,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],tmp=(C_word)a,a+=6,tmp);
t4=C_eqp(C_SCHEME_TRUE,((C_word*)((C_word*)t0)[5])[1]);
if(C_truep(t4)){
t5=C_set_block_item(((C_word*)t0)[5],0,C_fix(0));
t6=t3;
f_6984(t6,t5);}
else{
t5=t3;
f_6984(t5,C_i_check_number_2(((C_word*)((C_word*)t0)[5])[1],((C_word*)t0)[3]));}}

/* k6171 in k6165 in custom-input-port in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_6173(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word ab[81],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6173,2,t0,t1);}
t2=t1;
t3=C_fix(0);
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_fix(0);
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6174,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word)li139),tmp=(C_word)a,a+=6,tmp);
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6203,a[2]=t6,a[3]=t4,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t9=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_6211,a[2]=((C_word*)t0)[3],a[3]=t2,a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[2],a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[6],a[8]=t4,a[9]=t6,a[10]=((C_word)li141),tmp=(C_word)a,a+=11,tmp);
t10=C_SCHEME_UNDEFINED;
t11=(*a=C_VECTOR_TYPE|1,a[1]=t10,tmp=(C_word)a,a+=2,tmp);
t12=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6307,a[2]=t11,a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t13=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6313,a[2]=t8,a[3]=t6,a[4]=t4,a[5]=t9,a[6]=((C_word)li142),tmp=(C_word)a,a+=7,tmp);
t14=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6338,a[2]=t6,a[3]=t4,a[4]=t7,a[5]=((C_word)li143),tmp=(C_word)a,a+=6,tmp);
t15=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6350,a[2]=t11,a[3]=((C_word*)t0)[8],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[2],a[6]=((C_word*)t0)[4],a[7]=((C_word)li144),tmp=(C_word)a,a+=8,tmp);
t16=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6372,a[2]=t8,a[3]=t6,a[4]=t4,a[5]=t9,a[6]=((C_word)li145),tmp=(C_word)a,a+=7,tmp);
t17=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6387,a[2]=t6,a[3]=t4,a[4]=t2,a[5]=t9,a[6]=((C_word)li147),tmp=(C_word)a,a+=7,tmp);
t18=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6463,a[2]=t6,a[3]=t4,a[4]=t2,a[5]=t9,a[6]=((C_word)li151),tmp=(C_word)a,a+=7,tmp);
t19=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6586,a[2]=t6,a[3]=t4,a[4]=t2,a[5]=((C_word)li152),tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:1269: make-input-port */
t20=*((C_word*)lf[354]+1);
((C_proc9)(void*)(*((C_word*)t20+1)))(9,t20,t12,t13,t14,t15,t16,t17,t18,t19);}

/* ready? in k6171 in k6165 in custom-input-port in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_6174(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6174,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6178,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:1225: ##sys#file-select-one */
t3=*((C_word*)lf[125]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[3]);}

/* k4245 in k4232 in file-open in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_4247(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4247,2,t0,t1);}
t2=C_open(t1,((C_word*)t0)[2],((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4250,a[2]=((C_word*)t0)[4],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
/* posixunix.scm:516: posix-error */
t5=lf[0];
f_2668(8,t5,t3,lf[8],lf[164],lf[165],((C_word*)t0)[5],((C_word*)t0)[2],((C_word*)t0)[3]);}
else{
t5=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t2);}}

/* swapped-ends in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static C_word C_fcall f_8168(C_word *a,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_stack_overflow_check;
if(C_truep(t1)){
t2=C_i_cdr(t1);
t3=t1;
t4=C_u_i_car(t3);
return(C_a_i_cons(&a,2,t2,t4));}
else{
return(C_SCHEME_FALSE);}}

/* k8162 in connect-child in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8164(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8164,2,t0,t1);}
t2=((C_word*)t0)[2];
t3=((C_word*)t0)[3];
t4=((C_word*)t0)[4];
t5=C_eqp(t4,t3);
if(C_truep(t5)){
t6=C_SCHEME_UNDEFINED;
t7=t2;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}
else{
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8080,a[2]=t2,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1763: duplicate-fileno */
t7=*((C_word*)lf[59]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t6,t3,t4);}}

/* k4248 in k4245 in k4232 in file-open in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_4250(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[3]);}

/* setup in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_6962(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6962,NULL,4,t1,t2,t3,t4);}
t5=C_i_nullp(t3);
t6=(C_truep(t5)?C_fix(0):C_i_car(t3));
t7=t6;
t8=C_i_nullp(t3);
t9=(C_truep(t8)?C_SCHEME_END_OF_LIST:C_i_cdr(t3));
t10=C_i_nullp(t9);
t11=(C_truep(t10)?C_SCHEME_TRUE:C_i_car(t9));
t12=t11;
t13=(*a=C_VECTOR_TYPE|1,a[1]=t12,tmp=(C_word)a,a+=2,tmp);
t14=C_i_nullp(t9);
t15=(C_truep(t14)?C_SCHEME_END_OF_LIST:C_i_cdr(t9));
t16=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6978,a[2]=t7,a[3]=t4,a[4]=t2,a[5]=t13,a[6]=t1,tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm:1423: ##sys#check-port */
t17=*((C_word*)lf[363]+1);
((C_proc4)(void*)(*((C_word*)t17+1)))(4,t17,t16,t2,t4);}

/* file-close in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_4266(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4266,3,t0,t1,t2);}
t3=C_i_check_exact_2(t2,lf[166]);
t4=C_close(t2);
if(C_truep(C_fixnum_lessp(t4,C_fix(0)))){
/* posixunix.scm:523: posix-error */
t5=lf[0];
f_2668(6,t5,t1,lf[8],lf[166],lf[167],t2);}
else{
t5=C_SCHEME_UNDEFINED;
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}}

/* k4258 in k4232 in file-open in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_4260(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:514: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),((C_word*)t0)[2],t1,lf[164]);}

/* k6949 in file-truncate in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_6951(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1406: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),((C_word*)t0)[2],t1,lf[359]);}

/* a8100 */
static void C_ccall f_8101(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8101,2,t0,t1);}
/* posixunix.scm:1771: ##sys#process-wait */
t2=*((C_word*)lf[121]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,((C_word*)t0)[2],C_SCHEME_FALSE);}

/* a8106 */
static void C_ccall f_8107(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_8107,5,t0,t1,t2,t3,t4);}
if(C_truep(t3)){
t5=C_SCHEME_UNDEFINED;
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
/* posixunix.scm:1773: ##sys#signal-hook */
t5=*((C_word*)lf[1]+1);
((C_proc7)(void*)(*((C_word*)t5+1)))(7,t5,t1,lf[122],((C_word*)t0)[2],lf[436],((C_word*)t0)[3],t4);}}

/* a8135 in needed-pipe in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8136(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word ab[3],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_8136,4,t0,t1,t2,t3);}
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_a_i_cons(&a,2,t2,t3));}

/* a8129 in needed-pipe in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8130(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8130,2,t0,t1);}
/* posixunix.scm:1778: create-pipe */
t2=*((C_word*)lf[215]+1);
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}

/* f_8086 in make-on-close in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8086(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[9],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8086,2,t0,t1);}
t2=C_i_vector_set(((C_word*)t0)[2],((C_word*)t0)[3],C_SCHEME_TRUE);
t3=C_i_vector_ref(((C_word*)t0)[2],((C_word*)t0)[4]);
t4=(C_truep(t3)?C_i_vector_ref(((C_word*)t0)[2],((C_word*)t0)[5]):C_SCHEME_FALSE);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8101,a[2]=((C_word*)t0)[6],a[3]=((C_word)li203),tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_8107,a[2]=((C_word*)t0)[7],a[3]=((C_word*)t0)[6],a[4]=((C_word)li204),tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1771: ##sys#call-with-values */
C_call_with_values(4,0,t1,t5,t6);}
else{
t5=C_SCHEME_UNDEFINED;
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}}

/* make-on-close in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_8084(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_8084,NULL,7,t1,t2,t3,t4,t5,t6,t7);}
t8=t1;
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_8086,a[2]=t4,a[3]=t5,a[4]=t6,a[5]=t7,a[6]=t3,a[7]=t2,a[8]=((C_word)li205),tmp=(C_word)a,a+=9,tmp));}

/* k8078 in k8162 in connect-child in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8080(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1764: file-close */
t2=*((C_word*)lf[166]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],((C_word*)t0)[3]);}

/* file-read in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_4282(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_4282r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_4282r(t0,t1,t2,t3,t4);}}

static void C_ccall f_4282r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(5);
t5=C_i_check_exact_2(t2,lf[168]);
t6=C_i_check_exact_2(t3,lf[168]);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4292,a[2]=t2,a[3]=t3,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_pairp(t4))){
t8=t4;
t9=t7;
f_4292(2,t9,C_u_i_car(t8));}
else{
t8=t3;
/* ##sys#make-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[65]+1)))(4,*((C_word*)lf[65]+1),t7,t8,C_make_character(32));}}

/* needed-pipe in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_8121(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_8121,NULL,2,t1,t2);}
if(C_truep(t2)){
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8130,a[2]=((C_word)li207),tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8136,a[2]=((C_word)li208),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1776: ##sys#call-with-values */
C_call_with_values(4,0,t1,t3,t4);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_FALSE);}}

/* k4296 in k4293 in k4290 in file-read in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_4298(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4298,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_i_list2(&a,2,((C_word*)t0)[3],((C_word*)t0)[4]));}

/* k4293 in k4290 in file-read in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_4295(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4295,2,t0,t1);}
t2=C_read(((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)t0)[4]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4298,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t4=C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
/* posixunix.scm:534: posix-error */
t5=lf[0];
f_2668(7,t5,t3,lf[8],lf[168],lf[169],((C_word*)t0)[2],((C_word*)t0)[4]);}
else{
t5=((C_word*)t0)[5];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_a_i_list2(&a,2,((C_word*)t0)[3],t2));}}

/* k4290 in file-read in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_4292(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4292,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4295,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
if(C_truep(C_blockp(t2))){
if(C_truep(C_byteblockp(t2))){
t4=t3;
f_4295(2,t4,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm:531: ##sys#signal-hook */
t4=*((C_word*)lf[1]+1);
((C_proc6)(void*)(*((C_word*)t4+1)))(6,t4,t3,lf[13],lf[168],lf[170],t2);}}
else{
/* posixunix.scm:531: ##sys#signal-hook */
t4=*((C_word*)lf[1]+1);
((C_proc6)(void*)(*((C_word*)t4+1)))(6,t4,t3,lf[13],lf[168],lf[170],t2);}}

/* a5192 in k5186 in with-input-from-pipe in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5193(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5193,2,t0,t1);}
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,*((C_word*)lf[212]+1));
t3=C_mutate2((C_word*)lf[212]+1 /* (set! ##sys#standard-input ...) */,((C_word*)((C_word*)t0)[3])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}

/* a5197 in k5186 in with-input-from-pipe in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5198(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5198,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5204,a[2]=((C_word*)t0)[2],a[3]=((C_word)li99),tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:767: ##sys#call-with-values */
C_call_with_values(4,0,t1,((C_word*)t0)[3],t2);}

/* file-link in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_6117(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word ab[9],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_6117,4,t0,t1,t2,t3);}
t4=C_i_check_string_2(t2,lf[336]);
t5=C_i_check_string_2(t3,lf[336]);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6137,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t7=t6;
t8=t2;
t9=t3;
t10=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6098,a[2]=t7,a[3]=t9,tmp=(C_word)a,a+=4,tmp);
if(C_truep(t8)){
t11=C_i_foreign_string_argumentp(t8);
/* posixunix.scm:1208: ##sys#make-c-string */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(3,*((C_word*)lf[10]+1),t10,t11);}
else{
t11=t10;
f_6098(2,t11,C_SCHEME_FALSE);}}

/* chkstrlst in %process in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_8307(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_8307,NULL,3,t0,t1,t2);}
t3=C_i_check_list_2(t2,((C_word*)t0)[2]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8312,a[2]=((C_word*)t0)[2],a[3]=((C_word)li220),tmp=(C_word)a,a+=4,tmp);
t5=t2;
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8321,a[2]=t4,a[3]=((C_word)li221),tmp=(C_word)a,a+=4,tmp);
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,f_8321(t6,t5));}

/* %process in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_8305(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word ab[23],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_8305,NULL,7,t1,t2,t3,t4,t5,t6,t7);}
t8=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t9=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t10=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8307,a[2]=t2,a[3]=((C_word)li222),tmp=(C_word)a,a+=4,tmp);
t11=C_i_check_string_2(((C_word*)t8)[1],t2);
t12=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_8348,a[2]=t2,a[3]=t8,a[4]=t9,a[5]=t6,a[6]=t3,a[7]=t1,a[8]=t7,a[9]=t10,tmp=(C_word)a,a+=10,tmp);
if(C_truep(((C_word*)t9)[1])){
/* posixunix.scm:1846: chkstrlst */
t13=t10;
f_8307(t13,t12,((C_word*)t9)[1]);}
else{
t13=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_8370,a[2]=t9,a[3]=t8,a[4]=t12,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1848: ##sys#shell-command-arguments */
t14=*((C_word*)lf[433]+1);
((C_proc3)(void*)(*((C_word*)t14+1)))(3,t14,t13,((C_word*)t8)[1]);}}

/* ##sys#terminal-check in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_7543(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7543,NULL,3,t1,t2,t3);}
t4=t3;
t5=t2;
t6=C_i_check_port_2(t4,C_fix(0),C_SCHEME_TRUE,t5);
t7=C_slot(t3,C_fix(7));
t8=C_eqp(lf[51],t7);
t9=(C_truep(t8)?C_tty_portp(t3):C_SCHEME_FALSE);
if(C_truep(t9)){
t10=C_SCHEME_UNDEFINED;
t11=t1;
((C_proc2)(void*)(*((C_word*)t11+1)))(2,t11,t10);}
else{
/* posixunix.scm:1604: ##sys#error */
t10=*((C_word*)lf[41]+1);
((C_proc5)(void*)(*((C_word*)t10+1)))(5,t10,t1,t2,lf[410],t3);}}

/* k6100 in k6096 in file-link in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_6102(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,stub1374(C_SCHEME_UNDEFINED,((C_word*)t0)[3],t1));}

/* k3983 in loop in get-environment-variables in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3985(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3985,2,t0,t1);}
t2=t1;
if(C_truep(t2)){
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3993,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=t4,a[6]=((C_word)li59),tmp=(C_word)a,a+=7,tmp));
t6=((C_word*)t4)[1];
f_3993(t6,((C_word*)t0)[4],C_fix(0));}
else{
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_END_OF_LIST);}}

/* loop in get-environment-variables in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_3981(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3981,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3985,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=t2;
t5=C_a_i_bytevector(&a,1,C_fix(3));
t6=C_i_foreign_fixnum_argumentp(t4);
t7=stub566(t5,t6);
/* posix-common.scm:573: ##sys#peek-c-string */
t8=*((C_word*)lf[4]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t3,t7,C_fix(0));}

/* k4232 in file-open in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_4234(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4234,NULL,2,t0,t1);}
t2=t1;
t3=C_i_check_string_2(((C_word*)t0)[2],lf[164]);
t4=C_i_check_exact_2(((C_word*)t0)[3],lf[164]);
t5=C_i_check_exact_2(t2,lf[164]);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4247,a[2]=((C_word*)t0)[3],a[3]=t2,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[2],tmp=(C_word)a,a+=6,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4260,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:514: ##sys#expand-home-path */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(3,*((C_word*)lf[12]+1),t7,((C_word*)t0)[2]);}

/* file-open in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_4230(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_4230r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_4230r(t0,t1,t2,t3,t4);}}

static void C_ccall f_4230r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4234,a[2]=t2,a[3]=t3,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_pairp(t4))){
t6=t4;
t7=t5;
f_4234(t7,C_u_i_car(t6));}
else{
t6=t5;
f_4234(t6,((C_word*)t0)[2]);}}

/* a5174 in k5162 in call-with-output-pipe in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5175(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_5175r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_5175r(t0,t1,t2);}}

static void C_ccall f_5175r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5179,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:760: close-output-pipe */
t4=*((C_word*)lf[207]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k5177 in a5174 in k5162 in call-with-output-pipe in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5179(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply_values(3,0,((C_word*)t0)[2],((C_word*)t0)[3]);}

/* k7529 in terminal-port? in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7531(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_eqp(C_fix(0),t1);
if(C_truep(t2)){
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_FALSE);}
else{
t3=C_tty_portp(((C_word*)t0)[3]);
t4=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* for-each-loop2071 in chkstrlst in %process in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static C_word C_fcall f_8321(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_stack_overflow_check;
loop:
if(C_truep(C_i_pairp(t1))){
t2=C_slot(t1,C_fix(0));
t3=f_8312(((C_word*)t0)[2],t2);
t4=C_slot(t1,C_fix(1));
t7=t4;
t1=t7;
goto loop;}
else{
t2=C_SCHEME_UNDEFINED;
return(t2);}}

/* scan in k3983 in loop in get-environment-variables in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_3993(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
loop:
a=C_alloc(7);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_3993,NULL,3,t0,t1,t2);}
t3=C_subchar(((C_word*)t0)[2],t2);
if(C_truep(C_i_char_equalp(C_make_character(61),t3))){
t4=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4019,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,a[6]=((C_word*)t0)[2],tmp=(C_word)a,a+=7,tmp);
/* posix-common.scm:580: ##sys#substring */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[63]+1)))(5,*((C_word*)lf[63]+1),t4,((C_word*)t0)[2],C_fix(0),t2);}
else{
t4=C_fixnum_plus(t2,C_fix(1));
/* posix-common.scm:583: scan */
t7=t1;
t8=t4;
t1=t7;
t2=t8;
goto loop;}}

/* close-input-pipe in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5106(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5106,3,t0,t1,t2);}
t3=t2;
t4=C_i_check_port_2(t3,C_SCHEME_TRUE,C_SCHEME_TRUE,lf[205]);
t5=close_pipe(t2);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5113,a[2]=t1,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
t7=C_eqp(C_fix(-1),t5);
if(C_truep(t7)){
/* posixunix.scm:735: posix-error */
t8=lf[0];
f_2668(6,t8,t6,lf[8],lf[205],lf[206],t2);}
else{
t8=t1;
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,t5);}}

/* g2072 in chkstrlst in %process in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static C_word C_fcall f_8312(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_stack_overflow_check;
return(C_i_check_string_2(t1,((C_word*)t0)[2]));}

/* k3481 in k3478 in k3686 in k3683 in k3680 in k3677 in k3674 in k3671 in find-files in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_3483(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3483,NULL,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_3490,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],tmp=(C_word)a,a+=10,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3636,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
if(C_truep(((C_word*)t0)[5])){
/* posix-common.scm:465: make-pathname */
t5=*((C_word*)lf[77]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t4,((C_word*)t0)[9],lf[89]);}
else{
/* posix-common.scm:465: make-pathname */
t5=*((C_word*)lf[77]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t4,((C_word*)t0)[9],lf[90]);}}

/* k3478 in k3686 in k3683 in k3680 in k3677 in k3674 in k3671 in find-files in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_3480(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3480,NULL,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_3483,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t2,a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],tmp=(C_word)a,a+=10,tmp);
if(C_truep(C_i_closurep(((C_word*)t0)[9]))){
t4=t3;
f_3483(t4,((C_word*)t0)[9]);}
else{
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3646,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:463: irregex */
t5=*((C_word*)lf[91]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,((C_word*)t0)[9]);}}

/* k8346 in %process in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8348(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8348,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_8351,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],tmp=(C_word)a,a+=9,tmp);
if(C_truep(((C_word*)t0)[5])){
/* posixunix.scm:1850: chkstrlst */
t3=((C_word*)t0)[9];
f_8307(t3,t2,((C_word*)t0)[5]);}
else{
t3=t2;
f_8351(2,t3,C_SCHEME_UNDEFINED);}}

/* k6945 in file-truncate in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_6947(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_truncate(t1,((C_word*)t0)[2]);
t3=((C_word*)t0)[3];
f_6933(t3,C_fixnum_lessp(t2,C_fix(0)));}

/* loop in k3488 in k3481 in k3478 in k3686 in k3683 in k3680 in k3677 in k3674 in k3671 in find-files in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_3492(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3492,NULL,4,t0,t1,t2,t3);}
if(C_truep(C_i_nullp(t2))){
t4=t3;
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=C_slot(t2,C_fix(0));
t5=t4;
t6=C_slot(t2,C_fix(1));
t7=t6;
t8=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_3511,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t7,a[5]=t3,a[6]=((C_word*)t0)[3],a[7]=((C_word*)t0)[4],a[8]=t5,a[9]=((C_word*)t0)[5],a[10]=((C_word*)t0)[6],a[11]=((C_word*)t0)[7],a[12]=((C_word*)t0)[8],tmp=(C_word)a,a+=13,tmp);
/* posix-common.scm:471: directory? */
t9=*((C_word*)lf[36]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t5);}}

/* k3488 in k3481 in k3478 in k3686 in k3683 in k3680 in k3677 in k3674 in k3671 in find-files in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3490(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3490,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_3492,a[2]=t3,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word)li38),tmp=(C_word)a,a+=10,tmp));
t5=((C_word*)t3)[1];
f_3492(t5,((C_word*)t0)[8],t1,((C_word*)t0)[9]);}

/* k7576 in terminal-name in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7578(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7578,2,t0,t1);}
t2=C_C_fileno(((C_word*)t0)[2]);
t3=((C_word*)t0)[3];
t4=C_a_i_bytevector(&a,1,C_fix(3));
t5=C_i_foreign_fixnum_argumentp(t2);
t6=stub1788(t4,t5);
/* posixunix.scm:1607: ##sys#peek-nonnull-c-string */
t7=*((C_word*)lf[254]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t3,t6,C_fix(0));}

/* terminal-name in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7574(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7574,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7578,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1609: ##sys#terminal-check */
f_7543(t3,lf[411],t2);}

/* k6938 in file-truncate in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_6940(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
f_6933(t2,C_fixnum_lessp(t1,C_fix(0)));}

/* k6931 in file-truncate in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_6933(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
/* posixunix.scm:1410: posix-error */
t2=lf[0];
f_2668(7,t2,((C_word*)t0)[2],lf[8],lf[359],lf[360],((C_word*)t0)[3],((C_word*)t0)[4]);}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* a8598 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8599(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8599,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,stub1136(C_SCHEME_UNDEFINED));}

/* k8591 in a8582 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8593(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:935: ##sys#error */
t2=*((C_word*)lf[41]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[454],lf[455],((C_word*)t0)[3]);}

/* k8349 in k8346 in %process in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8351(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8351,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_8356,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word)li223),tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm:1851: ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[7],t2,((C_word*)t0)[8]);}

/* a8355 in k8349 in k8346 in %process in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8356(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8356,2,t0,t1);}
/* posixunix.scm:1852: ##sys#process */
t2=*((C_word*)lf[437]+1);
((C_proc9)(void*)(*((C_word*)t2+1)))(9,t2,t1,((C_word*)t0)[2],((C_word*)((C_word*)t0)[3])[1],((C_word*)((C_word*)t0)[4])[1],((C_word*)t0)[5],C_SCHEME_TRUE,C_SCHEME_TRUE,((C_word*)t0)[6]);}

/* terminal-size in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7598(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7598,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7602,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1617: ##sys#terminal-check */
f_7543(t3,lf[412],t2);}

/* a8393 in process in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8394(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word *a;
if(c!=6) C_bad_argc_2(c,6,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr6,(void*)f_8394,6,t0,t1,t2,t3,t4,t5);}
/* posixunix.scm:1858: values */
C_values(5,0,t1,t2,t3,t4);}

/* k2948 in mode in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_2950(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:310: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),((C_word*)t0)[2],t1,((C_word*)t0)[3]);}

/* k3445 in g363 in k3421 in loop in k3402 in k3395 in a3392 in conc-loop in glob in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3447(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:445: make-pathname */
t2=*((C_word*)lf[77]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],((C_word*)t0)[3],t1);}

/* mode in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_2942(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2942,NULL,4,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2950,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_pairp(t3))){
t6=t3;
t7=C_u_i_car(t6);
t8=C_eqp(t7,lf[40]);
if(C_truep(t8)){
t9=t2;
if(C_truep(t9)){
/* posix-common.scm:314: ##sys#error */
t10=*((C_word*)lf[41]+1);
((C_proc4)(void*)(*((C_word*)t10+1)))(4,t10,t5,lf[42],t7);}
else{
/* posix-common.scm:310: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),t1,lf[43],t4);}}
else{
/* posix-common.scm:315: ##sys#error */
t9=*((C_word*)lf[41]+1);
((C_proc4)(void*)(*((C_word*)t9+1)))(4,t9,t5,lf[44],t7);}}
else{
if(C_truep(t2)){
/* posix-common.scm:310: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),t1,lf[45],t4);}
else{
/* posix-common.scm:310: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),t1,lf[46],t4);}}}

/* k8368 in %process in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8370(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8370,2,t0,t1);}
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8374,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1849: ##sys#shell-command */
t4=*((C_word*)lf[429]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k8372 in k8368 in %process in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8374(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,t1);
t3=((C_word*)t0)[3];
f_8348(2,t3,t2);}

/* process in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8376(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr3r,(void*)f_8376r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_8376r(t0,t1,t2,t3);}}

static void C_ccall f_8376r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word *a=C_alloc(3);
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=C_i_nullp(t3);
t7=(C_truep(t6)?C_SCHEME_END_OF_LIST:C_i_cdr(t3));
t8=C_i_nullp(t7);
t9=(C_truep(t8)?C_SCHEME_FALSE:C_i_car(t7));
t10=C_i_nullp(t7);
t11=(C_truep(t10)?C_SCHEME_END_OF_LIST:C_i_cdr(t7));
t12=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8394,a[2]=((C_word)li225),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1856: %process */
f_8305(t1,lf[438],C_SCHEME_FALSE,t2,t5,t9,t12);}

/* k6041 in k6035 in loop in k6023 in a6016 in k6001 in read-symbolic-link in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in ... */
static void C_ccall f_6043(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6043,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[2];
t3=C_u_i_cdr(t2);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6052,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6055,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t3,a[5]=t4,a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm:1198: symbolic-link? */
t6=*((C_word*)lf[31]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,((C_word*)t0)[6]);}
else{
/* posixunix.scm:1204: ##sys#signal-hook */
t2=*((C_word*)lf[1]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[8],lf[330],lf[333],((C_word*)t0)[6]);}}

/* k3900 in k3881 in time->string in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3902(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3902,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3906,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:550: ##sys#make-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[65]+1)))(4,*((C_word*)lf[65]+1),t3,((C_word*)t0)[4],C_make_character(0));}

/* k3907 in k3881 in time->string in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3909(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=C_block_size(t1);
t3=C_fixnum_difference(t2,C_fix(1));
/* posix-common.scm:554: ##sys#substring */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[63]+1)))(5,*((C_word*)lf[63]+1),((C_word*)t0)[2],t1,C_fix(0),t3);}
else{
/* posix-common.scm:555: ##sys#error */
t2=*((C_word*)lf[41]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[110],lf[112],((C_word*)t0)[3]);}}

/* k3904 in k3900 in k3881 in time->string in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3906(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3906,2,t0,t1);}
t2=((C_word*)t0)[2];
t3=C_a_i_bytevector(&a,1,C_fix(3));
if(C_truep(t1)){
t4=C_i_foreign_block_argumentp(t1);
t5=stub526(t3,t2,((C_word*)t0)[3],t4);
/* posix-common.scm:543: ##sys#peek-c-string */
t6=*((C_word*)lf[4]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,((C_word*)t0)[4],t5,C_fix(0));}
else{
t4=stub526(t3,t2,((C_word*)t0)[3],C_SCHEME_FALSE);
/* posix-common.scm:543: ##sys#peek-c-string */
t5=*((C_word*)lf[4]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,((C_word*)t0)[4],t4,C_fix(0));}}

/* check in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_2979(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2979,NULL,5,t1,t2,t3,t4,t5);}
if(C_truep(C_null_pointerp(t5))){
/* posix-common.scm:321: posix-error */
t6=lf[0];
f_2668(6,t6,t1,lf[8],t2,lf[47],t3);}
else{
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2992,a[2]=t5,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:322: ##sys#make-port */
((C_proc6)C_fast_retrieve_proc(*((C_word*)lf[48]+1)))(6,*((C_word*)lf[48]+1),t6,t4,*((C_word*)lf[49]+1),lf[50],lf[51]);}}

/* k6035 in loop in k6023 in a6016 in k6001 in read-symbolic-link in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 in ... */
static void C_ccall f_6037(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6037,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6043,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t2,tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm:1196: file-exists? */
t4=*((C_word*)lf[194]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,t2);}

/* k6062 in k6056 in k6053 in k6041 in k6035 in loop in k6023 in a6016 in k6001 in read-symbolic-link in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in ... */
static void C_ccall f_6064(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
/* posixunix.scm:1197: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_6027(t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5]);}
else{
/* posixunix.scm:1202: make-pathname */
t2=*((C_word*)lf[77]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[6],((C_word*)t0)[7],((C_word*)t0)[5]);}}

/* k3437 in k3433 in g363 in k3421 in loop in k3402 in k3395 in a3392 in conc-loop in glob in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3439(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3439,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_i_cons(&a,2,((C_word*)t0)[3],t1));}

/* k3433 in g363 in k3421 in loop in k3402 in k3395 in a3392 in conc-loop in glob in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3435(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3435,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3439,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=C_i_cdr(((C_word*)t0)[3]);
/* posix-common.scm:446: loop */
t5=((C_word*)((C_word*)t0)[4])[1];
f_3406(t5,t3,t4);}

/* k6050 in k6041 in k6035 in loop in k6023 in a6016 in k6001 in read-symbolic-link in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in ... */
static void C_ccall f_6052(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1197: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_6027(t2,((C_word*)t0)[3],((C_word*)t0)[4],t1);}

/* loop in k3402 in k3395 in a3392 in conc-loop in glob in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_3406(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3406,NULL,3,t0,t1,t2);}
if(C_truep(C_i_nullp(t2))){
t3=C_i_cdr(((C_word*)t0)[2]);
/* posix-common.scm:441: conc-loop */
t4=((C_word*)((C_word*)t0)[3])[1];
f_3372(t4,t1,t3);}
else{
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3423,a[2]=t2,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t4=C_i_car(t2);
/* posix-common.scm:442: irregex-match */
t5=*((C_word*)lf[79]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t3,((C_word*)t0)[6],t4);}}

/* k3402 in k3395 in a3392 in conc-loop in glob in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3404(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3404,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3406,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word)li31),tmp=(C_word)a,a+=8,tmp));
t5=((C_word*)t3)[1];
f_3406(t5,((C_word*)t0)[6],t1);}

/* process-execute in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7782(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+8)){
C_save_and_reclaim((void*)tr3r,(void*)f_7782r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_7782r(t0,t1,t2,t3);}}

static void C_ccall f_7782r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word *a=C_alloc(8);
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_END_OF_LIST:C_i_car(t3));
t6=t5;
t7=C_i_nullp(t3);
t8=(C_truep(t7)?C_SCHEME_END_OF_LIST:C_i_cdr(t3));
t9=C_i_nullp(t8);
t10=(C_truep(t9)?C_SCHEME_FALSE:C_i_car(t8));
t11=t10;
t12=C_i_nullp(t8);
t13=(C_truep(t12)?C_SCHEME_END_OF_LIST:C_i_cdr(t8));
t14=C_i_check_string_2(t2,lf[423]);
t15=C_i_check_list_2(t6,lf[423]);
t16=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_7804,a[2]=t11,a[3]=t2,a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],a[6]=t1,a[7]=t6,tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm:1669: pathname-strip-directory */
t17=((C_word*)t0)[4];
((C_proc3)(void*)(*((C_word*)t17+1)))(3,t17,t16,t2);}

/* k6056 in k6053 in k6041 in k6035 in loop in k6023 in a6016 in k6001 in read-symbolic-link in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in ... */
static void C_ccall f_6058(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6058,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6064,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm:1200: absolute-pathname? */
t4=*((C_word*)lf[332]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,t2);}

/* k6053 in k6041 in k6035 in loop in k6023 in a6016 in k6001 in read-symbolic-link in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in ... */
static void C_ccall f_6055(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6055,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6058,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm:1199: ##sys#read-symbolic-link */
t3=*((C_word*)lf[327]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,((C_word*)t0)[7],lf[330]);}
else{
/* posixunix.scm:1197: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_6027(t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[7]);}}

/* a8697 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8698(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+0)){
C_save_and_reclaim((void*)tr2r,(void*)f_8698r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_8698r(t0,t1,t2);}}

static void C_ccall f_8698r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
t3=C_i_nullp(t2);
t4=(C_truep(t3)?C_SCHEME_FALSE:C_i_car(t2));
t5=(C_truep(t4)?C_i_check_exact_2(t4,lf[97]):C_SCHEME_UNDEFINED);
if(C_truep(t4)){
t6=C_umask(t4);
if(C_truep(t4)){
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}
else{
t7=C_umask(t6);
t8=t1;
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,t6);}}
else{
t6=C_umask(C_fix(0));
if(C_truep(t4)){
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}
else{
t7=C_umask(t6);
t8=t1;
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,t6);}}}

/* setarg in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_7736(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7736,NULL,4,t1,t2,t3,t4);}
t5=C_i_foreign_fixnum_argumentp(t2);
t6=t5;
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7745,a[2]=t4,a[3]=t1,a[4]=t6,tmp=(C_word)a,a+=5,tmp);
if(C_truep(t3)){
t8=C_i_foreign_string_argumentp(t3);
/* posixunix.scm:1661: ##sys#make-c-string */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(3,*((C_word*)lf[10]+1),t7,t8);}
else{
t8=C_i_foreign_fixnum_argumentp(t4);
t9=t1;
((C_proc2)(void*)(*((C_word*)t9+1)))(2,t9,stub1865(C_SCHEME_UNDEFINED,t6,C_SCHEME_FALSE,t8));}}

/* k2935 in directory? in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_2937(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_eqp(lf[25],t1));}

/* terminal-port? in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7525(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7525,3,t0,t1,t2);}
t3=t2;
t4=C_i_check_port_2(t3,C_fix(0),C_SCHEME_TRUE,lf[408]);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7531,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1597: ##sys#peek-unsigned-integer */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[58]+1)))(4,*((C_word*)lf[58]+1),t5,t2,C_fix(0));}

/* k3465 in a3392 in conc-loop in glob in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3467(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:439: ##sys#glob->regexp */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[81]+1)))(3,*((C_word*)lf[81]+1),((C_word*)t0)[2],t1);}

/* k2925 in socket? in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_2927(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_eqp(lf[29],t1));}

/* directory? in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_2929(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2929,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2937,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:295: file-type */
t4=*((C_word*)lf[22]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,t2,C_SCHEME_FALSE,C_SCHEME_FALSE);}

/* setenv in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_7759(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7759,NULL,4,t1,t2,t3,t4);}
t5=C_i_foreign_fixnum_argumentp(t2);
t6=t5;
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7768,a[2]=t4,a[3]=t1,a[4]=t6,tmp=(C_word)a,a+=5,tmp);
if(C_truep(t3)){
t8=C_i_foreign_string_argumentp(t3);
/* posixunix.scm:1663: ##sys#make-c-string */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(3,*((C_word*)lf[10]+1),t7,t8);}
else{
t8=C_i_foreign_fixnum_argumentp(t4);
t9=t1;
((C_proc2)(void*)(*((C_word*)t9+1)))(2,t9,stub1877(C_SCHEME_UNDEFINED,t6,C_SCHEME_FALSE,t8));}}

/* k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5348(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[21],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5348,2,t0,t1);}
t2=C_mutate2((C_word*)lf[247]+1 /* (set! signal-mask ...) */,t1);
t3=C_mutate2((C_word*)lf[248]+1 /* (set! signal-masked? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5350,a[2]=((C_word)li111),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate2((C_word*)lf[249]+1 /* (set! signal-mask! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5356,a[2]=((C_word)li112),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate2((C_word*)lf[251]+1 /* (set! signal-unmask! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5372,a[2]=((C_word)li113),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate2((C_word*)lf[253]+1 /* (set! system-information ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5388,a[2]=((C_word)li114),tmp=(C_word)a,a+=3,tmp));
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5428,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8599,a[2]=((C_word)li237),tmp=(C_word)a,a+=3,tmp);
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8602,a[2]=((C_word)li238),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:921: getter-with-setter */
t10=*((C_word*)lf[446]+1);
((C_proc5)(void*)(*((C_word*)t10+1)))(5,t10,t7,t8,t9,lf[458]);}

/* k5460 in k5447 in user-information in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5462(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5462,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5466,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* ##sys#peek-nonnull-c-string */
t4=*((C_word*)lf[254]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,C_mpointer(&a,(void*)C_user->pw_passwd),C_fix(0));}

/* k7743 in setarg in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7745(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_i_foreign_fixnum_argumentp(((C_word*)t0)[2]);
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,stub1865(C_SCHEME_UNDEFINED,((C_word*)t0)[4],t1,t2));}

/* k5464 in k5460 in k5447 in user-information in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5466(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5466,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5470,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
/* ##sys#peek-nonnull-c-string */
t4=*((C_word*)lf[254]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,C_mpointer(&a,(void*)C_PW_GECOS),C_fix(0));}

/* signal-mask! in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5356(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5356,3,t0,t1,t2);}
t3=C_i_check_exact_2(t2,lf[249]);
t4=C_sigemptyset(C_fix(0));
t5=C_sigaddset(t2);
t6=C_sigprocmask_block(C_fix(0));
if(C_truep(C_fixnum_lessp(t6,C_fix(0)))){
/* posixunix.scm:890: posix-error */
t7=lf[0];
f_2668(5,t7,t1,lf[122],lf[249],lf[250]);}
else{
t7=C_SCHEME_UNDEFINED;
t8=t1;
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,t7);}}

/* signal-masked? in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5350(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5350,3,t0,t1,t2);}
t3=C_i_check_exact_2(t2,lf[248]);
t4=C_sigprocmask_get(C_fix(0));
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_sigismember(t2));}

/* k6096 in file-link in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_6098(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6098,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6102,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(((C_word*)t0)[3])){
t4=C_i_foreign_string_argumentp(((C_word*)t0)[3]);
/* posixunix.scm:1208: ##sys#make-c-string */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(3,*((C_word*)lf[10]+1),t3,t4);}
else{
t4=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,stub1374(C_SCHEME_UNDEFINED,t2,C_SCHEME_FALSE));}}

/* f_6813 in k6810 in k6682 in custom-output-port in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_6813(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[11],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6813,3,t0,t1,t2);}
if(C_truep(t2)){
t3=C_fixnum_difference(((C_word*)t0)[2],((C_word*)((C_word*)t0)[3])[1]);
t4=C_block_size(t2);
t5=C_SCHEME_UNDEFINED;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_set_block_item(t6,0,(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_6830,a[2]=((C_word*)t0)[3],a[3]=t6,a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=t2,a[8]=((C_word)li160),tmp=(C_word)a,a+=9,tmp));
t8=((C_word*)t6)[1];
f_6830(t8,t1,t3,C_fix(0),t4);}
else{
if(C_truep(C_fixnum_lessp(C_fix(0),((C_word*)((C_word*)t0)[3])[1]))){
/* posixunix.scm:1385: poke */
t3=((C_word*)((C_word*)t0)[4])[1];
((C_proc4)C_fast_retrieve_proc(t3))(4,t3,t1,((C_word*)t0)[5],((C_word*)((C_word*)t0)[3])[1]);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}}

/* k6810 in k6682 in custom-output-port in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_6812(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6812,2,t0,t1);}
t2=t1;
t3=C_fix(0);
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=((C_word*)t0)[2];
f_6751(t5,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6813,a[2]=((C_word*)t0)[3],a[3]=t4,a[4]=((C_word*)t0)[4],a[5]=t2,a[6]=((C_word)li161),tmp=(C_word)a,a+=7,tmp));}

/* k5468 in k5464 in k5460 in k5447 in user-information in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5470(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5470,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_5474,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t2,tmp=(C_word)a,a+=7,tmp);
/* ##sys#peek-c-string */
t4=*((C_word*)lf[4]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,C_mpointer(&a,(void*)C_user->pw_dir),C_fix(0));}

/* k5476 in k5472 in k5468 in k5464 in k5460 in k5447 in user-information in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5478(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:966: g1171 */
t2=((C_word*)t0)[2];
((C_proc9)(void*)(*((C_word*)t2+1)))(9,t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],C_fix((C_word)C_user->pw_uid),C_fix((C_word)C_user->pw_gid),((C_word*)t0)[6],((C_word*)t0)[7],t1);}

/* k5472 in k5468 in k5464 in k5460 in k5447 in user-information in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5474(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5474,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_5478,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=t2,tmp=(C_word)a,a+=8,tmp);
/* ##sys#peek-c-string */
t4=*((C_word*)lf[4]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,C_mpointer(&a,(void*)C_user->pw_shell),C_fix(0));}

/* k5486 in user-information in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5488(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
f_5449(t2,C_getpwnam(t1));}

/* g363 in k3421 in loop in k3402 in k3395 in a3392 in conc-loop in glob in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_3427(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3427,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3435,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3447,a[2]=t3,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:445: irregex-match-substring */
t5=*((C_word*)lf[78]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k3421 in loop in k3402 in k3395 in a3392 in conc-loop in glob in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3423(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3423,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3427,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word)li30),tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:437: g363 */
t3=t2;
f_3427(t3,((C_word*)t0)[5],t1);}
else{
t2=((C_word*)t0)[2];
t3=C_u_i_cdr(t2);
/* posix-common.scm:447: loop */
t4=((C_word*)((C_word*)t0)[3])[1];
f_3406(t4,((C_word*)t0)[5],t3);}}

/* k8032 in process-run in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_8034(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_8034,NULL,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_8037,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1733: process-fork */
t4=*((C_word*)lf[419]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* process-run in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8030(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f_8030r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_8030r(t0,t1,t2,t3);}}

static void C_ccall f_8030r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8034,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_pairp(t3))){
t5=t3;
t6=t4;
f_8034(t6,C_u_i_car(t5));}
else{
t5=t4;
f_8034(t5,C_SCHEME_FALSE);}}

/* k5413 in k5409 in k5405 in k5401 in k5397 in k5390 in system-information in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5415(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5415,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_i_list5(&a,5,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)t0)[6],t1));}

/* k8035 in k8032 in process-run in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8037(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8037,2,t0,t1);}
t2=C_eqp(C_fix(0),t1);
if(C_truep(t2)){
if(C_truep(((C_word*)t0)[2])){
/* posixunix.scm:1735: process-execute */
t3=*((C_word*)lf[423]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[2]);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8056,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1737: ##sys#shell-command */
t4=*((C_word*)lf[429]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}}

/* k5409 in k5405 in k5401 in k5397 in k5390 in system-information in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5411(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5411,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_5415,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t2,tmp=(C_word)a,a+=7,tmp);
/* ##sys#peek-nonnull-c-string */
t4=*((C_word*)lf[254]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,C_mpointer(&a,(void*)C_utsname.machine),C_fix(0));}

/* open-input-file* in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_2994(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_2994r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2994r(t0,t1,t2,t3);}}

static void C_ccall f_2994r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t4=C_i_check_exact_2(t2,lf[52]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3006,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:328: mode */
f_2942(t5,C_SCHEME_TRUE,t3,lf[52]);}

/* k2990 in check in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_2992(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_set_file_ptr(t1,((C_word*)t0)[2]);
t3=t1;
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* ##sys#shell-command-arguments in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8024(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word ab[6],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_8024,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_a_i_list2(&a,2,lf[434],t2));}

/* ##sys#shell-command in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8015(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8015,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8019,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1725: get-environment-variable */
t3=*((C_word*)lf[431]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,lf[432]);}

/* k4541 in lp in k4472 in k4632 in k4408 in k4400 in k4397 in k4394 in file-select in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_4543(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4543,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=C_fixnum_plus(((C_word*)t0)[2],C_fix(1));
t3=C_i_car(((C_word*)t0)[3]);
t4=C_a_i_cons(&a,2,t3,((C_word*)t0)[4]);
t5=((C_word*)t0)[3];
t6=C_u_i_cdr(t5);
/* posixunix.scm:610: lp */
t7=((C_word*)((C_word*)t0)[5])[1];
f_4514(t7,((C_word*)t0)[6],t2,t4,t6);}
else{
t2=C_fixnum_plus(((C_word*)t0)[2],C_fix(1));
t3=C_i_cdr(((C_word*)t0)[3]);
/* posixunix.scm:611: lp */
t4=((C_word*)((C_word*)t0)[5])[1];
f_4514(t4,((C_word*)t0)[6],t2,((C_word*)t0)[4],t3);}}

/* k8017 in shell-command in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8019(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
t2=t1;
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,lf[430]);}}

/* k6001 in read-symbolic-link in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_6003(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6003,2,t0,t1);}
t2=t1;
if(C_truep(((C_word*)t0)[2])){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6011,a[2]=t2,a[3]=((C_word)li134),tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6017,a[2]=((C_word)li136),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1190: ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[3],t3,t4);}
else{
/* posixunix.scm:1205: ##sys#read-symbolic-link */
t3=*((C_word*)lf[327]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,((C_word*)t0)[3],t2,lf[330]);}}

/* loop in k6023 in a6016 in k6001 in read-symbolic-link in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_6027(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6027,NULL,4,t0,t1,t2,t3);}
if(C_truep(C_i_nullp(t2))){
t4=t3;
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6037,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t5=C_i_car(t2);
/* posixunix.scm:1195: make-pathname */
t6=*((C_word*)lf[77]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t4,t3,t5);}}

/* k6023 in a6016 in k6001 in read-symbolic-link in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_6025(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6025,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6027,a[2]=t3,a[3]=((C_word)li135),tmp=(C_word)a,a+=4,tmp));
t5=((C_word*)t3)[1];
f_6027(t5,((C_word*)t0)[2],((C_word*)t0)[3],t1);}

/* k8058 in k8054 in k8035 in k8032 in process-run in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8060(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1737: process-execute */
t2=*((C_word*)lf[423]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],((C_word*)t0)[3],t1);}

/* a6010 in k6001 in read-symbolic-link in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_6011(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6011,2,t0,t1);}
/* posixunix.scm:1190: decompose-directory */
t2=*((C_word*)lf[331]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,((C_word*)t0)[2]);}

/* a6016 in k6001 in read-symbolic-link in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_6017(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_6017,5,t0,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6025,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
t6=(C_truep(t2)?t2:lf[334]);
if(C_truep(t3)){
/* posixunix.scm:1192: string-append */
t7=*((C_word*)lf[2]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t5,t6,t3);}
else{
/* posixunix.scm:1192: string-append */
t7=*((C_word*)lf[2]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t5,t6,lf[335]);}}

/* k8054 in k8035 in k8032 in process-run in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8056(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_8056,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8060,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1737: ##sys#shell-command-arguments */
t4=*((C_word*)lf[433]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[3]);}

/* k7897 in doloop1904 in k7805 in k7802 in process-execute in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7899(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
t2=((C_word*)t0)[2];
t3=C_u_i_cdr(t2);
t4=C_fixnum_plus(((C_word*)t0)[3],C_fix(1));
t5=((C_word*)((C_word*)t0)[4])[1];
f_7812(t5,((C_word*)t0)[5],t3,t4);}

/* f_3655 in k3686 in k3683 in k3680 in k3677 in k3674 in k3671 in find-files in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3655(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3655,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_TRUE);}

/* k6838 in loop */
static void C_ccall f_6840(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_set_block_item(((C_word*)t0)[2],0,C_fix(0));
/* posixunix.scm:1377: loop */
t3=((C_word*)((C_word*)t0)[3])[1];
f_6830(t3,((C_word*)t0)[4],((C_word*)t0)[5],C_fix(0),((C_word*)t0)[6]);}

/* k7766 in setenv in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7768(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_i_foreign_fixnum_argumentp(((C_word*)t0)[2]);
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,stub1877(C_SCHEME_UNDEFINED,((C_word*)t0)[4],t1,t2));}

/* lp in k4472 in k4632 in k4408 in k4400 in k4397 in k4394 in file-select in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_4514(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4514,NULL,5,t0,t1,t2,t3,t4);}
if(C_truep(C_i_nullp(t4))){
/* posixunix.scm:605: ##sys#fast-reverse */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[178]+1)))(3,*((C_word*)lf[178]+1),t1,t3);}
else{
t5=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4543,a[2]=t2,a[3]=t4,a[4]=t3,a[5]=((C_word*)t0)[2],a[6]=t1,tmp=(C_word)a,a+=7,tmp);
t6=t2;
t7=C_i_foreign_fixnum_argumentp(t6);
if(C_truep(((C_word*)t0)[3])){
t8=C_i_foreign_block_argumentp(((C_word*)t0)[3]);
t9=t5;
f_4543(t9,stub873(C_SCHEME_UNDEFINED,t7,t8));}
else{
t8=t5;
f_4543(t8,stub873(C_SCHEME_UNDEFINED,t7,C_SCHEME_FALSE));}}}

/* loop */
static void C_fcall f_6830(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word *a;
loop:
a=C_alloc(7);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_6830,NULL,5,t0,t1,t2,t3,t4);}
t5=C_eqp(C_fix(0),t2);
if(C_truep(t5)){
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6840,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],a[6]=t4,tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm:1375: poke */
t7=((C_word*)((C_word*)t0)[5])[1];
((C_proc4)C_fast_retrieve_proc(t7))(4,t7,t6,((C_word*)t0)[6],((C_word*)t0)[4]);}
else{
if(C_truep(C_fixnum_lessp(t2,t4))){
t6=C_substring_copy(((C_word*)t0)[7],((C_word*)t0)[6],t3,t2,((C_word*)((C_word*)t0)[2])[1]);
t7=C_fixnum_difference(t4,t2);
/* posixunix.scm:1380: loop */
t13=t1;
t14=C_fix(0);
t15=t2;
t16=t7;
t1=t13;
t2=t14;
t3=t15;
t4=t16;
goto loop;}
else{
t6=C_substring_copy(((C_word*)t0)[7],((C_word*)t0)[6],t3,t4,((C_word*)((C_word*)t0)[2])[1]);
t7=C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],t4);
t8=C_mutate2(((C_word *)((C_word*)t0)[2])+1,t7);
t9=t1;
((C_proc2)(void*)(*((C_word*)t9+1)))(2,t9,t8);}}}

/* current-user-name in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5496(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5496,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5504,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5508,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:983: current-user-id */
t4=*((C_word*)lf[256]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k5419 in system-information in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5421(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:913: ##sys#error */
t2=*((C_word*)lf[41]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[253],lf[255]);}

/* k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5428(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5428,2,t0,t1);}
t2=C_mutate2((C_word*)lf[256]+1 /* (set! current-user-id ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5432,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8580,a[2]=((C_word)li235),tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8583,a[2]=((C_word)li236),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:930: getter-with-setter */
t6=*((C_word*)lf[446]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t3,t4,t5,lf[456]);}

/* k3686 in k3683 in k3680 in k3677 in k3674 in k3671 in find-files in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3688(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word ab[17],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3688,2,t0,t1);}
t2=((C_word*)t0)[2];
t3=((C_word*)t0)[3];
t4=((C_word*)t0)[4];
t5=((C_word*)t0)[5];
t6=((C_word*)t0)[6];
t7=((C_word*)t0)[7];
t8=t1;
t9=((C_word*)t0)[8];
t10=C_i_check_string_2(t3,lf[70]);
t11=C_fix(0);
t12=(*a=C_VECTOR_TYPE|1,a[1]=t11,tmp=(C_word)a,a+=2,tmp);
t13=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_3480,a[2]=t8,a[3]=t5,a[4]=t12,a[5]=t9,a[6]=t2,a[7]=t6,a[8]=t3,a[9]=t4,tmp=(C_word)a,a+=10,tmp);
if(C_truep(t7)){
if(C_truep(C_fixnump(t7))){
t14=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3663,a[2]=t12,a[3]=t7,a[4]=((C_word)li40),tmp=(C_word)a,a+=5,tmp);
t15=t13;
f_3480(t15,t14);}
else{
t14=t13;
f_3480(t14,t7);}}
else{
t14=t13;
f_3480(t14,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3655,a[2]=((C_word)li41),tmp=(C_word)a,a+=3,tmp));}}

/* k3683 in k3680 in k3677 in k3674 in k3671 in find-files in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3685(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3685,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3688,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=t2,tmp=(C_word)a,a+=9,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3693,a[2]=((C_word)li42),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:484: ##sys#get-keyword */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[92]+1)))(5,*((C_word*)lf[92]+1),t3,lf[72],((C_word*)t0)[8],t4);}

/* k3680 in k3677 in k3674 in k3671 in find-files in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3682(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3682,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3685,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=t2,a[8]=((C_word*)t0)[7],tmp=(C_word)a,a+=9,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3696,a[2]=((C_word)li43),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:484: ##sys#get-keyword */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[92]+1)))(5,*((C_word*)lf[92]+1),t3,lf[71],((C_word*)t0)[7],t4);}

/* k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5432(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5432,2,t0,t1);}
t2=C_mutate2((C_word*)lf[257]+1 /* (set! current-effective-user-id ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5436,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8561,a[2]=((C_word)li233),tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8564,a[2]=((C_word)li234),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:940: getter-with-setter */
t6=*((C_word*)lf[446]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t3,t4,t5,lf[453]);}

/* k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5436(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5436,2,t0,t1);}
t2=C_mutate2((C_word*)lf[258]+1 /* (set! current-group-id ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5440,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8542,a[2]=((C_word)li231),tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8545,a[2]=((C_word)li232),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:949: getter-with-setter */
t6=*((C_word*)lf[446]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t3,t4,t5,lf[450]);}

/* k3614 in k3509 in loop in k3488 in k3481 in k3478 in k3686 in k3683 in k3680 in k3677 in k3674 in k3671 in find-files in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3616(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3616,2,t0,t1);}
if(C_truep((C_truep(C_i_equalp(t1,lf[83]))?C_SCHEME_TRUE:(C_truep(C_i_equalp(t1,lf[84]))?C_SCHEME_TRUE:C_SCHEME_FALSE)))){
/* posix-common.scm:472: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_3492(t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5]);}
else{
t2=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_3609,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[5],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],a[11]=((C_word*)t0)[11],a[12]=((C_word*)t0)[12],tmp=(C_word)a,a+=13,tmp);
/* posix-common.scm:473: symbolic-link? */
t3=*((C_word*)lf[31]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[8]);}}

/* k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5440(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word ab[54],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5440,2,t0,t1);}
t2=C_mutate2((C_word*)lf[259]+1 /* (set! current-effective-group-id ...) */,t1);
t3=C_mutate2((C_word*)lf[260]+1 /* (set! user-information ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5442,a[2]=((C_word)li115),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate2((C_word*)lf[263]+1 /* (set! current-user-name ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5496,a[2]=((C_word)li116),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate2((C_word*)lf[264]+1 /* (set! current-effective-user-name ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5510,a[2]=((C_word)li117),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate2((C_word*)lf[265]+1 /* (set! group-information ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5535,a[2]=((C_word)li119),tmp=(C_word)a,a+=3,tmp));
t7=C_mutate2((C_word*)lf[266]+1 /* (set! get-groups ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5615,a[2]=((C_word)li121),tmp=(C_word)a,a+=3,tmp));
t8=C_mutate2((C_word*)lf[270]+1 /* (set! set-groups! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5679,a[2]=((C_word)li123),tmp=(C_word)a,a+=3,tmp));
t9=C_mutate2((C_word*)lf[273]+1 /* (set! initialize-groups ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5754,a[2]=((C_word)li124),tmp=(C_word)a,a+=3,tmp));
t10=C_mutate2((C_word*)lf[275]+1 /* (set! errno/perm ...) */,C_fix((C_word)EPERM));
t11=C_mutate2((C_word*)lf[276]+1 /* (set! errno/noent ...) */,C_fix((C_word)ENOENT));
t12=C_mutate2((C_word*)lf[277]+1 /* (set! errno/srch ...) */,C_fix((C_word)ESRCH));
t13=C_mutate2((C_word*)lf[278]+1 /* (set! errno/intr ...) */,C_fix((C_word)EINTR));
t14=C_mutate2((C_word*)lf[279]+1 /* (set! errno/io ...) */,C_fix((C_word)EIO));
t15=C_mutate2((C_word*)lf[280]+1 /* (set! errno/noexec ...) */,C_fix((C_word)ENOEXEC));
t16=C_mutate2((C_word*)lf[281]+1 /* (set! errno/badf ...) */,C_fix((C_word)EBADF));
t17=C_mutate2((C_word*)lf[282]+1 /* (set! errno/child ...) */,C_fix((C_word)ECHILD));
t18=C_mutate2((C_word*)lf[283]+1 /* (set! errno/nomem ...) */,C_fix((C_word)ENOMEM));
t19=C_mutate2((C_word*)lf[284]+1 /* (set! errno/acces ...) */,C_fix((C_word)EACCES));
t20=C_mutate2((C_word*)lf[285]+1 /* (set! errno/fault ...) */,C_fix((C_word)EFAULT));
t21=C_mutate2((C_word*)lf[286]+1 /* (set! errno/busy ...) */,C_fix((C_word)EBUSY));
t22=C_mutate2((C_word*)lf[287]+1 /* (set! errno/notdir ...) */,C_fix((C_word)ENOTDIR));
t23=C_mutate2((C_word*)lf[288]+1 /* (set! errno/isdir ...) */,C_fix((C_word)EISDIR));
t24=C_mutate2((C_word*)lf[289]+1 /* (set! errno/inval ...) */,C_fix((C_word)EINVAL));
t25=C_mutate2((C_word*)lf[290]+1 /* (set! errno/mfile ...) */,C_fix((C_word)EMFILE));
t26=C_mutate2((C_word*)lf[291]+1 /* (set! errno/nospc ...) */,C_fix((C_word)ENOSPC));
t27=C_mutate2((C_word*)lf[292]+1 /* (set! errno/spipe ...) */,C_fix((C_word)ESPIPE));
t28=C_mutate2((C_word*)lf[293]+1 /* (set! errno/pipe ...) */,C_fix((C_word)EPIPE));
t29=C_mutate2((C_word*)lf[294]+1 /* (set! errno/again ...) */,C_fix((C_word)EAGAIN));
t30=C_mutate2((C_word*)lf[295]+1 /* (set! errno/rofs ...) */,C_fix((C_word)EROFS));
t31=C_mutate2((C_word*)lf[296]+1 /* (set! errno/exist ...) */,C_fix((C_word)EEXIST));
t32=C_mutate2((C_word*)lf[297]+1 /* (set! errno/wouldblock ...) */,C_fix((C_word)EWOULDBLOCK));
t33=C_set_block_item(lf[298] /* errno/2big */,0,C_fix(0));
t34=C_set_block_item(lf[299] /* errno/deadlk */,0,C_fix(0));
t35=C_set_block_item(lf[300] /* errno/dom */,0,C_fix(0));
t36=C_set_block_item(lf[301] /* errno/fbig */,0,C_fix(0));
t37=C_set_block_item(lf[302] /* errno/ilseq */,0,C_fix(0));
t38=C_set_block_item(lf[303] /* errno/mlink */,0,C_fix(0));
t39=C_set_block_item(lf[304] /* errno/nametoolong */,0,C_fix(0));
t40=C_set_block_item(lf[305] /* errno/nfile */,0,C_fix(0));
t41=C_set_block_item(lf[306] /* errno/nodev */,0,C_fix(0));
t42=C_set_block_item(lf[307] /* errno/nolck */,0,C_fix(0));
t43=C_set_block_item(lf[308] /* errno/nosys */,0,C_fix(0));
t44=C_set_block_item(lf[309] /* errno/notempty */,0,C_fix(0));
t45=C_set_block_item(lf[310] /* errno/notty */,0,C_fix(0));
t46=C_set_block_item(lf[311] /* errno/nxio */,0,C_fix(0));
t47=C_set_block_item(lf[312] /* errno/range */,0,C_fix(0));
t48=C_set_block_item(lf[313] /* errno/xdev */,0,C_fix(0));
t49=C_mutate2((C_word*)lf[314]+1 /* (set! change-file-mode ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5818,a[2]=((C_word)li125),tmp=(C_word)a,a+=3,tmp));
t50=C_mutate2((C_word*)lf[316]+1 /* (set! change-file-owner ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5845,a[2]=((C_word)li126),tmp=(C_word)a,a+=3,tmp));
t51=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5875,a[2]=((C_word)li127),tmp=(C_word)a,a+=3,tmp);
t52=C_mutate2((C_word*)lf[318]+1 /* (set! file-read-access? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5899,a[2]=t51,a[3]=((C_word)li128),tmp=(C_word)a,a+=4,tmp));
t53=C_mutate2((C_word*)lf[319]+1 /* (set! file-write-access? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5905,a[2]=t51,a[3]=((C_word)li129),tmp=(C_word)a,a+=4,tmp));
t54=C_mutate2((C_word*)lf[320]+1 /* (set! file-execute-access? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5911,a[2]=t51,a[3]=((C_word)li130),tmp=(C_word)a,a+=4,tmp));
t55=C_mutate2((C_word*)lf[321]+1 /* (set! create-session ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5917,a[2]=((C_word)li131),tmp=(C_word)a,a+=3,tmp));
t56=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5934,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t57=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8502,a[2]=((C_word)li229),tmp=(C_word)a,a+=3,tmp);
t58=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8520,a[2]=((C_word)li230),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1144: getter-with-setter */
t59=*((C_word*)lf[446]+1);
((C_proc5)(void*)(*((C_word*)t59+1)))(5,t59,t56,t57,t58,lf[447]);}

/* user-information in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5442(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+7)){
C_save_and_reclaim((void*)tr3r,(void*)f_5442r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_5442r(t0,t1,t2,t3);}}

static void C_ccall f_5442r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(7);
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=t5;
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5449,a[2]=t6,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnump(t2))){
t8=t7;
f_5449(t8,C_getpwuid(t2));}
else{
t8=C_i_check_string_2(t2,lf[260]);
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5488,a[2]=t7,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:971: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),t9,t2,lf[260]);}}

/* k5447 in user-information in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_5449(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5449,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=(C_truep(((C_word*)t0)[2])?*((C_word*)lf[261]+1):*((C_word*)lf[262]+1));
t3=t2;
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5462,a[2]=t3,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* ##sys#peek-nonnull-c-string */
t5=*((C_word*)lf[254]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t4,C_mpointer(&a,(void*)C_user->pw_name),C_fix(0));}
else{
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* find-files in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3669(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+8)){
C_save_and_reclaim((void*)tr3r,(void*)f_3669r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3669r(t0,t1,t2,t3);}}

static void C_ccall f_3669r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(8);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3673,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3713,a[2]=((C_word)li49),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:484: ##sys#get-keyword */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[92]+1)))(5,*((C_word*)lf[92]+1),t4,lf[96],t3,t5);}

/* k7820 in doloop1904 in k7805 in k7802 in process-execute in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7822(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7822,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7825,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
if(C_truep(((C_word*)t0)[2])){
t3=C_i_check_list_2(((C_word*)t0)[2],lf[423]);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7858,a[2]=((C_word*)t0)[5],a[3]=t5,a[4]=((C_word)li192),tmp=(C_word)a,a+=5,tmp));
t7=((C_word*)t5)[1];
f_7858(t7,t2,((C_word*)t0)[2],C_fix(0));}
else{
t3=t2;
f_7825(2,t3,C_SCHEME_UNDEFINED);}}

/* f_3663 in k3686 in k3683 in k3680 in k3677 in k3674 in k3671 in find-files in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3663(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3663,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fixnum_lessp(((C_word*)((C_word*)t0)[2])[1],((C_word*)t0)[3]));}

/* glob in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3366(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr2r,(void*)f_3366r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3366r(t0,t1,t2);}}

static void C_ccall f_3366r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(6);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3372,a[2]=t4,a[3]=((C_word)li33),tmp=(C_word)a,a+=4,tmp));
t6=((C_word*)t4)[1];
f_3372(t6,t1,t2);}

/* k7875 in doloop1908 in k7820 in doloop1904 in k7805 in k7802 in process-execute in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in ... */
static void C_ccall f_7877(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
t2=((C_word*)t0)[2];
t3=C_u_i_cdr(t2);
t4=C_fixnum_plus(((C_word*)t0)[3],C_fix(1));
t5=((C_word*)((C_word*)t0)[4])[1];
f_7858(t5,((C_word*)t0)[5],t3,t4);}

/* k3677 in k3674 in k3671 in find-files in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3679(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3679,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3682,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t2,a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3699,a[2]=((C_word)li44),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:484: ##sys#get-keyword */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[92]+1)))(5,*((C_word*)lf[92]+1),t3,lf[93],((C_word*)t0)[6],t4);}

/* k3674 in k3671 in find-files in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3676(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3676,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3679,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3702,a[2]=((C_word)li45),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:484: ##sys#get-keyword */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[92]+1)))(5,*((C_word*)lf[92]+1),t3,lf[94],((C_word*)t0)[5],t4);}

/* doloop1904 in k7805 in k7802 in process-execute in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_7812(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7812,NULL,4,t0,t1,t2,t3);}
if(C_truep(C_i_nullp(t2))){
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7822,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:1674: setarg */
f_7736(t4,t3,C_SCHEME_FALSE,C_fix(0));}
else{
t4=C_i_car(t2);
t5=C_i_check_string_2(t4,lf[423]);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7899,a[2]=t2,a[3]=t3,a[4]=((C_word*)t0)[6],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t7=C_block_size(t4);
/* posixunix.scm:1693: setarg */
f_7736(t6,t3,t4,t7);}}

/* k3671 in find-files in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3673(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3673,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3676,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3705,a[2]=((C_word)li47),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:484: ##sys#get-keyword */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[92]+1)))(5,*((C_word*)lf[92]+1),t3,lf[95],((C_word*)t0)[4],t4);}

/* loop in k6393 in a6386 in k6171 in k6165 in custom-input-port in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 in ... */
static void C_fcall f_6397(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word *a;
loop:
a=C_alloc(8);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_6397,NULL,5,t0,t1,t2,t3,t4);}
t5=C_eqp(C_fix(0),t2);
if(C_truep(t5)){
t6=t3;
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}
else{
if(C_truep(C_fixnum_lessp(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]))){
t6=C_fixnum_difference(((C_word*)((C_word*)t0)[3])[1],((C_word*)((C_word*)t0)[2])[1]);
t7=C_fixnum_lessp(t2,t6);
t8=(C_truep(t7)?t2:t6);
t9=C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],t8);
t10=C_substring_copy(((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)((C_word*)t0)[2])[1],t9,t4);
t11=C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],t8);
t12=C_mutate2(((C_word *)((C_word*)t0)[2])+1,t11);
t13=C_fixnum_difference(t2,t8);
t14=C_fixnum_plus(t3,t8);
t15=C_fixnum_plus(t4,t8);
/* posixunix.scm:1297: loop */
t19=t1;
t20=t13;
t21=t14;
t22=t15;
t1=t19;
t2=t20;
t3=t21;
t4=t22;
goto loop;}
else{
t6=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6445,a[2]=((C_word*)t0)[3],a[3]=t3,a[4]=t1,a[5]=((C_word*)t0)[6],a[6]=t2,a[7]=t4,tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm:1299: fetch */
t7=((C_word*)t0)[7];
f_6211(t7,t6);}}}

/* lp in k4632 in k4408 in k4400 in k4397 in k4394 in file-select in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_4573(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4573,NULL,5,t0,t1,t2,t3,t4);}
if(C_truep(C_i_nullp(t4))){
/* posixunix.scm:597: ##sys#fast-reverse */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[178]+1)))(3,*((C_word*)lf[178]+1),t1,t3);}
else{
t5=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4602,a[2]=t2,a[3]=t4,a[4]=t3,a[5]=((C_word*)t0)[2],a[6]=t1,tmp=(C_word)a,a+=7,tmp);
t6=t2;
t7=C_i_foreign_fixnum_argumentp(t6);
if(C_truep(((C_word*)t0)[3])){
t8=C_i_foreign_block_argumentp(((C_word*)t0)[3]);
t9=t5;
f_4602(t9,stub854(C_SCHEME_UNDEFINED,t7,t8));}
else{
t8=t5;
f_4602(t8,stub854(C_SCHEME_UNDEFINED,t7,C_SCHEME_FALSE));}}}

/* conc-loop in glob in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_3372(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3372,NULL,3,t0,t1,t2);}
if(C_truep(C_i_nullp(t2))){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_END_OF_LIST);}
else{
t3=C_i_car(t2);
t4=t3;
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3387,a[2]=t4,a[3]=((C_word)li29),tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3393,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word)li32),tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:437: ##sys#call-with-values */
C_call_with_values(4,0,t1,t5,t6);}}

/* k7826 in k7823 in k7820 in doloop1904 in k7805 in k7802 in process-execute in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in ... */
static void C_ccall f_7828(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
t2=(C_truep(((C_word*)t0)[2])?C_execve(t1):C_execvp(t1));
t3=C_eqp(t2,C_fix(-1));
if(C_truep(t3)){
t4=stub1872(C_SCHEME_UNDEFINED);
t5=stub1884(C_SCHEME_UNDEFINED);
/* posixunix.scm:1690: posix-error */
t6=lf[0];
f_2668(6,t6,((C_word*)t0)[3],lf[122],lf[423],lf[424],((C_word*)t0)[4]);}
else{
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* k7823 in k7820 in doloop1904 in k7805 in k7802 in process-execute in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 in ... */
static void C_ccall f_7825(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7825,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7828,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7850,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1683: ##sys#expand-home-path */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(3,*((C_word*)lf[12]+1),t3,((C_word*)t0)[4]);}

/* a6371 in k6171 in k6165 in custom-input-port in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_6372(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6372,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6376,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[3])[1],((C_word*)((C_word*)t0)[4])[1]))){
/* posixunix.scm:1287: fetch */
t3=((C_word*)t0)[5];
f_6211(t3,t2);}
else{
/* posixunix.scm:1288: peek */
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,f_6203(((C_word*)t0)[2]));}}

/* a6386 in k6171 in k6165 in custom-input-port in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_6387(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word ab[9],*a=ab;
if(c!=6) C_bad_argc_2(c,6,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr6,(void*)f_6387,6,t0,t1,t2,t3,t4,t5);}
t6=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_6395,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t4,a[6]=((C_word*)t0)[5],a[7]=t1,a[8]=t5,tmp=(C_word)a,a+=9,tmp);
if(C_truep(t3)){
t7=t6;
f_6395(t7,t3);}
else{
t7=C_block_size(t4);
t8=t6;
f_6395(t8,C_fixnum_difference(t7,t5));}}

/* k3300 in k3290 in k3278 in loop in k3250 in k3246 in k3243 in k3240 in k3225 in directory in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3302(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3302,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_i_cons(&a,2,((C_word*)t0)[3],t1));}

/* k6358 in a6349 in k6171 in k6165 in custom-input-port in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_6360(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1284: on-close */
t2=((C_word*)t0)[2];
((C_proc2)C_fast_retrieve_proc(t2))(2,t2,((C_word*)t0)[3]);}

/* k6374 in a6371 in k6171 in k6165 in custom-input-port in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_6376(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1288: peek */
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,f_6203(((C_word*)t0)[3]));}

/* a3392 in conc-loop in glob in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3393(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[9],*a=ab;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_3393,5,t0,t1,t2,t3,t4);}
t5=t2;
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3397,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t5,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3467,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
if(C_truep(t3)){
t8=t3;
/* posix-common.scm:439: make-pathname */
t9=*((C_word*)lf[77]+1);
((C_proc5)(void*)(*((C_word*)t9+1)))(5,t9,t7,C_SCHEME_FALSE,t8,t4);}
else{
/* posix-common.scm:439: make-pathname */
t8=*((C_word*)lf[77]+1);
((C_proc5)(void*)(*((C_word*)t8+1)))(5,t8,t7,C_SCHEME_FALSE,lf[82],t4);}}

/* k3395 in a3392 in conc-loop in glob in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3397(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3397,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3404,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
if(C_truep(((C_word*)t0)[4])){
/* posix-common.scm:440: directory */
t4=*((C_word*)lf[25]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,((C_word*)t0)[4],C_SCHEME_TRUE);}
else{
/* posix-common.scm:440: directory */
t4=*((C_word*)lf[25]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,lf[80],C_SCHEME_TRUE);}}

/* a6349 in k6171 in k6165 in custom-input-port in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_6350(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6350,2,t0,t1);}
if(C_truep(C_slot(((C_word*)((C_word*)t0)[2])[1],C_fix(8)))){
t2=C_SCHEME_UNDEFINED;
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6360,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t3=C_close(((C_word*)t0)[4]);
if(C_truep(C_fixnum_lessp(t3,C_fix(0)))){
/* posixunix.scm:1283: posix-error */
t4=lf[0];
f_2668(7,t4,t2,lf[8],((C_word*)t0)[5],lf[351],((C_word*)t0)[4],((C_word*)t0)[6]);}
else{
/* posixunix.scm:1284: on-close */
t4=((C_word*)t0)[3];
((C_proc2)C_fast_retrieve_proc(t4))(2,t4,t1);}}}

/* a4087 in process-wait in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_4088(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4088,2,t0,t1);}
/* posix-common.scm:611: ##sys#process-wait */
t2=*((C_word*)lf[121]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,((C_word*)t0)[2],((C_word*)t0)[3]);}

/* k7848 in k7823 in k7820 in doloop1904 in k7805 in k7802 in process-execute in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in ... */
static void C_ccall f_7850(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1683: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),((C_word*)t0)[2],t1,lf[423]);}

/* k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_4056(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word ab[51],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4056,2,t0,t1);}
t2=C_mutate2((C_word*)lf[118]+1 /* (set! signal-handler ...) */,t1);
t3=C_mutate2((C_word*)lf[119]+1 /* (set! current-process-id ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4058,a[2]=((C_word)li63),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate2((C_word*)lf[120]+1 /* (set! process-wait ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4064,a[2]=((C_word)li66),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate2((C_word*)lf[124]+1 /* (set! ##sys#file-nonblocking! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4133,a[2]=((C_word)li67),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate2((C_word*)lf[125]+1 /* (set! ##sys#file-select-one ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4140,a[2]=((C_word)li68),tmp=(C_word)a,a+=3,tmp));
t7=C_mutate2((C_word*)lf[126]+1 /* (set! pipe/buf ...) */,C_fix((C_word)PIPE_BUF));
t8=C_mutate2((C_word*)lf[127]+1 /* (set! fcntl/dupfd ...) */,C_fix((C_word)F_DUPFD));
t9=C_mutate2((C_word*)lf[128]+1 /* (set! fcntl/getfd ...) */,C_fix((C_word)F_GETFD));
t10=C_mutate2((C_word*)lf[129]+1 /* (set! fcntl/setfd ...) */,C_fix((C_word)F_SETFD));
t11=C_mutate2((C_word*)lf[130]+1 /* (set! fcntl/getfl ...) */,C_fix((C_word)F_GETFL));
t12=C_mutate2((C_word*)lf[131]+1 /* (set! fcntl/setfl ...) */,C_fix((C_word)F_SETFL));
t13=C_mutate2((C_word*)lf[132]+1 /* (set! open/rdonly ...) */,C_fix((C_word)O_RDONLY));
t14=C_mutate2((C_word*)lf[133]+1 /* (set! open/wronly ...) */,C_fix((C_word)O_WRONLY));
t15=C_mutate2((C_word*)lf[134]+1 /* (set! open/rdwr ...) */,C_fix((C_word)O_RDWR));
t16=C_mutate2((C_word*)lf[135]+1 /* (set! open/read ...) */,C_fix((C_word)O_RDONLY));
t17=C_mutate2((C_word*)lf[136]+1 /* (set! open/write ...) */,C_fix((C_word)O_WRONLY));
t18=C_mutate2((C_word*)lf[137]+1 /* (set! open/creat ...) */,C_fix((C_word)O_CREAT));
t19=C_mutate2((C_word*)lf[138]+1 /* (set! open/append ...) */,C_fix((C_word)O_APPEND));
t20=C_mutate2((C_word*)lf[139]+1 /* (set! open/excl ...) */,C_fix((C_word)O_EXCL));
t21=C_mutate2((C_word*)lf[140]+1 /* (set! open/noctty ...) */,C_fix((C_word)O_NOCTTY));
t22=C_mutate2((C_word*)lf[141]+1 /* (set! open/nonblock ...) */,C_fix((C_word)O_NONBLOCK));
t23=C_mutate2((C_word*)lf[142]+1 /* (set! open/trunc ...) */,C_fix((C_word)O_TRUNC));
t24=C_mutate2((C_word*)lf[143]+1 /* (set! open/sync ...) */,C_fix((C_word)O_FSYNC));
t25=C_mutate2((C_word*)lf[144]+1 /* (set! open/fsync ...) */,C_fix((C_word)O_FSYNC));
t26=C_mutate2((C_word*)lf[145]+1 /* (set! open/binary ...) */,C_fix((C_word)O_BINARY));
t27=C_mutate2((C_word*)lf[146]+1 /* (set! open/text ...) */,C_fix((C_word)O_TEXT));
t28=C_mutate2((C_word*)lf[147]+1 /* (set! perm/irusr ...) */,C_fix((C_word)S_IRUSR));
t29=C_mutate2((C_word*)lf[148]+1 /* (set! perm/iwusr ...) */,C_fix((C_word)S_IWUSR));
t30=C_mutate2((C_word*)lf[149]+1 /* (set! perm/ixusr ...) */,C_fix((C_word)S_IXUSR));
t31=C_mutate2((C_word*)lf[150]+1 /* (set! perm/irgrp ...) */,C_fix((C_word)S_IRGRP));
t32=C_mutate2((C_word*)lf[151]+1 /* (set! perm/iwgrp ...) */,C_fix((C_word)S_IWGRP));
t33=C_mutate2((C_word*)lf[152]+1 /* (set! perm/ixgrp ...) */,C_fix((C_word)S_IXGRP));
t34=C_mutate2((C_word*)lf[153]+1 /* (set! perm/iroth ...) */,C_fix((C_word)S_IROTH));
t35=C_mutate2((C_word*)lf[154]+1 /* (set! perm/iwoth ...) */,C_fix((C_word)S_IWOTH));
t36=C_mutate2((C_word*)lf[155]+1 /* (set! perm/ixoth ...) */,C_fix((C_word)S_IXOTH));
t37=C_mutate2((C_word*)lf[156]+1 /* (set! perm/irwxu ...) */,C_fix((C_word)S_IRWXU));
t38=C_mutate2((C_word*)lf[157]+1 /* (set! perm/irwxg ...) */,C_fix((C_word)S_IRWXG));
t39=C_mutate2((C_word*)lf[158]+1 /* (set! perm/irwxo ...) */,C_fix((C_word)S_IRWXO));
t40=C_mutate2((C_word*)lf[159]+1 /* (set! perm/isvtx ...) */,C_fix((C_word)S_ISVTX));
t41=C_mutate2((C_word*)lf[160]+1 /* (set! perm/isuid ...) */,C_fix((C_word)S_ISUID));
t42=C_mutate2((C_word*)lf[161]+1 /* (set! perm/isgid ...) */,C_fix((C_word)S_ISGID));
t43=C_mutate2((C_word*)lf[162]+1 /* (set! file-control ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4197,a[2]=((C_word)li69),tmp=(C_word)a,a+=3,tmp));
t44=C_a_i_bitwise_ior(&a,2,C_fix((C_word)S_IRGRP),C_fix((C_word)S_IROTH));
t45=C_a_i_bitwise_ior(&a,2,C_fix((C_word)S_IRWXU),t44);
t46=t45;
t47=C_mutate2((C_word*)lf[164]+1 /* (set! file-open ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4230,a[2]=t46,a[3]=((C_word)li70),tmp=(C_word)a,a+=4,tmp));
t48=C_mutate2((C_word*)lf[166]+1 /* (set! file-close ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4266,a[2]=((C_word)li71),tmp=(C_word)a,a+=3,tmp));
t49=C_mutate2((C_word*)lf[168]+1 /* (set! file-read ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4282,a[2]=((C_word)li72),tmp=(C_word)a,a+=3,tmp));
t50=C_mutate2((C_word*)lf[171]+1 /* (set! file-write ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4323,a[2]=((C_word)li73),tmp=(C_word)a,a+=3,tmp));
t51=C_mutate2((C_word*)lf[174]+1 /* (set! file-mkstemp ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4360,a[2]=((C_word)li74),tmp=(C_word)a,a+=3,tmp));
t52=C_mutate2((C_word*)lf[176]+1 /* (set! file-select ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4392,a[2]=((C_word)li79),tmp=(C_word)a,a+=3,tmp));
t53=C_mutate2((C_word*)lf[181]+1 /* (set! seek/set ...) */,C_fix((C_word)SEEK_SET));
t54=C_mutate2((C_word*)lf[182]+1 /* (set! seek/end ...) */,C_fix((C_word)SEEK_END));
t55=C_mutate2((C_word*)lf[183]+1 /* (set! seek/cur ...) */,C_fix((C_word)SEEK_CUR));
t56=C_mutate2((C_word*)lf[184]+1 /* (set! set-file-position! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4776,a[2]=((C_word)li80),tmp=(C_word)a,a+=3,tmp));
t57=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4832,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t58=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8648,a[2]=((C_word)li241),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:644: getter-with-setter */
t59=*((C_word*)lf[446]+1);
((C_proc5)(void*)(*((C_word*)t59+1)))(5,t59,t57,t58,*((C_word*)lf[184]+1),lf[461]);}

/* current-process-id in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_4058(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4058,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fudge(C_fix(33)));}

/* memory-mapped-file? in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7357(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7357,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_i_structurep(t2,lf[386]));}

/* doloop1908 in k7820 in doloop1904 in k7805 in k7802 in process-execute in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 in ... */
static void C_fcall f_7858(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7858,NULL,4,t0,t1,t2,t3);}
if(C_truep(C_i_nullp(t2))){
/* posixunix.scm:1679: setenv */
f_7759(t1,t3,C_SCHEME_FALSE,C_fix(0));}
else{
t4=C_i_car(t2);
t5=C_i_check_string_2(t4,lf[423]);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7877,a[2]=t2,a[3]=t3,a[4]=((C_word*)t0)[3],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t7=C_block_size(t4);
/* posixunix.scm:1682: setenv */
f_7759(t6,t3,t4,t7);}}

/* file-write-access? in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5905(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5905,3,t0,t1,t2);}
/* posixunix.scm:1133: check */
f_5875(t1,t2,C_fix((C_word)W_OK),lf[319]);}

/* a3692 in k3683 in k3680 in k3677 in k3674 in k3671 in find-files in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3693(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3693,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}

/* a3695 in k3680 in k3677 in k3674 in k3671 in find-files in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3696(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3696,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}

/* a3698 in k3677 in k3674 in k3671 in find-files in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3699(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3699,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}

/* a6337 in k6171 in k6165 in custom-input-port in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_6338(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6338,2,t0,t1);}
t2=C_fixnum_lessp(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]);
if(C_truep(t2)){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
/* posixunix.scm:1278: ready? */
t3=((C_word*)t0)[4];
f_6174(t3,t1);}}

/* k7387 in string->time in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7389(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7389,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7393,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1542: ##sys#make-c-string */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(3,*((C_word*)lf[10]+1),t3,((C_word*)t0)[4]);}

/* k7802 in process-execute in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7804(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7804,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_7807,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp);
t3=C_block_size(t1);
/* posixunix.scm:1670: setarg */
f_7736(t2,C_fix(0),t1,t3);}

/* k7805 in k7802 in process-execute in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7807(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7807,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_7812,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t3,a[7]=((C_word)li193),tmp=(C_word)a,a+=8,tmp));
t5=((C_word*)t3)[1];
f_7812(t5,((C_word*)t0)[6],((C_word*)t0)[7],C_fix(1));}

/* set-signal-handler! in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_4041(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4041,4,t0,t1,t2,t3);}
t4=C_i_check_exact_2(t2,lf[116]);
if(C_truep(t3)){
t5=t2;
t6=C_establish_signal_handler(t2,t5);
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,C_i_vector_set(*((C_word*)lf[117]+1),t2,t3));}
else{
t5=C_establish_signal_handler(t2,C_SCHEME_FALSE);
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,C_i_vector_set(*((C_word*)lf[117]+1),t2,t3));}}

/* string->time in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7372(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_7372r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_7372r(t0,t1,t2,t3);}}

static void C_ccall f_7372r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(5);
t4=C_i_nullp(t3);
t5=(C_truep(t4)?lf[396]:C_i_car(t3));
t6=t5;
t7=C_i_check_string_2(t2,lf[395]);
t8=C_i_check_string_2(t6,lf[395]);
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7389,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t6,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1542: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),t9,t2,lf[395]);}

/* k6305 in k6171 in k6165 in custom-input-port in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_6307(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6307,2,t0,t1);}
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6311,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1342: set-port-name! */
t4=*((C_word*)lf[350]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,((C_word*)((C_word*)t0)[2])[1],((C_word*)t0)[4]);}

/* k4851 in k4842 in create-directory in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_4853(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4853,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[3]);}
else{
if(C_truep(((C_word*)t0)[4])){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4863,a[2]=((C_word*)t0)[5],tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4907,a[2]=((C_word*)t0)[3],a[3]=((C_word)li82),tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4913,a[2]=((C_word)li83),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:674: ##sys#call-with-values */
C_call_with_values(4,0,t2,t3,t4);}
else{
t2=((C_word*)t0)[5];
t3=((C_word*)t0)[3];
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4936,a[2]=t2,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:664: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),t4,t3,lf[191]);}}}

/* process-wait in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_4064(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+9)){
C_save_and_reclaim((void*)tr2r,(void*)f_4064r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_4064r(t0,t1,t2);}}

static void C_ccall f_4064r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word *a=C_alloc(9);
t3=C_i_nullp(t2);
t4=(C_truep(t3)?C_SCHEME_FALSE:C_i_car(t2));
t5=C_i_nullp(t2);
t6=(C_truep(t5)?C_SCHEME_END_OF_LIST:C_i_cdr(t2));
t7=C_i_nullp(t6);
t8=(C_truep(t7)?C_SCHEME_FALSE:C_i_car(t6));
t9=t8;
t10=C_i_nullp(t6);
t11=(C_truep(t10)?C_SCHEME_END_OF_LIST:C_i_cdr(t6));
t12=(C_truep(t4)?t4:C_fix(-1));
t13=t12;
t14=C_i_check_exact_2(t13,lf[120]);
t15=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4088,a[2]=t13,a[3]=t9,a[4]=((C_word)li64),tmp=(C_word)a,a+=5,tmp);
t16=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4094,a[2]=t13,a[3]=((C_word)li65),tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:611: ##sys#call-with-values */
C_call_with_values(4,0,t1,t15,t16);}

/* a3386 in conc-loop in glob in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3387(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3387,2,t0,t1);}
/* posix-common.scm:438: decompose-pathname */
t2=*((C_word*)lf[76]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,((C_word*)t0)[2]);}

/* for-each-loop1091 in set-signal-mask! in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static C_word C_fcall f_5323(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_stack_overflow_check;
loop:
if(C_truep(C_i_pairp(t1))){
t2=C_slot(t1,C_fix(0));
t3=C_i_check_exact_2(t2,lf[245]);
t4=C_sigaddset(t2);
t5=C_slot(t1,C_fix(1));
t8=t5;
t1=t8;
goto loop;}
else{
t2=C_SCHEME_UNDEFINED;
return(t2);}}

/* k5045 in open-input-pipe in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5047(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5047,2,t0,t1);}
t2=open_text_input_pipe(&a,1,t1);
/* posixunix.scm:712: check */
f_5011(((C_word*)t0)[3],lf[200],((C_word*)t0)[4],C_SCHEME_TRUE,t2);}

/* k5038 in open-input-pipe in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5040(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:712: check */
f_5011(((C_word*)t0)[3],lf[200],((C_word*)t0)[4],C_SCHEME_TRUE,t1);}

/* k5405 in k5401 in k5397 in k5390 in system-information in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5407(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5407,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5411,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
/* ##sys#peek-nonnull-c-string */
t4=*((C_word*)lf[254]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,C_mpointer(&a,(void*)C_utsname.version),C_fix(0));}

/* k5401 in k5397 in k5390 in system-information in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5403(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5403,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5407,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* ##sys#peek-nonnull-c-string */
t4=*((C_word*)lf[254]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,C_mpointer(&a,(void*)C_utsname.release),C_fix(0));}

/* memory-mapped-file-pointer in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7348(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7348,3,t0,t1,t2);}
t3=C_i_check_structure_2(t2,lf[386],lf[393]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_slot(t2,C_fix(1)));}

/* k4870 in loop in k4861 in k4851 in k4842 in create-directory in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_4872(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4872,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4875,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4898,a[2]=((C_word*)t0)[4],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:677: pathname-directory */
t4=*((C_word*)lf[193]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[3]);}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* k4873 in k4870 in loop in k4861 in k4851 in k4842 in create-directory in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_4875(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4875,2,t0,t1);}
t2=((C_word*)t0)[2];
t3=((C_word*)t0)[3];
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4891,a[2]=t2,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:664: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),t4,t3,lf[191]);}

/* file-execute-access? in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5911(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5911,3,t0,t1,t2);}
/* posixunix.scm:1134: check */
f_5875(t1,t2,C_fix((C_word)X_OK),lf[320]);}

/* create-session in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5917(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5917,2,t0,t1);}
t2=C_setsid(C_SCHEME_FALSE);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5921,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5927,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1139: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[5]+1)))(2,*((C_word*)lf[5]+1),t4);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t2);}}

/* k5055 in open-input-pipe in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5057(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5057,2,t0,t1);}
t2=open_binary_input_pipe(&a,1,t1);
/* posixunix.scm:712: check */
f_5011(((C_word*)t0)[3],lf[200],((C_word*)t0)[4],C_SCHEME_TRUE,t2);}

/* system-information in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5388(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5388,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5392,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_fixnum_lessp(C_fix((C_word)C_uname),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5421,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:912: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[5]+1)))(2,*((C_word*)lf[5]+1),t3);}
else{
t3=t2;
f_5392(2,t3,C_SCHEME_UNDEFINED);}}

/* k4842 in create-directory in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_4844(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4844,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4847,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=C_block_size(t2);
t5=C_eqp(C_fix(0),t4);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4853,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
if(C_truep(t5)){
t7=t6;
f_4853(2,t7,t5);}
else{
/* posixunix.scm:672: file-exists? */
t7=*((C_word*)lf[194]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,t2);}}

/* k5919 in create-session in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5921(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[3]);}

/* k4845 in k4842 in create-directory in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_4847(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[3]);}

/* k5925 in create-session in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5927(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1140: ##sys#error */
t2=*((C_word*)lf[41]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[321],lf[322]);}

/* open-output-pipe in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5066(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+10)){
C_save_and_reclaim((void*)tr3r,(void*)f_5066r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_5066r(t0,t1,t2,t3);}}

static void C_ccall f_5066r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a=C_alloc(10);
t4=C_i_check_string_2(t2,lf[204]);
t5=C_i_pairp(t3);
t6=(C_truep(t5)?C_slot(t3,C_fix(0)):lf[201]);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5080,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t8=C_eqp(t6,lf[201]);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5087,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:727: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),t9,t2,lf[204]);}
else{
t9=C_eqp(t6,lf[202]);
if(C_truep(t9)){
t10=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5097,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:728: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),t10,t2,lf[204]);}
else{
/* posixunix.scm:701: ##sys#error */
t10=*((C_word*)lf[41]+1);
((C_proc4)(void*)(*((C_word*)t10+1)))(4,t10,t7,lf[203],t6);}}}

/* k5390 in system-information in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5392(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5392,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5399,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[254]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.sysname),C_fix(0));}

/* k5397 in k5390 in system-information in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5399(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5399,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5403,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* ##sys#peek-nonnull-c-string */
t4=*((C_word*)lf[254]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,C_mpointer(&a,(void*)C_utsname.nodename),C_fix(0));}

/* k3764 in seconds->utc-time in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3766(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_i_check_number_2(t1,lf[103]);
/* posix-common.scm:521: ##sys#decode-seconds */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[101]+1)))(4,*((C_word*)lf[101]+1),((C_word*)t0)[2],t1,C_SCHEME_TRUE);}

/* seconds->utc-time in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3762(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr2r,(void*)f_3762r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3762r(t0,t1,t2);}}

static void C_ccall f_3762r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3766,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_i_nullp(t2))){
/* posix-common.scm:519: current-seconds */
t4=*((C_word*)lf[102]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t4=C_i_car(t2);
t5=C_i_check_number_2(t4,lf[103]);
/* posix-common.scm:521: ##sys#decode-seconds */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[101]+1)))(4,*((C_word*)lf[101]+1),t1,t4,C_SCHEME_TRUE);}}

/* k4021 in k4017 in scan in k3983 in loop in get-environment-variables in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_4023(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4023,2,t0,t1);}
t2=C_a_i_cons(&a,2,((C_word*)t0)[2],t1);
t3=t2;
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4011,a[2]=((C_word*)t0)[3],a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t5=C_fixnum_plus(((C_word*)t0)[4],C_fix(1));
/* posix-common.scm:582: loop */
t6=((C_word*)((C_word*)t0)[5])[1];
f_3981(t6,t4,t5);}

/* k4861 in k4851 in k4842 in create-directory in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_4863(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4863,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4865,a[2]=t3,a[3]=((C_word)li81),tmp=(C_word)a,a+=4,tmp));
t5=((C_word*)t3)[1];
f_4865(t5,((C_word*)t0)[2],t1);}

/* loop in k4861 in k4851 in k4842 in create-directory in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_4865(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4865,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4872,a[2]=t1,a[3]=t2,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
if(C_truep(t2)){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4905,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:676: directory? */
t5=*((C_word*)lf[36]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}
else{
t4=t3;
f_4872(t4,C_SCHEME_FALSE);}}

/* k3278 in loop in k3250 in k3246 in k3243 in k3240 in k3225 in directory in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3280(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3280,2,t0,t1);}
t2=t1;
t3=C_i_string_ref(t2,C_fix(0));
t4=C_fixnum_greaterp(((C_word*)t0)[2],C_fix(1));
t5=(C_truep(t4)?C_subchar(t2,C_fix(1)):C_SCHEME_FALSE);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3292,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t7=C_eqp(C_make_character(46),t3);
if(C_truep(t7)){
t8=C_i_not(t5);
if(C_truep(t8)){
t9=t6;
f_3292(t9,t8);}
else{
t9=C_eqp(C_make_character(46),t5);
if(C_truep(t9)){
t10=C_eqp(C_fix(2),((C_word*)t0)[2]);
t11=t6;
f_3292(t11,(C_truep(t10)?t10:C_i_not(((C_word*)t0)[5])));}
else{
t10=t6;
f_3292(t10,C_i_not(((C_word*)t0)[5]));}}}
else{
t8=t6;
f_3292(t8,C_SCHEME_FALSE);}}

/* k5085 in open-output-pipe in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5087(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5087,2,t0,t1);}
t2=open_text_output_pipe(&a,1,t1);
/* posixunix.scm:723: check */
f_5011(((C_word*)t0)[3],lf[204],((C_word*)t0)[4],C_SCHEME_FALSE,t2);}

/* k5078 in open-output-pipe in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5080(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:723: check */
f_5011(((C_word*)t0)[3],lf[204],((C_word*)t0)[4],C_SCHEME_FALSE,t1);}

/* signal-unmask! in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5372(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5372,3,t0,t1,t2);}
t3=C_i_check_exact_2(t2,lf[251]);
t4=C_sigemptyset(C_fix(0));
t5=C_sigaddset(t2);
t6=C_sigprocmask_unblock(C_fix(0));
if(C_truep(C_fixnum_lessp(t6,C_fix(0)))){
/* posixunix.scm:897: posix-error */
t7=lf[0];
f_2668(5,t7,t1,lf[122],lf[251],lf[252]);}
else{
t7=C_SCHEME_UNDEFINED;
t8=t1;
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,t7);}}

/* create-directory in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_4834(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f_4834r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4834r(t0,t1,t2,t3);}}

static void C_ccall f_4834r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a=C_alloc(4);
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=t5;
t7=C_i_check_string_2(t2,lf[191]);
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4844,a[2]=t1,a[3]=t6,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:670: ##sys#expand-home-path */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(3,*((C_word*)lf[12]+1),t8,t2);}

/* k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_4832(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word ab[128],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4832,2,t0,t1);}
t2=C_mutate2((C_word*)lf[190]+1 /* (set! file-position ...) */,t1);
t3=C_mutate2((C_word*)lf[191]+1 /* (set! create-directory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4834,a[2]=((C_word)li84),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate2((C_word*)lf[62]+1 /* (set! change-directory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4954,a[2]=((C_word)li85),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate2((C_word*)lf[196]+1 /* (set! change-directory* ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4977,a[2]=((C_word)li86),tmp=(C_word)a,a+=3,tmp));
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5011,a[2]=((C_word)li87),tmp=(C_word)a,a+=3,tmp);
t7=C_mutate2((C_word*)lf[200]+1 /* (set! open-input-pipe ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5026,a[2]=t6,a[3]=((C_word)li88),tmp=(C_word)a,a+=4,tmp));
t8=C_mutate2((C_word*)lf[204]+1 /* (set! open-output-pipe ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5066,a[2]=t6,a[3]=((C_word)li89),tmp=(C_word)a,a+=4,tmp));
t9=C_mutate2((C_word*)lf[205]+1 /* (set! close-input-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5106,a[2]=((C_word)li90),tmp=(C_word)a,a+=3,tmp));
t10=C_mutate2((C_word*)lf[207]+1 /* (set! close-output-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5121,a[2]=((C_word)li91),tmp=(C_word)a,a+=3,tmp));
t11=C_mutate2((C_word*)lf[209]+1 /* (set! call-with-input-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5136,a[2]=((C_word)li94),tmp=(C_word)a,a+=3,tmp));
t12=C_mutate2((C_word*)lf[210]+1 /* (set! call-with-output-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5160,a[2]=((C_word)li97),tmp=(C_word)a,a+=3,tmp));
t13=C_mutate2((C_word*)lf[211]+1 /* (set! with-input-from-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5184,a[2]=((C_word)li102),tmp=(C_word)a,a+=3,tmp));
t14=C_mutate2((C_word*)lf[213]+1 /* (set! with-output-to-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5218,a[2]=((C_word)li107),tmp=(C_word)a,a+=3,tmp));
t15=C_mutate2((C_word*)lf[215]+1 /* (set! create-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5252,a[2]=((C_word)li108),tmp=(C_word)a,a+=3,tmp));
t16=C_mutate2((C_word*)lf[217]+1 /* (set! signal/term ...) */,C_fix((C_word)SIGTERM));
t17=C_mutate2((C_word*)lf[218]+1 /* (set! signal/kill ...) */,C_fix((C_word)SIGKILL));
t18=C_mutate2((C_word*)lf[219]+1 /* (set! signal/int ...) */,C_fix((C_word)SIGINT));
t19=C_mutate2((C_word*)lf[220]+1 /* (set! signal/hup ...) */,C_fix((C_word)SIGHUP));
t20=C_mutate2((C_word*)lf[221]+1 /* (set! signal/fpe ...) */,C_fix((C_word)SIGFPE));
t21=C_mutate2((C_word*)lf[222]+1 /* (set! signal/ill ...) */,C_fix((C_word)SIGILL));
t22=C_mutate2((C_word*)lf[223]+1 /* (set! signal/segv ...) */,C_fix((C_word)SIGSEGV));
t23=C_mutate2((C_word*)lf[224]+1 /* (set! signal/abrt ...) */,C_fix((C_word)SIGABRT));
t24=C_mutate2((C_word*)lf[225]+1 /* (set! signal/trap ...) */,C_fix((C_word)SIGTRAP));
t25=C_mutate2((C_word*)lf[226]+1 /* (set! signal/quit ...) */,C_fix((C_word)SIGQUIT));
t26=C_mutate2((C_word*)lf[227]+1 /* (set! signal/alrm ...) */,C_fix((C_word)SIGALRM));
t27=C_mutate2((C_word*)lf[228]+1 /* (set! signal/vtalrm ...) */,C_fix((C_word)SIGVTALRM));
t28=C_mutate2((C_word*)lf[229]+1 /* (set! signal/prof ...) */,C_fix((C_word)SIGPROF));
t29=C_mutate2((C_word*)lf[230]+1 /* (set! signal/io ...) */,C_fix((C_word)SIGIO));
t30=C_mutate2((C_word*)lf[231]+1 /* (set! signal/urg ...) */,C_fix((C_word)SIGURG));
t31=C_mutate2((C_word*)lf[232]+1 /* (set! signal/chld ...) */,C_fix((C_word)SIGCHLD));
t32=C_mutate2((C_word*)lf[233]+1 /* (set! signal/cont ...) */,C_fix((C_word)SIGCONT));
t33=C_mutate2((C_word*)lf[234]+1 /* (set! signal/stop ...) */,C_fix((C_word)SIGSTOP));
t34=C_mutate2((C_word*)lf[235]+1 /* (set! signal/tstp ...) */,C_fix((C_word)SIGTSTP));
t35=C_mutate2((C_word*)lf[236]+1 /* (set! signal/pipe ...) */,C_fix((C_word)SIGPIPE));
t36=C_mutate2((C_word*)lf[237]+1 /* (set! signal/xcpu ...) */,C_fix((C_word)SIGXCPU));
t37=C_mutate2((C_word*)lf[238]+1 /* (set! signal/xfsz ...) */,C_fix((C_word)SIGXFSZ));
t38=C_mutate2((C_word*)lf[239]+1 /* (set! signal/usr1 ...) */,C_fix((C_word)SIGUSR1));
t39=C_mutate2((C_word*)lf[240]+1 /* (set! signal/usr2 ...) */,C_fix((C_word)SIGUSR2));
t40=C_mutate2((C_word*)lf[241]+1 /* (set! signal/winch ...) */,C_fix((C_word)SIGWINCH));
t41=C_mutate2((C_word*)lf[242]+1 /* (set! signal/bus ...) */,C_fix((C_word)SIGBUS));
t42=C_set_block_item(lf[243] /* signal/break */,0,C_fix(0));
t43=C_a_i_list(&a,26,*((C_word*)lf[217]+1),*((C_word*)lf[218]+1),*((C_word*)lf[219]+1),*((C_word*)lf[220]+1),*((C_word*)lf[221]+1),*((C_word*)lf[222]+1),*((C_word*)lf[223]+1),*((C_word*)lf[224]+1),*((C_word*)lf[225]+1),*((C_word*)lf[226]+1),*((C_word*)lf[227]+1),*((C_word*)lf[228]+1),*((C_word*)lf[229]+1),*((C_word*)lf[230]+1),*((C_word*)lf[231]+1),*((C_word*)lf[232]+1),*((C_word*)lf[233]+1),*((C_word*)lf[234]+1),*((C_word*)lf[235]+1),*((C_word*)lf[236]+1),*((C_word*)lf[237]+1),*((C_word*)lf[238]+1),*((C_word*)lf[239]+1),*((C_word*)lf[240]+1),*((C_word*)lf[241]+1),*((C_word*)lf[242]+1));
t44=C_mutate2((C_word*)lf[244]+1 /* (set! signals-list ...) */,t43);
t45=C_mutate2((C_word*)lf[245]+1 /* (set! set-signal-mask! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5299,a[2]=((C_word)li110),tmp=(C_word)a,a+=3,tmp));
t46=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5348,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t47=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8618,a[2]=((C_word)li240),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:869: getter-with-setter */
t48=*((C_word*)lf[446]+1);
((C_proc4)(void*)(*((C_word*)t48+1)))(4,t48,t46,t47,*((C_word*)lf[245]+1));}

/* k6393 in a6386 in k6171 in k6165 in custom-input-port in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_6395(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6395,NULL,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_6397,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t3,a[7]=((C_word*)t0)[6],a[8]=((C_word)li146),tmp=(C_word)a,a+=9,tmp));
t5=((C_word*)t3)[1];
f_6397(t5,((C_word*)t0)[7],t1,C_fix(0),((C_word*)t0)[8]);}

/* k5955 in create-symbolic-link in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5957(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5957,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5961,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5965,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1170: ##sys#expand-home-path */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(3,*((C_word*)lf[12]+1),t4,((C_word*)t0)[4]);}

/* k3290 in k3278 in loop in k3250 in k3246 in k3243 in k3240 in k3225 in directory in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_3292(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3292,NULL,2,t0,t1);}
if(C_truep(t1)){
/* posix-common.scm:426: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_3266(t2,((C_word*)t0)[3]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3302,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:427: loop */
t3=((C_word*)((C_word*)t0)[2])[1];
f_3266(t3,t2);}}

/* seconds->string in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3793(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr2r,(void*)f_3793r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3793r(t0,t1,t2);}}

static void C_ccall f_3793r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3797,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_i_nullp(t2))){
/* posix-common.scm:525: current-seconds */
t4=*((C_word*)lf[102]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t4=t3;
f_3797(2,t4,C_i_car(t2));}}

/* k4799 in k4787 in k4778 in set-file-position! in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_4801(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_truep(t1)){
t2=C_slot(((C_word*)t0)[2],C_fix(7));
t3=C_eqp(t2,lf[51]);
if(C_truep(t3)){
t4=C_fseek(((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)t0)[4]);
t5=((C_word*)t0)[5];
f_4795(2,t5,t4);}
else{
t4=((C_word*)t0)[5];
f_4795(2,t4,C_SCHEME_FALSE);}}
else{
if(C_truep(C_fixnump(((C_word*)t0)[2]))){
t2=C_lseek(((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)t0)[4]);
t3=((C_word*)t0)[5];
f_4795(2,t3,t2);}
else{
/* posixunix.scm:640: ##sys#signal-hook */
t2=*((C_word*)lf[1]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[5],lf[13],lf[184],lf[186],((C_word*)t0)[2]);}}}

/* k3795 in seconds->string in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3797(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3797,2,t0,t1);}
t2=t1;
t3=C_i_check_number_2(t2,lf[104]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3803,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t5=C_a_i_bytevector(&a,1,C_fix(3));
t6=C_i_foreign_integer_argumentp(t2);
t7=stub487(t5,t6);
/* posix-common.scm:524: ##sys#peek-c-string */
t8=*((C_word*)lf[4]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t4,t7,C_fix(0));}

/* k5959 in k5955 in create-symbolic-link in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5961(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_symlink(((C_word*)t0)[2],t1);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm:1172: posix-error */
t3=lf[0];
f_2668(7,t3,((C_word*)t0)[3],lf[8],lf[325],lf[326],((C_word*)t0)[4],((C_word*)t0)[5]);}
else{
t3=C_SCHEME_UNDEFINED;
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k5963 in k5955 in create-symbolic-link in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5965(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1170: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),((C_word*)t0)[2],t1,lf[324]);}

/* k5967 in create-symbolic-link in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5969(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1169: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),((C_word*)t0)[2],t1,lf[324]);}

/* a4093 in process-wait in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_4094(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_4094,5,t0,t1,t2,t3,t4);}
t5=C_eqp(t2,C_fix(-1));
if(C_truep(t5)){
/* posix-common.scm:613: posix-error */
t6=lf[0];
f_2668(6,t6,t1,lf[122],lf[120],lf[123],((C_word*)t0)[2]);}
else{
/* posix-common.scm:614: values */
C_values(5,0,t1,t2,t3,t4);}}

/* loop in k3250 in k3246 in k3243 in k3240 in k3225 in directory in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_3266(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3266,NULL,2,t0,t1);}
t2=C_readdir(((C_word*)t0)[2],((C_word*)t0)[3]);
if(C_truep(C_null_pointerp(((C_word*)t0)[3]))){
t3=C_closedir(((C_word*)t0)[2]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_END_OF_LIST);}
else{
t3=C_block_size(((C_word*)t0)[4]);
t4=C_foundfile(((C_word*)t0)[3],((C_word*)t0)[4],t3);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3280,a[2]=t4,a[3]=((C_word*)t0)[5],a[4]=t1,a[5]=((C_word*)t0)[6],tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:419: ##sys#substring */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[63]+1)))(5,*((C_word*)lf[63]+1),t5,((C_word*)t0)[4],C_fix(0),t4);}}

/* k7320 in unmap-file-from-memory in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_7322(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
t2=C_slot(((C_word*)t0)[2],C_fix(1));
t3=(C_truep(t2)?C_i_foreign_pointer_argumentp(t2):C_SCHEME_FALSE);
t4=C_i_foreign_integer_argumentp(t1);
t5=stub1694(C_SCHEME_UNDEFINED,t3,t4);
t6=C_eqp(C_fix(0),t5);
if(C_truep(t6)){
t7=C_SCHEME_UNDEFINED;
t8=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,t7);}
else{
/* posixunix.scm:1525: posix-error */
t7=lf[0];
f_2668(7,t7,((C_word*)t0)[3],lf[8],lf[391],lf[392],((C_word*)t0)[2],t1);}}

/* k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5934(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5934,2,t0,t1);}
t2=C_mutate2((C_word*)lf[323]+1 /* (set! process-group-id ...) */,t1);
t3=C_mutate2((C_word*)lf[324]+1 /* (set! create-symbolic-link ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5936,a[2]=((C_word)li132),tmp=(C_word)a,a+=3,tmp));
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5973,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t5=C_fixnum_plus(C_fix((C_word)FILENAME_MAX),C_fix(1));
/* ##sys#make-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[65]+1)))(4,*((C_word*)lf[65]+1),t4,t5,C_make_character(32));}

/* create-symbolic-link in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5936(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[8],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_5936,4,t0,t1,t2,t3);}
t4=C_i_check_string_2(t2,lf[324]);
t5=C_i_check_string_2(t3,lf[324]);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5957,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5969,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1169: ##sys#expand-home-path */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(3,*((C_word*)lf[12]+1),t7,t2);}

/* k7391 in k7387 in string->time in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7393(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[17],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7393,2,t0,t1);}
t2=t1;
t3=C_a_i_vector(&a,10,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE);
t4=t3;
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7401,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:1542: ##sys#make-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[65]+1)))(4,*((C_word*)lf[65]+1),t5,((C_word*)t0)[4],C_make_character(0));}

/* k3243 in k3240 in k3225 in directory in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3245(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3245,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3248,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* posix-common.scm:406: ##sys#make-pointer */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[74]+1)))(2,*((C_word*)lf[74]+1),t3);}

/* k3246 in k3243 in k3240 in k3225 in directory in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3248(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3248,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3252,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3336,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:409: ##sys#expand-home-path */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(3,*((C_word*)lf[12]+1),t4,((C_word*)t0)[4]);}

/* k3240 in k3225 in directory in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3242(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3242,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3245,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:405: ##sys#make-pointer */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[74]+1)))(2,*((C_word*)lf[74]+1),t3);}

/* read-symbolic-link in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5993(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f_5993r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_5993r(t0,t1,t2,t3);}}

static void C_ccall f_5993r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a=C_alloc(4);
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=t5;
t7=C_i_check_string_2(t2,lf[330]);
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6003,a[2]=t6,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1188: ##sys#expand-home-path */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(3,*((C_word*)lf[12]+1),t8,t2);}

/* k3250 in k3246 in k3243 in k3240 in k3225 in directory in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3252(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3252,2,t0,t1);}
t2=C_opendir(t1,((C_word*)t0)[2]);
if(C_truep(C_null_pointerp(((C_word*)t0)[2]))){
/* posix-common.scm:411: posix-error */
t3=lf[0];
f_2668(6,t3,((C_word*)t0)[3],lf[8],lf[25],lf[73],((C_word*)t0)[4]);}
else{
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3266,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=t4,a[6]=((C_word*)t0)[7],a[7]=((C_word)li27),tmp=(C_word)a,a+=8,tmp));
t6=((C_word*)t4)[1];
f_3266(t6,((C_word*)t0)[3]);}}

/* k6237 in k6234 in loop in fetch in k6171 in k6165 in custom-input-port in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in ... */
static void C_ccall f_6239(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1246: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_6217(2,t2,((C_word*)t0)[3]);}

/* k6234 in loop in fetch in k6171 in k6165 in custom-input-port in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 in ... */
static void C_ccall f_6236(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6236,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6239,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1245: ##sys#thread-yield! */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[343]+1)))(2,*((C_word*)lf[343]+1),t2);}

/* k3801 in k3795 in seconds->string in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3803(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=C_block_size(t1);
t3=C_fixnum_difference(t2,C_fix(1));
/* posix-common.scm:529: ##sys#substring */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[63]+1)))(5,*((C_word*)lf[63]+1),((C_word*)t0)[2],t1,C_fix(0),t3);}
else{
/* posix-common.scm:530: ##sys#error */
t2=*((C_word*)lf[41]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[104],lf[105],((C_word*)t0)[3]);}}

/* k3225 in directory in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3227(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3227,2,t0,t1);}
t2=t1;
t3=C_i_nullp(((C_word*)t0)[2]);
t4=(C_truep(t3)?C_SCHEME_END_OF_LIST:C_i_cdr(((C_word*)t0)[2]));
t5=C_i_nullp(t4);
t6=(C_truep(t5)?C_SCHEME_FALSE:C_i_car(t4));
t7=t6;
t8=C_i_nullp(t4);
t9=(C_truep(t8)?C_SCHEME_END_OF_LIST:C_i_cdr(t4));
t10=C_i_check_string_2(t2,lf[25]);
t11=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3242,a[2]=((C_word*)t0)[3],a[3]=t2,a[4]=t7,tmp=(C_word)a,a+=5,tmp);
/* ##sys#make-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[65]+1)))(4,*((C_word*)lf[65]+1),t11,C_fix(256),C_make_character(32));}

/* directory in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3223(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_3223r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3223r(t0,t1,t2);}}

static void C_ccall f_3223r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a=C_alloc(4);
t3=t2;
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3227,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t3))){
/* posix-common.scm:402: current-directory */
t5=*((C_word*)lf[61]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t5=t4;
f_3227(2,t5,C_i_car(t3));}}

/* k6267 in loop in fetch in k6171 in k6165 in custom-input-port in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 in ... */
static void C_ccall f_6269(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6269,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6272,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1255: ##sys#thread-yield! */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[343]+1)))(2,*((C_word*)lf[343]+1),t2);}
else{
t2=C_read(((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)t0)[6]);
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6278,a[2]=((C_word*)t0)[7],a[3]=t3,a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
t5=C_eqp(((C_word*)t3)[1],C_fix(-1));
if(C_truep(t5)){
t6=C_eqp(C_fix((C_word)errno),C_fix((C_word)EWOULDBLOCK));
t7=(C_truep(t6)?t6:C_eqp(C_fix((C_word)errno),C_fix((C_word)EAGAIN)));
if(C_truep(t7)){
t8=C_set_block_item(t3,0,C_fix(0));
t9=C_mutate2(((C_word *)((C_word*)t0)[7])+1,((C_word*)t3)[1]);
t10=C_set_block_item(((C_word*)t0)[8],0,C_fix(0));
t11=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t11+1)))(2,t11,t10);}
else{
/* posixunix.scm:1262: posix-error */
t8=lf[0];
f_2668(7,t8,t4,lf[8],((C_word*)t0)[9],lf[349],((C_word*)t0)[4],((C_word*)t0)[10]);}}
else{
t6=C_mutate2(((C_word *)((C_word*)t0)[7])+1,((C_word*)t3)[1]);
t7=C_set_block_item(((C_word*)t0)[8],0,C_fix(0));
t8=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,t7);}}}

/* k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5973(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word ab[186],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5973,2,t0,t1);}
t2=t1;
t3=C_mutate2((C_word*)lf[327]+1 /* (set! ##sys#read-symbolic-link ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5974,a[2]=t2,a[3]=((C_word)li133),tmp=(C_word)a,a+=4,tmp));
t4=C_mutate2((C_word*)lf[330]+1 /* (set! read-symbolic-link ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5993,a[2]=((C_word)li137),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate2((C_word*)lf[336]+1 /* (set! file-link ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6117,a[2]=((C_word)li138),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate2((C_word*)lf[339]+1 /* (set! ##sys#custom-input-port ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6139,a[2]=((C_word)li153),tmp=(C_word)a,a+=3,tmp));
t7=C_mutate2((C_word*)lf[355]+1 /* (set! ##sys#custom-output-port ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6662,a[2]=((C_word)li162),tmp=(C_word)a,a+=3,tmp));
t8=C_mutate2((C_word*)lf[359]+1 /* (set! file-truncate ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6923,a[2]=((C_word)li163),tmp=(C_word)a,a+=3,tmp));
t9=C_SCHEME_UNDEFINED;
t10=(*a=C_VECTOR_TYPE|1,a[1]=t9,tmp=(C_word)a,a+=2,tmp);
t11=C_SCHEME_UNDEFINED;
t12=(*a=C_VECTOR_TYPE|1,a[1]=t11,tmp=(C_word)a,a+=2,tmp);
t13=C_set_block_item(t10,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6962,a[2]=((C_word)li164),tmp=(C_word)a,a+=3,tmp));
t14=C_set_block_item(t12,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7027,a[2]=((C_word)li165),tmp=(C_word)a,a+=3,tmp));
t15=C_mutate2((C_word*)lf[364]+1 /* (set! file-lock ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7045,a[2]=t12,a[3]=t10,a[4]=((C_word)li166),tmp=(C_word)a,a+=5,tmp));
t16=C_mutate2((C_word*)lf[366]+1 /* (set! file-lock/blocking ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7061,a[2]=t12,a[3]=t10,a[4]=((C_word)li167),tmp=(C_word)a,a+=5,tmp));
t17=C_mutate2((C_word*)lf[368]+1 /* (set! file-test-lock ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7077,a[2]=t12,a[3]=t10,a[4]=((C_word)li168),tmp=(C_word)a,a+=5,tmp));
t18=C_mutate2((C_word*)lf[370]+1 /* (set! file-unlock ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7104,a[2]=((C_word)li169),tmp=(C_word)a,a+=3,tmp));
t19=C_mutate2((C_word*)lf[372]+1 /* (set! create-fifo ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7132,a[2]=((C_word)li170),tmp=(C_word)a,a+=3,tmp));
t20=C_mutate2((C_word*)lf[34]+1 /* (set! fifo? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7173,a[2]=((C_word)li171),tmp=(C_word)a,a+=3,tmp));
t21=C_mutate2((C_word*)lf[376]+1 /* (set! prot/read ...) */,C_fix((C_word)PROT_READ));
t22=C_mutate2((C_word*)lf[377]+1 /* (set! prot/write ...) */,C_fix((C_word)PROT_WRITE));
t23=C_mutate2((C_word*)lf[378]+1 /* (set! prot/exec ...) */,C_fix((C_word)PROT_EXEC));
t24=C_mutate2((C_word*)lf[379]+1 /* (set! prot/none ...) */,C_fix((C_word)PROT_NONE));
t25=C_mutate2((C_word*)lf[380]+1 /* (set! map/fixed ...) */,C_fix((C_word)MAP_FIXED));
t26=C_mutate2((C_word*)lf[381]+1 /* (set! map/shared ...) */,C_fix((C_word)MAP_SHARED));
t27=C_mutate2((C_word*)lf[382]+1 /* (set! map/private ...) */,C_fix((C_word)MAP_PRIVATE));
t28=C_mutate2((C_word*)lf[383]+1 /* (set! map/anonymous ...) */,C_fix((C_word)MAP_ANON));
t29=C_mutate2((C_word*)lf[384]+1 /* (set! map/file ...) */,C_fix((C_word)MAP_FILE));
t30=C_mutate2((C_word*)lf[385]+1 /* (set! map-file-to-memory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7255,a[2]=((C_word)li172),tmp=(C_word)a,a+=3,tmp));
t31=C_mutate2((C_word*)lf[391]+1 /* (set! unmap-file-from-memory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7315,a[2]=((C_word)li173),tmp=(C_word)a,a+=3,tmp));
t32=C_mutate2((C_word*)lf[393]+1 /* (set! memory-mapped-file-pointer ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7348,a[2]=((C_word)li174),tmp=(C_word)a,a+=3,tmp));
t33=C_mutate2((C_word*)lf[394]+1 /* (set! memory-mapped-file? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7357,a[2]=((C_word)li175),tmp=(C_word)a,a+=3,tmp));
t34=C_fix((C_word)sizeof(struct tm));
t35=C_mutate2((C_word*)lf[395]+1 /* (set! string->time ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7372,a[2]=t34,a[3]=((C_word)li176),tmp=(C_word)a,a+=4,tmp));
t36=C_fix((C_word)sizeof(struct tm));
t37=C_mutate2((C_word*)lf[397]+1 /* (set! utc-time->seconds ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7409,a[2]=t36,a[3]=((C_word)li177),tmp=(C_word)a,a+=4,tmp));
t38=C_mutate2((C_word*)lf[399]+1 /* (set! local-timezone-abbreviation ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7428,a[2]=((C_word)li178),tmp=(C_word)a,a+=3,tmp));
t39=C_mutate2((C_word*)lf[400]+1 /* (set! _exit ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7441,a[2]=((C_word)li179),tmp=(C_word)a,a+=3,tmp));
t40=C_mutate2((C_word*)lf[401]+1 /* (set! set-alarm! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7455,a[2]=((C_word)li180),tmp=(C_word)a,a+=3,tmp));
t41=C_mutate2((C_word*)lf[402]+1 /* (set! set-buffering-mode! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7462,a[2]=((C_word)li181),tmp=(C_word)a,a+=3,tmp));
t42=C_mutate2((C_word*)lf[408]+1 /* (set! terminal-port? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7525,a[2]=((C_word)li182),tmp=(C_word)a,a+=3,tmp));
t43=C_mutate2(&lf[409] /* (set! ##sys#terminal-check ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7543,a[2]=((C_word)li183),tmp=(C_word)a,a+=3,tmp));
t44=C_mutate2((C_word*)lf[411]+1 /* (set! terminal-name ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7574,a[2]=((C_word)li184),tmp=(C_word)a,a+=3,tmp));
t45=C_mutate2((C_word*)lf[412]+1 /* (set! terminal-size ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7598,a[2]=((C_word)li185),tmp=(C_word)a,a+=3,tmp));
t46=C_mutate2((C_word*)lf[417]+1 /* (set! get-host-name ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7635,a[2]=((C_word)li186),tmp=(C_word)a,a+=3,tmp));
t47=C_mutate2((C_word*)lf[419]+1 /* (set! process-fork ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7649,a[2]=((C_word)li189),tmp=(C_word)a,a+=3,tmp));
t48=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7736,a[2]=((C_word)li190),tmp=(C_word)a,a+=3,tmp);
t49=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7759,a[2]=((C_word)li191),tmp=(C_word)a,a+=3,tmp);
t50=*((C_word*)lf[422]+1);
t51=C_mutate2((C_word*)lf[423]+1 /* (set! process-execute ...) */,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7782,a[2]=t49,a[3]=t48,a[4]=t50,a[5]=((C_word)li194),tmp=(C_word)a,a+=6,tmp));
t52=C_mutate2((C_word*)lf[121]+1 /* (set! ##sys#process-wait ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7942,a[2]=((C_word)li196),tmp=(C_word)a,a+=3,tmp));
t53=C_mutate2((C_word*)lf[425]+1 /* (set! parent-process-id ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7980,a[2]=((C_word)li197),tmp=(C_word)a,a+=3,tmp));
t54=C_mutate2((C_word*)lf[426]+1 /* (set! sleep ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7983,a[2]=((C_word)li198),tmp=(C_word)a,a+=3,tmp));
t55=C_mutate2((C_word*)lf[427]+1 /* (set! process-signal ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7990,a[2]=((C_word)li199),tmp=(C_word)a,a+=3,tmp));
t56=C_mutate2((C_word*)lf[429]+1 /* (set! ##sys#shell-command ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8015,a[2]=((C_word)li200),tmp=(C_word)a,a+=3,tmp));
t57=C_mutate2((C_word*)lf[433]+1 /* (set! ##sys#shell-command-arguments ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8024,a[2]=((C_word)li201),tmp=(C_word)a,a+=3,tmp));
t58=C_mutate2((C_word*)lf[435]+1 /* (set! process-run ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8030,a[2]=((C_word)li202),tmp=(C_word)a,a+=3,tmp));
t59=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8084,a[2]=((C_word)li206),tmp=(C_word)a,a+=3,tmp);
t60=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8121,a[2]=((C_word)li209),tmp=(C_word)a,a+=3,tmp);
t61=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8141,a[2]=((C_word)li210),tmp=(C_word)a,a+=3,tmp);
t62=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8153,a[2]=((C_word)li211),tmp=(C_word)a,a+=3,tmp);
t63=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8168,a[2]=((C_word)li212),tmp=(C_word)a,a+=3,tmp);
t64=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_8182,a[2]=t63,a[3]=t62,a[4]=t60,a[5]=((C_word)li214),tmp=(C_word)a,a+=6,tmp);
t65=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8227,a[2]=t61,a[3]=((C_word)li215),tmp=(C_word)a,a+=4,tmp);
t66=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8238,a[2]=t61,a[3]=((C_word)li216),tmp=(C_word)a,a+=4,tmp);
t67=C_mutate2((C_word*)lf[437]+1 /* (set! ##sys#process ...) */,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_8249,a[2]=t64,a[3]=t65,a[4]=t59,a[5]=t66,a[6]=((C_word)li219),tmp=(C_word)a,a+=7,tmp));
t68=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8305,a[2]=((C_word)li224),tmp=(C_word)a,a+=3,tmp);
t69=C_mutate2((C_word*)lf[438]+1 /* (set! process ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8376,a[2]=t68,a[3]=((C_word)li226),tmp=(C_word)a,a+=4,tmp));
t70=C_mutate2((C_word*)lf[439]+1 /* (set! process* ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8424,a[2]=t68,a[3]=((C_word)li227),tmp=(C_word)a,a+=4,tmp));
t71=C_mutate2((C_word*)lf[441]+1 /* (set! set-root-directory! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8479,a[2]=((C_word)li228),tmp=(C_word)a,a+=3,tmp));
t72=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t72+1)))(2,t72,C_SCHEME_UNDEFINED);}

/* ##sys#read-symbolic-link in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5974(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_5974,4,t0,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5979,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t3,a[5]=t2,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:1181: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),t4,t2,t3);}

/* k5977 in read-symbolic-link in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5979(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_do_readlink(t1,((C_word*)t0)[2]);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm:1183: posix-error */
t3=lf[0];
f_2668(6,t3,((C_word*)t0)[3],lf[8],((C_word*)t0)[4],lf[328],((C_word*)t0)[5]);}
else{
/* posixunix.scm:1184: substring */
t3=*((C_word*)lf[329]+1);
((C_proc5)(void*)(*((C_word*)t3+1)))(5,t3,((C_word*)t0)[3],((C_word*)t0)[2],C_fix(0),t2);}}

/* k4337 in k4331 in k4328 in file-write in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_4339(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[3]);}

/* k4331 in k4328 in file-write in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_4333(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4333,NULL,2,t0,t1);}
t2=C_i_check_exact_2(t1,lf[171]);
t3=C_write(((C_word*)t0)[2],((C_word*)t0)[3],t1);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4339,a[2]=((C_word*)t0)[4],a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t5=C_eqp(C_fix(-1),t3);
if(C_truep(t5)){
/* posixunix.scm:546: posix-error */
t6=lf[0];
f_2668(7,t6,t4,lf[8],lf[171],lf[172],((C_word*)t0)[2],t1);}
else{
t6=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t3);}}

/* k4328 in file-write in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_4330(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4330,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4333,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_pairp(((C_word*)t0)[5]))){
t3=((C_word*)t0)[5];
t4=t2;
f_4333(t4,C_u_i_car(t3));}
else{
t3=t2;
f_4333(t3,C_block_size(((C_word*)t0)[3]));}}

/* port->fileno in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3022(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3022,3,t0,t1,t2);}
t3=t2;
t4=C_i_check_port_2(t3,C_fix(0),C_SCHEME_TRUE,lf[54]);
t5=C_slot(t2,C_fix(7));
t6=C_eqp(lf[29],t5);
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3038,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:342: ##sys#port-data */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[55]+1)))(3,*((C_word*)lf[55]+1),t7,t2);}
else{
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3064,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:343: ##sys#peek-unsigned-integer */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[58]+1)))(4,*((C_word*)lf[58]+1),t7,t2,C_fix(0));}}

/* k3199 in for-each-loop270 in k3161 in k3155 in delete-directory in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3201(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_slot(((C_word*)t0)[2],C_fix(1));
t3=((C_word*)((C_word*)t0)[3])[1];
f_3191(t3,((C_word*)t0)[4],t2);}

/* k3018 in open-output-file* in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3020(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3020,2,t0,t1);}
t2=C_fdopen(&a,2,((C_word*)t0)[2],t1);
/* posix-common.scm:332: check */
f_2979(((C_word*)t0)[4],lf[53],((C_word*)t0)[2],C_SCHEME_FALSE,t2);}

/* k8494 in set-root-directory! in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_8496(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(C_fixnum_lessp(t1,C_fix(0)))){
/* posixunix.scm:1873: posix-error */
t2=lf[0];
f_2668(6,t2,((C_word*)t0)[2],lf[8],lf[441],lf[442],((C_word*)t0)[3]);}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* k6309 in k6305 in k6171 in k6165 in custom-input-port in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_6311(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)((C_word*)t0)[3])[1]);}

/* a6312 in k6171 in k6165 in custom-input-port in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_6313(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6313,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6317,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[3])[1],((C_word*)((C_word*)t0)[4])[1]))){
/* posixunix.scm:1272: fetch */
t3=((C_word*)t0)[5];
f_6211(t3,t2);}
else{
t3=t2;
f_6317(2,t3,C_SCHEME_UNDEFINED);}}

/* k6315 in a6312 in k6171 in k6165 in custom-input-port in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_6317(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
t2=f_6203(((C_word*)t0)[2]);
if(C_truep(C_eofp(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
t3=C_fixnum_plus(((C_word*)((C_word*)t0)[4])[1],C_fix(1));
t4=C_mutate2(((C_word *)((C_word*)t0)[4])+1,t3);
t5=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t2);}}

/* check in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_5011(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5011,NULL,5,t1,t2,t3,t4,t5);}
if(C_truep(C_null_pointerp(t5))){
/* posixunix.scm:704: posix-error */
t6=lf[0];
f_2668(6,t6,t1,lf[8],t2,lf[198],t3);}
else{
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5024,a[2]=t5,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:705: ##sys#make-port */
((C_proc6)C_fast_retrieve_proc(*((C_word*)lf[48]+1)))(6,*((C_word*)lf[48]+1),t6,t4,*((C_word*)lf[49]+1),lf[199],lf[51]);}}

/* k6270 in k6267 in loop in fetch in k6171 in k6165 in custom-input-port in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in ... */
static void C_ccall f_6272(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1256: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_6217(2,t2,((C_word*)t0)[3]);}

/* k6276 in k6267 in loop in fetch in k6171 in k6165 in custom-input-port in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in ... */
static void C_ccall f_6278(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_set_block_item(((C_word*)t0)[4],0,C_fix(0));
t4=((C_word*)t0)[5];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k4009 in k4021 in k4017 in scan in k3983 in loop in get-environment-variables in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_4011(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4011,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_i_cons(&a,2,((C_word*)t0)[3],t1));}

/* k5022 in check in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5024(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_set_file_ptr(t1,((C_word*)t0)[2]);
t3=t1;
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* open-input-pipe in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5026(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+10)){
C_save_and_reclaim((void*)tr3r,(void*)f_5026r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_5026r(t0,t1,t2,t3);}}

static void C_ccall f_5026r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a=C_alloc(10);
t4=C_i_check_string_2(t2,lf[200]);
t5=C_i_pairp(t3);
t6=(C_truep(t5)?C_slot(t3,C_fix(0)):lf[201]);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5040,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t8=C_eqp(t6,lf[201]);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5047,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:716: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),t9,t2,lf[200]);}
else{
t9=C_eqp(t6,lf[202]);
if(C_truep(t9)){
t10=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5057,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:717: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),t10,t2,lf[200]);}
else{
/* posixunix.scm:701: ##sys#error */
t10=*((C_word*)lf[41]+1);
((C_proc4)(void*)(*((C_word*)t10+1)))(4,t10,t7,lf[203],t6);}}}

/* k4017 in scan in k3983 in loop in get-environment-variables in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_4019(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4019,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4023,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t4=C_fixnum_plus(((C_word*)t0)[5],C_fix(1));
t5=C_block_size(((C_word*)t0)[6]);
/* posix-common.scm:581: ##sys#substring */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[63]+1)))(5,*((C_word*)lf[63]+1),t3,((C_word*)t0)[6],t4,t5);}

/* open-output-file* in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3008(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_3008r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3008r(t0,t1,t2,t3);}}

static void C_ccall f_3008r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t4=C_i_check_exact_2(t2,lf[53]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3020,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:332: mode */
f_2942(t5,C_SCHEME_FALSE,t3,lf[53]);}

/* k3004 in open-input-file* in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3006(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3006,2,t0,t1);}
t2=C_fdopen(&a,2,((C_word*)t0)[2],t1);
/* posix-common.scm:328: check */
f_2979(((C_word*)t0)[4],lf[52],((C_word*)t0)[2],C_SCHEME_TRUE,t2);}

/* k4365 in file-mkstemp in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_4367(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4367,2,t0,t1);}
t2=t1;
t3=C_mkstemp(t2);
t4=C_block_size(t2);
t5=t4;
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4373,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=t5,a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t7=C_eqp(C_fix(-1),t3);
if(C_truep(t7)){
/* posixunix.scm:556: posix-error */
t8=lf[0];
f_2668(6,t8,t6,lf[8],lf[174],lf[175],((C_word*)t0)[3]);}
else{
t8=t6;
f_4373(2,t8,C_SCHEME_UNDEFINED);}}

/* file-mkstemp in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_4360(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4360,3,t0,t1,t2);}
t3=C_i_check_string_2(t2,lf[174]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4367,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:552: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[10]+1)))(4,*((C_word*)lf[10]+1),t4,t2,lf[174]);}

/* unmap-file-from-memory in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7315(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f_7315r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_7315r(t0,t1,t2,t3);}}

static void C_ccall f_7315r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(4);
t4=C_i_check_structure_2(t2,lf[386],lf[391]);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7322,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_pairp(t3))){
t6=t3;
t7=t5;
f_7322(t7,C_u_i_car(t6));}
else{
t6=t5;
f_7322(t6,C_slot(t2,C_fix(2)));}}

/* k4371 in k4365 in file-mkstemp in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_4373(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4373,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4380,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=C_fixnum_difference(((C_word*)t0)[4],C_fix(1));
/* posixunix.scm:557: ##sys#substring */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[63]+1)))(5,*((C_word*)lf[63]+1),t2,((C_word*)t0)[5],C_fix(0),t3);}

/* k4378 in k4371 in k4365 in file-mkstemp in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_4380(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:557: values */
C_values(4,0,((C_word*)t0)[2],((C_word*)t0)[3],t1);}

/* doloop1226 in k5681 in set-groups! in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_5688(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a;
loop:
a=C_alloc(4);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_5688,NULL,4,t0,t1,t2,t3);}
if(C_truep(C_i_nullp(t2))){
t4=C_set_groups(t3);
if(C_truep(C_fixnum_lessp(t4,C_fix(0)))){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5704,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1046: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[5]+1)))(2,*((C_word*)lf[5]+1),t5);}
else{
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_SCHEME_UNDEFINED);}}
else{
t4=C_slot(t2,C_fix(0));
t5=C_i_check_exact_2(t4,lf[270]);
t6=C_set_gid(t3,t4);
t7=C_slot(t2,C_fix(1));
t8=C_fixnum_plus(t3,C_fix(1));
t12=t1;
t13=t7;
t14=t8;
t1=t12;
t2=t13;
t3=t14;
goto loop;}}

/* k5681 in set-groups! in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5683(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5683,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5688,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=((C_word)li122),tmp=(C_word)a,a+=5,tmp));
t5=((C_word*)t3)[1];
f_5688(t5,((C_word*)t0)[3],((C_word*)t0)[2],C_fix(0));}

/* k4397 in k4394 in file-select in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_4399(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4399,NULL,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4402,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
t4=((C_word*)t0)[5];
if(C_truep(t4)){
if(C_truep(C_fixnump(((C_word*)t0)[5]))){
t5=t3;
f_4402(t5,C_a_i_list1(&a,1,((C_word*)t0)[5]));}
else{
t5=C_i_check_list_2(((C_word*)t0)[5],lf[176]);
t6=((C_word*)t0)[5];
t7=t3;
f_4402(t7,t6);}}
else{
t5=t3;
f_4402(t5,C_SCHEME_END_OF_LIST);}}

/* k4394 in file-select in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_4396(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4396,NULL,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4399,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t4=((C_word*)t0)[3];
if(C_truep(t4)){
if(C_truep(C_fixnump(((C_word*)t0)[3]))){
t5=t3;
f_4399(t5,C_a_i_list1(&a,1,((C_word*)t0)[3]));}
else{
t5=C_i_check_list_2(((C_word*)t0)[3],lf[176]);
t6=((C_word*)t0)[3];
t7=t3;
f_4399(t7,t6);}}
else{
t5=t3;
f_4399(t5,C_SCHEME_END_OF_LIST);}}

/* file-select in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_4392(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_4392r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_4392r(t0,t1,t2,t3,t4);}}

static void C_ccall f_4392r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4396,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_pairp(t4))){
t6=t4;
t7=t5;
f_4396(t7,C_u_i_car(t6));}
else{
t6=t5;
f_4396(t6,C_SCHEME_FALSE);}}

/* current-directory in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3097(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr2r,(void*)f_3097r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3097r(t0,t1,t2);}}

static void C_ccall f_3097r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(3);
t3=C_i_nullp(t2);
t4=(C_truep(t3)?C_SCHEME_FALSE:C_i_car(t2));
if(C_truep(t4)){
/* posix-common.scm:367: change-directory */
t5=*((C_word*)lf[62]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t1,t4);}
else{
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3110,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* ##sys#make-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[65]+1)))(4,*((C_word*)lf[65]+1),t5,C_fix(1024),C_make_character(32));}}

/* k7415 in k7411 in utc-time->seconds in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7417(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7417,2,t0,t1);}
t2=C_a_timegm(&a,2,((C_word*)t0)[2],t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7423,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1549: fp= */
t4=*((C_word*)lf[108]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,lf[109],t2);}

/* k7411 in utc-time->seconds in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7413(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7413,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7417,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1548: ##sys#make-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[65]+1)))(4,*((C_word*)lf[65]+1),t2,((C_word*)t0)[4],C_make_character(0));}

/* peek in k6171 in k6165 in custom-input-port in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static C_word C_fcall f_6203(C_word t0){
C_word tmp;
C_word t1;
C_word t2;
C_stack_overflow_check;
if(C_truep(C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]))){
return(C_SCHEME_END_OF_FILE);}
else{
t1=C_subchar(((C_word*)t0)[4],((C_word*)((C_word*)t0)[2])[1]);
return(t1);}}

/* utc-time->seconds in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7409(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7409,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7413,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1547: check-time-vector */
f_3722(t3,lf[397],t2);}

/* k7399 in k7391 in k7387 in string->time in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7401(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=((C_word*)t0)[2];
if(C_truep(t1)){
t3=C_i_foreign_block_argumentp(t1);
t4=t2;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,stub1716(C_SCHEME_UNDEFINED,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],t3));}
else{
t3=t2;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,stub1716(C_SCHEME_UNDEFINED,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],C_SCHEME_FALSE));}}

/* duplicate-fileno in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3070(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f_3070r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3070r(t0,t1,t2,t3);}}

static void C_ccall f_3070r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(4);
t4=C_i_check_exact_2(t2,*((C_word*)lf[59]+1));
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3077,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t3))){
t6=t5;
f_3077(t6,C_dup(t2));}
else{
t6=C_i_car(t3);
t7=C_i_check_exact_2(t6,lf[59]);
t8=t5;
f_3077(t8,C_dup2(t2,t6));}}

/* k5095 in open-output-pipe in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5097(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5097,2,t0,t1);}
t2=open_binary_output_pipe(&a,1,t1);
/* posixunix.scm:723: check */
f_5011(((C_word*)t0)[3],lf[204],((C_word*)t0)[4],C_SCHEME_FALSE,t2);}

/* k3075 in duplicate-fileno in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_3077(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3077,NULL,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3080,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
/* posix-common.scm:359: posix-error */
t4=lf[0];
f_2668(6,t4,t3,lf[8],lf[59],lf[60],((C_word*)t0)[3]);}
else{
t4=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t2);}}

/* k3078 in k3075 in duplicate-fileno in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_3080(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[3]);}

/* local-timezone-abbreviation in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7428(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7428,2,t0,t1);}
t2=C_a_i_bytevector(&a,1,C_fix(3));
t3=stub1746(t2);
/* posixunix.scm:1554: ##sys#peek-c-string */
t4=*((C_word*)lf[4]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t1,t3,C_fix(0));}

/* _exit in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7441(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+0)){
C_save_and_reclaim((void*)tr2r,(void*)f_7441r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_7441r(t0,t1,t2);}}

static void C_ccall f_7441r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
if(C_truep(C_i_pairp(t2))){
t3=t2;
t4=C_u_i_car(t3);
t5=t1;
t6=C_i_foreign_fixnum_argumentp(t4);
t7=t5;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,stub1752(C_SCHEME_UNDEFINED,t6));}
else{
t3=t1;
t4=C_i_foreign_fixnum_argumentp(C_fix(0));
t5=t3;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,stub1752(C_SCHEME_UNDEFINED,t4));}}

/* fetch in k6171 in k6165 in custom-input-port in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_6211(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6211,NULL,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_6217,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t3,a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],a[11]=((C_word)li140),tmp=(C_word)a,a+=12,tmp));
t5=((C_word*)t3)[1];
f_6217(2,t5,t1);}

/* loop in fetch in k6171 in k6165 in custom-input-port in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_6217(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word ab[11],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6217,2,t0,t1);}
t2=C_read(((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)t0)[4]);
t3=C_eqp(t2,C_fix(-1));
if(C_truep(t3)){
t4=C_fix((C_word)errno);
t5=C_i_eqvp(t4,C_fix((C_word)EWOULDBLOCK));
t6=(C_truep(t5)?t5:C_i_eqvp(t4,C_fix((C_word)EAGAIN)));
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6236,a[2]=((C_word*)t0)[5],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1244: ##sys#thread-block-for-i/o! */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[344]+1)))(5,*((C_word*)lf[344]+1),t7,*((C_word*)lf[345]+1),((C_word*)t0)[2],lf[346]);}
else{
if(C_truep(C_i_eqvp(t4,C_fix((C_word)EINTR)))){
/* posixunix.scm:1248: ##sys#dispatch-interrupt */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[347]+1)))(3,*((C_word*)lf[347]+1),t1,((C_word*)((C_word*)t0)[5])[1]);}
else{
/* posixunix.scm:1249: posix-error */
t7=lf[0];
f_2668(7,t7,t1,lf[8],((C_word*)t0)[6],lf[348],((C_word*)t0)[2],((C_word*)t0)[7]);}}}
else{
t4=(C_truep(((C_word*)t0)[8])?C_eqp(t2,C_fix(0)):C_SCHEME_FALSE);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_6269,a[2]=((C_word*)t0)[5],a[3]=t1,a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[6],a[10]=((C_word*)t0)[7],tmp=(C_word)a,a+=11,tmp);
/* posixunix.scm:1253: more? */
t6=((C_word*)t0)[8];
((C_proc2)C_fast_retrieve_proc(t6))(2,t6,t5);}
else{
t5=C_mutate2(((C_word *)((C_word*)t0)[9])+1,t2);
t6=C_set_block_item(((C_word*)t0)[10],0,C_fix(0));
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}}}

/* set-alarm! in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7455(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7455,3,t0,t1,t2);}
t3=C_i_foreign_fixnum_argumentp(t2);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,stub1758(C_SCHEME_UNDEFINED,t3));}

/* k7470 in k7467 in k7464 in set-buffering-mode! in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7472(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7472,2,t0,t1);}
t2=t1;
t3=C_i_check_exact_2(((C_word*)t0)[2],lf[402]);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7481,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t2,a[5]=((C_word*)t0)[2],tmp=(C_word)a,a+=6,tmp);
t5=C_slot(((C_word*)t0)[4],C_fix(7));
t6=C_eqp(lf[51],t5);
if(C_truep(t6)){
t7=C_setvbuf(((C_word*)t0)[4],t2,((C_word*)t0)[2]);
t8=t4;
f_7481(t8,C_fixnum_lessp(t7,C_fix(0)));}
else{
t7=t4;
f_7481(t7,C_SCHEME_TRUE);}}

/* loop in k5623 in k5620 in k5617 in get-groups in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_5630(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
loop:
a=C_alloc(4);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_5630,NULL,3,t0,t1,t2);}
if(C_truep(C_fixnum_greater_or_equal_p(t2,((C_word*)t0)[2]))){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_END_OF_LIST);}
else{
t3=C_get_gid(t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5645,a[2]=t1,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t5=C_fixnum_plus(t2,C_fix(1));
/* posixunix.scm:1037: loop */
t7=t4;
t8=t5;
t1=t7;
t2=t8;
goto loop;}}

/* set-buffering-mode! in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7462(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4r,(void*)f_7462r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_7462r(t0,t1,t2,t3,t4);}}

static void C_ccall f_7462r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(6);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7466,a[2]=t3,a[3]=t1,a[4]=t2,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:1581: ##sys#check-port */
t6=*((C_word*)lf[363]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t5,t2,lf[402]);}

/* k5653 in k5620 in k5617 in get-groups in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5655(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1033: ##sys#error */
t2=*((C_word*)lf[41]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[266],lf[267]);}

/* file-write in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_4323(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4r,(void*)f_4323r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_4323r(t0,t1,t2,t3,t4);}}

static void C_ccall f_4323r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t5=C_i_check_exact_2(t2,lf[171]);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4330,a[2]=t2,a[3]=t3,a[4]=t1,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
if(C_truep(C_blockp(t3))){
if(C_truep(C_byteblockp(t3))){
t7=t6;
f_4330(2,t7,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm:541: ##sys#signal-hook */
t7=*((C_word*)lf[1]+1);
((C_proc6)(void*)(*((C_word*)t7+1)))(6,t7,t6,lf[13],lf[171],lf[173],t3);}}
else{
/* posixunix.scm:541: ##sys#signal-hook */
t7=*((C_word*)lf[1]+1);
((C_proc6)(void*)(*((C_word*)t7+1)))(6,t7,t6,lf[13],lf[171],lf[173],t3);}}

/* k7467 in k7464 in set-buffering-mode! in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_7469(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7469,NULL,2,t0,t1);}
t2=t1;
t3=((C_word*)t0)[2];
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7472,a[2]=t2,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t5=C_eqp(t3,lf[404]);
if(C_truep(t5)){
t6=t4;
f_7472(2,t6,C_fix((C_word)_IOFBF));}
else{
t6=C_eqp(t3,lf[405]);
if(C_truep(t6)){
t7=C_fix((C_word)_IOLBF);
t8=t4;
f_7472(2,t8,t7);}
else{
t7=C_eqp(t3,lf[406]);
if(C_truep(t7)){
t8=t4;
f_7472(2,t8,C_fix((C_word)_IONBF));}
else{
/* posixunix.scm:1587: ##sys#error */
t8=*((C_word*)lf[41]+1);
((C_proc6)(void*)(*((C_word*)t8+1)))(6,t8,t4,lf[402],lf[407],((C_word*)t0)[2],((C_word*)t0)[4]);}}}}

/* k7464 in set-buffering-mode! in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7466(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7466,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7469,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_pairp(((C_word*)t0)[5]))){
t3=((C_word*)t0)[5];
t4=t2;
f_7469(t4,C_u_i_car(t3));}
else{
t3=t2;
f_7469(t3,C_fix((C_word)BUFSIZ));}}

/* k7479 in k7470 in k7467 in k7464 in set-buffering-mode! in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_fcall f_7481(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
/* posixunix.scm:1593: ##sys#error */
t2=*((C_word*)lf[41]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[2],lf[402],lf[403],((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5]);}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* k5620 in k5617 in get-groups in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5622(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5622,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5625,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=C_i_foreign_fixnum_argumentp(((C_word*)t0)[2]);
t4=stub1205(C_SCHEME_UNDEFINED,t3);
if(C_truep(C_fixnum_lessp(t4,C_fix(0)))){
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5655,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1032: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[5]+1)))(2,*((C_word*)lf[5]+1),t5);}
else{
t5=t2;
f_5625(2,t5,C_SCHEME_UNDEFINED);}}

/* k5623 in k5620 in k5617 in get-groups in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5625(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5625,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5630,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=((C_word)li120),tmp=(C_word)a,a+=5,tmp));
t5=((C_word*)t3)[1];
f_5630(t5,((C_word*)t0)[3],C_fix(0));}

/* set-groups! in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5679(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5679,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5683,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=C_i_length(t2);
t5=C_i_foreign_fixnum_argumentp(t4);
if(C_truep(stub1210(C_SCHEME_UNDEFINED,t5))){
t6=t3;
f_5683(2,t6,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm:1041: ##sys#error */
t6=*((C_word*)lf[41]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t3,lf[270],lf[272]);}}

/* k5672 in get-groups in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5674(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm:1028: ##sys#error */
t2=*((C_word*)lf[41]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[266],lf[269]);}

/* k5643 in loop in k5623 in k5620 in k5617 in get-groups in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_5645(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5645,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_i_cons(&a,2,((C_word*)t0)[3],t1));}

/* f_7696 in k7666 in process-fork in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7696(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7696,3,t0,t1,t2);}
/* posixunix.scm:1651: thunk */
t3=t2;
((C_proc2)C_fast_retrieve_proc(t3))(2,t3,t1);}

/* k7684 in a7681 in k7666 in process-fork in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7686(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=((C_word*)t0)[2];
t3=C_i_foreign_fixnum_argumentp(C_fix(0));
t4=t2;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,stub1851(C_SCHEME_UNDEFINED,t3));}

/* a7681 in k7666 in process-fork in k5971 in k5932 in k5438 in k5434 in k5430 in k5426 in k5346 in k4830 in k4054 in k3718 in k2748 in k2654 in k2651 in k2648 in k2645 in k2642 */
static void C_ccall f_7682(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7682,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7686,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1653: thunk */
t3=((C_word*)t0)[2];
((C_proc2)C_fast_retrieve_proc(t3))(2,t3,t2);}

#ifdef C_ENABLE_PTABLES
static C_PTABLE_ENTRY ptable[610] = {
{"f_7635:posixunix_2escm",(void*)f_7635},
{"f_7639:posixunix_2escm",(void*)f_7639},
{"f_7627:posixunix_2escm",(void*)f_7627},
{"f_7623:posixunix_2escm",(void*)f_7623},
{"f_7649:posixunix_2escm",(void*)f_7649},
{"f_7642:posixunix_2escm",(void*)f_7642},
{"f_7423:posixunix_2escm",(void*)f_7423},
{"f_5256:posixunix_2escm",(void*)f_5256},
{"f_5252:posixunix_2escm",(void*)f_5252},
{"f_5619:posixunix_2escm",(void*)f_5619},
{"f_5615:posixunix_2escm",(void*)f_5615},
{"f_7139:posixunix_2escm",(void*)f_7139},
{"f_7132:posixunix_2escm",(void*)f_7132},
{"f_7602:posixunix_2escm",(void*)f_7602},
{"f_6511:posixunix_2escm",(void*)f_6511},
{"f_7160:posixunix_2escm",(void*)f_7160},
{"f_7156:posixunix_2escm",(void*)f_7156},
{"f_8768:posixunix_2escm",(void*)f_8768},
{"f_7181:posixunix_2escm",(void*)f_7181},
{"f_5299:posixunix_2escm",(void*)f_5299},
{"f_7173:posixunix_2escm",(void*)f_7173},
{"f_4602:posixunix_2escm",(void*)f_4602},
{"f_2774:posixunix_2escm",(void*)f_2774},
{"f_2776:posixunix_2escm",(void*)f_2776},
{"f_2770:posixunix_2escm",(void*)f_2770},
{"f_6586:posixunix_2escm",(void*)f_6586},
{"f_5238:posixunix_2escm",(void*)f_5238},
{"f_5232:posixunix_2escm",(void*)f_5232},
{"f_7668:posixunix_2escm",(void*)f_7668},
{"f_5247:posixunix_2escm",(void*)f_5247},
{"f_5242:posixunix_2escm",(void*)f_5242},
{"f_3892:posixunix_2escm",(void*)f_3892},
{"f_6596:posixunix_2escm",(void*)f_6596},
{"f_8745:posixunix_2escm",(void*)f_8745},
{"f_4647:posixunix_2escm",(void*)f_4647},
{"f_4645:posixunix_2escm",(void*)f_4645},
{"f_2737:posixunix_2escm",(void*)f_2737},
{"f_3876:posixunix_2escm",(void*)f_3876},
{"f_2730:posixunix_2escm",(void*)f_2730},
{"f_3590:posixunix_2escm",(void*)f_3590},
{"f_3647:posixunix_2escm",(void*)f_3647},
{"f_2764:posixunix_2escm",(void*)f_2764},
{"f_3646:posixunix_2escm",(void*)f_3646},
{"f_2762:posixunix_2escm",(void*)f_2762},
{"f_2768:posixunix_2escm",(void*)f_2768},
{"f_3883:posixunix_2escm",(void*)f_3883},
{"f_3562:posixunix_2escm",(void*)f_3562},
{"f_7104:posixunix_2escm",(void*)f_7104},
{"f_2752:posixunix_2escm",(void*)f_2752},
{"f_2758:posixunix_2escm",(void*)f_2758},
{"f_2756:posixunix_2escm",(void*)f_2756},
{"f_2750:posixunix_2escm",(void*)f_2750},
{"f_3629:posixunix_2escm",(void*)f_3629},
{"f_2782:posixunix_2escm",(void*)f_2782},
{"f_3622:posixunix_2escm",(void*)f_3622},
{"f_2780:posixunix_2escm",(void*)f_2780},
{"f_3584:posixunix_2escm",(void*)f_3584},
{"f_4689:posixunix_2escm",(void*)f_4689},
{"f_3636:posixunix_2escm",(void*)f_3636},
{"f_3839:posixunix_2escm",(void*)f_3839},
{"f_3835:posixunix_2escm",(void*)f_3835},
{"f_3831:posixunix_2escm",(void*)f_3831},
{"f_3557:posixunix_2escm",(void*)f_3557},
{"f_8733:posixunix_2escm",(void*)f_8733},
{"f_8735:posixunix_2escm",(void*)f_8735},
{"f_3555:posixunix_2escm",(void*)f_3555},
{"f_3603:posixunix_2escm",(void*)f_3603},
{"f_3600:posixunix_2escm",(void*)f_3600},
{"f_3609:posixunix_2escm",(void*)f_3609},
{"f_3845:posixunix_2escm",(void*)f_3845},
{"f_8723:posixunix_2escm",(void*)f_8723},
{"f_6537:posixunix_2escm",(void*)f_6537},
{"f_8729:posixunix_2escm",(void*)f_8729},
{"f_3577:posixunix_2escm",(void*)f_3577},
{"f_8755:posixunix_2escm",(void*)f_8755},
{"f_3570:posixunix_2escm",(void*)f_3570},
{"f_3574:posixunix_2escm",(void*)f_3574},
{"f_7271:posixunix_2escm",(void*)f_7271},
{"f_7265:posixunix_2escm",(void*)f_7265},
{"f_7262:posixunix_2escm",(void*)f_7262},
{"f_5204:posixunix_2escm",(void*)f_5204},
{"f_5208:posixunix_2escm",(void*)f_5208},
{"f_7284:posixunix_2escm",(void*)f_7284},
{"f_4898:posixunix_2escm",(void*)f_4898},
{"f_4891:posixunix_2escm",(void*)f_4891},
{"f_4197:posixunix_2escm",(void*)f_4197},
{"f_8602:posixunix_2escm",(void*)f_8602},
{"f_7259:posixunix_2escm",(void*)f_7259},
{"f_7255:posixunix_2escm",(void*)f_7255},
{"f_4961:posixunix_2escm",(void*)f_4961},
{"f_4964:posixunix_2escm",(void*)f_4964},
{"f_4634:posixunix_2escm",(void*)f_4634},
{"f_6445:posixunix_2escm",(void*)f_6445},
{"f_5704:posixunix_2escm",(void*)f_5704},
{"f_4133:posixunix_2escm",(void*)f_4133},
{"f_4975:posixunix_2escm",(void*)f_4975},
{"f_4977:posixunix_2escm",(void*)f_4977},
{"f_4140:posixunix_2escm",(void*)f_4140},
{"f_4984:posixunix_2escm",(void*)f_4984},
{"f_6463:posixunix_2escm",(void*)f_6463},
{"f_5818:posixunix_2escm",(void*)f_5818},
{"f_6467:posixunix_2escm",(void*)f_6467},
{"f_8648:posixunix_2escm",(void*)f_8648},
{"f_7215:posixunix_2escm",(void*)f_7215},
{"f_5213:posixunix_2escm",(void*)f_5213},
{"f_5218:posixunix_2escm",(void*)f_5218},
{"f_5839:posixunix_2escm",(void*)f_5839},
{"f_6481:posixunix_2escm",(void*)f_6481},
{"f_3180:posixunix_2escm",(void*)f_3180},
{"f_3186:posixunix_2escm",(void*)f_3186},
{"f_5222:posixunix_2escm",(void*)f_5222},
{"f_5227:posixunix_2escm",(void*)f_5227},
{"f_4936:posixunix_2escm",(void*)f_4936},
{"f_8624:posixunix_2escm",(void*)f_8624},
{"f_6476:posixunix_2escm",(void*)f_6476},
{"f_5843:posixunix_2escm",(void*)f_5843},
{"f_5845:posixunix_2escm",(void*)f_5845},
{"f_2668:posixunix_2escm",(void*)f_2668},
{"f_3191:posixunix_2escm",(void*)f_3191},
{"f_2725:posixunix_2escm",(void*)f_2725},
{"f_8612:posixunix_2escm",(void*)f_8612},
{"f_2721:posixunix_2escm",(void*)f_2721},
{"f_8618:posixunix_2escm",(void*)f_8618},
{"f_2690:posixunix_2escm",(void*)f_2690},
{"f_4954:posixunix_2escm",(void*)f_4954},
{"f_6491:posixunix_2escm",(void*)f_6491},
{"f_2714:posixunix_2escm",(void*)f_2714},
{"f_5869:posixunix_2escm",(void*)f_5869},
{"f_8689:posixunix_2escm",(void*)f_8689},
{"f_3141:posixunix_2escm",(void*)f_3141},
{"f_5873:posixunix_2escm",(void*)f_5873},
{"f_5875:posixunix_2escm",(void*)f_5875},
{"f_2672:posixunix_2escm",(void*)f_2672},
{"f_2679:posixunix_2escm",(void*)f_2679},
{"f_3702:posixunix_2escm",(void*)f_3702},
{"f_3705:posixunix_2escm",(void*)f_3705},
{"f_3707:posixunix_2escm",(void*)f_3707},
{"f_3715:posixunix_2escm",(void*)f_3715},
{"f_3713:posixunix_2escm",(void*)f_3713},
{"f_3157:posixunix_2escm",(void*)f_3157},
{"f_5885:posixunix_2escm",(void*)f_5885},
{"f_8664:posixunix_2escm",(void*)f_8664},
{"f_5899:posixunix_2escm",(void*)f_5899},
{"f_5897:posixunix_2escm",(void*)f_5897},
{"f_5893:posixunix_2escm",(void*)f_5893},
{"f_4907:posixunix_2escm",(void*)f_4907},
{"f_3722:posixunix_2escm",(void*)f_3722},
{"f_3164:posixunix_2escm",(void*)f_3164},
{"f_3163:posixunix_2escm",(void*)f_3163},
{"f_3720:posixunix_2escm",(void*)f_3720},
{"f_4905:posixunix_2escm",(void*)f_4905},
{"f_2653:posixunix_2escm",(void*)f_2653},
{"f_8652:posixunix_2escm",(void*)f_8652},
{"f_8655:posixunix_2escm",(void*)f_8655},
{"f_2656:posixunix_2escm",(void*)f_2656},
{"f_2650:posixunix_2escm",(void*)f_2650},
{"f_4913:posixunix_2escm",(void*)f_4913},
{"f_3174:posixunix_2escm",(void*)f_3174},
{"f_2683:posixunix_2escm",(void*)f_2683},
{"f_2686:posixunix_2escm",(void*)f_2686},
{"f_3745:posixunix_2escm",(void*)f_3745},
{"f_3741:posixunix_2escm",(void*)f_3741},
{"f_3110:posixunix_2escm",(void*)f_3110},
{"f_3113:posixunix_2escm",(void*)f_3113},
{"f_3949:posixunix_2escm",(void*)f_3949},
{"f_3955:posixunix_2escm",(void*)f_3955},
{"f_3953:posixunix_2escm",(void*)f_3953},
{"f_3137:posixunix_2escm",(void*)f_3137},
{"f_3131:posixunix_2escm",(void*)f_3131},
{"f_3963:posixunix_2escm",(void*)f_3963},
{"f_6790:posixunix_2escm",(void*)f_6790},
{"f_3975:posixunix_2escm",(void*)f_3975},
{"f_5569:posixunix_2escm",(void*)f_5569},
{"f_5565:posixunix_2escm",(void*)f_5565},
{"f_5563:posixunix_2escm",(void*)f_5563},
{"f_6798:posixunix_2escm",(void*)f_6798},
{"f_8536:posixunix_2escm",(void*)f_8536},
{"f_5579:posixunix_2escm",(void*)f_5579},
{"f_4484:posixunix_2escm",(void*)f_4484},
{"f_8520:posixunix_2escm",(void*)f_8520},
{"f_8288:posixunix_2escm",(void*)f_8288},
{"f_8284:posixunix_2escm",(void*)f_8284},
{"f_8280:posixunix_2escm",(void*)f_8280},
{"f_6751:posixunix_2escm",(void*)f_6751},
{"f_6756:posixunix_2escm",(void*)f_6756},
{"f_3336:posixunix_2escm",(void*)f_3336},
{"f_3938:posixunix_2escm",(void*)f_3938},
{"f_3930:posixunix_2escm",(void*)f_3930},
{"f_8545:posixunix_2escm",(void*)f_8545},
{"f_8542:posixunix_2escm",(void*)f_8542},
{"f_8261:posixunix_2escm",(void*)f_8261},
{"f_6741:posixunix_2escm",(void*)f_6741},
{"f_8292:posixunix_2escm",(void*)f_8292},
{"f_5508:posixunix_2escm",(void*)f_5508},
{"f_5504:posixunix_2escm",(void*)f_5504},
{"f_5518:posixunix_2escm",(void*)f_5518},
{"f_5510:posixunix_2escm",(void*)f_5510},
{"f_6710:posixunix_2escm",(void*)f_6710},
{"f_8509:posixunix_2escm",(void*)f_8509},
{"f_8502:posixunix_2escm",(void*)f_8502},
{"f_4402:posixunix_2escm",(void*)f_4402},
{"f_5542:posixunix_2escm",(void*)f_5542},
{"f_7994:posixunix_2escm",(void*)f_7994},
{"f_7990:posixunix_2escm",(void*)f_7990},
{"f_6762:posixunix_2escm",(void*)f_6762},
{"f_6760:posixunix_2escm",(void*)f_6760},
{"f_5770:posixunix_2escm",(void*)f_5770},
{"f_6778:posixunix_2escm",(void*)f_6778},
{"f_5777:posixunix_2escm",(void*)f_5777},
{"f_4410:posixunix_2escm",(void*)f_4410},
{"f_5555:posixunix_2escm",(void*)f_5555},
{"f_5559:posixunix_2escm",(void*)f_5559},
{"f_8555:posixunix_2escm",(void*)f_8555},
{"f_6768:posixunix_2escm",(void*)f_6768},
{"f_5742:posixunix_2escm",(void*)f_5742},
{"f_2801:posixunix_2escm",(void*)f_2801},
{"f_5522:posixunix_2escm",(void*)f_5522},
{"f_5754:posixunix_2escm",(void*)f_5754},
{"f_5535:posixunix_2escm",(void*)f_5535},
{"f_8574:posixunix_2escm",(void*)f_8574},
{"f_8561:posixunix_2escm",(void*)f_8561},
{"f_8564:posixunix_2escm",(void*)f_8564},
{"f_2647:posixunix_2escm",(void*)f_2647},
{"f_2644:posixunix_2escm",(void*)f_2644},
{"f_8515:posixunix_2escm",(void*)f_8515},
{"f_5593:posixunix_2escm",(void*)f_5593},
{"f_7983:posixunix_2escm",(void*)f_7983},
{"f_7980:posixunix_2escm",(void*)f_7980},
{"f_8583:posixunix_2escm",(void*)f_8583},
{"f_8580:posixunix_2escm",(void*)f_8580},
{"f_4474:posixunix_2escm",(void*)f_4474},
{"f_4477:posixunix_2escm",(void*)f_4477},
{"f_7958:posixunix_2escm",(void*)f_7958},
{"f_2909:posixunix_2escm",(void*)f_2909},
{"f_2907:posixunix_2escm",(void*)f_2907},
{"f_7049:posixunix_2escm",(void*)f_7049},
{"f_7045:posixunix_2escm",(void*)f_7045},
{"f_5145:posixunix_2escm",(void*)f_5145},
{"f_5140:posixunix_2escm",(void*)f_5140},
{"f_6684:posixunix_2escm",(void*)f_6684},
{"f_6685:posixunix_2escm",(void*)f_6685},
{"f_7065:posixunix_2escm",(void*)f_7065},
{"f_7061:posixunix_2escm",(void*)f_7061},
{"f_3064:posixunix_2escm",(void*)f_3064},
{"f_8203:posixunix_2escm",(void*)f_8203},
{"f_8205:posixunix_2escm",(void*)f_8205},
{"f_8209:posixunix_2escm",(void*)f_8209},
{"f_3038:posixunix_2escm",(void*)f_3038},
{"f_8231:posixunix_2escm",(void*)f_8231},
{"f_8238:posixunix_2escm",(void*)f_8238},
{"f_7942:posixunix_2escm",(void*)f_7942},
{"f_5184:posixunix_2escm",(void*)f_5184},
{"f_5188:posixunix_2escm",(void*)f_5188},
{"f_3047:posixunix_2escm",(void*)f_3047},
{"f_7077:posixunix_2escm",(void*)f_7077},
{"f_5155:posixunix_2escm",(void*)f_5155},
{"f_5151:posixunix_2escm",(void*)f_5151},
{"f_8215:posixunix_2escm",(void*)f_8215},
{"f_8212:posixunix_2escm",(void*)f_8212},
{"f_8424:posixunix_2escm",(void*)f_8424},
{"f_2887:posixunix_2escm",(void*)f_2887},
{"f_2889:posixunix_2escm",(void*)f_2889},
{"f_5164:posixunix_2escm",(void*)f_5164},
{"f_4776:posixunix_2escm",(void*)f_4776},
{"f_5160:posixunix_2escm",(void*)f_5160},
{"f_8249:posixunix_2escm",(void*)f_8249},
{"f_8242:posixunix_2escm",(void*)f_8242},
{"f_5169:posixunix_2escm",(void*)f_5169},
{"f_2877:posixunix_2escm",(void*)f_2877},
{"f_6662:posixunix_2escm",(void*)f_6662},
{"f_2879:posixunix_2escm",(void*)f_2879},
{"f_5136:posixunix_2escm",(void*)f_5136},
{"f_8276:posixunix_2escm",(void*)f_8276},
{"f_2919:posixunix_2escm",(void*)f_2919},
{"f_8272:posixunix_2escm",(void*)f_8272},
{"f_2917:posixunix_2escm",(void*)f_2917},
{"f_2869:posixunix_2escm",(void*)f_2869},
{"f_6691:posixunix_2escm",(void*)f_6691},
{"f_4795:posixunix_2escm",(void*)f_4795},
{"f_8227:posixunix_2escm",(void*)f_8227},
{"f_8471:posixunix_2escm",(void*)f_8471},
{"f_8479:posixunix_2escm",(void*)f_8479},
{"f_7081:posixunix_2escm",(void*)f_7081},
{"f_8255:posixunix_2escm",(void*)f_8255},
{"f_3545:posixunix_2escm",(void*)f_3545},
{"f_3511:posixunix_2escm",(void*)f_3511},
{"f_4780:posixunix_2escm",(void*)f_4780},
{"f_4789:posixunix_2escm",(void*)f_4789},
{"f_6167:posixunix_2escm",(void*)f_6167},
{"f_2899:posixunix_2escm",(void*)f_2899},
{"f_2897:posixunix_2escm",(void*)f_2897},
{"f_3536:posixunix_2escm",(void*)f_3536},
{"f_3533:posixunix_2escm",(void*)f_3533},
{"f_8192:posixunix_2escm",(void*)f_8192},
{"f_7027:posixunix_2escm",(void*)f_7027},
{"f_8189:posixunix_2escm",(void*)f_8189},
{"f_8186:posixunix_2escm",(void*)f_8186},
{"f_8182:posixunix_2escm",(void*)f_8182},
{"f_6139:posixunix_2escm",(void*)f_6139},
{"f_6137:posixunix_2escm",(void*)f_6137},
{"toplevel:posixunix_2escm",(void*)C_posix_toplevel},
{"f_6923:posixunix_2escm",(void*)f_6923},
{"f_5113:posixunix_2escm",(void*)f_5113},
{"f_6193:posixunix_2escm",(void*)f_6193},
{"f_8153:posixunix_2escm",(void*)f_8153},
{"f_8152:posixunix_2escm",(void*)f_8152},
{"f_5121:posixunix_2escm",(void*)f_5121},
{"f_5128:posixunix_2escm",(void*)f_5128},
{"f_8141:posixunix_2escm",(void*)f_8141},
{"f_6178:posixunix_2escm",(void*)f_6178},
{"f_6984:posixunix_2escm",(void*)f_6984},
{"f_6978:posixunix_2escm",(void*)f_6978},
{"f_6173:posixunix_2escm",(void*)f_6173},
{"f_6174:posixunix_2escm",(void*)f_6174},
{"f_4247:posixunix_2escm",(void*)f_4247},
{"f_8168:posixunix_2escm",(void*)f_8168},
{"f_8164:posixunix_2escm",(void*)f_8164},
{"f_4250:posixunix_2escm",(void*)f_4250},
{"f_6962:posixunix_2escm",(void*)f_6962},
{"f_4266:posixunix_2escm",(void*)f_4266},
{"f_4260:posixunix_2escm",(void*)f_4260},
{"f_6951:posixunix_2escm",(void*)f_6951},
{"f_8101:posixunix_2escm",(void*)f_8101},
{"f_8107:posixunix_2escm",(void*)f_8107},
{"f_8136:posixunix_2escm",(void*)f_8136},
{"f_8130:posixunix_2escm",(void*)f_8130},
{"f_8086:posixunix_2escm",(void*)f_8086},
{"f_8084:posixunix_2escm",(void*)f_8084},
{"f_8080:posixunix_2escm",(void*)f_8080},
{"f_4282:posixunix_2escm",(void*)f_4282},
{"f_8121:posixunix_2escm",(void*)f_8121},
{"f_4298:posixunix_2escm",(void*)f_4298},
{"f_4295:posixunix_2escm",(void*)f_4295},
{"f_4292:posixunix_2escm",(void*)f_4292},
{"f_5193:posixunix_2escm",(void*)f_5193},
{"f_5198:posixunix_2escm",(void*)f_5198},
{"f_6117:posixunix_2escm",(void*)f_6117},
{"f_8307:posixunix_2escm",(void*)f_8307},
{"f_8305:posixunix_2escm",(void*)f_8305},
{"f_7543:posixunix_2escm",(void*)f_7543},
{"f_6102:posixunix_2escm",(void*)f_6102},
{"f_3985:posixunix_2escm",(void*)f_3985},
{"f_3981:posixunix_2escm",(void*)f_3981},
{"f_4234:posixunix_2escm",(void*)f_4234},
{"f_4230:posixunix_2escm",(void*)f_4230},
{"f_5175:posixunix_2escm",(void*)f_5175},
{"f_5179:posixunix_2escm",(void*)f_5179},
{"f_7531:posixunix_2escm",(void*)f_7531},
{"f_8321:posixunix_2escm",(void*)f_8321},
{"f_3993:posixunix_2escm",(void*)f_3993},
{"f_5106:posixunix_2escm",(void*)f_5106},
{"f_8312:posixunix_2escm",(void*)f_8312},
{"f_3483:posixunix_2escm",(void*)f_3483},
{"f_3480:posixunix_2escm",(void*)f_3480},
{"f_8348:posixunix_2escm",(void*)f_8348},
{"f_6947:posixunix_2escm",(void*)f_6947},
{"f_3492:posixunix_2escm",(void*)f_3492},
{"f_3490:posixunix_2escm",(void*)f_3490},
{"f_7578:posixunix_2escm",(void*)f_7578},
{"f_7574:posixunix_2escm",(void*)f_7574},
{"f_6940:posixunix_2escm",(void*)f_6940},
{"f_6933:posixunix_2escm",(void*)f_6933},
{"f_8599:posixunix_2escm",(void*)f_8599},
{"f_8593:posixunix_2escm",(void*)f_8593},
{"f_8351:posixunix_2escm",(void*)f_8351},
{"f_8356:posixunix_2escm",(void*)f_8356},
{"f_7598:posixunix_2escm",(void*)f_7598},
{"f_8394:posixunix_2escm",(void*)f_8394},
{"f_2950:posixunix_2escm",(void*)f_2950},
{"f_3447:posixunix_2escm",(void*)f_3447},
{"f_2942:posixunix_2escm",(void*)f_2942},
{"f_8370:posixunix_2escm",(void*)f_8370},
{"f_8374:posixunix_2escm",(void*)f_8374},
{"f_8376:posixunix_2escm",(void*)f_8376},
{"f_6043:posixunix_2escm",(void*)f_6043},
{"f_3902:posixunix_2escm",(void*)f_3902},
{"f_3909:posixunix_2escm",(void*)f_3909},
{"f_3906:posixunix_2escm",(void*)f_3906},
{"f_2979:posixunix_2escm",(void*)f_2979},
{"f_6037:posixunix_2escm",(void*)f_6037},
{"f_6064:posixunix_2escm",(void*)f_6064},
{"f_3439:posixunix_2escm",(void*)f_3439},
{"f_3435:posixunix_2escm",(void*)f_3435},
{"f_6052:posixunix_2escm",(void*)f_6052},
{"f_3406:posixunix_2escm",(void*)f_3406},
{"f_3404:posixunix_2escm",(void*)f_3404},
{"f_7782:posixunix_2escm",(void*)f_7782},
{"f_6058:posixunix_2escm",(void*)f_6058},
{"f_6055:posixunix_2escm",(void*)f_6055},
{"f_8698:posixunix_2escm",(void*)f_8698},
{"f_7736:posixunix_2escm",(void*)f_7736},
{"f_2937:posixunix_2escm",(void*)f_2937},
{"f_7525:posixunix_2escm",(void*)f_7525},
{"f_3467:posixunix_2escm",(void*)f_3467},
{"f_2927:posixunix_2escm",(void*)f_2927},
{"f_2929:posixunix_2escm",(void*)f_2929},
{"f_7759:posixunix_2escm",(void*)f_7759},
{"f_5348:posixunix_2escm",(void*)f_5348},
{"f_5462:posixunix_2escm",(void*)f_5462},
{"f_7745:posixunix_2escm",(void*)f_7745},
{"f_5466:posixunix_2escm",(void*)f_5466},
{"f_5356:posixunix_2escm",(void*)f_5356},
{"f_5350:posixunix_2escm",(void*)f_5350},
{"f_6098:posixunix_2escm",(void*)f_6098},
{"f_6813:posixunix_2escm",(void*)f_6813},
{"f_6812:posixunix_2escm",(void*)f_6812},
{"f_5470:posixunix_2escm",(void*)f_5470},
{"f_5478:posixunix_2escm",(void*)f_5478},
{"f_5474:posixunix_2escm",(void*)f_5474},
{"f_5488:posixunix_2escm",(void*)f_5488},
{"f_3427:posixunix_2escm",(void*)f_3427},
{"f_3423:posixunix_2escm",(void*)f_3423},
{"f_8034:posixunix_2escm",(void*)f_8034},
{"f_8030:posixunix_2escm",(void*)f_8030},
{"f_5415:posixunix_2escm",(void*)f_5415},
{"f_8037:posixunix_2escm",(void*)f_8037},
{"f_5411:posixunix_2escm",(void*)f_5411},
{"f_2994:posixunix_2escm",(void*)f_2994},
{"f_2992:posixunix_2escm",(void*)f_2992},
{"f_8024:posixunix_2escm",(void*)f_8024},
{"f_8015:posixunix_2escm",(void*)f_8015},
{"f_4543:posixunix_2escm",(void*)f_4543},
{"f_8019:posixunix_2escm",(void*)f_8019},
{"f_6003:posixunix_2escm",(void*)f_6003},
{"f_6027:posixunix_2escm",(void*)f_6027},
{"f_6025:posixunix_2escm",(void*)f_6025},
{"f_8060:posixunix_2escm",(void*)f_8060},
{"f_6011:posixunix_2escm",(void*)f_6011},
{"f_6017:posixunix_2escm",(void*)f_6017},
{"f_8056:posixunix_2escm",(void*)f_8056},
{"f_7899:posixunix_2escm",(void*)f_7899},
{"f_3655:posixunix_2escm",(void*)f_3655},
{"f_6840:posixunix_2escm",(void*)f_6840},
{"f_7768:posixunix_2escm",(void*)f_7768},
{"f_4514:posixunix_2escm",(void*)f_4514},
{"f_6830:posixunix_2escm",(void*)f_6830},
{"f_5496:posixunix_2escm",(void*)f_5496},
{"f_5421:posixunix_2escm",(void*)f_5421},
{"f_5428:posixunix_2escm",(void*)f_5428},
{"f_3688:posixunix_2escm",(void*)f_3688},
{"f_3685:posixunix_2escm",(void*)f_3685},
{"f_3682:posixunix_2escm",(void*)f_3682},
{"f_5432:posixunix_2escm",(void*)f_5432},
{"f_5436:posixunix_2escm",(void*)f_5436},
{"f_3616:posixunix_2escm",(void*)f_3616},
{"f_5440:posixunix_2escm",(void*)f_5440},
{"f_5442:posixunix_2escm",(void*)f_5442},
{"f_5449:posixunix_2escm",(void*)f_5449},
{"f_3669:posixunix_2escm",(void*)f_3669},
{"f_7822:posixunix_2escm",(void*)f_7822},
{"f_3663:posixunix_2escm",(void*)f_3663},
{"f_3366:posixunix_2escm",(void*)f_3366},
{"f_7877:posixunix_2escm",(void*)f_7877},
{"f_3679:posixunix_2escm",(void*)f_3679},
{"f_3676:posixunix_2escm",(void*)f_3676},
{"f_7812:posixunix_2escm",(void*)f_7812},
{"f_3673:posixunix_2escm",(void*)f_3673},
{"f_6397:posixunix_2escm",(void*)f_6397},
{"f_4573:posixunix_2escm",(void*)f_4573},
{"f_3372:posixunix_2escm",(void*)f_3372},
{"f_7828:posixunix_2escm",(void*)f_7828},
{"f_7825:posixunix_2escm",(void*)f_7825},
{"f_6372:posixunix_2escm",(void*)f_6372},
{"f_6387:posixunix_2escm",(void*)f_6387},
{"f_3302:posixunix_2escm",(void*)f_3302},
{"f_6360:posixunix_2escm",(void*)f_6360},
{"f_6376:posixunix_2escm",(void*)f_6376},
{"f_3393:posixunix_2escm",(void*)f_3393},
{"f_3397:posixunix_2escm",(void*)f_3397},
{"f_6350:posixunix_2escm",(void*)f_6350},
{"f_4088:posixunix_2escm",(void*)f_4088},
{"f_7850:posixunix_2escm",(void*)f_7850},
{"f_4056:posixunix_2escm",(void*)f_4056},
{"f_4058:posixunix_2escm",(void*)f_4058},
{"f_7357:posixunix_2escm",(void*)f_7357},
{"f_7858:posixunix_2escm",(void*)f_7858},
{"f_5905:posixunix_2escm",(void*)f_5905},
{"f_3693:posixunix_2escm",(void*)f_3693},
{"f_3696:posixunix_2escm",(void*)f_3696},
{"f_3699:posixunix_2escm",(void*)f_3699},
{"f_6338:posixunix_2escm",(void*)f_6338},
{"f_7389:posixunix_2escm",(void*)f_7389},
{"f_7804:posixunix_2escm",(void*)f_7804},
{"f_7807:posixunix_2escm",(void*)f_7807},
{"f_4041:posixunix_2escm",(void*)f_4041},
{"f_7372:posixunix_2escm",(void*)f_7372},
{"f_6307:posixunix_2escm",(void*)f_6307},
{"f_4853:posixunix_2escm",(void*)f_4853},
{"f_4064:posixunix_2escm",(void*)f_4064},
{"f_3387:posixunix_2escm",(void*)f_3387},
{"f_5323:posixunix_2escm",(void*)f_5323},
{"f_5047:posixunix_2escm",(void*)f_5047},
{"f_5040:posixunix_2escm",(void*)f_5040},
{"f_5407:posixunix_2escm",(void*)f_5407},
{"f_5403:posixunix_2escm",(void*)f_5403},
{"f_7348:posixunix_2escm",(void*)f_7348},
{"f_4872:posixunix_2escm",(void*)f_4872},
{"f_4875:posixunix_2escm",(void*)f_4875},
{"f_5911:posixunix_2escm",(void*)f_5911},
{"f_5917:posixunix_2escm",(void*)f_5917},
{"f_5057:posixunix_2escm",(void*)f_5057},
{"f_5388:posixunix_2escm",(void*)f_5388},
{"f_4844:posixunix_2escm",(void*)f_4844},
{"f_5921:posixunix_2escm",(void*)f_5921},
{"f_4847:posixunix_2escm",(void*)f_4847},
{"f_5927:posixunix_2escm",(void*)f_5927},
{"f_5066:posixunix_2escm",(void*)f_5066},
{"f_5392:posixunix_2escm",(void*)f_5392},
{"f_5399:posixunix_2escm",(void*)f_5399},
{"f_3766:posixunix_2escm",(void*)f_3766},
{"f_3762:posixunix_2escm",(void*)f_3762},
{"f_4023:posixunix_2escm",(void*)f_4023},
{"f_4863:posixunix_2escm",(void*)f_4863},
{"f_4865:posixunix_2escm",(void*)f_4865},
{"f_3280:posixunix_2escm",(void*)f_3280},
{"f_5087:posixunix_2escm",(void*)f_5087},
{"f_5080:posixunix_2escm",(void*)f_5080},
{"f_5372:posixunix_2escm",(void*)f_5372},
{"f_4834:posixunix_2escm",(void*)f_4834},
{"f_4832:posixunix_2escm",(void*)f_4832},
{"f_6395:posixunix_2escm",(void*)f_6395},
{"f_5957:posixunix_2escm",(void*)f_5957},
{"f_3292:posixunix_2escm",(void*)f_3292},
{"f_3793:posixunix_2escm",(void*)f_3793},
{"f_4801:posixunix_2escm",(void*)f_4801},
{"f_3797:posixunix_2escm",(void*)f_3797},
{"f_5961:posixunix_2escm",(void*)f_5961},
{"f_5965:posixunix_2escm",(void*)f_5965},
{"f_5969:posixunix_2escm",(void*)f_5969},
{"f_4094:posixunix_2escm",(void*)f_4094},
{"f_3266:posixunix_2escm",(void*)f_3266},
{"f_7322:posixunix_2escm",(void*)f_7322},
{"f_5934:posixunix_2escm",(void*)f_5934},
{"f_5936:posixunix_2escm",(void*)f_5936},
{"f_7393:posixunix_2escm",(void*)f_7393},
{"f_3245:posixunix_2escm",(void*)f_3245},
{"f_3248:posixunix_2escm",(void*)f_3248},
{"f_3242:posixunix_2escm",(void*)f_3242},
{"f_5993:posixunix_2escm",(void*)f_5993},
{"f_3252:posixunix_2escm",(void*)f_3252},
{"f_6239:posixunix_2escm",(void*)f_6239},
{"f_6236:posixunix_2escm",(void*)f_6236},
{"f_3803:posixunix_2escm",(void*)f_3803},
{"f_3227:posixunix_2escm",(void*)f_3227},
{"f_3223:posixunix_2escm",(void*)f_3223},
{"f_6269:posixunix_2escm",(void*)f_6269},
{"f_5973:posixunix_2escm",(void*)f_5973},
{"f_5974:posixunix_2escm",(void*)f_5974},
{"f_5979:posixunix_2escm",(void*)f_5979},
{"f_4339:posixunix_2escm",(void*)f_4339},
{"f_4333:posixunix_2escm",(void*)f_4333},
{"f_4330:posixunix_2escm",(void*)f_4330},
{"f_3022:posixunix_2escm",(void*)f_3022},
{"f_3201:posixunix_2escm",(void*)f_3201},
{"f_3020:posixunix_2escm",(void*)f_3020},
{"f_8496:posixunix_2escm",(void*)f_8496},
{"f_6311:posixunix_2escm",(void*)f_6311},
{"f_6313:posixunix_2escm",(void*)f_6313},
{"f_6317:posixunix_2escm",(void*)f_6317},
{"f_5011:posixunix_2escm",(void*)f_5011},
{"f_6272:posixunix_2escm",(void*)f_6272},
{"f_6278:posixunix_2escm",(void*)f_6278},
{"f_4011:posixunix_2escm",(void*)f_4011},
{"f_5024:posixunix_2escm",(void*)f_5024},
{"f_5026:posixunix_2escm",(void*)f_5026},
{"f_4019:posixunix_2escm",(void*)f_4019},
{"f_3008:posixunix_2escm",(void*)f_3008},
{"f_3006:posixunix_2escm",(void*)f_3006},
{"f_4367:posixunix_2escm",(void*)f_4367},
{"f_4360:posixunix_2escm",(void*)f_4360},
{"f_7315:posixunix_2escm",(void*)f_7315},
{"f_4373:posixunix_2escm",(void*)f_4373},
{"f_4380:posixunix_2escm",(void*)f_4380},
{"f_5688:posixunix_2escm",(void*)f_5688},
{"f_5683:posixunix_2escm",(void*)f_5683},
{"f_4399:posixunix_2escm",(void*)f_4399},
{"f_4396:posixunix_2escm",(void*)f_4396},
{"f_4392:posixunix_2escm",(void*)f_4392},
{"f_3097:posixunix_2escm",(void*)f_3097},
{"f_7417:posixunix_2escm",(void*)f_7417},
{"f_7413:posixunix_2escm",(void*)f_7413},
{"f_6203:posixunix_2escm",(void*)f_6203},
{"f_7409:posixunix_2escm",(void*)f_7409},
{"f_7401:posixunix_2escm",(void*)f_7401},
{"f_3070:posixunix_2escm",(void*)f_3070},
{"f_5097:posixunix_2escm",(void*)f_5097},
{"f_3077:posixunix_2escm",(void*)f_3077},
{"f_3080:posixunix_2escm",(void*)f_3080},
{"f_7428:posixunix_2escm",(void*)f_7428},
{"f_7441:posixunix_2escm",(void*)f_7441},
{"f_6211:posixunix_2escm",(void*)f_6211},
{"f_6217:posixunix_2escm",(void*)f_6217},
{"f_7455:posixunix_2escm",(void*)f_7455},
{"f_7472:posixunix_2escm",(void*)f_7472},
{"f_5630:posixunix_2escm",(void*)f_5630},
{"f_7462:posixunix_2escm",(void*)f_7462},
{"f_5655:posixunix_2escm",(void*)f_5655},
{"f_4323:posixunix_2escm",(void*)f_4323},
{"f_7469:posixunix_2escm",(void*)f_7469},
{"f_7466:posixunix_2escm",(void*)f_7466},
{"f_7481:posixunix_2escm",(void*)f_7481},
{"f_5622:posixunix_2escm",(void*)f_5622},
{"f_5625:posixunix_2escm",(void*)f_5625},
{"f_5679:posixunix_2escm",(void*)f_5679},
{"f_5674:posixunix_2escm",(void*)f_5674},
{"f_5645:posixunix_2escm",(void*)f_5645},
{"f_7696:posixunix_2escm",(void*)f_7696},
{"f_7686:posixunix_2escm",(void*)f_7686},
{"f_7682:posixunix_2escm",(void*)f_7682},
{NULL,NULL}};
#endif

static C_PTABLE_ENTRY *create_ptable(void){
#ifdef C_ENABLE_PTABLES
return ptable;
#else
return NULL;
#endif
}

/*
S|applied compiler syntax:
S|  for-each		3
o|eliminated procedure checks: 275 
o|specializations:
o|  1 (zero? fixnum)
o|  2 (##sys#check-list (or pair list) *)
o|  1 (##sys#check-output-port * * *)
o|  1 (##sys#check-input-port * * *)
o|  1 (negative? fixnum)
o|  2 (##sys#length list)
o|  11 (cdr pair)
o|  1 (string-ref string fixnum)
o|  1 (string-length string)
o|  4 (make-string fixnum)
o|  3 (##sys#check-open-port * *)
o|  11 (eqv? * (not float))
o|  14 (car pair)
o|dropping redundant toplevel assignment: process 
o|dropping redundant toplevel assignment: process* 
o|safe globals: (file-stat ##sys#stat ##sys#posix-error posix-error) 
o|Removed `not' forms: 9 
o|contracted procedure: "(posix-common.scm:179) strerror64" 
o|inlining procedure: k2691 
o|inlining procedure: k2691 
o|inlining procedure: k2706 
o|inlining procedure: k2706 
o|inlining procedure: k2796 
o|inlining procedure: k2808 
o|inlining procedure: k2808 
o|inlining procedure: k2820 
o|inlining procedure: k2820 
o|inlining procedure: k2832 
o|inlining procedure: k2832 
o|inlining procedure: k2796 
o|inlining procedure: k2948 
o|contracted procedure: k2964 
o|inlining procedure: k2961 
o|inlining procedure: k2961 
o|substituted constant variable: a2974 
o|inlining procedure: k2948 
o|inlining procedure: k2981 
o|inlining procedure: k2981 
o|substituted constant variable: a3025 
o|inlining procedure: k3026 
o|inlining procedure: k3026 
o|contracted procedure: k3042 
o|inlining procedure: k3045 
o|inlining procedure: k3045 
o|inlining procedure: k3078 
o|inlining procedure: k3078 
o|inlining procedure: k3102 
o|inlining procedure: k3102 
o|substituted constant variable: a3123 
o|inlining procedure: k3142 
o|inlining procedure: k3142 
o|inlining procedure: k3166 
o|propagated global variable: r31678803 delete-file 
o|inlining procedure: k3166 
o|inlining procedure: k3158 
o|inlining procedure: k3193 
o|inlining procedure: k3193 
o|inlining procedure: k3158 
o|inlining procedure: k3253 
o|inlining procedure: k3253 
o|inlining procedure: k3268 
o|inlining procedure: k3268 
o|inlining procedure: k3309 
o|inlining procedure: k3309 
o|substituted constant variable: a3331 
o|substituted constant variable: a3337 
o|inlining procedure: k3374 
o|inlining procedure: k3374 
o|inlining procedure: k3408 
o|inlining procedure: k3408 
o|inlining procedure: k3461 
o|inlining procedure: k3461 
o|inlining procedure: k3469 
o|inlining procedure: k3469 
o|contracted procedure: "(posix-common.scm:490) find-files" 
o|inlining procedure: k3494 
o|inlining procedure: k3494 
o|inlining procedure: k3512 
o|inlining procedure: k3512 
o|inlining procedure: k3531 
o|inlining procedure: k3531 
o|inlining procedure: k3540 
o|inlining procedure: k3572 
o|inlining procedure: k3572 
o|inlining procedure: k3586 
o|inlining procedure: k3586 
o|inlining procedure: k3540 
o|inlining procedure: k3598 
o|inlining procedure: k3598 
o|inlining procedure: k3617 
o|inlining procedure: k3617 
o|inlining procedure: k3638 
o|inlining procedure: k3638 
o|contracted procedure: k3652 
o|inlining procedure: k3657 
o|inlining procedure: k3657 
o|inlining procedure: k3727 
o|inlining procedure: k3727 
o|inlining procedure: k3804 
o|inlining procedure: k3804 
o|contracted procedure: "(posix-common.scm:527) ctime485" 
o|inlining procedure: k3840 
o|inlining procedure: k3840 
o|inlining procedure: k3884 
o|contracted procedure: "(posix-common.scm:550) strftime512" 
o|inlining procedure: k3870 
o|inlining procedure: k3870 
o|inlining procedure: k3884 
o|contracted procedure: "(posix-common.scm:552) asctime511" 
o|inlining procedure: k3857 
o|inlining procedure: k3857 
o|inlining procedure: k3986 
o|inlining procedure: k3995 
o|inlining procedure: k3995 
o|inlining procedure: k3986 
o|contracted procedure: "(posix-common.scm:576) get564" 
o|inlining procedure: k4096 
o|inlining procedure: k4096 
o|inlining procedure: k4211 
o|inlining procedure: k4211 
o|contracted procedure: "(posixunix.scm:502) fcntl697" 
o|inlining procedure: k4248 
o|inlining procedure: k4248 
o|inlining procedure: k4271 
o|inlining procedure: k4271 
o|inlining procedure: k4296 
o|inlining procedure: k4296 
o|inlining procedure: k4337 
o|inlining procedure: k4337 
o|inlining procedure: k4440 
o|inlining procedure: k4440 
o|inlining procedure: k4463 
o|inlining procedure: k4463 
o|inlining procedure: k4486 
o|inlining procedure: k4495 
o|inlining procedure: k4495 
o|inlining procedure: k4486 
o|inlining procedure: k4501 
o|inlining procedure: k4501 
o|inlining procedure: k4516 
o|inlining procedure: k4516 
o|contracted procedure: "(posixunix.scm:604) g869870" 
o|inlining procedure: k4535 
o|inlining procedure: k4535 
o|inlining procedure: k4575 
o|inlining procedure: k4575 
o|contracted procedure: "(posixunix.scm:596) g850851" 
o|inlining procedure: k4594 
o|inlining procedure: k4594 
o|contracted procedure: "(posixunix.scm:590) g824825" 
o|inlining procedure: k4649 
o|inlining procedure: k4649 
o|contracted procedure: "(posixunix.scm:584) g809810" 
o|inlining procedure: k4666 
o|inlining procedure: k4666 
o|inlining procedure: k4691 
o|inlining procedure: k4691 
o|contracted procedure: "(posixunix.scm:578) g791792" 
o|inlining procedure: k4708 
o|inlining procedure: k4708 
o|contracted procedure: k4738 
o|inlining procedure: k4741 
o|inlining procedure: k4741 
o|contracted procedure: k4753 
o|inlining procedure: k4756 
o|inlining procedure: k4756 
o|inlining procedure: k4790 
o|inlining procedure: k4790 
o|inlining procedure: k4802 
o|inlining procedure: k4802 
o|inlining procedure: k4812 
o|inlining procedure: k4812 
o|inlining procedure: k4845 
o|inlining procedure: k4845 
o|inlining procedure: k4867 
o|contracted procedure: "(posixunix.scm:678) g931932" 
o|inlining procedure: k4878 
o|inlining procedure: k4878 
o|inlining procedure: k4867 
o|inlining procedure: k4915 
o|inlining procedure: k4915 
o|contracted procedure: "(posixunix.scm:679) g949950" 
o|inlining procedure: k4923 
o|inlining procedure: k4923 
o|inlining procedure: k4962 
o|inlining procedure: k4962 
o|inlining procedure: k4982 
o|inlining procedure: k4982 
o|inlining procedure: k4995 
o|inlining procedure: k4995 
o|inlining procedure: k5013 
o|inlining procedure: k5013 
o|inlining procedure: k5038 
o|inlining procedure: k5038 
o|inlining procedure: "(posixunix.scm:718) badmode965" 
o|substituted constant variable: a5062 
o|substituted constant variable: a5064 
o|inlining procedure: k5078 
o|inlining procedure: k5078 
o|inlining procedure: "(posixunix.scm:729) badmode965" 
o|substituted constant variable: a5102 
o|substituted constant variable: a5104 
o|substituted constant variable: a5109 
o|substituted constant variable: a5110 
o|inlining procedure: k5111 
o|inlining procedure: k5111 
o|substituted constant variable: a5124 
o|substituted constant variable: a5125 
o|inlining procedure: k5126 
o|inlining procedure: k5126 
o|inlining procedure: k5254 
o|inlining procedure: k5254 
o|inlining procedure: k5312 
o|inlining procedure: k5312 
o|inlining procedure: k5325 
o|contracted procedure: "(posixunix.scm:860) g10921099" 
o|inlining procedure: k5325 
o|inlining procedure: k5361 
o|inlining procedure: k5361 
o|inlining procedure: k5377 
o|inlining procedure: k5377 
o|inlining procedure: k5450 
o|inlining procedure: k5450 
o|inlining procedure: k5543 
o|inlining procedure: k5570 
o|inlining procedure: k5570 
o|contracted procedure: "(posixunix.scm:1008) group-member" 
o|inlining procedure: k5543 
o|inlining procedure: k5632 
o|inlining procedure: k5632 
o|contracted procedure: "(posixunix.scm:1031) _get-groups" 
o|inlining procedure: "(posixunix.scm:1029) _ensure-groups" 
o|inlining procedure: k5690 
o|inlining procedure: k5690 
o|inlining procedure: "(posixunix.scm:1040) _ensure-groups" 
o|inlining procedure: k5762 
o|inlining procedure: k5762 
o|contracted procedure: "(posixunix.scm:1057) init1237" 
o|inlining procedure: k5826 
o|inlining procedure: k5826 
o|inlining procedure: k5856 
o|inlining procedure: k5856 
o|inlining procedure: k5883 
o|inlining procedure: k5883 
o|inlining procedure: k5919 
o|inlining procedure: k5919 
o|inlining procedure: k5944 
o|inlining procedure: k5944 
o|inlining procedure: k5980 
o|inlining procedure: k5980 
o|inlining procedure: k6004 
o|inlining procedure: k6029 
o|inlining procedure: k6029 
o|inlining procedure: k6050 
o|inlining procedure: k6050 
o|inlining procedure: k6080 
o|inlining procedure: k6080 
o|inlining procedure: k6004 
o|inlining procedure: k6125 
o|inlining procedure: k6125 
o|contracted procedure: "(posixunix.scm:1212) link1371" 
o|inlining procedure: k6100 
o|inlining procedure: k6100 
o|inlining procedure: k6179 
o|inlining procedure: k6179 
o|inlining procedure: k6205 
o|inlining procedure: k6205 
o|inlining procedure: k6219 
o|inlining procedure: k6243 
o|inlining procedure: k6243 
o|inlining procedure: k6219 
o|inlining procedure: k6264 
o|inlining procedure: k6264 
o|inlining procedure: k6284 
o|inlining procedure: k6284 
o|inlining procedure: k6321 
o|inlining procedure: k6321 
o|inlining procedure: k6343 
o|inlining procedure: k6343 
o|inlining procedure: k6352 
o|inlining procedure: k6352 
o|inlining procedure: k6374 
o|inlining procedure: k6374 
o|inlining procedure: k6399 
o|inlining procedure: k6399 
o|inlining procedure: k6446 
o|inlining procedure: k6446 
o|inlining procedure: k6468 
o|inlining procedure: k6468 
o|inlining procedure: k6496 
o|inlining procedure: k6496 
o|inlining procedure: k6539 
o|inlining procedure: k6539 
o|inlining procedure: k6588 
o|inlining procedure: k6588 
o|inlining procedure: k6693 
o|inlining procedure: k6714 
o|inlining procedure: k6714 
o|inlining procedure: k6693 
o|inlining procedure: k6770 
o|inlining procedure: k6770 
o|inlining procedure: k6800 
o|inlining procedure: k6800 
o|inlining procedure: k6815 
o|inlining procedure: k6832 
o|inlining procedure: k6832 
o|inlining procedure: k6815 
o|inlining procedure: k6928 
o|inlining procedure: k6928 
o|inlining procedure: k6938 
o|inlining procedure: k6938 
o|inlining procedure: k7050 
o|inlining procedure: k7050 
o|inlining procedure: k7066 
o|inlining procedure: k7066 
o|inlining procedure: k7082 
o|contracted procedure: "(posixunix.scm:1445) g16231624" 
o|contracted procedure: k7090 
o|inlining procedure: k7087 
o|inlining procedure: k7087 
o|inlining procedure: k7082 
o|inlining procedure: k7117 
o|inlining procedure: k7117 
o|inlining procedure: k7143 
o|inlining procedure: k7143 
o|inlining procedure: k7182 
o|inlining procedure: k7182 
o|inlining procedure: k7194 
o|inlining procedure: k7194 
o|substituted constant variable: a7207 
o|substituted constant variable: a7209 
o|substituted constant variable: a7211 
o|contracted procedure: "(posixunix.scm:1514) mmap1660" 
o|contracted procedure: k7295 
o|inlining procedure: k7323 
o|inlining procedure: k7323 
o|contracted procedure: "(posixunix.scm:1524) munmap1691" 
o|contracted procedure: "(posixunix.scm:1542) strptime1710" 
o|inlining procedure: k7366 
o|inlining procedure: k7366 
o|inlining procedure: k7418 
o|inlining procedure: k7418 
o|contracted procedure: "(posixunix.scm:1570) ex01750" 
o|inlining procedure: k7476 
o|inlining procedure: k7476 
o|inlining procedure: k7486 
o|inlining procedure: k7486 
o|inlining procedure: k7499 
o|inlining procedure: k7499 
o|substituted constant variable: a7515 
o|substituted constant variable: a7517 
o|substituted constant variable: a7519 
o|substituted constant variable: a7528 
o|contracted procedure: k7535 
o|inlining procedure: k7532 
o|inlining procedure: k7532 
o|inlining procedure: k7547 
o|inlining procedure: k7547 
o|contracted procedure: "(posixunix.scm:1610) ttyname1786" 
o|inlining procedure: k7603 
o|inlining procedure: k7603 
o|contracted procedure: "(posixunix.scm:1621) ttysize1795" 
o|inlining procedure: k7640 
o|inlining procedure: k7640 
o|contracted procedure: "(posixunix.scm:1634) getit1817" 
o|inlining procedure: k7669 
o|contracted procedure: "(posixunix.scm:1652) g18481849" 
o|inlining procedure: k7669 
o|contracted procedure: "(posixunix.scm:1645) fork1824" 
o|inlining procedure: k7814 
o|contracted procedure: "(posixunix.scm:1689) freeenv1860" 
o|contracted procedure: "(posixunix.scm:1688) freeargs1858" 
o|inlining procedure: k7860 
o|inlining procedure: k7860 
o|inlining procedure: k7814 
o|inlining procedure: k7948 
o|inlining procedure: k7948 
o|inlining procedure: k7967 
o|inlining procedure: k7967 
o|inlining procedure: k8001 
o|inlining procedure: k8001 
o|inlining procedure: k8020 
o|inlining procedure: k8020 
o|contracted procedure: k8041 
o|inlining procedure: k8038 
o|inlining procedure: k8038 
o|inlining procedure: k8091 
o|inlining procedure: k8109 
o|inlining procedure: k8109 
o|inlining procedure: k8091 
o|removed unused formal parameters: (loc1991) 
o|inlining procedure: k8123 
o|inlining procedure: k8123 
o|removed unused formal parameters: (loc1996 fd1999) 
o|inlining procedure: k8143 
o|inlining procedure: k8143 
o|inlining procedure: k8155 
o|contracted procedure: "(posixunix.scm:1790) replace-fd1971" 
o|inlining procedure: k8072 
o|inlining procedure: k8072 
o|inlining procedure: k8155 
o|inlining procedure: k8170 
o|inlining procedure: k8170 
o|removed unused parameter to known procedure: loc1991 "(posixunix.scm:1800) needed-pipe1977" 
o|removed unused parameter to known procedure: loc1991 "(posixunix.scm:1799) needed-pipe1977" 
o|removed unused parameter to known procedure: loc1991 "(posixunix.scm:1798) needed-pipe1977" 
o|removed unused formal parameters: (pid2031) 
o|inlining procedure: k8232 
o|inlining procedure: k8232 
o|removed unused parameter to known procedure: loc1996 "(posixunix.scm:1811) connect-parent1978" 
o|removed unused parameter to known procedure: fd1999 "(posixunix.scm:1811) connect-parent1978" 
o|removed unused formal parameters: (pid2039) 
o|inlining procedure: k8243 
o|inlining procedure: k8243 
o|removed unused parameter to known procedure: loc1996 "(posixunix.scm:1815) connect-parent1978" 
o|removed unused parameter to known procedure: fd1999 "(posixunix.scm:1815) connect-parent1978" 
o|removed unused parameter to known procedure: pid2031 "(posixunix.scm:1830) input-port2012" 
o|removed unused parameter to known procedure: pid2039 "(posixunix.scm:1827) output-port2013" 
o|removed unused parameter to known procedure: pid2031 "(posixunix.scm:1825) input-port2012" 
o|inlining procedure: k8323 
o|inlining procedure: k8323 
o|inlining procedure: k8484 
o|inlining procedure: k8484 
o|contracted procedure: "(posixunix.scm:1872) chroot2139" 
o|inlining procedure: k8469 
o|inlining procedure: k8469 
o|inlining procedure: k8507 
o|inlining procedure: k8507 
o|inlining procedure: k8528 
o|inlining procedure: k8528 
o|inlining procedure: k8547 
o|inlining procedure: k8547 
o|inlining procedure: k8566 
o|inlining procedure: k8566 
o|inlining procedure: k8585 
o|inlining procedure: k8585 
o|inlining procedure: k8604 
o|inlining procedure: k8604 
o|inlining procedure: k8626 
o|inlining procedure: k8626 
o|inlining procedure: k8641 
o|inlining procedure: k8641 
o|inlining procedure: k8653 
o|inlining procedure: k8653 
o|inlining procedure: k8665 
o|inlining procedure: k8665 
o|inlining procedure: k8675 
o|inlining procedure: k8675 
o|inlining procedure: k8710 
o|inlining procedure: k8710 
o|inlining procedure: k8756 
o|inlining procedure: k8756 
o|contracted procedure: "(posix-common.scm:250) g116117" 
o|inlining procedure: k8743 
o|inlining procedure: k8743 
o|replaced variables: 906 
o|removed binding forms: 566 
o|substituted constant variable: r26928770 
o|substituted constant variable: r28098774 
o|substituted constant variable: r28218776 
o|substituted constant variable: r28338778 
o|substituted constant variable: r27978780 
o|inlining procedure: k2948 
o|substituted constant variable: r29628784 
o|inlining procedure: k2948 
o|inlining procedure: k2948 
o|propagated global variable: g2812828804 delete-file 
o|inlining procedure: k3166 
o|inlining procedure: k3166 
o|propagated global variable: r31679288 delete-file 
o|propagated global variable: r31679288 delete-file 
o|converted assignments to bindings: (rmdir263) 
o|substituted constant variable: r32698819 
o|substituted constant variable: r33758823 
o|substituted constant variable: r34628829 
o|substituted constant variable: r34628829 
o|substituted constant variable: r34708833 
o|substituted constant variable: r34708833 
o|substituted constant variable: r35878848 
o|substituted constant variable: r35878848 
o|substituted constant variable: r35878850 
o|substituted constant variable: r35878850 
o|substituted constant variable: r36398859 
o|substituted constant variable: r36398859 
o|substituted constant variable: r36398861 
o|substituted constant variable: r36398861 
o|substituted constant variable: loc379 
o|substituted constant variable: r38718875 
o|substituted constant variable: r38718875 
o|substituted constant variable: r38588882 
o|substituted constant variable: r38588882 
o|substituted constant variable: r39878888 
o|substituted constant variable: r44648915 
o|substituted constant variable: r44648915 
o|substituted constant variable: r44648917 
o|substituted constant variable: r44648917 
o|inlining procedure: k4486 
o|inlining procedure: k4486 
o|substituted constant variable: r44968922 
o|inlining procedure: k4486 
o|substituted constant variable: r44878923 
o|substituted constant variable: r44878923 
o|substituted constant variable: r45368931 
o|substituted constant variable: r45368931 
o|substituted constant variable: r45958937 
o|substituted constant variable: r45958937 
o|substituted constant variable: r46678943 
o|substituted constant variable: r46678943 
o|substituted constant variable: r47098949 
o|substituted constant variable: r47098949 
o|substituted constant variable: r48038958 
o|substituted constant variable: loc933 
o|substituted constant variable: loc933 
o|substituted constant variable: loc951 
o|substituted constant variable: loc951 
o|substituted constant variable: r49968982 
o|removed side-effect free assignment to unused variable: badmode965 
o|inlining procedure: k5038 
o|inlining procedure: k5078 
o|substituted constant variable: r54519030 
o|substituted constant variable: r55719033 
o|substituted constant variable: r55449034 
o|removed side-effect free assignment to unused variable: _ensure-groups 
o|substituted constant variable: r56339035 
o|inlining procedure: k6050 
o|substituted constant variable: r60819078 
o|substituted constant variable: r60819078 
o|substituted constant variable: r61019085 
o|substituted constant variable: r61019085 
o|substituted constant variable: r62069089 
o|inlining procedure: k6276 
o|inlining procedure: k6276 
o|inlining procedure: k6358 
o|substituted constant variable: r64699121 
o|substituted constant variable: r65899133 
o|inlining procedure: k6776 
o|inlining procedure: k6938 
o|substituted constant variable: r70889158 
o|substituted constant variable: r71839165 
o|inlining procedure: k7269 
o|substituted constant variable: r73679173 
o|substituted constant variable: r73679173 
o|substituted constant variable: r74879181 
o|substituted constant variable: r74879181 
o|folded constant expression: (fx< (quote -1) (quote 0)) 
o|substituted constant variable: r75339185 
o|substituted constant variable: int18501853 
o|inlining procedure: k7967 
o|inlining procedure: k7967 
o|substituted constant variable: r80219210 
o|substituted constant variable: r81249218 
o|substituted constant variable: r81449220 
o|substituted constant variable: r81719226 
o|removed unused formal parameters: (stdfd2035) 
o|substituted constant variable: r82339228 
o|removed unused formal parameters: (stdfd2043) 
o|substituted constant variable: r82449230 
o|removed unused parameter to known procedure: stdfd2035 "(posixunix.scm:1830) input-port2012" 
o|removed unused parameter to known procedure: stdfd2043 "(posixunix.scm:1827) output-port2013" 
o|removed unused parameter to known procedure: stdfd2035 "(posixunix.scm:1825) input-port2012" 
o|substituted constant variable: r84709237 
o|substituted constant variable: r84709237 
o|converted assignments to bindings: (check1302) 
o|substituted constant variable: r86669264 
o|substituted constant variable: r87449275 
o|substituted constant variable: r87449275 
o|simplifications: ((let . 2)) 
o|replaced variables: 62 
o|removed binding forms: 947 
o|inlining procedure: k3312 
o|inlining procedure: k4047 
o|inlining procedure: k4047 
o|inlining procedure: k4308 
o|inlining procedure: k4308 
o|inlining procedure: k4353 
o|inlining procedure: k4353 
o|substituted constant variable: r44879322 
o|inlining procedure: k7285 
o|inlining procedure: k7285 
o|inlining procedure: k7841 
o|removed unused formal parameters: (loc2004) 
o|removed unused parameter to known procedure: loc2004 "(posixunix.scm:1807) connect-child1979" 
o|removed unused parameter to known procedure: loc2004 "(posixunix.scm:1806) connect-child1979" 
o|removed unused parameter to known procedure: loc2004 "(posixunix.scm:1805) connect-child1979" 
o|inlining procedure: k8435 
o|replaced variables: 29 
o|removed binding forms: 179 
o|substituted constant variable: r29499277 
o|substituted constant variable: r29499279 
o|substituted constant variable: r29499281 
o|substituted constant variable: r33139423 
o|substituted constant variable: r33139423 
o|substituted constant variable: r40489438 
o|substituted constant variable: r43099441 
o|substituted constant variable: r43549443 
o|substituted constant variable: r72869473 
o|contracted procedure: k7663 
o|contracted procedure: k7838 
o|removed unused formal parameters: (loc2017) 
o|removed unused parameter to known procedure: loc2017 "(posixunix.scm:1819) spawn2011" 
o|inlining procedure: k8707 
o|inlining procedure: k8707 
o|simplifications: ((let . 3)) 
o|replaced variables: 2 
o|removed binding forms: 31 
o|removed conditional forms: 4 
o|inlining procedure: k7447 
o|inlining procedure: k7447 
o|substituted constant variable: r87089537 
o|replaced variables: 1 
o|removed binding forms: 11 
o|substituted constant variable: r74489587 
o|removed binding forms: 3 
o|removed binding forms: 1 
o|simplifications: ((if . 88) (##core#call . 671)) 
o|  call simplifications:
o|    bitwise-ior	2
o|    <
o|    vector-ref	2
o|    make-vector
o|    ##sys#structure?
o|    ##sys#foreign-pointer-argument	4
o|    fxior	2
o|    ##sys#check-structure	3
o|    ##sys#make-structure	3
o|    ##sys#setislot	3
o|    fxmin	2
o|    eof-object?
o|    ##sys#foreign-string-argument	7
o|    length
o|    fx>=	8
o|    fx*
o|    *
o|    inexact->exact
o|    memq	2
o|    list	7
o|    values	20
o|    ##sys#fudge	2
o|    vector-set!	3
o|    char=?
o|    ##sys#foreign-block-argument	8
o|    ##sys#foreign-integer-argument	5
o|    fx-	12
o|    ##sys#check-number	8
o|    ##sys#check-vector
o|    procedure?
o|    member
o|    fx+	27
o|    ##sys#call-with-values	13
o|    ##sys#size	17
o|    string-ref
o|    fx>
o|    not	8
o|    cons	12
o|    ##sys#check-string	34
o|    ##sys#check-list	7
o|    fx=	29
o|    zero?
o|    ##sys#slot	32
o|    ##sys#check-exact	37
o|    ##sys#null-pointer?	4
o|    pair?	19
o|    eq?	40
o|    cdr	28
o|    ##sys#eqv?	13
o|    null?	73
o|    car	52
o|    vector	2
o|    fixnum?	15
o|    string?	2
o|    fx<	47
o|    ##sys#foreign-fixnum-argument	33
o|    apply	9
o|contracted procedure: k2665 
o|contracted procedure: k2694 
o|contracted procedure: k2703 
o|contracted procedure: k2709 
o|contracted procedure: k2741 
o|contracted procedure: k2732 
o|contracted procedure: k2862 
o|contracted procedure: k2784 
o|contracted procedure: k2856 
o|contracted procedure: k2787 
o|contracted procedure: k2850 
o|contracted procedure: k2790 
o|contracted procedure: k2844 
o|contracted procedure: k2793 
o|contracted procedure: k2805 
o|contracted procedure: k2811 
o|contracted procedure: k2817 
o|contracted procedure: k2823 
o|contracted procedure: k2829 
o|contracted procedure: k2835 
o|contracted procedure: k2841 
o|contracted procedure: k2951 
o|contracted procedure: k2958 
o|contracted procedure: k2984 
o|contracted procedure: k2996 
o|contracted procedure: k3010 
o|contracted procedure: k3066 
o|contracted procedure: k3029 
o|contracted procedure: k3058 
o|contracted procedure: k3048 
o|contracted procedure: k3072 
o|contracted procedure: k3081 
o|contracted procedure: k3087 
o|contracted procedure: k3090 
o|contracted procedure: k3093 
o|contracted procedure: k3124 
o|contracted procedure: k3099 
o|contracted procedure: k3216 
o|contracted procedure: k3133 
o|contracted procedure: k3145 
o|contracted procedure: k3152 
o|contracted procedure: k3181 
o|contracted procedure: k3196 
o|contracted procedure: k3206 
o|contracted procedure: k3210 
o|contracted procedure: k3350 
o|contracted procedure: k3228 
o|contracted procedure: k3344 
o|contracted procedure: k3231 
o|contracted procedure: k3338 
o|contracted procedure: k3234 
o|contracted procedure: k3237 
o|contracted procedure: k3256 
o|contracted procedure: k3271 
o|contracted procedure: k3275 
o|contracted procedure: k3281 
o|contracted procedure: k3327 
o|contracted procedure: k3284 
o|contracted procedure: k3303 
o|contracted procedure: k3306 
o|contracted procedure: k3321 
o|contracted procedure: k3312 
o|contracted procedure: k3356 
o|contracted procedure: k3377 
o|contracted procedure: k3380 
o|contracted procedure: k3411 
o|contracted procedure: k3418 
o|contracted procedure: k3441 
o|contracted procedure: k3457 
o|contracted procedure: k3475 
o|contracted procedure: k3497 
o|contracted procedure: k3500 
o|contracted procedure: k3503 
o|contracted procedure: k3515 
o|contracted procedure: k3524 
o|contracted procedure: k3550 
o|contracted procedure: k3641 
o|contracted procedure: k3660 
o|contracted procedure: k3724 
o|contracted procedure: k3737 
o|contracted procedure: k3730 
o|contracted procedure: k3746 
o|contracted procedure: k3752 
o|contracted procedure: k3767 
o|contracted procedure: k3773 
o|contracted procedure: k3798 
o|contracted procedure: k3815 
o|contracted procedure: k3811 
o|contracted procedure: k3790 
o|contracted procedure: k3821 
o|contracted procedure: k3931 
o|contracted procedure: k3878 
o|contracted procedure: k3887 
o|contracted procedure: k3870 
o|contracted procedure: k3921 
o|contracted procedure: k3917 
o|contracted procedure: k3857 
o|contracted procedure: k3940 
o|contracted procedure: k3943 
o|contracted procedure: k3957 
o|contracted procedure: k3998 
o|contracted procedure: k4005 
o|contracted procedure: k4013 
o|contracted procedure: k4025 
o|contracted procedure: k4029 
o|contracted procedure: k4036 
o|contracted procedure: k3972 
o|contracted procedure: k4043 
o|contracted procedure: k4126 
o|contracted procedure: k4066 
o|contracted procedure: k4120 
o|contracted procedure: k4069 
o|contracted procedure: k4114 
o|contracted procedure: k4072 
o|contracted procedure: k4108 
o|contracted procedure: k4075 
o|contracted procedure: k4078 
o|contracted procedure: k4081 
o|contracted procedure: k4099 
o|contracted procedure: k4136 
o|contracted procedure: k4143 
o|contracted procedure: k4220 
o|contracted procedure: k4199 
o|contracted procedure: k4202 
o|contracted procedure: k4205 
o|contracted procedure: k4214 
o|contracted procedure: k4186 
o|contracted procedure: k4190 
o|contracted procedure: k4194 
o|contracted procedure: k8685 
o|contracted procedure: k4227 
o|contracted procedure: k4235 
o|contracted procedure: k4238 
o|contracted procedure: k4241 
o|contracted procedure: k4251 
o|contracted procedure: k4261 
o|contracted procedure: k4268 
o|contracted procedure: k4274 
o|contracted procedure: k4284 
o|contracted procedure: k4287 
o|contracted procedure: k4302 
o|contracted procedure: k4314 
o|contracted procedure: k4325 
o|contracted procedure: k4334 
o|contracted procedure: k4340 
o|contracted procedure: k4346 
o|contracted procedure: k4362 
o|contracted procedure: k4368 
o|contracted procedure: k4382 
o|contracted procedure: k4385 
o|contracted procedure: k4405 
o|contracted procedure: k4411 
o|contracted procedure: k4443 
o|contracted procedure: k4452 
o|contracted procedure: k4469 
o|contracted procedure: k4459 
o|contracted procedure: k4466 
o|contracted procedure: k4492 
o|contracted procedure: k4498 
o|contracted procedure: k4504 
o|contracted procedure: k4510 
o|contracted procedure: k4519 
o|contracted procedure: k4548 
o|contracted procedure: k4558 
o|contracted procedure: k4552 
o|contracted procedure: k4565 
o|contracted procedure: k4569 
o|contracted procedure: k4531 
o|contracted procedure: k4535 
o|contracted procedure: k4578 
o|contracted procedure: k4607 
o|contracted procedure: k4617 
o|contracted procedure: k4611 
o|contracted procedure: k4624 
o|contracted procedure: k4628 
o|contracted procedure: k4590 
o|contracted procedure: k4594 
o|contracted procedure: k4423 
o|contracted procedure: k4427 
o|contracted procedure: k4431 
o|contracted procedure: k4639 
o|contracted procedure: k4652 
o|contracted procedure: k4679 
o|contracted procedure: k4685 
o|contracted procedure: k4658 
o|contracted procedure: k4662 
o|contracted procedure: k4666 
o|contracted procedure: k4694 
o|contracted procedure: k4721 
o|contracted procedure: k4727 
o|contracted procedure: k4700 
o|contracted procedure: k4704 
o|contracted procedure: k4708 
o|contracted procedure: k4734 
o|contracted procedure: k4744 
o|contracted procedure: k4750 
o|contracted procedure: k4759 
o|contracted procedure: k4765 
o|contracted procedure: k4768 
o|contracted procedure: k4781 
o|contracted procedure: k4784 
o|contracted procedure: k4809 
o|contracted procedure: k4805 
o|contracted procedure: k4815 
o|contracted procedure: k4825 
o|contracted procedure: k4947 
o|contracted procedure: k4836 
o|contracted procedure: k4839 
o|contracted procedure: k4944 
o|contracted procedure: k4848 
o|contracted procedure: k4881 
o|contracted procedure: k4926 
o|contracted procedure: k4956 
o|contracted procedure: k4965 
o|contracted procedure: k4979 
o|contracted procedure: k4985 
o|contracted procedure: k4998 
o|contracted procedure: k5016 
o|contracted procedure: k5028 
o|contracted procedure: k5041 
o|contracted procedure: k5051 
o|contracted procedure: k5068 
o|contracted procedure: k5081 
o|contracted procedure: k5091 
o|contracted procedure: k5114 
o|contracted procedure: k5129 
o|contracted procedure: k5260 
o|contracted procedure: k5295 
o|contracted procedure: k5301 
o|contracted procedure: k5315 
o|contracted procedure: k5328 
o|contracted procedure: k5338 
o|contracted procedure: k5342 
o|contracted procedure: k5306 
o|contracted procedure: k5352 
o|contracted procedure: k5358 
o|contracted procedure: k5364 
o|contracted procedure: k5374 
o|contracted procedure: k5380 
o|contracted procedure: k5416 
o|contracted procedure: k5489 
o|contracted procedure: k5444 
o|contracted procedure: k5453 
o|contracted procedure: k5479 
o|contracted procedure: k5482 
o|contracted procedure: k5594 
o|contracted procedure: k5537 
o|contracted procedure: k5546 
o|contracted procedure: k5581 
o|contracted procedure: k5531 
o|contracted procedure: k5584 
o|contracted procedure: k5587 
o|contracted procedure: k5635 
o|contracted procedure: k5647 
o|contracted procedure: k5650 
o|contracted procedure: k5604 
o|contracted procedure: k56119042 
o|contracted procedure: k5669 
o|contracted procedure: k5693 
o|contracted procedure: k5699 
o|contracted procedure: k5709 
o|contracted procedure: k5712 
o|contracted procedure: k5719 
o|contracted procedure: k5723 
o|contracted procedure: k5733 
o|contracted procedure: k56119050 
o|contracted procedure: k5756 
o|contracted procedure: k5759 
o|contracted procedure: k5765 
o|contracted procedure: k5744 
o|contracted procedure: k5751 
o|contracted procedure: k5820 
o|contracted procedure: k5823 
o|contracted procedure: k5829 
o|contracted procedure: k5847 
o|contracted procedure: k5850 
o|contracted procedure: k5853 
o|contracted procedure: k5859 
o|contracted procedure: k5877 
o|contracted procedure: k5880 
o|contracted procedure: k5922 
o|contracted procedure: k5938 
o|contracted procedure: k5941 
o|contracted procedure: k5947 
o|contracted procedure: k5983 
o|contracted procedure: k6086 
o|contracted procedure: k5995 
o|contracted procedure: k5998 
o|contracted procedure: k6032 
o|contracted procedure: k6072 
o|contracted procedure: k6076 
o|contracted procedure: k6119 
o|contracted procedure: k6122 
o|contracted procedure: k6128 
o|contracted procedure: k6107 
o|contracted procedure: k6114 
o|contracted procedure: k6655 
o|contracted procedure: k6141 
o|contracted procedure: k6649 
o|contracted procedure: k6144 
o|contracted procedure: k6643 
o|contracted procedure: k6147 
o|contracted procedure: k6637 
o|contracted procedure: k6150 
o|contracted procedure: k6631 
o|contracted procedure: k6153 
o|contracted procedure: k6625 
o|contracted procedure: k6156 
o|contracted procedure: k6619 
o|contracted procedure: k6159 
o|contracted procedure: k6613 
o|contracted procedure: k6162 
o|contracted procedure: k6604 
o|contracted procedure: k6168 
o|contracted procedure: k6182 
o|contracted procedure: k6188 
o|contracted procedure: k6208 
o|contracted procedure: k6222 
o|contracted procedure: k6228 
o|contracted procedure: k6231 
o|contracted procedure: k6246 
o|contracted procedure: k6261 
o|contracted procedure: k6281 
o|contracted procedure: k6287 
o|contracted procedure: k6290 
o|contracted procedure: k6324 
o|contracted procedure: k6328 
o|contracted procedure: k6331 
o|contracted procedure: k6340 
o|contracted procedure: k6355 
o|contracted procedure: k6364 
o|contracted procedure: k6380 
o|contracted procedure: k6402 
o|contracted procedure: k6408 
o|contracted procedure: k6411 
o|contracted procedure: k6440 
o|contracted procedure: k6414 
o|contracted procedure: k6418 
o|contracted procedure: k6422 
o|contracted procedure: k6429 
o|contracted procedure: k6433 
o|contracted procedure: k6437 
o|contracted procedure: k6449 
o|contracted procedure: k6459 
o|contracted procedure: k6471 
o|contracted procedure: k6533 
o|contracted procedure: k6487 
o|contracted procedure: k6493 
o|contracted procedure: k6499 
o|contracted procedure: k6506 
o|contracted procedure: k6515 
o|contracted procedure: k6526 
o|contracted procedure: k6522 
o|contracted procedure: k6554 
o|contracted procedure: k6550 
o|contracted procedure: k6543 
o|inlining procedure: k6539 
o|contracted procedure: k6565 
o|contracted procedure: k6569 
o|contracted procedure: k6561 
o|inlining procedure: k6539 
o|contracted procedure: k6576 
o|contracted procedure: k6579 
o|contracted procedure: k6591 
o|contracted procedure: k6598 
o|contracted procedure: k6916 
o|contracted procedure: k6664 
o|contracted procedure: k6910 
o|contracted procedure: k6667 
o|contracted procedure: k6904 
o|contracted procedure: k6670 
o|contracted procedure: k6898 
o|contracted procedure: k6673 
o|contracted procedure: k6892 
o|contracted procedure: k6676 
o|contracted procedure: k6886 
o|contracted procedure: k6679 
o|contracted procedure: k6696 
o|contracted procedure: k6702 
o|contracted procedure: k6705 
o|contracted procedure: k6717 
o|contracted procedure: k6732 
o|contracted procedure: k6743 
o|contracted procedure: k6877 
o|contracted procedure: k6746 
o|contracted procedure: k6773 
o|contracted procedure: k6782 
o|contracted procedure: k6795 
o|contracted procedure: k6807 
o|contracted procedure: k6822 
o|contracted procedure: k6826 
o|contracted procedure: k6835 
o|contracted procedure: k6848 
o|contracted procedure: k6855 
o|contracted procedure: k6859 
o|contracted procedure: k6865 
o|contracted procedure: k6871 
o|contracted procedure: k6925 
o|contracted procedure: k6941 
o|contracted procedure: k6955 
o|contracted procedure: k7020 
o|contracted procedure: k6964 
o|contracted procedure: k7014 
o|contracted procedure: k6967 
o|contracted procedure: k7008 
o|contracted procedure: k6970 
o|contracted procedure: k7002 
o|contracted procedure: k6973 
o|contracted procedure: k6979 
o|contracted procedure: k6992 
o|contracted procedure: k6986 
o|contracted procedure: k6995 
o|contracted procedure: k7033 
o|contracted procedure: k7037 
o|contracted procedure: k7041 
o|contracted procedure: k7053 
o|contracted procedure: k7069 
o|contracted procedure: k7094 
o|contracted procedure: k7106 
o|contracted procedure: k7110 
o|contracted procedure: k7114 
o|contracted procedure: k7128 
o|contracted procedure: k7120 
o|contracted procedure: k7134 
o|contracted procedure: k7140 
o|contracted procedure: k7146 
o|contracted procedure: k7161 
o|contracted procedure: k7169 
o|contracted procedure: k7175 
o|contracted procedure: k7185 
o|contracted procedure: k7191 
o|contracted procedure: k7197 
o|contracted procedure: k7275 
o|contracted procedure: k7229 
o|contracted procedure: k7233 
o|contracted procedure: k7237 
o|contracted procedure: k7241 
o|contracted procedure: k7245 
o|contracted procedure: k7249 
o|contracted procedure: k7291 
o|contracted procedure: k7317 
o|contracted procedure: k7326 
o|contracted procedure: k7337 
o|contracted procedure: k7305 
o|contracted procedure: k7309 
o|contracted procedure: k7340 
o|contracted procedure: k7350 
o|contracted procedure: k7402 
o|contracted procedure: k7374 
o|contracted procedure: k7377 
o|contracted procedure: k7380 
o|contracted procedure: k7395 
o|substituted constant variable: g9792 
o|substituted constant variable: g9792 
o|substituted constant variable: g9792 
o|substituted constant variable: g9792 
o|substituted constant variable: g9792 
o|substituted constant variable: g9792 
o|substituted constant variable: g9792 
o|substituted constant variable: g9792 
o|substituted constant variable: g9792 
o|substituted constant variable: g9792 
o|contracted procedure: k7366 
o|contracted procedure: k7450 
o|contracted procedure: k74389586 
o|contracted procedure: k74389591 
o|contracted procedure: k7458 
o|contracted procedure: k7473 
o|contracted procedure: k7493 
o|contracted procedure: k7489 
o|contracted procedure: k7496 
o|contracted procedure: k7502 
o|contracted procedure: k7508 
o|contracted procedure: k7520 
o|contracted procedure: k7539 
o|contracted procedure: k7560 
o|contracted procedure: k7556 
o|contracted procedure: k7550 
o|contracted procedure: k7571 
o|contracted procedure: k7606 
o|contracted procedure: k7587 
o|contracted procedure: k7591 
o|contracted procedure: k7595 
o|contracted procedure: k7729 
o|contracted procedure: k7651 
o|contracted procedure: k7723 
o|contracted procedure: k7654 
o|contracted procedure: k7717 
o|contracted procedure: k7657 
o|contracted procedure: k7711 
o|contracted procedure: k7660 
o|contracted procedure: k7672 
o|contracted procedure: k7675 
o|contracted procedure: k7690 
o|contracted procedure: k7705 
o|contracted procedure: k7739 
o|contracted procedure: k7747 
o|contracted procedure: k7754 
o|contracted procedure: k7762 
o|contracted procedure: k7770 
o|contracted procedure: k7777 
o|contracted procedure: k7935 
o|contracted procedure: k7784 
o|contracted procedure: k7929 
o|contracted procedure: k7787 
o|contracted procedure: k7923 
o|contracted procedure: k7790 
o|contracted procedure: k7917 
o|contracted procedure: k7793 
o|contracted procedure: k7796 
o|contracted procedure: k7799 
o|contracted procedure: k7817 
o|contracted procedure: k7829 
o|contracted procedure: k7835 
o|contracted procedure: k7851 
o|contracted procedure: k7863 
o|contracted procedure: k7869 
o|contracted procedure: k7872 
o|contracted procedure: k7884 
o|contracted procedure: k7888 
o|contracted procedure: k7891 
o|contracted procedure: k7894 
o|contracted procedure: k7906 
o|contracted procedure: k7910 
o|contracted procedure: k7914 
o|contracted procedure: k7945 
o|contracted procedure: k7973 
o|contracted procedure: k7951 
o|contracted procedure: k7986 
o|contracted procedure: k7995 
o|contracted procedure: k7998 
o|contracted procedure: k8004 
o|contracted procedure: k8010 
o|contracted procedure: k8062 
o|contracted procedure: k8065 
o|contracted procedure: k8088 
o|contracted procedure: k8115 
o|contracted procedure: k8094 
o|contracted procedure: k8146 
o|contracted procedure: k8158 
o|contracted procedure: k8075 
o|contracted procedure: k8177 
o|contracted procedure: k8294 
o|contracted procedure: k8298 
o|contracted procedure: k8302 
o|contracted procedure: k8263 
o|contracted procedure: k8309 
o|contracted procedure: k8326 
o|contracted procedure: k8336 
o|contracted procedure: k8340 
o|contracted procedure: k8343 
o|contracted procedure: k8417 
o|contracted procedure: k8378 
o|contracted procedure: k8411 
o|contracted procedure: k8381 
o|contracted procedure: k8405 
o|contracted procedure: k8384 
o|contracted procedure: k8399 
o|contracted procedure: k8387 
o|contracted procedure: k8459 
o|contracted procedure: k8426 
o|contracted procedure: k8453 
o|contracted procedure: k8429 
o|contracted procedure: k8447 
o|contracted procedure: k8432 
o|contracted procedure: k8441 
o|contracted procedure: k8435 
o|contracted procedure: k8481 
o|contracted procedure: k8487 
o|contracted procedure: k8476 
o|contracted procedure: k8498 
o|contracted procedure: k8504 
o|contracted procedure: k8510 
o|contracted procedure: k8522 
o|contracted procedure: k8525 
o|contracted procedure: k8531 
o|contracted procedure: k8550 
o|contracted procedure: k8569 
o|contracted procedure: k8588 
o|contracted procedure: k8607 
o|contracted procedure: k8629 
o|contracted procedure: k8632 
o|contracted procedure: k8641 
o|contracted procedure: k8656 
o|contracted procedure: k8672 
o|contracted procedure: k8668 
o|contracted procedure: k8678 
o|contracted procedure: k8691 
o|contracted procedure: k8716 
o|contracted procedure: k8700 
o|contracted procedure: k8703 
o|contracted procedure: k8725 
o|contracted procedure: k8737 
o|contracted procedure: k8759 
o|contracted procedure: k8750 
o|simplifications: ((if . 1) (let . 121)) 
o|removed binding forms: 583 
o|inlining procedure: k3743 
o|inlining procedure: k3764 
o|inlining procedure: "(posixunix.scm:711) mode964" 
o|inlining procedure: "(posixunix.scm:722) mode964" 
o|inlining procedure: k5740 
o|inlining procedure: k7743 
o|inlining procedure: k7766 
o|replaced variables: 313 
o|removed binding forms: 2 
o|inlining procedure: k4672 
o|inlining procedure: k4672 
o|inlining procedure: k4714 
o|inlining procedure: k4714 
o|removed side-effect free assignment to unused variable: mode964 
o|inlining procedure: k5331 
o|inlining procedure: k5663 
o|inlining procedure: k5726 
o|substituted constant variable: r57419900 
o|substituted constant variable: r57419900 
o|substituted constant variable: r77449913 
o|substituted constant variable: r77449913 
o|substituted constant variable: r77679916 
o|substituted constant variable: r77679916 
o|replaced variables: 10 
o|removed binding forms: 158 
o|contracted procedure: k4208 
o|contracted procedure: k4437 
o|contracted procedure: k5660 
o|contracted procedure: k7266 
o|contracted procedure: k7333 
o|contracted procedure: k7616 
o|converted assignments to bindings: (check966) 
o|simplifications: ((let . 3)) 
o|removed binding forms: 25 
o|contracted procedure: k5031 
o|contracted procedure: k5071 
o|replaced variables: 2 
o|removed binding forms: 2 
o|removed binding forms: 1 
o|direct leaf routine/allocation: doloop805806 0 
o|direct leaf routine/allocation: doloop787788 0 
o|direct leaf routine/allocation: for-each-loop10911103 0 
o|direct leaf routine/allocation: peek1415 0 
o|direct leaf routine/allocation: swapped-ends2014 3 
o|direct leaf routine/allocation: g20722079 0 
o|contracted procedure: k4414 
o|contracted procedure: k4417 
o|converted assignments to bindings: (doloop805806) 
o|converted assignments to bindings: (doloop787788) 
o|contracted procedure: k5309 
o|converted assignments to bindings: (for-each-loop10911103) 
o|contracted procedure: "(posixunix.scm:1273) k6318" 
o|contracted procedure: "(posixunix.scm:1802) k8197" 
o|contracted procedure: "(posixunix.scm:1807) k8220" 
o|contracted procedure: "(posixunix.scm:1806) k8224" 
o|contracted procedure: "(posixunix.scm:1843) k8329" 
o|simplifications: ((let . 3)) 
o|removed binding forms: 8 
o|direct leaf routine/allocation: for-each-loop20712089 0 
o|converted assignments to bindings: (for-each-loop20712089) 
o|simplifications: ((let . 1)) 
o|customizable procedures: (loop1112 %process2060 chkstrlst2067 output-port2013 make-on-close1976 input-port2012 spawn2011 connect-parent1978 needed-pipe1977 connect-child1979 k8032 k7992 doloop19041905 setarg1857 doloop19081909 setenv1859 ##sys#terminal-check k7467 k7479 k7320 k7260 k7137 setup1586 err1587 k6982 k6931 loop1555 k6749 k6474 k6393 loop1461 ready?1414 fetch1416 loop1357 check1302 doloop12261227 loop1218 k5540 loop1199 k5447 check966 k4870 loop928 k4778 k4394 k4397 k4400 k4632 k4600 lp842 k4541 lp861 k4482 k4331 k4232 scan573 loop570 check-time-vector k3478 k3481 loop391 g363364 loop355 conc-loop336 k3290 loop315 g271278 for-each-loop270287 rmdir263 k3075 mode183 check184 ##sys#stat) 
o|calls to known targets: 284 
o|unused rest argument: _387 f_3663 
o|unused rest argument: _386 f_3655 
o|unused rest argument: _426 f_3715 
o|identified direct recursive calls: f_3993 1 
o|identified direct recursive calls: f_4689 2 
o|identified direct recursive calls: f_4647 2 
o|identified direct recursive calls: f_5323 1 
o|identified direct recursive calls: f_5630 1 
o|identified direct recursive calls: f_5688 1 
o|identified direct recursive calls: f_6397 1 
o|identified direct recursive calls: f_6830 1 
o|identified direct recursive calls: f_8321 1 
o|identified direct recursive calls: f_8624 2 
o|fast box initializations: 25 
o|fast global references: 67 
o|fast global assignments: 4 
o|dropping unused closure argument: f_5875 
o|dropping unused closure argument: f_3722 
o|dropping unused closure argument: f_2686 
o|dropping unused closure argument: f_3137 
o|dropping unused closure argument: f_7027 
o|dropping unused closure argument: f_8153 
o|dropping unused closure argument: f_8141 
o|dropping unused closure argument: f_8168 
o|dropping unused closure argument: f_6962 
o|dropping unused closure argument: f_8084 
o|dropping unused closure argument: f_8121 
o|dropping unused closure argument: f_8305 
o|dropping unused closure argument: f_7543 
o|dropping unused closure argument: f_2942 
o|dropping unused closure argument: f_2979 
o|dropping unused closure argument: f_7736 
o|dropping unused closure argument: f_7759 
o|dropping unused closure argument: f_5323 
o|dropping unused closure argument: f_5011 
*/
/* end of file */
