/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import net.sf.saxon.Controller;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.instruct.Block;
import net.sf.saxon.instruct.ParentNodeConstructor;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.instruct.ValueOf;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pull.UnconstructedElement;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.StringValue;

public abstract class ElementCreator
extends ParentNodeConstructor {
    protected boolean inheritNamespaces = true;
    protected boolean validating = false;

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return NodeKindTest.ELEMENT;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public boolean isInheritNamespaces() {
        return this.inheritNamespaces;
    }

    public int computeSpecialProperties() {
        return super.computeSpecialProperties() | 0x800000;
    }

    public void setValidationMode(int n) {
        this.validation = n;
        if (n != 3) {
            this.validating = true;
        }
    }

    public int getValidationMode() {
        return this.validation;
    }

    public void suppressValidation(int n) {
        if (this.validation == n) {
            this.setValidationMode(3);
        }
    }

    protected void checkContentForAttributes(StaticContext staticContext) throws XPathException {
        if (this.content instanceof Block) {
            TypeHierarchy typeHierarchy = staticContext.getConfiguration().getTypeHierarchy();
            Expression[] expressionArray = ((Block)this.content).getChildren();
            boolean bl = false;
            int n = 394;
            for (int i = 0; i < expressionArray.length; ++i) {
                ItemType itemType;
                if (expressionArray[i] instanceof ValueOf && ((ValueOf)expressionArray[i]).select instanceof StringValue && ((StringValue)((ValueOf)expressionArray[i]).select).getStringValue().equals("") || !((itemType = expressionArray[i].getItemType(typeHierarchy)) instanceof NodeTest)) continue;
                int n2 = ((NodeTest)itemType).getNodeKindMask();
                if ((n2 & ~n) == 0) {
                    bl = true;
                    continue;
                }
                if (bl && n2 == 4) {
                    DynamicError dynamicError = new DynamicError("Cannot create an attribute node after creating a child of the containing element");
                    dynamicError.setErrorCode(this.isXSLT() ? "XTDE0410" : "XQTY0024");
                    dynamicError.setLocator(this);
                    throw dynamicError;
                }
                if (!bl || n2 != 8192) continue;
                DynamicError dynamicError = new DynamicError("Cannot create a namespace node after creating a child of the containing element");
                dynamicError.setErrorCode(this.isXSLT() ? "XTDE0410" : "XQTY0024");
                dynamicError.setLocator(this);
                throw dynamicError;
            }
        }
    }

    public abstract int getNameCode(XPathContext var1) throws XPathException;

    public abstract String getNewBaseURI(XPathContext var1);

    protected abstract void outputNamespaceNodes(XPathContext var1, Receiver var2) throws XPathException;

    public int[] getActiveNamespaces() throws XPathException {
        return null;
    }

    public int getImplementationMethod() {
        return 5;
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        try {
            Controller controller;
            Receiver receiver;
            int n = this.getNameCode(xPathContext);
            int n2 = this.validation == 3 ? 572 : 641;
            XPathContext xPathContext2 = xPathContext;
            SequenceReceiver sequenceReceiver = xPathContext.getReceiver();
            if (this.validating && (receiver = (controller = xPathContext.getController()).getConfiguration().getElementValidator(sequenceReceiver, n, this.locationId, this.getSchemaType(), this.validation)) != sequenceReceiver) {
                xPathContext2 = xPathContext.newMinorContext();
                xPathContext2.setOrigin(this);
                sequenceReceiver = new TreeReceiver(receiver);
                PipelineConfiguration pipelineConfiguration = controller.makePipelineConfiguration();
                pipelineConfiguration.setHostLanguage(this.getHostLanguage());
                sequenceReceiver.setPipelineConfiguration(pipelineConfiguration);
                xPathContext2.setReceiver(sequenceReceiver);
            }
            if (sequenceReceiver.getSystemId() == null) {
                sequenceReceiver.setSystemId(this.getNewBaseURI(xPathContext2));
            }
            int n3 = this.inheritNamespaces ? 0 : 128;
            sequenceReceiver.startElement(n, n2, this.locationId, n3);
            this.outputNamespaceNodes(xPathContext2, sequenceReceiver);
            this.content.process(xPathContext2);
            sequenceReceiver.endElement();
            return null;
        }
        catch (DynamicError dynamicError) {
            if (dynamicError.getXPathContext() == null) {
                dynamicError.setXPathContext(xPathContext);
            }
            if (dynamicError.getLocator() == null) {
                dynamicError.setLocator(this);
            }
            throw dynamicError;
        }
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        if (this.isLazyConstruction()) {
            UnconstructedElement unconstructedElement = new UnconstructedElement(this, xPathContext);
            unconstructedElement.setNameCode(this.getNameCode(xPathContext));
            return unconstructedElement;
        }
        return this.constructElement(xPathContext);
    }

    private NodeInfo constructElement(XPathContext xPathContext) throws XPathException {
        try {
            Object object;
            Controller controller = xPathContext.getController();
            XPathContextMinor xPathContextMinor = xPathContext.newMinorContext();
            xPathContextMinor.setOrigin(this);
            SequenceOutputter sequenceOutputter = controller.allocateSequenceOutputter(1);
            PipelineConfiguration pipelineConfiguration = controller.makePipelineConfiguration();
            pipelineConfiguration.setHostLanguage(this.getHostLanguage());
            sequenceOutputter.setPipelineConfiguration(pipelineConfiguration);
            int n = this.getNameCode(xPathContextMinor);
            int n2 = this.validation == 3 ? 572 : 641;
            SequenceReceiver sequenceReceiver = sequenceOutputter;
            if (this.validating) {
                Receiver receiver = controller.getConfiguration().getElementValidator(sequenceReceiver, n, this.locationId, this.getSchemaType(), this.validation);
                if (sequenceReceiver.getSystemId() == null) {
                    sequenceReceiver.setSystemId(this.getNewBaseURI(xPathContextMinor));
                }
                if (receiver == sequenceReceiver) {
                    xPathContextMinor.setTemporaryReceiver(sequenceReceiver);
                } else {
                    object = new TreeReceiver(receiver);
                    ((SequenceReceiver)object).setPipelineConfiguration(sequenceOutputter.getPipelineConfiguration());
                    xPathContextMinor.setReceiver((SequenceReceiver)object);
                    sequenceReceiver = object;
                }
            } else {
                xPathContextMinor.setTemporaryReceiver(sequenceReceiver);
                if (sequenceReceiver.getSystemId() == null) {
                    sequenceReceiver.setSystemId(this.getNewBaseURI(xPathContextMinor));
                }
            }
            sequenceReceiver.open();
            int n3 = this.inheritNamespaces ? 0 : 128;
            sequenceReceiver.startElement(n, n2, this.locationId, n3);
            this.outputNamespaceNodes(xPathContextMinor, sequenceReceiver);
            this.content.process(xPathContextMinor);
            sequenceReceiver.endElement();
            sequenceReceiver.close();
            object = (NodeInfo)sequenceOutputter.popLastItem();
            sequenceOutputter.reset();
            return object;
        }
        catch (XPathException xPathException) {
            if (xPathException instanceof ValidationException) {
                ((ValidationException)xPathException).setSourceLocator(this);
                ((ValidationException)xPathException).setSystemId(this.getSystemId());
            }
            if (xPathException.getLocator() == null) {
                xPathException.setLocator(this);
            }
            if (xPathException instanceof DynamicError && ((DynamicError)xPathException).getXPathContext() == null) {
                ((DynamicError)xPathException).setXPathContext(xPathContext);
            }
            throw xPathException;
        }
    }
}

