DACS.VFS(5)                   DACS Formats Manual                  DACS.VFS(5)



[1mNAME[0m
       dacs.vfs - the [1mDACS [22mvirtual filestore

[1mDESCRIPTION[0m
       These files are part of the [1mDACS [22msuite.

       The virtual filestore provides flexible ways for [1mDACS [22mand software
       built on top of [1mDACS [22mto obtain information regardless of how or where
       the information is stored. The [1mDACS [22mcore accesses (almost) all
       configuration information through the virtual filestore layer, allowing
       information to be more easily shared and maintained, secured, or
       organized for better performance.

       Sometimes it is easiest to store information in a regular file
       initially, where it can be modified using an ordinary text editor, but
       after some growth a database might improve performance. In some
       situations, accessing the information remotely, via HTTP, makes
       administration more convenient or is more secure. A goal of the virtual
       filestore is to make it simple to make configuration choices
       appropriate to a particular [1mDACS [22menvironment, and to change them as
       required. Consult [34m[1mdacsvfs(1)[0m[1m[22m[1] for additional information.

       For example, the account file used by [34m[1mdacspasswd(1)[0m[1m[22m[2] and other
       components is accessed from within [1mDACS [22mthrough the name passwds (a
       string called an item type). The [1mDACS [22mconfiguration in effect
       determines how this is mapped to an object that contains the account
       information, how an individual account name is looked up, and where the
       object is located.

       Each virtual filestore instance maps to either an uninterpreted
       sequence of bytes (e.g., a Unix file or the output of a program) or an
       object that contains zero or more items, each of which is associated
       with a key (i.e., the name of an item relative in its virtual filestore
       context) and has an uninterpreted sequence of bytes as its value (e.g.,
       a database file, a Unix file containing lines having a particular
       keyword/value structure, or a directory containing regular files).

       The [34m[1mVFS[0m[1m[22m[3] directive is used to specify where and how information is
       stored. Some commands and functions take a VFS specification as an
       argument to provide a default or override a default.

       For maximum portability, a key should be composed of characters from
       the [34m[1mPortable Filename Character Set[0m[1m[22m[4]: any alphanumeric character,
       period, hyphen, or underscore. The true limitation on the character set
       depends on the underlying storage scheme and URI syntax constraints.
       There is no [4ma[24m [4mpriori[24m limit on naming context or key length.

[1mSEE ALSO[0m
       [34m[1mdacsvfs(1)[0m[1m[22m[1], [34m[1mdacs.conf(5)[0m[1m[22m[5], [34m[1mdacs.install(7)[0m[1m[22m[6], [34m[1mdacs_vfs(8)[0m[1m[22m[7]

[1mBUGS[0m
[1mAUTHOR[0m
       Distributed Systems Software ([34m[1mwww.dss.ca[0m[1m[22m[8])

[1mCOPYING[0m
       Copyright (C) 2003-2012 Distributed Systems Software. See the
       [34m[1mLICENSE[0m[1m[22m[9] file that accompanies the distribution for licensing
       information.

[1mNOTES[0m
        1. dacsvfs(1)
           http://dacs.dss.ca/man/dacsvfs.1.html

        2. dacspasswd(1)
           http://dacs.dss.ca/man/dacspasswd.1.html

        3. VFS
           http://dacs.dss.ca/man/dacs.conf.5.html#VFS

        4. Portable Filename Character Set
           http://www.opengroup.org/onlinepubs/009695399/basedefs/xbd_chap03.html#tag_03_276

        5. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html

        6. dacs.install(7)
           http://dacs.dss.ca/man/dacs.install.7.html

        7. dacs_vfs(8)
           http://dacs.dss.ca/man/dacs_vfs.8.html

        8. www.dss.ca
           http://www.dss.ca

        9. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.28b                      03/01/2013                       DACS.VFS(5)
