<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:d="http://docbook.org/ns/docbook" xmlns:exsl="http://exslt.org/common" xmlns:dbs="http://docbook.org/ns/docbook-slides" xmlns:fo="http://www.w3.org/1999/XSL/Format" version="1.0" exclude-result-prefixes="exsl d">

<!-- This stylesheet was created by template/titlepage.xsl-->

<xsl:template name="slides.titlepage.recto">
  <xsl:choose>
    <xsl:when test="d:slidesinfo/d:title">
      <xsl:apply-templates mode="slides.titlepage.recto.auto.mode" select="d:slidesinfo/d:title"/>
    </xsl:when>
    <xsl:when test="d:docinfo/d:title">
      <xsl:apply-templates mode="slides.titlepage.recto.auto.mode" select="d:docinfo/d:title"/>
    </xsl:when>
    <xsl:when test="d:info/d:title">
      <xsl:apply-templates mode="slides.titlepage.recto.auto.mode" select="d:info/d:title"/>
    </xsl:when>
    <xsl:when test="d:title">
      <xsl:apply-templates mode="slides.titlepage.recto.auto.mode" select="d:title"/>
    </xsl:when>
  </xsl:choose>

  <xsl:choose>
    <xsl:when test="d:slidesinfo/d:subtitle">
      <xsl:apply-templates mode="slides.titlepage.recto.auto.mode" select="d:slidesinfo/d:subtitle"/>
    </xsl:when>
    <xsl:when test="d:docinfo/d:subtitle">
      <xsl:apply-templates mode="slides.titlepage.recto.auto.mode" select="d:docinfo/d:subtitle"/>
    </xsl:when>
    <xsl:when test="d:info/d:subtitle">
      <xsl:apply-templates mode="slides.titlepage.recto.auto.mode" select="d:info/d:subtitle"/>
    </xsl:when>
    <xsl:when test="d:subtitle">
      <xsl:apply-templates mode="slides.titlepage.recto.auto.mode" select="d:subtitle"/>
    </xsl:when>
  </xsl:choose>

  <xsl:apply-templates mode="slides.titlepage.recto.auto.mode" select="d:slidesinfo/d:corpauthor"/>
  <xsl:apply-templates mode="slides.titlepage.recto.auto.mode" select="d:docinfo/d:corpauthor"/>
  <xsl:apply-templates mode="slides.titlepage.recto.auto.mode" select="d:info/d:corpauthor"/>
  <xsl:apply-templates mode="slides.titlepage.recto.auto.mode" select="d:slidesinfo/d:authorgroup"/>
  <xsl:apply-templates mode="slides.titlepage.recto.auto.mode" select="d:docinfo/d:authorgroup"/>
  <xsl:apply-templates mode="slides.titlepage.recto.auto.mode" select="d:info/d:authorgroup"/>
  <xsl:apply-templates mode="slides.titlepage.recto.auto.mode" select="d:slidesinfo/d:author"/>
  <xsl:apply-templates mode="slides.titlepage.recto.auto.mode" select="d:docinfo/d:author"/>
  <xsl:apply-templates mode="slides.titlepage.recto.auto.mode" select="d:info/d:author"/>
  <xsl:apply-templates mode="slides.titlepage.recto.auto.mode" select="d:slidesinfo/d:pubdate"/>
  <xsl:apply-templates mode="slides.titlepage.recto.auto.mode" select="d:docinfo/d:pubdate"/>
  <xsl:apply-templates mode="slides.titlepage.recto.auto.mode" select="d:info/d:pubdate"/>
</xsl:template>

<xsl:template name="slides.titlepage.verso">
</xsl:template>

<xsl:template name="slides.titlepage.separator">
</xsl:template>

<xsl:template name="slides.titlepage.before.recto">
</xsl:template>

<xsl:template name="slides.titlepage.before.verso">
</xsl:template>

<xsl:template name="slides.titlepage">
  <fo:block>
    <xsl:variable name="recto.content">
      <xsl:call-template name="slides.titlepage.before.recto"/>
      <xsl:call-template name="slides.titlepage.recto"/>
    </xsl:variable>
    <xsl:variable name="recto.elements.count">
      <xsl:choose>
        <xsl:when test="function-available('exsl:node-set')"><xsl:value-of select="count(exsl:node-set($recto.content)/*)"/></xsl:when>
        <xsl:when test="contains(system-property('xsl:vendor'), 'Apache Software Foundation')">
          <!--Xalan quirk--><xsl:value-of select="count(exsl:node-set($recto.content)/*)"/></xsl:when>
        <xsl:otherwise>1</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:if test="(normalize-space($recto.content) != '') or ($recto.elements.count &gt; 0)">
      <fo:block><xsl:copy-of select="$recto.content"/></fo:block>
    </xsl:if>
    <xsl:variable name="verso.content">
      <xsl:call-template name="slides.titlepage.before.verso"/>
      <xsl:call-template name="slides.titlepage.verso"/>
    </xsl:variable>
    <xsl:variable name="verso.elements.count">
      <xsl:choose>
        <xsl:when test="function-available('exsl:node-set')"><xsl:value-of select="count(exsl:node-set($verso.content)/*)"/></xsl:when>
        <xsl:when test="contains(system-property('xsl:vendor'), 'Apache Software Foundation')">
          <!--Xalan quirk--><xsl:value-of select="count(exsl:node-set($verso.content)/*)"/></xsl:when>
        <xsl:otherwise>1</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:if test="(normalize-space($verso.content) != '') or ($verso.elements.count &gt; 0)">
      <fo:block><xsl:copy-of select="$verso.content"/></fo:block>
    </xsl:if>
    <xsl:call-template name="slides.titlepage.separator"/>
  </fo:block>
</xsl:template>

<xsl:template match="*" mode="slides.titlepage.recto.mode">
  <!-- if an element isn't found in this mode, -->
  <!-- try the generic titlepage.mode -->
  <xsl:apply-templates select="." mode="titlepage.mode"/>
</xsl:template>

<xsl:template match="*" mode="slides.titlepage.verso.mode">
  <!-- if an element isn't found in this mode, -->
  <!-- try the generic titlepage.mode -->
  <xsl:apply-templates select="." mode="titlepage.mode"/>
</xsl:template>

<xsl:template match="d:title" mode="slides.titlepage.recto.auto.mode">
<fo:block xsl:use-attribute-sets="slides.titlepage.title.properties">
<xsl:call-template name="presentation.title">
</xsl:call-template>
</fo:block>
</xsl:template>

<xsl:template match="d:subtitle" mode="slides.titlepage.recto.auto.mode">
<fo:block xsl:use-attribute-sets="slides.titlepage.subtitle.properties">
<xsl:apply-templates select="." mode="slides.titlepage.recto.mode"/>
</fo:block>
</xsl:template>

<xsl:template match="d:corpauthor" mode="slides.titlepage.recto.auto.mode">
<fo:block xsl:use-attribute-sets="slides.titlepage.corpauthor.properties">
<xsl:apply-templates select="." mode="slides.titlepage.recto.mode"/>
</fo:block>
</xsl:template>

<xsl:template match="d:authorgroup" mode="slides.titlepage.recto.auto.mode">
<fo:block xsl:use-attribute-sets="slides.titlepage.authorgroup.properties">
<xsl:apply-templates select="." mode="slides.titlepage.recto.mode"/>
</fo:block>
</xsl:template>

<xsl:template match="d:author" mode="slides.titlepage.recto.auto.mode">
<fo:block xsl:use-attribute-sets="slides.titlepage.author.properties">
<xsl:apply-templates select="." mode="slides.titlepage.recto.mode"/>
</fo:block>
</xsl:template>

<xsl:template match="d:pubdate" mode="slides.titlepage.recto.auto.mode">
<fo:block xsl:use-attribute-sets="slides.titlepage.pubdate.properties">
<xsl:apply-templates select="." mode="slides.titlepage.recto.mode"/>
</fo:block>
</xsl:template>

</xsl:stylesheet>
