/****************************************************************************
** Dooble - The Secure Internet Web Browser
**
** Copyright (c) 2008, 2009 Alexis Megas, 
** Gunther van Dooble, and the Dooble Team. 
** All rights reserved.
**
**
** License: GPL2 only: 
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; version 2 of the License only.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
** or see here: http://www.gnu.org/licenses/gpl.html
**
**
** For the WebKit library, please see: http://webkit.org.
**
** THE CODE IS PROVIDED BY THE AUTHORS ''AS IS'' AND ANY
** EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
** IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
** PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
** ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
** IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
** ARISING IN ANY WAY OUT OF THE USE OF THIS APPLICATION, EVEN IF ADVISED
** OF THE POSSIBILITY OF SUCH DAMAGE.
**
** Please report all praise, requests, bugs, and problems to the project
** team and administrators: http://sf.net/projects/dooble.
**
** You can find us listed at our project page. New team members are welcome.
** The name of the authors should not be used to endorse or promote products
** derived from Dooble without specific prior written permission.
** If you use this code for other projects, please let us know.
**
** Web sites:
**   http://dooble.net/projects/dooble
**   http://dooble.sf.net
**   http://www.getadooble.com
****************************************************************************/


#ifndef _dooble_h_
#define _dooble_h_

#include <QCloseEvent>

#include "dview.h"
#include "ui_statusBar.h"
#include "ui_mainWindow.h"
#include "downloadwindow.h"

class dooble: public QMainWindow
{
  Q_OBJECT

 public:
  static const int MAX_NUMBER_OF_TAB_TITLE_CHARACTERS = 25;
  static const int MAX_NUMBER_OF_MENU_TITLE_CHARACTERS = 50;
  dooble(QList<QAction *> actionsList);
  dooble(QList<QAction *> actionsList, const QUrl &url);
  dooble(QList<QAction *> actionsList, dview *p, const QString &tabTitle);
  ~dooble();
  void copyLink(const QUrl &url);
  void closeTab(const int index);
  void closeEvent(QCloseEvent *event);

 private:
  QWidget *sbWidget;
  Ui_statusBar sb;
  Ui_mainWindow ui;
  dview *newTab(const QUrl &url);
  dview *newTab(dview *p, const QString &tabTitle);
  void init(QList<QAction *> actionsList);
  void saveUrl(const QUrl &url);
  void loadPage(const QUrl &url);
  void newTabInit(dview *p, const QString &tabTitle);
  void closeDesktop(void);
  void saveSettings(void);
  void keyPressEvent(QKeyEvent *event);
  void prepareNavigationButtonMenus(dview *p);
  QString dest_url_;

 private slots:
  void slotBack(void);
  void slotFind(void);
  void slotFind(const QString &text);
  void slotQuit(void);
  void slotStop(void);
  void slotAbout(void);
  void slotClose(void);
  void slotPrint(void);
  void slotGoHome(void);
  void slotNewTab(void);
  void slotReload(void);
  void slotSearch(void);
  void slotForward(void);
  void slotOpenUrl(void);
  void slotSaveUrl(const QUrl &url);
  void slotCloseTab(void);
  void slotCloseTab(const int index);
  void slotCopyLink(const QUrl &url);
  void slotHideFind(void);
  void slotLoadPage(bool);
  void slotLoadPage(void);
  void slotLoadPage(const QUrl &url);
  void slotLoadPage(QAction *action);
  void slotSavePage(void);
  void slotSetIcons(void);
  void slotShowFind(void);
  void slotNewWindow(void);
  void slotUrlChanged(const QUrl &url);
  void slotLinkHovered(const QString &link, const QString &title,
		       const QString &textContent);
  void slotLoadStarted(void);
  void slotTabSelected(const int index);
  void slotTextChanged(const QString &text);
  void slotClearHistory(bool checked);
  void slotLoadFinished(bool ok);
  void slotLoadProgress(int progress);
  void slotPrintPreview(void);
  void slotTitleChanged(const QString &title);
  void slotShowDesktopTab(void);
  void slotShowPageSource(void);
  void slotOpenLinkInNewTab(const QUrl &url);
  void slotStatusBarDisplay(void);
  void slotShowSettingsWindow(void);
  void slotUnsupportedContent(QNetworkReply *reply);
  void slotOpenLinkInNewWindow(const QUrl &url);
  void slotOpenPageInNewWindow(const int index);
  void slotDisplayDownloadWindow(void);
  void slotHistoryActionTriggered(bool checked);

#if QT_VERSION >= 0x040500
  void slotViewZoomIn(void);
  void slotViewZoomOut(void);
  void slotViewResetZoom(void);
  void slotViewZoomTextOnly(bool enable);
#endif

  friend class dwebpage;

 signals:
  void clearHistorySignal(void);
  void iconsChangedSignal(void);
};

#endif
