#!/usr/bin/env python3

import re
import codecs
from dput import __appname__
from setuptools import setup

def make_pep440_compliant(version: str) -> str:
    """Convert the version into a PEP440 compliant version."""
    public_version_re = re.compile(
        r"^([0-9][0-9.]*(?:(?:a|b|rc|.post|.dev)[0-9]+)*)\+?"
    )
    _, public, local = public_version_re.split(version, maxsplit=1)
    if not local:
        return version
    sanitized_local = re.sub("[+~]+", ".", local).strip(".")
    pep440_version = f"{public}+{sanitized_local}"
    assert re.match(
        "^[a-zA-Z0-9.]+$", sanitized_local
    ), f"'{pep440_version}' not PEP440 compliant"
    return pep440_version

with open('README.md') as f:
    long_description = f.read()
cur = codecs.open('debian/changelog', 'r', encoding='utf-8').readline().strip()
pobj = re.findall(
    r'(?P<src>.*) \((?P<version>.*)\) (?P<suite>.*); .*',
    cur
)[0]
src, version, suite = pobj
# Yes, I'm sorry, world. I'm sorry.

version = make_pep440_compliant(version)

setup(
    name=__appname__,
    version=version,
    packages=[
        'dput',
        'dput.hooks',
        'dput.configs',
        'dput.commands',
        'dput.commands.contrib',
        'dput.uploaders',
        'dput.interfaces',
    ],
    author="dput authors",
    author_email="dput-ng@packages.debian.org",
    long_description=long_description,
    description='dput-ng -- like dput, but better',
    license="GPL-2+",
    url="",
    platforms=['any']
)
