include /usr/share/dpkg/pkg-info.mk

DUNE_CTEST ?= /usr/bin/dune-ctest

DUNE_DEBIAN_CMAKE_FLAGS = -DBUILD_SHARED_LIBS=1

DUNE_DEBIAN_SHLIB = $(subst ~,.,lib$(DEB_SOURCE)-$(DEB_VERSION_UPSTREAM))

override_dh_auto_configure:
	dh_auto_configure -- $(DUNE_DEBIAN_CMAKE_FLAGS)

# OpenMPI looks for a rsh program, even when it only starts local processes.
export OMPI_MCA_plm_rsh_agent=/bin/false

# Don't limit number of MPI ranks to number of cores (when running tests),
# see https://bugs.debian.org/850229
export OMPI_MCA_rmaps_base_oversubscribe=1

override_dh_auto_test:
	dh_auto_build -- build_tests
	cd build; PATH=$(CURDIR)/debian/tmp-test:$$PATH $(DUNE_CTEST)

override_dh_gencontrol:
	dh_gencontrol -- -Vdune:shared-library='$(DUNE_DEBIAN_SHLIB)'

override_dh_makeshlibs:
	dh_makeshlibs --version-info='$(DUNE_DEBIAN_SHLIB)'
