// -*- tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*-
// vi: set et ts=4 sw=2 sts=2:
//
// WARNING
// This file is automatically generated by gausslobatto.mac! Don't edit by hand!

#ifndef DUNE_INCLUDING_IMPLEMENTATION
#error This is a private header that should not be included directly.
#error Use #include <dune/geometry/quadraturerules.hh> instead.
#endif
#undef DUNE_INCLUDING_IMPLEMENTATION

namespace Dune {

  // for fundamental types
  template<typename ct>
  void GaussLobattoQuadratureInitHelper<ct,true>::init(int p,
         std::vector< FieldVector<ct, 1> > & _points,
         std::vector< ct > & _weight,
         int & delivered_order)
  {
    switch(p)
    {
    // order 0,1
    case 0 :
    case 1 :
      delivered_order = 1;
      _points.resize(2);
      _weight.resize(2);
      _points[0] = 0.0;
      _weight[0] = 0.5;
      _points[1] = 1.0;
      _weight[1] = 0.5;
      break;

    // order 2,3
    case 2 :
    case 3 :
      delivered_order = 3;
      _points.resize(3);
      _weight.resize(3);
      _points[0] = 0.0;
      _weight[0] = 0.1666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666;
      _points[1] = 1.0;
      _weight[1] = 0.1666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666;
      _points[2] = 0.5;
      _weight[2] = 0.6666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666;
      break;

    // order 4,5
    case 4 :
    case 5 :
      delivered_order = 5;
      _points.resize(4);
      _weight.resize(4);
      _points[0] = 0.0;
      _weight[0] = 0.08333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333;
      _points[1] = 1.0;
      _weight[1] = 0.08333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333;
      _points[2] = 0.7236067977499789696409173668731276235440618359611525724270897245410520925637804899414414408378782274;
      _weight[2] = 0.4166666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666;
      _points[3] = 0.2763932022500210303590826331268723764559381640388474275729102754589479074362195100585585591621217725;
      _weight[3] = 0.4166666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666;
      break;

    // order 6,7
    case 6 :
    case 7 :
      delivered_order = 7;
      _points.resize(5);
      _weight.resize(5);
      _points[0] = 0.0;
      _weight[0] = 0.05;
      _points[1] = 1.0;
      _weight[1] = 0.05;
      _points[2] = 0.8273268353539885718991462281234291777846040411977122787576601517076334589676979204717401113923889309;
      _weight[2] = 0.2722222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222;
      _points[3] = 0.172673164646011428100853771876570822215395958802287721242339848292366541032302079528259888607611069;
      _weight[3] = 0.2722222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222;
      _points[4] = 0.5;
      _weight[4] = 0.3555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555;
      break;

    // order 8,9
    case 8 :
    case 9 :
      delivered_order = 9;
      _points.resize(6);
      _weight.resize(6);
      _points[0] = 1.0;
      _weight[0] = 0.03333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333;
      _points[1] = 0.0;
      _weight[1] = 0.03333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333;
      _points[2] = 0.1174723380352676535744985130203309248171321557319478803362088220814723414805867429382513646351330634;
      _weight[2] = 0.1892374781489234232284036242057490907893514186964376616666256074476596593400013181062101736711021799;
      _points[3] = 0.8825276619647323464255014869796690751828678442680521196637911779185276585194132570617486353648669365;
      _weight[3] = 0.1892374781489234232284036242057490907893514186964376616666256074476596593400013181062101736711021799;
      _points[4] = 0.6426157582403225481570754970204395359595017363632126959098752082638489654570997990908378640025315086;
      _weight[4] = 0.2774291885177430282418638795784291955151657623014470227339178631890479528065466824200205653368404297;
      _points[5] = 0.3573842417596774518429245029795604640404982636367873040901247917361510345429002009091621359974684913;
      _weight[5] = 0.2774291885177430282418638795784291955151657623014470227339178631890479528065466824200205653368404297;
      break;

    // order 10,11
    case 10 :
    case 11 :
      delivered_order = 11;
      _points.resize(7);
      _weight.resize(7);
      _points[0] = 0.0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002904443936136988704613522974964763885677664394036593149115822206008312261073264473647011675707760947;
      _weight[0] = 0.0238095238095238095238095238095238095238095238095238095238095238095238095238095238095238095238095238;
      _points[1] = 1.0;
      _weight[1] = 0.0238095238095238095238095238095238095238095238095238095238095238095238095238095238095238095238095238;
      _points[2] = 0.08488805186071653506398389301626743020641481756400195420459339398355773991365476236892514937696012313;
      _weight[2] = 0.1384130236807829131218398865437551831905777354633772635053884911031405721309519182560026241400322403;
      _points[3] = 0.9151119481392834649360161069837325697935851824359980457954066060164422600863452376310748506230398768;
      _weight[3] = 0.1384130236807829131218398865437551831905777354633772635053884911031405721309519182560026241400322403;
      _points[4] = 0.7344243967353571069018859409543831647027987358359223785513347296814777650585638543983611678787947876;
      _weight[4] = 0.2158726906049312417948738610998339197914196923935309869032368559369673797042108420764826997039883878;
      _points[5] = 0.2655756032646428930981140590456168352972012641640776214486652703185222349414361456016388321212052123;
      _weight[5] = 0.2158726906049312417948738610998339197914196923935309869032368559369673797042108420764826997039883878;
      _points[6] = 0.5;
      _weight[6] = 0.2438095238095238095238095238095238095238095238095238095238095238095238095238095238095238095238095238;
      break;

    // order 12,13
    case 12 :
    case 13 :
      delivered_order = 13;
      _points.resize(8);
      _weight.resize(8);
      _points[0] = 1.0;
      _weight[0] = 0.01785714285714285714285714285714285714285714285714285714285714285714285714285714285714285714285714285;
      _points[1] = 0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001549036765939727309127212253314540739028087676819516346195105176537766539239074385945072893710805838;
      _weight[1] = 0.01785714285714285714285714285714285714285714285714285714285714285714285714285714285714285714285714285;
      _points[2] = 0.9358700742548033076687228806103317190518903348384916774597076427869494970464842703630747633289511529;
      _weight[2] = 0.1053521135717531457639492254179672657149286651899994025892058675171367569238415491958627052447628671;
      _points[3] = 0.06412992574519669233127711938966828094810966516150832254029235721305050295351572963692523667104884704;
      _weight[3] = 0.1053521135717531457639492254179672657149286651899994025892058675171367569238415491958627052447628671;
      _points[4] = 0.2041499092834288489277446343010234050271495052413337516288702042649259099754335560686927101889881905;
      _weight[4] = 0.1705613462417519709738997111619593972203589637193408611485199043949945226147230572395682263445081994;
      _points[5] = 0.7958500907165711510722553656989765949728504947586662483711297957350740900245664439313072898110118094;
      _weight[5] = 0.1705613462417519709738997111619593972203589637193408611485199043949945226147230572395682263445081994;
      _points[6] = 0.395350391048760565615671369827324372352227297456659450554576653838934538176858502305738892317405195;
      _weight[6] = 0.2062293973293512499410663914158269430521945689751541836635147440769128811521868890734569253884206652;
      _points[7] = 0.6046496089512394343843286301726756276477727025433405494454233461610654618231414976942611076825948049;
      _weight[7] = 0.206229397329352290058663329175500307978970438228117708299717557326882845922119905543761777214046086;
      break;

    // order 14,15
    case 14 :
    case 15 :
      delivered_order = 15;
      _points.resize(9);
      _weight.resize(9);
      _points[0] = 1.0;
      _weight[0] = 0.01388888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888;
      _points[1] = 0.0;
      _weight[1] = 0.01388888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888;
      _points[2] = 0.0501210022942699213438273777908310209742598522169477887853436657575933627168406408544934398437526016;
      _weight[2] = 0.08274768078040277307375110531620151299110161681408257666001582629645006868924950402598198636482761858;
      _points[3] = 0.9498789977057300786561726222091689790257401477830522112146563342424066372831593591455065601562473983;
      _weight[3] = 0.08274768078040299448083313098402094403540223161400542189096055703361081411625039308473630041998890322;
      _points[4] = 0.1614068602446311232770572864543287746444851761930467102295183122514507360076748631095880608419781472;
      _weight[4] = 0.1372693562500809593124338701941148015065349646047663411511034276171563187785350916655638663434730627;
      _points[5] = 0.8385931397553688767229427135456712253555148238069532897704816877485492639923251368904119391580218527;
      _weight[5] = 0.1372693562500809593124338701941148015065349646047663411511034276171563187785350916655638663434730627;
      _points[6] = 0.681558731913089079355376034354329606510321138800439075160136865385805213816899479027566535923708144;
      _weight[6] = 0.1732142554865231869322860992053680838463565217024682188451171609646738454988173685693963668198179665;
      _points[7] = 0.3184412680869109206446239656456703934896788611995609248398631346141947861831005209724334640762918559;
      _weight[7] = 0.1732142554865231869322860992053680838463565217024682188451171609646738454988173685693963668198179665;
      _points[8] = 0.5;
      _weight[8] = 0.1857596371882086167800453514739229024943310657596371882086167800453514739229024943310657596371882086;
      break;

    // order 16,17
    case 16 :
    case 17 :
      delivered_order = 17;
      _points.resize(10);
      _weight.resize(10);
      _points[0] = 0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999;
      _weight[0] = 0.01111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
      _points[1] = 0.0;
      _weight[1] = 0.01111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
      _points[2] = 0.04023304591677059308553366958883093292322846227686206425518692770786627926104335933756011688795994553;
      _weight[2] = 0.06665299542553486307563078419385037524164195656474633503676859357600184466551650296921943773532930684;
      _points[3] = 0.9597669540832294069144663304111690670767715377231379357448130722921337207389566406624398831120400544;
      _weight[3] = 0.0666529954255350876256462019178923055849817749288126634748625480504711123271781571100362680090635451;
      _points[4] = 0.8693869325527525375015530874299153625080925506884633427325544965275766578699549008371448931272867576;
      _weight[4] = 0.112444671031563139838202048484435502843446956618904920749437576846203760250428610476443523218425496;
      _points[5] = 0.1306130674472474624984469125700846374919074493115366572674455034724233421300450991628551068727132423;
      _weight[5] = 0.1124446710315632557865964406843838642729673511142965495154088031617257004011641459726513834468349851;
      _points[6] = 0.2610375250947777521694124536343710010566135533347167655428715801541887244557614303116642045509084166;
      _weight[6] = 0.1460213418398417036209800331044298629666660225306298392345715865267261875420489975656340541631828428;
      _points[7] = 0.7389624749052222478305875463656289989433864466652832344571284198458112755442385696883357954490915833;
      _weight[7] = 0.1460213418398417036209800331044298629666660225306298392345715865267261875420489975656340541631828428;
      _points[8] = 0.5826394788331935123131098829790867666155751717747418655664497860523941482272025775233841371104750817;
      _weight[8] = 0.163769880591948734348597024651334428580472884726067686608365083124607813252839493579199611488019423;
      _points[9] = 0.4173605211668064876868901170209132333844248282252581344335502139476058517727974224766158628895249182;
      _weight[9] = 0.163769880591948734348597024651334428580472884726067686608365083124607813252839493579199611488019423;
      break;

    // order 18,19
    case 18 :
    case 19 :
      delivered_order = 19;
      _points.resize(11);
      _weight.resize(11);
      _points[0] = 1.0;
      _weight[0] = 0.00909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909;
      _points[1] = 0.0;
      _weight[1] = 0.00909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909;
      _points[2] = 0.03299928479597043283386293195030818273004133494501888705418662336432199124519182900837678308430293929;
      _weight[2] = 0.05480613663349747180131790064486021210029815861780431434085487755057522026619613620315494546320940628;
      _points[3] = 0.9670007152040295671661370680496918172699586650549811129458133766356780087548081709916232169156970607;
      _weight[3] = 0.05480613663349747180131790064486021210029815861780431434085487755057522026619613620315494546320940628;
      _points[4] = 0.892241736831572209311208908054229051753598727547031810841317670384292356072438301406275095976056209;
      _weight[4] = 0.09358494089015252696327174240117207855218318192550176212624049743234428734352148131097006547408770523;
      _points[5] = 0.1077582631684277906887910919457709482464012724529681891586823296157076439275616985937249040239437909;
      _weight[5] = 0.09358494089015273771626140833075693899437949665748224552868178075846784376744728583934397639003552592;
      _points[6] = 0.2173823365018974967645180152611241678584739272189915121544213759600612059255784548809189629767876991;
      _weight[6] = 0.1240240521320142891804383293899665806242608294678538621504361485460838477153266390282580452167026476;
      _points[7] = 0.7826176634981025032354819847388758321415260727810084878455786240399387940744215451190810370232123008;
      _weight[7] = 0.1240240521320142891804383293899665806242608294678538621504361485460838477153266390282580452167026476;
      _points[8] = 0.6478790677934696957159557577795287544705032171743020547339496869008099808882276395132179974605411626;
      _weight[8] = 0.1434395623895041888327723915044603555734785596509798429577098328117542773990115034803028594956977203;
      _points[9] = 0.3521209322065303042840442422204712455294967828256979452660503130991900191117723604867820025394588373;
      _weight[9] = 0.1434395623895041888327723915044603555734785596509798429577098328117542773990115034803028594956977203;
      _points[10] = 0.5;
      _weight[10] = 0.150108797727845346892965940584988204035823083442131061178680226299273918321537369156416775464394512;
      break;

    // order 20,21
    case 20 :
    case 21 :
      delivered_order = 21;
      _points.resize(12);
      _weight.resize(12);
      _points[0] = 0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001781392280830686405496294091311721849882300828342443798124370953018431520124935543836833827767426714;
      _weight[0] = 0.007575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575;
      _points[1] = 0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999;
      _weight[1] = 0.007575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575;
      _points[2] = 0.02755036388855888829620993084839064319437172402498633814305405146172603859028701369634772815688410958;
      _weight[2] = 0.04584225870659798715036925589564285604170047429796152073151861841009423965716600639739150395416708617;
      _points[3] = 0.9724496361114411117037900691516093568056282759750136618569459485382739614097129863036522718431158904;
      _weight[3] = 0.04584225870659800440346685904355316020528159352455033803492081370360040588262094430946338464327254694;
      _points[4] = 0.9096396608220033391743207908584513303452333289518221447116583630584383637955809711802462446795835436;
      _weight[4] = 0.07898735278218495200388303300215442025826577292611090576303298520123454982016201877028466329583963642;
      _points[5] = 0.09036033917799666082567920914154866965476667104817785528834163694156163620441902881975375532041645631;
      _weight[5] = 0.0789873527821851186180752898779220719303782093539899033577745626868502710304103192219598833696683329;
      _points[6] = 0.8164380765159303388312024272218279291219218727007504964825767823235261210022296852225740227244886444;
      _weight[6] = 0.1062542088805105716744093009787904717056408463699116702735805868768086945124594787342787723965605353;
      _points[7] = 0.1835619234840696611687975727781720708780781272992495035174232176764738789977703147774259772755113555;
      _weight[7] = 0.1062542088805105716744093009787904717056408463699116702735805868768086945124594787342787723965605353;
      _points[8] = 0.3002345295173255338678251042165165497361259836023464817560311639749518780463076119023391127095642402;
      _weight[8] = 0.1256378015996005165827376850755831139070011511966554376121170978329472714657423785638682272588676999;
      _points[9] = 0.6997654704826744661321748957834834502638740163976535182439688360250481219536923880976608872904357597;
      _weight[9] = 0.1256378015996005165827376850755831139070011511966554376121170978329472714657423785638682272588676999;
      _points[10] = 0.5682764664274637774320309278698469484492070556410291927257907830335263719510014649425107069687302462;
      _weight[10] = 0.1357026204553480906096889911764786402158746729620987369287502247173580356645839055831198708548202671;
      _points[11] = 0.4317235335725362225679690721301530515507929443589708072742092169664736280489985350574892930312697537;
      _weight[11] = 0.1357026204553480906096889911764786402158746729620987369287502247173580356645839055831198708548202671;
      break;

    // order 22,23
    case 22 :
    case 23 :
      delivered_order = 23;
      _points.resize(13);
      _weight.resize(13);
      _points[0] = 0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999;
      _weight[0] = 0.00641025641025641025641025641025641025641025641025641025641025641025641025641025641025641025641025641;
      _points[1] = 0.0;
      _weight[1] = 0.00641025641025641025641025641025641025641025641025641025641025641025641025641025641025641025641025641;
      _points[2] = 0.976654923321081955948452732377724575813253944348681592594686301425449791149365608726532254019633679;
      _weight[2] = 0.03890084337340951352241815224962494681077413819473638123548816575330444020962125016612379081158827671;
      _points[3] = 0.02334507667891804405154726762227542418674605565131840740531369857455020885063439127346774598036632099;
      _weight[3] = 0.03890084337340958827601245635130368047541246960728107078202562012408954852923196046113675883133340303;
      _points[4] = 0.07682621767406384156703719645062332021098167014279568715567649366694671496870686996706125852843088673;
      _weight[4] = 0.06749096334480406838932902883081278821819444630474906104405659574885031897065583141011906071888851221;
      _points[5] = 0.9231737823259361584329628035493766797890183298572043128443235063330532850312931300329387414715691132;
      _weight[5] = 0.06749096334480413889962929617064163476963845740219567032780352580688423373246502389108955519941753406;
      _points[6] = 0.1569057654591212869636204802168222235354119009378077864686543270522656709999405253802533533853237888;
      _weight[6] = 0.09182343260177488792767534215391263627423219394617012098311944957839368766343343432165329667315733756;
      _points[7] = 0.8430942345408787130363795197831777764645880990621922135313456729477343290000594746197466466146762111;
      _weight[7] = 0.09182343260177528389330746184235496439693092275287745425247374194410753288715329773930435313147982784;
      _points[8] = 0.2585450894543318991265313831815331896139033689407049947611379539755934104463513064527766100872116534;
      _weight[8] = 0.110383896783055056246621494118085971542659810255041303886069760014526608615072150467986514378309256;
      _points[9] = 0.7414549105456681008734686168184668103860966310592950052388620460244065895536486935472233899127883465;
      _weight[9] = 0.1103838967830551045620897232012161458144565663253055673568641263262421083935999484922047328534838929;
      _points[10] = 0.6246434650531199962843368501871134907444056562464879296492579543168629813997495722095567115050590931;
      _weight[10] = 0.1220078951533380694135091140203570882018292390060569030446137943731266281663298099310619861671980622;
      _points[11] = 0.3753565349468800037156631498128865092555943437535120703507420456831370186002504277904432884949409068;
      _weight[11] = 0.1220078951533380694135091140203570882018292390060569030446137943731266281663298099310619861671980622;
      _points[12] = 0.5;
      _weight[12] = 0.1259654246667233680220693207706194719181732168745155758142771129784116797103810090823077836064849051;
      break;

    // order 24,25
    case 24 :
    case 25 :
      delivered_order = 25;
      _points.resize(14);
      _weight.resize(14);
      _points[0] = 1.0;
      _weight[0] = 0.005494505494505494505494505494505494505494505494505494505494505494505494505494505494505494505494505494;
      _points[1] = 0.0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005808887872273977409227045949929527771355328788073186298231644412016624522146528947294023351415521895;
      _weight[1] = 0.005494505494505494505494505494505494505494505494505494505494505494505494505494505494505494505494505494;
      _points[2] = 0.02003247736636954932244991899228780546680424071367603181792088307398665120252422248009577136781701629;
      _weight[2] = 0.03341864224884065217061354728917174278902212629139089722371383266283797624548671670279582881834208524;
      _points[3] = 0.9799675226336304506775500810077121945331957592863239681820791169260133487974757775199042286321829837;
      _weight[3] = 0.03341864224884065217061354728917174278902212629139089722371383266283797624548671670279582881834208524;
      _points[4] = 0.9339005269151736255001101014541321066249361765472180673794130920541252668245245267203554324860697834;
      _weight[4] = 0.05829332794935571210271662888017431543229876919401686092600394050583016885163116922076726270883171305;
      _points[5] = 0.06609947308482637449988989854586789337506382345278193262058690794587473317547547327964456751393021655;
      _weight[5] = 0.05829332794935579360619760354616444941160248221320965046128703070188777304751333641065014872547972147;
      _points[6] = 0.1355657004543369297076637997395592021713302341528390986938780173861806180949423040135067458535801027;
      _weight[6] = 0.08001092588147612699855887615065849281923484038077205182492425701464771387231180735243810330300693959;
      _points[7] = 0.8644342995456630702923362002604407978286697658471609013061219826138193819050576959864932541464198972;
      _weight[7] = 0.08001092588147612699855887615065849281923484038077205182492425701464771387231180735243810330300693959;
      _points[8] = 0.7753197014643235276583113529295403172310691597769570669118964569840194786616101591806838309484212402;
      _weight[8] = 0.09741307468670808344801049010650000522379523141023358240396111161380728370363602934063314340453378684;
      _points[9] = 0.2246802985356764723416886470704596827689308402230429330881035430159805213383898408193161690515787597;
      _weight[9] = 0.09741307468670808344801049010650000522379523141023358240396111161380728370363602934063314340453378684;
      _points[10] = 0.3286379933286435774780482981791626775834432329298466267225425835645065531681161297198297276026186597;
      _weight[10] = 0.1095631265048852318156387560975273959852529670907608877986845521431840985717081685110602384512818439;
      _points[11] = 0.6713620066713564225219517018208373224165567670701533732774574164354934468318838702801702723973813402;
      _weight[11] = 0.1095631265048854938052036604530717246636213171726383190876371756244984197097901689822018187203160027;
      _points[12] = 0.4418340655581480661706116451319199160292454778718596158983375697060141886686100702311406674611777446;
      _weight[12] = 0.1158063972342284700226103441401948464902902135539666609185863177651613242876539379250513692524248257;
      _points[13] = 0.5581659344418519338293883548680800839707545221281403841016624302939858113313899297688593325388222553;
      _weight[13] = 0.1158063972342285397083030502863276232762209597422663360982907980606878842338318503509714229153436604;
      break;

    // order 26,27
    case 26 :
    case 27 :
      delivered_order = 27;
      _points.resize(15);
      _weight.resize(15);
      _points[0] = 0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999;
      _weight[0] = 0.004761904761904761904761904761904761904761904761904761904761904761904761904761904761904761904761904761;
      _points[1] = 0.0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001776551540937124757655271553020113910072838054352382809542511249341750999689813436380755474974580446;
      _weight[1] = 0.004761904761904761904761904761904761904761904761904761904761904761904761904761904761904761904761904761;
      _points[2] = 0.9826229632519192863979256960348005888538250679985466700362492292135561186010360176002647647677775953;
      _weight[2] = 0.02901494651430062756621020915804012753889874672455136580035112501061369195534504408694618242582509908;
      _points[3] = 0.01737703674808071360207430396519941114617493200145332996375077078644388139896398239973523523222240469;
      _weight[3] = 0.02901494651430062756621020915804012753889874672455136580035112501061369195534504408694618242582509908;
      _points[4] = 0.05745897788851185058729918425888517400564295739626101359130918465945600252159841114408283401864691438;
      _weight[4] = 0.05083003516285878338803942630302165725168794138894212677814386905351545744325033588832115298736238919;
      _points[5] = 0.9425410221114881494127008157411148259943570426037389864086908153405439974784015888559171659813530856;
      _weight[5] = 0.05083003516285899330827821352748378690108686993446504683879406493951605815149878395862946911174315326;
      _points[6] = 0.118240155024092399647940762011854190911315739842354831622647197476461454480323624696818048989422683;
      _weight[6] = 0.07025584990121407338933749964280231716628931085103427835102929419731533544351325685204838749336276863;
      _points[7] = 0.8817598449759076003520592379881458090886842601576451683773528025235385455196763753031819510105773169;
      _weight[7] = 0.07025584990121407338933749964280231716628931085103427835102929419731533544351325685204838749336276863;
      _points[8] = 0.1968733972650771444382350306816332464101344831200401071570852480104016101447308179570244003079193093;
      _weight[8] = 0.08639482362680036401606076625455722556519712728535659599275114991384778388925459506585146451274262273;
      _points[9] = 0.8031266027349228555617649693183667535898655168799598928429147519895983898552691820429755996920806906;
      _weight[9] = 0.08639482362680062998622671825835568869702664765410094182168518362444715482799754020955470023746019139;
      _points[10] = 0.7103190273568362404609484693692902064921691027462151841925466804687845341292931576115237553308309106;
      _weight[10] = 0.09849361798230646863702106300593697382510285092920888688095284104258975741179661694544935058484678254;
      _points[11] = 0.2896809726431637595390515306307097935078308972537848158074533195312154658707068423884762446691690893;
      _weight[11] = 0.09849361798230673878605433006448159592348868526692761846331165137267792942173170662632461201451372639;
      _points[12] = 0.6076769776818971191128397231364588563260789506015205317372525738208551778333542221797656769767607932;
      _weight[12] = 0.1059867929634106089765228761759381798732911730748818676865148423030660515596094954274641983031741433;
      _points[13] = 0.3923230223181028808871602768635411436739210493984794682627474261791448221666457778202343230232392067;
      _weight[13] = 0.1059867929634106089765228761759381798732911730748818676865148423030660515596094954274641983031741433;
      _points[14] = 0.5;
      _weight[14] = 0.1085240581744078247574751071254567758064261560765057268553772050275546779043282539786036289532793029;
      break;

    // order 28,29
    case 28 :
    case 29 :
      delivered_order = 29;
      _points.resize(16);
      _weight.resize(16);
      _points[0] = 0.0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001717494514235672653994796585862497044397392211673638748843822864486248650381323725416599570901855973;
      _weight[0] = 0.004166666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666;
      _points[1] = 1.0;
      _weight[1] = 0.004166666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666;
      _points[2] = 0.9847840231351089664761213691837296206944953732519173650343393661412705259269883781602191879541709236;
      _weight[2] = 0.0254251805029600001309399960630984095079177571685866744976519164487631070262712662765718326148449947;
      _points[3] = 0.0152159768648910335238786308162703793055046267480826349656606338587294740730116218397808120458290763;
      _weight[3] = 0.0254251805029600001309399960630984095079177571685866744976519164487631070262712662765718326148449947;
      _points[4] = 0.05039973345326395350268586924007526162500119547742778728778629410576180140857154234663004161524265869;
      _weight[4] = 0.04469684866296540360807512395212181743763849069106172851842802759230782156701519482136464005494460301;
      _points[5] = 0.9496002665467360464973141307599247383749988045225722127122137058942381985914284576533699583847573413;
      _weight[5] = 0.04469684866296540360807512395212181743763849069106172851842802759230782156701519482136464005494460301;
      _points[6] = 0.1039958540690924680344558645184271470959630860099004886577946750670018549860024997788167097104336213;
      _weight[6] = 0.06212769106625700090745135751571169925765012779766252234075191002994688829391255260828613367456086166;
      _points[7] = 0.8960041459309075319655441354815728529040369139900995113422053249329981450139975002211832902895663786;
      _weight[7] = 0.06212769106625713680999500056864677179206724428416510521932624364081498865545853252074214270875472272;
      _points[8] = 0.8261943514412465447339416098202907401607790064147871686928906421111185215402141672897334327391086998;
      _weight[8] = 0.07701349040358195341145453566040361269680954371316890783810954300473408230488869486388761496861299555;
      _points[9] = 0.1738056485587534552660583901797092598392209935852128313071093578888814784597858327102665672608913001;
      _weight[9] = 0.07701349040358215871376149544072559912165775818315250344225198835223859484704541379040276381827425959;
      _points[10] = 0.7430297109435688058909453929234373484444886521491262856883284338033922487167612097283758109612034;
      _weight[10] = 0.08874595669585221520933868691235856081930807191018199541200416779573042660639649880097344522469846959;
      _points[11] = 0.2569702890564311941090546070765626515555113478508737143116715661966077512832387902716241890387965999;
      _weight[11] = 0.08874595669585221520933868691235856081930807191018199541200416779573042660639649880097344522469846959;
      _points[12] = 0.3500847655496183959508232726388496760922695115461111676728449511779795615144536050173294511021111004;
      _weight[12] = 0.09684501191260187752750797980922898202299380259227232810235530312185806551162011408119432317334702951;
      _points[13] = 0.6499152344503816040491767273611503239077304884538888323271550488220204384855463949826705488978888995;
      _weight[13] = 0.09684501191260187752750797980922898202299380259227232810235530312185806551162011408119432317334702951;
      _points[14] = 0.4493368632390252760784834974770411187333795427999044300412248998728460413102109205056194162045666875;
      _weight[14] = 0.1009791540891148356147629230961218152573684409527987001771404500634876059376754607311450331000040295;
      _points[15] = 0.5506631367609747239215165025229588812666204572000955699587751001271539586897890794943805837954333124;
      _weight[15] = 0.1009791540891151004983612731230700862720831623456811382569592001800226682876474162857257849626219047;
      break;

    // order 30,31
    case 30 :
    case 31 :
      delivered_order = 31;
      _points.resize(17);
      _weight.resize(17);
      _points[0] = 1.0;
      _weight[0] = 0.003676470588235294117647058823529411764705882352941176470588235294117647058823529411764705882352941176;
      _points[1] = 0.0;
      _weight[1] = 0.003676470588235294117647058823529411764705882352941176470588235294117647058823529411764705882352941176;
      _points[2] = 0.9865660883157091570784897509368607152944795745612547432232459215480390687332058160630984405164903217;
      _weight[2] = 0.02246097027162712220178874277948353879341752283391191053478448918418274884000451898542092410577902027;
      _points[3] = 0.01343391168429084292151024906313928470552042543874525677675407845196093126679418393690155948350967826;
      _weight[3] = 0.02246097027162712220178874277948353879341752283391191053478448918418274884000451898542092410577902027;
      _points[4] = 0.04456000204221320218809874680113676623456027406563361783909372034451666996366541838091452314925205037;
      _weight[4] = 0.03959913525184347758052285572370103043491489833360928035519321099199068708437537909786266847751137145;
      _points[5] = 0.9554399979577867978119012531988632337654397259343663821609062796554833300363345816190854768507479496;
      _weight[5] = 0.03959913525184361306673554464542586725695163952049856128804051234255261129138488693510910732381279879;
      _points[6] = 0.09215187438911484644662472338123667264179880146643822092506801920657976020699941134173341547096827924;
      _weight[6] = 0.05529645450351410102036170292138269670717637406083712964877105472962133442402408483737679619844190362;
      _points[7] = 0.9078481256108851535533752766187633273582011985335617790749319807934202397930005886582665845290317207;
      _weight[7] = 0.05529645450351410102036170292138269670717637406083712964877105472962133442402408483737679619844190362;
      _points[8] = 0.1544855096861576473025403213137733515967934689047922857963009513809809776082858467655372231955925407;
      _weight[8] = 0.06899387310096333045880700038864374309162572725800545170015760121411244787741507536110273618225975423;
      _points[9] = 0.8455144903138423526974596786862266484032065310952077142036990486190190223917141532344627768044074592;
      _weight[9] = 0.06899387310096333045880700038864374309162572725800545170015760121411244787741507536110273618225975423;
      _points[10] = 0.2293073003349492304381332962479683741624266760175844273395272942728200129063258890899339345066293663;
      _weight[10] = 0.08019733099881071727160499832974122041636212873920630079131172039729398165167861574477447700407927277;
      _points[11] = 0.7706926996650507695618667037520316258375733239824155726604727057271799870936741109100660654933706336;
      _weight[11] = 0.08019733099881078821693743948011763927449738613103247849548941778047869008300141395588839069473838607;
      _points[12] = 0.3139127832172614790463826596323710937200913427998597132674483282100146380580786932332134427655540175;
      _weight[12] = 0.08850212675782896135222352511185941077261441964304223231868144023076568116352616347759386466853424436;
      _points[13] = 0.6860872167827385209536173403676289062799086572001402867325516717899853619419213067667865572344459824;
      _weight[13] = 0.08850212675782896135222352511185941077261441964304223231868144023076568116352616347759386466853424436;
      _points[14] = 0.5947559867591586941521315073765569856724962114612492852889356355838398959607577064877475493328539104;
      _weight[14] = 0.09360816983880938635940242790916881385197052498183308417216218607377116989021462011158933594030989464;
      _points[15] = 0.4052440132408413058478684926234430143275037885387507147110643644161601040392422935122524506671460895;
      _weight[15] = 0.0936081698388097198357489579060647365167603390289223278358109823224203417654486101271080891938957963;
      _points[16] = 0.5;
      _weight[16] = 0.09533093737673469592049638786099957318493533837136307751858427271487841651421308465940795530806018266;
      break;

    default :
      DUNE_THROW(QuadratureOrderOutOfRange, "Quadrature rule " << p << " not supported!");
    }
  }

  // for non-fundamental types: assign numbers as strings
  template<typename ct>
  void GaussLobattoQuadratureInitHelper<ct,false>::init(int p,
         std::vector< FieldVector<ct, 1> > & _points,
         std::vector< ct > & _weight,
         int & delivered_order)
  {
    switch(p)
    {
    // order 0,1
    case 0 :
    case 1 :
      delivered_order = 1;
      _points.resize(2);
      _weight.resize(2);
      _points[0] = "0.0";
      _weight[0] = "0.5";
      _points[1] = "1.0";
      _weight[1] = "0.5";
      break;

    // order 2,3
    case 2 :
    case 3 :
      delivered_order = 3;
      _points.resize(3);
      _weight.resize(3);
      _points[0] = "0.0";
      _weight[0] = "0.1666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666";
      _points[1] = "1.0";
      _weight[1] = "0.1666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666";
      _points[2] = "0.5";
      _weight[2] = "0.6666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666";
      break;

    // order 4,5
    case 4 :
    case 5 :
      delivered_order = 5;
      _points.resize(4);
      _weight.resize(4);
      _points[0] = "0.0";
      _weight[0] = "0.08333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333";
      _points[1] = "1.0";
      _weight[1] = "0.08333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333";
      _points[2] = "0.7236067977499789696409173668731276235440618359611525724270897245410520925637804899414414408378782274";
      _weight[2] = "0.4166666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666";
      _points[3] = "0.2763932022500210303590826331268723764559381640388474275729102754589479074362195100585585591621217725";
      _weight[3] = "0.4166666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666";
      break;

    // order 6,7
    case 6 :
    case 7 :
      delivered_order = 7;
      _points.resize(5);
      _weight.resize(5);
      _points[0] = "0.0";
      _weight[0] = "0.05";
      _points[1] = "1.0";
      _weight[1] = "0.05";
      _points[2] = "0.8273268353539885718991462281234291777846040411977122787576601517076334589676979204717401113923889309";
      _weight[2] = "0.2722222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222";
      _points[3] = "0.172673164646011428100853771876570822215395958802287721242339848292366541032302079528259888607611069";
      _weight[3] = "0.2722222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222";
      _points[4] = "0.5";
      _weight[4] = "0.3555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555";
      break;

    // order 8,9
    case 8 :
    case 9 :
      delivered_order = 9;
      _points.resize(6);
      _weight.resize(6);
      _points[0] = "1.0";
      _weight[0] = "0.03333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333";
      _points[1] = "0.0";
      _weight[1] = "0.03333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333";
      _points[2] = "0.1174723380352676535744985130203309248171321557319478803362088220814723414805867429382513646351330634";
      _weight[2] = "0.1892374781489234232284036242057490907893514186964376616666256074476596593400013181062101736711021799";
      _points[3] = "0.8825276619647323464255014869796690751828678442680521196637911779185276585194132570617486353648669365";
      _weight[3] = "0.1892374781489234232284036242057490907893514186964376616666256074476596593400013181062101736711021799";
      _points[4] = "0.6426157582403225481570754970204395359595017363632126959098752082638489654570997990908378640025315086";
      _weight[4] = "0.2774291885177430282418638795784291955151657623014470227339178631890479528065466824200205653368404297";
      _points[5] = "0.3573842417596774518429245029795604640404982636367873040901247917361510345429002009091621359974684913";
      _weight[5] = "0.2774291885177430282418638795784291955151657623014470227339178631890479528065466824200205653368404297";
      break;

    // order 10,11
    case 10 :
    case 11 :
      delivered_order = 11;
      _points.resize(7);
      _weight.resize(7);
      _points[0] = "0.0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002904443936136988704613522974964763885677664394036593149115822206008312261073264473647011675707760947";
      _weight[0] = "0.0238095238095238095238095238095238095238095238095238095238095238095238095238095238095238095238095238";
      _points[1] = "1.0";
      _weight[1] = "0.0238095238095238095238095238095238095238095238095238095238095238095238095238095238095238095238095238";
      _points[2] = "0.08488805186071653506398389301626743020641481756400195420459339398355773991365476236892514937696012313";
      _weight[2] = "0.1384130236807829131218398865437551831905777354633772635053884911031405721309519182560026241400322403";
      _points[3] = "0.9151119481392834649360161069837325697935851824359980457954066060164422600863452376310748506230398768";
      _weight[3] = "0.1384130236807829131218398865437551831905777354633772635053884911031405721309519182560026241400322403";
      _points[4] = "0.7344243967353571069018859409543831647027987358359223785513347296814777650585638543983611678787947876";
      _weight[4] = "0.2158726906049312417948738610998339197914196923935309869032368559369673797042108420764826997039883878";
      _points[5] = "0.2655756032646428930981140590456168352972012641640776214486652703185222349414361456016388321212052123";
      _weight[5] = "0.2158726906049312417948738610998339197914196923935309869032368559369673797042108420764826997039883878";
      _points[6] = "0.5";
      _weight[6] = "0.2438095238095238095238095238095238095238095238095238095238095238095238095238095238095238095238095238";
      break;

    // order 12,13
    case 12 :
    case 13 :
      delivered_order = 13;
      _points.resize(8);
      _weight.resize(8);
      _points[0] = "1.0";
      _weight[0] = "0.01785714285714285714285714285714285714285714285714285714285714285714285714285714285714285714285714285";
      _points[1] = "0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001549036765939727309127212253314540739028087676819516346195105176537766539239074385945072893710805838";
      _weight[1] = "0.01785714285714285714285714285714285714285714285714285714285714285714285714285714285714285714285714285";
      _points[2] = "0.9358700742548033076687228806103317190518903348384916774597076427869494970464842703630747633289511529";
      _weight[2] = "0.1053521135717531457639492254179672657149286651899994025892058675171367569238415491958627052447628671";
      _points[3] = "0.06412992574519669233127711938966828094810966516150832254029235721305050295351572963692523667104884704";
      _weight[3] = "0.1053521135717531457639492254179672657149286651899994025892058675171367569238415491958627052447628671";
      _points[4] = "0.2041499092834288489277446343010234050271495052413337516288702042649259099754335560686927101889881905";
      _weight[4] = "0.1705613462417519709738997111619593972203589637193408611485199043949945226147230572395682263445081994";
      _points[5] = "0.7958500907165711510722553656989765949728504947586662483711297957350740900245664439313072898110118094";
      _weight[5] = "0.1705613462417519709738997111619593972203589637193408611485199043949945226147230572395682263445081994";
      _points[6] = "0.395350391048760565615671369827324372352227297456659450554576653838934538176858502305738892317405195";
      _weight[6] = "0.2062293973293512499410663914158269430521945689751541836635147440769128811521868890734569253884206652";
      _points[7] = "0.6046496089512394343843286301726756276477727025433405494454233461610654618231414976942611076825948049";
      _weight[7] = "0.206229397329352290058663329175500307978970438228117708299717557326882845922119905543761777214046086";
      break;

    // order 14,15
    case 14 :
    case 15 :
      delivered_order = 15;
      _points.resize(9);
      _weight.resize(9);
      _points[0] = "1.0";
      _weight[0] = "0.01388888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888";
      _points[1] = "0.0";
      _weight[1] = "0.01388888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888";
      _points[2] = "0.0501210022942699213438273777908310209742598522169477887853436657575933627168406408544934398437526016";
      _weight[2] = "0.08274768078040277307375110531620151299110161681408257666001582629645006868924950402598198636482761858";
      _points[3] = "0.9498789977057300786561726222091689790257401477830522112146563342424066372831593591455065601562473983";
      _weight[3] = "0.08274768078040299448083313098402094403540223161400542189096055703361081411625039308473630041998890322";
      _points[4] = "0.1614068602446311232770572864543287746444851761930467102295183122514507360076748631095880608419781472";
      _weight[4] = "0.1372693562500809593124338701941148015065349646047663411511034276171563187785350916655638663434730627";
      _points[5] = "0.8385931397553688767229427135456712253555148238069532897704816877485492639923251368904119391580218527";
      _weight[5] = "0.1372693562500809593124338701941148015065349646047663411511034276171563187785350916655638663434730627";
      _points[6] = "0.681558731913089079355376034354329606510321138800439075160136865385805213816899479027566535923708144";
      _weight[6] = "0.1732142554865231869322860992053680838463565217024682188451171609646738454988173685693963668198179665";
      _points[7] = "0.3184412680869109206446239656456703934896788611995609248398631346141947861831005209724334640762918559";
      _weight[7] = "0.1732142554865231869322860992053680838463565217024682188451171609646738454988173685693963668198179665";
      _points[8] = "0.5";
      _weight[8] = "0.1857596371882086167800453514739229024943310657596371882086167800453514739229024943310657596371882086";
      break;

    // order 16,17
    case 16 :
    case 17 :
      delivered_order = 17;
      _points.resize(10);
      _weight.resize(10);
      _points[0] = "0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999";
      _weight[0] = "0.01111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111";
      _points[1] = "0.0";
      _weight[1] = "0.01111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111";
      _points[2] = "0.04023304591677059308553366958883093292322846227686206425518692770786627926104335933756011688795994553";
      _weight[2] = "0.06665299542553486307563078419385037524164195656474633503676859357600184466551650296921943773532930684";
      _points[3] = "0.9597669540832294069144663304111690670767715377231379357448130722921337207389566406624398831120400544";
      _weight[3] = "0.0666529954255350876256462019178923055849817749288126634748625480504711123271781571100362680090635451";
      _points[4] = "0.8693869325527525375015530874299153625080925506884633427325544965275766578699549008371448931272867576";
      _weight[4] = "0.112444671031563139838202048484435502843446956618904920749437576846203760250428610476443523218425496";
      _points[5] = "0.1306130674472474624984469125700846374919074493115366572674455034724233421300450991628551068727132423";
      _weight[5] = "0.1124446710315632557865964406843838642729673511142965495154088031617257004011641459726513834468349851";
      _points[6] = "0.2610375250947777521694124536343710010566135533347167655428715801541887244557614303116642045509084166";
      _weight[6] = "0.1460213418398417036209800331044298629666660225306298392345715865267261875420489975656340541631828428";
      _points[7] = "0.7389624749052222478305875463656289989433864466652832344571284198458112755442385696883357954490915833";
      _weight[7] = "0.1460213418398417036209800331044298629666660225306298392345715865267261875420489975656340541631828428";
      _points[8] = "0.5826394788331935123131098829790867666155751717747418655664497860523941482272025775233841371104750817";
      _weight[8] = "0.163769880591948734348597024651334428580472884726067686608365083124607813252839493579199611488019423";
      _points[9] = "0.4173605211668064876868901170209132333844248282252581344335502139476058517727974224766158628895249182";
      _weight[9] = "0.163769880591948734348597024651334428580472884726067686608365083124607813252839493579199611488019423";
      break;

    // order 18,19
    case 18 :
    case 19 :
      delivered_order = 19;
      _points.resize(11);
      _weight.resize(11);
      _points[0] = "1.0";
      _weight[0] = "0.00909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909";
      _points[1] = "0.0";
      _weight[1] = "0.00909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909090909";
      _points[2] = "0.03299928479597043283386293195030818273004133494501888705418662336432199124519182900837678308430293929";
      _weight[2] = "0.05480613663349747180131790064486021210029815861780431434085487755057522026619613620315494546320940628";
      _points[3] = "0.9670007152040295671661370680496918172699586650549811129458133766356780087548081709916232169156970607";
      _weight[3] = "0.05480613663349747180131790064486021210029815861780431434085487755057522026619613620315494546320940628";
      _points[4] = "0.892241736831572209311208908054229051753598727547031810841317670384292356072438301406275095976056209";
      _weight[4] = "0.09358494089015252696327174240117207855218318192550176212624049743234428734352148131097006547408770523";
      _points[5] = "0.1077582631684277906887910919457709482464012724529681891586823296157076439275616985937249040239437909";
      _weight[5] = "0.09358494089015273771626140833075693899437949665748224552868178075846784376744728583934397639003552592";
      _points[6] = "0.2173823365018974967645180152611241678584739272189915121544213759600612059255784548809189629767876991";
      _weight[6] = "0.1240240521320142891804383293899665806242608294678538621504361485460838477153266390282580452167026476";
      _points[7] = "0.7826176634981025032354819847388758321415260727810084878455786240399387940744215451190810370232123008";
      _weight[7] = "0.1240240521320142891804383293899665806242608294678538621504361485460838477153266390282580452167026476";
      _points[8] = "0.6478790677934696957159557577795287544705032171743020547339496869008099808882276395132179974605411626";
      _weight[8] = "0.1434395623895041888327723915044603555734785596509798429577098328117542773990115034803028594956977203";
      _points[9] = "0.3521209322065303042840442422204712455294967828256979452660503130991900191117723604867820025394588373";
      _weight[9] = "0.1434395623895041888327723915044603555734785596509798429577098328117542773990115034803028594956977203";
      _points[10] = "0.5";
      _weight[10] = "0.150108797727845346892965940584988204035823083442131061178680226299273918321537369156416775464394512";
      break;

    // order 20,21
    case 20 :
    case 21 :
      delivered_order = 21;
      _points.resize(12);
      _weight.resize(12);
      _points[0] = "0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001781392280830686405496294091311721849882300828342443798124370953018431520124935543836833827767426714";
      _weight[0] = "0.007575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575";
      _points[1] = "0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999";
      _weight[1] = "0.007575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575";
      _points[2] = "0.02755036388855888829620993084839064319437172402498633814305405146172603859028701369634772815688410958";
      _weight[2] = "0.04584225870659798715036925589564285604170047429796152073151861841009423965716600639739150395416708617";
      _points[3] = "0.9724496361114411117037900691516093568056282759750136618569459485382739614097129863036522718431158904";
      _weight[3] = "0.04584225870659800440346685904355316020528159352455033803492081370360040588262094430946338464327254694";
      _points[4] = "0.9096396608220033391743207908584513303452333289518221447116583630584383637955809711802462446795835436";
      _weight[4] = "0.07898735278218495200388303300215442025826577292611090576303298520123454982016201877028466329583963642";
      _points[5] = "0.09036033917799666082567920914154866965476667104817785528834163694156163620441902881975375532041645631";
      _weight[5] = "0.0789873527821851186180752898779220719303782093539899033577745626868502710304103192219598833696683329";
      _points[6] = "0.8164380765159303388312024272218279291219218727007504964825767823235261210022296852225740227244886444";
      _weight[6] = "0.1062542088805105716744093009787904717056408463699116702735805868768086945124594787342787723965605353";
      _points[7] = "0.1835619234840696611687975727781720708780781272992495035174232176764738789977703147774259772755113555";
      _weight[7] = "0.1062542088805105716744093009787904717056408463699116702735805868768086945124594787342787723965605353";
      _points[8] = "0.3002345295173255338678251042165165497361259836023464817560311639749518780463076119023391127095642402";
      _weight[8] = "0.1256378015996005165827376850755831139070011511966554376121170978329472714657423785638682272588676999";
      _points[9] = "0.6997654704826744661321748957834834502638740163976535182439688360250481219536923880976608872904357597";
      _weight[9] = "0.1256378015996005165827376850755831139070011511966554376121170978329472714657423785638682272588676999";
      _points[10] = "0.5682764664274637774320309278698469484492070556410291927257907830335263719510014649425107069687302462";
      _weight[10] = "0.1357026204553480906096889911764786402158746729620987369287502247173580356645839055831198708548202671";
      _points[11] = "0.4317235335725362225679690721301530515507929443589708072742092169664736280489985350574892930312697537";
      _weight[11] = "0.1357026204553480906096889911764786402158746729620987369287502247173580356645839055831198708548202671";
      break;

    // order 22,23
    case 22 :
    case 23 :
      delivered_order = 23;
      _points.resize(13);
      _weight.resize(13);
      _points[0] = "0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999";
      _weight[0] = "0.00641025641025641025641025641025641025641025641025641025641025641025641025641025641025641025641025641";
      _points[1] = "0.0";
      _weight[1] = "0.00641025641025641025641025641025641025641025641025641025641025641025641025641025641025641025641025641";
      _points[2] = "0.976654923321081955948452732377724575813253944348681592594686301425449791149365608726532254019633679";
      _weight[2] = "0.03890084337340951352241815224962494681077413819473638123548816575330444020962125016612379081158827671";
      _points[3] = "0.02334507667891804405154726762227542418674605565131840740531369857455020885063439127346774598036632099";
      _weight[3] = "0.03890084337340958827601245635130368047541246960728107078202562012408954852923196046113675883133340303";
      _points[4] = "0.07682621767406384156703719645062332021098167014279568715567649366694671496870686996706125852843088673";
      _weight[4] = "0.06749096334480406838932902883081278821819444630474906104405659574885031897065583141011906071888851221";
      _points[5] = "0.9231737823259361584329628035493766797890183298572043128443235063330532850312931300329387414715691132";
      _weight[5] = "0.06749096334480413889962929617064163476963845740219567032780352580688423373246502389108955519941753406";
      _points[6] = "0.1569057654591212869636204802168222235354119009378077864686543270522656709999405253802533533853237888";
      _weight[6] = "0.09182343260177488792767534215391263627423219394617012098311944957839368766343343432165329667315733756";
      _points[7] = "0.8430942345408787130363795197831777764645880990621922135313456729477343290000594746197466466146762111";
      _weight[7] = "0.09182343260177528389330746184235496439693092275287745425247374194410753288715329773930435313147982784";
      _points[8] = "0.2585450894543318991265313831815331896139033689407049947611379539755934104463513064527766100872116534";
      _weight[8] = "0.110383896783055056246621494118085971542659810255041303886069760014526608615072150467986514378309256";
      _points[9] = "0.7414549105456681008734686168184668103860966310592950052388620460244065895536486935472233899127883465";
      _weight[9] = "0.1103838967830551045620897232012161458144565663253055673568641263262421083935999484922047328534838929";
      _points[10] = "0.6246434650531199962843368501871134907444056562464879296492579543168629813997495722095567115050590931";
      _weight[10] = "0.1220078951533380694135091140203570882018292390060569030446137943731266281663298099310619861671980622";
      _points[11] = "0.3753565349468800037156631498128865092555943437535120703507420456831370186002504277904432884949409068";
      _weight[11] = "0.1220078951533380694135091140203570882018292390060569030446137943731266281663298099310619861671980622";
      _points[12] = "0.5";
      _weight[12] = "0.1259654246667233680220693207706194719181732168745155758142771129784116797103810090823077836064849051";
      break;

    // order 24,25
    case 24 :
    case 25 :
      delivered_order = 25;
      _points.resize(14);
      _weight.resize(14);
      _points[0] = "1.0";
      _weight[0] = "0.005494505494505494505494505494505494505494505494505494505494505494505494505494505494505494505494505494";
      _points[1] = "0.0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005808887872273977409227045949929527771355328788073186298231644412016624522146528947294023351415521895";
      _weight[1] = "0.005494505494505494505494505494505494505494505494505494505494505494505494505494505494505494505494505494";
      _points[2] = "0.02003247736636954932244991899228780546680424071367603181792088307398665120252422248009577136781701629";
      _weight[2] = "0.03341864224884065217061354728917174278902212629139089722371383266283797624548671670279582881834208524";
      _points[3] = "0.9799675226336304506775500810077121945331957592863239681820791169260133487974757775199042286321829837";
      _weight[3] = "0.03341864224884065217061354728917174278902212629139089722371383266283797624548671670279582881834208524";
      _points[4] = "0.9339005269151736255001101014541321066249361765472180673794130920541252668245245267203554324860697834";
      _weight[4] = "0.05829332794935571210271662888017431543229876919401686092600394050583016885163116922076726270883171305";
      _points[5] = "0.06609947308482637449988989854586789337506382345278193262058690794587473317547547327964456751393021655";
      _weight[5] = "0.05829332794935579360619760354616444941160248221320965046128703070188777304751333641065014872547972147";
      _points[6] = "0.1355657004543369297076637997395592021713302341528390986938780173861806180949423040135067458535801027";
      _weight[6] = "0.08001092588147612699855887615065849281923484038077205182492425701464771387231180735243810330300693959";
      _points[7] = "0.8644342995456630702923362002604407978286697658471609013061219826138193819050576959864932541464198972";
      _weight[7] = "0.08001092588147612699855887615065849281923484038077205182492425701464771387231180735243810330300693959";
      _points[8] = "0.7753197014643235276583113529295403172310691597769570669118964569840194786616101591806838309484212402";
      _weight[8] = "0.09741307468670808344801049010650000522379523141023358240396111161380728370363602934063314340453378684";
      _points[9] = "0.2246802985356764723416886470704596827689308402230429330881035430159805213383898408193161690515787597";
      _weight[9] = "0.09741307468670808344801049010650000522379523141023358240396111161380728370363602934063314340453378684";
      _points[10] = "0.3286379933286435774780482981791626775834432329298466267225425835645065531681161297198297276026186597";
      _weight[10] = "0.1095631265048852318156387560975273959852529670907608877986845521431840985717081685110602384512818439";
      _points[11] = "0.6713620066713564225219517018208373224165567670701533732774574164354934468318838702801702723973813402";
      _weight[11] = "0.1095631265048854938052036604530717246636213171726383190876371756244984197097901689822018187203160027";
      _points[12] = "0.4418340655581480661706116451319199160292454778718596158983375697060141886686100702311406674611777446";
      _weight[12] = "0.1158063972342284700226103441401948464902902135539666609185863177651613242876539379250513692524248257";
      _points[13] = "0.5581659344418519338293883548680800839707545221281403841016624302939858113313899297688593325388222553";
      _weight[13] = "0.1158063972342285397083030502863276232762209597422663360982907980606878842338318503509714229153436604";
      break;

    // order 26,27
    case 26 :
    case 27 :
      delivered_order = 27;
      _points.resize(15);
      _weight.resize(15);
      _points[0] = "0.9999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999";
      _weight[0] = "0.004761904761904761904761904761904761904761904761904761904761904761904761904761904761904761904761904761";
      _points[1] = "0.0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001776551540937124757655271553020113910072838054352382809542511249341750999689813436380755474974580446";
      _weight[1] = "0.004761904761904761904761904761904761904761904761904761904761904761904761904761904761904761904761904761";
      _points[2] = "0.9826229632519192863979256960348005888538250679985466700362492292135561186010360176002647647677775953";
      _weight[2] = "0.02901494651430062756621020915804012753889874672455136580035112501061369195534504408694618242582509908";
      _points[3] = "0.01737703674808071360207430396519941114617493200145332996375077078644388139896398239973523523222240469";
      _weight[3] = "0.02901494651430062756621020915804012753889874672455136580035112501061369195534504408694618242582509908";
      _points[4] = "0.05745897788851185058729918425888517400564295739626101359130918465945600252159841114408283401864691438";
      _weight[4] = "0.05083003516285878338803942630302165725168794138894212677814386905351545744325033588832115298736238919";
      _points[5] = "0.9425410221114881494127008157411148259943570426037389864086908153405439974784015888559171659813530856";
      _weight[5] = "0.05083003516285899330827821352748378690108686993446504683879406493951605815149878395862946911174315326";
      _points[6] = "0.118240155024092399647940762011854190911315739842354831622647197476461454480323624696818048989422683";
      _weight[6] = "0.07025584990121407338933749964280231716628931085103427835102929419731533544351325685204838749336276863";
      _points[7] = "0.8817598449759076003520592379881458090886842601576451683773528025235385455196763753031819510105773169";
      _weight[7] = "0.07025584990121407338933749964280231716628931085103427835102929419731533544351325685204838749336276863";
      _points[8] = "0.1968733972650771444382350306816332464101344831200401071570852480104016101447308179570244003079193093";
      _weight[8] = "0.08639482362680036401606076625455722556519712728535659599275114991384778388925459506585146451274262273";
      _points[9] = "0.8031266027349228555617649693183667535898655168799598928429147519895983898552691820429755996920806906";
      _weight[9] = "0.08639482362680062998622671825835568869702664765410094182168518362444715482799754020955470023746019139";
      _points[10] = "0.7103190273568362404609484693692902064921691027462151841925466804687845341292931576115237553308309106";
      _weight[10] = "0.09849361798230646863702106300593697382510285092920888688095284104258975741179661694544935058484678254";
      _points[11] = "0.2896809726431637595390515306307097935078308972537848158074533195312154658707068423884762446691690893";
      _weight[11] = "0.09849361798230673878605433006448159592348868526692761846331165137267792942173170662632461201451372639";
      _points[12] = "0.6076769776818971191128397231364588563260789506015205317372525738208551778333542221797656769767607932";
      _weight[12] = "0.1059867929634106089765228761759381798732911730748818676865148423030660515596094954274641983031741433";
      _points[13] = "0.3923230223181028808871602768635411436739210493984794682627474261791448221666457778202343230232392067";
      _weight[13] = "0.1059867929634106089765228761759381798732911730748818676865148423030660515596094954274641983031741433";
      _points[14] = "0.5";
      _weight[14] = "0.1085240581744078247574751071254567758064261560765057268553772050275546779043282539786036289532793029";
      break;

    // order 28,29
    case 28 :
    case 29 :
      delivered_order = 29;
      _points.resize(16);
      _weight.resize(16);
      _points[0] = "0.0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001717494514235672653994796585862497044397392211673638748843822864486248650381323725416599570901855973";
      _weight[0] = "0.004166666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666";
      _points[1] = "1.0";
      _weight[1] = "0.004166666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666";
      _points[2] = "0.9847840231351089664761213691837296206944953732519173650343393661412705259269883781602191879541709236";
      _weight[2] = "0.0254251805029600001309399960630984095079177571685866744976519164487631070262712662765718326148449947";
      _points[3] = "0.0152159768648910335238786308162703793055046267480826349656606338587294740730116218397808120458290763";
      _weight[3] = "0.0254251805029600001309399960630984095079177571685866744976519164487631070262712662765718326148449947";
      _points[4] = "0.05039973345326395350268586924007526162500119547742778728778629410576180140857154234663004161524265869";
      _weight[4] = "0.04469684866296540360807512395212181743763849069106172851842802759230782156701519482136464005494460301";
      _points[5] = "0.9496002665467360464973141307599247383749988045225722127122137058942381985914284576533699583847573413";
      _weight[5] = "0.04469684866296540360807512395212181743763849069106172851842802759230782156701519482136464005494460301";
      _points[6] = "0.1039958540690924680344558645184271470959630860099004886577946750670018549860024997788167097104336213";
      _weight[6] = "0.06212769106625700090745135751571169925765012779766252234075191002994688829391255260828613367456086166";
      _points[7] = "0.8960041459309075319655441354815728529040369139900995113422053249329981450139975002211832902895663786";
      _weight[7] = "0.06212769106625713680999500056864677179206724428416510521932624364081498865545853252074214270875472272";
      _points[8] = "0.8261943514412465447339416098202907401607790064147871686928906421111185215402141672897334327391086998";
      _weight[8] = "0.07701349040358195341145453566040361269680954371316890783810954300473408230488869486388761496861299555";
      _points[9] = "0.1738056485587534552660583901797092598392209935852128313071093578888814784597858327102665672608913001";
      _weight[9] = "0.07701349040358215871376149544072559912165775818315250344225198835223859484704541379040276381827425959";
      _points[10] = "0.7430297109435688058909453929234373484444886521491262856883284338033922487167612097283758109612034";
      _weight[10] = "0.08874595669585221520933868691235856081930807191018199541200416779573042660639649880097344522469846959";
      _points[11] = "0.2569702890564311941090546070765626515555113478508737143116715661966077512832387902716241890387965999";
      _weight[11] = "0.08874595669585221520933868691235856081930807191018199541200416779573042660639649880097344522469846959";
      _points[12] = "0.3500847655496183959508232726388496760922695115461111676728449511779795615144536050173294511021111004";
      _weight[12] = "0.09684501191260187752750797980922898202299380259227232810235530312185806551162011408119432317334702951";
      _points[13] = "0.6499152344503816040491767273611503239077304884538888323271550488220204384855463949826705488978888995";
      _weight[13] = "0.09684501191260187752750797980922898202299380259227232810235530312185806551162011408119432317334702951";
      _points[14] = "0.4493368632390252760784834974770411187333795427999044300412248998728460413102109205056194162045666875";
      _weight[14] = "0.1009791540891148356147629230961218152573684409527987001771404500634876059376754607311450331000040295";
      _points[15] = "0.5506631367609747239215165025229588812666204572000955699587751001271539586897890794943805837954333124";
      _weight[15] = "0.1009791540891151004983612731230700862720831623456811382569592001800226682876474162857257849626219047";
      break;

    // order 30,31
    case 30 :
    case 31 :
      delivered_order = 31;
      _points.resize(17);
      _weight.resize(17);
      _points[0] = "1.0";
      _weight[0] = "0.003676470588235294117647058823529411764705882352941176470588235294117647058823529411764705882352941176";
      _points[1] = "0.0";
      _weight[1] = "0.003676470588235294117647058823529411764705882352941176470588235294117647058823529411764705882352941176";
      _points[2] = "0.9865660883157091570784897509368607152944795745612547432232459215480390687332058160630984405164903217";
      _weight[2] = "0.02246097027162712220178874277948353879341752283391191053478448918418274884000451898542092410577902027";
      _points[3] = "0.01343391168429084292151024906313928470552042543874525677675407845196093126679418393690155948350967826";
      _weight[3] = "0.02246097027162712220178874277948353879341752283391191053478448918418274884000451898542092410577902027";
      _points[4] = "0.04456000204221320218809874680113676623456027406563361783909372034451666996366541838091452314925205037";
      _weight[4] = "0.03959913525184347758052285572370103043491489833360928035519321099199068708437537909786266847751137145";
      _points[5] = "0.9554399979577867978119012531988632337654397259343663821609062796554833300363345816190854768507479496";
      _weight[5] = "0.03959913525184361306673554464542586725695163952049856128804051234255261129138488693510910732381279879";
      _points[6] = "0.09215187438911484644662472338123667264179880146643822092506801920657976020699941134173341547096827924";
      _weight[6] = "0.05529645450351410102036170292138269670717637406083712964877105472962133442402408483737679619844190362";
      _points[7] = "0.9078481256108851535533752766187633273582011985335617790749319807934202397930005886582665845290317207";
      _weight[7] = "0.05529645450351410102036170292138269670717637406083712964877105472962133442402408483737679619844190362";
      _points[8] = "0.1544855096861576473025403213137733515967934689047922857963009513809809776082858467655372231955925407";
      _weight[8] = "0.06899387310096333045880700038864374309162572725800545170015760121411244787741507536110273618225975423";
      _points[9] = "0.8455144903138423526974596786862266484032065310952077142036990486190190223917141532344627768044074592";
      _weight[9] = "0.06899387310096333045880700038864374309162572725800545170015760121411244787741507536110273618225975423";
      _points[10] = "0.2293073003349492304381332962479683741624266760175844273395272942728200129063258890899339345066293663";
      _weight[10] = "0.08019733099881071727160499832974122041636212873920630079131172039729398165167861574477447700407927277";
      _points[11] = "0.7706926996650507695618667037520316258375733239824155726604727057271799870936741109100660654933706336";
      _weight[11] = "0.08019733099881078821693743948011763927449738613103247849548941778047869008300141395588839069473838607";
      _points[12] = "0.3139127832172614790463826596323710937200913427998597132674483282100146380580786932332134427655540175";
      _weight[12] = "0.08850212675782896135222352511185941077261441964304223231868144023076568116352616347759386466853424436";
      _points[13] = "0.6860872167827385209536173403676289062799086572001402867325516717899853619419213067667865572344459824";
      _weight[13] = "0.08850212675782896135222352511185941077261441964304223231868144023076568116352616347759386466853424436";
      _points[14] = "0.5947559867591586941521315073765569856724962114612492852889356355838398959607577064877475493328539104";
      _weight[14] = "0.09360816983880938635940242790916881385197052498183308417216218607377116989021462011158933594030989464";
      _points[15] = "0.4052440132408413058478684926234430143275037885387507147110643644161601040392422935122524506671460895";
      _weight[15] = "0.0936081698388097198357489579060647365167603390289223278358109823224203417654486101271080891938957963";
      _points[16] = "0.5";
      _weight[16] = "0.09533093737673469592049638786099957318493533837136307751858427271487841651421308465940795530806018266";
      break;

    default :
      DUNE_THROW(QuadratureOrderOutOfRange, "Quadrature rule " << p << " not supported!");
    }
  }

} // namespace
