/* -*- tab-width: 4 -*-
 *
 * Electric(tm) VLSI Design System
 *
 * File: SVGTab.java
 *
 * Copyright (c) 2010, Static Free Software. All rights reserved.
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.PreferencesFrame;
import com.sun.electric.util.TextUtils;

import javax.swing.JPanel;

/**
 * Class for showing the SVG preferences panel.
 */
public class SVGTab extends PreferencePanel
{
    /** Creates new form SVGTab */
    public SVGTab(PreferencesFrame parent, boolean modal)
    {
        super(parent, modal);
        initComponents();

		// make all text fields select-all when entered
	    EDialog.makeTextFieldSelectAllOnTab(svgScale);
	    EDialog.makeTextFieldSelectAllOnTab(svgMargin);
    }

    /** return the panel to use for the user preferences. */
    public JPanel getUserPreferencesPanel() { return svgPanel; }

    /** return the name of this preferences tab. */
    public String getName() { return "SVG"; }

    /**
     * Method called at the start of the dialog.
     * Caches current values and displays them in the SVG tab.
     */
    public void init() {
    	svgScale.setText(TextUtils.formatDouble(IOTool.getSVGScale()));
        svgMargin.setText(TextUtils.formatDouble(IOTool.getSVGMargin()));
    }

    /**
     * Method called when the "OK" panel is hit.
     * Updates any changed fields in the SVG tab.
     */
    public void term()
    {
        double v = TextUtils.atof(svgScale.getText());
        if (v != IOTool.getSVGScale()) IOTool.setSVGScale(v);
        v = TextUtils.atof(svgMargin.getText());
        if (v != IOTool.getSVGMargin()) IOTool.setSVGMargin(v);
    }

	/**
	 * Method called when the factory reset is requested.
	 */
	public void reset()
	{
		if (IOTool.getFactorySVGScale() != IOTool.getSVGScale())
			IOTool.setSVGScale(IOTool.getFactorySVGScale());
		if (IOTool.getFactorySVGMargin() != IOTool.getSVGMargin())
			IOTool.setSVGMargin(IOTool.getFactorySVGMargin());
	}

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        svgPanel = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        svgScale = new javax.swing.JTextField();
        svgMargin = new javax.swing.JTextField();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        getContentPane().setLayout(new java.awt.GridBagLayout());

        svgPanel.setLayout(new java.awt.GridBagLayout());

        jLabel1.setText("Margin:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        svgPanel.add(jLabel1, gridBagConstraints);

        jLabel2.setText("Scale Factor:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        svgPanel.add(jLabel2, gridBagConstraints);

        svgScale.setColumns(16);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        svgPanel.add(svgScale, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        svgPanel.add(svgMargin, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        getContentPane().add(svgPanel, gridBagConstraints);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JTextField svgMargin;
    private javax.swing.JPanel svgPanel;
    private javax.swing.JTextField svgScale;
    // End of variables declaration//GEN-END:variables

}
