#include "SDL_opengl.h"
#include "tower.h"


#include <iostream>

namespace models {

static GLuint tower_dl=0;

void tower::draw() {
	dldraw();
}
void tower::dldraw() {
	if (tower_dl==0) { sdraw(); return; }
	glCallList(tower_dl);
}

void tower::gen_dl() {
	tower_dl=glGenLists(1);
	glNewList(tower_dl,GL_COMPILE);
	sdraw();
	glEndList();
	std::cout << " loaded tower " << tower_dl << std::endl;
}
namespace mtl_tower {
typedef enum MTL {
m_New_Material,
m_antenna,
m_deco,
m_window,
m_last
};
} //namespace
void tower::material (int id) {
	switch (id) {
		case mtl_tower::m_New_Material:
static const GLfloat m_New_Material_diffuse[] = {0.806860,0.806860,0.806860};
			glMaterialfv(GL_FRONT,GL_DIFFUSE, m_New_Material_diffuse);
static const GLfloat m_New_Material_ambient[] = {0.793540,0.793540,0.793540};
			glMaterialfv(GL_FRONT,GL_AMBIENT, m_New_Material_ambient);
static const GLfloat m_New_Material_emissive[] = {0.00000e+0,0.00000e+0,0.00000e+0};
			glMaterialfv(GL_FRONT,GL_EMISSION, m_New_Material_emissive);
			break;
		case mtl_tower::m_antenna:
static const GLfloat m_antenna_diffuse[] = {8.75800e-2,8.75800e-2,8.75800e-2};
			glMaterialfv(GL_FRONT,GL_DIFFUSE, m_antenna_diffuse);
static const GLfloat m_antenna_ambient[] = {9.42400e-2,9.42400e-2,9.42400e-2};
			glMaterialfv(GL_FRONT,GL_AMBIENT, m_antenna_ambient);
static const GLfloat m_antenna_emissive[] = {0.00000e+0,0.00000e+0,0.00000e+0};
			glMaterialfv(GL_FRONT,GL_EMISSION, m_antenna_emissive);
			break;
		case mtl_tower::m_deco:
static const GLfloat m_deco_diffuse[] = {1.00000,0.00000e+0,0.00000e+0};
			glMaterialfv(GL_FRONT,GL_DIFFUSE, m_deco_diffuse);
static const GLfloat m_deco_ambient[] = {1.00000,0.00000e+0,0.00000e+0};
			glMaterialfv(GL_FRONT,GL_AMBIENT, m_deco_ambient);
static const GLfloat m_deco_emissive[] = {0.00000e+0,0.00000e+0,0.00000e+0};
			glMaterialfv(GL_FRONT,GL_EMISSION, m_deco_emissive);
			break;
		case mtl_tower::m_window:
static const GLfloat m_window_diffuse[] = {1.00000,1.00000,0.173333};
			glMaterialfv(GL_FRONT,GL_DIFFUSE, m_window_diffuse);
static const GLfloat m_window_ambient[] = {1.00000,1.00000,0.166667};
			glMaterialfv(GL_FRONT,GL_AMBIENT, m_window_ambient);
static const GLfloat m_window_emissive[] = {0.00000e+0,0.00000e+0,0.00000e+0};
			glMaterialfv(GL_FRONT,GL_EMISSION, m_window_emissive);
			break;
	}
}
float tower::minx() { return -1.39258 ; }
float tower::miny() { return 0 ; }
float tower::minz() { return -1.39258 ; }
float tower::maxx() { return 1.39258; }
float tower::maxy() { return 9.37256; }
float tower::maxz() { return 1.39258; }
float tower::radius() { return 9.57724; }
void tower::sdraw() {
const float vertices[59][3]={
	{-1.29692612,0.0000000e+0,1.29692612},
	{-1.29692612,4.41244444,1.29692612},
	{1.29692612,4.41244444,1.29692612},
	{1.29692612,0.0000000e+0,1.29692612},
	{-1.29692612,0.0000000e+0,-1.29692612},
	{-1.29692612,4.41244444,-1.29692612},
	{1.29692612,4.41244444,-1.29692612},
	{1.29692612,0.0000000e+0,-1.29692612},
	{-1.36600000,5.53955556,1.36600000},
	{1.36600000,5.53955556,1.36600000},
	{1.36600000,5.53955556,-1.36600000},
	{-1.36600000,5.53955556,-1.36600000},
	{-0.85784800,5.53955556,0.85784800},
	{0.85784800,5.53955556,0.85784800},
	{0.85784800,5.53955556,-0.85784800},
	{-0.85784800,5.53955556,-0.85784800},
	{-0.85784800,6.10844444,0.85784800},
	{0.85784800,6.10844444,0.85784800},
	{0.85784800,6.10844444,-0.85784800},
	{-0.85784800,6.10844444,-0.85784800},
	{-1.39257554,6.04453328,1.39257554},
	{1.39257554,6.04453328,1.39257554},
	{1.39257554,6.04453328,-1.39257554},
	{-1.39257554,6.04453328,-1.39257554},
	{-0.59041217,8.57244859,0.59041217},
	{0.59041217,8.57244859,0.59041217},
	{0.59041217,8.57244859,-0.59041217},
	{-0.59041217,8.57244859,-0.59041217},
	{-0.80000000,0.0000000e+0,1.00000000},
	{-1.00000000,0.0000000e+0,0.80000000},
	{-0.80000000,4.41244444,1.00000000},
	{-1.05901899,4.59419570,1.05901899},
	{-1.00000000,4.41244444,0.80000000},
	{0.80000000,4.41244444,1.00000000},
	{1.00000000,4.41244444,0.80000000},
	{1.05901899,4.59419570,1.05901899},
	{0.80000000,0.0000000e+0,1.00000000},
	{1.00000000,0.0000000e+0,0.80000000},
	{-1.00000000,0.0000000e+0,-0.80000000},
	{-0.80000000,0.0000000e+0,-1.00000000},
	{-1.00000000,4.41244444,-0.80000000},
	{-1.05901899,4.59419570,-1.05901899},
	{-0.80000000,4.41244444,-1.00000000},
	{0.80000000,4.41244444,-1.00000000},
	{1.05901899,4.59419570,-1.05901899},
	{1.00000000,4.41244444,-0.80000000},
	{0.80000000,0.0000000e+0,-1.00000000},
	{1.00000000,0.0000000e+0,-0.80000000},
	{0.59041217,8.57244859,-0.36959802},
	{0.74041672,8.09972842,-0.74041672},
	{0.64212631,8.82256155,-0.50441484},
	{0.68802770,8.82256155,-0.58348374},
	{0.64212631,8.82256155,-0.57198397},
	{0.73847184,8.33608851,-0.55500737},
	{0.68743257,8.82256155,-0.52674848},
	{0.66996920,9.37256285,-0.54219808},
	{0.67010251,9.37256285,-0.55490678},
	{0.65982060,9.37256285,-0.55233083},
	{0.65982060,9.37256285,-0.53719534},
};
const float normals[59][3]={
	{-0.31042256,-0.89848521,0.31042256},
	{-0.61183100,0.50132391,0.61183100},
	{0.53016250,0.66170646,0.53016250},
	{0.49420367,-0.71521009,0.49420367},
	{-0.49420367,-0.71521009,-0.49420367},
	{-0.53016250,0.66170646,-0.53016250},
	{0.61183100,0.50132391,-0.61183100},
	{0.31042256,-0.89848521,-0.31042256},
	{-0.82479804,0.13174324,0.54986536},
	{0.62425214,0.46970046,0.62425214},
	{0.54986536,0.13174324,-0.82479804},
	{-0.49312912,0.71669195,-0.49312912},
	{-0.40824829,0.81649658,0.40824829},
	{0.40824829,0.81649658,0.40824829},
	{0.40824829,0.81649658,-0.40824829},
	{-0.40824829,0.81649658,-0.40824829},
	{-0.37589588,-0.84699739,0.37589588},
	{0.37589588,-0.84699739,0.37589588},
	{0.37589588,-0.84699739,-0.37589588},
	{-0.37589588,-0.84699739,-0.37589588},
	{-0.45938689,-0.76021534,0.45938689},
	{0.79508467,-0.47967437,0.37115075},
	{0.20360330,-0.95764889,-0.20360330},
	{-0.37115075,-0.47967437,-0.79508467},
	{-0.32497578,0.88813371,0.32497578},
	{0.66729194,0.55837020,0.49289369},
	{-0.59637699,0.46336674,-0.65545843},
	{-0.45477446,0.76574172,-0.45477446},
	{0.23617525,-0.46044063,0.85569602},
	{-0.66899927,-0.71996232,-0.18464626},
	{0.17491639,-9.1800273e-2,0.98029433},
	{-0.70245239,0.11454809,0.70245239},
	{-0.97654461,-4.4203912e-2,-0.21072881},
	{-0.22706152,-3.1268778e-2,0.97337831},
	{0.97337831,-3.1268778e-2,-0.22706152},
	{0.70245239,0.11454809,0.70245239},
	{-0.14383708,-0.84126217,0.52114188},
	{0.41853042,-0.90082649,-0.11551593},
	{-0.41853042,-0.90082649,0.11551593},
	{0.14383708,-0.84126217,-0.52114188},
	{-0.97769687,-6.8414479e-2,0.19856559},
	{-0.70245239,0.11454809,-0.70245239},
	{0.19856559,-6.8414479e-2,-0.97769687},
	{-0.21072881,-4.4203912e-2,-0.97654461},
	{0.70245239,0.11454809,-0.70245239},
	{0.98029433,-9.1800273e-2,0.17491639},
	{-0.23617525,-0.46044063,-0.85569602},
	{0.66899927,-0.71996232,0.18464626},
	{0.17974472,0.97451739,0.13419274},
	{0.65067844,0.31003263,-0.69317916},
	{-0.47869425,0.17467480,0.86043043},
	{0.58985565,0.13105765,-0.79680249},
	{-0.78050393,0.12610187,-0.61230053},
	{0.95172158,0.13577663,0.27530117},
	{0.84491337,4.9691113e-2,0.53259007},
	{0.71643332,0.53250467,0.45073504},
	{0.46514434,0.66053909,-0.58934612},
	{-0.65137817,0.56345246,-0.50816120},
	{-0.37079008,0.71232904,0.59590441},
};
//o cube1
material(mtl_tower::m_New_Material);
glBegin(GL_POLYGON);
	glNormal3fv(normals[0]);
	glVertex3fv(vertices[0]);
	glNormal3fv(normals[28]);
	glVertex3fv(vertices[28]);
	glNormal3fv(normals[1]);
	glVertex3fv(vertices[1]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[0]);
	glVertex3fv(vertices[0]);
	glNormal3fv(normals[29]);
	glVertex3fv(vertices[29]);
	glNormal3fv(normals[28]);
	glVertex3fv(vertices[28]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[1]);
	glVertex3fv(vertices[1]);
	glNormal3fv(normals[28]);
	glVertex3fv(vertices[28]);
	glNormal3fv(normals[30]);
	glVertex3fv(vertices[30]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[1]);
	glVertex3fv(vertices[1]);
	glNormal3fv(normals[29]);
	glVertex3fv(vertices[29]);
	glNormal3fv(normals[0]);
	glVertex3fv(vertices[0]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[2]);
	glVertex3fv(vertices[2]);
	glNormal3fv(normals[33]);
	glVertex3fv(vertices[33]);
	glNormal3fv(normals[3]);
	glVertex3fv(vertices[3]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[3]);
	glVertex3fv(vertices[3]);
	glNormal3fv(normals[33]);
	glVertex3fv(vertices[33]);
	glNormal3fv(normals[36]);
	glVertex3fv(vertices[36]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[3]);
	glVertex3fv(vertices[3]);
	glNormal3fv(normals[34]);
	glVertex3fv(vertices[34]);
	glNormal3fv(normals[2]);
	glVertex3fv(vertices[2]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[3]);
	glVertex3fv(vertices[3]);
	glNormal3fv(normals[36]);
	glVertex3fv(vertices[36]);
	glNormal3fv(normals[37]);
	glVertex3fv(vertices[37]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[4]);
	glVertex3fv(vertices[4]);
	glNormal3fv(normals[40]);
	glVertex3fv(vertices[40]);
	glNormal3fv(normals[5]);
	glVertex3fv(vertices[5]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[4]);
	glVertex3fv(vertices[4]);
	glNormal3fv(normals[42]);
	glVertex3fv(vertices[42]);
	glNormal3fv(normals[39]);
	glVertex3fv(vertices[39]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[5]);
	glVertex3fv(vertices[5]);
	glNormal3fv(normals[42]);
	glVertex3fv(vertices[42]);
	glNormal3fv(normals[4]);
	glVertex3fv(vertices[4]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[6]);
	glVertex3fv(vertices[6]);
	glNormal3fv(normals[46]);
	glVertex3fv(vertices[46]);
	glNormal3fv(normals[43]);
	glVertex3fv(vertices[43]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[6]);
	glVertex3fv(vertices[6]);
	glNormal3fv(normals[47]);
	glVertex3fv(vertices[47]);
	glNormal3fv(normals[7]);
	glVertex3fv(vertices[7]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[7]);
	glVertex3fv(vertices[7]);
	glNormal3fv(normals[46]);
	glVertex3fv(vertices[46]);
	glNormal3fv(normals[6]);
	glVertex3fv(vertices[6]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[7]);
	glVertex3fv(vertices[7]);
	glNormal3fv(normals[47]);
	glVertex3fv(vertices[47]);
	glNormal3fv(normals[46]);
	glVertex3fv(vertices[46]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[8]);
	glVertex3fv(vertices[8]);
	glNormal3fv(normals[12]);
	glVertex3fv(vertices[12]);
	glNormal3fv(normals[11]);
	glVertex3fv(vertices[11]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[8]);
	glVertex3fv(vertices[8]);
	glNormal3fv(normals[30]);
	glVertex3fv(vertices[30]);
	glNormal3fv(normals[9]);
	glVertex3fv(vertices[9]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[8]);
	glVertex3fv(vertices[8]);
	glNormal3fv(normals[32]);
	glVertex3fv(vertices[32]);
	glNormal3fv(normals[31]);
	glVertex3fv(vertices[31]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[9]);
	glVertex3fv(vertices[9]);
	glNormal3fv(normals[12]);
	glVertex3fv(vertices[12]);
	glNormal3fv(normals[8]);
	glVertex3fv(vertices[8]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[9]);
	glVertex3fv(vertices[9]);
	glNormal3fv(normals[33]);
	glVertex3fv(vertices[33]);
	glNormal3fv(normals[35]);
	glVertex3fv(vertices[35]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[9]);
	glVertex3fv(vertices[9]);
	glNormal3fv(normals[45]);
	glVertex3fv(vertices[45]);
	glNormal3fv(normals[10]);
	glVertex3fv(vertices[10]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[10]);
	glVertex3fv(vertices[10]);
	glNormal3fv(normals[14]);
	glVertex3fv(vertices[14]);
	glNormal3fv(normals[9]);
	glVertex3fv(vertices[9]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[10]);
	glVertex3fv(vertices[10]);
	glNormal3fv(normals[42]);
	glVertex3fv(vertices[42]);
	glNormal3fv(normals[11]);
	glVertex3fv(vertices[11]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[10]);
	glVertex3fv(vertices[10]);
	glNormal3fv(normals[45]);
	glVertex3fv(vertices[45]);
	glNormal3fv(normals[44]);
	glVertex3fv(vertices[44]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[11]);
	glVertex3fv(vertices[11]);
	glNormal3fv(normals[14]);
	glVertex3fv(vertices[14]);
	glNormal3fv(normals[10]);
	glVertex3fv(vertices[10]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[11]);
	glVertex3fv(vertices[11]);
	glNormal3fv(normals[40]);
	glVertex3fv(vertices[40]);
	glNormal3fv(normals[8]);
	glVertex3fv(vertices[8]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[11]);
	glVertex3fv(vertices[11]);
	glNormal3fv(normals[42]);
	glVertex3fv(vertices[42]);
	glNormal3fv(normals[41]);
	glVertex3fv(vertices[41]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[12]);
	glVertex3fv(vertices[12]);
	glNormal3fv(normals[9]);
	glVertex3fv(vertices[9]);
	glNormal3fv(normals[13]);
	glVertex3fv(vertices[13]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[13]);
	glVertex3fv(vertices[13]);
	glNormal3fv(normals[9]);
	glVertex3fv(vertices[9]);
	glNormal3fv(normals[14]);
	glVertex3fv(vertices[14]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[14]);
	glVertex3fv(vertices[14]);
	glNormal3fv(normals[11]);
	glVertex3fv(vertices[11]);
	glNormal3fv(normals[15]);
	glVertex3fv(vertices[15]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[15]);
	glVertex3fv(vertices[15]);
	glNormal3fv(normals[11]);
	glVertex3fv(vertices[11]);
	glNormal3fv(normals[12]);
	glVertex3fv(vertices[12]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[16]);
	glVertex3fv(vertices[16]);
	glNormal3fv(normals[20]);
	glVertex3fv(vertices[20]);
	glNormal3fv(normals[19]);
	glVertex3fv(vertices[19]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[17]);
	glVertex3fv(vertices[17]);
	glNormal3fv(normals[20]);
	glVertex3fv(vertices[20]);
	glNormal3fv(normals[16]);
	glVertex3fv(vertices[16]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[18]);
	glVertex3fv(vertices[18]);
	glNormal3fv(normals[22]);
	glVertex3fv(vertices[22]);
	glNormal3fv(normals[17]);
	glVertex3fv(vertices[17]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[19]);
	glVertex3fv(vertices[19]);
	glNormal3fv(normals[22]);
	glVertex3fv(vertices[22]);
	glNormal3fv(normals[18]);
	glVertex3fv(vertices[18]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[20]);
	glVertex3fv(vertices[20]);
	glNormal3fv(normals[17]);
	glVertex3fv(vertices[17]);
	glNormal3fv(normals[21]);
	glVertex3fv(vertices[21]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[20]);
	glVertex3fv(vertices[20]);
	glNormal3fv(normals[27]);
	glVertex3fv(vertices[27]);
	glNormal3fv(normals[23]);
	glVertex3fv(vertices[23]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[21]);
	glVertex3fv(vertices[21]);
	glNormal3fv(normals[17]);
	glVertex3fv(vertices[17]);
	glNormal3fv(normals[22]);
	glVertex3fv(vertices[22]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[21]);
	glVertex3fv(vertices[21]);
	glNormal3fv(normals[25]);
	glVertex3fv(vertices[25]);
	glNormal3fv(normals[20]);
	glVertex3fv(vertices[20]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[21]);
	glVertex3fv(vertices[21]);
	glNormal3fv(normals[49]);
	glVertex3fv(vertices[49]);
	glNormal3fv(normals[25]);
	glVertex3fv(vertices[25]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[22]);
	glVertex3fv(vertices[22]);
	glNormal3fv(normals[19]);
	glVertex3fv(vertices[19]);
	glNormal3fv(normals[23]);
	glVertex3fv(vertices[23]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[22]);
	glVertex3fv(vertices[22]);
	glNormal3fv(normals[49]);
	glVertex3fv(vertices[49]);
	glNormal3fv(normals[21]);
	glVertex3fv(vertices[21]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[23]);
	glVertex3fv(vertices[23]);
	glNormal3fv(normals[19]);
	glVertex3fv(vertices[19]);
	glNormal3fv(normals[20]);
	glVertex3fv(vertices[20]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[23]);
	glVertex3fv(vertices[23]);
	glNormal3fv(normals[49]);
	glVertex3fv(vertices[49]);
	glNormal3fv(normals[22]);
	glVertex3fv(vertices[22]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[24]);
	glVertex3fv(vertices[24]);
	glNormal3fv(normals[20]);
	glVertex3fv(vertices[20]);
	glNormal3fv(normals[25]);
	glVertex3fv(vertices[25]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[24]);
	glVertex3fv(vertices[24]);
	glNormal3fv(normals[27]);
	glVertex3fv(vertices[27]);
	glNormal3fv(normals[20]);
	glVertex3fv(vertices[20]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[24]);
	glVertex3fv(vertices[24]);
	glNormal3fv(normals[48]);
	glVertex3fv(vertices[48]);
	glNormal3fv(normals[27]);
	glVertex3fv(vertices[27]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[25]);
	glVertex3fv(vertices[25]);
	glNormal3fv(normals[48]);
	glVertex3fv(vertices[48]);
	glNormal3fv(normals[24]);
	glVertex3fv(vertices[24]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[25]);
	glVertex3fv(vertices[25]);
	glNormal3fv(normals[53]);
	glVertex3fv(vertices[53]);
	glNormal3fv(normals[48]);
	glVertex3fv(vertices[48]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[26]);
	glVertex3fv(vertices[26]);
	glNormal3fv(normals[27]);
	glVertex3fv(vertices[27]);
	glNormal3fv(normals[48]);
	glVertex3fv(vertices[48]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[26]);
	glVertex3fv(vertices[26]);
	glNormal3fv(normals[49]);
	glVertex3fv(vertices[49]);
	glNormal3fv(normals[27]);
	glVertex3fv(vertices[27]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[27]);
	glVertex3fv(vertices[27]);
	glNormal3fv(normals[49]);
	glVertex3fv(vertices[49]);
	glNormal3fv(normals[23]);
	glVertex3fv(vertices[23]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[28]);
	glVertex3fv(vertices[28]);
	glNormal3fv(normals[29]);
	glVertex3fv(vertices[29]);
	glNormal3fv(normals[36]);
	glVertex3fv(vertices[36]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[29]);
	glVertex3fv(vertices[29]);
	glNormal3fv(normals[40]);
	glVertex3fv(vertices[40]);
	glNormal3fv(normals[38]);
	glVertex3fv(vertices[38]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[30]);
	glVertex3fv(vertices[30]);
	glNormal3fv(normals[28]);
	glVertex3fv(vertices[28]);
	glNormal3fv(normals[33]);
	glVertex3fv(vertices[33]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[31]);
	glVertex3fv(vertices[31]);
	glNormal3fv(normals[30]);
	glVertex3fv(vertices[30]);
	glNormal3fv(normals[8]);
	glVertex3fv(vertices[8]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[32]);
	glVertex3fv(vertices[32]);
	glNormal3fv(normals[8]);
	glVertex3fv(vertices[8]);
	glNormal3fv(normals[40]);
	glVertex3fv(vertices[40]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[32]);
	glVertex3fv(vertices[32]);
	glNormal3fv(normals[29]);
	glVertex3fv(vertices[29]);
	glNormal3fv(normals[1]);
	glVertex3fv(vertices[1]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[33]);
	glVertex3fv(vertices[33]);
	glNormal3fv(normals[9]);
	glVertex3fv(vertices[9]);
	glNormal3fv(normals[30]);
	glVertex3fv(vertices[30]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[34]);
	glVertex3fv(vertices[34]);
	glNormal3fv(normals[47]);
	glVertex3fv(vertices[47]);
	glNormal3fv(normals[45]);
	glVertex3fv(vertices[45]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[35]);
	glVertex3fv(vertices[35]);
	glNormal3fv(normals[34]);
	glVertex3fv(vertices[34]);
	glNormal3fv(normals[9]);
	glVertex3fv(vertices[9]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[36]);
	glVertex3fv(vertices[36]);
	glNormal3fv(normals[29]);
	glVertex3fv(vertices[29]);
	glNormal3fv(normals[37]);
	glVertex3fv(vertices[37]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[36]);
	glVertex3fv(vertices[36]);
	glNormal3fv(normals[33]);
	glVertex3fv(vertices[33]);
	glNormal3fv(normals[28]);
	glVertex3fv(vertices[28]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[37]);
	glVertex3fv(vertices[37]);
	glNormal3fv(normals[34]);
	glVertex3fv(vertices[34]);
	glNormal3fv(normals[3]);
	glVertex3fv(vertices[3]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[37]);
	glVertex3fv(vertices[37]);
	glNormal3fv(normals[38]);
	glVertex3fv(vertices[38]);
	glNormal3fv(normals[47]);
	glVertex3fv(vertices[47]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[38]);
	glVertex3fv(vertices[38]);
	glNormal3fv(normals[37]);
	glVertex3fv(vertices[37]);
	glNormal3fv(normals[29]);
	glVertex3fv(vertices[29]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[38]);
	glVertex3fv(vertices[38]);
	glNormal3fv(normals[40]);
	glVertex3fv(vertices[40]);
	glNormal3fv(normals[4]);
	glVertex3fv(vertices[4]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[39]);
	glVertex3fv(vertices[39]);
	glNormal3fv(normals[38]);
	glVertex3fv(vertices[38]);
	glNormal3fv(normals[4]);
	glVertex3fv(vertices[4]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[39]);
	glVertex3fv(vertices[39]);
	glNormal3fv(normals[42]);
	glVertex3fv(vertices[42]);
	glNormal3fv(normals[46]);
	glVertex3fv(vertices[46]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[39]);
	glVertex3fv(vertices[39]);
	glNormal3fv(normals[47]);
	glVertex3fv(vertices[47]);
	glNormal3fv(normals[38]);
	glVertex3fv(vertices[38]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[40]);
	glVertex3fv(vertices[40]);
	glNormal3fv(normals[29]);
	glVertex3fv(vertices[29]);
	glNormal3fv(normals[32]);
	glVertex3fv(vertices[32]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[41]);
	glVertex3fv(vertices[41]);
	glNormal3fv(normals[40]);
	glVertex3fv(vertices[40]);
	glNormal3fv(normals[11]);
	glVertex3fv(vertices[11]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[42]);
	glVertex3fv(vertices[42]);
	glNormal3fv(normals[10]);
	glVertex3fv(vertices[10]);
	glNormal3fv(normals[43]);
	glVertex3fv(vertices[43]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[43]);
	glVertex3fv(vertices[43]);
	glNormal3fv(normals[46]);
	glVertex3fv(vertices[46]);
	glNormal3fv(normals[42]);
	glVertex3fv(vertices[42]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[44]);
	glVertex3fv(vertices[44]);
	glNormal3fv(normals[43]);
	glVertex3fv(vertices[43]);
	glNormal3fv(normals[10]);
	glVertex3fv(vertices[10]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[45]);
	glVertex3fv(vertices[45]);
	glNormal3fv(normals[9]);
	glVertex3fv(vertices[9]);
	glNormal3fv(normals[34]);
	glVertex3fv(vertices[34]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[45]);
	glVertex3fv(vertices[45]);
	glNormal3fv(normals[47]);
	glVertex3fv(vertices[47]);
	glNormal3fv(normals[6]);
	glVertex3fv(vertices[6]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[46]);
	glVertex3fv(vertices[46]);
	glNormal3fv(normals[47]);
	glVertex3fv(vertices[47]);
	glNormal3fv(normals[39]);
	glVertex3fv(vertices[39]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[47]);
	glVertex3fv(vertices[47]);
	glNormal3fv(normals[34]);
	glVertex3fv(vertices[34]);
	glNormal3fv(normals[37]);
	glVertex3fv(vertices[37]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[53]);
	glVertex3fv(vertices[53]);
	glNormal3fv(normals[25]);
	glVertex3fv(vertices[25]);
	glNormal3fv(normals[49]);
	glVertex3fv(vertices[49]);
glEnd();
material(mtl_tower::m_antenna);
glBegin(GL_POLYGON);
	glNormal3fv(normals[26]);
	glVertex3fv(vertices[26]);
	glNormal3fv(normals[51]);
	glVertex3fv(vertices[51]);
	glNormal3fv(normals[49]);
	glVertex3fv(vertices[49]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[48]);
	glVertex3fv(vertices[48]);
	glNormal3fv(normals[50]);
	glVertex3fv(vertices[50]);
	glNormal3fv(normals[26]);
	glVertex3fv(vertices[26]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[50]);
	glVertex3fv(vertices[50]);
	glNormal3fv(normals[53]);
	glVertex3fv(vertices[53]);
	glNormal3fv(normals[54]);
	glVertex3fv(vertices[54]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[50]);
	glVertex3fv(vertices[50]);
	glNormal3fv(normals[57]);
	glVertex3fv(vertices[57]);
	glNormal3fv(normals[52]);
	glVertex3fv(vertices[52]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[51]);
	glVertex3fv(vertices[51]);
	glNormal3fv(normals[26]);
	glVertex3fv(vertices[26]);
	glNormal3fv(normals[52]);
	glVertex3fv(vertices[52]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[51]);
	glVertex3fv(vertices[51]);
	glNormal3fv(normals[53]);
	glVertex3fv(vertices[53]);
	glNormal3fv(normals[49]);
	glVertex3fv(vertices[49]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[51]);
	glVertex3fv(vertices[51]);
	glNormal3fv(normals[55]);
	glVertex3fv(vertices[55]);
	glNormal3fv(normals[54]);
	glVertex3fv(vertices[54]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[52]);
	glVertex3fv(vertices[52]);
	glNormal3fv(normals[26]);
	glVertex3fv(vertices[26]);
	glNormal3fv(normals[50]);
	glVertex3fv(vertices[50]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[52]);
	glVertex3fv(vertices[52]);
	glNormal3fv(normals[57]);
	glVertex3fv(vertices[57]);
	glNormal3fv(normals[51]);
	glVertex3fv(vertices[51]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[53]);
	glVertex3fv(vertices[53]);
	glNormal3fv(normals[50]);
	glVertex3fv(vertices[50]);
	glNormal3fv(normals[48]);
	glVertex3fv(vertices[48]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[54]);
	glVertex3fv(vertices[54]);
	glNormal3fv(normals[53]);
	glVertex3fv(vertices[53]);
	glNormal3fv(normals[51]);
	glVertex3fv(vertices[51]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[54]);
	glVertex3fv(vertices[54]);
	glNormal3fv(normals[55]);
	glVertex3fv(vertices[55]);
	glNormal3fv(normals[50]);
	glVertex3fv(vertices[50]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[55]);
	glVertex3fv(vertices[55]);
	glNormal3fv(normals[51]);
	glVertex3fv(vertices[51]);
	glNormal3fv(normals[56]);
	glVertex3fv(vertices[56]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[56]);
	glVertex3fv(vertices[56]);
	glNormal3fv(normals[51]);
	glVertex3fv(vertices[51]);
	glNormal3fv(normals[57]);
	glVertex3fv(vertices[57]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[56]);
	glVertex3fv(vertices[56]);
	glNormal3fv(normals[57]);
	glVertex3fv(vertices[57]);
	glNormal3fv(normals[55]);
	glVertex3fv(vertices[55]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[57]);
	glVertex3fv(vertices[57]);
	glNormal3fv(normals[50]);
	glVertex3fv(vertices[50]);
	glNormal3fv(normals[58]);
	glVertex3fv(vertices[58]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[58]);
	glVertex3fv(vertices[58]);
	glNormal3fv(normals[50]);
	glVertex3fv(vertices[50]);
	glNormal3fv(normals[55]);
	glVertex3fv(vertices[55]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[58]);
	glVertex3fv(vertices[58]);
	glNormal3fv(normals[55]);
	glVertex3fv(vertices[55]);
	glNormal3fv(normals[57]);
	glVertex3fv(vertices[57]);
glEnd();
material(mtl_tower::m_deco);
glBegin(GL_POLYGON);
	glNormal3fv(normals[1]);
	glVertex3fv(vertices[1]);
	glNormal3fv(normals[31]);
	glVertex3fv(vertices[31]);
	glNormal3fv(normals[32]);
	glVertex3fv(vertices[32]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[5]);
	glVertex3fv(vertices[5]);
	glNormal3fv(normals[40]);
	glVertex3fv(vertices[40]);
	glNormal3fv(normals[41]);
	glVertex3fv(vertices[41]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[5]);
	glVertex3fv(vertices[5]);
	glNormal3fv(normals[41]);
	glVertex3fv(vertices[41]);
	glNormal3fv(normals[42]);
	glVertex3fv(vertices[42]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[6]);
	glVertex3fv(vertices[6]);
	glNormal3fv(normals[43]);
	glVertex3fv(vertices[43]);
	glNormal3fv(normals[44]);
	glVertex3fv(vertices[44]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[30]);
	glVertex3fv(vertices[30]);
	glNormal3fv(normals[31]);
	glVertex3fv(vertices[31]);
	glNormal3fv(normals[1]);
	glVertex3fv(vertices[1]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[34]);
	glVertex3fv(vertices[34]);
	glNormal3fv(normals[35]);
	glVertex3fv(vertices[35]);
	glNormal3fv(normals[2]);
	glVertex3fv(vertices[2]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[35]);
	glVertex3fv(vertices[35]);
	glNormal3fv(normals[33]);
	glVertex3fv(vertices[33]);
	glNormal3fv(normals[2]);
	glVertex3fv(vertices[2]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[44]);
	glVertex3fv(vertices[44]);
	glNormal3fv(normals[45]);
	glVertex3fv(vertices[45]);
	glNormal3fv(normals[6]);
	glVertex3fv(vertices[6]);
glEnd();
material(mtl_tower::m_window);
glBegin(GL_POLYGON);
	glNormal3fv(normals[12]);
	glVertex3fv(vertices[12]);
	glNormal3fv(normals[19]);
	glVertex3fv(vertices[19]);
	glNormal3fv(normals[15]);
	glVertex3fv(vertices[15]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[13]);
	glVertex3fv(vertices[13]);
	glNormal3fv(normals[17]);
	glVertex3fv(vertices[17]);
	glNormal3fv(normals[12]);
	glVertex3fv(vertices[12]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[14]);
	glVertex3fv(vertices[14]);
	glNormal3fv(normals[17]);
	glVertex3fv(vertices[17]);
	glNormal3fv(normals[13]);
	glVertex3fv(vertices[13]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[15]);
	glVertex3fv(vertices[15]);
	glNormal3fv(normals[19]);
	glVertex3fv(vertices[19]);
	glNormal3fv(normals[14]);
	glVertex3fv(vertices[14]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[16]);
	glVertex3fv(vertices[16]);
	glNormal3fv(normals[12]);
	glVertex3fv(vertices[12]);
	glNormal3fv(normals[17]);
	glVertex3fv(vertices[17]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[16]);
	glVertex3fv(vertices[16]);
	glNormal3fv(normals[19]);
	glVertex3fv(vertices[19]);
	glNormal3fv(normals[12]);
	glVertex3fv(vertices[12]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[17]);
	glVertex3fv(vertices[17]);
	glNormal3fv(normals[14]);
	glVertex3fv(vertices[14]);
	glNormal3fv(normals[18]);
	glVertex3fv(vertices[18]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[18]);
	glVertex3fv(vertices[18]);
	glNormal3fv(normals[14]);
	glVertex3fv(vertices[14]);
	glNormal3fv(normals[19]);
	glVertex3fv(vertices[19]);
glEnd();
}
} //namespace
