/* $Id: PackageBody.hpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __PACKAGE_BODY_HPP_INCLUDED
#define __PACKAGE_BODY_HPP_INCLUDED

#include "frontend/ast/LibUnit.hpp"

namespace ast {

//! VHDL package body declaration
/** This class represents a VHDL package body declaration.
 */
class PackageBody : public LibUnit {
public:
	//! c'tor
	/** 
	 * @param declName name of the declared symbol.
	 * @param libs library clauses
         * @param useCs use clauses
         * @param decls local declarations.
         * @param loc location of the declaration.
         */
	PackageBody(
		std::string* declName,
		std::list<SimpleName*> *libs,
		std::list<Name*> *useCs,
		std::list<SymbolDeclaration*> *decls,
		Location loc
		) : 	LibUnit(declName, libs, useCs, decls, loc) {}

	//! Accept a Visitor.
	//
 	/** All leaf AST nodes need to implement this method.
         *
         *  @param visitor the Visitor that can visit this node.
         */
	virtual void accept(Visitor& visitor) {
		visitor.visit(*this);
	}

	/** Put a textual representation of the AstNode on the stream.
	 *  @param stream stream to put the textual representation to.
	 */
	virtual void put(std::ostream &stream) const {
		assert(this->name);
		stream << "PACKAGE BODY " << *this->name;

	}

};

}; /* namespace ast */

#endif /* __PACKAGE_BODY_HPP_INCLUDED */
