/* -------------------------------------------
     This file was created with csUtility.java

    Unicode mapping table generated from java mapping and UnicodeData.txt

#    Name:     Cp864 to Unicode table
#    Unicode version: Java 1.3

 * The contents of this file are subject to the Interbase Public
 * License Version 1.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy
 * of the License at http://www.Inprise.com/IPL.html
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * The Original Code was created by Inprise Corporation
 * and its predecessors. Portions created by Inprise Corporation are
 * Copyright (C) Inprise Corporation.
 *
 * All Rights Reserved.
 * Contributor(s): Blas Rodriguez Somoza.
   -------------------------------------------- */
static const int CANT_MAP_CHARACTER = 0;

static const USHORT to_unicode_map[256] = {
/* 00 */  0x0000 /*                                          NULL */,
/* 01 */  0x0001 /*                              START OF HEADING */,
/* 02 */  0x0002 /*                                 START OF TEXT */,
/* 03 */  0x0003 /*                                   END OF TEXT */,
/* 04 */  0x0004 /*                           END OF TRANSMISSION */,
/* 05 */  0x0005 /*                                       ENQUIRY */,
/* 06 */  0x0006 /*                                   ACKNOWLEDGE */,
/* 07 */  0x0007 /*                                          BELL */,
/* 08 */  0x0008 /*                                     BACKSPACE */,
/* 09 */  0x0009 /*                          CHARACTER TABULATION */,
/* 0A */  0x000A /*                                LINE FEED (LF) */,
/* 0B */  0x000B /*                               LINE TABULATION */,
/* 0C */  0x000C /*                                FORM FEED (FF) */,
/* 0D */  0x000D /*                          CARRIAGE RETURN (CR) */,
/* 0E */  0x000E /*                                     SHIFT OUT */,
/* 0F */  0x000F /*                                      SHIFT IN */,
/* 10 */  0x0010 /*                              DATA LINK ESCAPE */,
/* 11 */  0x0011 /*                            DEVICE CONTROL ONE */,
/* 12 */  0x0012 /*                            DEVICE CONTROL TWO */,
/* 13 */  0x0013 /*                          DEVICE CONTROL THREE */,
/* 14 */  0x0014 /*                           DEVICE CONTROL FOUR */,
/* 15 */  0x0015 /*                          NEGATIVE ACKNOWLEDGE */,
/* 16 */  0x0016 /*                              SYNCHRONOUS IDLE */,
/* 17 */  0x0017 /*                     END OF TRANSMISSION BLOCK */,
/* 18 */  0x0018 /*                                        CANCEL */,
/* 19 */  0x0019 /*                                 END OF MEDIUM */,
/* 1A */  0x001A /*                                    SUBSTITUTE */,
/* 1B */  0x001B /*                                        ESCAPE */,
/* 1C */  0x001C /*                    INFORMATION SEPARATOR FOUR */,
/* 1D */  0x001D /*                   INFORMATION SEPARATOR THREE */,
/* 1E */  0x001E /*                     INFORMATION SEPARATOR TWO */,
/* 1F */  0x001F /*                     INFORMATION SEPARATOR ONE */,
/* 20 */  0x0020 /*                                         SPACE */,
/* 21 */  0x0021 /*                              EXCLAMATION MARK */,
/* 22 */  0x0022 /*                                QUOTATION MARK */,
/* 23 */  0x0023 /*                                   NUMBER SIGN */,
/* 24 */  0x0024 /*                                   DOLLAR SIGN */,
/* 25 */  0x066A /*                           ARABIC PERCENT SIGN */,
/* 26 */  0x0026 /*                                     AMPERSAND */,
/* 27 */  0x0027 /*                                    APOSTROPHE */,
/* 28 */  0x0028 /*                              LEFT PARENTHESIS */,
/* 29 */  0x0029 /*                             RIGHT PARENTHESIS */,
/* 2A */  0x002A /*                                      ASTERISK */,
/* 2B */  0x002B /*                                     PLUS SIGN */,
/* 2C */  0x002C /*                                         COMMA */,
/* 2D */  0x002D /*                                  HYPHEN-MINUS */,
/* 2E */  0x002E /*                                     FULL STOP */,
/* 2F */  0x002F /*                                       SOLIDUS */,
/* 30 */  0x0030 /*                                    DIGIT ZERO */,
/* 31 */  0x0031 /*                                     DIGIT ONE */,
/* 32 */  0x0032 /*                                     DIGIT TWO */,
/* 33 */  0x0033 /*                                   DIGIT THREE */,
/* 34 */  0x0034 /*                                    DIGIT FOUR */,
/* 35 */  0x0035 /*                                    DIGIT FIVE */,
/* 36 */  0x0036 /*                                     DIGIT SIX */,
/* 37 */  0x0037 /*                                   DIGIT SEVEN */,
/* 38 */  0x0038 /*                                   DIGIT EIGHT */,
/* 39 */  0x0039 /*                                    DIGIT NINE */,
/* 3A */  0x003A /*                                         COLON */,
/* 3B */  0x003B /*                                     SEMICOLON */,
/* 3C */  0x003C /*                                LESS-THAN SIGN */,
/* 3D */  0x003D /*                                   EQUALS SIGN */,
/* 3E */  0x003E /*                             GREATER-THAN SIGN */,
/* 3F */  0x003F /*                                 QUESTION MARK */,
/* 40 */  0x0040 /*                                 COMMERCIAL AT */,
/* 41 */  0x0041 /*                        LATIN CAPITAL LETTER A */,
/* 42 */  0x0042 /*                        LATIN CAPITAL LETTER B */,
/* 43 */  0x0043 /*                        LATIN CAPITAL LETTER C */,
/* 44 */  0x0044 /*                        LATIN CAPITAL LETTER D */,
/* 45 */  0x0045 /*                        LATIN CAPITAL LETTER E */,
/* 46 */  0x0046 /*                        LATIN CAPITAL LETTER F */,
/* 47 */  0x0047 /*                        LATIN CAPITAL LETTER G */,
/* 48 */  0x0048 /*                        LATIN CAPITAL LETTER H */,
/* 49 */  0x0049 /*                        LATIN CAPITAL LETTER I */,
/* 4A */  0x004A /*                        LATIN CAPITAL LETTER J */,
/* 4B */  0x004B /*                        LATIN CAPITAL LETTER K */,
/* 4C */  0x004C /*                        LATIN CAPITAL LETTER L */,
/* 4D */  0x004D /*                        LATIN CAPITAL LETTER M */,
/* 4E */  0x004E /*                        LATIN CAPITAL LETTER N */,
/* 4F */  0x004F /*                        LATIN CAPITAL LETTER O */,
/* 50 */  0x0050 /*                        LATIN CAPITAL LETTER P */,
/* 51 */  0x0051 /*                        LATIN CAPITAL LETTER Q */,
/* 52 */  0x0052 /*                        LATIN CAPITAL LETTER R */,
/* 53 */  0x0053 /*                        LATIN CAPITAL LETTER S */,
/* 54 */  0x0054 /*                        LATIN CAPITAL LETTER T */,
/* 55 */  0x0055 /*                        LATIN CAPITAL LETTER U */,
/* 56 */  0x0056 /*                        LATIN CAPITAL LETTER V */,
/* 57 */  0x0057 /*                        LATIN CAPITAL LETTER W */,
/* 58 */  0x0058 /*                        LATIN CAPITAL LETTER X */,
/* 59 */  0x0059 /*                        LATIN CAPITAL LETTER Y */,
/* 5A */  0x005A /*                        LATIN CAPITAL LETTER Z */,
/* 5B */  0x005B /*                           LEFT SQUARE BRACKET */,
/* 5C */  0x005C /*                               REVERSE SOLIDUS */,
/* 5D */  0x005D /*                          RIGHT SQUARE BRACKET */,
/* 5E */  0x005E /*                             CIRCUMFLEX ACCENT */,
/* 5F */  0x005F /*                                      LOW LINE */,
/* 60 */  0x0060 /*                                  GRAVE ACCENT */,
/* 61 */  0x0061 /*                          LATIN SMALL LETTER A */,
/* 62 */  0x0062 /*                          LATIN SMALL LETTER B */,
/* 63 */  0x0063 /*                          LATIN SMALL LETTER C */,
/* 64 */  0x0064 /*                          LATIN SMALL LETTER D */,
/* 65 */  0x0065 /*                          LATIN SMALL LETTER E */,
/* 66 */  0x0066 /*                          LATIN SMALL LETTER F */,
/* 67 */  0x0067 /*                          LATIN SMALL LETTER G */,
/* 68 */  0x0068 /*                          LATIN SMALL LETTER H */,
/* 69 */  0x0069 /*                          LATIN SMALL LETTER I */,
/* 6A */  0x006A /*                          LATIN SMALL LETTER J */,
/* 6B */  0x006B /*                          LATIN SMALL LETTER K */,
/* 6C */  0x006C /*                          LATIN SMALL LETTER L */,
/* 6D */  0x006D /*                          LATIN SMALL LETTER M */,
/* 6E */  0x006E /*                          LATIN SMALL LETTER N */,
/* 6F */  0x006F /*                          LATIN SMALL LETTER O */,
/* 70 */  0x0070 /*                          LATIN SMALL LETTER P */,
/* 71 */  0x0071 /*                          LATIN SMALL LETTER Q */,
/* 72 */  0x0072 /*                          LATIN SMALL LETTER R */,
/* 73 */  0x0073 /*                          LATIN SMALL LETTER S */,
/* 74 */  0x0074 /*                          LATIN SMALL LETTER T */,
/* 75 */  0x0075 /*                          LATIN SMALL LETTER U */,
/* 76 */  0x0076 /*                          LATIN SMALL LETTER V */,
/* 77 */  0x0077 /*                          LATIN SMALL LETTER W */,
/* 78 */  0x0078 /*                          LATIN SMALL LETTER X */,
/* 79 */  0x0079 /*                          LATIN SMALL LETTER Y */,
/* 7A */  0x007A /*                          LATIN SMALL LETTER Z */,
/* 7B */  0x007B /*                            LEFT CURLY BRACKET */,
/* 7C */  0x007C /*                                 VERTICAL LINE */,
/* 7D */  0x007D /*                           RIGHT CURLY BRACKET */,
/* 7E */  0x007E /*                                         TILDE */,
/* 7F */  0x007F /*                                        DELETE */,
/* 80 */  0x00B0 /*                                   DEGREE SIGN */,
/* 81 */  0x00B7 /*                                    MIDDLE DOT */,
/* 82 */  0x2219 /*                               BULLET OPERATOR */,
/* 83 */  0x221A /*                                   SQUARE ROOT */,
/* 84 */  0x2592 /*                                  MEDIUM SHADE */,
/* 85 */  0x2500 /*                 BOX DRAWINGS LIGHT HORIZONTAL */,
/* 86 */  0x2502 /*                   BOX DRAWINGS LIGHT VERTICAL */,
/* 87 */  0x253C /*    BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL */,
/* 88 */  0x2524 /*          BOX DRAWINGS LIGHT VERTICAL AND LEFT */,
/* 89 */  0x252C /*        BOX DRAWINGS LIGHT DOWN AND HORIZONTAL */,
/* 8A */  0x251C /*         BOX DRAWINGS LIGHT VERTICAL AND RIGHT */,
/* 8B */  0x2534 /*          BOX DRAWINGS LIGHT UP AND HORIZONTAL */,
/* 8C */  0x2510 /*              BOX DRAWINGS LIGHT DOWN AND LEFT */,
/* 8D */  0x250C /*             BOX DRAWINGS LIGHT DOWN AND RIGHT */,
/* 8E */  0x2514 /*               BOX DRAWINGS LIGHT UP AND RIGHT */,
/* 8F */  0x2518 /*                BOX DRAWINGS LIGHT UP AND LEFT */,
/* 90 */  0x03B2 /*                       GREEK SMALL LETTER BETA */,
/* 91 */  0x221E /*                                      INFINITY */,
/* 92 */  0x03C6 /*                        GREEK SMALL LETTER PHI */,
/* 93 */  0x00B1 /*                               PLUS-MINUS SIGN */,
/* 94 */  0x00BD /*                      VULGAR FRACTION ONE HALF */,
/* 95 */  0x00BC /*                   VULGAR FRACTION ONE QUARTER */,
/* 96 */  0x2248 /*                               ALMOST EQUAL TO */,
/* 97 */  0x00AB /*     LEFT-POINTING DOUBLE ANGLE QUOTATION MARK */,
/* 98 */  0x00BB /*    RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK */,
/* 99 */  0xFEF7 /* ARABIC LIGATURE LAM WITH ALEF WITH HAMZA ABOVE ISOLATED FORM */,
/* 9A */  0xFEF8 /* ARABIC LIGATURE LAM WITH ALEF WITH HAMZA ABOVE FINAL FORM */,
/* 9B */     CANT_MAP_CHARACTER   ,
/* 9C */     CANT_MAP_CHARACTER   ,
/* 9D */  0xFEFB /*   ARABIC LIGATURE LAM WITH ALEF ISOLATED FORM */,
/* 9E */  0xFEFC /*      ARABIC LIGATURE LAM WITH ALEF FINAL FORM */,
/* 9F */     CANT_MAP_CHARACTER   ,
/* A0 */  0x00A0 /*                                NO-BREAK SPACE */,
/* A1 */  0x00AD /*                                   SOFT HYPHEN */,
/* A2 */  0xFE82 /* ARABIC LETTER ALEF WITH MADDA ABOVE FINAL FORM */,
/* A3 */  0x00A3 /*                                    POUND SIGN */,
/* A4 */  0x00A4 /*                                 CURRENCY SIGN */,
/* A5 */  0xFE84 /* ARABIC LETTER ALEF WITH HAMZA ABOVE FINAL FORM */,
/* A6 */     CANT_MAP_CHARACTER   ,
/* A7 */     CANT_MAP_CHARACTER   ,
/* A8 */  0xFE8E /*                 ARABIC LETTER ALEF FINAL FORM */,
/* A9 */  0xFE8F /*               ARABIC LETTER BEH ISOLATED FORM */,
/* AA */  0xFE95 /*               ARABIC LETTER TEH ISOLATED FORM */,
/* AB */  0xFE99 /*              ARABIC LETTER THEH ISOLATED FORM */,
/* AC */  0x060C /*                                  ARABIC COMMA */,
/* AD */  0xFE9D /*              ARABIC LETTER JEEM ISOLATED FORM */,
/* AE */  0xFEA1 /*               ARABIC LETTER HAH ISOLATED FORM */,
/* AF */  0xFEA5 /*              ARABIC LETTER KHAH ISOLATED FORM */,
/* B0 */  0x0660 /*                       ARABIC-INDIC DIGIT ZERO */,
/* B1 */  0x0661 /*                        ARABIC-INDIC DIGIT ONE */,
/* B2 */  0x0662 /*                        ARABIC-INDIC DIGIT TWO */,
/* B3 */  0x0663 /*                      ARABIC-INDIC DIGIT THREE */,
/* B4 */  0x0664 /*                       ARABIC-INDIC DIGIT FOUR */,
/* B5 */  0x0665 /*                       ARABIC-INDIC DIGIT FIVE */,
/* B6 */  0x0666 /*                        ARABIC-INDIC DIGIT SIX */,
/* B7 */  0x0667 /*                      ARABIC-INDIC DIGIT SEVEN */,
/* B8 */  0x0668 /*                      ARABIC-INDIC DIGIT EIGHT */,
/* B9 */  0x0669 /*                       ARABIC-INDIC DIGIT NINE */,
/* BA */  0xFED1 /*               ARABIC LETTER FEH ISOLATED FORM */,
/* BB */  0x061B /*                              ARABIC SEMICOLON */,
/* BC */  0xFEB1 /*              ARABIC LETTER SEEN ISOLATED FORM */,
/* BD */  0xFEB5 /*             ARABIC LETTER SHEEN ISOLATED FORM */,
/* BE */  0xFEB9 /*               ARABIC LETTER SAD ISOLATED FORM */,
/* BF */  0x061F /*                          ARABIC QUESTION MARK */,
/* C0 */  0x00A2 /*                                     CENT SIGN */,
/* C1 */  0xFE80 /*             ARABIC LETTER HAMZA ISOLATED FORM */,
/* C2 */  0xFE81 /* ARABIC LETTER ALEF WITH MADDA ABOVE ISOLATED FORM */,
/* C3 */  0xFE83 /* ARABIC LETTER ALEF WITH HAMZA ABOVE ISOLATED FORM */,
/* C4 */  0xFE85 /* ARABIC LETTER WAW WITH HAMZA ABOVE ISOLATED FORM */,
/* C5 */  0xFECA /*                  ARABIC LETTER AIN FINAL FORM */,
/* C6 */  0xFE8B /* ARABIC LETTER YEH WITH HAMZA ABOVE INITIAL FORM */,
/* C7 */  0xFE8D /*              ARABIC LETTER ALEF ISOLATED FORM */,
/* C8 */  0xFE91 /*                ARABIC LETTER BEH INITIAL FORM */,
/* C9 */  0xFE93 /*       ARABIC LETTER TEH MARBUTA ISOLATED FORM */,
/* CA */  0xFE97 /*                ARABIC LETTER TEH INITIAL FORM */,
/* CB */  0xFE9B /*               ARABIC LETTER THEH INITIAL FORM */,
/* CC */  0xFE9F /*               ARABIC LETTER JEEM INITIAL FORM */,
/* CD */  0xFEA3 /*                ARABIC LETTER HAH INITIAL FORM */,
/* CE */  0xFEA7 /*               ARABIC LETTER KHAH INITIAL FORM */,
/* CF */  0xFEA9 /*               ARABIC LETTER DAL ISOLATED FORM */,
/* D0 */  0xFEAB /*              ARABIC LETTER THAL ISOLATED FORM */,
/* D1 */  0xFEAD /*               ARABIC LETTER REH ISOLATED FORM */,
/* D2 */  0xFEAF /*              ARABIC LETTER ZAIN ISOLATED FORM */,
/* D3 */  0xFEB3 /*               ARABIC LETTER SEEN INITIAL FORM */,
/* D4 */  0xFEB7 /*              ARABIC LETTER SHEEN INITIAL FORM */,
/* D5 */  0xFEBB /*                ARABIC LETTER SAD INITIAL FORM */,
/* D6 */  0xFEBF /*                ARABIC LETTER DAD INITIAL FORM */,
/* D7 */  0xFEC1 /*               ARABIC LETTER TAH ISOLATED FORM */,
/* D8 */  0xFEC5 /*               ARABIC LETTER ZAH ISOLATED FORM */,
/* D9 */  0xFECB /*                ARABIC LETTER AIN INITIAL FORM */,
/* DA */  0xFECF /*              ARABIC LETTER GHAIN INITIAL FORM */,
/* DB */  0x00A6 /*                                    BROKEN BAR */,
/* DC */  0x00AC /*                                      NOT SIGN */,
/* DD */  0x00F7 /*                                 DIVISION SIGN */,
/* DE */  0x00D7 /*                           MULTIPLICATION SIGN */,
/* DF */  0xFEC9 /*               ARABIC LETTER AIN ISOLATED FORM */,
/* E0 */  0x0640 /*                                ARABIC TATWEEL */,
/* E1 */  0xFED3 /*                ARABIC LETTER FEH INITIAL FORM */,
/* E2 */  0xFED7 /*                ARABIC LETTER QAF INITIAL FORM */,
/* E3 */  0xFEDB /*                ARABIC LETTER KAF INITIAL FORM */,
/* E4 */  0xFEDF /*                ARABIC LETTER LAM INITIAL FORM */,
/* E5 */  0xFEE3 /*               ARABIC LETTER MEEM INITIAL FORM */,
/* E6 */  0xFEE7 /*               ARABIC LETTER NOON INITIAL FORM */,
/* E7 */  0xFEEB /*                ARABIC LETTER HEH INITIAL FORM */,
/* E8 */  0xFEED /*               ARABIC LETTER WAW ISOLATED FORM */,
/* E9 */  0xFEEF /*      ARABIC LETTER ALEF MAKSURA ISOLATED FORM */,
/* EA */  0xFEF3 /*                ARABIC LETTER YEH INITIAL FORM */,
/* EB */  0xFEBD /*               ARABIC LETTER DAD ISOLATED FORM */,
/* EC */  0xFECC /*                 ARABIC LETTER AIN MEDIAL FORM */,
/* ED */  0xFECE /*                ARABIC LETTER GHAIN FINAL FORM */,
/* EE */  0xFECD /*             ARABIC LETTER GHAIN ISOLATED FORM */,
/* EF */  0xFEE1 /*              ARABIC LETTER MEEM ISOLATED FORM */,
/* F0 */  0xFE7D /*                     ARABIC SHADDA MEDIAL FORM */,
/* F1 */  0x0651 /*                                 ARABIC SHADDA */,
/* F2 */  0xFEE5 /*              ARABIC LETTER NOON ISOLATED FORM */,
/* F3 */  0xFEE9 /*               ARABIC LETTER HEH ISOLATED FORM */,
/* F4 */  0xFEEC /*                 ARABIC LETTER HEH MEDIAL FORM */,
/* F5 */  0xFEF0 /*         ARABIC LETTER ALEF MAKSURA FINAL FORM */,
/* F6 */  0xFEF2 /*                  ARABIC LETTER YEH FINAL FORM */,
/* F7 */  0xFED0 /*               ARABIC LETTER GHAIN MEDIAL FORM */,
/* F8 */  0xFED5 /*               ARABIC LETTER QAF ISOLATED FORM */,
/* F9 */  0xFEF5 /* ARABIC LIGATURE LAM WITH ALEF WITH MADDA ABOVE ISOLATED FORM */,
/* FA */  0xFEF6 /* ARABIC LIGATURE LAM WITH ALEF WITH MADDA ABOVE FINAL FORM */,
/* FB */  0xFEDD /*               ARABIC LETTER LAM ISOLATED FORM */,
/* FC */  0xFED9 /*               ARABIC LETTER KAF ISOLATED FORM */,
/* FD */  0xFEF1 /*               ARABIC LETTER YEH ISOLATED FORM */,
/* FE */  0x25A0 /*                                  BLACK SQUARE */,
/* FF */     CANT_MAP_CHARACTER   ,
};


static const UCHAR from_unicode_mapping_array[] = {
/* U+XX00 */	CANT_MAP_CHARACTER,	/* 0 */
/* U+XX01 */	CANT_MAP_CHARACTER,	/* 1 */
/* U+XX02 */	CANT_MAP_CHARACTER,	/* 2 */
/* U+XX03 */	CANT_MAP_CHARACTER,	/* 3 */
/* U+XX04 */	CANT_MAP_CHARACTER,	/* 4 */
/* U+XX05 */	CANT_MAP_CHARACTER,	/* 5 */
/* U+XX06 */	CANT_MAP_CHARACTER,	/* 6 */
/* U+XX07 */	CANT_MAP_CHARACTER,	/* 7 */
/* U+XX08 */	CANT_MAP_CHARACTER,	/* 8 */
/* U+XX09 */	CANT_MAP_CHARACTER,	/* 9 */
/* U+XX0A */	CANT_MAP_CHARACTER,	/* 10 */
/* U+XX0B */	CANT_MAP_CHARACTER,	/* 11 */
/* U+XX0C */	CANT_MAP_CHARACTER,	/* 12 */
/* U+XX0D */	CANT_MAP_CHARACTER,	/* 13 */
/* U+XX0E */	CANT_MAP_CHARACTER,	/* 14 */
/* U+XX0F */	CANT_MAP_CHARACTER,	/* 15 */
/* U+XX10 */	CANT_MAP_CHARACTER,	/* 16 */
/* U+XX11 */	CANT_MAP_CHARACTER,	/* 17 */
/* U+XX12 */	CANT_MAP_CHARACTER,	/* 18 */
/* U+XX13 */	CANT_MAP_CHARACTER,	/* 19 */
/* U+XX14 */	CANT_MAP_CHARACTER,	/* 20 */
/* U+XX15 */	CANT_MAP_CHARACTER,	/* 21 */
/* U+XX16 */	CANT_MAP_CHARACTER,	/* 22 */
/* U+XX17 */	CANT_MAP_CHARACTER,	/* 23 */
/* U+XX18 */	CANT_MAP_CHARACTER,	/* 24 */
/* U+XX19 */	CANT_MAP_CHARACTER,	/* 25 */
/* U+XX1A */	CANT_MAP_CHARACTER,	/* 26 */
/* U+XX1B */	CANT_MAP_CHARACTER,	/* 27 */
/* U+XX1C */	CANT_MAP_CHARACTER,	/* 28 */
/* U+XX1D */	CANT_MAP_CHARACTER,	/* 29 */
/* U+XX1E */	CANT_MAP_CHARACTER,	/* 30 */
/* U+XX1F */	CANT_MAP_CHARACTER,	/* 31 */
/* U+XX20 */	CANT_MAP_CHARACTER,	/* 32 */
/* U+XX21 */	CANT_MAP_CHARACTER,	/* 33 */
/* U+XX22 */	CANT_MAP_CHARACTER,	/* 34 */
/* U+XX23 */	CANT_MAP_CHARACTER,	/* 35 */
/* U+XX24 */	CANT_MAP_CHARACTER,	/* 36 */
/* U+XX25 */	CANT_MAP_CHARACTER,	/* 37 */
/* U+XX26 */	CANT_MAP_CHARACTER,	/* 38 */
/* U+XX27 */	CANT_MAP_CHARACTER,	/* 39 */
/* U+XX28 */	CANT_MAP_CHARACTER,	/* 40 */
/* U+XX29 */	CANT_MAP_CHARACTER,	/* 41 */
/* U+XX2A */	CANT_MAP_CHARACTER,	/* 42 */
/* U+XX2B */	CANT_MAP_CHARACTER,	/* 43 */
/* U+XX2C */	CANT_MAP_CHARACTER,	/* 44 */
/* U+XX2D */	CANT_MAP_CHARACTER,	/* 45 */
/* U+XX2E */	CANT_MAP_CHARACTER,	/* 46 */
/* U+XX2F */	CANT_MAP_CHARACTER,	/* 47 */
/* U+XX30 */	CANT_MAP_CHARACTER,	/* 48 */
/* U+XX31 */	CANT_MAP_CHARACTER,	/* 49 */
/* U+XX32 */	CANT_MAP_CHARACTER,	/* 50 */
/* U+XX33 */	CANT_MAP_CHARACTER,	/* 51 */
/* U+XX34 */	CANT_MAP_CHARACTER,	/* 52 */
/* U+XX35 */	CANT_MAP_CHARACTER,	/* 53 */
/* U+XX36 */	CANT_MAP_CHARACTER,	/* 54 */
/* U+XX37 */	CANT_MAP_CHARACTER,	/* 55 */
/* U+XX38 */	CANT_MAP_CHARACTER,	/* 56 */
/* U+XX39 */	CANT_MAP_CHARACTER,	/* 57 */
/* U+XX3A */	CANT_MAP_CHARACTER,	/* 58 */
/* U+XX3B */	CANT_MAP_CHARACTER,	/* 59 */
/* U+XX3C */	CANT_MAP_CHARACTER,	/* 60 */
/* U+XX3D */	CANT_MAP_CHARACTER,	/* 61 */
/* U+XX3E */	CANT_MAP_CHARACTER,	/* 62 */
/* U+XX3F */	CANT_MAP_CHARACTER,	/* 63 */
/* U+XX40 */	CANT_MAP_CHARACTER,	/* 64 */
/* U+XX41 */	CANT_MAP_CHARACTER,	/* 65 */
/* U+XX42 */	CANT_MAP_CHARACTER,	/* 66 */
/* U+XX43 */	CANT_MAP_CHARACTER,	/* 67 */
/* U+XX44 */	CANT_MAP_CHARACTER,	/* 68 */
/* U+XX45 */	CANT_MAP_CHARACTER,	/* 69 */
/* U+XX46 */	CANT_MAP_CHARACTER,	/* 70 */
/* U+XX47 */	CANT_MAP_CHARACTER,	/* 71 */
/* U+XX48 */	CANT_MAP_CHARACTER,	/* 72 */
/* U+XX49 */	CANT_MAP_CHARACTER,	/* 73 */
/* U+XX4A */	CANT_MAP_CHARACTER,	/* 74 */
/* U+XX4B */	CANT_MAP_CHARACTER,	/* 75 */
/* U+XX4C */	CANT_MAP_CHARACTER,	/* 76 */
/* U+XX4D */	CANT_MAP_CHARACTER,	/* 77 */
/* U+XX4E */	CANT_MAP_CHARACTER,	/* 78 */
/* U+XX4F */	CANT_MAP_CHARACTER,	/* 79 */
/* U+XX50 */	CANT_MAP_CHARACTER,	/* 80 */
/* U+XX51 */	CANT_MAP_CHARACTER,	/* 81 */
/* U+XX52 */	CANT_MAP_CHARACTER,	/* 82 */
/* U+XX53 */	CANT_MAP_CHARACTER,	/* 83 */
/* U+XX54 */	CANT_MAP_CHARACTER,	/* 84 */
/* U+XX55 */	CANT_MAP_CHARACTER,	/* 85 */
/* U+XX56 */	CANT_MAP_CHARACTER,	/* 86 */
/* U+XX57 */	CANT_MAP_CHARACTER,	/* 87 */
/* U+XX58 */	CANT_MAP_CHARACTER,	/* 88 */
/* U+XX59 */	CANT_MAP_CHARACTER,	/* 89 */
/* U+XX5A */	CANT_MAP_CHARACTER,	/* 90 */
/* U+XX5B */	CANT_MAP_CHARACTER,	/* 91 */
/* U+XX5C */	CANT_MAP_CHARACTER,	/* 92 */
/* U+XX5D */	CANT_MAP_CHARACTER,	/* 93 */
/* U+XX5E */	CANT_MAP_CHARACTER,	/* 94 */
/* U+XX5F */	CANT_MAP_CHARACTER,	/* 95 */
/* U+XX60 */	CANT_MAP_CHARACTER,	/* 96 */
/* U+XX61 */	CANT_MAP_CHARACTER,	/* 97 */
/* U+XX62 */	CANT_MAP_CHARACTER,	/* 98 */
/* U+XX63 */	CANT_MAP_CHARACTER,	/* 99 */
/* U+XX64 */	CANT_MAP_CHARACTER,	/* 100 */
/* U+XX65 */	CANT_MAP_CHARACTER,	/* 101 */
/* U+XX66 */	CANT_MAP_CHARACTER,	/* 102 */
/* U+XX67 */	CANT_MAP_CHARACTER,	/* 103 */
/* U+XX68 */	CANT_MAP_CHARACTER,	/* 104 */
/* U+XX69 */	CANT_MAP_CHARACTER,	/* 105 */
/* U+XX6A */	CANT_MAP_CHARACTER,	/* 106 */
/* U+XX6B */	CANT_MAP_CHARACTER,	/* 107 */
/* U+XX6C */	CANT_MAP_CHARACTER,	/* 108 */
/* U+XX6D */	CANT_MAP_CHARACTER,	/* 109 */
/* U+XX6E */	CANT_MAP_CHARACTER,	/* 110 */
/* U+XX6F */	CANT_MAP_CHARACTER,	/* 111 */
/* U+XX70 */	CANT_MAP_CHARACTER,	/* 112 */
/* U+XX71 */	CANT_MAP_CHARACTER,	/* 113 */
/* U+XX72 */	CANT_MAP_CHARACTER,	/* 114 */
/* U+XX73 */	CANT_MAP_CHARACTER,	/* 115 */
/* U+XX74 */	CANT_MAP_CHARACTER,	/* 116 */
/* U+XX75 */	CANT_MAP_CHARACTER,	/* 117 */
/* U+XX76 */	CANT_MAP_CHARACTER,	/* 118 */
/* U+XX77 */	CANT_MAP_CHARACTER,	/* 119 */
/* U+XX78 */	CANT_MAP_CHARACTER,	/* 120 */
/* U+XX79 */	CANT_MAP_CHARACTER,	/* 121 */
/* U+XX7A */	CANT_MAP_CHARACTER,	/* 122 */
/* U+XX7B */	CANT_MAP_CHARACTER,	/* 123 */
/* U+XX7C */	CANT_MAP_CHARACTER,	/* 124 */
/* U+XX7D */	CANT_MAP_CHARACTER,	/* 125 */
/* U+XX7E */	CANT_MAP_CHARACTER,	/* 126 */
/* U+XX7F */	CANT_MAP_CHARACTER,	/* 127 */
/* U+XX80 */	CANT_MAP_CHARACTER,	/* 128 */
/* U+XX81 */	CANT_MAP_CHARACTER,	/* 129 */
/* U+XX82 */	CANT_MAP_CHARACTER,	/* 130 */
/* U+XX83 */	CANT_MAP_CHARACTER,	/* 131 */
/* U+XX84 */	CANT_MAP_CHARACTER,	/* 132 */
/* U+XX85 */	CANT_MAP_CHARACTER,	/* 133 */
/* U+XX86 */	CANT_MAP_CHARACTER,	/* 134 */
/* U+XX87 */	CANT_MAP_CHARACTER,	/* 135 */
/* U+XX88 */	CANT_MAP_CHARACTER,	/* 136 */
/* U+XX89 */	CANT_MAP_CHARACTER,	/* 137 */
/* U+XX8A */	CANT_MAP_CHARACTER,	/* 138 */
/* U+XX8B */	CANT_MAP_CHARACTER,	/* 139 */
/* U+XX8C */	CANT_MAP_CHARACTER,	/* 140 */
/* U+XX8D */	CANT_MAP_CHARACTER,	/* 141 */
/* U+XX8E */	CANT_MAP_CHARACTER,	/* 142 */
/* U+XX8F */	CANT_MAP_CHARACTER,	/* 143 */
/* U+XX90 */	CANT_MAP_CHARACTER,	/* 144 */
/* U+XX91 */	CANT_MAP_CHARACTER,	/* 145 */
/* U+XX92 */	CANT_MAP_CHARACTER,	/* 146 */
/* U+XX93 */	CANT_MAP_CHARACTER,	/* 147 */
/* U+XX94 */	CANT_MAP_CHARACTER,	/* 148 */
/* U+XX95 */	CANT_MAP_CHARACTER,	/* 149 */
/* U+XX96 */	CANT_MAP_CHARACTER,	/* 150 */
/* U+XX97 */	CANT_MAP_CHARACTER,	/* 151 */
/* U+XX98 */	CANT_MAP_CHARACTER,	/* 152 */
/* U+XX99 */	CANT_MAP_CHARACTER,	/* 153 */
/* U+XX9A */	CANT_MAP_CHARACTER,	/* 154 */
/* U+XX9B */	CANT_MAP_CHARACTER,	/* 155 */
/* U+XX9C */	CANT_MAP_CHARACTER,	/* 156 */
/* U+XX9D */	CANT_MAP_CHARACTER,	/* 157 */
/* U+XX9E */	CANT_MAP_CHARACTER,	/* 158 */
/* U+XX9F */	CANT_MAP_CHARACTER,	/* 159 */
/* U+XXA0 */	CANT_MAP_CHARACTER,	/* 160 */
/* U+XXA1 */	CANT_MAP_CHARACTER,	/* 161 */
/* U+XXA2 */	CANT_MAP_CHARACTER,	/* 162 */
/* U+XXA3 */	CANT_MAP_CHARACTER,	/* 163 */
/* U+XXA4 */	CANT_MAP_CHARACTER,	/* 164 */
/* U+XXA5 */	CANT_MAP_CHARACTER,	/* 165 */
/* U+XXA6 */	CANT_MAP_CHARACTER,	/* 166 */
/* U+XXA7 */	CANT_MAP_CHARACTER,	/* 167 */
/* U+XXA8 */	CANT_MAP_CHARACTER,	/* 168 */
/* U+XXA9 */	CANT_MAP_CHARACTER,	/* 169 */
/* U+XXAA */	CANT_MAP_CHARACTER,	/* 170 */
/* U+XXAB */	CANT_MAP_CHARACTER,	/* 171 */
/* U+XXAC */	CANT_MAP_CHARACTER,	/* 172 */
/* U+XXAD */	CANT_MAP_CHARACTER,	/* 173 */
/* U+XXAE */	CANT_MAP_CHARACTER,	/* 174 */
/* U+XXAF */	CANT_MAP_CHARACTER,	/* 175 */
/* U+XXB0 */	CANT_MAP_CHARACTER,	/* 176 */
/* U+XXB1 */	CANT_MAP_CHARACTER,	/* 177 */
/* U+XXB2 */	CANT_MAP_CHARACTER,	/* 178 */
/* U+XXB3 */	CANT_MAP_CHARACTER,	/* 179 */
/* U+XXB4 */	CANT_MAP_CHARACTER,	/* 180 */
/* U+XXB5 */	CANT_MAP_CHARACTER,	/* 181 */
/* U+XXB6 */	CANT_MAP_CHARACTER,	/* 182 */
/* U+XXB7 */	CANT_MAP_CHARACTER,	/* 183 */
/* U+XXB8 */	CANT_MAP_CHARACTER,	/* 184 */
/* U+XXB9 */	CANT_MAP_CHARACTER,	/* 185 */
/* U+XXBA */	CANT_MAP_CHARACTER,	/* 186 */
/* U+XXBB */	CANT_MAP_CHARACTER,	/* 187 */
/* U+XXBC */	CANT_MAP_CHARACTER,	/* 188 */
/* U+XXBD */	CANT_MAP_CHARACTER,	/* 189 */
/* U+XXBE */	CANT_MAP_CHARACTER,	/* 190 */
/* U+XXBF */	CANT_MAP_CHARACTER,	/* 191 */
/* U+XXC0 */	CANT_MAP_CHARACTER,	/* 192 */
/* U+XXC1 */	CANT_MAP_CHARACTER,	/* 193 */
/* U+XXC2 */	CANT_MAP_CHARACTER,	/* 194 */
/* U+XXC3 */	CANT_MAP_CHARACTER,	/* 195 */
/* U+XXC4 */	CANT_MAP_CHARACTER,	/* 196 */
/* U+XXC5 */	CANT_MAP_CHARACTER,	/* 197 */
/* U+XXC6 */	CANT_MAP_CHARACTER,	/* 198 */
/* U+XXC7 */	CANT_MAP_CHARACTER,	/* 199 */
/* U+XXC8 */	CANT_MAP_CHARACTER,	/* 200 */
/* U+XXC9 */	CANT_MAP_CHARACTER,	/* 201 */
/* U+XXCA */	CANT_MAP_CHARACTER,	/* 202 */
/* U+XXCB */	CANT_MAP_CHARACTER,	/* 203 */
/* U+XXCC */	CANT_MAP_CHARACTER,	/* 204 */
/* U+XXCD */	CANT_MAP_CHARACTER,	/* 205 */
/* U+XXCE */	CANT_MAP_CHARACTER,	/* 206 */
/* U+XXCF */	CANT_MAP_CHARACTER,	/* 207 */
/* U+XXD0 */	CANT_MAP_CHARACTER,	/* 208 */
/* U+XXD1 */	CANT_MAP_CHARACTER,	/* 209 */
/* U+XXD2 */	CANT_MAP_CHARACTER,	/* 210 */
/* U+XXD3 */	CANT_MAP_CHARACTER,	/* 211 */
/* U+XXD4 */	CANT_MAP_CHARACTER,	/* 212 */
/* U+XXD5 */	CANT_MAP_CHARACTER,	/* 213 */
/* U+XXD6 */	CANT_MAP_CHARACTER,	/* 214 */
/* U+XXD7 */	CANT_MAP_CHARACTER,	/* 215 */
/* U+XXD8 */	CANT_MAP_CHARACTER,	/* 216 */
/* U+XXD9 */	CANT_MAP_CHARACTER,	/* 217 */
/* U+XXDA */	CANT_MAP_CHARACTER,	/* 218 */
/* U+XXDB */	CANT_MAP_CHARACTER,	/* 219 */
/* U+XXDC */	CANT_MAP_CHARACTER,	/* 220 */
/* U+XXDD */	CANT_MAP_CHARACTER,	/* 221 */
/* U+XXDE */	CANT_MAP_CHARACTER,	/* 222 */
/* U+XXDF */	CANT_MAP_CHARACTER,	/* 223 */
/* U+XXE0 */	CANT_MAP_CHARACTER,	/* 224 */
/* U+XXE1 */	CANT_MAP_CHARACTER,	/* 225 */
/* U+XXE2 */	CANT_MAP_CHARACTER,	/* 226 */
/* U+XXE3 */	CANT_MAP_CHARACTER,	/* 227 */
/* U+XXE4 */	CANT_MAP_CHARACTER,	/* 228 */
/* U+XXE5 */	CANT_MAP_CHARACTER,	/* 229 */
/* U+XXE6 */	CANT_MAP_CHARACTER,	/* 230 */
/* U+XXE7 */	CANT_MAP_CHARACTER,	/* 231 */
/* U+XXE8 */	CANT_MAP_CHARACTER,	/* 232 */
/* U+XXE9 */	CANT_MAP_CHARACTER,	/* 233 */
/* U+XXEA */	CANT_MAP_CHARACTER,	/* 234 */
/* U+XXEB */	CANT_MAP_CHARACTER,	/* 235 */
/* U+XXEC */	CANT_MAP_CHARACTER,	/* 236 */
/* U+XXED */	CANT_MAP_CHARACTER,	/* 237 */
/* U+XXEE */	CANT_MAP_CHARACTER,	/* 238 */
/* U+XXEF */	CANT_MAP_CHARACTER,	/* 239 */
/* U+XXF0 */	CANT_MAP_CHARACTER,	/* 240 */
/* U+XXF1 */	CANT_MAP_CHARACTER,	/* 241 */
/* U+XXF2 */	CANT_MAP_CHARACTER,	/* 242 */
/* U+XXF3 */	CANT_MAP_CHARACTER,	/* 243 */
/* U+XXF4 */	CANT_MAP_CHARACTER,	/* 244 */
/* U+XXF5 */	CANT_MAP_CHARACTER,	/* 245 */
/* U+XXF6 */	CANT_MAP_CHARACTER,	/* 246 */
/* U+XXF7 */	CANT_MAP_CHARACTER,	/* 247 */
/* U+XXF8 */	CANT_MAP_CHARACTER,	/* 248 */
/* U+XXF9 */	CANT_MAP_CHARACTER,	/* 249 */
/* U+XXFA */	CANT_MAP_CHARACTER,	/* 250 */
/* U+XXFB */	CANT_MAP_CHARACTER,	/* 251 */
/* U+XXFC */	CANT_MAP_CHARACTER,	/* 252 */
/* U+XXFD */	CANT_MAP_CHARACTER,	/* 253 */
/* U+XXFE */	CANT_MAP_CHARACTER,	/* 254 */
/* U+XXFF */	CANT_MAP_CHARACTER,	/* 255 */
/* U+0000 */	0x00	/*                                          NULL */,/* 256 */
/* U+0001 */	0x01	/*                              START OF HEADING */,/* 257 */
/* U+0002 */	0x02	/*                                 START OF TEXT */,/* 258 */
/* U+0003 */	0x03	/*                                   END OF TEXT */,/* 259 */
/* U+0004 */	0x04	/*                           END OF TRANSMISSION */,/* 260 */
/* U+0005 */	0x05	/*                                       ENQUIRY */,/* 261 */
/* U+0006 */	0x06	/*                                   ACKNOWLEDGE */,/* 262 */
/* U+0007 */	0x07	/*                                          BELL */,/* 263 */
/* U+0008 */	0x08	/*                                     BACKSPACE */,/* 264 */
/* U+0009 */	0x09	/*                          CHARACTER TABULATION */,/* 265 */
/* U+000A */	0x0A	/*                                LINE FEED (LF) */,/* 266 */
/* U+000B */	0x0B	/*                               LINE TABULATION */,/* 267 */
/* U+000C */	0x0C	/*                                FORM FEED (FF) */,/* 268 */
/* U+000D */	0x0D	/*                          CARRIAGE RETURN (CR) */,/* 269 */
/* U+000E */	0x0E	/*                                     SHIFT OUT */,/* 270 */
/* U+000F */	0x0F	/*                                      SHIFT IN */,/* 271 */
/* U+0010 */	0x10	/*                              DATA LINK ESCAPE */,/* 272 */
/* U+0011 */	0x11	/*                            DEVICE CONTROL ONE */,/* 273 */
/* U+0012 */	0x12	/*                            DEVICE CONTROL TWO */,/* 274 */
/* U+0013 */	0x13	/*                          DEVICE CONTROL THREE */,/* 275 */
/* U+0014 */	0x14	/*                           DEVICE CONTROL FOUR */,/* 276 */
/* U+0015 */	0x15	/*                          NEGATIVE ACKNOWLEDGE */,/* 277 */
/* U+0016 */	0x16	/*                              SYNCHRONOUS IDLE */,/* 278 */
/* U+0017 */	0x17	/*                     END OF TRANSMISSION BLOCK */,/* 279 */
/* U+0018 */	0x18	/*                                        CANCEL */,/* 280 */
/* U+0019 */	0x19	/*                                 END OF MEDIUM */,/* 281 */
/* U+001A */	0x1A	/*                                    SUBSTITUTE */,/* 282 */
/* U+001B */	0x1B	/*                                        ESCAPE */,/* 283 */
/* U+001C */	0x1C	/*                    INFORMATION SEPARATOR FOUR */,/* 284 */
/* U+001D */	0x1D	/*                   INFORMATION SEPARATOR THREE */,/* 285 */
/* U+001E */	0x1E	/*                     INFORMATION SEPARATOR TWO */,/* 286 */
/* U+001F */	0x1F	/*                     INFORMATION SEPARATOR ONE */,/* 287 */
/* U+0020 */	0x20	/*                                         SPACE */,/* 288 */
/* U+0021 */	0x21	/*                              EXCLAMATION MARK */,/* 289 */
/* U+0022 */	0x22	/*                                QUOTATION MARK */,/* 290 */
/* U+0023 */	0x23	/*                                   NUMBER SIGN */,/* 291 */
/* U+0024 */	0x24	/*                                   DOLLAR SIGN */,/* 292 */
/* U+0025 */	CANT_MAP_CHARACTER,	/* 293 */
/* U+0026 */	0x26	/*                                     AMPERSAND */,/* 294 */
/* U+0027 */	0x27	/*                                    APOSTROPHE */,/* 295 */
/* U+0028 */	0x28	/*                              LEFT PARENTHESIS */,/* 296 */
/* U+0029 */	0x29	/*                             RIGHT PARENTHESIS */,/* 297 */
/* U+002A */	0x2A	/*                                      ASTERISK */,/* 298 */
/* U+002B */	0x2B	/*                                     PLUS SIGN */,/* 299 */
/* U+002C */	0x2C	/*                                         COMMA */,/* 300 */
/* U+002D */	0x2D	/*                                  HYPHEN-MINUS */,/* 301 */
/* U+002E */	0x2E	/*                                     FULL STOP */,/* 302 */
/* U+002F */	0x2F	/*                                       SOLIDUS */,/* 303 */
/* U+0030 */	0x30	/*                                    DIGIT ZERO */,/* 304 */
/* U+0031 */	0x31	/*                                     DIGIT ONE */,/* 305 */
/* U+0032 */	0x32	/*                                     DIGIT TWO */,/* 306 */
/* U+0033 */	0x33	/*                                   DIGIT THREE */,/* 307 */
/* U+0034 */	0x34	/*                                    DIGIT FOUR */,/* 308 */
/* U+0035 */	0x35	/*                                    DIGIT FIVE */,/* 309 */
/* U+0036 */	0x36	/*                                     DIGIT SIX */,/* 310 */
/* U+0037 */	0x37	/*                                   DIGIT SEVEN */,/* 311 */
/* U+0038 */	0x38	/*                                   DIGIT EIGHT */,/* 312 */
/* U+0039 */	0x39	/*                                    DIGIT NINE */,/* 313 */
/* U+003A */	0x3A	/*                                         COLON */,/* 314 */
/* U+003B */	0x3B	/*                                     SEMICOLON */,/* 315 */
/* U+003C */	0x3C	/*                                LESS-THAN SIGN */,/* 316 */
/* U+003D */	0x3D	/*                                   EQUALS SIGN */,/* 317 */
/* U+003E */	0x3E	/*                             GREATER-THAN SIGN */,/* 318 */
/* U+003F */	0x3F	/*                                 QUESTION MARK */,/* 319 */
/* U+0040 */	0x40	/*                                 COMMERCIAL AT */,/* 320 */
/* U+0041 */	0x41	/*                        LATIN CAPITAL LETTER A */,/* 321 */
/* U+0042 */	0x42	/*                        LATIN CAPITAL LETTER B */,/* 322 */
/* U+0043 */	0x43	/*                        LATIN CAPITAL LETTER C */,/* 323 */
/* U+0044 */	0x44	/*                        LATIN CAPITAL LETTER D */,/* 324 */
/* U+0045 */	0x45	/*                        LATIN CAPITAL LETTER E */,/* 325 */
/* U+0046 */	0x46	/*                        LATIN CAPITAL LETTER F */,/* 326 */
/* U+0047 */	0x47	/*                        LATIN CAPITAL LETTER G */,/* 327 */
/* U+0048 */	0x48	/*                        LATIN CAPITAL LETTER H */,/* 328 */
/* U+0049 */	0x49	/*                        LATIN CAPITAL LETTER I */,/* 329 */
/* U+004A */	0x4A	/*                        LATIN CAPITAL LETTER J */,/* 330 */
/* U+004B */	0x4B	/*                        LATIN CAPITAL LETTER K */,/* 331 */
/* U+004C */	0x4C	/*                        LATIN CAPITAL LETTER L */,/* 332 */
/* U+004D */	0x4D	/*                        LATIN CAPITAL LETTER M */,/* 333 */
/* U+004E */	0x4E	/*                        LATIN CAPITAL LETTER N */,/* 334 */
/* U+004F */	0x4F	/*                        LATIN CAPITAL LETTER O */,/* 335 */
/* U+0050 */	0x50	/*                        LATIN CAPITAL LETTER P */,/* 336 */
/* U+0051 */	0x51	/*                        LATIN CAPITAL LETTER Q */,/* 337 */
/* U+0052 */	0x52	/*                        LATIN CAPITAL LETTER R */,/* 338 */
/* U+0053 */	0x53	/*                        LATIN CAPITAL LETTER S */,/* 339 */
/* U+0054 */	0x54	/*                        LATIN CAPITAL LETTER T */,/* 340 */
/* U+0055 */	0x55	/*                        LATIN CAPITAL LETTER U */,/* 341 */
/* U+0056 */	0x56	/*                        LATIN CAPITAL LETTER V */,/* 342 */
/* U+0057 */	0x57	/*                        LATIN CAPITAL LETTER W */,/* 343 */
/* U+0058 */	0x58	/*                        LATIN CAPITAL LETTER X */,/* 344 */
/* U+0059 */	0x59	/*                        LATIN CAPITAL LETTER Y */,/* 345 */
/* U+005A */	0x5A	/*                        LATIN CAPITAL LETTER Z */,/* 346 */
/* U+005B */	0x5B	/*                           LEFT SQUARE BRACKET */,/* 347 */
/* U+005C */	0x5C	/*                               REVERSE SOLIDUS */,/* 348 */
/* U+005D */	0x5D	/*                          RIGHT SQUARE BRACKET */,/* 349 */
/* U+005E */	0x5E	/*                             CIRCUMFLEX ACCENT */,/* 350 */
/* U+005F */	0x5F	/*                                      LOW LINE */,/* 351 */
/* U+0060 */	0x60	/*                                  GRAVE ACCENT */,/* 352 */
/* U+0061 */	0x61	/*                          LATIN SMALL LETTER A */,/* 353 */
/* U+0062 */	0x62	/*                          LATIN SMALL LETTER B */,/* 354 */
/* U+0063 */	0x63	/*                          LATIN SMALL LETTER C */,/* 355 */
/* U+0064 */	0x64	/*                          LATIN SMALL LETTER D */,/* 356 */
/* U+0065 */	0x65	/*                          LATIN SMALL LETTER E */,/* 357 */
/* U+0066 */	0x66	/*                          LATIN SMALL LETTER F */,/* 358 */
/* U+0067 */	0x67	/*                          LATIN SMALL LETTER G */,/* 359 */
/* U+0068 */	0x68	/*                          LATIN SMALL LETTER H */,/* 360 */
/* U+0069 */	0x69	/*                          LATIN SMALL LETTER I */,/* 361 */
/* U+006A */	0x6A	/*                          LATIN SMALL LETTER J */,/* 362 */
/* U+006B */	0x6B	/*                          LATIN SMALL LETTER K */,/* 363 */
/* U+006C */	0x6C	/*                          LATIN SMALL LETTER L */,/* 364 */
/* U+006D */	0x6D	/*                          LATIN SMALL LETTER M */,/* 365 */
/* U+006E */	0x6E	/*                          LATIN SMALL LETTER N */,/* 366 */
/* U+006F */	0x6F	/*                          LATIN SMALL LETTER O */,/* 367 */
/* U+0070 */	0x70	/*                          LATIN SMALL LETTER P */,/* 368 */
/* U+0071 */	0x71	/*                          LATIN SMALL LETTER Q */,/* 369 */
/* U+0072 */	0x72	/*                          LATIN SMALL LETTER R */,/* 370 */
/* U+0073 */	0x73	/*                          LATIN SMALL LETTER S */,/* 371 */
/* U+0074 */	0x74	/*                          LATIN SMALL LETTER T */,/* 372 */
/* U+0075 */	0x75	/*                          LATIN SMALL LETTER U */,/* 373 */
/* U+0076 */	0x76	/*                          LATIN SMALL LETTER V */,/* 374 */
/* U+0077 */	0x77	/*                          LATIN SMALL LETTER W */,/* 375 */
/* U+0078 */	0x78	/*                          LATIN SMALL LETTER X */,/* 376 */
/* U+0079 */	0x79	/*                          LATIN SMALL LETTER Y */,/* 377 */
/* U+007A */	0x7A	/*                          LATIN SMALL LETTER Z */,/* 378 */
/* U+007B */	0x7B	/*                            LEFT CURLY BRACKET */,/* 379 */
/* U+007C */	0x7C	/*                                 VERTICAL LINE */,/* 380 */
/* U+007D */	0x7D	/*                           RIGHT CURLY BRACKET */,/* 381 */
/* U+007E */	0x7E	/*                                         TILDE */,/* 382 */
/* U+007F */	0x7F	/*                                        DELETE */,/* 383 */
/* U+0080 */	CANT_MAP_CHARACTER,	/* 384 */
/* U+0081 */	CANT_MAP_CHARACTER,	/* 385 */
/* U+0082 */	CANT_MAP_CHARACTER,	/* 386 */
/* U+0083 */	CANT_MAP_CHARACTER,	/* 387 */
/* U+0084 */	CANT_MAP_CHARACTER,	/* 388 */
/* U+0085 */	CANT_MAP_CHARACTER,	/* 389 */
/* U+0086 */	CANT_MAP_CHARACTER,	/* 390 */
/* U+0087 */	CANT_MAP_CHARACTER,	/* 391 */
/* U+0088 */	CANT_MAP_CHARACTER,	/* 392 */
/* U+0089 */	CANT_MAP_CHARACTER,	/* 393 */
/* U+008A */	CANT_MAP_CHARACTER,	/* 394 */
/* U+008B */	CANT_MAP_CHARACTER,	/* 395 */
/* U+008C */	CANT_MAP_CHARACTER,	/* 396 */
/* U+008D */	CANT_MAP_CHARACTER,	/* 397 */
/* U+008E */	CANT_MAP_CHARACTER,	/* 398 */
/* U+008F */	CANT_MAP_CHARACTER,	/* 399 */
/* U+0090 */	CANT_MAP_CHARACTER,	/* 400 */
/* U+0091 */	CANT_MAP_CHARACTER,	/* 401 */
/* U+0092 */	CANT_MAP_CHARACTER,	/* 402 */
/* U+0093 */	CANT_MAP_CHARACTER,	/* 403 */
/* U+0094 */	CANT_MAP_CHARACTER,	/* 404 */
/* U+0095 */	CANT_MAP_CHARACTER,	/* 405 */
/* U+0096 */	CANT_MAP_CHARACTER,	/* 406 */
/* U+0097 */	CANT_MAP_CHARACTER,	/* 407 */
/* U+0098 */	CANT_MAP_CHARACTER,	/* 408 */
/* U+0099 */	CANT_MAP_CHARACTER,	/* 409 */
/* U+009A */	CANT_MAP_CHARACTER,	/* 410 */
/* U+009B */	CANT_MAP_CHARACTER,	/* 411 */
/* U+009C */	CANT_MAP_CHARACTER,	/* 412 */
/* U+009D */	CANT_MAP_CHARACTER,	/* 413 */
/* U+009E */	CANT_MAP_CHARACTER,	/* 414 */
/* U+009F */	CANT_MAP_CHARACTER,	/* 415 */
/* U+00A0 */	0xA0	/*                                NO-BREAK SPACE */,/* 416 */
/* U+00A1 */	CANT_MAP_CHARACTER,	/* 417 */
/* U+00A2 */	0xC0	/*                                     CENT SIGN */,/* 418 */
/* U+00A3 */	0xA3	/*                                    POUND SIGN */,/* 419 */
/* U+00A4 */	0xA4	/*                                 CURRENCY SIGN */,/* 420 */
/* U+00A5 */	CANT_MAP_CHARACTER,	/* 421 */
/* U+00A6 */	0xDB	/*                                    BROKEN BAR */,/* 422 */
/* U+00A7 */	CANT_MAP_CHARACTER,	/* 423 */
/* U+00A8 */	CANT_MAP_CHARACTER,	/* 424 */
/* U+00A9 */	CANT_MAP_CHARACTER,	/* 425 */
/* U+00AA */	CANT_MAP_CHARACTER,	/* 426 */
/* U+00AB */	0x97	/*     LEFT-POINTING DOUBLE ANGLE QUOTATION MARK */,/* 427 */
/* U+00AC */	0xDC	/*                                      NOT SIGN */,/* 428 */
/* U+00AD */	0xA1	/*                                   SOFT HYPHEN */,/* 429 */
/* U+00AE */	CANT_MAP_CHARACTER,	/* 430 */
/* U+00AF */	CANT_MAP_CHARACTER,	/* 431 */
/* U+00B0 */	0x80	/*                                   DEGREE SIGN */,/* 432 */
/* U+00B1 */	0x93	/*                               PLUS-MINUS SIGN */,/* 433 */
/* U+00B2 */	CANT_MAP_CHARACTER,	/* 434 */
/* U+00B3 */	CANT_MAP_CHARACTER,	/* 435 */
/* U+00B4 */	CANT_MAP_CHARACTER,	/* 436 */
/* U+00B5 */	CANT_MAP_CHARACTER,	/* 437 */
/* U+00B6 */	CANT_MAP_CHARACTER,	/* 438 */
/* U+00B7 */	0x81	/*                                    MIDDLE DOT */,/* 439 */
/* U+00B8 */	CANT_MAP_CHARACTER,	/* 440 */
/* U+00B9 */	CANT_MAP_CHARACTER,	/* 441 */
/* U+00BA */	CANT_MAP_CHARACTER,	/* 442 */
/* U+00BB */	0x98	/*    RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK */,/* 443 */
/* U+00BC */	0x95	/*                   VULGAR FRACTION ONE QUARTER */,/* 444 */
/* U+00BD */	0x94	/*                      VULGAR FRACTION ONE HALF */,/* 445 */
/* U+00BE */	CANT_MAP_CHARACTER,	/* 446 */
/* U+00BF */	CANT_MAP_CHARACTER,	/* 447 */
/* U+00C0 */	CANT_MAP_CHARACTER,	/* 448 */
/* U+00C1 */	CANT_MAP_CHARACTER,	/* 449 */
/* U+00C2 */	CANT_MAP_CHARACTER,	/* 450 */
/* U+00C3 */	CANT_MAP_CHARACTER,	/* 451 */
/* U+00C4 */	CANT_MAP_CHARACTER,	/* 452 */
/* U+00C5 */	CANT_MAP_CHARACTER,	/* 453 */
/* U+00C6 */	CANT_MAP_CHARACTER,	/* 454 */
/* U+00C7 */	CANT_MAP_CHARACTER,	/* 455 */
/* U+00C8 */	CANT_MAP_CHARACTER,	/* 456 */
/* U+00C9 */	CANT_MAP_CHARACTER,	/* 457 */
/* U+00CA */	CANT_MAP_CHARACTER,	/* 458 */
/* U+00CB */	CANT_MAP_CHARACTER,	/* 459 */
/* U+00CC */	CANT_MAP_CHARACTER,	/* 460 */
/* U+00CD */	CANT_MAP_CHARACTER,	/* 461 */
/* U+00CE */	CANT_MAP_CHARACTER,	/* 462 */
/* U+00CF */	CANT_MAP_CHARACTER,	/* 463 */
/* U+00D0 */	CANT_MAP_CHARACTER,	/* 464 */
/* U+00D1 */	CANT_MAP_CHARACTER,	/* 465 */
/* U+00D2 */	CANT_MAP_CHARACTER,	/* 466 */
/* U+00D3 */	CANT_MAP_CHARACTER,	/* 467 */
/* U+00D4 */	CANT_MAP_CHARACTER,	/* 468 */
/* U+00D5 */	CANT_MAP_CHARACTER,	/* 469 */
/* U+00D6 */	CANT_MAP_CHARACTER,	/* 470 */
/* U+00D7 */	0xDE	/*                           MULTIPLICATION SIGN */,/* 471 */
/* U+00D8 */	CANT_MAP_CHARACTER,	/* 472 */
/* U+00D9 */	CANT_MAP_CHARACTER,	/* 473 */
/* U+00DA */	CANT_MAP_CHARACTER,	/* 474 */
/* U+00DB */	CANT_MAP_CHARACTER,	/* 475 */
/* U+00DC */	CANT_MAP_CHARACTER,	/* 476 */
/* U+00DD */	CANT_MAP_CHARACTER,	/* 477 */
/* U+00DE */	CANT_MAP_CHARACTER,	/* 478 */
/* U+00DF */	CANT_MAP_CHARACTER,	/* 479 */
/* U+00E0 */	CANT_MAP_CHARACTER,	/* 480 */
/* U+00E1 */	CANT_MAP_CHARACTER,	/* 481 */
/* U+00E2 */	CANT_MAP_CHARACTER,	/* 482 */
/* U+00E3 */	CANT_MAP_CHARACTER,	/* 483 */
/* U+00E4 */	CANT_MAP_CHARACTER,	/* 484 */
/* U+00E5 */	CANT_MAP_CHARACTER,	/* 485 */
/* U+00E6 */	CANT_MAP_CHARACTER,	/* 486 */
/* U+00E7 */	CANT_MAP_CHARACTER,	/* 487 */
/* U+00E8 */	CANT_MAP_CHARACTER,	/* 488 */
/* U+00E9 */	CANT_MAP_CHARACTER,	/* 489 */
/* U+00EA */	CANT_MAP_CHARACTER,	/* 490 */
/* U+00EB */	CANT_MAP_CHARACTER,	/* 491 */
/* U+00EC */	CANT_MAP_CHARACTER,	/* 492 */
/* U+00ED */	CANT_MAP_CHARACTER,	/* 493 */
/* U+00EE */	CANT_MAP_CHARACTER,	/* 494 */
/* U+00EF */	CANT_MAP_CHARACTER,	/* 495 */
/* U+00F0 */	CANT_MAP_CHARACTER,	/* 496 */
/* U+00F1 */	CANT_MAP_CHARACTER,	/* 497 */
/* U+00F2 */	CANT_MAP_CHARACTER,	/* 498 */
/* U+00F3 */	CANT_MAP_CHARACTER,	/* 499 */
/* U+00F4 */	CANT_MAP_CHARACTER,	/* 500 */
/* U+00F5 */	CANT_MAP_CHARACTER,	/* 501 */
/* U+00F6 */	CANT_MAP_CHARACTER,	/* 502 */
/* U+00F7 */	0xDD	/*                                 DIVISION SIGN */,/* 503 */
/* U+00F8 */	CANT_MAP_CHARACTER,	/* 504 */
/* U+00F9 */	CANT_MAP_CHARACTER,	/* 505 */
/* U+00FA */	CANT_MAP_CHARACTER,	/* 506 */
/* U+00FB */	CANT_MAP_CHARACTER,	/* 507 */
/* U+00FC */	CANT_MAP_CHARACTER,	/* 508 */
/* U+00FD */	CANT_MAP_CHARACTER,	/* 509 */
/* U+00FE */	CANT_MAP_CHARACTER,	/* 510 */
/* U+00FF */	CANT_MAP_CHARACTER,	/* 511 */
/* U+0300 */	CANT_MAP_CHARACTER,	/* 512 */
/* U+0301 */	CANT_MAP_CHARACTER,	/* 513 */
/* U+0302 */	CANT_MAP_CHARACTER,	/* 514 */
/* U+0303 */	CANT_MAP_CHARACTER,	/* 515 */
/* U+0304 */	CANT_MAP_CHARACTER,	/* 516 */
/* U+0305 */	CANT_MAP_CHARACTER,	/* 517 */
/* U+0306 */	CANT_MAP_CHARACTER,	/* 518 */
/* U+0307 */	CANT_MAP_CHARACTER,	/* 519 */
/* U+0308 */	CANT_MAP_CHARACTER,	/* 520 */
/* U+0309 */	CANT_MAP_CHARACTER,	/* 521 */
/* U+030A */	CANT_MAP_CHARACTER,	/* 522 */
/* U+030B */	CANT_MAP_CHARACTER,	/* 523 */
/* U+030C */	CANT_MAP_CHARACTER,	/* 524 */
/* U+030D */	CANT_MAP_CHARACTER,	/* 525 */
/* U+030E */	CANT_MAP_CHARACTER,	/* 526 */
/* U+030F */	CANT_MAP_CHARACTER,	/* 527 */
/* U+0310 */	CANT_MAP_CHARACTER,	/* 528 */
/* U+0311 */	CANT_MAP_CHARACTER,	/* 529 */
/* U+0312 */	CANT_MAP_CHARACTER,	/* 530 */
/* U+0313 */	CANT_MAP_CHARACTER,	/* 531 */
/* U+0314 */	CANT_MAP_CHARACTER,	/* 532 */
/* U+0315 */	CANT_MAP_CHARACTER,	/* 533 */
/* U+0316 */	CANT_MAP_CHARACTER,	/* 534 */
/* U+0317 */	CANT_MAP_CHARACTER,	/* 535 */
/* U+0318 */	CANT_MAP_CHARACTER,	/* 536 */
/* U+0319 */	CANT_MAP_CHARACTER,	/* 537 */
/* U+031A */	CANT_MAP_CHARACTER,	/* 538 */
/* U+031B */	CANT_MAP_CHARACTER,	/* 539 */
/* U+031C */	CANT_MAP_CHARACTER,	/* 540 */
/* U+031D */	CANT_MAP_CHARACTER,	/* 541 */
/* U+031E */	CANT_MAP_CHARACTER,	/* 542 */
/* U+031F */	CANT_MAP_CHARACTER,	/* 543 */
/* U+0320 */	CANT_MAP_CHARACTER,	/* 544 */
/* U+0321 */	CANT_MAP_CHARACTER,	/* 545 */
/* U+0322 */	CANT_MAP_CHARACTER,	/* 546 */
/* U+0323 */	CANT_MAP_CHARACTER,	/* 547 */
/* U+0324 */	CANT_MAP_CHARACTER,	/* 548 */
/* U+0325 */	CANT_MAP_CHARACTER,	/* 549 */
/* U+0326 */	CANT_MAP_CHARACTER,	/* 550 */
/* U+0327 */	CANT_MAP_CHARACTER,	/* 551 */
/* U+0328 */	CANT_MAP_CHARACTER,	/* 552 */
/* U+0329 */	CANT_MAP_CHARACTER,	/* 553 */
/* U+032A */	CANT_MAP_CHARACTER,	/* 554 */
/* U+032B */	CANT_MAP_CHARACTER,	/* 555 */
/* U+032C */	CANT_MAP_CHARACTER,	/* 556 */
/* U+032D */	CANT_MAP_CHARACTER,	/* 557 */
/* U+032E */	CANT_MAP_CHARACTER,	/* 558 */
/* U+032F */	CANT_MAP_CHARACTER,	/* 559 */
/* U+0330 */	CANT_MAP_CHARACTER,	/* 560 */
/* U+0331 */	CANT_MAP_CHARACTER,	/* 561 */
/* U+0332 */	CANT_MAP_CHARACTER,	/* 562 */
/* U+0333 */	CANT_MAP_CHARACTER,	/* 563 */
/* U+0334 */	CANT_MAP_CHARACTER,	/* 564 */
/* U+0335 */	CANT_MAP_CHARACTER,	/* 565 */
/* U+0336 */	CANT_MAP_CHARACTER,	/* 566 */
/* U+0337 */	CANT_MAP_CHARACTER,	/* 567 */
/* U+0338 */	CANT_MAP_CHARACTER,	/* 568 */
/* U+0339 */	CANT_MAP_CHARACTER,	/* 569 */
/* U+033A */	CANT_MAP_CHARACTER,	/* 570 */
/* U+033B */	CANT_MAP_CHARACTER,	/* 571 */
/* U+033C */	CANT_MAP_CHARACTER,	/* 572 */
/* U+033D */	CANT_MAP_CHARACTER,	/* 573 */
/* U+033E */	CANT_MAP_CHARACTER,	/* 574 */
/* U+033F */	CANT_MAP_CHARACTER,	/* 575 */
/* U+0340 */	CANT_MAP_CHARACTER,	/* 576 */
/* U+0341 */	CANT_MAP_CHARACTER,	/* 577 */
/* U+0342 */	CANT_MAP_CHARACTER,	/* 578 */
/* U+0343 */	CANT_MAP_CHARACTER,	/* 579 */
/* U+0344 */	CANT_MAP_CHARACTER,	/* 580 */
/* U+0345 */	CANT_MAP_CHARACTER,	/* 581 */
/* U+0346 */	CANT_MAP_CHARACTER,	/* 582 */
/* U+0347 */	CANT_MAP_CHARACTER,	/* 583 */
/* U+0348 */	CANT_MAP_CHARACTER,	/* 584 */
/* U+0349 */	CANT_MAP_CHARACTER,	/* 585 */
/* U+034A */	CANT_MAP_CHARACTER,	/* 586 */
/* U+034B */	CANT_MAP_CHARACTER,	/* 587 */
/* U+034C */	CANT_MAP_CHARACTER,	/* 588 */
/* U+034D */	CANT_MAP_CHARACTER,	/* 589 */
/* U+034E */	CANT_MAP_CHARACTER,	/* 590 */
/* U+034F */	CANT_MAP_CHARACTER,	/* 591 */
/* U+0350 */	CANT_MAP_CHARACTER,	/* 592 */
/* U+0351 */	CANT_MAP_CHARACTER,	/* 593 */
/* U+0352 */	CANT_MAP_CHARACTER,	/* 594 */
/* U+0353 */	CANT_MAP_CHARACTER,	/* 595 */
/* U+0354 */	CANT_MAP_CHARACTER,	/* 596 */
/* U+0355 */	CANT_MAP_CHARACTER,	/* 597 */
/* U+0356 */	CANT_MAP_CHARACTER,	/* 598 */
/* U+0357 */	CANT_MAP_CHARACTER,	/* 599 */
/* U+0358 */	CANT_MAP_CHARACTER,	/* 600 */
/* U+0359 */	CANT_MAP_CHARACTER,	/* 601 */
/* U+035A */	CANT_MAP_CHARACTER,	/* 602 */
/* U+035B */	CANT_MAP_CHARACTER,	/* 603 */
/* U+035C */	CANT_MAP_CHARACTER,	/* 604 */
/* U+035D */	CANT_MAP_CHARACTER,	/* 605 */
/* U+035E */	CANT_MAP_CHARACTER,	/* 606 */
/* U+035F */	CANT_MAP_CHARACTER,	/* 607 */
/* U+0360 */	CANT_MAP_CHARACTER,	/* 608 */
/* U+0361 */	CANT_MAP_CHARACTER,	/* 609 */
/* U+0362 */	CANT_MAP_CHARACTER,	/* 610 */
/* U+0363 */	CANT_MAP_CHARACTER,	/* 611 */
/* U+0364 */	CANT_MAP_CHARACTER,	/* 612 */
/* U+0365 */	CANT_MAP_CHARACTER,	/* 613 */
/* U+0366 */	CANT_MAP_CHARACTER,	/* 614 */
/* U+0367 */	CANT_MAP_CHARACTER,	/* 615 */
/* U+0368 */	CANT_MAP_CHARACTER,	/* 616 */
/* U+0369 */	CANT_MAP_CHARACTER,	/* 617 */
/* U+036A */	CANT_MAP_CHARACTER,	/* 618 */
/* U+036B */	CANT_MAP_CHARACTER,	/* 619 */
/* U+036C */	CANT_MAP_CHARACTER,	/* 620 */
/* U+036D */	CANT_MAP_CHARACTER,	/* 621 */
/* U+036E */	CANT_MAP_CHARACTER,	/* 622 */
/* U+036F */	CANT_MAP_CHARACTER,	/* 623 */
/* U+0370 */	CANT_MAP_CHARACTER,	/* 624 */
/* U+0371 */	CANT_MAP_CHARACTER,	/* 625 */
/* U+0372 */	CANT_MAP_CHARACTER,	/* 626 */
/* U+0373 */	CANT_MAP_CHARACTER,	/* 627 */
/* U+0374 */	CANT_MAP_CHARACTER,	/* 628 */
/* U+0375 */	CANT_MAP_CHARACTER,	/* 629 */
/* U+0376 */	CANT_MAP_CHARACTER,	/* 630 */
/* U+0377 */	CANT_MAP_CHARACTER,	/* 631 */
/* U+0378 */	CANT_MAP_CHARACTER,	/* 632 */
/* U+0379 */	CANT_MAP_CHARACTER,	/* 633 */
/* U+037A */	CANT_MAP_CHARACTER,	/* 634 */
/* U+037B */	CANT_MAP_CHARACTER,	/* 635 */
/* U+037C */	CANT_MAP_CHARACTER,	/* 636 */
/* U+037D */	CANT_MAP_CHARACTER,	/* 637 */
/* U+037E */	CANT_MAP_CHARACTER,	/* 638 */
/* U+037F */	CANT_MAP_CHARACTER,	/* 639 */
/* U+0380 */	CANT_MAP_CHARACTER,	/* 640 */
/* U+0381 */	CANT_MAP_CHARACTER,	/* 641 */
/* U+0382 */	CANT_MAP_CHARACTER,	/* 642 */
/* U+0383 */	CANT_MAP_CHARACTER,	/* 643 */
/* U+0384 */	CANT_MAP_CHARACTER,	/* 644 */
/* U+0385 */	CANT_MAP_CHARACTER,	/* 645 */
/* U+0386 */	CANT_MAP_CHARACTER,	/* 646 */
/* U+0387 */	CANT_MAP_CHARACTER,	/* 647 */
/* U+0388 */	CANT_MAP_CHARACTER,	/* 648 */
/* U+0389 */	CANT_MAP_CHARACTER,	/* 649 */
/* U+038A */	CANT_MAP_CHARACTER,	/* 650 */
/* U+038B */	CANT_MAP_CHARACTER,	/* 651 */
/* U+038C */	CANT_MAP_CHARACTER,	/* 652 */
/* U+038D */	CANT_MAP_CHARACTER,	/* 653 */
/* U+038E */	CANT_MAP_CHARACTER,	/* 654 */
/* U+038F */	CANT_MAP_CHARACTER,	/* 655 */
/* U+0390 */	CANT_MAP_CHARACTER,	/* 656 */
/* U+0391 */	CANT_MAP_CHARACTER,	/* 657 */
/* U+0392 */	CANT_MAP_CHARACTER,	/* 658 */
/* U+0393 */	CANT_MAP_CHARACTER,	/* 659 */
/* U+0394 */	CANT_MAP_CHARACTER,	/* 660 */
/* U+0395 */	CANT_MAP_CHARACTER,	/* 661 */
/* U+0396 */	CANT_MAP_CHARACTER,	/* 662 */
/* U+0397 */	CANT_MAP_CHARACTER,	/* 663 */
/* U+0398 */	CANT_MAP_CHARACTER,	/* 664 */
/* U+0399 */	CANT_MAP_CHARACTER,	/* 665 */
/* U+039A */	CANT_MAP_CHARACTER,	/* 666 */
/* U+039B */	CANT_MAP_CHARACTER,	/* 667 */
/* U+039C */	CANT_MAP_CHARACTER,	/* 668 */
/* U+039D */	CANT_MAP_CHARACTER,	/* 669 */
/* U+039E */	CANT_MAP_CHARACTER,	/* 670 */
/* U+039F */	CANT_MAP_CHARACTER,	/* 671 */
/* U+03A0 */	CANT_MAP_CHARACTER,	/* 672 */
/* U+03A1 */	CANT_MAP_CHARACTER,	/* 673 */
/* U+03A2 */	CANT_MAP_CHARACTER,	/* 674 */
/* U+03A3 */	CANT_MAP_CHARACTER,	/* 675 */
/* U+03A4 */	CANT_MAP_CHARACTER,	/* 676 */
/* U+03A5 */	CANT_MAP_CHARACTER,	/* 677 */
/* U+03A6 */	CANT_MAP_CHARACTER,	/* 678 */
/* U+03A7 */	CANT_MAP_CHARACTER,	/* 679 */
/* U+03A8 */	CANT_MAP_CHARACTER,	/* 680 */
/* U+03A9 */	CANT_MAP_CHARACTER,	/* 681 */
/* U+03AA */	CANT_MAP_CHARACTER,	/* 682 */
/* U+03AB */	CANT_MAP_CHARACTER,	/* 683 */
/* U+03AC */	CANT_MAP_CHARACTER,	/* 684 */
/* U+03AD */	CANT_MAP_CHARACTER,	/* 685 */
/* U+03AE */	CANT_MAP_CHARACTER,	/* 686 */
/* U+03AF */	CANT_MAP_CHARACTER,	/* 687 */
/* U+03B0 */	CANT_MAP_CHARACTER,	/* 688 */
/* U+03B1 */	CANT_MAP_CHARACTER,	/* 689 */
/* U+03B2 */	0x90	/*                       GREEK SMALL LETTER BETA */,/* 690 */
/* U+03B3 */	CANT_MAP_CHARACTER,	/* 691 */
/* U+03B4 */	CANT_MAP_CHARACTER,	/* 692 */
/* U+03B5 */	CANT_MAP_CHARACTER,	/* 693 */
/* U+03B6 */	CANT_MAP_CHARACTER,	/* 694 */
/* U+03B7 */	CANT_MAP_CHARACTER,	/* 695 */
/* U+03B8 */	CANT_MAP_CHARACTER,	/* 696 */
/* U+03B9 */	CANT_MAP_CHARACTER,	/* 697 */
/* U+03BA */	CANT_MAP_CHARACTER,	/* 698 */
/* U+03BB */	CANT_MAP_CHARACTER,	/* 699 */
/* U+03BC */	CANT_MAP_CHARACTER,	/* 700 */
/* U+03BD */	CANT_MAP_CHARACTER,	/* 701 */
/* U+03BE */	CANT_MAP_CHARACTER,	/* 702 */
/* U+03BF */	CANT_MAP_CHARACTER,	/* 703 */
/* U+03C0 */	CANT_MAP_CHARACTER,	/* 704 */
/* U+03C1 */	CANT_MAP_CHARACTER,	/* 705 */
/* U+03C2 */	CANT_MAP_CHARACTER,	/* 706 */
/* U+03C3 */	CANT_MAP_CHARACTER,	/* 707 */
/* U+03C4 */	CANT_MAP_CHARACTER,	/* 708 */
/* U+03C5 */	CANT_MAP_CHARACTER,	/* 709 */
/* U+03C6 */	0x92	/*                        GREEK SMALL LETTER PHI */,/* 710 */
/* U+03C7 */	CANT_MAP_CHARACTER,	/* 711 */
/* U+03C8 */	CANT_MAP_CHARACTER,	/* 712 */
/* U+03C9 */	CANT_MAP_CHARACTER,	/* 713 */
/* U+03CA */	CANT_MAP_CHARACTER,	/* 714 */
/* U+03CB */	CANT_MAP_CHARACTER,	/* 715 */
/* U+03CC */	CANT_MAP_CHARACTER,	/* 716 */
/* U+03CD */	CANT_MAP_CHARACTER,	/* 717 */
/* U+03CE */	CANT_MAP_CHARACTER,	/* 718 */
/* U+03CF */	CANT_MAP_CHARACTER,	/* 719 */
/* U+03D0 */	CANT_MAP_CHARACTER,	/* 720 */
/* U+03D1 */	CANT_MAP_CHARACTER,	/* 721 */
/* U+03D2 */	CANT_MAP_CHARACTER,	/* 722 */
/* U+03D3 */	CANT_MAP_CHARACTER,	/* 723 */
/* U+03D4 */	CANT_MAP_CHARACTER,	/* 724 */
/* U+03D5 */	CANT_MAP_CHARACTER,	/* 725 */
/* U+03D6 */	CANT_MAP_CHARACTER,	/* 726 */
/* U+03D7 */	CANT_MAP_CHARACTER,	/* 727 */
/* U+03D8 */	CANT_MAP_CHARACTER,	/* 728 */
/* U+03D9 */	CANT_MAP_CHARACTER,	/* 729 */
/* U+03DA */	CANT_MAP_CHARACTER,	/* 730 */
/* U+03DB */	CANT_MAP_CHARACTER,	/* 731 */
/* U+03DC */	CANT_MAP_CHARACTER,	/* 732 */
/* U+03DD */	CANT_MAP_CHARACTER,	/* 733 */
/* U+03DE */	CANT_MAP_CHARACTER,	/* 734 */
/* U+03DF */	CANT_MAP_CHARACTER,	/* 735 */
/* U+03E0 */	CANT_MAP_CHARACTER,	/* 736 */
/* U+03E1 */	CANT_MAP_CHARACTER,	/* 737 */
/* U+03E2 */	CANT_MAP_CHARACTER,	/* 738 */
/* U+03E3 */	CANT_MAP_CHARACTER,	/* 739 */
/* U+03E4 */	CANT_MAP_CHARACTER,	/* 740 */
/* U+03E5 */	CANT_MAP_CHARACTER,	/* 741 */
/* U+03E6 */	CANT_MAP_CHARACTER,	/* 742 */
/* U+03E7 */	CANT_MAP_CHARACTER,	/* 743 */
/* U+03E8 */	CANT_MAP_CHARACTER,	/* 744 */
/* U+03E9 */	CANT_MAP_CHARACTER,	/* 745 */
/* U+03EA */	CANT_MAP_CHARACTER,	/* 746 */
/* U+03EB */	CANT_MAP_CHARACTER,	/* 747 */
/* U+03EC */	CANT_MAP_CHARACTER,	/* 748 */
/* U+03ED */	CANT_MAP_CHARACTER,	/* 749 */
/* U+03EE */	CANT_MAP_CHARACTER,	/* 750 */
/* U+03EF */	CANT_MAP_CHARACTER,	/* 751 */
/* U+03F0 */	CANT_MAP_CHARACTER,	/* 752 */
/* U+03F1 */	CANT_MAP_CHARACTER,	/* 753 */
/* U+03F2 */	CANT_MAP_CHARACTER,	/* 754 */
/* U+03F3 */	CANT_MAP_CHARACTER,	/* 755 */
/* U+03F4 */	CANT_MAP_CHARACTER,	/* 756 */
/* U+03F5 */	CANT_MAP_CHARACTER,	/* 757 */
/* U+03F6 */	CANT_MAP_CHARACTER,	/* 758 */
/* U+03F7 */	CANT_MAP_CHARACTER,	/* 759 */
/* U+03F8 */	CANT_MAP_CHARACTER,	/* 760 */
/* U+03F9 */	CANT_MAP_CHARACTER,	/* 761 */
/* U+03FA */	CANT_MAP_CHARACTER,	/* 762 */
/* U+03FB */	CANT_MAP_CHARACTER,	/* 763 */
/* U+03FC */	CANT_MAP_CHARACTER,	/* 764 */
/* U+03FD */	CANT_MAP_CHARACTER,	/* 765 */
/* U+03FE */	CANT_MAP_CHARACTER,	/* 766 */
/* U+03FF */	CANT_MAP_CHARACTER,	/* 767 */
/* U+0600 */	CANT_MAP_CHARACTER,	/* 768 */
/* U+0601 */	CANT_MAP_CHARACTER,	/* 769 */
/* U+0602 */	CANT_MAP_CHARACTER,	/* 770 */
/* U+0603 */	CANT_MAP_CHARACTER,	/* 771 */
/* U+0604 */	CANT_MAP_CHARACTER,	/* 772 */
/* U+0605 */	CANT_MAP_CHARACTER,	/* 773 */
/* U+0606 */	CANT_MAP_CHARACTER,	/* 774 */
/* U+0607 */	CANT_MAP_CHARACTER,	/* 775 */
/* U+0608 */	CANT_MAP_CHARACTER,	/* 776 */
/* U+0609 */	CANT_MAP_CHARACTER,	/* 777 */
/* U+060A */	CANT_MAP_CHARACTER,	/* 778 */
/* U+060B */	CANT_MAP_CHARACTER,	/* 779 */
/* U+060C */	0xAC	/*                                  ARABIC COMMA */,/* 780 */
/* U+060D */	CANT_MAP_CHARACTER,	/* 781 */
/* U+060E */	CANT_MAP_CHARACTER,	/* 782 */
/* U+060F */	CANT_MAP_CHARACTER,	/* 783 */
/* U+0610 */	CANT_MAP_CHARACTER,	/* 784 */
/* U+0611 */	CANT_MAP_CHARACTER,	/* 785 */
/* U+0612 */	CANT_MAP_CHARACTER,	/* 786 */
/* U+0613 */	CANT_MAP_CHARACTER,	/* 787 */
/* U+0614 */	CANT_MAP_CHARACTER,	/* 788 */
/* U+0615 */	CANT_MAP_CHARACTER,	/* 789 */
/* U+0616 */	CANT_MAP_CHARACTER,	/* 790 */
/* U+0617 */	CANT_MAP_CHARACTER,	/* 791 */
/* U+0618 */	CANT_MAP_CHARACTER,	/* 792 */
/* U+0619 */	CANT_MAP_CHARACTER,	/* 793 */
/* U+061A */	CANT_MAP_CHARACTER,	/* 794 */
/* U+061B */	0xBB	/*                              ARABIC SEMICOLON */,/* 795 */
/* U+061C */	CANT_MAP_CHARACTER,	/* 796 */
/* U+061D */	CANT_MAP_CHARACTER,	/* 797 */
/* U+061E */	CANT_MAP_CHARACTER,	/* 798 */
/* U+061F */	0xBF	/*                          ARABIC QUESTION MARK */,/* 799 */
/* U+0620 */	CANT_MAP_CHARACTER,	/* 800 */
/* U+0621 */	CANT_MAP_CHARACTER,	/* 801 */
/* U+0622 */	CANT_MAP_CHARACTER,	/* 802 */
/* U+0623 */	CANT_MAP_CHARACTER,	/* 803 */
/* U+0624 */	CANT_MAP_CHARACTER,	/* 804 */
/* U+0625 */	CANT_MAP_CHARACTER,	/* 805 */
/* U+0626 */	CANT_MAP_CHARACTER,	/* 806 */
/* U+0627 */	CANT_MAP_CHARACTER,	/* 807 */
/* U+0628 */	CANT_MAP_CHARACTER,	/* 808 */
/* U+0629 */	CANT_MAP_CHARACTER,	/* 809 */
/* U+062A */	CANT_MAP_CHARACTER,	/* 810 */
/* U+062B */	CANT_MAP_CHARACTER,	/* 811 */
/* U+062C */	CANT_MAP_CHARACTER,	/* 812 */
/* U+062D */	CANT_MAP_CHARACTER,	/* 813 */
/* U+062E */	CANT_MAP_CHARACTER,	/* 814 */
/* U+062F */	CANT_MAP_CHARACTER,	/* 815 */
/* U+0630 */	CANT_MAP_CHARACTER,	/* 816 */
/* U+0631 */	CANT_MAP_CHARACTER,	/* 817 */
/* U+0632 */	CANT_MAP_CHARACTER,	/* 818 */
/* U+0633 */	CANT_MAP_CHARACTER,	/* 819 */
/* U+0634 */	CANT_MAP_CHARACTER,	/* 820 */
/* U+0635 */	CANT_MAP_CHARACTER,	/* 821 */
/* U+0636 */	CANT_MAP_CHARACTER,	/* 822 */
/* U+0637 */	CANT_MAP_CHARACTER,	/* 823 */
/* U+0638 */	CANT_MAP_CHARACTER,	/* 824 */
/* U+0639 */	CANT_MAP_CHARACTER,	/* 825 */
/* U+063A */	CANT_MAP_CHARACTER,	/* 826 */
/* U+063B */	CANT_MAP_CHARACTER,	/* 827 */
/* U+063C */	CANT_MAP_CHARACTER,	/* 828 */
/* U+063D */	CANT_MAP_CHARACTER,	/* 829 */
/* U+063E */	CANT_MAP_CHARACTER,	/* 830 */
/* U+063F */	CANT_MAP_CHARACTER,	/* 831 */
/* U+0640 */	0xE0	/*                                ARABIC TATWEEL */,/* 832 */
/* U+0641 */	CANT_MAP_CHARACTER,	/* 833 */
/* U+0642 */	CANT_MAP_CHARACTER,	/* 834 */
/* U+0643 */	CANT_MAP_CHARACTER,	/* 835 */
/* U+0644 */	CANT_MAP_CHARACTER,	/* 836 */
/* U+0645 */	CANT_MAP_CHARACTER,	/* 837 */
/* U+0646 */	CANT_MAP_CHARACTER,	/* 838 */
/* U+0647 */	CANT_MAP_CHARACTER,	/* 839 */
/* U+0648 */	CANT_MAP_CHARACTER,	/* 840 */
/* U+0649 */	CANT_MAP_CHARACTER,	/* 841 */
/* U+064A */	CANT_MAP_CHARACTER,	/* 842 */
/* U+064B */	CANT_MAP_CHARACTER,	/* 843 */
/* U+064C */	CANT_MAP_CHARACTER,	/* 844 */
/* U+064D */	CANT_MAP_CHARACTER,	/* 845 */
/* U+064E */	CANT_MAP_CHARACTER,	/* 846 */
/* U+064F */	CANT_MAP_CHARACTER,	/* 847 */
/* U+0650 */	CANT_MAP_CHARACTER,	/* 848 */
/* U+0651 */	0xF1	/*                                 ARABIC SHADDA */,/* 849 */
/* U+0652 */	CANT_MAP_CHARACTER,	/* 850 */
/* U+0653 */	CANT_MAP_CHARACTER,	/* 851 */
/* U+0654 */	CANT_MAP_CHARACTER,	/* 852 */
/* U+0655 */	CANT_MAP_CHARACTER,	/* 853 */
/* U+0656 */	CANT_MAP_CHARACTER,	/* 854 */
/* U+0657 */	CANT_MAP_CHARACTER,	/* 855 */
/* U+0658 */	CANT_MAP_CHARACTER,	/* 856 */
/* U+0659 */	CANT_MAP_CHARACTER,	/* 857 */
/* U+065A */	CANT_MAP_CHARACTER,	/* 858 */
/* U+065B */	CANT_MAP_CHARACTER,	/* 859 */
/* U+065C */	CANT_MAP_CHARACTER,	/* 860 */
/* U+065D */	CANT_MAP_CHARACTER,	/* 861 */
/* U+065E */	CANT_MAP_CHARACTER,	/* 862 */
/* U+065F */	CANT_MAP_CHARACTER,	/* 863 */
/* U+0660 */	0xB0	/*                       ARABIC-INDIC DIGIT ZERO */,/* 864 */
/* U+0661 */	0xB1	/*                        ARABIC-INDIC DIGIT ONE */,/* 865 */
/* U+0662 */	0xB2	/*                        ARABIC-INDIC DIGIT TWO */,/* 866 */
/* U+0663 */	0xB3	/*                      ARABIC-INDIC DIGIT THREE */,/* 867 */
/* U+0664 */	0xB4	/*                       ARABIC-INDIC DIGIT FOUR */,/* 868 */
/* U+0665 */	0xB5	/*                       ARABIC-INDIC DIGIT FIVE */,/* 869 */
/* U+0666 */	0xB6	/*                        ARABIC-INDIC DIGIT SIX */,/* 870 */
/* U+0667 */	0xB7	/*                      ARABIC-INDIC DIGIT SEVEN */,/* 871 */
/* U+0668 */	0xB8	/*                      ARABIC-INDIC DIGIT EIGHT */,/* 872 */
/* U+0669 */	0xB9	/*                       ARABIC-INDIC DIGIT NINE */,/* 873 */
/* U+066A */	0x25	/*                           ARABIC PERCENT SIGN */,/* 874 */
/* U+066B */	CANT_MAP_CHARACTER,	/* 875 */
/* U+066C */	CANT_MAP_CHARACTER,	/* 876 */
/* U+066D */	CANT_MAP_CHARACTER,	/* 877 */
/* U+066E */	CANT_MAP_CHARACTER,	/* 878 */
/* U+066F */	CANT_MAP_CHARACTER,	/* 879 */
/* U+0670 */	CANT_MAP_CHARACTER,	/* 880 */
/* U+0671 */	CANT_MAP_CHARACTER,	/* 881 */
/* U+0672 */	CANT_MAP_CHARACTER,	/* 882 */
/* U+0673 */	CANT_MAP_CHARACTER,	/* 883 */
/* U+0674 */	CANT_MAP_CHARACTER,	/* 884 */
/* U+0675 */	CANT_MAP_CHARACTER,	/* 885 */
/* U+0676 */	CANT_MAP_CHARACTER,	/* 886 */
/* U+0677 */	CANT_MAP_CHARACTER,	/* 887 */
/* U+0678 */	CANT_MAP_CHARACTER,	/* 888 */
/* U+0679 */	CANT_MAP_CHARACTER,	/* 889 */
/* U+067A */	CANT_MAP_CHARACTER,	/* 890 */
/* U+067B */	CANT_MAP_CHARACTER,	/* 891 */
/* U+067C */	CANT_MAP_CHARACTER,	/* 892 */
/* U+067D */	CANT_MAP_CHARACTER,	/* 893 */
/* U+067E */	CANT_MAP_CHARACTER,	/* 894 */
/* U+067F */	CANT_MAP_CHARACTER,	/* 895 */
/* U+0680 */	CANT_MAP_CHARACTER,	/* 896 */
/* U+0681 */	CANT_MAP_CHARACTER,	/* 897 */
/* U+0682 */	CANT_MAP_CHARACTER,	/* 898 */
/* U+0683 */	CANT_MAP_CHARACTER,	/* 899 */
/* U+0684 */	CANT_MAP_CHARACTER,	/* 900 */
/* U+0685 */	CANT_MAP_CHARACTER,	/* 901 */
/* U+0686 */	CANT_MAP_CHARACTER,	/* 902 */
/* U+0687 */	CANT_MAP_CHARACTER,	/* 903 */
/* U+0688 */	CANT_MAP_CHARACTER,	/* 904 */
/* U+0689 */	CANT_MAP_CHARACTER,	/* 905 */
/* U+068A */	CANT_MAP_CHARACTER,	/* 906 */
/* U+068B */	CANT_MAP_CHARACTER,	/* 907 */
/* U+068C */	CANT_MAP_CHARACTER,	/* 908 */
/* U+068D */	CANT_MAP_CHARACTER,	/* 909 */
/* U+068E */	CANT_MAP_CHARACTER,	/* 910 */
/* U+068F */	CANT_MAP_CHARACTER,	/* 911 */
/* U+0690 */	CANT_MAP_CHARACTER,	/* 912 */
/* U+0691 */	CANT_MAP_CHARACTER,	/* 913 */
/* U+0692 */	CANT_MAP_CHARACTER,	/* 914 */
/* U+0693 */	CANT_MAP_CHARACTER,	/* 915 */
/* U+0694 */	CANT_MAP_CHARACTER,	/* 916 */
/* U+0695 */	CANT_MAP_CHARACTER,	/* 917 */
/* U+0696 */	CANT_MAP_CHARACTER,	/* 918 */
/* U+0697 */	CANT_MAP_CHARACTER,	/* 919 */
/* U+0698 */	CANT_MAP_CHARACTER,	/* 920 */
/* U+0699 */	CANT_MAP_CHARACTER,	/* 921 */
/* U+069A */	CANT_MAP_CHARACTER,	/* 922 */
/* U+069B */	CANT_MAP_CHARACTER,	/* 923 */
/* U+069C */	CANT_MAP_CHARACTER,	/* 924 */
/* U+069D */	CANT_MAP_CHARACTER,	/* 925 */
/* U+069E */	CANT_MAP_CHARACTER,	/* 926 */
/* U+069F */	CANT_MAP_CHARACTER,	/* 927 */
/* U+06A0 */	CANT_MAP_CHARACTER,	/* 928 */
/* U+06A1 */	CANT_MAP_CHARACTER,	/* 929 */
/* U+06A2 */	CANT_MAP_CHARACTER,	/* 930 */
/* U+06A3 */	CANT_MAP_CHARACTER,	/* 931 */
/* U+06A4 */	CANT_MAP_CHARACTER,	/* 932 */
/* U+06A5 */	CANT_MAP_CHARACTER,	/* 933 */
/* U+06A6 */	CANT_MAP_CHARACTER,	/* 934 */
/* U+06A7 */	CANT_MAP_CHARACTER,	/* 935 */
/* U+06A8 */	CANT_MAP_CHARACTER,	/* 936 */
/* U+06A9 */	CANT_MAP_CHARACTER,	/* 937 */
/* U+06AA */	CANT_MAP_CHARACTER,	/* 938 */
/* U+06AB */	CANT_MAP_CHARACTER,	/* 939 */
/* U+06AC */	CANT_MAP_CHARACTER,	/* 940 */
/* U+06AD */	CANT_MAP_CHARACTER,	/* 941 */
/* U+06AE */	CANT_MAP_CHARACTER,	/* 942 */
/* U+06AF */	CANT_MAP_CHARACTER,	/* 943 */
/* U+06B0 */	CANT_MAP_CHARACTER,	/* 944 */
/* U+06B1 */	CANT_MAP_CHARACTER,	/* 945 */
/* U+06B2 */	CANT_MAP_CHARACTER,	/* 946 */
/* U+06B3 */	CANT_MAP_CHARACTER,	/* 947 */
/* U+06B4 */	CANT_MAP_CHARACTER,	/* 948 */
/* U+06B5 */	CANT_MAP_CHARACTER,	/* 949 */
/* U+06B6 */	CANT_MAP_CHARACTER,	/* 950 */
/* U+06B7 */	CANT_MAP_CHARACTER,	/* 951 */
/* U+06B8 */	CANT_MAP_CHARACTER,	/* 952 */
/* U+06B9 */	CANT_MAP_CHARACTER,	/* 953 */
/* U+06BA */	CANT_MAP_CHARACTER,	/* 954 */
/* U+06BB */	CANT_MAP_CHARACTER,	/* 955 */
/* U+06BC */	CANT_MAP_CHARACTER,	/* 956 */
/* U+06BD */	CANT_MAP_CHARACTER,	/* 957 */
/* U+06BE */	CANT_MAP_CHARACTER,	/* 958 */
/* U+06BF */	CANT_MAP_CHARACTER,	/* 959 */
/* U+06C0 */	CANT_MAP_CHARACTER,	/* 960 */
/* U+06C1 */	CANT_MAP_CHARACTER,	/* 961 */
/* U+06C2 */	CANT_MAP_CHARACTER,	/* 962 */
/* U+06C3 */	CANT_MAP_CHARACTER,	/* 963 */
/* U+06C4 */	CANT_MAP_CHARACTER,	/* 964 */
/* U+06C5 */	CANT_MAP_CHARACTER,	/* 965 */
/* U+06C6 */	CANT_MAP_CHARACTER,	/* 966 */
/* U+06C7 */	CANT_MAP_CHARACTER,	/* 967 */
/* U+06C8 */	CANT_MAP_CHARACTER,	/* 968 */
/* U+06C9 */	CANT_MAP_CHARACTER,	/* 969 */
/* U+06CA */	CANT_MAP_CHARACTER,	/* 970 */
/* U+06CB */	CANT_MAP_CHARACTER,	/* 971 */
/* U+06CC */	CANT_MAP_CHARACTER,	/* 972 */
/* U+06CD */	CANT_MAP_CHARACTER,	/* 973 */
/* U+06CE */	CANT_MAP_CHARACTER,	/* 974 */
/* U+06CF */	CANT_MAP_CHARACTER,	/* 975 */
/* U+06D0 */	CANT_MAP_CHARACTER,	/* 976 */
/* U+06D1 */	CANT_MAP_CHARACTER,	/* 977 */
/* U+06D2 */	CANT_MAP_CHARACTER,	/* 978 */
/* U+06D3 */	CANT_MAP_CHARACTER,	/* 979 */
/* U+06D4 */	CANT_MAP_CHARACTER,	/* 980 */
/* U+06D5 */	CANT_MAP_CHARACTER,	/* 981 */
/* U+06D6 */	CANT_MAP_CHARACTER,	/* 982 */
/* U+06D7 */	CANT_MAP_CHARACTER,	/* 983 */
/* U+06D8 */	CANT_MAP_CHARACTER,	/* 984 */
/* U+06D9 */	CANT_MAP_CHARACTER,	/* 985 */
/* U+06DA */	CANT_MAP_CHARACTER,	/* 986 */
/* U+06DB */	CANT_MAP_CHARACTER,	/* 987 */
/* U+06DC */	CANT_MAP_CHARACTER,	/* 988 */
/* U+06DD */	CANT_MAP_CHARACTER,	/* 989 */
/* U+06DE */	CANT_MAP_CHARACTER,	/* 990 */
/* U+06DF */	CANT_MAP_CHARACTER,	/* 991 */
/* U+06E0 */	CANT_MAP_CHARACTER,	/* 992 */
/* U+06E1 */	CANT_MAP_CHARACTER,	/* 993 */
/* U+06E2 */	CANT_MAP_CHARACTER,	/* 994 */
/* U+06E3 */	CANT_MAP_CHARACTER,	/* 995 */
/* U+06E4 */	CANT_MAP_CHARACTER,	/* 996 */
/* U+06E5 */	CANT_MAP_CHARACTER,	/* 997 */
/* U+06E6 */	CANT_MAP_CHARACTER,	/* 998 */
/* U+06E7 */	CANT_MAP_CHARACTER,	/* 999 */
/* U+06E8 */	CANT_MAP_CHARACTER,	/* 1000 */
/* U+06E9 */	CANT_MAP_CHARACTER,	/* 1001 */
/* U+06EA */	CANT_MAP_CHARACTER,	/* 1002 */
/* U+06EB */	CANT_MAP_CHARACTER,	/* 1003 */
/* U+06EC */	CANT_MAP_CHARACTER,	/* 1004 */
/* U+06ED */	CANT_MAP_CHARACTER,	/* 1005 */
/* U+06EE */	CANT_MAP_CHARACTER,	/* 1006 */
/* U+06EF */	CANT_MAP_CHARACTER,	/* 1007 */
/* U+06F0 */	CANT_MAP_CHARACTER,	/* 1008 */
/* U+06F1 */	CANT_MAP_CHARACTER,	/* 1009 */
/* U+06F2 */	CANT_MAP_CHARACTER,	/* 1010 */
/* U+06F3 */	CANT_MAP_CHARACTER,	/* 1011 */
/* U+06F4 */	CANT_MAP_CHARACTER,	/* 1012 */
/* U+06F5 */	CANT_MAP_CHARACTER,	/* 1013 */
/* U+06F6 */	CANT_MAP_CHARACTER,	/* 1014 */
/* U+06F7 */	CANT_MAP_CHARACTER,	/* 1015 */
/* U+06F8 */	CANT_MAP_CHARACTER,	/* 1016 */
/* U+06F9 */	CANT_MAP_CHARACTER,	/* 1017 */
/* U+06FA */	CANT_MAP_CHARACTER,	/* 1018 */
/* U+06FB */	CANT_MAP_CHARACTER,	/* 1019 */
/* U+06FC */	CANT_MAP_CHARACTER,	/* 1020 */
/* U+06FD */	CANT_MAP_CHARACTER,	/* 1021 */
/* U+06FE */	CANT_MAP_CHARACTER,	/* 1022 */
/* U+06FF */	CANT_MAP_CHARACTER,	/* 1023 */
/* U+2200 */	CANT_MAP_CHARACTER,	/* 1024 */
/* U+2201 */	CANT_MAP_CHARACTER,	/* 1025 */
/* U+2202 */	CANT_MAP_CHARACTER,	/* 1026 */
/* U+2203 */	CANT_MAP_CHARACTER,	/* 1027 */
/* U+2204 */	CANT_MAP_CHARACTER,	/* 1028 */
/* U+2205 */	CANT_MAP_CHARACTER,	/* 1029 */
/* U+2206 */	CANT_MAP_CHARACTER,	/* 1030 */
/* U+2207 */	CANT_MAP_CHARACTER,	/* 1031 */
/* U+2208 */	CANT_MAP_CHARACTER,	/* 1032 */
/* U+2209 */	CANT_MAP_CHARACTER,	/* 1033 */
/* U+220A */	CANT_MAP_CHARACTER,	/* 1034 */
/* U+220B */	CANT_MAP_CHARACTER,	/* 1035 */
/* U+220C */	CANT_MAP_CHARACTER,	/* 1036 */
/* U+220D */	CANT_MAP_CHARACTER,	/* 1037 */
/* U+220E */	CANT_MAP_CHARACTER,	/* 1038 */
/* U+220F */	CANT_MAP_CHARACTER,	/* 1039 */
/* U+2210 */	CANT_MAP_CHARACTER,	/* 1040 */
/* U+2211 */	CANT_MAP_CHARACTER,	/* 1041 */
/* U+2212 */	CANT_MAP_CHARACTER,	/* 1042 */
/* U+2213 */	CANT_MAP_CHARACTER,	/* 1043 */
/* U+2214 */	CANT_MAP_CHARACTER,	/* 1044 */
/* U+2215 */	CANT_MAP_CHARACTER,	/* 1045 */
/* U+2216 */	CANT_MAP_CHARACTER,	/* 1046 */
/* U+2217 */	CANT_MAP_CHARACTER,	/* 1047 */
/* U+2218 */	CANT_MAP_CHARACTER,	/* 1048 */
/* U+2219 */	0x82	/*                               BULLET OPERATOR */,/* 1049 */
/* U+221A */	0x83	/*                                   SQUARE ROOT */,/* 1050 */
/* U+221B */	CANT_MAP_CHARACTER,	/* 1051 */
/* U+221C */	CANT_MAP_CHARACTER,	/* 1052 */
/* U+221D */	CANT_MAP_CHARACTER,	/* 1053 */
/* U+221E */	0x91	/*                                      INFINITY */,/* 1054 */
/* U+221F */	CANT_MAP_CHARACTER,	/* 1055 */
/* U+2220 */	CANT_MAP_CHARACTER,	/* 1056 */
/* U+2221 */	CANT_MAP_CHARACTER,	/* 1057 */
/* U+2222 */	CANT_MAP_CHARACTER,	/* 1058 */
/* U+2223 */	CANT_MAP_CHARACTER,	/* 1059 */
/* U+2224 */	CANT_MAP_CHARACTER,	/* 1060 */
/* U+2225 */	CANT_MAP_CHARACTER,	/* 1061 */
/* U+2226 */	CANT_MAP_CHARACTER,	/* 1062 */
/* U+2227 */	CANT_MAP_CHARACTER,	/* 1063 */
/* U+2228 */	CANT_MAP_CHARACTER,	/* 1064 */
/* U+2229 */	CANT_MAP_CHARACTER,	/* 1065 */
/* U+222A */	CANT_MAP_CHARACTER,	/* 1066 */
/* U+222B */	CANT_MAP_CHARACTER,	/* 1067 */
/* U+222C */	CANT_MAP_CHARACTER,	/* 1068 */
/* U+222D */	CANT_MAP_CHARACTER,	/* 1069 */
/* U+222E */	CANT_MAP_CHARACTER,	/* 1070 */
/* U+222F */	CANT_MAP_CHARACTER,	/* 1071 */
/* U+2230 */	CANT_MAP_CHARACTER,	/* 1072 */
/* U+2231 */	CANT_MAP_CHARACTER,	/* 1073 */
/* U+2232 */	CANT_MAP_CHARACTER,	/* 1074 */
/* U+2233 */	CANT_MAP_CHARACTER,	/* 1075 */
/* U+2234 */	CANT_MAP_CHARACTER,	/* 1076 */
/* U+2235 */	CANT_MAP_CHARACTER,	/* 1077 */
/* U+2236 */	CANT_MAP_CHARACTER,	/* 1078 */
/* U+2237 */	CANT_MAP_CHARACTER,	/* 1079 */
/* U+2238 */	CANT_MAP_CHARACTER,	/* 1080 */
/* U+2239 */	CANT_MAP_CHARACTER,	/* 1081 */
/* U+223A */	CANT_MAP_CHARACTER,	/* 1082 */
/* U+223B */	CANT_MAP_CHARACTER,	/* 1083 */
/* U+223C */	CANT_MAP_CHARACTER,	/* 1084 */
/* U+223D */	CANT_MAP_CHARACTER,	/* 1085 */
/* U+223E */	CANT_MAP_CHARACTER,	/* 1086 */
/* U+223F */	CANT_MAP_CHARACTER,	/* 1087 */
/* U+2240 */	CANT_MAP_CHARACTER,	/* 1088 */
/* U+2241 */	CANT_MAP_CHARACTER,	/* 1089 */
/* U+2242 */	CANT_MAP_CHARACTER,	/* 1090 */
/* U+2243 */	CANT_MAP_CHARACTER,	/* 1091 */
/* U+2244 */	CANT_MAP_CHARACTER,	/* 1092 */
/* U+2245 */	CANT_MAP_CHARACTER,	/* 1093 */
/* U+2246 */	CANT_MAP_CHARACTER,	/* 1094 */
/* U+2247 */	CANT_MAP_CHARACTER,	/* 1095 */
/* U+2248 */	0x96	/*                               ALMOST EQUAL TO */,/* 1096 */
/* U+2249 */	CANT_MAP_CHARACTER,	/* 1097 */
/* U+224A */	CANT_MAP_CHARACTER,	/* 1098 */
/* U+224B */	CANT_MAP_CHARACTER,	/* 1099 */
/* U+224C */	CANT_MAP_CHARACTER,	/* 1100 */
/* U+224D */	CANT_MAP_CHARACTER,	/* 1101 */
/* U+224E */	CANT_MAP_CHARACTER,	/* 1102 */
/* U+224F */	CANT_MAP_CHARACTER,	/* 1103 */
/* U+2250 */	CANT_MAP_CHARACTER,	/* 1104 */
/* U+2251 */	CANT_MAP_CHARACTER,	/* 1105 */
/* U+2252 */	CANT_MAP_CHARACTER,	/* 1106 */
/* U+2253 */	CANT_MAP_CHARACTER,	/* 1107 */
/* U+2254 */	CANT_MAP_CHARACTER,	/* 1108 */
/* U+2255 */	CANT_MAP_CHARACTER,	/* 1109 */
/* U+2256 */	CANT_MAP_CHARACTER,	/* 1110 */
/* U+2257 */	CANT_MAP_CHARACTER,	/* 1111 */
/* U+2258 */	CANT_MAP_CHARACTER,	/* 1112 */
/* U+2259 */	CANT_MAP_CHARACTER,	/* 1113 */
/* U+225A */	CANT_MAP_CHARACTER,	/* 1114 */
/* U+225B */	CANT_MAP_CHARACTER,	/* 1115 */
/* U+225C */	CANT_MAP_CHARACTER,	/* 1116 */
/* U+225D */	CANT_MAP_CHARACTER,	/* 1117 */
/* U+225E */	CANT_MAP_CHARACTER,	/* 1118 */
/* U+225F */	CANT_MAP_CHARACTER,	/* 1119 */
/* U+2260 */	CANT_MAP_CHARACTER,	/* 1120 */
/* U+2261 */	CANT_MAP_CHARACTER,	/* 1121 */
/* U+2262 */	CANT_MAP_CHARACTER,	/* 1122 */
/* U+2263 */	CANT_MAP_CHARACTER,	/* 1123 */
/* U+2264 */	CANT_MAP_CHARACTER,	/* 1124 */
/* U+2265 */	CANT_MAP_CHARACTER,	/* 1125 */
/* U+2266 */	CANT_MAP_CHARACTER,	/* 1126 */
/* U+2267 */	CANT_MAP_CHARACTER,	/* 1127 */
/* U+2268 */	CANT_MAP_CHARACTER,	/* 1128 */
/* U+2269 */	CANT_MAP_CHARACTER,	/* 1129 */
/* U+226A */	CANT_MAP_CHARACTER,	/* 1130 */
/* U+226B */	CANT_MAP_CHARACTER,	/* 1131 */
/* U+226C */	CANT_MAP_CHARACTER,	/* 1132 */
/* U+226D */	CANT_MAP_CHARACTER,	/* 1133 */
/* U+226E */	CANT_MAP_CHARACTER,	/* 1134 */
/* U+226F */	CANT_MAP_CHARACTER,	/* 1135 */
/* U+2270 */	CANT_MAP_CHARACTER,	/* 1136 */
/* U+2271 */	CANT_MAP_CHARACTER,	/* 1137 */
/* U+2272 */	CANT_MAP_CHARACTER,	/* 1138 */
/* U+2273 */	CANT_MAP_CHARACTER,	/* 1139 */
/* U+2274 */	CANT_MAP_CHARACTER,	/* 1140 */
/* U+2275 */	CANT_MAP_CHARACTER,	/* 1141 */
/* U+2276 */	CANT_MAP_CHARACTER,	/* 1142 */
/* U+2277 */	CANT_MAP_CHARACTER,	/* 1143 */
/* U+2278 */	CANT_MAP_CHARACTER,	/* 1144 */
/* U+2279 */	CANT_MAP_CHARACTER,	/* 1145 */
/* U+227A */	CANT_MAP_CHARACTER,	/* 1146 */
/* U+227B */	CANT_MAP_CHARACTER,	/* 1147 */
/* U+227C */	CANT_MAP_CHARACTER,	/* 1148 */
/* U+227D */	CANT_MAP_CHARACTER,	/* 1149 */
/* U+227E */	CANT_MAP_CHARACTER,	/* 1150 */
/* U+227F */	CANT_MAP_CHARACTER,	/* 1151 */
/* U+2280 */	CANT_MAP_CHARACTER,	/* 1152 */
/* U+2281 */	CANT_MAP_CHARACTER,	/* 1153 */
/* U+2282 */	CANT_MAP_CHARACTER,	/* 1154 */
/* U+2283 */	CANT_MAP_CHARACTER,	/* 1155 */
/* U+2284 */	CANT_MAP_CHARACTER,	/* 1156 */
/* U+2285 */	CANT_MAP_CHARACTER,	/* 1157 */
/* U+2286 */	CANT_MAP_CHARACTER,	/* 1158 */
/* U+2287 */	CANT_MAP_CHARACTER,	/* 1159 */
/* U+2288 */	CANT_MAP_CHARACTER,	/* 1160 */
/* U+2289 */	CANT_MAP_CHARACTER,	/* 1161 */
/* U+228A */	CANT_MAP_CHARACTER,	/* 1162 */
/* U+228B */	CANT_MAP_CHARACTER,	/* 1163 */
/* U+228C */	CANT_MAP_CHARACTER,	/* 1164 */
/* U+228D */	CANT_MAP_CHARACTER,	/* 1165 */
/* U+228E */	CANT_MAP_CHARACTER,	/* 1166 */
/* U+228F */	CANT_MAP_CHARACTER,	/* 1167 */
/* U+2290 */	CANT_MAP_CHARACTER,	/* 1168 */
/* U+2291 */	CANT_MAP_CHARACTER,	/* 1169 */
/* U+2292 */	CANT_MAP_CHARACTER,	/* 1170 */
/* U+2293 */	CANT_MAP_CHARACTER,	/* 1171 */
/* U+2294 */	CANT_MAP_CHARACTER,	/* 1172 */
/* U+2295 */	CANT_MAP_CHARACTER,	/* 1173 */
/* U+2296 */	CANT_MAP_CHARACTER,	/* 1174 */
/* U+2297 */	CANT_MAP_CHARACTER,	/* 1175 */
/* U+2298 */	CANT_MAP_CHARACTER,	/* 1176 */
/* U+2299 */	CANT_MAP_CHARACTER,	/* 1177 */
/* U+229A */	CANT_MAP_CHARACTER,	/* 1178 */
/* U+229B */	CANT_MAP_CHARACTER,	/* 1179 */
/* U+229C */	CANT_MAP_CHARACTER,	/* 1180 */
/* U+229D */	CANT_MAP_CHARACTER,	/* 1181 */
/* U+229E */	CANT_MAP_CHARACTER,	/* 1182 */
/* U+229F */	CANT_MAP_CHARACTER,	/* 1183 */
/* U+22A0 */	CANT_MAP_CHARACTER,	/* 1184 */
/* U+22A1 */	CANT_MAP_CHARACTER,	/* 1185 */
/* U+22A2 */	CANT_MAP_CHARACTER,	/* 1186 */
/* U+22A3 */	CANT_MAP_CHARACTER,	/* 1187 */
/* U+22A4 */	CANT_MAP_CHARACTER,	/* 1188 */
/* U+22A5 */	CANT_MAP_CHARACTER,	/* 1189 */
/* U+22A6 */	CANT_MAP_CHARACTER,	/* 1190 */
/* U+22A7 */	CANT_MAP_CHARACTER,	/* 1191 */
/* U+22A8 */	CANT_MAP_CHARACTER,	/* 1192 */
/* U+22A9 */	CANT_MAP_CHARACTER,	/* 1193 */
/* U+22AA */	CANT_MAP_CHARACTER,	/* 1194 */
/* U+22AB */	CANT_MAP_CHARACTER,	/* 1195 */
/* U+22AC */	CANT_MAP_CHARACTER,	/* 1196 */
/* U+22AD */	CANT_MAP_CHARACTER,	/* 1197 */
/* U+22AE */	CANT_MAP_CHARACTER,	/* 1198 */
/* U+22AF */	CANT_MAP_CHARACTER,	/* 1199 */
/* U+22B0 */	CANT_MAP_CHARACTER,	/* 1200 */
/* U+22B1 */	CANT_MAP_CHARACTER,	/* 1201 */
/* U+22B2 */	CANT_MAP_CHARACTER,	/* 1202 */
/* U+22B3 */	CANT_MAP_CHARACTER,	/* 1203 */
/* U+22B4 */	CANT_MAP_CHARACTER,	/* 1204 */
/* U+22B5 */	CANT_MAP_CHARACTER,	/* 1205 */
/* U+22B6 */	CANT_MAP_CHARACTER,	/* 1206 */
/* U+22B7 */	CANT_MAP_CHARACTER,	/* 1207 */
/* U+22B8 */	CANT_MAP_CHARACTER,	/* 1208 */
/* U+22B9 */	CANT_MAP_CHARACTER,	/* 1209 */
/* U+22BA */	CANT_MAP_CHARACTER,	/* 1210 */
/* U+22BB */	CANT_MAP_CHARACTER,	/* 1211 */
/* U+22BC */	CANT_MAP_CHARACTER,	/* 1212 */
/* U+22BD */	CANT_MAP_CHARACTER,	/* 1213 */
/* U+22BE */	CANT_MAP_CHARACTER,	/* 1214 */
/* U+22BF */	CANT_MAP_CHARACTER,	/* 1215 */
/* U+22C0 */	CANT_MAP_CHARACTER,	/* 1216 */
/* U+22C1 */	CANT_MAP_CHARACTER,	/* 1217 */
/* U+22C2 */	CANT_MAP_CHARACTER,	/* 1218 */
/* U+22C3 */	CANT_MAP_CHARACTER,	/* 1219 */
/* U+22C4 */	CANT_MAP_CHARACTER,	/* 1220 */
/* U+22C5 */	CANT_MAP_CHARACTER,	/* 1221 */
/* U+22C6 */	CANT_MAP_CHARACTER,	/* 1222 */
/* U+22C7 */	CANT_MAP_CHARACTER,	/* 1223 */
/* U+22C8 */	CANT_MAP_CHARACTER,	/* 1224 */
/* U+22C9 */	CANT_MAP_CHARACTER,	/* 1225 */
/* U+22CA */	CANT_MAP_CHARACTER,	/* 1226 */
/* U+22CB */	CANT_MAP_CHARACTER,	/* 1227 */
/* U+22CC */	CANT_MAP_CHARACTER,	/* 1228 */
/* U+22CD */	CANT_MAP_CHARACTER,	/* 1229 */
/* U+22CE */	CANT_MAP_CHARACTER,	/* 1230 */
/* U+22CF */	CANT_MAP_CHARACTER,	/* 1231 */
/* U+22D0 */	CANT_MAP_CHARACTER,	/* 1232 */
/* U+22D1 */	CANT_MAP_CHARACTER,	/* 1233 */
/* U+22D2 */	CANT_MAP_CHARACTER,	/* 1234 */
/* U+22D3 */	CANT_MAP_CHARACTER,	/* 1235 */
/* U+22D4 */	CANT_MAP_CHARACTER,	/* 1236 */
/* U+22D5 */	CANT_MAP_CHARACTER,	/* 1237 */
/* U+22D6 */	CANT_MAP_CHARACTER,	/* 1238 */
/* U+22D7 */	CANT_MAP_CHARACTER,	/* 1239 */
/* U+22D8 */	CANT_MAP_CHARACTER,	/* 1240 */
/* U+22D9 */	CANT_MAP_CHARACTER,	/* 1241 */
/* U+22DA */	CANT_MAP_CHARACTER,	/* 1242 */
/* U+22DB */	CANT_MAP_CHARACTER,	/* 1243 */
/* U+22DC */	CANT_MAP_CHARACTER,	/* 1244 */
/* U+22DD */	CANT_MAP_CHARACTER,	/* 1245 */
/* U+22DE */	CANT_MAP_CHARACTER,	/* 1246 */
/* U+22DF */	CANT_MAP_CHARACTER,	/* 1247 */
/* U+22E0 */	CANT_MAP_CHARACTER,	/* 1248 */
/* U+22E1 */	CANT_MAP_CHARACTER,	/* 1249 */
/* U+22E2 */	CANT_MAP_CHARACTER,	/* 1250 */
/* U+22E3 */	CANT_MAP_CHARACTER,	/* 1251 */
/* U+22E4 */	CANT_MAP_CHARACTER,	/* 1252 */
/* U+22E5 */	CANT_MAP_CHARACTER,	/* 1253 */
/* U+22E6 */	CANT_MAP_CHARACTER,	/* 1254 */
/* U+22E7 */	CANT_MAP_CHARACTER,	/* 1255 */
/* U+22E8 */	CANT_MAP_CHARACTER,	/* 1256 */
/* U+22E9 */	CANT_MAP_CHARACTER,	/* 1257 */
/* U+22EA */	CANT_MAP_CHARACTER,	/* 1258 */
/* U+22EB */	CANT_MAP_CHARACTER,	/* 1259 */
/* U+22EC */	CANT_MAP_CHARACTER,	/* 1260 */
/* U+22ED */	CANT_MAP_CHARACTER,	/* 1261 */
/* U+22EE */	CANT_MAP_CHARACTER,	/* 1262 */
/* U+22EF */	CANT_MAP_CHARACTER,	/* 1263 */
/* U+22F0 */	CANT_MAP_CHARACTER,	/* 1264 */
/* U+22F1 */	CANT_MAP_CHARACTER,	/* 1265 */
/* U+22F2 */	CANT_MAP_CHARACTER,	/* 1266 */
/* U+22F3 */	CANT_MAP_CHARACTER,	/* 1267 */
/* U+22F4 */	CANT_MAP_CHARACTER,	/* 1268 */
/* U+22F5 */	CANT_MAP_CHARACTER,	/* 1269 */
/* U+22F6 */	CANT_MAP_CHARACTER,	/* 1270 */
/* U+22F7 */	CANT_MAP_CHARACTER,	/* 1271 */
/* U+22F8 */	CANT_MAP_CHARACTER,	/* 1272 */
/* U+22F9 */	CANT_MAP_CHARACTER,	/* 1273 */
/* U+22FA */	CANT_MAP_CHARACTER,	/* 1274 */
/* U+22FB */	CANT_MAP_CHARACTER,	/* 1275 */
/* U+22FC */	CANT_MAP_CHARACTER,	/* 1276 */
/* U+22FD */	CANT_MAP_CHARACTER,	/* 1277 */
/* U+22FE */	CANT_MAP_CHARACTER,	/* 1278 */
/* U+22FF */	CANT_MAP_CHARACTER,	/* 1279 */
/* U+2500 */	0x85	/*                 BOX DRAWINGS LIGHT HORIZONTAL */,/* 1280 */
/* U+2501 */	CANT_MAP_CHARACTER,	/* 1281 */
/* U+2502 */	0x86	/*                   BOX DRAWINGS LIGHT VERTICAL */,/* 1282 */
/* U+2503 */	CANT_MAP_CHARACTER,	/* 1283 */
/* U+2504 */	CANT_MAP_CHARACTER,	/* 1284 */
/* U+2505 */	CANT_MAP_CHARACTER,	/* 1285 */
/* U+2506 */	CANT_MAP_CHARACTER,	/* 1286 */
/* U+2507 */	CANT_MAP_CHARACTER,	/* 1287 */
/* U+2508 */	CANT_MAP_CHARACTER,	/* 1288 */
/* U+2509 */	CANT_MAP_CHARACTER,	/* 1289 */
/* U+250A */	CANT_MAP_CHARACTER,	/* 1290 */
/* U+250B */	CANT_MAP_CHARACTER,	/* 1291 */
/* U+250C */	0x8D	/*             BOX DRAWINGS LIGHT DOWN AND RIGHT */,/* 1292 */
/* U+250D */	CANT_MAP_CHARACTER,	/* 1293 */
/* U+250E */	CANT_MAP_CHARACTER,	/* 1294 */
/* U+250F */	CANT_MAP_CHARACTER,	/* 1295 */
/* U+2510 */	0x8C	/*              BOX DRAWINGS LIGHT DOWN AND LEFT */,/* 1296 */
/* U+2511 */	CANT_MAP_CHARACTER,	/* 1297 */
/* U+2512 */	CANT_MAP_CHARACTER,	/* 1298 */
/* U+2513 */	CANT_MAP_CHARACTER,	/* 1299 */
/* U+2514 */	0x8E	/*               BOX DRAWINGS LIGHT UP AND RIGHT */,/* 1300 */
/* U+2515 */	CANT_MAP_CHARACTER,	/* 1301 */
/* U+2516 */	CANT_MAP_CHARACTER,	/* 1302 */
/* U+2517 */	CANT_MAP_CHARACTER,	/* 1303 */
/* U+2518 */	0x8F	/*                BOX DRAWINGS LIGHT UP AND LEFT */,/* 1304 */
/* U+2519 */	CANT_MAP_CHARACTER,	/* 1305 */
/* U+251A */	CANT_MAP_CHARACTER,	/* 1306 */
/* U+251B */	CANT_MAP_CHARACTER,	/* 1307 */
/* U+251C */	0x8A	/*         BOX DRAWINGS LIGHT VERTICAL AND RIGHT */,/* 1308 */
/* U+251D */	CANT_MAP_CHARACTER,	/* 1309 */
/* U+251E */	CANT_MAP_CHARACTER,	/* 1310 */
/* U+251F */	CANT_MAP_CHARACTER,	/* 1311 */
/* U+2520 */	CANT_MAP_CHARACTER,	/* 1312 */
/* U+2521 */	CANT_MAP_CHARACTER,	/* 1313 */
/* U+2522 */	CANT_MAP_CHARACTER,	/* 1314 */
/* U+2523 */	CANT_MAP_CHARACTER,	/* 1315 */
/* U+2524 */	0x88	/*          BOX DRAWINGS LIGHT VERTICAL AND LEFT */,/* 1316 */
/* U+2525 */	CANT_MAP_CHARACTER,	/* 1317 */
/* U+2526 */	CANT_MAP_CHARACTER,	/* 1318 */
/* U+2527 */	CANT_MAP_CHARACTER,	/* 1319 */
/* U+2528 */	CANT_MAP_CHARACTER,	/* 1320 */
/* U+2529 */	CANT_MAP_CHARACTER,	/* 1321 */
/* U+252A */	CANT_MAP_CHARACTER,	/* 1322 */
/* U+252B */	CANT_MAP_CHARACTER,	/* 1323 */
/* U+252C */	0x89	/*        BOX DRAWINGS LIGHT DOWN AND HORIZONTAL */,/* 1324 */
/* U+252D */	CANT_MAP_CHARACTER,	/* 1325 */
/* U+252E */	CANT_MAP_CHARACTER,	/* 1326 */
/* U+252F */	CANT_MAP_CHARACTER,	/* 1327 */
/* U+2530 */	CANT_MAP_CHARACTER,	/* 1328 */
/* U+2531 */	CANT_MAP_CHARACTER,	/* 1329 */
/* U+2532 */	CANT_MAP_CHARACTER,	/* 1330 */
/* U+2533 */	CANT_MAP_CHARACTER,	/* 1331 */
/* U+2534 */	0x8B	/*          BOX DRAWINGS LIGHT UP AND HORIZONTAL */,/* 1332 */
/* U+2535 */	CANT_MAP_CHARACTER,	/* 1333 */
/* U+2536 */	CANT_MAP_CHARACTER,	/* 1334 */
/* U+2537 */	CANT_MAP_CHARACTER,	/* 1335 */
/* U+2538 */	CANT_MAP_CHARACTER,	/* 1336 */
/* U+2539 */	CANT_MAP_CHARACTER,	/* 1337 */
/* U+253A */	CANT_MAP_CHARACTER,	/* 1338 */
/* U+253B */	CANT_MAP_CHARACTER,	/* 1339 */
/* U+253C */	0x87	/*    BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL */,/* 1340 */
/* U+253D */	CANT_MAP_CHARACTER,	/* 1341 */
/* U+253E */	CANT_MAP_CHARACTER,	/* 1342 */
/* U+253F */	CANT_MAP_CHARACTER,	/* 1343 */
/* U+2540 */	CANT_MAP_CHARACTER,	/* 1344 */
/* U+2541 */	CANT_MAP_CHARACTER,	/* 1345 */
/* U+2542 */	CANT_MAP_CHARACTER,	/* 1346 */
/* U+2543 */	CANT_MAP_CHARACTER,	/* 1347 */
/* U+2544 */	CANT_MAP_CHARACTER,	/* 1348 */
/* U+2545 */	CANT_MAP_CHARACTER,	/* 1349 */
/* U+2546 */	CANT_MAP_CHARACTER,	/* 1350 */
/* U+2547 */	CANT_MAP_CHARACTER,	/* 1351 */
/* U+2548 */	CANT_MAP_CHARACTER,	/* 1352 */
/* U+2549 */	CANT_MAP_CHARACTER,	/* 1353 */
/* U+254A */	CANT_MAP_CHARACTER,	/* 1354 */
/* U+254B */	CANT_MAP_CHARACTER,	/* 1355 */
/* U+254C */	CANT_MAP_CHARACTER,	/* 1356 */
/* U+254D */	CANT_MAP_CHARACTER,	/* 1357 */
/* U+254E */	CANT_MAP_CHARACTER,	/* 1358 */
/* U+254F */	CANT_MAP_CHARACTER,	/* 1359 */
/* U+2550 */	CANT_MAP_CHARACTER,	/* 1360 */
/* U+2551 */	CANT_MAP_CHARACTER,	/* 1361 */
/* U+2552 */	CANT_MAP_CHARACTER,	/* 1362 */
/* U+2553 */	CANT_MAP_CHARACTER,	/* 1363 */
/* U+2554 */	CANT_MAP_CHARACTER,	/* 1364 */
/* U+2555 */	CANT_MAP_CHARACTER,	/* 1365 */
/* U+2556 */	CANT_MAP_CHARACTER,	/* 1366 */
/* U+2557 */	CANT_MAP_CHARACTER,	/* 1367 */
/* U+2558 */	CANT_MAP_CHARACTER,	/* 1368 */
/* U+2559 */	CANT_MAP_CHARACTER,	/* 1369 */
/* U+255A */	CANT_MAP_CHARACTER,	/* 1370 */
/* U+255B */	CANT_MAP_CHARACTER,	/* 1371 */
/* U+255C */	CANT_MAP_CHARACTER,	/* 1372 */
/* U+255D */	CANT_MAP_CHARACTER,	/* 1373 */
/* U+255E */	CANT_MAP_CHARACTER,	/* 1374 */
/* U+255F */	CANT_MAP_CHARACTER,	/* 1375 */
/* U+2560 */	CANT_MAP_CHARACTER,	/* 1376 */
/* U+2561 */	CANT_MAP_CHARACTER,	/* 1377 */
/* U+2562 */	CANT_MAP_CHARACTER,	/* 1378 */
/* U+2563 */	CANT_MAP_CHARACTER,	/* 1379 */
/* U+2564 */	CANT_MAP_CHARACTER,	/* 1380 */
/* U+2565 */	CANT_MAP_CHARACTER,	/* 1381 */
/* U+2566 */	CANT_MAP_CHARACTER,	/* 1382 */
/* U+2567 */	CANT_MAP_CHARACTER,	/* 1383 */
/* U+2568 */	CANT_MAP_CHARACTER,	/* 1384 */
/* U+2569 */	CANT_MAP_CHARACTER,	/* 1385 */
/* U+256A */	CANT_MAP_CHARACTER,	/* 1386 */
/* U+256B */	CANT_MAP_CHARACTER,	/* 1387 */
/* U+256C */	CANT_MAP_CHARACTER,	/* 1388 */
/* U+256D */	CANT_MAP_CHARACTER,	/* 1389 */
/* U+256E */	CANT_MAP_CHARACTER,	/* 1390 */
/* U+256F */	CANT_MAP_CHARACTER,	/* 1391 */
/* U+2570 */	CANT_MAP_CHARACTER,	/* 1392 */
/* U+2571 */	CANT_MAP_CHARACTER,	/* 1393 */
/* U+2572 */	CANT_MAP_CHARACTER,	/* 1394 */
/* U+2573 */	CANT_MAP_CHARACTER,	/* 1395 */
/* U+2574 */	CANT_MAP_CHARACTER,	/* 1396 */
/* U+2575 */	CANT_MAP_CHARACTER,	/* 1397 */
/* U+2576 */	CANT_MAP_CHARACTER,	/* 1398 */
/* U+2577 */	CANT_MAP_CHARACTER,	/* 1399 */
/* U+2578 */	CANT_MAP_CHARACTER,	/* 1400 */
/* U+2579 */	CANT_MAP_CHARACTER,	/* 1401 */
/* U+257A */	CANT_MAP_CHARACTER,	/* 1402 */
/* U+257B */	CANT_MAP_CHARACTER,	/* 1403 */
/* U+257C */	CANT_MAP_CHARACTER,	/* 1404 */
/* U+257D */	CANT_MAP_CHARACTER,	/* 1405 */
/* U+257E */	CANT_MAP_CHARACTER,	/* 1406 */
/* U+257F */	CANT_MAP_CHARACTER,	/* 1407 */
/* U+2580 */	CANT_MAP_CHARACTER,	/* 1408 */
/* U+2581 */	CANT_MAP_CHARACTER,	/* 1409 */
/* U+2582 */	CANT_MAP_CHARACTER,	/* 1410 */
/* U+2583 */	CANT_MAP_CHARACTER,	/* 1411 */
/* U+2584 */	CANT_MAP_CHARACTER,	/* 1412 */
/* U+2585 */	CANT_MAP_CHARACTER,	/* 1413 */
/* U+2586 */	CANT_MAP_CHARACTER,	/* 1414 */
/* U+2587 */	CANT_MAP_CHARACTER,	/* 1415 */
/* U+2588 */	CANT_MAP_CHARACTER,	/* 1416 */
/* U+2589 */	CANT_MAP_CHARACTER,	/* 1417 */
/* U+258A */	CANT_MAP_CHARACTER,	/* 1418 */
/* U+258B */	CANT_MAP_CHARACTER,	/* 1419 */
/* U+258C */	CANT_MAP_CHARACTER,	/* 1420 */
/* U+258D */	CANT_MAP_CHARACTER,	/* 1421 */
/* U+258E */	CANT_MAP_CHARACTER,	/* 1422 */
/* U+258F */	CANT_MAP_CHARACTER,	/* 1423 */
/* U+2590 */	CANT_MAP_CHARACTER,	/* 1424 */
/* U+2591 */	CANT_MAP_CHARACTER,	/* 1425 */
/* U+2592 */	0x84	/*                                  MEDIUM SHADE */,/* 1426 */
/* U+2593 */	CANT_MAP_CHARACTER,	/* 1427 */
/* U+2594 */	CANT_MAP_CHARACTER,	/* 1428 */
/* U+2595 */	CANT_MAP_CHARACTER,	/* 1429 */
/* U+2596 */	CANT_MAP_CHARACTER,	/* 1430 */
/* U+2597 */	CANT_MAP_CHARACTER,	/* 1431 */
/* U+2598 */	CANT_MAP_CHARACTER,	/* 1432 */
/* U+2599 */	CANT_MAP_CHARACTER,	/* 1433 */
/* U+259A */	CANT_MAP_CHARACTER,	/* 1434 */
/* U+259B */	CANT_MAP_CHARACTER,	/* 1435 */
/* U+259C */	CANT_MAP_CHARACTER,	/* 1436 */
/* U+259D */	CANT_MAP_CHARACTER,	/* 1437 */
/* U+259E */	CANT_MAP_CHARACTER,	/* 1438 */
/* U+259F */	CANT_MAP_CHARACTER,	/* 1439 */
/* U+25A0 */	0xFE	/*                                  BLACK SQUARE */,/* 1440 */
/* U+25A1 */	CANT_MAP_CHARACTER,	/* 1441 */
/* U+25A2 */	CANT_MAP_CHARACTER,	/* 1442 */
/* U+25A3 */	CANT_MAP_CHARACTER,	/* 1443 */
/* U+25A4 */	CANT_MAP_CHARACTER,	/* 1444 */
/* U+25A5 */	CANT_MAP_CHARACTER,	/* 1445 */
/* U+25A6 */	CANT_MAP_CHARACTER,	/* 1446 */
/* U+25A7 */	CANT_MAP_CHARACTER,	/* 1447 */
/* U+25A8 */	CANT_MAP_CHARACTER,	/* 1448 */
/* U+25A9 */	CANT_MAP_CHARACTER,	/* 1449 */
/* U+25AA */	CANT_MAP_CHARACTER,	/* 1450 */
/* U+25AB */	CANT_MAP_CHARACTER,	/* 1451 */
/* U+25AC */	CANT_MAP_CHARACTER,	/* 1452 */
/* U+25AD */	CANT_MAP_CHARACTER,	/* 1453 */
/* U+25AE */	CANT_MAP_CHARACTER,	/* 1454 */
/* U+25AF */	CANT_MAP_CHARACTER,	/* 1455 */
/* U+25B0 */	CANT_MAP_CHARACTER,	/* 1456 */
/* U+25B1 */	CANT_MAP_CHARACTER,	/* 1457 */
/* U+25B2 */	CANT_MAP_CHARACTER,	/* 1458 */
/* U+25B3 */	CANT_MAP_CHARACTER,	/* 1459 */
/* U+25B4 */	CANT_MAP_CHARACTER,	/* 1460 */
/* U+25B5 */	CANT_MAP_CHARACTER,	/* 1461 */
/* U+25B6 */	CANT_MAP_CHARACTER,	/* 1462 */
/* U+25B7 */	CANT_MAP_CHARACTER,	/* 1463 */
/* U+25B8 */	CANT_MAP_CHARACTER,	/* 1464 */
/* U+25B9 */	CANT_MAP_CHARACTER,	/* 1465 */
/* U+25BA */	CANT_MAP_CHARACTER,	/* 1466 */
/* U+25BB */	CANT_MAP_CHARACTER,	/* 1467 */
/* U+25BC */	CANT_MAP_CHARACTER,	/* 1468 */
/* U+25BD */	CANT_MAP_CHARACTER,	/* 1469 */
/* U+25BE */	CANT_MAP_CHARACTER,	/* 1470 */
/* U+25BF */	CANT_MAP_CHARACTER,	/* 1471 */
/* U+25C0 */	CANT_MAP_CHARACTER,	/* 1472 */
/* U+25C1 */	CANT_MAP_CHARACTER,	/* 1473 */
/* U+25C2 */	CANT_MAP_CHARACTER,	/* 1474 */
/* U+25C3 */	CANT_MAP_CHARACTER,	/* 1475 */
/* U+25C4 */	CANT_MAP_CHARACTER,	/* 1476 */
/* U+25C5 */	CANT_MAP_CHARACTER,	/* 1477 */
/* U+25C6 */	CANT_MAP_CHARACTER,	/* 1478 */
/* U+25C7 */	CANT_MAP_CHARACTER,	/* 1479 */
/* U+25C8 */	CANT_MAP_CHARACTER,	/* 1480 */
/* U+25C9 */	CANT_MAP_CHARACTER,	/* 1481 */
/* U+25CA */	CANT_MAP_CHARACTER,	/* 1482 */
/* U+25CB */	CANT_MAP_CHARACTER,	/* 1483 */
/* U+25CC */	CANT_MAP_CHARACTER,	/* 1484 */
/* U+25CD */	CANT_MAP_CHARACTER,	/* 1485 */
/* U+25CE */	CANT_MAP_CHARACTER,	/* 1486 */
/* U+25CF */	CANT_MAP_CHARACTER,	/* 1487 */
/* U+25D0 */	CANT_MAP_CHARACTER,	/* 1488 */
/* U+25D1 */	CANT_MAP_CHARACTER,	/* 1489 */
/* U+25D2 */	CANT_MAP_CHARACTER,	/* 1490 */
/* U+25D3 */	CANT_MAP_CHARACTER,	/* 1491 */
/* U+25D4 */	CANT_MAP_CHARACTER,	/* 1492 */
/* U+25D5 */	CANT_MAP_CHARACTER,	/* 1493 */
/* U+25D6 */	CANT_MAP_CHARACTER,	/* 1494 */
/* U+25D7 */	CANT_MAP_CHARACTER,	/* 1495 */
/* U+25D8 */	CANT_MAP_CHARACTER,	/* 1496 */
/* U+25D9 */	CANT_MAP_CHARACTER,	/* 1497 */
/* U+25DA */	CANT_MAP_CHARACTER,	/* 1498 */
/* U+25DB */	CANT_MAP_CHARACTER,	/* 1499 */
/* U+25DC */	CANT_MAP_CHARACTER,	/* 1500 */
/* U+25DD */	CANT_MAP_CHARACTER,	/* 1501 */
/* U+25DE */	CANT_MAP_CHARACTER,	/* 1502 */
/* U+25DF */	CANT_MAP_CHARACTER,	/* 1503 */
/* U+25E0 */	CANT_MAP_CHARACTER,	/* 1504 */
/* U+25E1 */	CANT_MAP_CHARACTER,	/* 1505 */
/* U+25E2 */	CANT_MAP_CHARACTER,	/* 1506 */
/* U+25E3 */	CANT_MAP_CHARACTER,	/* 1507 */
/* U+25E4 */	CANT_MAP_CHARACTER,	/* 1508 */
/* U+25E5 */	CANT_MAP_CHARACTER,	/* 1509 */
/* U+25E6 */	CANT_MAP_CHARACTER,	/* 1510 */
/* U+25E7 */	CANT_MAP_CHARACTER,	/* 1511 */
/* U+25E8 */	CANT_MAP_CHARACTER,	/* 1512 */
/* U+25E9 */	CANT_MAP_CHARACTER,	/* 1513 */
/* U+25EA */	CANT_MAP_CHARACTER,	/* 1514 */
/* U+25EB */	CANT_MAP_CHARACTER,	/* 1515 */
/* U+25EC */	CANT_MAP_CHARACTER,	/* 1516 */
/* U+25ED */	CANT_MAP_CHARACTER,	/* 1517 */
/* U+25EE */	CANT_MAP_CHARACTER,	/* 1518 */
/* U+25EF */	CANT_MAP_CHARACTER,	/* 1519 */
/* U+25F0 */	CANT_MAP_CHARACTER,	/* 1520 */
/* U+25F1 */	CANT_MAP_CHARACTER,	/* 1521 */
/* U+25F2 */	CANT_MAP_CHARACTER,	/* 1522 */
/* U+25F3 */	CANT_MAP_CHARACTER,	/* 1523 */
/* U+25F4 */	CANT_MAP_CHARACTER,	/* 1524 */
/* U+25F5 */	CANT_MAP_CHARACTER,	/* 1525 */
/* U+25F6 */	CANT_MAP_CHARACTER,	/* 1526 */
/* U+25F7 */	CANT_MAP_CHARACTER,	/* 1527 */
/* U+25F8 */	CANT_MAP_CHARACTER,	/* 1528 */
/* U+25F9 */	CANT_MAP_CHARACTER,	/* 1529 */
/* U+25FA */	CANT_MAP_CHARACTER,	/* 1530 */
/* U+25FB */	CANT_MAP_CHARACTER,	/* 1531 */
/* U+25FC */	CANT_MAP_CHARACTER,	/* 1532 */
/* U+25FD */	CANT_MAP_CHARACTER,	/* 1533 */
/* U+25FE */	CANT_MAP_CHARACTER,	/* 1534 */
/* U+25FF */	CANT_MAP_CHARACTER,	/* 1535 */
/* U+FE00 */	CANT_MAP_CHARACTER,	/* 1536 */
/* U+FE01 */	CANT_MAP_CHARACTER,	/* 1537 */
/* U+FE02 */	CANT_MAP_CHARACTER,	/* 1538 */
/* U+FE03 */	CANT_MAP_CHARACTER,	/* 1539 */
/* U+FE04 */	CANT_MAP_CHARACTER,	/* 1540 */
/* U+FE05 */	CANT_MAP_CHARACTER,	/* 1541 */
/* U+FE06 */	CANT_MAP_CHARACTER,	/* 1542 */
/* U+FE07 */	CANT_MAP_CHARACTER,	/* 1543 */
/* U+FE08 */	CANT_MAP_CHARACTER,	/* 1544 */
/* U+FE09 */	CANT_MAP_CHARACTER,	/* 1545 */
/* U+FE0A */	CANT_MAP_CHARACTER,	/* 1546 */
/* U+FE0B */	CANT_MAP_CHARACTER,	/* 1547 */
/* U+FE0C */	CANT_MAP_CHARACTER,	/* 1548 */
/* U+FE0D */	CANT_MAP_CHARACTER,	/* 1549 */
/* U+FE0E */	CANT_MAP_CHARACTER,	/* 1550 */
/* U+FE0F */	CANT_MAP_CHARACTER,	/* 1551 */
/* U+FE10 */	CANT_MAP_CHARACTER,	/* 1552 */
/* U+FE11 */	CANT_MAP_CHARACTER,	/* 1553 */
/* U+FE12 */	CANT_MAP_CHARACTER,	/* 1554 */
/* U+FE13 */	CANT_MAP_CHARACTER,	/* 1555 */
/* U+FE14 */	CANT_MAP_CHARACTER,	/* 1556 */
/* U+FE15 */	CANT_MAP_CHARACTER,	/* 1557 */
/* U+FE16 */	CANT_MAP_CHARACTER,	/* 1558 */
/* U+FE17 */	CANT_MAP_CHARACTER,	/* 1559 */
/* U+FE18 */	CANT_MAP_CHARACTER,	/* 1560 */
/* U+FE19 */	CANT_MAP_CHARACTER,	/* 1561 */
/* U+FE1A */	CANT_MAP_CHARACTER,	/* 1562 */
/* U+FE1B */	CANT_MAP_CHARACTER,	/* 1563 */
/* U+FE1C */	CANT_MAP_CHARACTER,	/* 1564 */
/* U+FE1D */	CANT_MAP_CHARACTER,	/* 1565 */
/* U+FE1E */	CANT_MAP_CHARACTER,	/* 1566 */
/* U+FE1F */	CANT_MAP_CHARACTER,	/* 1567 */
/* U+FE20 */	CANT_MAP_CHARACTER,	/* 1568 */
/* U+FE21 */	CANT_MAP_CHARACTER,	/* 1569 */
/* U+FE22 */	CANT_MAP_CHARACTER,	/* 1570 */
/* U+FE23 */	CANT_MAP_CHARACTER,	/* 1571 */
/* U+FE24 */	CANT_MAP_CHARACTER,	/* 1572 */
/* U+FE25 */	CANT_MAP_CHARACTER,	/* 1573 */
/* U+FE26 */	CANT_MAP_CHARACTER,	/* 1574 */
/* U+FE27 */	CANT_MAP_CHARACTER,	/* 1575 */
/* U+FE28 */	CANT_MAP_CHARACTER,	/* 1576 */
/* U+FE29 */	CANT_MAP_CHARACTER,	/* 1577 */
/* U+FE2A */	CANT_MAP_CHARACTER,	/* 1578 */
/* U+FE2B */	CANT_MAP_CHARACTER,	/* 1579 */
/* U+FE2C */	CANT_MAP_CHARACTER,	/* 1580 */
/* U+FE2D */	CANT_MAP_CHARACTER,	/* 1581 */
/* U+FE2E */	CANT_MAP_CHARACTER,	/* 1582 */
/* U+FE2F */	CANT_MAP_CHARACTER,	/* 1583 */
/* U+FE30 */	CANT_MAP_CHARACTER,	/* 1584 */
/* U+FE31 */	CANT_MAP_CHARACTER,	/* 1585 */
/* U+FE32 */	CANT_MAP_CHARACTER,	/* 1586 */
/* U+FE33 */	CANT_MAP_CHARACTER,	/* 1587 */
/* U+FE34 */	CANT_MAP_CHARACTER,	/* 1588 */
/* U+FE35 */	CANT_MAP_CHARACTER,	/* 1589 */
/* U+FE36 */	CANT_MAP_CHARACTER,	/* 1590 */
/* U+FE37 */	CANT_MAP_CHARACTER,	/* 1591 */
/* U+FE38 */	CANT_MAP_CHARACTER,	/* 1592 */
/* U+FE39 */	CANT_MAP_CHARACTER,	/* 1593 */
/* U+FE3A */	CANT_MAP_CHARACTER,	/* 1594 */
/* U+FE3B */	CANT_MAP_CHARACTER,	/* 1595 */
/* U+FE3C */	CANT_MAP_CHARACTER,	/* 1596 */
/* U+FE3D */	CANT_MAP_CHARACTER,	/* 1597 */
/* U+FE3E */	CANT_MAP_CHARACTER,	/* 1598 */
/* U+FE3F */	CANT_MAP_CHARACTER,	/* 1599 */
/* U+FE40 */	CANT_MAP_CHARACTER,	/* 1600 */
/* U+FE41 */	CANT_MAP_CHARACTER,	/* 1601 */
/* U+FE42 */	CANT_MAP_CHARACTER,	/* 1602 */
/* U+FE43 */	CANT_MAP_CHARACTER,	/* 1603 */
/* U+FE44 */	CANT_MAP_CHARACTER,	/* 1604 */
/* U+FE45 */	CANT_MAP_CHARACTER,	/* 1605 */
/* U+FE46 */	CANT_MAP_CHARACTER,	/* 1606 */
/* U+FE47 */	CANT_MAP_CHARACTER,	/* 1607 */
/* U+FE48 */	CANT_MAP_CHARACTER,	/* 1608 */
/* U+FE49 */	CANT_MAP_CHARACTER,	/* 1609 */
/* U+FE4A */	CANT_MAP_CHARACTER,	/* 1610 */
/* U+FE4B */	CANT_MAP_CHARACTER,	/* 1611 */
/* U+FE4C */	CANT_MAP_CHARACTER,	/* 1612 */
/* U+FE4D */	CANT_MAP_CHARACTER,	/* 1613 */
/* U+FE4E */	CANT_MAP_CHARACTER,	/* 1614 */
/* U+FE4F */	CANT_MAP_CHARACTER,	/* 1615 */
/* U+FE50 */	CANT_MAP_CHARACTER,	/* 1616 */
/* U+FE51 */	CANT_MAP_CHARACTER,	/* 1617 */
/* U+FE52 */	CANT_MAP_CHARACTER,	/* 1618 */
/* U+FE53 */	CANT_MAP_CHARACTER,	/* 1619 */
/* U+FE54 */	CANT_MAP_CHARACTER,	/* 1620 */
/* U+FE55 */	CANT_MAP_CHARACTER,	/* 1621 */
/* U+FE56 */	CANT_MAP_CHARACTER,	/* 1622 */
/* U+FE57 */	CANT_MAP_CHARACTER,	/* 1623 */
/* U+FE58 */	CANT_MAP_CHARACTER,	/* 1624 */
/* U+FE59 */	CANT_MAP_CHARACTER,	/* 1625 */
/* U+FE5A */	CANT_MAP_CHARACTER,	/* 1626 */
/* U+FE5B */	CANT_MAP_CHARACTER,	/* 1627 */
/* U+FE5C */	CANT_MAP_CHARACTER,	/* 1628 */
/* U+FE5D */	CANT_MAP_CHARACTER,	/* 1629 */
/* U+FE5E */	CANT_MAP_CHARACTER,	/* 1630 */
/* U+FE5F */	CANT_MAP_CHARACTER,	/* 1631 */
/* U+FE60 */	CANT_MAP_CHARACTER,	/* 1632 */
/* U+FE61 */	CANT_MAP_CHARACTER,	/* 1633 */
/* U+FE62 */	CANT_MAP_CHARACTER,	/* 1634 */
/* U+FE63 */	CANT_MAP_CHARACTER,	/* 1635 */
/* U+FE64 */	CANT_MAP_CHARACTER,	/* 1636 */
/* U+FE65 */	CANT_MAP_CHARACTER,	/* 1637 */
/* U+FE66 */	CANT_MAP_CHARACTER,	/* 1638 */
/* U+FE67 */	CANT_MAP_CHARACTER,	/* 1639 */
/* U+FE68 */	CANT_MAP_CHARACTER,	/* 1640 */
/* U+FE69 */	CANT_MAP_CHARACTER,	/* 1641 */
/* U+FE6A */	CANT_MAP_CHARACTER,	/* 1642 */
/* U+FE6B */	CANT_MAP_CHARACTER,	/* 1643 */
/* U+FE6C */	CANT_MAP_CHARACTER,	/* 1644 */
/* U+FE6D */	CANT_MAP_CHARACTER,	/* 1645 */
/* U+FE6E */	CANT_MAP_CHARACTER,	/* 1646 */
/* U+FE6F */	CANT_MAP_CHARACTER,	/* 1647 */
/* U+FE70 */	CANT_MAP_CHARACTER,	/* 1648 */
/* U+FE71 */	CANT_MAP_CHARACTER,	/* 1649 */
/* U+FE72 */	CANT_MAP_CHARACTER,	/* 1650 */
/* U+FE73 */	CANT_MAP_CHARACTER,	/* 1651 */
/* U+FE74 */	CANT_MAP_CHARACTER,	/* 1652 */
/* U+FE75 */	CANT_MAP_CHARACTER,	/* 1653 */
/* U+FE76 */	CANT_MAP_CHARACTER,	/* 1654 */
/* U+FE77 */	CANT_MAP_CHARACTER,	/* 1655 */
/* U+FE78 */	CANT_MAP_CHARACTER,	/* 1656 */
/* U+FE79 */	CANT_MAP_CHARACTER,	/* 1657 */
/* U+FE7A */	CANT_MAP_CHARACTER,	/* 1658 */
/* U+FE7B */	CANT_MAP_CHARACTER,	/* 1659 */
/* U+FE7C */	CANT_MAP_CHARACTER,	/* 1660 */
/* U+FE7D */	0xF0	/*                     ARABIC SHADDA MEDIAL FORM */,/* 1661 */
/* U+FE7E */	CANT_MAP_CHARACTER,	/* 1662 */
/* U+FE7F */	CANT_MAP_CHARACTER,	/* 1663 */
/* U+FE80 */	0xC1	/*             ARABIC LETTER HAMZA ISOLATED FORM */,/* 1664 */
/* U+FE81 */	0xC2	/* ARABIC LETTER ALEF WITH MADDA ABOVE ISOLATED FORM */,/* 1665 */
/* U+FE82 */	0xA2	/* ARABIC LETTER ALEF WITH MADDA ABOVE FINAL FORM */,/* 1666 */
/* U+FE83 */	0xC3	/* ARABIC LETTER ALEF WITH HAMZA ABOVE ISOLATED FORM */,/* 1667 */
/* U+FE84 */	0xA5	/* ARABIC LETTER ALEF WITH HAMZA ABOVE FINAL FORM */,/* 1668 */
/* U+FE85 */	0xC4	/* ARABIC LETTER WAW WITH HAMZA ABOVE ISOLATED FORM */,/* 1669 */
/* U+FE86 */	CANT_MAP_CHARACTER,	/* 1670 */
/* U+FE87 */	CANT_MAP_CHARACTER,	/* 1671 */
/* U+FE88 */	CANT_MAP_CHARACTER,	/* 1672 */
/* U+FE89 */	CANT_MAP_CHARACTER,	/* 1673 */
/* U+FE8A */	CANT_MAP_CHARACTER,	/* 1674 */
/* U+FE8B */	0xC6	/* ARABIC LETTER YEH WITH HAMZA ABOVE INITIAL FORM */,/* 1675 */
/* U+FE8C */	CANT_MAP_CHARACTER,	/* 1676 */
/* U+FE8D */	0xC7	/*              ARABIC LETTER ALEF ISOLATED FORM */,/* 1677 */
/* U+FE8E */	0xA8	/*                 ARABIC LETTER ALEF FINAL FORM */,/* 1678 */
/* U+FE8F */	0xA9	/*               ARABIC LETTER BEH ISOLATED FORM */,/* 1679 */
/* U+FE90 */	CANT_MAP_CHARACTER,	/* 1680 */
/* U+FE91 */	0xC8	/*                ARABIC LETTER BEH INITIAL FORM */,/* 1681 */
/* U+FE92 */	CANT_MAP_CHARACTER,	/* 1682 */
/* U+FE93 */	0xC9	/*       ARABIC LETTER TEH MARBUTA ISOLATED FORM */,/* 1683 */
/* U+FE94 */	CANT_MAP_CHARACTER,	/* 1684 */
/* U+FE95 */	0xAA	/*               ARABIC LETTER TEH ISOLATED FORM */,/* 1685 */
/* U+FE96 */	CANT_MAP_CHARACTER,	/* 1686 */
/* U+FE97 */	0xCA	/*                ARABIC LETTER TEH INITIAL FORM */,/* 1687 */
/* U+FE98 */	CANT_MAP_CHARACTER,	/* 1688 */
/* U+FE99 */	0xAB	/*              ARABIC LETTER THEH ISOLATED FORM */,/* 1689 */
/* U+FE9A */	CANT_MAP_CHARACTER,	/* 1690 */
/* U+FE9B */	0xCB	/*               ARABIC LETTER THEH INITIAL FORM */,/* 1691 */
/* U+FE9C */	CANT_MAP_CHARACTER,	/* 1692 */
/* U+FE9D */	0xAD	/*              ARABIC LETTER JEEM ISOLATED FORM */,/* 1693 */
/* U+FE9E */	CANT_MAP_CHARACTER,	/* 1694 */
/* U+FE9F */	0xCC	/*               ARABIC LETTER JEEM INITIAL FORM */,/* 1695 */
/* U+FEA0 */	CANT_MAP_CHARACTER,	/* 1696 */
/* U+FEA1 */	0xAE	/*               ARABIC LETTER HAH ISOLATED FORM */,/* 1697 */
/* U+FEA2 */	CANT_MAP_CHARACTER,	/* 1698 */
/* U+FEA3 */	0xCD	/*                ARABIC LETTER HAH INITIAL FORM */,/* 1699 */
/* U+FEA4 */	CANT_MAP_CHARACTER,	/* 1700 */
/* U+FEA5 */	0xAF	/*              ARABIC LETTER KHAH ISOLATED FORM */,/* 1701 */
/* U+FEA6 */	CANT_MAP_CHARACTER,	/* 1702 */
/* U+FEA7 */	0xCE	/*               ARABIC LETTER KHAH INITIAL FORM */,/* 1703 */
/* U+FEA8 */	CANT_MAP_CHARACTER,	/* 1704 */
/* U+FEA9 */	0xCF	/*               ARABIC LETTER DAL ISOLATED FORM */,/* 1705 */
/* U+FEAA */	CANT_MAP_CHARACTER,	/* 1706 */
/* U+FEAB */	0xD0	/*              ARABIC LETTER THAL ISOLATED FORM */,/* 1707 */
/* U+FEAC */	CANT_MAP_CHARACTER,	/* 1708 */
/* U+FEAD */	0xD1	/*               ARABIC LETTER REH ISOLATED FORM */,/* 1709 */
/* U+FEAE */	CANT_MAP_CHARACTER,	/* 1710 */
/* U+FEAF */	0xD2	/*              ARABIC LETTER ZAIN ISOLATED FORM */,/* 1711 */
/* U+FEB0 */	CANT_MAP_CHARACTER,	/* 1712 */
/* U+FEB1 */	0xBC	/*              ARABIC LETTER SEEN ISOLATED FORM */,/* 1713 */
/* U+FEB2 */	CANT_MAP_CHARACTER,	/* 1714 */
/* U+FEB3 */	0xD3	/*               ARABIC LETTER SEEN INITIAL FORM */,/* 1715 */
/* U+FEB4 */	CANT_MAP_CHARACTER,	/* 1716 */
/* U+FEB5 */	0xBD	/*             ARABIC LETTER SHEEN ISOLATED FORM */,/* 1717 */
/* U+FEB6 */	CANT_MAP_CHARACTER,	/* 1718 */
/* U+FEB7 */	0xD4	/*              ARABIC LETTER SHEEN INITIAL FORM */,/* 1719 */
/* U+FEB8 */	CANT_MAP_CHARACTER,	/* 1720 */
/* U+FEB9 */	0xBE	/*               ARABIC LETTER SAD ISOLATED FORM */,/* 1721 */
/* U+FEBA */	CANT_MAP_CHARACTER,	/* 1722 */
/* U+FEBB */	0xD5	/*                ARABIC LETTER SAD INITIAL FORM */,/* 1723 */
/* U+FEBC */	CANT_MAP_CHARACTER,	/* 1724 */
/* U+FEBD */	0xEB	/*               ARABIC LETTER DAD ISOLATED FORM */,/* 1725 */
/* U+FEBE */	CANT_MAP_CHARACTER,	/* 1726 */
/* U+FEBF */	0xD6	/*                ARABIC LETTER DAD INITIAL FORM */,/* 1727 */
/* U+FEC0 */	CANT_MAP_CHARACTER,	/* 1728 */
/* U+FEC1 */	0xD7	/*               ARABIC LETTER TAH ISOLATED FORM */,/* 1729 */
/* U+FEC2 */	CANT_MAP_CHARACTER,	/* 1730 */
/* U+FEC3 */	CANT_MAP_CHARACTER,	/* 1731 */
/* U+FEC4 */	CANT_MAP_CHARACTER,	/* 1732 */
/* U+FEC5 */	0xD8	/*               ARABIC LETTER ZAH ISOLATED FORM */,/* 1733 */
/* U+FEC6 */	CANT_MAP_CHARACTER,	/* 1734 */
/* U+FEC7 */	CANT_MAP_CHARACTER,	/* 1735 */
/* U+FEC8 */	CANT_MAP_CHARACTER,	/* 1736 */
/* U+FEC9 */	0xDF	/*               ARABIC LETTER AIN ISOLATED FORM */,/* 1737 */
/* U+FECA */	0xC5	/*                  ARABIC LETTER AIN FINAL FORM */,/* 1738 */
/* U+FECB */	0xD9	/*                ARABIC LETTER AIN INITIAL FORM */,/* 1739 */
/* U+FECC */	0xEC	/*                 ARABIC LETTER AIN MEDIAL FORM */,/* 1740 */
/* U+FECD */	0xEE	/*             ARABIC LETTER GHAIN ISOLATED FORM */,/* 1741 */
/* U+FECE */	0xED	/*                ARABIC LETTER GHAIN FINAL FORM */,/* 1742 */
/* U+FECF */	0xDA	/*              ARABIC LETTER GHAIN INITIAL FORM */,/* 1743 */
/* U+FED0 */	0xF7	/*               ARABIC LETTER GHAIN MEDIAL FORM */,/* 1744 */
/* U+FED1 */	0xBA	/*               ARABIC LETTER FEH ISOLATED FORM */,/* 1745 */
/* U+FED2 */	CANT_MAP_CHARACTER,	/* 1746 */
/* U+FED3 */	0xE1	/*                ARABIC LETTER FEH INITIAL FORM */,/* 1747 */
/* U+FED4 */	CANT_MAP_CHARACTER,	/* 1748 */
/* U+FED5 */	0xF8	/*               ARABIC LETTER QAF ISOLATED FORM */,/* 1749 */
/* U+FED6 */	CANT_MAP_CHARACTER,	/* 1750 */
/* U+FED7 */	0xE2	/*                ARABIC LETTER QAF INITIAL FORM */,/* 1751 */
/* U+FED8 */	CANT_MAP_CHARACTER,	/* 1752 */
/* U+FED9 */	0xFC	/*               ARABIC LETTER KAF ISOLATED FORM */,/* 1753 */
/* U+FEDA */	CANT_MAP_CHARACTER,	/* 1754 */
/* U+FEDB */	0xE3	/*                ARABIC LETTER KAF INITIAL FORM */,/* 1755 */
/* U+FEDC */	CANT_MAP_CHARACTER,	/* 1756 */
/* U+FEDD */	0xFB	/*               ARABIC LETTER LAM ISOLATED FORM */,/* 1757 */
/* U+FEDE */	CANT_MAP_CHARACTER,	/* 1758 */
/* U+FEDF */	0xE4	/*                ARABIC LETTER LAM INITIAL FORM */,/* 1759 */
/* U+FEE0 */	CANT_MAP_CHARACTER,	/* 1760 */
/* U+FEE1 */	0xEF	/*              ARABIC LETTER MEEM ISOLATED FORM */,/* 1761 */
/* U+FEE2 */	CANT_MAP_CHARACTER,	/* 1762 */
/* U+FEE3 */	0xE5	/*               ARABIC LETTER MEEM INITIAL FORM */,/* 1763 */
/* U+FEE4 */	CANT_MAP_CHARACTER,	/* 1764 */
/* U+FEE5 */	0xF2	/*              ARABIC LETTER NOON ISOLATED FORM */,/* 1765 */
/* U+FEE6 */	CANT_MAP_CHARACTER,	/* 1766 */
/* U+FEE7 */	0xE6	/*               ARABIC LETTER NOON INITIAL FORM */,/* 1767 */
/* U+FEE8 */	CANT_MAP_CHARACTER,	/* 1768 */
/* U+FEE9 */	0xF3	/*               ARABIC LETTER HEH ISOLATED FORM */,/* 1769 */
/* U+FEEA */	CANT_MAP_CHARACTER,	/* 1770 */
/* U+FEEB */	0xE7	/*                ARABIC LETTER HEH INITIAL FORM */,/* 1771 */
/* U+FEEC */	0xF4	/*                 ARABIC LETTER HEH MEDIAL FORM */,/* 1772 */
/* U+FEED */	0xE8	/*               ARABIC LETTER WAW ISOLATED FORM */,/* 1773 */
/* U+FEEE */	CANT_MAP_CHARACTER,	/* 1774 */
/* U+FEEF */	0xE9	/*      ARABIC LETTER ALEF MAKSURA ISOLATED FORM */,/* 1775 */
/* U+FEF0 */	0xF5	/*         ARABIC LETTER ALEF MAKSURA FINAL FORM */,/* 1776 */
/* U+FEF1 */	0xFD	/*               ARABIC LETTER YEH ISOLATED FORM */,/* 1777 */
/* U+FEF2 */	0xF6	/*                  ARABIC LETTER YEH FINAL FORM */,/* 1778 */
/* U+FEF3 */	0xEA	/*                ARABIC LETTER YEH INITIAL FORM */,/* 1779 */
/* U+FEF4 */	CANT_MAP_CHARACTER,	/* 1780 */
/* U+FEF5 */	0xF9	/* ARABIC LIGATURE LAM WITH ALEF WITH MADDA ABOVE ISOLATED FORM */,/* 1781 */
/* U+FEF6 */	0xFA	/* ARABIC LIGATURE LAM WITH ALEF WITH MADDA ABOVE FINAL FORM */,/* 1782 */
/* U+FEF7 */	0x99	/* ARABIC LIGATURE LAM WITH ALEF WITH HAMZA ABOVE ISOLATED FORM */,/* 1783 */
/* U+FEF8 */	0x9A	/* ARABIC LIGATURE LAM WITH ALEF WITH HAMZA ABOVE FINAL FORM */,/* 1784 */
/* U+FEF9 */	CANT_MAP_CHARACTER,	/* 1785 */
/* U+FEFA */	CANT_MAP_CHARACTER,	/* 1786 */
/* U+FEFB */	0x9D	/*   ARABIC LIGATURE LAM WITH ALEF ISOLATED FORM */,/* 1787 */
/* U+FEFC */	0x9E	/*      ARABIC LIGATURE LAM WITH ALEF FINAL FORM */,/* 1788 */
/* U+FEFD */	CANT_MAP_CHARACTER,	/* 1789 */
/* U+FEFE */	CANT_MAP_CHARACTER,	/* 1790 */
/* U+FEFF */	CANT_MAP_CHARACTER,	/* 1791 */
	0 /* END OF MAP TABLE */
};
static const USHORT from_unicode_map[256] = {
/* U+00-- */	256,
/* U+01-- */	0,
/* U+02-- */	0,
/* U+03-- */	512,
/* U+04-- */	0,
/* U+05-- */	0,
/* U+06-- */	768,
/* U+07-- */	0,
/* U+08-- */	0,
/* U+09-- */	0,
/* U+0A-- */	0,
/* U+0B-- */	0,
/* U+0C-- */	0,
/* U+0D-- */	0,
/* U+0E-- */	0,
/* U+0F-- */	0,
/* U+10-- */	0,
/* U+11-- */	0,
/* U+12-- */	0,
/* U+13-- */	0,
/* U+14-- */	0,
/* U+15-- */	0,
/* U+16-- */	0,
/* U+17-- */	0,
/* U+18-- */	0,
/* U+19-- */	0,
/* U+1A-- */	0,
/* U+1B-- */	0,
/* U+1C-- */	0,
/* U+1D-- */	0,
/* U+1E-- */	0,
/* U+1F-- */	0,
/* U+20-- */	0,
/* U+21-- */	0,
/* U+22-- */	1024,
/* U+23-- */	0,
/* U+24-- */	0,
/* U+25-- */	1280,
/* U+26-- */	0,
/* U+27-- */	0,
/* U+28-- */	0,
/* U+29-- */	0,
/* U+2A-- */	0,
/* U+2B-- */	0,
/* U+2C-- */	0,
/* U+2D-- */	0,
/* U+2E-- */	0,
/* U+2F-- */	0,
/* U+30-- */	0,
/* U+31-- */	0,
/* U+32-- */	0,
/* U+33-- */	0,
/* U+34-- */	0,
/* U+35-- */	0,
/* U+36-- */	0,
/* U+37-- */	0,
/* U+38-- */	0,
/* U+39-- */	0,
/* U+3A-- */	0,
/* U+3B-- */	0,
/* U+3C-- */	0,
/* U+3D-- */	0,
/* U+3E-- */	0,
/* U+3F-- */	0,
/* U+40-- */	0,
/* U+41-- */	0,
/* U+42-- */	0,
/* U+43-- */	0,
/* U+44-- */	0,
/* U+45-- */	0,
/* U+46-- */	0,
/* U+47-- */	0,
/* U+48-- */	0,
/* U+49-- */	0,
/* U+4A-- */	0,
/* U+4B-- */	0,
/* U+4C-- */	0,
/* U+4D-- */	0,
/* U+4E-- */	0,
/* U+4F-- */	0,
/* U+50-- */	0,
/* U+51-- */	0,
/* U+52-- */	0,
/* U+53-- */	0,
/* U+54-- */	0,
/* U+55-- */	0,
/* U+56-- */	0,
/* U+57-- */	0,
/* U+58-- */	0,
/* U+59-- */	0,
/* U+5A-- */	0,
/* U+5B-- */	0,
/* U+5C-- */	0,
/* U+5D-- */	0,
/* U+5E-- */	0,
/* U+5F-- */	0,
/* U+60-- */	0,
/* U+61-- */	0,
/* U+62-- */	0,
/* U+63-- */	0,
/* U+64-- */	0,
/* U+65-- */	0,
/* U+66-- */	0,
/* U+67-- */	0,
/* U+68-- */	0,
/* U+69-- */	0,
/* U+6A-- */	0,
/* U+6B-- */	0,
/* U+6C-- */	0,
/* U+6D-- */	0,
/* U+6E-- */	0,
/* U+6F-- */	0,
/* U+70-- */	0,
/* U+71-- */	0,
/* U+72-- */	0,
/* U+73-- */	0,
/* U+74-- */	0,
/* U+75-- */	0,
/* U+76-- */	0,
/* U+77-- */	0,
/* U+78-- */	0,
/* U+79-- */	0,
/* U+7A-- */	0,
/* U+7B-- */	0,
/* U+7C-- */	0,
/* U+7D-- */	0,
/* U+7E-- */	0,
/* U+7F-- */	0,
/* U+80-- */	0,
/* U+81-- */	0,
/* U+82-- */	0,
/* U+83-- */	0,
/* U+84-- */	0,
/* U+85-- */	0,
/* U+86-- */	0,
/* U+87-- */	0,
/* U+88-- */	0,
/* U+89-- */	0,
/* U+8A-- */	0,
/* U+8B-- */	0,
/* U+8C-- */	0,
/* U+8D-- */	0,
/* U+8E-- */	0,
/* U+8F-- */	0,
/* U+90-- */	0,
/* U+91-- */	0,
/* U+92-- */	0,
/* U+93-- */	0,
/* U+94-- */	0,
/* U+95-- */	0,
/* U+96-- */	0,
/* U+97-- */	0,
/* U+98-- */	0,
/* U+99-- */	0,
/* U+9A-- */	0,
/* U+9B-- */	0,
/* U+9C-- */	0,
/* U+9D-- */	0,
/* U+9E-- */	0,
/* U+9F-- */	0,
/* U+A0-- */	0,
/* U+A1-- */	0,
/* U+A2-- */	0,
/* U+A3-- */	0,
/* U+A4-- */	0,
/* U+A5-- */	0,
/* U+A6-- */	0,
/* U+A7-- */	0,
/* U+A8-- */	0,
/* U+A9-- */	0,
/* U+AA-- */	0,
/* U+AB-- */	0,
/* U+AC-- */	0,
/* U+AD-- */	0,
/* U+AE-- */	0,
/* U+AF-- */	0,
/* U+B0-- */	0,
/* U+B1-- */	0,
/* U+B2-- */	0,
/* U+B3-- */	0,
/* U+B4-- */	0,
/* U+B5-- */	0,
/* U+B6-- */	0,
/* U+B7-- */	0,
/* U+B8-- */	0,
/* U+B9-- */	0,
/* U+BA-- */	0,
/* U+BB-- */	0,
/* U+BC-- */	0,
/* U+BD-- */	0,
/* U+BE-- */	0,
/* U+BF-- */	0,
/* U+C0-- */	0,
/* U+C1-- */	0,
/* U+C2-- */	0,
/* U+C3-- */	0,
/* U+C4-- */	0,
/* U+C5-- */	0,
/* U+C6-- */	0,
/* U+C7-- */	0,
/* U+C8-- */	0,
/* U+C9-- */	0,
/* U+CA-- */	0,
/* U+CB-- */	0,
/* U+CC-- */	0,
/* U+CD-- */	0,
/* U+CE-- */	0,
/* U+CF-- */	0,
/* U+D0-- */	0,
/* U+D1-- */	0,
/* U+D2-- */	0,
/* U+D3-- */	0,
/* U+D4-- */	0,
/* U+D5-- */	0,
/* U+D6-- */	0,
/* U+D7-- */	0,
/* U+D8-- */	0,
/* U+D9-- */	0,
/* U+DA-- */	0,
/* U+DB-- */	0,
/* U+DC-- */	0,
/* U+DD-- */	0,
/* U+DE-- */	0,
/* U+DF-- */	0,
/* U+E0-- */	0,
/* U+E1-- */	0,
/* U+E2-- */	0,
/* U+E3-- */	0,
/* U+E4-- */	0,
/* U+E5-- */	0,
/* U+E6-- */	0,
/* U+E7-- */	0,
/* U+E8-- */	0,
/* U+E9-- */	0,
/* U+EA-- */	0,
/* U+EB-- */	0,
/* U+EC-- */	0,
/* U+ED-- */	0,
/* U+EE-- */	0,
/* U+EF-- */	0,
/* U+F0-- */	0,
/* U+F1-- */	0,
/* U+F2-- */	0,
/* U+F3-- */	0,
/* U+F4-- */	0,
/* U+F5-- */	0,
/* U+F6-- */	0,
/* U+F7-- */	0,
/* U+F8-- */	0,
/* U+F9-- */	0,
/* U+FA-- */	0,
/* U+FB-- */	0,
/* U+FC-- */	0,
/* U+FD-- */	0,
/* U+FE-- */	1536,
/* U+FF-- */	0,
};
