% firehol-proxy(5) FireHOL Reference | VERSION
% FireHOL Team
% Built DATE

# NAME

firehol-proxy - set up a transparent TCP, HTTP or squid proxy

<!--
extra-manpage: firehol-transparent_proxy.5
extra-manpage: firehol-transparent_squid.5
  -->

# SYNOPSIS

transparent\_proxy *service* *port* *user* *rule-params*

transparent\_squid *port* *user* *rule-params*

# DESCRIPTION

The `transparent_proxy` helper command sets up transparent caching for
TCP traffic.

The `transparent_squid` helper command sets up the special case for HTTP
traffic with *service* implicitly set to 80.

> **Note**
>
> The proxy application must be running on the firewall host at port
> *port* with the credentials of the local user *user* (which may be a
> space-delimited list enclosed in quotes) serving requests appropriate
> to the TCP port service.

The *rule-params* define a set of rule parameters to define the traffic
that is to be proxied. See [firehol-params(5)][] for
more details.

For traffic destined for the firewall host or passing through the
firewall, do not use the `outface` parameter because the rules are applied
before the routing decision and so the outgoing interface will not be
known.

An empty *user* string ("") disables caching of locally-generated traffic.
Otherwise, traffic starting from the firewall is captured, except that
traffic generated by the local user(s) *user*. The `inface`, `outface` and
`src` *rule-params* are all ignored for locally-generated traffic.

# EXAMPLES

~~~~

transparent_proxy 80 3128 squid inface eth0 src 192.0.2.0/24
transparent_squid 3128 squid inface eth0 src 192.0.2.0/24

transparent_proxy "80 3128 8080" 3128 "squid privoxy root bin" \
      inface not "ppp+ ipsec+" dst not "a.not.proxied.server"
transparent_squid "80 3128 8080" "squid privoxy root bin" \
      inface not "ppp+ ipsec+" dst not "non.proxied.server"
~~~~

# SEE ALSO

* [firehol(1)][] - FireHOL program
* [firehol.conf(5)][] - FireHOL configuration
* [firehol-interface(5)][keyword-firehol-interface] - interface definition
* [firehol-router(5)][keyword-firehol-router] - router definition
* [firehol-params(5)][] - optional rule parameters
* [firehol-nat(5)][] - nat, snat, dnat, redirect config helpers
* [FireHOL Website](http://firehol.org/)
* [FireHOL Online PDF Manual](http://firehol.org/firehol-manual.pdf)
* [FireHOL Online HTML Manual](http://firehol.org/manual)
