/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | Copyright (C) 1991-2010 OpenCFD Ltd.
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::fileFormats::X3DsurfaceFormat

Description
    Provide a means of writing x3d format.

SourceFiles
    X3DsurfaceFormat.C

\*---------------------------------------------------------------------------*/

#ifndef X3DsurfaceFormat_H
#define X3DsurfaceFormat_H

#include <surfMesh/MeshedSurface.H>
#include <surfMesh/MeshedSurfaceProxy.H>
#include <surfMesh/UnsortedMeshedSurface.H>
#include "X3DsurfaceFormatCore.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{
namespace fileFormats
{

/*---------------------------------------------------------------------------*\
                      Class X3DsurfaceFormat Declaration
\*---------------------------------------------------------------------------*/

template<class Face>
class X3DsurfaceFormat
:
    public MeshedSurface<Face>,
    public X3DsurfaceFormatCore
{
    // Private Member Functions

        //- Disallow default bitwise copy construct
        X3DsurfaceFormat(const X3DsurfaceFormat<Face>&);

        //- Disallow default bitwise assignment
        void operator=(const X3DsurfaceFormat<Face>&);

public:

    // Constructors

        //- Construct null
        X3DsurfaceFormat();


    // Destructor

        virtual ~X3DsurfaceFormat()
        {}


    // Member Functions

        //- Write surface mesh components by proxy
        static void write(const fileName&, const MeshedSurfaceProxy<Face>&);

        //- Write object file
        virtual void write(const fileName& name) const
        {
            write(name, MeshedSurfaceProxy<Face>(*this));
        }

};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace fileFormats
} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#ifdef NoRepository
#   include "X3DsurfaceFormat.C"
#endif

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************ vim: set sw=4 sts=4 et: ************************ //
