#!/bin/sh
REV=e3d6339c5d69e0791c4633f86363159e56126075
VERS=$(dpkg-parsechangelog | sed -ne 's/^Version: \(\([0-9]\+\):\)\?\(.*\)-.*/\3/p')
NAME=fso-frameworkd
REPO=git://git.freesmartphone.org/framework.git

# switch to tmp directory
rm -rf get-orig-source
mkdir get-orig-source
cd get-orig-source

# get src from git
git clone ${REPO} ${NAME}-${REV}
cd ${NAME}-${REV}
git archive --format=tar --prefix=${NAME}-${VERS}/ ${REV} > ../${NAME}-${VERS}-tmp.tar
cd ..
rm -rf ${NAME}-${REV}
tar xf ${NAME}-${VERS}-tmp.tar
rm ${NAME}-${VERS}-tmp.tar

# generate the orig.tar.gz
GZIP=--best tar czf ../${NAME}_${VERS}.orig.tar.gz ${NAME}-${VERS}
rm -rf ${NAME}-${VERS}

# remove tmp directory
cd ..
rm -rf get-orig-source

echo "  ${NAME}_${VERS}.orig.tar.gz created; move it to the right destination to build the package"
