/*
 * Decompiled with CFR 0.152.
 */
package hypergraph.graphApi.algorithms;

import hypergraph.graphApi.Edge;
import hypergraph.graphApi.Node;
import hypergraph.graphApi.algorithms.GraphWalker;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class BFSGraphWalker
extends GraphWalker {
    private Node startNode;
    private boolean ignoreVisitedNodes = true;
    private Set visitedNodes = new HashSet();
    private Set visitedEdges = new HashSet();
    private Set currentNodes = new HashSet();
    private Set nextNodes = new HashSet();
    private int iteration;

    public int getIteration() {
        return this.iteration;
    }

    public void setStartNode(Node node) {
        this.startNode = node;
    }

    public void setIgnoreVisited(boolean bl) {
        this.ignoreVisitedNodes = bl;
    }

    public boolean isIgnoreVisited() {
        return this.ignoreVisitedNodes;
    }

    public void walk() {
        if (this.startNode == null) {
            return;
        }
        this.iteration = 0;
        this.visitedNodes.clear();
        this.visitedEdges.clear();
        this.currentNodes.clear();
        this.nextNodes.clear();
        this.visitElement(this.startNode);
        this.visitedNodes.add(this.startNode);
        this.currentNodes.add(this.startNode);
        while (!this.currentNodes.isEmpty()) {
            ++this.iteration;
            Object object = this.currentNodes.iterator();
            while (object.hasNext()) {
                Node node = (Node)object.next();
                Collection collection = this.getGraph().getEdges(node);
                if (collection == null) continue;
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    Edge edge = (Edge)iterator.next();
                    if (this.visitedEdges.contains(edge)) continue;
                    this.visitedEdges.add(edge);
                    Node node2 = edge.getOtherNode(node);
                    if (this.ignoreVisitedNodes && this.visitedNodes.contains(node2)) continue;
                    this.visitElement(edge);
                    this.visitElement(node2);
                    this.visitedNodes.add(node2);
                    this.nextNodes.add(node2);
                }
            }
            this.currentNodes.clear();
            object = this.currentNodes;
            this.currentNodes = this.nextNodes;
            this.nextNodes = object;
        }
    }
}

