// moment.js language configuration
// language : russian (ru)
// author : Viktorminator : https://github.com/Viktorminator
(function () {

    var pluralRules = [
        function (n) { return ((n % 10 === 1) && (n % 100 !== 11)); },
        function (n) { return ((n % 10) >= 2 && (n % 10) <= 4 && ((n % 10) % 1) === 0) && ((n % 100) < 12 || (n % 100) > 14); },
        function (n) { return ((n % 10) === 0 || ((n % 10) >= 5 && (n % 10) <= 9 && ((n % 10) % 1) === 0) || ((n % 100) >= 11 && (n % 100) <= 14 && ((n % 100) % 1) === 0)); },
        function (n) { return true; }
    ],

    plural = function (word, num) {
        var forms = word.split('_'),
        minCount = Math.min(pluralRules.length, forms.length),
        i = -1;

        while (++i < minCount) {
            if (pluralRules[i](num)) {
                return forms[i];
            }
        }
        return forms[minCount - 1];
    },

    relativeTimeWithPlural = function (number, withoutSuffix, key) {
        var format = {
            'mm': 'минута_минуты_минут_минуты',
            'hh': 'час_часа_часов_часа',
            'dd': 'день_дня_дней_дня',
            'MM': 'месяц_месяца_месяцев_месяца',
            'yy': 'год_года_лет_года'
        };
        if (key === 'm') {
            return withoutSuffix ? 'минута' : 'минуту';
        }
        else {
            return number + ' ' + plural(format[key], +number);
        }
    },

    monthsCaseReplace = function (m, format) {
        var months = {
            'nominative': 'январь_февраль_март_апрель_май_июнь_июль_август_сентябрь_октябрь_ноябрь_декабрь'.split('_'),
            'accusative': 'января_февраля_марта_апреля_мая_июня_июля_августа_сентября_октября_ноября_декабря'.split('_')
        },

        nounCase = (/D[oD]? *MMMM?/).test(format) ?
            'accusative' :
            'nominative';

        return months[nounCase][m.month()];
    },

    weekdaysCaseReplace = function (m, format) {
        var weekdays = {
            'nominative': 'воскресенье_понедельник_вторник_среда_четверг_пятница_суббота'.split('_'),
            'accusative': 'воскресенье_понедельник_вторник_среду_четверг_пятницу_субботу'.split('_')
        },

        nounCase = (/\[ ?[Вв] ?(?:прошлую|следующую)? ?\] ?dddd/).test(format) ?
            'accusative' :
            'nominative';

        return weekdays[nounCase][m.day()];
    },

    lang = {
            months : monthsCaseReplace,
            monthsShort : "янв_фев_мар_апр_май_июн_июл_авг_сен_окт_ноя_дек".split("_"),
            weekdays : weekdaysCaseReplace,
            weekdaysShort : "вск_пнд_втр_срд_чтв_птн_сбт".split("_"),
            weekdaysMin : "вс_пн_вт_ср_чт_пт_сб".split("_"),
            longDateFormat : {
                LT : "HH:mm",
                L : "DD.MM.YYYY",
                LL : "D MMMM YYYY г.",
                LLL : "D MMMM YYYY г., LT",
                LLLL : "dddd, D MMMM YYYY г., LT"
            },
            calendar : {
                sameDay: '[Сегодня в] LT',
                nextDay: '[Завтра в] LT',
                lastDay: '[Вчера в] LT',
                nextWeek: function () {
                    return this.day() === 2 ? '[Во] dddd [в] LT' : '[В] dddd [в] LT';
                },
                lastWeek: function () {
                    switch (this.day()) {
                    case 0:
                        return '[В прошлое] dddd [в] LT';
                    case 1:
                    case 2:
                    case 4:
                        return '[В прошлый] dddd [в] LT';
                    case 3:
                    case 5:
                    case 6:
                        return '[В прошлую] dddd [в] LT';
                    }
                },
                sameElse: 'L'
            },
            // It needs checking (adding) russian plurals and cases.
            relativeTime : {
                future : "через %s",
                past : "%s назад",
                s : "несколько секунд",
                m : relativeTimeWithPlural,
                mm : relativeTimeWithPlural,
                h : "час",
                hh : relativeTimeWithPlural,
                d : "день",
                dd : relativeTimeWithPlural,
                M : "месяц",
                MM : relativeTimeWithPlural,
                y : "год",
                yy : relativeTimeWithPlural
            },
            ordinal : function (number) {
                return '.';
            }
        };

    // Node
    if (typeof module !== 'undefined' && module.exports) {
        module.exports = lang;
    }
    // Browser
    if (typeof window !== 'undefined' && this.moment && this.moment.lang) {
        this.moment.lang('ru', lang);
    }
}());
