# SPDX-License-Identifier: Apache-2.0
# SPDX-FileCopyrightText: Zygmunt Krynicki
QEMU_SYSTEM_AARCH64 ?= $(if $(value SNAP_INSTANCE_NAME),$$(test -z "$${SNAP_INSTANCE_NAME-}" && echo $(SNAP_INSTANCE_NAME).)qemu-system-aarch64,$(or $(shell command -v qemu-system-aarch64),$(warning program qemu-system-aarch64 is required)qemu-system-aarch64))
QEMU_SYSTEM_AARCH64_MACHINE = virt,gic-version=max
QEMU_CPU_AARCH64 = max
QEMU_SMP_AARCH64 = 1
QEMU_DEFAULT_NET_OPTION_AARCH64 ?= \
	-netdev user,id=netdev0$(QEMU_DEFAULT_NETDEV_SYS_EXTRA)$${QEMU_NETDEV_USER_EXTRA:-} \
	-device virtio-net-pci,netdev=netdev0,id=net0 \
	-smbios type=41,designation=Virtual-LAN,instance=1,kind=ethernet,pcidev=net0
QEMU_SYSTEM_AARCH64_EFI_CMDLINE = \
	$(QEMU_ENV_QUIRKS) \
	exec $(QEMU_SYSTEM_AARCH64) \
	-cpu $(QEMU_CPU_AARCH64) \
	-machine $(QEMU_SYSTEM_AARCH64_MACHINE)$${QEMU_ACCEL_MACHINE_PROP=,accel=`$(QEMU_SYSTEM_AARCH64) -accel help | tail -n +2 | sort | paste -sd :`} \
	$${QEMU_MEM_OPTION=$(QEMU_DEFAULT_MEM_OPTION)} \
	$${QEMU_SMP_OPTION=-smp $(QEMU_SMP_AARCH64)} \
	$${QEMU_DISPLAY_OPTION=$(QEMU_DEFAULT_DISPLAY_OPTION)} \
	$${QEMU_BOOT_FIRMWARE_OPTION=-drive if=pflash,format=raw,unit=0,file=$(2),readonly=on \
		-drive if=pflash,format=raw,unit=1,file=$(3)} \
	$${QEMU_STORAGE_OPTION=-drive file=$(1),if=none,format=qcow2,id=drive0,media=disk,cache=writeback,discard=unmap \
		-device virtio-blk,drive=drive0,bootindex=0} \
	$${QEMU_RNG_OPTION=$(QEMU_DEFAULT_RNG_OPTION)} \
	$${QEMU_NET_OPTION=$(QEMU_DEFAULT_NET_OPTION_AARCH64)}
QEMU_EDK2_CODE_AARCH64 ?= \
	/usr/share/AAVMF/AAVMF_CODE.fd \
	/usr/share/qemu/aavmf-aarch64-code.bin
QEMU_EDK2_VARS_AARCH64 ?= \
	/usr/share/AAVMF/AAVMF_VARS.fd \
	/usr/share/qemu/aavmf-aarch64-vars.bin

ifneq (,$(value SNAP))
QEMU_EDK2_CODE_AARCH64 += $(SNAP)/components/qemu-aarch64/share/qemu/edk2-aarch64-code.fd
QEMU_EDK2_VARS_AARCH64 += $(SNAP)/components/qemu-aarch64/share/qemu/edk2-arm-vars.fd
endif

ifneq (,$(value GARDEN_AARCH64_PREFIX))
QEMU_EDK2_CODE_AARCH64 += $(GARDEN_AARCH64_PREFIX)/share/qemu/edk2-aarch64-code.fd
QEMU_EDK2_VARS_AARCH64 += $(GARDEN_AARCH64_PREFIX)/share/qemu/edk2-arm-vars.fd
endif


efi-code.aarch64.img: $(or $(firstword $(wildcard $(QEMU_EDK2_CODE_AARCH64))),$(warning please install aarch64 edk2 firmware - not in $(QEMU_EDK2_CODE_AARCH64)))
	cp --preserve=timestamps $< $@

efi-vars.aarch64.img: $(or $(firstword $(wildcard $(QEMU_EDK2_VARS_AARCH64))),$(warning please install aarch64 edk2 firmware - not in $(QEMU_EDK2_VARS_AARCH64)))
	cp --preserve=timestamps $< $@

%.aarch64.efi-code.img: | efi-code.aarch64.img
	ln -sf $(firstword $|) $@

%.aarch64.efi-vars.img: efi-vars.aarch64.img
	cp --preserve=timestamps $< $@

.PHONY: clean
clean::
	rm -f efi-code.aarch64.img efi-vars.aarch64.img
	rm -f *.aarch64.qcow2 *.aarch64.efi-code.img *.aarch64.efi-vars.img
