/*
 * Decompiled with CFR 0.152.
 */
package org.freshcookies.security.cert;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.freshcookies.security.cert.Trustee;

public class JarHelper {
    private Map caCache = new HashMap();
    private Map certCache = new HashMap();
    private Set jars = new HashSet();

    public static void main(String[] args) {
        X509Certificate cert;
        if (args.length == 0) {
            System.err.println("FATAL: you must supply a jar file (e.g., foo.jar)");
            System.exit(1);
        }
        if (args[0].equals("--help") | args[0].equals("-h")) {
            System.out.println("Usage: JarHelper jarfile");
            System.exit(0);
        }
        String file = args[0];
        Trustee trustee = new Trustee();
        JarHelper helper = new JarHelper();
        System.out.print("Extracting signing certificates from " + file + "... ");
        Set cas = new HashSet();
        Set signers = new HashSet();
        try {
            JarFile jar = new JarFile(new File(file), true);
            cas = helper.extractCACertificates(jar);
            signers = helper.extractSigningCertificates(jar);
        }
        catch (IOException e) {
            System.err.println("Couldn't get jar certificates: " + e.getLocalizedMessage());
        }
        System.out.println("Found " + cas.size() + " CA certificates.");
        boolean certsAdded = false;
        int i = 0;
        Iterator it = cas.iterator();
        while (it.hasNext()) {
            cert = (X509Certificate)it.next();
            System.out.println("CA certificate [" + i + "]:");
            System.out.println(Trustee.getCertificateInfo(cert));
            try {
                certsAdded |= trustee.trustCACertificate(cert);
            }
            catch (Exception e) {
                System.err.println("Could not add certificate to trust store: " + e.getLocalizedMessage());
            }
            ++i;
        }
        System.out.println("Found " + signers.size() + " signing certificates.");
        i = 0;
        it = signers.iterator();
        while (it.hasNext()) {
            cert = (X509Certificate)it.next();
            System.out.println(Trustee.getCertificateInfo(cert));
        }
        try {
            it = cas.iterator();
            while (it.hasNext()) {
                cert = (X509Certificate)it.next();
                trustee.saveCertificate(cert);
            }
            it = signers.iterator();
            while (it.hasNext()) {
                cert = (X509Certificate)it.next();
                trustee.saveCertificate(cert);
            }
        }
        catch (Exception e) {
            System.err.println("Could not save certificate: " + e.getLocalizedMessage());
        }
        System.out.print("Committing changes to trust store... ");
        if (trustee.commit()) {
            System.err.println("done.");
        } else {
            System.err.println("trust store not saved.");
        }
    }

    public Set extractCACertificates(JarFile jar) throws IOException {
        if (!this.jars.contains(jar)) {
            this.extractJarCerts(jar);
            this.jars.add(jar);
        }
        return (Set)this.caCache.get(jar);
    }

    public Set extractSigningCertificates(JarFile jar) throws IOException {
        if (!this.jars.contains(jar)) {
            this.extractJarCerts(jar);
            this.jars.add(jar);
        }
        return (Set)this.certCache.get(jar);
    }

    private void extractJarCerts(JarFile jar) throws IOException {
        HashSet<Certificate> cas = new HashSet<Certificate>();
        HashSet<X509Certificate> certs = new HashSet<X509Certificate>();
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            InputStream is = jar.getInputStream(entry);
            byte[] buf = new byte[1024];
            while (is.read(buf) > 0) {
            }
            is.close();
            Certificate[] signingCerts = entry.getCertificates();
            if (signingCerts == null) continue;
            int i = 0;
            while (i < signingCerts.length) {
                Certificate cert = signingCerts[i];
                if (cert instanceof X509Certificate) {
                    X509Certificate x509cert = (X509Certificate)cert;
                    if (i == 0 && !certs.contains(x509cert)) {
                        certs.add(x509cert);
                    } else if (i > 0 && !cas.contains(x509cert)) {
                        cas.add(x509cert);
                    }
                }
                ++i;
            }
            if (signingCerts.length != 1 || !(signingCerts[0] instanceof X509Certificate)) continue;
            cas.add(signingCerts[0]);
        }
        this.caCache.put(jar, cas);
        this.certCache.put(jar, certs);
    }
}

