/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.controller.multipart;

import com.oreilly.servlet.MultipartRequest;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.stripes.action.FileBean;
import net.sourceforge.stripes.controller.FileUploadLimitExceededException;
import net.sourceforge.stripes.controller.multipart.MultipartWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CosMultipartWrapper
implements MultipartWrapper {
    private static Pattern EXCEPTION_PATTERN = Pattern.compile("Posted content length of (\\d*) exceeds limit of (\\d*)");
    private MultipartRequest multipart;
    private String charset;

    @Override
    public void build(HttpServletRequest request, File tempDir, long maxPostSize) throws IOException, FileUploadLimitExceededException {
        try {
            this.charset = request.getCharacterEncoding();
            this.multipart = new MultipartRequest(request, tempDir.getAbsolutePath(), (int)maxPostSize, this.charset);
        }
        catch (IOException ioe) {
            Matcher matcher = EXCEPTION_PATTERN.matcher(ioe.getMessage());
            if (matcher.matches()) {
                throw new FileUploadLimitExceededException(Long.parseLong(matcher.group(2)), Long.parseLong(matcher.group(1)));
            }
            throw ioe;
        }
    }

    @Override
    public Enumeration<String> getParameterNames() {
        return this.multipart.getParameterNames();
    }

    @Override
    public String[] getParameterValues(String name) {
        String[] values = this.multipart.getParameterValues(name);
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                if (values[i] != null) continue;
                values[i] = "";
            }
        }
        return values;
    }

    @Override
    public Enumeration<String> getFileParameterNames() {
        return this.multipart.getFileNames();
    }

    @Override
    public FileBean getFileParameterValue(String name) {
        File file = this.multipart.getFile(name);
        if (file != null) {
            return new FileBean(file, this.multipart.getContentType(name), this.multipart.getOriginalFileName(name), this.charset);
        }
        return null;
    }

    static {
        MultipartRequest.class.getName();
    }
}

