/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.util.bean;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.sourceforge.stripes.util.ReflectUtil;
import net.sourceforge.stripes.util.bean.EvaluationException;
import net.sourceforge.stripes.util.bean.NoSuchPropertyException;
import net.sourceforge.stripes.util.bean.NodeEvaluation;
import net.sourceforge.stripes.util.bean.PropertyAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBeanPropertyAccessor
implements PropertyAccessor<Object> {
    @Override
    public Object getValue(NodeEvaluation evaluation, Object bean) throws NoSuchPropertyException, EvaluationException {
        String property = evaluation.getNode().getStringValue();
        PropertyDescriptor pd = ReflectUtil.getPropertyDescriptor(bean.getClass(), property);
        try {
            if (pd != null) {
                Method m = pd.getReadMethod();
                if (m != null) {
                    m = ReflectUtil.findAccessibleMethod(m);
                    return m.invoke(bean, new Object[0]);
                }
                throw new EvaluationException("Could not read write-only property '" + property + "' on bean of type " + bean.getClass().getName());
            }
            Field field = ReflectUtil.getField(bean.getClass(), property);
            if (field != null) {
                return field.get(bean);
            }
            throw new NoSuchPropertyException("Bean class " + bean.getClass().getName() + " does not contain a property called '" + property + "'.");
        }
        catch (EvaluationException ee) {
            throw ee;
        }
        catch (Exception e) {
            throw new EvaluationException("Could not read value of property '" + property + "' on bean of type " + bean.getClass().getName() + " due to an exception.", e);
        }
    }

    @Override
    public void setValue(NodeEvaluation evaluation, Object bean, Object value) {
        block6: {
            String property = evaluation.getNode().getStringValue();
            PropertyDescriptor pd = ReflectUtil.getPropertyDescriptor(bean.getClass(), property);
            try {
                if (pd != null) {
                    Method m = pd.getWriteMethod();
                    if (m != null) {
                        m = ReflectUtil.findAccessibleMethod(m);
                        m.invoke(bean, value);
                        break block6;
                    }
                    throw new EvaluationException("Could not write read-only property '" + property + "' on bean of type " + bean.getClass().getName());
                }
                Field field = ReflectUtil.getField(bean.getClass(), property);
                if (field != null) {
                    field.set(bean, value);
                    break block6;
                }
                throw new NoSuchPropertyException("Bean class " + bean.getClass().getName() + " does not contain a property called '" + property + "'.");
            }
            catch (EvaluationException ee) {
                throw ee;
            }
            catch (Exception e) {
                throw new EvaluationException("Could not write value of property '" + property + "' on bean of type " + bean.getClass().getName() + " due to an exception.", e);
            }
        }
    }
}

