import socket
from unittest import TestCase
from juju.lib.port import get_open_port


class OpenPortTest(TestCase):

    def test_get_open_port(self):
        port = get_open_port()
        self.assertTrue(isinstance(port, int))

        sock = socket.socket(
            socket.AF_INET, socket.SOCK_STREAM, socket.IPPROTO_TCP)

        # would raise an error if we got it wrong.
        sock.bind(("127.0.0.1", port))
        sock.listen(1)
        sock.close()
        del sock

    def test_get_open_port_with_host(self):
        port = get_open_port("localhost")
        self.assertTrue(isinstance(port, int))

        sock = socket.socket(
            socket.AF_INET, socket.SOCK_STREAM, socket.IPPROTO_TCP)

        # would raise an error if we got it wrong.
        sock.bind(("127.0.0.1", port))
        sock.listen(1)
        sock.close()
        del sock
