package latexDraw.ui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;

import javax.swing.JProgressBar;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

import latexDraw.ui.components.DisplayCanvas;
import latexDraw.ui.dialog.ExceptionFrameDialog;

/** 
 * This class defines a splash screen displayed during the start of the program with a progress
 * bar showing us the progression of the loading of the LaTeXDraw interface.<br>
 *<br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE.  See the GNU General Public License for more details.<br>
 *<br>
 * 09/13/06<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 * @since 1.9<br>
 */
public class SplashScreen extends JWindow
{
	private static final long serialVersionUID = 1L;

	/** The progress bar showing us the progression of the loading of the LaTeXDraw interface.*/
	JProgressBar progressBar;
	
	
	/**
	 * The constructor by default.
	 * @param lookAndFeel the class of the look and feel; default LaF if null.
	 */
	public SplashScreen(String lookAndFeel)
	{
		try
		{
			try
			{
				if(lookAndFeel==null)
					UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
				else
					UIManager.setLookAndFeel(lookAndFeel);
			}catch(Exception ex)
			{/* Tant pis ! */}
			
			Dimension dim 	= Toolkit.getDefaultToolkit().getScreenSize();
			progressBar 	= new JProgressBar(0, 100);
			Image i 		= Toolkit.getDefaultToolkit().getImage(
							  getClass().getClassLoader().getResource("res/LaTeXDrawSmall.png"));//$NON-NLS-1$
			MediaTracker tracker=new MediaTracker(this);
			tracker.addImage(i,0);
			
			try { tracker.waitForID(0); } 
			catch(InterruptedException e) { e.printStackTrace(); }
			
			setLayout(new BorderLayout());
			getContentPane().add(new DisplayCanvas(i), BorderLayout.CENTER);
			getContentPane().add(progressBar, BorderLayout.SOUTH);
			setLocation((dim.width-i.getWidth(null))/2, (dim.height-i.getHeight(null))/2);
			setSize(i.getWidth(null), i.getHeight(null)+15);
			
		}catch(Exception e)
		{
			e.printStackTrace();
			ExceptionFrameDialog.showExceptionDialog(e);
		}
	}

	
	
	/**
	 * Increment the progress bar.
	 * @param increment The value to add to the progress bar.
	 */
	public void addToProgressBar(int increment)
	{
		final int cpt = progressBar.getValue()+increment;
		
		if(cpt>=progressBar.getMinimum() && cpt<=progressBar.getMaximum())
			try
			{
				SwingUtilities.invokeAndWait(new Runnable() { public void run() {updateBar(cpt);} });
			} catch(Exception e)
			{
				e.printStackTrace();
				ExceptionFrameDialog.showExceptionDialog(e);
			}
	}
	
	
	
	
	/**
	 * Allows to update the progress bar.
	 * @param newValue its new value.
	 */
	protected synchronized void updateBar(int newValue) 
	{
		progressBar.setValue(newValue);
	}
}
