/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <corelinux/Common.hpp>
#endif

#if   !defined(__EVENTCONTEXT_HPP)
#include <EventContext.hpp>
#endif

using namespace corelinux;

// Default assertion

EventContext::EventContext( void )
   throw ( Assertion )
   : 
   ThreadContext()
{
   NEVER_GET_HERE;
}

// Reasonable constructor

EventContext::EventContext
    ( 
        ArgumentFunctionPtr aFunction, 
        EventSemaphoreGroupPtr arg 
    )
    throw ( Assertion )
    :
    ThreadContext( CallerFunctionPtr(aFunction) ),
    theSemaphoreGroup( arg )
{
   REQUIRE( theSemaphoreGroup != NULLPTR );
   ThreadContext::setFrameFunction( argumentFrame );
   ThreadContext::setContextFunctions
      ( 
         argumentContextCreate, 
         argumentContextDestroy 
      );
}

// Reasonable constructor with stack

EventContext::EventContext
   ( 
      ArgumentFunctionPtr       aFunction, 
      Size                      stackSize,
      EventSemaphoreGroupPtr    arg 
   )
   throw ( Assertion )
   :
   ThreadContext( CallerFunctionPtr(aFunction), stackSize ),
   theSemaphoreGroup( arg )
{
   REQUIRE( theSemaphoreGroup != NULLPTR );
   ThreadContext::setFrameFunction( argumentFrame );
   ThreadContext::setContextFunctions
      ( 
         argumentContextCreate, 
         argumentContextDestroy 
      );
}

// Copy constructor

EventContext::EventContext( EventContextCref aContext )
   throw ( Assertion )
   :
   ThreadContext( aContext ),
   theSemaphoreGroup( aContext.getArgument() )
{
   ;  // do nothing
}

// Destructor

EventContext::~EventContext( void )
{
   ;  // do nothing
}

// Assignment operator

EventContextRef   EventContext::operator=
   ( 
      EventContextCref aContext 
   )
   throw ( Assertion )
{
   ThreadContext::operator==(aContext);
   setArgument( aContext.getArgument() );
   return ( *this );
}

// Equality operator

bool  EventContext::operator==( EventContextCref aContext ) const
{
   return ThreadContext::operator==(aContext);
}

// Get the argument

EventSemaphoreGroupPtr EventContext::getArgument( void ) const
{
   return theSemaphoreGroup;
}

ArgumentFunctionPtr  EventContext::getArgumentFunction( void )
{
   return ArgumentFunctionPtr( ThreadContext::getCallerFunction() );
}

// Set the argument

void EventContext::setArgument( EventSemaphoreGroupPtr arg )
{
   theSemaphoreGroup = arg;
}

// Factory method redirect to insure we create a ArgumentContext object

ThreadContextPtr  EventContext::argumentContextCreate
   ( 
      ThreadContextRef aContext 
   )
{
   EventContextPtr   aContextPtr( NULLPTR );

   aContextPtr = new EventContext
      ( 
         dynamic_cast<EventContextRef>(aContext) 
      );

   return aContextPtr;
}

// Factory method redirect to insure we destroy a ArgumentContext object

void  EventContext::argumentContextDestroy( ThreadContextPtr aContext )
{
   EventContextPtr   myArg( NULLPTR );

   myArg = dynamic_cast<EventContextPtr>(aContext);
   if( myArg != NULLPTR )
   {
      delete myArg;
   }
   else
   {
      ; // TBD
   }

}

// Our thread frame which allows us to call the single argument method

Int   EventContext::argumentFrame( ThreadContextPtr aContext )
{
   EventContextPtr   aEventContext
      ( 
         dynamic_cast<EventContextPtr>(aContext) 
      );


   return (aEventContext->getArgumentFunction())(aEventContext->getArgument());
}

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.2 $
   $Date: 2000/09/10 04:37:32 $
   $Locker:  $
*/

