/**
 *    Copyright 2011 Peter Murray-Rust
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */
package org.xmlcml.stml.interfacex;

import org.xmlcml.stml.STMLAttribute;



/**
 * attached to elements that can carry dictRef. 
 * examples are scalar, array, matrix, property
 * 
 * @author pmr
 * 
 */
public interface HasDictRef {

//    /**
//     * sets value on dictRef attribute. 
//     * example: setDictRef("myRef", "floop");
//     * 
//     * @param prefix
//     * @param idRef
//     * @param namespaceURI
//     */
//    void setDictRef(String prefix, String idRef, String namespaceURI);

    /** get dictRef attribute.
     * 
     * @return attribute (must be STMLAttribute to be compatible with autogenerated code)
     */
    STMLAttribute getDictRefAttribute();

    /** get dictRef value.
     * 
     * @return value
     */
    String getDictRef();


    /** set dictRef value.
     * 
     * @return value
     */
    void setDictRef(String dictRef);

}