/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the libgltf project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#ifndef APITEST_H_INCLUDED
#define APITEST_H_INCLUDED

#include <cppunit/TestFixture.h>
#include <cppunit/extensions/HelperMacros.h>

#include <libgltf.h>

#define DUCK_FILE_NAME "../data/duck_model/duck.json"

namespace libgltf { namespace test
{

class APITest : public CPPUNIT_NS::TestFixture
{
private:
    CPPUNIT_TEST_SUITE(APITest);
    CPPUNIT_TEST(test_gltf_renderer_init);
    CPPUNIT_TEST(test_gltf_renderer_set_content);
    CPPUNIT_TEST(test_gltf_get_camera_pos);
    CPPUNIT_TEST(test_gltf_enable_disable_rotation);
    CPPUNIT_TEST(test_gltf_get_model_center_pos);
    CPPUNIT_TEST(test_gltf_get_model_size);
    CPPUNIT_TEST(test_gltf_renderer_move_camera);
    CPPUNIT_TEST_SUITE_END();

private:

    void test_gltf_renderer_init();
    void test_gltf_renderer_set_content();
    void test_gltf_get_camera_pos();
    void test_gltf_enable_disable_rotation();
    void test_gltf_get_model_center_pos();
    void test_gltf_get_model_size();
    void test_gltf_renderer_move_camera();

    // Helper methods
    glTFHandle* parseJsonAndLoadInputFiles(std::vector<glTFFile>& vInputFiles, const std::string& sFilename = DUCK_FILE_NAME);
    glTFHandle* initSceneAndSetContent(const std::string& sFilename = DUCK_FILE_NAME);

    void readInputFiles(std::vector<glTFFile>& vInputFiles, const std::string& sJsonName);
    void releaseInputFiles(std::vector<glTFFile>& vInputFiles);
};

} // test
} // libgltf

#endif // APITEST_H_INCLUDED

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
